/*
 * This is the one thing we need to include in web2c.c as well as
 * in other modules which include web2c.h.
 */

struct sym_entry {
  char *id;	/* points to the identifier */
  int typ;	/* token type */
  int next;	/* next symbol entry */
  long val;	/* constant : value
		   subrange type : lower bound */
  long upper; 	/* subrange type : upper bound
		   variable, type or field : type length */
  int val_sym, upper_sym;	/* Sym table entries of symbols for lower
				   and upper bounds. On a function: point to
				   first and last formals.
				 */
  char *arg_typ;               /* If a var id was defined by a type-id, this points 
				 to the type-id. On a field of a with record, points 
				 to the record variable. In both cases, points into
				 STRINGS. Point at "vvoid" if no id was given. */
  int top_type, sub_type ;   /* Try to specify types of var. or type or field*/
  boolean var_formal;	/*TRUE if this is a formal parameter by reference
			 or a FORWARD proc.*/
  boolean need_var;
  		      /* TRUE this is a formal parameter and must be passed by pointer
			 */
};

