
#define FLIVER1	1

/*
 *  TEX Device Driver  ver 2.02-
 *  copyright(c) 1988, 1989 by TSG, 1990-93 by SHIMA
 *  1990 changed by M.Watanabe
 *  1991 changed by hideki
 *  1991 changed by T.Minagawa
 *
 *  flifont.h : module to handle FLI font library
 *
 *  Feb.  7, 1993 : 2nd edition   by H.Yoshizaki
 *  Jul.  4, 1993 : 3rd edition   by H.Yoshizaki
 */

/***********************************************
Structure of emTeX's font-library (.fli)

byte order
	<ver.1>		little endian
	<ver.2>		big    endian

Header
	identifier				4		"FLIB"
	version					1
	dummy					1
	directory length		2
	num. of size directory	2
	num. of fonts			2
	length of comment		2
	comment					?

Size
< ver 1 >
	directory length		2
	dpi						2		dpi * 5
	num. of font directory	2

< ver 2 >
	directory length		2
	num. of fonts			2
	dpi						4		ffff.ffff

Font
	font length				4
	font position			4
	length of font name		1
	font name				?

***********************************************/

struct HDR {
	struct HDR *next;
	struct SIZ *size;
#if	FLIVER1
	char version;
#endif
	char name[1];
};

struct SIZ {
	struct SIZ *next;
	struct FNT *font;
	short dpi;
};

struct FNT {
	struct FNT *next;
	long fontlen;
	long fontpos;
	char name[1];
};

struct FNT *search_fli(char *filename, char *fontname, int dpi);
void free_fli(void);
