// Copyright (c) 1991 by Parag Patel.  All Rights Reserved.
// $Header: dev.h,v 1.17 91/02/22 15:59:17 hmgr Exp $

// Base device class definition.  Specific devices should derive a
// class from this base class, and overload every virtual function.
//
// by Parag Patel


class font;
class fontchar;

class Device
{
public: 
    const int maxfonts;
    const int maxchars;
    const int maxonpage;
    const int maxloaded;
    const int resolution;
    const int hoff;
    const int voff;
    const int fhmin;
    const int fhmax;
    const int fvmin;
    const int fvmax;
    const int fwidth;
    const int fheight;
    char *deffontpath;

protected: 
    // a Device may only be created by a derived class and is never
    // directly used
    Device(int maxf, int maxc, int maxpg, int maxld, int res,
	int ho, int vo, int fhmn, int fhmx, int fvmn, int fvmx,
	int fwd, int fhg, char *deffp);

public:
    virtual ~Device();

    //virtual void color(long red, long green, long blue);

    // the following are pure virtual functions and MUST be overridden
    // by a derived class since the are NOT defined
    //
    virtual const char *char2dev(int ch, int &len) = 0;
    virtual long sp2dev(double sp) = 0;
    virtual double dev2sp(long pix) = 0;
    virtual void newpage(boolean odd, boolean first) = 0;
    virtual void downchar(font & f, fontchar & g, int ch) = 0;
    virtual void bigchar(font & f, fontchar & g, int ch) = 0;
    virtual void movehv(long h, long v) = 0;
    virtual void moveh(long n) = 0;
    virtual void movev(long n) = 0;
    virtual void push() = 0;
    virtual void pop() = 0;
    virtual void delfont(font & f) = 0;
    virtual void newfont(font & f) = 0;
    virtual void usefont(font & f) = 0;
    virtual void rule(double v, double h) = 0;
};


// The following macros are for backward compatibility with the older
// code in this program.  It was originally C code that was upgraded to
// C++.  Since there may only be a single "device" per invocation,
// there's little need to change all the old code.  Yet.

extern Device *device;

#define MAXFONTS	device->maxfonts
#define MAXCHARS	device->maxchars

#define MAXONPAGE	device->maxonpage
#define MAXLOADED	device->maxloaded

#define RESOLUTION	device->resolution

#define HOFF		device->hoff
#define VOFF		device->voff

#define FHMIN		device->fhmin
#define FHMAX		device->fhmax
#define FVMIN		device->fvmin
#define FVMAX		device->fvmax
#define FWIDTH		device->fwidth
#define FHEIGHT		device->fheight

#define DEFFONTPATH	device->deffontpath

#define dev_char2dev	device->char2dev
#define dev_sp2dev	device->sp2dev
#define dev_dev2sp	device->dev2sp
#define dev_newpage	device->newpage
#define dev_downchar	device->downchar
#define dev_bigchar	device->bigchar
#define dev_movehv	device->movehv
#define dev_moveh	device->moveh
#define dev_movev	device->movev
#define dev_push	device->push
#define dev_pop		device->pop
#define dev_delfont	device->delfont
#define dev_newfont	device->newfont
#define dev_usefont	device->usefont
#define dev_rule	device->rule
#define dev_color	device->color
