/*
 *	The internal structure for holding a definition for one
 *	character from a font.
 *
 *	IMPORTANT NOTE: There are static initializations for the
 *	Font_Definition data structure in file TKPASTE.C that must
 *	be changed whenever the structure definition is changed.
 */

#define CHARS_PER_FONT 256

struct Char_Definition {
	unsigned long Driver_Id;	/* Device driver identifier; 0 if not resident */
	         long DVI_Width;	/* Width in same units as DVI file */
	         long H_Escapement;	/* Horizontal displacement in 1/1024 pixels */
	         long V_Escapement;	/* Vertical displacement in 1/1024 pixels */
	unsigned long Character_Code;	/* Character code value */
	unsigned short Pixel_Width;	/* bit-width of character */
	unsigned short Pixel_Height;	/* bit-height of character */
	         short X_Origin;	/* X offset to origin */
	         short Y_Origin;	/* Y offset to origin */
	unsigned char *Pixel_Array;	/* Pixel specification (consists of
					   Height * ((Width + 7) / 8) bytes) */
};

/*
 *	The structure to describe an encoding vector:
 */

struct Encoding {
	unsigned long *Encoding_Map;
	unsigned long Encoding_Length;
	unsigned long Undef_Code;
};

/*
 *	The internal structure for holding a font definition:
 */

struct Font_Definition {
	struct Font_Definition *Link;	/* Pointer to next one */
	struct Char_Definition **Font_Directory; /* Ptr to char defn's array */
	struct Encoding *Font_Encoding;	/* 0: TeX font; non-zero: Native font */
	char *Area_Ptr;			/* Pointer to Area name string */
	char *Name_Ptr;			/* Pointer to Font name string */
	long Font_Number;		/* Number by which it is referenced
					   (negative => mirror image font) */
	unsigned long Pixel_Id;		/* Pixel format id number */
#define ID_TFM      0
#define ID_PXL      1
#define ID_PK       2
#define ID_GF       3
#define ID_INTERNAL 4
#define ID_V_TYPE   29
#define ID_M_FORMAT 0x1FFFFFFF
	unsigned long Checksum;		/* Checksum from TFM/PXL/PK/GF file */
	fix_word Font_Design_Size;	/* Design size from TFM/PXL/PK/GF file */
	unsigned long Design_Size;	/* The font's design size (DVI units) */
	unsigned long At_Size;		/* The font's "at" size (DVI units) */
	unsigned long Magnification;	/* The font's magnification */
	unsigned long Max_Packed;	/* Maximum height*(width+7)/8 */
	unsigned long Max_Unpacked;	/* Maximum width * height */
	unsigned long Max_Compressed;	/* Maximum compressed size */
	unsigned int Font_Index;	/* Array index for font */
	unsigned int Char_Dir_Count;	/* Size of Font_Directory array */
	unsigned short Max_Width;	/* Maximum width */
	unsigned short Max_Height;	/* Maximum height */
	char Font_Coding[40];		/* Coding Scheme (TFM only) */
	char Font_Family[20];		/* Font Family name (TFM only) */
	unsigned char Font_Face;	/* Face style code (TFM only) */
	unsigned char Flags;		/* Various flags */
#define NATIVE_FONT 0x01
#define MIRROR_FONT 0x02
#define MARK_FONT   0x04
#define TEMP_FONT   0x08
#define DOWNLOADED  0x80
	char Name[];			/* Area and Font strings */
};

/*
 *	Define the pointer to the list of (dynamically allocated) font
 *	definitions, and how many; also define variables to record the
 *	number of characters and maximum size of characters in the DVI
 *	File:
 */

struct Font_Definition *Font_Def_Head;	/* Head of font definition list */
unsigned long Font_Count;		/* Number of fonts this run */
unsigned long Char_Count;		/* Number of different characters */
unsigned long Undef_Char_Count;		/* Number of used but not defined characters */
unsigned long Max_Char_Size;		/* Maximum width X height, in pixels */
unsigned long Mark_Font_Number;		/* Font number of MARK font */
unsigned long Max_Font_Number;		/* Maximum font number used */

/*
 *	Two scratch arrays used by the load procedures:
 */

unsigned char Char_Mask[CHARS_PER_FONT];/* Indicates if character seen */
unsigned long Char_Addr[CHARS_PER_FONT];/* Address in raster file */
