/* Fast I/O macros (but must check for feof by hand afterwards) */

#define fGetWord(fp,r)  ((r)  = getc (fp) << 8,  (r) |= getc (fp))
#define fGet3Byte(fp,r) ((r)  = getc (fp) << 16, (r) |= getc (fp) << 8, \
			 (r) |= getc (fp))
#define fGetLong(fp,r)  ((r)  = getc (fp) << 24, (r) |= getc (fp) << 16, \
			 (r) |= getc (fp) << 8,  (r) |= getc (fp))

/* Fast I/O write (and regular write) macros */
#define PutWord(fp,r)  (putc ((r) >> 8,  fp), putc ((r), fp))
#define Put3Byte(fp,r) (putc ((r) >> 16, fp), putc ((r) >> 8, fp), \
			putc ((r), fp))
#define PutLong(fp,r)  (putc ((r) >> 24, fp), putc ((r) >> 16, fp), \
			putc ((r) >> 8, fp),  putc ((r), fp))
