/* PXL file format */

/* Note:  PXL files are stored in the opposite of VAX byte order, which
   means each group of 4 bytes must be reversed before using the info. */

#define PXLID 1001		/* PXL file ID number */
#define PKID ((247<<8)+89)	/* PK preamble, v. 89 */

#define FONT_SLOP 5		/* how much "slop" from the given
				   magnification is permitted when looking
				   for a font (e.g., if the computed size
				   is 999, will try up to 999 +- FONT_SLOP,
				   until something is found) */

/* chinfo is called the "font directory" by the PXL file description, but I
   think that "character info" is a more accurate description.  Each group of
   4 "words" is one of these things, and there are 128 such groups, one for
   each character.

   Note that for empty characters ch_un.un_rastoff will be zero.

   The "#if vax" is for vax-dependent byte order stuff (I know, it's ugly).
 */
struct chinfo {
#if vax || ns32000		/* little-endian order */
    short   ch_height;
    short   ch_width;
    short   ch_yoffset;
    short   ch_xoffset;
#else				/* big-endian order */
    short   ch_width;		/* character width */
    short   ch_height;		/* character height */
    short   ch_xoffset;		/* X offset of ref point */
    short   ch_yoffset;		/* Y offset of ref point */
#endif
    union {
	int     un_rastoff;	/* raster offset from word 0 */
	unsigned long *un_raster; /* pointer to actual raster */
    }               ch_un;
    int     ch_TFMwidth;	/* TFM width (in FIXes) */
};
/* shorthand */
#define ch_rastoff ch_un.un_rastoff
#define ch_raster  ch_un.un_raster

typedef enum {NOFMT, BADFMT, PXLFMT, PKFMT, ROMFMT, TFMFMT} FONT_FORMAT;

/* The end of the PXL file looks like this */
struct pxltail {
    int     px_checksum;	/* checksum */
    int     px_magnification;	/* magnification factor */
    int     px_designsize;	/* font design size (FIXes) */
    int     px_dirpointer;	/* pointer to font directory */
    int     px_pxlid;		/* pxlid, should be == PXLID */
    char   *px_filename;	/* actual filename */
    FONT_FORMAT px_fmt;		/* PXLFMT, PKFMT, TFMFMT */
    struct chinfo px_info[256];	/* "font directory" info */
};

/* Function types */
struct pxltail *read_font ();
char *fontname ();
extern char errstr[];
extern double reconcile_scale (double scale);
