/*
 * Decompiled with CFR 0.152.
 */
package de.nm.file;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class CsvReader
implements Closeable {
    private static final int BUFFERSIZE = 65535;
    public static final char ESCAPE = '\\';
    public static final char QUOTECHAR = '\"';
    public static final char SEPARATOR = ',';
    private boolean firstRead = true;
    private final BufferedReader in;
    private int minElements = -1;
    private String nextLine = null;
    private boolean open = true;
    private final char quotechar;
    private final char separator;

    public CsvReader(File file, Charset encoding) throws IOException {
        this(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding)));
    }

    public CsvReader(File file, Charset encoding, char separator, char quotechar, int minElements) throws IOException {
        this(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding)), separator, quotechar, minElements);
    }

    public CsvReader(InputStream stream, Charset encoding) {
        this(stream, encoding, ',', '\"', -1);
    }

    public CsvReader(InputStream stream, Charset encoding, char separator, char quotechar, int minElements) {
        this(new BufferedReader(new InputStreamReader(stream, encoding)), separator, quotechar, minElements);
    }

    public CsvReader(Reader reader) {
        this(reader, ',', '\"');
    }

    public CsvReader(Reader reader, char separator) {
        this(reader, separator, '\"');
    }

    public CsvReader(Reader reader, char separator, char quotechar) {
        this(reader, separator, quotechar, -1);
    }

    public CsvReader(Reader reader, char separator, char quotechar, int minElements) {
        this.in = new BufferedReader(reader, 65535);
        this.separator = separator;
        this.quotechar = quotechar;
        this.minElements = minElements;
    }

    public CsvReader(String line, char separator, char quotechar, int minElements) {
        this(new StringReader(line), separator, quotechar, minElements);
    }

    public CsvReader(String file, Charset encoding) throws IOException {
        this(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding)));
    }

    public CsvReader(String file, Charset encoding, char separator, char quotechar, int minElements) throws IOException {
        this(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding)), separator, quotechar, minElements);
    }

    @Override
    public void close() throws IOException {
        this.open = false;
        this.in.close();
    }

    private void firstRead() throws IOException {
        if (this.firstRead) {
            this.nextLine = this.in.readLine();
            this.firstRead = false;
        }
    }

    public boolean hasNext() throws IOException {
        boolean noteof;
        if (!this.open) {
            return false;
        }
        this.firstRead();
        boolean bl = noteof = this.nextLine != null && this.nextLine.trim().length() != 0;
        if (!noteof) {
            this.close();
        }
        return noteof;
    }

    public String[] next() throws IOException {
        if (this.open) {
            return this.parseLine();
        }
        throw new IOException("File is closed!");
    }

    private String[] parseLine() throws IOException {
        ArrayList<String> elements = new ArrayList<String>();
        this.firstRead();
        if (this.hasNext()) {
            String line = this.nextLine;
            this.nextLine = this.in.readLine();
            boolean escape = false;
            boolean string = false;
            StringBuilder val = new StringBuilder();
            int i = 0;
            int n = line.length();
            while (i < n) {
                char ch = line.charAt(i);
                if (escape) {
                    escape = false;
                    if (i + 1 >= line.length()) {
                        throw new IOException("EOL using escape character");
                    }
                    if (ch == this.quotechar) {
                        val.append(this.quotechar);
                    } else {
                        val.append('\\');
                        val.append(ch);
                    }
                } else if (!string && ch == this.quotechar) {
                    string = true;
                } else if (string && ch == '\\') {
                    escape = true;
                } else if (string && ch == this.quotechar) {
                    string = false;
                } else if (string) {
                    val.append(ch);
                } else if (ch == this.separator) {
                    elements.add(val.toString().trim());
                    val = new StringBuilder();
                } else {
                    val.append(ch);
                }
                ++i;
            }
            if (val.length() > 0) {
                elements.add(val.toString().trim());
            }
        }
        if (this.minElements > elements.size()) {
            int d = this.minElements - elements.size();
            int i = 0;
            while (i < d) {
                elements.add("");
                ++i;
            }
        }
        return elements.toArray(new String[elements.size()]);
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> liste = new ArrayList<String[]>();
        while (this.hasNext()) {
            liste.add(this.next());
        }
        return liste;
    }

    public static synchronized String[] removeEmptyEntries(String[] entries) {
        LinkedList<String> liste = new LinkedList<String>();
        String[] stringArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && s.length() > 0) {
                liste.add(s);
            }
            ++n2;
        }
        String[] newentries = new String[liste.size()];
        newentries = liste.toArray(newentries);
        return newentries;
    }
}

