{$N-,E-,B-,V-,M 45000,0,655360}
{$F+,O+}
program bibdb;

{
  Database program for BIBTEX databases.
  Created by Eyal Doron.
  Ver. 2.0.
}

Uses
  clearmem,   { initialize all memory to a known value }
  {stackuse,} {report stack usage at exit time}
  overlay, objects,
  bibwindo, Dos, bibstrm, bibCrt, bibstrg, BibMouse, bibcheck, lfnunit,
  bibvars, bibfile, bibdisp, bib8bit, bibutil, bibsedit, bibedit, bibselct,
  bibinit2, bibinit, bibpchec, bibSrtPt, bibprint, bibshow, bibedent,
  bibreadB, BibReadT, BibreadD, bibwritB, bibWritO, bibfilch, bibdialg,
  biblist, bibsave, bibmain, bibbrows, bibflch2, bibadd, bibedsrt, bibcache,
  bibgoto, bibmisc, bibsort;

{$IFNDEF noover}

{$O bibinit2}
{$O bibinit}
{$O bibcheck}
{$O bibdialg}
{$O bibreadB}
{$O bibreadT}
{$O bibwritB}
{$O bibprint}
{$O bibwritO}
{$O bibsrtpt}
{$O bibsort}
{$O bibfilch}
{$O bibflch2}
{$O bibadd}
{$O biblist}
{$O bibsave}
{$O bibedsrt}
{$O bibgoto}
{$O bibinout}
{$O bibmisc}
{$O bibmain}
{$O bibedit}
{$O bibbrows}

{$ENDIF}

Var
  Dir,Name,Ext,OvrName: string;
  Pattern: PatRecPtr;

{$I comptime.inc}

begin                              { Main }

  CompTime;
{$IFNDEF noover}

  OvrName:=Fexpand(LFNShortName(ParamStr(0)));
  {
  Fsplit(Fexpand(LFNShortName(ParamStr(0))),Dir,Name,Ext);
  OvrName:=Dir+Name+'.OVR';
  if not FileExist(OvrName) then OvrName:=Dir+Name+'.EXE';
  }
  OvrInit(OvrName);
  if OvrResult<>0 then
  begin
    writeln;
    if OvrResult=-1 then writeln('Overlay Manager error!')
    else if OvrResult=-2 then writeln('Can''t find overlay file!')
    else if OvrResult=-3 then writeln('Not enough memory for overlay buffer!')
    else if OvrResult=-4 then writeln('Overlay file IO error!')
    else if OvrResult=-5 then writeln('EMS driver not installed!')
    else if OvrResult=-6 then writeln('Not enough EMS memory for overlay!')
    else writeln('Overlay error ',OvrResult,'!');
    Halt(255);
  end;
  {
  OvrSetBuf(OvrGetBuf+$2000);
  if OvrResult<>0 then
  begin
    writeln;
    if OvrResult=-1 then writeln('Overlay Manager error!')
    else if OvrResult=-2 then writeln('Can''t find overlay file!')
    else if OvrResult=-3 then writeln('Not enough memory for overlay buffer!')
    else if OvrResult=-4 then writeln('Overlay file IO error!')
    else if OvrResult=-5 then writeln('EMS driver not installed!')
    else if OvrResult=-6 then writeln('Not enough EMS memory for overlay!')
    else writeln('Overlay error ',OvrResult,'!');
    Halt(255);
  end;
  }

{$ENDIF}

  Pattern:=Nil;
  InitDb(Pattern);

  { File handles }

  if MaxFileHandles<>15 then
  begin
    if SetHandleCount(MaxFileHandles)<MaxFileHandles then
      FatalError(' Can''t open enough files. Increase FILES= in CONFIG.SYS! ');
  end;

  Browse(pattern);
  
  if SaveOptsOnExit then
    SaveConfigOptions(OptionsModified.Preferences,
                      OptionsModified.Registers,
                      OptionsModified.Sort,
                      OptionsModified.Formats,
                      false);
  
end.
