/* Copyright Phil Andrews 1987 */

/* include files */
#include <stdio.h>
#include <ctype.h>
#include <math.h>
double atan();	/* not in some math.h */
#include "defs.h"
#define version_str "4.23"
char *allocate_mem(), *realloc();

/* GPLOT style globals */
static struct info_struct dev_info;
static struct one_opt opt[opt_size];

/* one local set of function pointers */
static int (*gtex_calls[Gtex_Size])();

/* and now the arrays of function pointer, filled in externally by the
   device initialisation routine */
static int (*delim[Delim_Size])();	/* delimiter functions */
static int (*mfdesc[MfDesc_Size])();	/* metafile descriptor functions */
static int (*pdesc[PDesc_Size])();	/* page descriptor functions */
static int (*mfctrl[Control_Size])();	/* mf control functions */
static int (*gprim[GPrim_Size])();	/* graphical primitives */
static int (*attr[Att_Size])();	/* the attribute functions */
static int (*escfun[Esc_Size])();	/* the escape functions */
static int (*extfun[Ext_Size])();	/* the external functions */
static int (*ctrl[Delim_Size])();	/* external controller functions */
/* some macros */

#define true 1
#define false 0
#define esc	'\033'	/* prefix character */
#define max_str 128
/* now to handle device-dependent calls */

/* bit masks */
#define ls3 7	
/* 3 least significant bits */

/* numbers */
#define shift8 256
#define shift16  0200000
#define shift20 04000000
#define byte_size 8

/* globals we don't want to bother passing around */

/* macros to get the x-y coordinates required, fix later */
#define newx(h,v) ((int)(hor_margin + pxl_from_sp(h))+ (0 * v))
#define newy(h,v) (y_pxl - ver_margin - (int) pxl_from_sp(v) + (0 * h))

static int y_pxl;	/* the biggest pixel number */

struct cgm_struct {	/* store cgm special commands */
  int el_id;	/* element id */
  int cmd_no;	/* which one this is (allow mutliple on page) */
  int no_pos;	/* how many entries */
  int pos;	/* which entry is this */
  int done;	/* how many done */
  int *x_ptr;	/* ptr to x array */
  int *y_ptr;	/* ptr to Y array */
};

#define no_cgm_specials 100	/* max no of such specials */
static struct cgm_struct cgm_specials[no_cgm_specials];

static double pi;
static int rot_page;
static int xsize, ysize;
/* a few globals */
static int 
  record_size,	/* record size of the file (RMS) */
  b_used, 	/* blocks used */
  b_allocated, 	/* blocks allocated */
  last_byte;	/* position in file of last byte */

#define amin(arg1, arg2) ( (arg1) < (arg2) ? (arg1) : (arg2) )
static unsigned char *dvi_ptr;
unsigned char *go_to();

char global_string[128];
/* handy definitions */
#define byte_size 8
#define word_size (sizeof(int) * byte_size)
#define not_found 1111
#define max_length 128


/* declare global variables, flags first */
int font_open = 0;	/* have we used any fonts ? */
#define r_none 0
#define r_all 1
#define r_page 2
#define r_fonts 3	
static int second_time = 0;
/* all of the options */
     static int deb; 	/* do debugging ? */
     static int pxl_per_in;	/* pixels per inch */
     static int hor_margin, ver_margin;	/* margins (in pxls) */
#define base_pxl_per_in 300
     static int max_drift = 1;	/* how many pixels we can drift horizontally */
     static int fix_drift = 1;	/* how fast to move back (except in an absolute positioning) */
     /* more globals */
     struct tbuffer {
       int proc_user_time;
       int proc_system_time;
       int child_user_time;
       int child_system_time;
     };
     static int xshift, yshift;	/* how much to shift page */
     static float ht_in, wd_in;
     static int pages_done;	/* how many pages processed */
     static unsigned num, den;
     static int mag, dvi_ver;
     static int max_ht, max_wd, max_stack, no_pages, pst_start;
     
     /* now define the font info array */
#define max_fonts 100
     struct font farray[max_fonts];
     
     /* now the page positions, sizes, counters and page stack */
#define no_counters 10
#define max_pages 1000
#define max_size_stack 1000
#define stack_elements 6
#define reg_ht 11.0
#define reg_wd 8.5
#define legal_ht 14.0
#define legal_wd 8.5
     
     int page[max_pages][no_counters+1];
     static int curr_font;	/* current font */
     static int fonts_declared;	/* no. of fonts declared */
     static int page_stack[max_size_stack][stack_elements];
     static int stack_ptr;
     static int h, v, w, x, y, z;	/* the stack variables */
     static int last_v;		/* so we know if we moved */
     static int actual_h_pxl;		/* where we really are on page */
     /* note that we are making the stack a global quantity */
     
     /* alpha-numeric shift */
     int	alph_shift = 'a' - 'A';
     
     /* define the standard dvi commands */
#define beg_char_set   0
#define end_char_set   127
#define set1 128
#define set2 129
#define set3 130
#define set4 131
#define set_rule_cmd 132
#define put1 133
#define put2 134
#define put3 135
#define put4 136
#define put_rule 137
#define nop 138
#define bop 139
#define eop 140
#define push 141
#define pop 142
#define right1 143
#define right2 144
#define right3 145
#define right4 146
#define w4 151
#define w3 150
#define w2 149
#define w1 148
#define w0 147
#define x4 156
#define x3 155
#define x2 154
#define x1 153
#define x0 152
#define down1 157
#define down2 158
#define down3 159
#define down4 160
#define y4 165
#define y3 164
#define y2 163
#define y1 162
#define y0 161
#define z4 170
#define z3 169
#define z2 168
#define z1 167
#define z0 166
#define beg_fnt_set   171
#define filler 223
#define end_fnt_set   234
#define fnt1 235
#define fnt2 236
#define fnt3 237
#define fnt4 238
#define xxx1 239
#define xxx2 240
#define xxx3 241
#define xxx4 242
#define fnt_def1 243
#define fnt_def2 244
#define fnt_def3 245
#define fnt_def4 246
#define preamble   247
#define pst 248
#define pst_pst   249
#define tex82_ver   2
     /* macros to avoid function calls */
     
#define pxl_from_sp(sp_meas) \
       (((( (float) sp_meas)*mag*pxl_per_in)/ (72270.0 * shift16) ) + 0.5 )
#define cpxl_from_sp(sp_meas) \
       (((( (float) sp_meas)*mag*pxl_per_in)/ (72270.0 * shift16) ) + 0.9999 )
     /* this for rules which have to round up */
     
     
     /* now the big locals, the structures which keep track of the CGM state */
     static struct 	mf_d_struct 	glbl1;	/* the class 1 elements */
     static struct 	pic_d_struct 	glbl2, dflt2;	/* the class 2 elements */
     static struct 	control_struct	glbl3, dflt3;	/* the class 3 elements */
     static struct 	attrib_struct	glbl5, dflt5;	/* the class 5 elements */
     
     main(argc, argv)
     int argc;
     char **argv;
{
  
  extern void s_defaults();		/* in utils.c */
  char cmd_line[max_str];	
  char in_fname[max_str], def_name[max_str], open_name[max_str], 
  full_name[max_str];
  int to_screen, do_list, cmd_len,i, have_fonts;
  
  	/* make initial values */
  initialise_time();
  pi = 4. * atan(1.0);
  in_fname[0] = def_name[0] = '\0';
  
#ifdef VMS
  strcpy(cmd_line, "GPT ");	/* our multi-purpose verb */
  cmd_len = strlen(cmd_line);	/* get the command line */
  if (!get_cmd_line(cmd_line + cmd_len, max_str - 1 - cmd_len, 0, NULL)){
    fprintf(stderr, "trouble getting command line !\n");
    exit(2);
  }
  
  /* check options */
  try_def_name(in_fname);	/* is there a default ? */
#endif
  /* check options */
  if (!parse_cline(cmd_line, argc, argv, &to_screen,
		   &do_list, &dev_info, opt)){
    fprintf(stderr, "incomplete/illegal command line !\n");
    exit(2);
  }
  deb = opt[(int) debug].set;
  /* now go ask the device what it thinks */
  dev_setup(opt, &dev_info, 
	    &glbl1, &glbl2, &glbl3, &glbl5, delim, mfdesc, pdesc, mfctrl, 
	    gprim, attr, escfun, extfun, ctrl, &argc, argv);	
  /* override the margins for TeX conformance */
  if (!opt[(int) x_offset].set && !opt[(int) y_offset].set) {
    dev_info.x_offset = 1.0;
    dev_info.y_offset = 1.0;
  }
  /* and come to a conclusion */
  consult_device(opt, &dev_info);
  pxl_per_in = dev_info.pxl_in;
  /* now see if we have gtex specific functions available */
  gtex_setup(opt, gtex_calls);

  
  if (!to_screen) fprintf(stderr, "GTEX %s\n", version_str);
  /* take care of the file names */
  
  if (opt[(int) in_name].set) 
    strncpy(in_fname, opt[(int) in_name].val.str, max_str);
  
  if (opt[(int) out_name].set) 
    strncpy(def_name, opt[(int) out_name].val.str, max_str);
  else {
#ifdef VMS
    strncpy(def_name, dev_info.out_name, max_str);
#endif
  }
  
  
  if (dvi_open(in_fname, ".dvi", open_name, &b_allocated, &b_used,
	       full_name, to_screen, &last_byte, &record_size)) {
    open_output_file(open_name, def_name, do_list, &dev_info);	
    if (to_screen) fprintf(stderr, "GTEX %s\n", version_str);
  } 
  else {
    fprintf(stderr, "\nGTEX %s couldn't open your file !\n", 
	    version_str);
    exit(2);
  }
  
  
  
  	/* check to see if we have any fonts */
  have_fonts = check_fdir(NULL);
  if (!have_fonts) {
    fprintf(stderr, "no fonts available !\n");
    exit(2);
  }
  /* set the defaults for the CGM modules */
  /* set up the initial defaults */
  s_defaults(&glbl1, &dflt2, &dflt3, &dflt5, &glbl5, 1.0);
  rs_defaults(&glbl1, &glbl2, &glbl3, &glbl5, &dflt2, &dflt3, &dflt5, 1.0);
  
  read_preamble();	/* read preamble and check format */
  read_postamble();
  /* try to be smart here */
  /* get the output device started */
  if (delim[(int) B_Mf]) (*delim[(int) B_Mf]) ("", full_name, 
					       strcat("GTEX ", version_str));
  if (ctrl[(int) B_Mf]) (*ctrl[(int) B_Mf]) ();	/* ctrl function */
  
  clear_flag();	/* clear the character used array */
  
  for (second_time = 0; second_time <= 1; ++second_time){
    if (second_time && have_fonts) load_fonts();
    pages_done = 0;
    for (i=0;i<no_pages;++i){
      if (want_page(page[i][0], opt[(int) pages].val.str)) {
	do_page(i);
	++pages_done;
      }
    }
  }
  
  
  /* close all of the files and clean up */
  close_dvi();
  if (delim[(int) E_Mf]) (*delim[(int) E_Mf])(pages_done);
  if (ctrl[(int) E_Mf]) (*ctrl[(int) E_Mf])();
  
  write_time(pages_done);    /* type out the time used */
  
  
  return(1);
}
/* this function clears the character flags (no characters used so far) */
clear_flag()
{
  int i, font_no;
  
  for (font_no = 0; font_no < max_fonts; font_no++){
    farray[font_no].used = 0;
    farray[font_no].loaded_once = 0;
    farray[font_no].read = 0;
    farray[font_no].found = 0;
    for (i=0; i < flag_no; i++) {
      farray[font_no].load_flag[i] = 0; 
      farray[font_no].want_flag[i] = 0; }
  }
  return(0);
}

read_preamble()
{
  int mem_size;
  unsigned k; 
  dvi_ptr = go_to(0, record_size);
  
  if ( *dvi_ptr++ != preamble) fprintf(stderr, "first byte incorrect: %d",*dvi_ptr);
  if ( (dvi_ver = *dvi_ptr++) != tex82_ver)
    fprintf(stderr, "\nincorrect version; %d", dvi_ver);
  num = read_dvi(4, false);
  den = read_dvi(4, false);
  mag = read_dvi(4, true);
  for (k = *dvi_ptr++; k > 0; --k) fputc(*dvi_ptr++, stderr);
  return(dvi_ver);
}
/* read in up to 4 consecutive bytes here, have to be careful, */
/* if has_sign is true then we allow negative values */
/* we assume that we won't run out of bytes to read */

read_dvi(no_bytes, has_sign)
     int no_bytes, has_sign;
{
#define SIGN_MASK (-1 ^ 255)
  unsigned int u_ret;
  int  ret, no_chars;
  
  if (has_sign) {
    ret = (*dvi_ptr & 128) ? SIGN_MASK | *dvi_ptr++ : *dvi_ptr++;
    for (no_chars = no_bytes; no_chars > 1; --no_chars) 
      ret = (ret << 8) | *dvi_ptr++;
    return(ret);
  } else {
    u_ret = *dvi_ptr++;
    for (no_chars = no_bytes; no_chars > 1; --no_chars) 
      u_ret = (u_ret << 8) | (*dvi_ptr++ & 255);
    return((int) u_ret);
  }
#undef SIGN_MASK
}
old_read_dvi(no_bytes, has_sign)
{
  unsigned result, first_byte;
  int i, ret;
  result = *dvi_ptr++;
  first_byte = result;
  for  (i=1;i<no_bytes;++i) result = (result<<byte_size) + *dvi_ptr++;
  
  /* now check for negative values, if so turn on high order bits */
  
  if ( has_sign && (first_byte > 127) )	/* meant to be negative */
    ret = result | ~0 << (no_bytes * byte_size); /* sneaky ! */
  else ret = (int) result;

  return(ret);
}


read_bytes(f_in, no_bytes, has_sign)
FILE *f_in;
{
  unsigned result, first_byte;
  int i;
  result = getc(f_in);
  first_byte = result;
  for  (i=1;i<no_bytes;++i) result = (result<<byte_size) + getc(f_in);
  
  /* now check for negative values, if so turn on high order bits */
  
  if ((first_byte > 127) && has_sign )	/* meant to be negative */
    result |=  ~0 << (no_bytes * byte_size); /* sneaky ! */
  
  return(result);
}

read_postamble()
{
  int i, j, a, l, cmd, num1, den1, mag1, lbop, no_zeros, mem_size, first_byte, 
  safety;
  unsigned char *start_ptr;
  float dev_ht, dev_wd;
  /* read in up to last two records */
  first_byte = b_used > 2 ? (b_used - 2) * record_size : 0;
  safety = last_byte - first_byte;
  start_ptr = dvi_ptr = go_to(first_byte, safety);
  dvi_ptr += safety - 1;	/* last byte in file */
  
  while (*dvi_ptr != filler) --dvi_ptr;	/* find filler */
  while( !( (*dvi_ptr == filler) && (*(dvi_ptr-1) == filler)
	   && (*(dvi_ptr-2) == filler) )
	&& (dvi_ptr > start_ptr) ) --dvi_ptr;
  while(*--dvi_ptr == filler) ;   /* back over fillers */
  
  if (*dvi_ptr != dvi_ver) 
    fprintf(stderr, "\nincompatible dvi_versions; %d, %d", *dvi_ptr, dvi_ver);
  
  dvi_ptr -= 5;
  if ( *dvi_ptr != pst_pst) 
    fprintf(stderr, "\nnot at pst_pst ! %d", *dvi_ptr);
  ++dvi_ptr;
  pst_start = read_dvi(4, false); 
  if (deb) fprintf(stderr, 
		   "\npst_start = %d, b_used = %d", 
		   pst_start, b_used);
  dvi_ptr = go_to(pst_start, last_byte - pst_start);
  
  if ( *dvi_ptr != pst) 
    fprintf(stderr, "\nnot at pst ! %d\n", *dvi_ptr);
  ++dvi_ptr;
  lbop = read_dvi(4, false); 
  if (num != (num1 = read_dvi(4, false)) )
    fprintf(stderr, "different num ! %d, %d\n", num, num1);
  if (den != (den1 = read_dvi(4, false)) )
    fprintf(stderr, "different den ! %d, %d\n", den, den1);
  if (mag != (mag1 = read_dvi(4, false)) )
    fprintf(stderr, "\ndifferent mag ! %d, %d\n", mag, mag1);
  
  /* now check for the page size and see if we want to rotate */
  
  max_ht = read_dvi(4, true);
  max_wd = read_dvi(4, true);
  
  hor_margin = dev_info.x_offset * pxl_per_in;	/* fix later */
  ver_margin = dev_info.y_offset * pxl_per_in;
  
  ht_in = (ver_margin + pxl_from_sp(max_ht) ) / pxl_per_in;
  wd_in = (hor_margin + pxl_from_sp(max_wd) ) / pxl_per_in;
  
  dev_ht = dev_info.y_size;
  dev_wd = dev_info.x_size;
  
  xshift = 0;
  yshift = 0;
  if ( (!opt[(int) degrees].set) 	/* didn't specify a rotation */
      && (!opt[(int) screen].set)	/* not to the screen */
      && (dev_info.capability & port_land)	/* can do it */
      && (    (   (wd_in > dev_wd)	/* wide image */
	       && (wd_in < dev_ht)	/* fits up */
	       && (ht_in < dev_wd))	/* this way too */
	  ||  (   (ht_in > dev_ht)	/* tall image */
	       &&	(ht_in < dev_wd)	/* fits up */
	       &&	(wd_in < dev_ht))	/* this way too */
	  )
      ) {
    opt[(int) degrees].val.r = 90.0;	/* rotate it for the user */
    opt[(int) degrees].set = 1;
  }
  
  rot_page = opt[(int) degrees].set && (opt[(int) degrees].val.r <91.0)
    && (opt[(int) degrees].val.r > 89.0);
  
  if (rot_page) {
    xsize = ht_in * pxl_per_in;
    ysize = wd_in * pxl_per_in;
  } else {
    xsize = wd_in * pxl_per_in;
    ysize = ht_in * pxl_per_in;
  }
  y_pxl = dev_info.y_size * pxl_per_in;
  
  /* check on more of the parameters */
  
  max_stack = read_dvi(2, false);
  no_pages = read_dvi(2, false);
  if (deb) fprintf(stderr, "\n");
#ifdef VMS
  fprintf(stderr, " (%d page%s in file, %d/%d blocks, mag = %d)\n", 
	  no_pages, (no_pages > 1) ? "s" : "", b_used, b_allocated, mag);
#else
  fprintf(stderr, " (%d page%s in file, %d blocks, mag = %d)\n", 
	  no_pages, (no_pages > 1) ? "s" : "", b_used, mag);
#endif
  if (max_stack > max_size_stack)
    fprintf(stderr, "max_stack(%d) too big\n", max_stack);
  	/* now read fonts */
  
  if (deb) fprintf(stderr, "\nreading font definitions");
  cmd = *dvi_ptr++;
  if ((cmd > fnt_def4) || (cmd < fnt_def1)) 
    /* fprintf(stderr, "no fonts ??") */ ;
  while ((cmd >= fnt_def1) && (cmd <= fnt_def4)) {
    process_font(fonts_declared = read_dvi(cmd-fnt_def1 + 1, false));
    cmd = *dvi_ptr++; 
  }
  
  
  /* now set up page array */
  
  if (deb) fprintf(stderr, "\nsetting up page array\n");
  cmd = lbop;	/* go to last page */
  if (no_pages > max_pages) fprintf(stderr, "too many pages!\n");
  i = no_pages;
  while (cmd >= 0) /* not run out of pages */ {
    dvi_ptr = go_to(cmd, amin(2 * 512, last_byte - cmd));
    if (bop != (j = *dvi_ptr++) )
      fprintf(stderr, "\nscrewed up page(%d) ptr = %d, cmd=%d,",i, cmd, j);
    --i;
    for (j=0; j<no_counters; ++j) page[i][j] = read_dvi(4, true);
    page[i][j] = cmd;
    cmd = read_dvi(4, true);	/* goto previous page */
  }
}

/* note that we might be passing thru this page either to check what 
     characters we need to down load, or to actually set the page */

do_page(page_no)
{
  int arg, cmd, i, arg1, arg2, bytes_needed, start_byte, setting, a, l;
  unsigned char *hold_place;
  
  start_byte = page[page_no][no_counters];
  bytes_needed = (page_no == no_pages - 1) ? pst_start - start_byte
    : page[page_no + 1][no_counters] - start_byte;
  
  hold_place = dvi_ptr = go_to(start_byte, bytes_needed);
  
  setting = second_time;	/* may have to change */
  if (setting) {
    fprintf(stderr, "[%d", page[page_no][0]);
    /* would like origin at the top for TeX */
    if (delim[(int) B_Pic_Body]) 
      (*delim[(int) B_Pic_Body])("", xshift, yshift, 
				 opt[(int) degrees].val.r, 1.0, 1.0, 1.0, page[page_no][0],
				 xsize, ysize);
    if (ctrl[(int) B_Pic_Body]) (*ctrl[(int) B_Pic_Body])();
  }
  /* and check we are where we should be */
  if (bop !=  *dvi_ptr++)
    fprintf(stderr, "not at bop in do_page!\n");
  
  if (setting) {
    init_stack();	/* initialise stack */
    for (i=0; i<no_cgm_specials; ++i){
      cgm_specials[i].x_ptr = cgm_specials[i].y_ptr = NULL;
      cgm_specials[i].el_id = cgm_specials[i].cmd_no = 0;
      cgm_specials[i].no_pos = cgm_specials[i].done = 0;
    }
  }
  
  dvi_ptr += (no_counters + 1) * 4; /* skip over counters */
  
  cmd = *dvi_ptr++;	/* grab next command */
  
  /* now get into the main processing loop for page */
  	while (eop != cmd) {	
    /* first check for the set_char range */
    if ((beg_char_set <= cmd) && (cmd <= end_char_set))
      set_char(cmd, true, setting);	
    else if ((beg_fnt_set <= cmd) && (cmd <= end_fnt_set))
      set_font(cmd - beg_fnt_set, setting);
    else	/* go into big switch statement */ {
      
      /* now set up the main switch statement, used to process the page */
      
      switch (cmd) {
	
      case set1:
      case set2:
      case set3:
      case set4: set_char( read_dvi(cmd-set1 + 1, false), true,
			  setting); break;
	
      case set_rule_cmd:  if (setting) {
	arg1=read_dvi(4, true);
	arg2=read_dvi(4, true);
	do_rule(arg1, arg2, true);
      } else dvi_ptr += 8;
	break;
      case put1:
      case put2:
      case put3:
      case put4: set_char( read_dvi(cmd-put1 + 1, false), false,
			  setting); break;
	
      case put_rule:	if (setting) {
	arg1=read_dvi(4, true);
	arg2=read_dvi(4, true);
	do_rule(arg1, arg2, false);
      } else dvi_ptr += 8;
	break;
	
      case nop: break;
	case push: if (setting) push_stack(); break;
	
      case pop: if (setting) pop_stack(); break;
	
      case right1: 
      case right2:
      case right3:
      case right4:	if (setting) h += read_dvi(cmd - right1 + 1, true);
      else dvi_ptr += cmd - right1 + 1;
	break;
	
      case w0: if (setting) h += w; break;
      case w1: 
      case w2:
      case w3:
      case w4:    if (setting) h += (w = read_dvi(cmd - w0, true)); 
      else dvi_ptr += cmd - w0; break;
	
      case x0: if (setting) h += x; break;
      case x1: 
      case x2:
      case x3:
      case x4: if (setting) h += (x = read_dvi(cmd - x0, true)); 
      else dvi_ptr += cmd - x0; break;
	
      case down1:
      case down2:
      case down3:
      case down4: if (setting) v += read_dvi(cmd - down1 + 1, true); 
      else dvi_ptr += cmd - down1 + 1; break;
	
	case y0: if (setting) v += y; break;
      case y1:
      case y2:
      case y3:
      case y4: if (setting) v += (y=read_dvi(cmd - y0, true)); 
      else dvi_ptr += cmd - y0; break;
	
      case z0: if (setting) v += z; break;
      case z1:
      case z2:
      case z3:
      case z4: if (setting) v += (z=read_dvi(cmd - z0, true)); 
      else dvi_ptr += cmd - z0; break;
	
      case fnt1:
      case fnt2:
      case fnt3:
      case fnt4: set_font(read_dvi(cmd - fnt1 + 1, (cmd==fnt4)), 
			  setting);break;
	
      case xxx1:
      case xxx2:
      case xxx3:
      case xxx4: if (setting) read_special(read_dvi(cmd - xxx1 + 1, false)); 
      else dvi_ptr += read_dvi(cmd - xxx1 + 1, false);
	break;
	
      case fnt_def1:
      case fnt_def2:
      case fnt_def3:
      case fnt_def4: 	dvi_ptr += 12 + (cmd - fnt_def1 + 1);
	a = *dvi_ptr++;
	l = *dvi_ptr++;
	dvi_ptr += a + l;
	break;
	
      default: fprintf(stderr, "\nshouldn't see this here, cmd = %d, %d into page",
		       cmd, dvi_ptr - hold_place); break; 
		} /* end of switch */
    } /* end of else (not set_char or set_fnt) */
    cmd = *dvi_ptr++;	/* grab next command */
  } /* end of while not eop */
  if (setting) {
    fprintf(stderr, "]");
    if (delim[(int) E_Pic]) (*delim[(int) E_Pic])(opt[(int) copies].val.i);
    if (ctrl[(int) E_Pic]) (*ctrl[(int) E_Pic])(opt[(int) copies].val.i);
    for (i=0; i<no_cgm_specials; ++i) {
      if (cgm_specials[i].x_ptr != NULL) free(cgm_specials[i].x_ptr);
      if (cgm_specials[i].y_ptr != NULL) free(cgm_specials[i].y_ptr);
    }
  }
  return(0);
}
init_stack() {
  last_v = -1; 	/* reset at beginning of page */
  h = 0; 	v = 0; 	w = 0; 	x = 0; 	y = 0; 	z = 0;
  stack_ptr = 0;
  return(0);	}
push_stack() {
  page_stack[stack_ptr][0] = h;
  page_stack[stack_ptr][1] = v;
  page_stack[stack_ptr][2] = w;
  page_stack[stack_ptr][3] = x;
  page_stack[stack_ptr][4] = y;
  page_stack[stack_ptr][5] = z;
  stack_ptr++;    
  return(0);		}
     
     pop_stack() {
       stack_ptr--;   
       h = page_stack[stack_ptr][0];
       v = page_stack[stack_ptr][1];
       w = page_stack[stack_ptr][2];
       x = page_stack[stack_ptr][3];
       y = page_stack[stack_ptr][4];
       z = page_stack[stack_ptr][5];
       return(0);		}
     set_font(font_no, do_it) 
     int font_no, do_it;
{
  unsigned char temp;
  curr_font = font_no;
  if (!do_it) return(0);
  if (gtex_calls[(int) S_Font]) (*gtex_calls[(int) S_Font])(font_no);
  return(0);	
}

float float_fix(arg)
int arg;
{
  float rtemp;
  rtemp = arg;
  rtemp = rtemp / shift20 ; /* divide by 2^{20} */
  
  return(rtemp);
}



read_special(no_chars) 
int no_chars;
{
#define sp_size 256
  int i, page_no, xshift, yshift, ret;
  char char_buffer[sp_size];
  static char gplot_flag[] = "gplot";
  char file_name[max_str], c, c_name[10];
  char special_flag[max_str], *sp_ptr;
#define buffer_len 514
  char line_buffer[buffer_len];
  float xpos, ypos;
  FILE *sp_file;
  int c_flag = 1;
  int el_id, cmd_no, no_pos, pos;	/* for cgm calls */
  
  if (no_chars > sp_size) {
    dvi_ptr += no_chars;
    return(0);
  }
  for (i=0; i < no_chars; ++i)
    char_buffer[i] = *dvi_ptr++;
  char_buffer[no_chars] = '\0';
  
  /* scan in the flag */
  sscanf(char_buffer, " %s ", special_flag);
  
  if(deb) fprintf(stderr, "\nspecial string is %s\n", char_buffer);
  
#define same(str1, str2) ((strlen(str1) == strlen(str2)) && \
			  (strcmp(str1, str2) == 0))
  
  /* a string to be inserted into the output */
  
  if same("include-string", special_flag) {
    
    for (i=strlen(special_flag) + 1; i<strlen(char_buffer); ++i) 
      outc(char_buffer[i]);
    return(1);
  }
  /* a file to be inserted into the output */
  /* probably only text files make sense, so do line at a time */
  if same("include-file", special_flag) {
    sp_ptr = char_buffer + strlen(special_flag) + 1;
    if (NULL == (sp_file = fopen(sp_ptr, "r"))) {
      fprintf(stderr, "couldn't open \"%s\"\n", sp_ptr);
      return(2);
    } else {
      while (fgets(line_buffer, buffer_len, sp_file)) {
	line_buffer[strlen(line_buffer) - 1] = '\0';
	out_string(line_buffer);
	fb();
      }
      fclose(sp_file);
    }
  }
  /* a string to be inserted into the output, preceded by an escape char. */
  
  if same("escape-string", special_flag) {
    
    outc(esc);
    for (i=strlen(special_flag) + 1; i<strlen(char_buffer); ++i) 
      outc(char_buffer[i]);
    return(1);
  }
  /* colour options */
  if same("color", special_flag) {
    sscanf(char_buffer, " %*s %s", c_name);
    if same("whi", c_name) c_flag = 0;
    else if same("bla", c_name) c_flag = 1;
    else if same("red", c_name) c_flag = 2;
    else if same("gre", c_name) c_flag = 3;
    else if same("blu", c_name) c_flag = 4;
    else if same("cya", c_name) c_flag = 5;
    else if same("mag", c_name) c_flag = 6;
    else if same("yel", c_name) c_flag = 7;
    else fprintf(stderr, "\ncan't do colour %s!", c_name);
    return(1);
  }
  /* a gplot directive (heavy stuff !) */
  if same(gplot_flag, special_flag) {
    xpos = hor_margin + pxl_from_sp(h); xpos /= pxl_per_in;
    ypos = y_pxl - ver_margin - pxl_from_sp(v); ypos /= pxl_per_in;
    call_gplot(char_buffer + strlen(gplot_flag), xpos, ypos); 
    return(1);
  }
  /* a cgm directive (heavy stuff !) */
  if same("cgm", special_flag) {
    sscanf(char_buffer, " %*s %d %d %d %d", &el_id, &cmd_no,
	   &no_pos, &pos);
    if ((el_id < 1) || (el_id >19)) {
      fprintf(stderr, "\nillegal element id = %d\n", el_id);
      return(1);
    }
    if ((pos < 1) || (pos > no_pos)) {
      fprintf(stderr, "\nillegal position = %d, %d\n", pos, no_pos);
      return(1);
    }
    /* first check to see if we have already started this one */
    for (i=0; 	(i<no_cgm_specials) &&
	 ( (cgm_specials[i].el_id != el_id) || 
	  (cgm_specials[i].cmd_no != cmd_no) ); ++i);
    
    if (i == no_cgm_specials) { /* not yet started */
      
      /* find an unused one */
      for (i=0; (i<no_cgm_specials) && (cgm_specials[i].done); ++i);
      
      if (i == no_cgm_specials) { /* no room left */
	fprintf(stderr,"\ntoo many cgm specials active (%d)!\n",i);
	return(1);
      }
      /* now start a new one */
      if ((!(cgm_specials[i].x_ptr = (int *)
	     allocate_mem(no_pos * sizeof(int), 0))) || 
	  (!(cgm_specials[i].y_ptr = (int *)
	     allocate_mem(no_pos * sizeof(int), 0)))) return(1);
      cgm_specials[i].el_id = el_id;
      cgm_specials[i].cmd_no = cmd_no;
      cgm_specials[i].no_pos = no_pos;
      cgm_specials[i].done = 0;
    }
    	    /* add in the new point */
    ++cgm_specials[i].done;
    
    xpos = newx(h, v);
    ypos = newy(h, v);
    *(cgm_specials[i].x_ptr + pos - 1) = xpos;
    *(cgm_specials[i].y_ptr + pos - 1) = ypos;
    
    /* see if we're ready to go */
    if (cgm_specials[i].done >= no_pos) {
      
      if (gtex_calls[(int) Suspend]) (*gtex_calls[(int) Suspend])();
      if (gprim[cgm_specials[i].el_id - 1]) (*gprim[cgm_specials[i].el_id - 1])
	(cgm_specials[i].no_pos, cgm_specials[i].x_ptr,
	 cgm_specials[i].y_ptr);
      if (gtex_calls[(int) Restart]) (*gtex_calls[(int) Restart])();
      
      free(cgm_specials[i].x_ptr);
      free(cgm_specials[i].y_ptr);
      cgm_specials[i].x_ptr = cgm_specials[i].y_ptr = NULL;
      cgm_specials[i].el_id = cgm_specials[i].cmd_no = 0;
      cgm_specials[i].no_pos = cgm_specials[i].done = 0;
    }
    
  }
  return(1);
}
#undef buffer_len

/* trying to set the char here, implemented max-drift so that intra-word
     spacing is better, hopefully can take care of rounding slack between words, 
     but have to be careful about non-word spacing, so if !do_shift or v has 
     changed I do an absolute positioning, also if we didn't find the font */

set_char(char_no, do_shift, do_it) 
     int char_no, do_shift, do_it;
{
  static int need_h_reset = 0;
  int hshift, hh, vv, htemp, temp;
  extern int bit_set();
  /* we mark a character as wanted by increasing the used count and turning */
  /* on the corresponding bit in the want_flag */
  
  if (!bit_set(char_no, farray[curr_font].load_flag)){
    if (do_it) fprintf(stderr, "\nchar %d(%d) not loaded !", char_no, curr_font);
    ++farray[curr_font].used;
    farray[curr_font].want_flag[char_no / word_size]
      |= 1 << ( char_no % word_size);
    farray[curr_font].load_flag[char_no / word_size]
      |= 1 << ( char_no % word_size);
  }
  if (!do_it) return(0);
  hh = pxl_from_sp(h);
  
  if (v != last_v) {	/* major move */
    set_abs_both(h, v);
    last_v = v;
  }
  else if ( (abs(htemp = (hh - actual_h_pxl) ) > max_drift) || (!do_shift) 
	   || (need_h_reset)) {
    set_abs_h(h, v);
    actual_h_pxl = hh;
  }
  else if ( (htemp != 0) &&  (fix_drift > 0) ) {
    if (abs(htemp) > fix_drift ) hshift = fix_drift * (htemp > 0 ? 1 : -1);
    else hshift = htemp;
    move_rel_h(hshift);
    actual_h_pxl += hshift;
  }
  
  write_char(curr_font, char_no, newx(h, v), newy(h, v));
  
  if (do_shift) h += (int) farray[curr_font].width[char_no];
  actual_h_pxl += farray[curr_font].pxl[char_no];
  /* check to make sure we're not thrown off course */
  hh = pxl_from_sp(h);
  need_h_reset = (abs(htemp = (hh - actual_h_pxl) ) > max_drift);
  
  return(0); 
}
do_rule(height, width, do_shift) 
{
  int h_pxl, w_pxl, hshift, x, y;
  hshift = (do_shift) ? width : 0;
  
  if ( (height <= 0) || (width <= 0) ) return(0);
  
  if (height > width) {
    h_pxl = pxl_from_sp(height);
    w_pxl = cpxl_from_sp(width);}
  else {
    h_pxl = cpxl_from_sp(height);
    w_pxl = pxl_from_sp(width);
  }
  
  x = newx(h, v);
  y = newy(h, v);
  if (gtex_calls[(int) S_Rule]) 
    (*gtex_calls[(int) S_Rule])(x, y, w_pxl, h_pxl);
  else if (gprim[(int) Rectangle]) 
    (*gprim[(int) Rectangle])(x, y, x + w_pxl - 1, y + h_pxl - 1);
  
  last_v = -1;	/* need to re-calculate position */
  
  h += hshift;
  actual_h_pxl += w_pxl;
  return(0);
}
/* now put in the font processing routine */
process_font(font_no) 
{
  int j, a, l;
  float mag_temp;
  farray[font_no].chk_sum	= read_dvi(4, true);
  farray[font_no].scale 	= read_dvi(4, false);
  farray[font_no].design 	= read_dvi(4, false);
  farray[font_no].a = a 	= *dvi_ptr++;
  farray[font_no].l = l 	= *dvi_ptr++;
  farray[font_no].ino = 0;	/* don't have it yet */
  
  /* read in font name and convert to lower case */
  for (j=0; j< a + l; ++j) {
    farray[font_no].name[j] = (isupper(*dvi_ptr)) ? tolower(*dvi_ptr) :
      *dvi_ptr;
    ++dvi_ptr;
  }
  
  farray[font_no].name[j + 1] = '\0'; /* end with null */ 
  
  mag_temp = mag; /* global */
  mag_temp *= farray[font_no].scale ;
  mag_temp /= farray[font_no].design;
  mag_temp /= base_pxl_per_in;
  mag_temp *= pxl_per_in;
  farray[font_no].want_mag = mag_temp + 0.5;
  
  return(0);
}
make_dev_char(in_ptr, w_bytes, height, width, char_no, font_no, 
		tfm_width, pxl_width, char_array, bytes_found)
unsigned char *in_ptr;
char *char_array;
int w_bytes, height, char_no, width, font_no, tfm_width,pxl_width,*bytes_found;
{
  /* fix later */
  return(1);
}
end_dev_font(font_no)
int font_no;
{
  if (gtex_calls[(int) S_Font]) (*gtex_calls[(int) S_Font])(font_no);
  return(1);
}


set_abs_both(h, v)
int h, v;
{
  if (gtex_calls[(int) S_Abs_Both]) 
    (*gtex_calls[(int) S_Abs_Both])(newx(h,v), newy(h,v));
  else {
    if (gtex_calls[(int) S_Abs_H])
      (*gtex_calls[(int) S_Abs_H])(newx(h,v));
    if (gtex_calls[(int) S_Abs_V])
      (*gtex_calls[(int) S_Abs_V])(newy(h,v));
  }
  
  return(1);
}

set_abs_h(h,v)
     int h,v;
{
  if (gtex_calls[(int) S_Abs_H])
    (*gtex_calls[(int) S_Abs_H])(newx(h,v));
  return(0);
}
set_abs_v(h, v)
int h, v;
{
  if (gtex_calls[(int) S_Abs_V])
    (*gtex_calls[(int) S_Abs_V])(newy(h, v));
  return(0);
}


/* move horizontally in a relative fashion */
move_rel_h(shift)
     int shift;
{
  if (gtex_calls[(int) M_Rel_H])
    (*gtex_calls[(int) M_Rel_H])(shift);
  return(0);
}


/* do this in two bits, see if we have a TeX specific function to call,
     if not, if the device can handle cell arrays, do it that way */
write_char(font_no, char_no, hpos, vpos)
     int font_no;
     char char_no;
     int hpos, vpos;
{
  if (gtex_calls[(int) S_Char]) (*gtex_calls[(int) S_Char])(char_no);
  else if (gprim[(int) Cell_Array]) {
    int p[2], q[2], r[2];
    float rmag;
    if ((farray[font_no].want_mag) && (farray[font_no].local_mag)
	&& (farray[font_no].want_mag != farray[font_no].local_mag)) {
      rmag = farray[font_no].want_mag;
      rmag /= farray[font_no].local_mag;
    } else rmag = 1.0;
    p[0] = hpos + farray[font_no].hoff[char_no] * rmag;
    p[1] = vpos - farray[font_no].voff[char_no] * rmag;
    q[0] = p[0] + (farray[font_no].w_bits[char_no] - 1) * rmag;
    q[1] = p[1] - (farray[font_no].h_bits[char_no] - 1) * rmag;
    r[0] = q[0];
    r[1] = p[1];
    
    (*gprim[(int) Cell_Array]) (p, q, r, 
				farray[font_no].w_bits[char_no], farray[font_no].h_bits[char_no],
				1, farray[font_no].ptr[char_no], 1);
  }
  return(1);
}

/* do this in 3 steps (1) see if the char is as requested in cache_file,
     (2) if not, look at .pk files extant to find closest name, then look in
     cache-file again, (3) if still not found, get it from .pk file and
     put in cache file as well as down loading, mark it as loaded once
     when it is sent down */

load_fonts()
{
  int font_no, char_no, need_rotate;
  FILE *pk_file;	/* file for pk format font files */
  
  /* march thru all of the fonts  in a big font loop */
  for (font_no=0; font_no<max_fonts; font_no++) {
    if (!farray[font_no].used) continue; /* no characters used */
    
    get_pk_name(&farray[font_no]);	/* get the local name */
    
    /* start the device font declaration */
    if (gtex_calls[(int) St_Font])
      (*gtex_calls[(int) St_Font])(font_no, &farray[font_no]);
    
    /* get the info from the pk file */
    need_rotate = (!rot_page && (dev_info.capability & rot1_font)) ||
      (rot_page && (dev_info.capability & rot2_font));
    
    if (!do_pk_file(pk_file, &farray[font_no], gtex_calls[(int) M_Dev_Char], 
		    gprim[(int) Cell_Array], dev_info.capability, need_rotate))
      fprintf(stderr, "couldn't load font file %s\n", 
	      farray[font_no].local);
    
    /* and end the device font definition */
    if (gtex_calls[(int) E_Font])
      (*gtex_calls[(int) E_Font])(font_no);
  }
  return(1);
}
/* calling function to go grab gplot */
call_gplot(cmd_in, xpos, ypos)
     char *cmd_in;
     float xpos, ypos;
{
  struct info_struct new_info;
  struct one_opt new_opt[opt_size];
  int cmd_len, to_screen = 0, do_list = 0, i;
  char cmd_line[max_str];
  char in_fname[max_str];	/* the input file name */
  char open_name[max_str];	/* the opened file name */
  char def_name[max_str];	/* default output file specification */
  char full_oname[max_str];	/* full input file specification */
  int random_file;		/* random input possible ? */
  extern cgm_setup(), ccgm_setup();	/* binary and clear text setup */
  extern get_cmd(), get_clear();		/* get next command */
  extern cgm_command(), do_clear();	/* do the command */
  int (*do_command)(), (*get_command)();	/* useful pointers */
  
  unsigned char *start_mem = NULL;	/* for holding commands, data */
  int mem_size = 512 * 1000;	/* intial mem we will use */
  int get_cmd();	/* get the next command, return -1 if run out of data */
  int p_len;	/* parameter length */
  static struct ad_struct last_ad;	/* address of the last command read */
  int class, element;
  
  extern void s_defaults();		/* in utils.c */
  int argc1;			/* fake UNIX call */
  char **argv1;
  
  /* we need to initialise the new_info values to background */
  
  new_info.pxl_in 	= dev_info.pxl_in;
  new_info.ypxl_in 	= dev_info.ypxl_in;
  new_info.x_offset 	= dev_info.x_offset;
  new_info.y_offset 	= dev_info.y_offset;
  new_info.x_size 	= dev_info.x_size;
  new_info.y_size 	= dev_info.y_size;
  new_info.capability	= dev_info.capability;
  new_info.rec_size	= dev_info.rec_size;
  new_info.c_height	= dev_info.c_height;
  new_info.c_width	= dev_info.c_width;
  new_info.d_l_width	= dev_info.d_l_width;
  new_info.d_e_width	= dev_info.d_e_width;
  new_info.d_m_size	= dev_info.d_m_size;
  
  /* and initialise the options setting */
  
  for(i=0; i<opt_size; ++i) new_opt[i].set = 0;
  	/* make the new command line */
  
#ifdef VMS
  sprintf(cmd_line, "GPT/INCLUDED/NINDEX/X_OFFSET=%.4f/Y_OFFSET=%.4f", 
	  xpos, ypos);
#else
  sprintf(cmd_line, "gpt -i -N -x%.4f -y%.4f ", xpos, ypos);
#endif
  strncat(cmd_line, cmd_in, max_str - strlen(cmd_line));
  cmd_line[max_str] = 0;	/* be sure */
  
#ifdef VMS
  argc1 = 0;
  argv1 = NULL;
#else
  fake_call(cmd_line, &argc1, &argv1);
#endif
  /* check options */
  in_fname[0] = def_name[0] = '\0';
  if (!parse_cline(cmd_line, argc1, argv1, &to_screen,
		   &do_list, &new_info, new_opt)){
    fprintf(stderr, "couldn't parse the command line\n%s\n",cmd_line);
    return(2);
  }
  /* figure out what we should be opening */
  consult_device(new_opt, &new_info);
  /* take care of the file names */
  
  if (new_opt[(int) in_name].set) 
    strncpy(in_fname, new_opt[(int) in_name].val.str, max_str);
  else return(0);
  
  /* may need to suspend things */
  if (gtex_calls[(int) Suspend]) (*gtex_calls[(int) Suspend])();
  
  /* open up the input file */
  if (!open_input_file(in_fname, open_name, !to_screen, 
		       (new_opt[(int) clear_text].set) ? ".cgmc" : ".cgm", 
		       full_oname, &new_info, 
		       new_opt[(int) clear_text].set, &random_file)) {
    
    fprintf(stderr, "couldn't open your CGM file !\n");
    if (gtex_calls[(int) Restart])
      (*gtex_calls[(int) Restart])();	/* clean up */
    return(1);	/* can't do anything */
  }
  	/* have input, so continue */
  /* set the defaults */
  s_defaults(&glbl1, &dflt2, &dflt3, &dflt5, &glbl5, 1.0);
  
  /* allocate main memory */
  if (!(start_mem = (unsigned char *) allocate_mem(mem_size, 0))) {
    fprintf(stderr, "couldn't make memory for your CGM file !\n");
    if (gtex_calls[(int) Restart])
      (*gtex_calls[(int) Restart])();
    return(1);
  }
  /* setup the command interpreters */
  if (new_opt[(int) clear_text].set) {
    if (!ccgm_setup(do_list, full_oname, version_str, &new_info, 
		    new_opt, &glbl1, &glbl2, &dflt2, &glbl3, &dflt3, &glbl5, 
		    &dflt5, delim, mfdesc, pdesc, mfctrl, gprim, attr, escfun, 
		    extfun, ctrl)) {
      (void) fprintf(stderr, "couldn't setup clear text\n");
      exit(0);
    } else {	/* setup pointers */
      get_command = get_clear;
      do_command = do_clear;
    }
  }
  else if (!cgm_setup(do_list, full_oname, version_str, &new_info, 
		      new_opt, &glbl1, &glbl2, &dflt2, &glbl3, &dflt3, &glbl5, 
		      &dflt5, delim, mfdesc, pdesc, mfctrl, gprim, attr, escfun, 
		      extfun, ctrl, random_file)) {
    (void) fprintf(stderr, "couldn't setup binary\n");
    exit(0);
  } else {	/* setup pointers */
    get_command = get_cmd;
    do_command = cgm_command;
  }
  	/* do the main loop while there is both input and not end_metafile */
  while  ( ((p_len = (*get_command)(&start_mem, &mem_size, &last_ad))
	    >= 0) && 
	  ((*do_command)(start_mem, p_len, &last_ad, &class, &element))) {
    if ((class == 0) && (element == (int) E_Pic)) {
      /* just finished page */
      ++pages_done;
    }
  }
  
  if (p_len < 0) (void) fprintf(stderr, "premature end of file\n");
  if (gtex_calls[(int) Restart]) (*gtex_calls[(int) Restart])();
  free(start_mem);	/* give up memory */
  return(1);
}

/* this is where we look for GTEX specific functions */
gtex_setup(in_opt, out_calls)
     struct one_opt 		*in_opt;	/* the command line options, in only */
     int (*out_calls[])();	/* function pointers which may be filled in */
{
#define dev_length 20	/* maximum device name length */
  char dev_name[dev_length + 1], buffer[dev_length + 1];
  int i;
  /* now need to figure out who to call*/
  
  /* now see if we asked for a device */
  if (in_opt[(int) device].set) 
    strncpy(dev_name, in_opt[(int) device].val.str, dev_length);
  else if (in_opt[(int) screen].set) 
    strncpy(dev_name, in_opt[(int) screen].val.str, dev_length);
  else return(0);
  
  dev_name[dev_length] = '\0';	/* for safety */
  
  /* let's convert to lower case */	
  
  for (i=0; i<strlen(dev_name); ++i) dev_name[i] = tolower(dev_name[i]);
  
  /* and go check to see if we know it */
  
  /* first postscript */
#ifdef incps
  if (0 == strncmp(dev_name, "ps", 2)) {	/* anything beginning w "ps" */
    ps_gtex_setup(in_opt, out_calls);
    return(1);
  }
#endif
  /* now QMS */
#ifdef incqms
  if (0 == strncmp(dev_name, "qms", 3)) {	/* anything beginning w "qms" */
    qms_gtex_setup(in_opt, out_calls);
    return(1);
  }
#endif
  /* now XL */
#ifdef incxl
  if (0 == strncmp(dev_name, "xl", 2)) {	/* anything beginning w "ps" */
    xl_gtex_setup(in_opt, out_calls);
    return(1);
  }
#endif
  
  /* if we got here, no specific functions */
  return(0);
  
}

