/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2007  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/


#include <stdio.h>
#include <string.h>

#include "recode.h"
#include "str_fun.h"

/* 
   Information about utf-8, cp850, latin-1 character encoding which has been 
   used for writing the functions in this file has been taken from:

   http://www.cl.cam.ac.uk/~mgk25/unicode.html (by Markus Kuhn)
   http://en.wikipedia.org/wiki/Windows-1252
   http://en.wikipedia.org/wiki/CP850
   http://en.wikipedia.org/wiki/Western_Latin_character_sets_%28computing%29
   http://en.wikipedia.org/wiki/UTF8
   http://www.utf8-chartable.de/

   all websites were accessed on 13.3.2006
   
*/


/* es ist ein Puffer fuer outzeile_len + 1 Zeichen bereitzustellen */
int utf8_to_latin1(char * outzeile, char * inzeile, long outzeile_len)
{
  int i,j;
  int first_byte;
  int second_byte;
  int laenge_inzeile;
  unsigned int aktuelles_byte;

  laenge_inzeile=strlen(inzeile);
  
  j = 0;
  first_byte = 0;
  second_byte = 0;
  for (i=0;i <= laenge_inzeile-1;i++) 
  {
    if (j>=outzeile_len-1)
    {
      break;
    }
    aktuelles_byte = (unsigned char) inzeile[i];
    if (aktuelles_byte < 128)
    {
       outzeile[j] = aktuelles_byte;
       j++;
       first_byte = 0; second_byte = 0; 
       continue;
    }
    if (aktuelles_byte >= 192)
    {
       first_byte = aktuelles_byte;
       continue;
    }
    if (aktuelles_byte < 192 && aktuelles_byte >= 128)
    {
       if (first_byte < 192)
       {
         outzeile[j] = '?';
         j++;
         first_byte = 0;
         second_byte = 0;
         continue;
       } else {
         second_byte = aktuelles_byte;
       }
       if (first_byte == 194 && second_byte == 161)
       {
          outzeile[j] = 0xa1; /* Inverted exclamation mark */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 162)
       {
          outzeile[j] = 0xa2; /* cent sign */
          j++;
          first_byte = 0; second_byte = 0; 
          continue;
       }
       if (first_byte == 194 && second_byte == 163)
       {
          outzeile[j] = 0xa3; /* pound sign */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 164)
       {
          outzeile[j] = 0xa4; /* currency sign */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 165)
       {
          outzeile[j] = 0xa5; /* Yen sign */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 166)
       {
          outzeile[j] = 0xa6; /* broken bar */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 167)
       {
          outzeile[j] = 0xa7; /* section (paragraph) sign */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 168)
       {
          outzeile[j] = 0xa8; /* diaeresis */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 169)
       {
          outzeile[j] = 0xa9; /* copyright sign */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 170)
       {
          outzeile[j] = 0xaa; /* feminine ordinal indicator (superscript a) */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 171)
       {
          outzeile[j] = 0xab; /* left-pointing double angle quotation mark */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 172)
       {
          outzeile[j] = 0xac; /* not sign */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 173)
       {
          outzeile[j] = 0xad; /* soft hyphen */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 174)
       {
          outzeile[j] = 0xae; /* registered sign */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 175)
       {
          outzeile[j] = 0xaf; /* macron sign */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 176)
       {
          outzeile[j] = 0xb0; /* degree sign */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 177)
       {
          outzeile[j] = 0xb1; /* plus-minus-sign */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 178)
       {
          outzeile[j] = 0xb2; /* superscript two */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 179)
       {
          outzeile[j] = 0xb3; /* superscript three */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 180)
       {
          outzeile[j] = 0xb4; /* acute accent */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 181)
       {
          outzeile[j] = 0xb5; /* micro sign */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 182)
       {
          outzeile[j] = 0xb6; /* pilcrow sign */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 183)
       {
          outzeile[j] = 0xb7; /* middle dot */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 184)
       {
          outzeile[j] = 0xb8; /* cedilla */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 185)
       {
          outzeile[j] = 0xb9; /* superscript one */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 186)
       {
          outzeile[j] = 0xba; /* masculine ordinal indicator */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 187)
       {
          outzeile[j] = 0xbb; /* right-pointing double angle quotation mark */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 188)
       {
          outzeile[j] = 0xbc; /* vulgar fraction one quarter */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 189)
       {
          outzeile[j] = 0xbd; /* vulgar fraction one half */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 190)
       {
          outzeile[j] = 0xbe; /* vulgar fraction three quarters */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 194 && second_byte == 191)
       {
          outzeile[j] = 0xbf; /* inverted question mark */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 128)
       {
          outzeile[j] = 0xc0; /* latin capital letter A with grave */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 129)
       {
          outzeile[j] = 0xc1; /* latin capital letter A with acute */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 130)
       {
          outzeile[j] = 0xc2; /* latin capital letter A with circumflex */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 131)
       {
          outzeile[j] = 0xc3; /* latin capital letter A with tilde */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 132)
       {
          outzeile[j] = 0xc4; /* Latin capital letter A with diaeresis */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 133)
       {
          outzeile[j] = 0xc5; /* Latin capital letter A with ring above */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 134)
       {
          outzeile[j] = 0xc6; /* Latin capital letter AE */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 135)
       {
          outzeile[j] = 0xc7; /* Latin capital letter C with cedilla */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 136)
       {
          outzeile[j] = 0xc8; /* Latin capital letter E with grave */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 137)
       {
          outzeile[j] = 0xc9; /* Latin capital letter E with acute */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 138)
       {
          outzeile[j] = 0xca; /* Latin capital letter E with circumflex */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 139)
       {
          outzeile[j] = 0xcb; /* Latin capital letter E with diaeresis */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 140)
       {
          outzeile[j] = 0xcc; /* Latin capital letter I with grave */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 141)
       {
          outzeile[j] = 0xcd; /* Latin capital letter I with acute */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 142)
       {
          outzeile[j] = 0xce; /* Latin capital letter I with circumflex */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 143)
       {
          outzeile[j] = 0xcf; /* Latin capital letter I with diaeresis */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 144)
       {
          outzeile[j] = 0xd0; /* Latin capital letter eth */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 145)
       {
          outzeile[j] = 0xd1; /* Latin capital letter N with tilde */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 146)
       {
          outzeile[j] = 0xd2; /* Latin capital letter O with grave */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 147)
       {
          outzeile[j] = 0xd3; /* Latin capital letter O with acute */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 148)
       {
          outzeile[j] = 0xd4; /* Latin capital letter O with circumflex */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 149)
       {
          outzeile[j] = 0xd5; /* Latin capital letter O with tilde */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 150)
       {
          outzeile[j] = 0xd6; /* Latin capital letter O with diaeresis */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 151)
       {
          outzeile[j] = 0xd7; /* multiplication sign */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 152)
       {
          outzeile[j] = 0xd8; /* Latin capital letter O with stroke */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 153)
       {
          outzeile[j] = 0xd9; /* Latin capital letter U with grave */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 154)
       {
          outzeile[j] = 0xda; /* Latin capital letter U with acute */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 155)
       {
          outzeile[j] = 0xdb; /* Latin capital letter U with circumflex */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 156)
       {
          outzeile[j] = 0xdc; /* Latin capital letter U with diaeresis */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 157)
       {
          outzeile[j] = 0xdd; /* Latin capital letter Y with acute */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 158)
       {
          outzeile[j] = 0xde; /* Latin capital letter thorn */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 159)
       {
          outzeile[j] = 0xdf; /* Latin small letter sharp s (eszet) */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 160)
       {
          outzeile[j] = 0xe0; /* Latin small letter a with grave */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 161)
       {
          outzeile[j] = 0xe1; /* Latin small letter a with acute */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 162)
       {
          outzeile[j] = 0xe2; /* Latin small letter a with circumflex */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 163)
       {
          outzeile[j] = 0xe3; /* Latin small letter a with tilde */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 164)
       {
          outzeile[j] = 0xe4; /* Latin small letter a with diaeresis */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 165)
       {
          outzeile[j] = 0xe5; /* Latin small letter a with ring above */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 166)
       {
          outzeile[j] = 0xe6; /* Latin small letter ae */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 167)
       {
          outzeile[j] = 0xe7; /* Latin small letter c with cedilla */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 168)
       {
          outzeile[j] = 0xe8; /* Latin small letter e with grave */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 169)
       {
          outzeile[j] = 0xe9; /* Latin small letter e with acute */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 170)
       {
          outzeile[j] = 0xea; /* Latin small letter e with circumflex */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 171)
       {
          outzeile[j] = 0xeb; /* Latin small letter e with diaeresis */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 172)
       {
          outzeile[j] = 0xec; /* Latin small letter i with grave */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 173)
       {
          outzeile[j] = 0xed; /* Latin small letter i with acute */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 174)
       {
          outzeile[j] = 0xee; /* Latin small letter i with circumflex */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 175)
       {
          outzeile[j] = 0xef; /* Latin small letter i with diaeresis */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 176)
       {
          outzeile[j] = 0xf0; /* Latin small letter eth */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 177)
       {
          outzeile[j] = 0xf1; /* Latin small letter n with tilde */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 178)
       {
          outzeile[j] = 0xf2; /* Latin small letter o with grave */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 179)
       {
          outzeile[j] = 0xf3; /* Latin small letter o with acute */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 180)
       {
          outzeile[j] = 0xf4; /* Latin small letter o with circumflex */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 181)
       {
          outzeile[j] = 0xf5; /* Latin small letter o with tilde */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 182)
       {
          outzeile[j] = 0xf6; /* Latin small letter o with diaeresis */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 183)
       {
          outzeile[j] = 0xf7; /* division sign */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 184)
       {
          outzeile[j] = 0xf8; /* Latin small letter o with stroke */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 185)
       {
          outzeile[j] = 0xf9; /* Latin small letter u with grave */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 186)
       {
          outzeile[j] = 0xfa; /* Latin small letter u with acute */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 187)
       {
          outzeile[j] = 0xfb; /* Latin small letter u with circumflex */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 188)
       {
          outzeile[j] = 0xfc; /* Latin small letter u with diaeresis */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
       if (first_byte == 195 && second_byte == 189)
       {
          outzeile[j] = 0xfd; /* Latin small letter y with acute */
          j++;
          first_byte = 0; second_byte = 0;
          continue;
       }
    }
  }
  outzeile[j]='\0';
  return 1;
}


#define UTF8_BUCHSTABEN_LEN 2


/* es ist ein Puffer fuer outzeile_len + 1 Zeichen bereitzustellen */
int latin1_to_utf8(char * outzeile, char * inzeile, long outzeile_len) 
{
   int laenge_inzeile;
   int i, aktuelles_byte;
   char buchstabe[UTF8_BUCHSTABEN_LEN + 1];
   int schleife_fortsetzen = 1;
   
   laenge_inzeile = strlen(inzeile);
   
   strcpy(outzeile,"");
   for (i=0;i<laenge_inzeile;i++)   
   {
      if (schleife_fortsetzen == 0) 
      { 
        break;
      }
      aktuelles_byte = (unsigned char) inzeile[i];
      if (aktuelles_byte < 128) 
      {
         buchstabe[0] = aktuelles_byte;
         buchstabe[1] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xa1) /* inverted exclamation mark */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 161;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xa2) /* cent sign */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 162;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xa3) /* pound sign */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 163;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xa4) /* currency sign */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 164;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xa5) /* yen sign */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 165;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xa6) /* broken bar */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 166;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xa7) /* section (paragraph) sign */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 167;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xa8) /* diaeresis */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 168;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xa9) /* copyright sign */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 169;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xaa) /* feminine ordinal indicator */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 170;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xab) /* left-pointing double angle quotation mark */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 171;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xac) /* not sign */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 172;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xad) /* soft hyphen */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 173;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xae) /* registered sign */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 174;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xaf) /* macron */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 175;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xb0) /* degree sign */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 176;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xb1) /* plus-minus sign */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 177;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xb2) /* superscript two */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 178;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xb3) /* superscript three */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 179;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xb4) /* acute accent */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 180;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xb5) /* micro sign */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 181;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xb6) /* pilcrow sign */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 182;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xb7) /* middle dot */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 183;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xb8) /* cedilla */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 184;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xb9) /* superscript one */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 185;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xba) /* masculine ordinal indicator */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 186;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xbb) /* right-pointing double angle quotation mark */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 187;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xbc) /* vulgar fraction one quarter */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 188;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xbd) /* vulgar fraction one half */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 189;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xbe) /* vulgar fraction three quarters */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 190;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xbf) /* inverted question mark */
      {
         buchstabe[0] = 194;
         buchstabe[1] = 191;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xc0) /* latin capital letter A with grave */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 128;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xc1) /* latin capital letter A with acute */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 129;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xc2) /* latin capital letter A with circumflex */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 130;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xc3) /* latin capital letter A with tilde */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 131;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xc4) /* latin capital letter A with diaeresis */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 132;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xc5) /* latin capital letter A with ring above */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 133;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xc6) /* latin capital letter AE */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 134;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xc7) /* latin capital letter C with cedilla */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 135;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xc8) /* latin capital letter E with grave */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 136;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xc9) /* latin capital letter E with acute */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 137;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xca) /* latin capital letter E with circumflex */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 138;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xcb) /* latin capital letter E with diaeresis */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 139;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xcc) /* latin capital letter I with grave */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 140;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xcd) /* latin capital letter I with acute */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 141;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xce) /* latin capital letter I with circumflex */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 142;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xcf) /* latin capital letter I with diaeresis */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 143;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xd0) /* latin capital letter ETH */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 144;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xd1) /* latin capital letter N with tilde */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 145;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xd2) /* latin capital letter O with grave */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 146;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xd3) /* latin capital letter O with acute */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 147;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xd4) /* latin capital letter O with circumflex */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 148;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xd5) /* latin capital letter O with tilde */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 149;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xd6) /* latin capital letter O with diaeresis */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 150;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xd7) /* multiplication sign */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 151;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xd8) /* latin capital letter O with stroke */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 152;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xd9) /* latin capital letter U with grave */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 153;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xda) /* latin capital letter U with acute */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 154;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xdb) /* latin capital letter U with circumflex */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 155;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xdc) /* latin capital letter U with diaeresis */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 156;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xdd) /* latin capital letter Y with acute */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 157;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xde) /* latin capital letter thorn */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 158;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xdf) /* latin capital letter sharp s (eszet) */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 159;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xe0) /* latin small letter a with grave */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 160;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xe1) /* latin small letter a with acute */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 161;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xe2) /* latin small letter a with circumflex */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 162;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xe3) /* latin small letter a with tilde */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 163;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xe4) /* latin small letter a with diaeresis */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 164;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xe5) /* latin small letter a with ring above */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 165;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xe6) /* latin small letter ae */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 166;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xe7) /* latin small letter c with cedilla */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 167;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xe8) /* latin small letter e with grave */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 168;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xe9) /* latin small letter e with acute */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 169;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xea) /* latin small letter e with circumflex */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 170;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xeb) /* latin small letter e with diaeresis */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 171;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xec) /* latin small letter i with grave */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 172;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xed) /* latin small letter i with acute */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 173;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xee) /* latin small letter i with circumflex */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 174;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xef) /* latin small letter i with diaeresis */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 175;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xf0) /* latin small letter eth */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 176;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xf1) /* latin small letter n with tilde */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 177;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xf2) /* latin small letter o with grave */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 178;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xf3) /* latin small letter o with acute */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 179;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xf4) /* latin small letter o with circumflex */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 180;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xf5) /* latin small letter o with tilde */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 181;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xf6) /* latin small letter o with diaeresis */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 182;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xf7) /* division sign */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 183;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xf8) /* latin small letter o with stroke */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 184;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xf9) /* latin small letter u with grave */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 185;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xfa) /* latin small letter u with acute */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 186;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xfb) /* latin small letter u with circumflex */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 187;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xfc) /* latin small letter u with diaeresis */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 188;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
      if (aktuelles_byte == 0xfd) /* latin small letter y with acute */
      {
         buchstabe[0] = 195;
         buchstabe[1] = 189;
         buchstabe[2] = '\0';
         schleife_fortsetzen = strlimcat(outzeile,buchstabe,outzeile_len);
         continue;
      }
   }
   return 1;   
}

/* 
    Converts encoding of `zeile', however, 
    characters 0x80 .. 0xa0 and 0xfe and 0xff are not changed. 
*/
int cp850_to_latin1(char * zeile)
{
  unsigned int aktuelles_byte;
  int laenge_zeile;
  int i;
  laenge_zeile=strlen(zeile);
  
  for (i=0;i < laenge_zeile;i++)
  {
    aktuelles_byte = (unsigned char) zeile[i];
    if (aktuelles_byte < 128)
    {
       zeile[i] = aktuelles_byte;
       continue;
    }
    if (aktuelles_byte == 0xad) /* inverted exclamation mark */
    {
      zeile[i] = 0xa1;
      continue;
    }
    if (aktuelles_byte == 0xbd) /* cent sign */
    {
      zeile[i] = 0xa2;
      continue;
    }
    if (aktuelles_byte == 0x9c) /* pound sign */
    {
      zeile[i] = 0xa3;
      continue;
    }
    if (aktuelles_byte == 0xcf) /* currency sign */
    {
      zeile[i] = 0xa4;
      continue;
    }
    if (aktuelles_byte == 0xbe) /* yen sign */
    {
      zeile[i] = 0xa5;
      continue;
    }
    if (aktuelles_byte == 0xdd) /* broken bar */
    {
      zeile[i] = 0xa6;
      continue;
    }
    if (aktuelles_byte == 0xf5) /* section sign */
    {
      zeile[i] = 0xa7;
      continue;
    }
    if (aktuelles_byte == 0xf9) /* diaeresis */
    {
      zeile[i] = 0xa8;
      continue;
    }
    if (aktuelles_byte == 0xb8) /* copyright sign */
    {
      zeile[i] = 0xa9;
      continue;
    }
    if (aktuelles_byte == 0xa6) /* feminine ordinal indicator (^a) */
    {
      zeile[i] = 0xaa;
      continue;
    }
    if (aktuelles_byte == 0xae) /* left-pointing double angle quotation mark */
    {
      zeile[i] = 0xab;
      continue;
    }
    if (aktuelles_byte == 0xaa) /* not sign */
    {
      zeile[i] = 0xac;
      continue;
    }
    if (aktuelles_byte == 0xf0) /* soft hyphen */
    {
      zeile[i] = 0xad;
      continue;
    }
    if (aktuelles_byte == 0xa9) /* registered sign */
    {
      zeile[i] = 0xae;
      continue;
    }
    if (aktuelles_byte == 0xee) /* macron */
    {
      zeile[i] = 0xaf;
      continue;
    }
    if (aktuelles_byte == 0xf8) /* degree sign */
    {
      zeile[i] = 0xb0;
      continue;
    }
    if (aktuelles_byte == 0xf1) /* plus-minus sign */
    {
      zeile[i] = 0xb1;
      continue;
    }
    if (aktuelles_byte == 0xfd) /* superscript two */
    {
      zeile[i] = 0xb2;
      continue;
    }
    if (aktuelles_byte == 0xfc) /* superscript three */
    {
      zeile[i] = 0xb3;
      continue;
    }
    if (aktuelles_byte == 0xef) /* acute accent */
    {
      zeile[i] = 0xb4;
      continue;
    }
    if (aktuelles_byte == 0xe6) /* micro sign */
    {
      zeile[i] = 0xb5;
      continue;
    }
    if (aktuelles_byte == 0xf4) /* pilcrow sign */
    {
      zeile[i] = 0xb6;
      continue;
    }
    if (aktuelles_byte == 0xfa) /* middle dot */
    {
      zeile[i] = 0xb7;
      continue;
    }
    if (aktuelles_byte == 0xf7) /* cedilla */
    {
      zeile[i] = 0xb8;
      continue;
    }
    if (aktuelles_byte == 0xfb) /* superscript one */
    {
      zeile[i] = 0xb9;
      continue;
    }
    if (aktuelles_byte == 0xa7) /* masculine ordinal indicator */
    {
      zeile[i] = 0xba;
      continue;
    }
    if (aktuelles_byte == 0xaf) /* right-pointing double angle quotation mark */
    {
      zeile[i] = 0xbb;
      continue;
    }
    if (aktuelles_byte == 0xac) /* vulgar fraction one quarter */
    {
      zeile[i] = 0xbc;
      continue;
    }
    if (aktuelles_byte == 0xab) /* vulgar fraction one half */
    {
      zeile[i] = 0xbd;
      continue;
    }
    if (aktuelles_byte == 0xf3) /* vulgar fraction three quarters */
    {
      zeile[i] = 0xbe;
      continue;
    }
    if (aktuelles_byte == 0xa8) /* inverted quotation mark */
    {
      zeile[i] = 0xbf;
      continue;
    }
    if (aktuelles_byte == 0xb7) /* latin capital letter A with grave */
    {
      zeile[i] = 0xc0;
      continue;
    }
    if (aktuelles_byte == 0xb5) /* latin capital letter A with acute */
    {
      zeile[i] = 0xc1;
      continue;
    }
    if (aktuelles_byte == 0xb6) /* latin capital letter A with circumflex */
    {
      zeile[i] = 0xc2;
      continue;
    }
    if (aktuelles_byte == 0xc7) /* latin capital letter A with tilde */
    {
      zeile[i] = 0xc3;
      continue;
    }
    if (aktuelles_byte == 0x8e) /* latin capital letter A with diaeresis */
    {
      zeile[i] = 0xc4;
      continue;
    }
    if (aktuelles_byte == 0x8f) /* latin capital letter A with ring above */
    {
      zeile[i] = 0xc5;
      continue;
    }
    if (aktuelles_byte == 0x92) /* latin capital letter AE */
    {
      zeile[i] = 0xc6;
      continue;
    }
    if (aktuelles_byte == 0x80) /* latin capital letter C with cedilla */
    {
      zeile[i] = 0xc7;
      continue;
    }
    if (aktuelles_byte == 0xd4) /* latin capital letter E with grave */
    {
      zeile[i] = 0xc8;
      continue;
    }
    if (aktuelles_byte == 0x90) /* latin capital letter E with acute */
    {
      zeile[i] = 0xc9;
      continue;
    }
    if (aktuelles_byte == 0xd2) /* latin capital letter E with circumflex */
    {
      zeile[i] = 0xca;
      continue;
    }
    if (aktuelles_byte == 0xd3) /* latin capital letter E with diaeresis */
    {
      zeile[i] = 0xcb;
      continue;
    }
    if (aktuelles_byte == 0xde) /* latin capital letter I with grave */
    {
      zeile[i] = 0xcc;
      continue;
    }
    if (aktuelles_byte == 0xd6) /* latin capital letter I with acute */
    {
      zeile[i] = 0xcd;
      continue;
    }
    if (aktuelles_byte == 0xd7) /* latin capital letter I with circumflex */
    {
      zeile[i] = 0xce;
      continue;
    }
    if (aktuelles_byte == 0xd8) /* latin capital letter I with diaeresis */
    {
      zeile[i] = 0xcf;
      continue;
    }
    if (aktuelles_byte == 0xd1) /* latin capital letter ETH */
    {
      zeile[i] = 0xd0;
      continue;
    }
    if (aktuelles_byte == 0xa5) /* latin capital letter N with tilde */
    {
      zeile[i] = 0xd1;
      continue;
    }
    if (aktuelles_byte == 0xe3) /* latin capital letter O with grave */
    {
      zeile[i] = 0xd2;
      continue;
    }
    if (aktuelles_byte == 0xe0) /* latin capital letter O with acute */
    {
      zeile[i] = 0xd3;
      continue;
    }
    if (aktuelles_byte == 0xe2) /* latin capital letter O with circumflex */
    {
      zeile[i] = 0xd4;
      continue;
    }
    if (aktuelles_byte == 0xe5) /* latin capital letter O with tilde */
    {
      zeile[i] = 0xd5;
      continue;
    }
    if (aktuelles_byte == 0x99) /* latin capital letter O with diaeresis */
    {
      zeile[i] = 0xd6;
      continue;
    }
    if (aktuelles_byte == 0x9e) /* multiplication sign */
    {
      zeile[i] = 0xd7;
      continue;
    }
    if (aktuelles_byte == 0x9d) /* latin capital letter O with stroke */
    {
      zeile[i] = 0xd8;
      continue;
    }
    if (aktuelles_byte == 0xeb) /* latin capital letter U with grave */
    {
      zeile[i] = 0xd9;
      continue;
    }
    if (aktuelles_byte == 0xe9) /* latin capital letter U with acute */
    {
      zeile[i] = 0xda;
      continue;
    }
    if (aktuelles_byte == 0xea) /* latin capital letter U with circumflex */
    {
      zeile[i] = 0xdb;
      continue;
    }
    if (aktuelles_byte == 0x9a) /* latin capital letter U with diaeresis */
    {
      zeile[i] = 0xdc;
      continue;
    }
    if (aktuelles_byte == 0xed) /* latin capital letter Y with acute */
    {
      zeile[i] = 0xdd;
      continue;
    }
    if (aktuelles_byte == 0xe8) /* latin capital letter THORN */
    {
      zeile[i] = 0xde;
      continue;
    }
    if (aktuelles_byte == 0xe1) /* latin small letter sharp S */
    {
      zeile[i] = 0xdf;
      continue;
    }
    if (aktuelles_byte == 0x85) /* latin small letter a with grave */
    {
      zeile[i] = 0xe0;
      continue;
    }
    if (aktuelles_byte == 0xa0) /* latin small letter a with acute */
    {
      zeile[i] = 0xe1;
      continue;
    }
    if (aktuelles_byte == 0x83) /* latin small letter a with circumflex */
    {
      zeile[i] = 0xe2;
      continue;
    }
    if (aktuelles_byte == 0xc6) /* latin small letter a with tilde */
    {
      zeile[i] = 0xe3;
      continue;
    }
    if (aktuelles_byte == 0x84) /* latin small letter a with diaeresis */
    {
      zeile[i] = 0xe4;
      continue;
    }
    if (aktuelles_byte == 0x86) /* latin small letter a with ring above */
    {
      zeile[i] = 0xe5;
      continue;
    }
    if (aktuelles_byte == 0x91) /* latin small letter ae */
    {
      zeile[i] = 0xe6;
      continue;
    }
    if (aktuelles_byte == 0x87) /* latin small letter c with cedilla */
    {
      zeile[i] = 0xe7;
      continue;
    }
    if (aktuelles_byte == 0x8a) /* latin small letter e with grave */
    {
      zeile[i] = 0xe8;
      continue;
    }
    if (aktuelles_byte == 0x82) /* latin small letter e with acute */
    {
      zeile[i] = 0xe9;
      continue;
    }
    if (aktuelles_byte == 0x88) /* latin small letter e with circumflex */
    {
      zeile[i] = 0xea;
      continue;
    }
    if (aktuelles_byte == 0x89) /* latin small letter e with diaeresis */
    {
      zeile[i] = 0xeb;
      continue;
    }
    if (aktuelles_byte == 0x8d) /* latin small letter i with grave */
    {
      zeile[i] = 0xec;
      continue;
    }
    if (aktuelles_byte == 0xa1) /* latin small letter i with acute */
    {
      zeile[i] = 0xed;
      continue;
    }
    if (aktuelles_byte == 0x8c) /* latin small letter i with circumflex */
    {
      zeile[i] = 0xee;
      continue;
    }
    if (aktuelles_byte == 0x8b) /* latin small letter i with diaeresis */
    {
      zeile[i] = 0xef;
      continue;
    }
    if (aktuelles_byte == 0xd0) /* latin small letter eth */
    {
      zeile[i] = 0xf0;
      continue;
    }
    if (aktuelles_byte == 0xa4) /* latin small letter n with tilde */
    {
      zeile[i] = 0xf1;
      continue;
    }
    if (aktuelles_byte == 0x95) /* latin small letter o with grave */
    {
      zeile[i] = 0xf2;
      continue;
    }
    if (aktuelles_byte == 0xa2) /* latin small letter o with acute */
    {
      zeile[i] = 0xf3;
      continue;
    }
    if (aktuelles_byte == 0x93) /* latin small letter o with circumflex */
    {
      zeile[i] = 0xf4;
      continue;
    }
    if (aktuelles_byte == 0xe4) /* latin small letter o with tilde */
    {
      zeile[i] = 0xf5;
      continue;
    }
    if (aktuelles_byte == 0x94) /* latin small letter o with diaeresis */
    {
      zeile[i] = 0xf6;
      continue;
    }
    if (aktuelles_byte == 0xf6) /* division sign */
    {
      zeile[i] = 0xf7;
      continue;
    }
    if (aktuelles_byte == 0x9b) /* latin small letter o with stroke */
    {
      zeile[i] = 0xf8;
      continue;
    }
    if (aktuelles_byte == 0x97) /* latin small letter u with grave */
    {
      zeile[i] = 0xf9;
      continue;
    }
    if (aktuelles_byte == 0xa3) /* latin small letter u with acute */
    {
      zeile[i] = 0xfa;
      continue;
    }
    if (aktuelles_byte == 0x96) /* latin small letter u with circumflex */
    {
      zeile[i] = 0xfb;
      continue;
    }
    if (aktuelles_byte == 0x81) /* latin small letter u with diaeresis */
    {
      zeile[i] = 0xfc;
      continue;
    }
    if (aktuelles_byte == 0xec) /* latin small letter y with acute */
    {
      zeile[i] = 0xfd;
      continue;
    }
  }
  return 1;
}

/* 
    Converts encoding of `zeile', however, 
    characters 0x80 .. 0xa0 and 0xfe and 0xff are not changed. 
*/
int latin1_to_cp850(char * zeile)
{
  unsigned int aktuelles_byte;
  int laenge_zeile;
  int i;
  laenge_zeile=strlen(zeile);
  
  for (i=0;i < laenge_zeile;i++)
  {
    aktuelles_byte = (unsigned char) zeile[i];
    if (aktuelles_byte < 128)
    {
       zeile[i] = aktuelles_byte;
       continue;
    }
    if (aktuelles_byte == 0xa1) /* inverted exclamation mark */
    {
      zeile[i] = 0xad;
      continue;
    }
    if (aktuelles_byte == 0xa2) /* cent sign */
    {
      zeile[i] = 0xbd;
      continue;
    }
    if (aktuelles_byte == 0xa3) /* pound sign */
    {
      zeile[i] = 0x9c;
      continue;
    }
    if (aktuelles_byte == 0xa4) /* currency sign */
    {
      zeile[i] = 0xcf;
      continue;
    }
    if (aktuelles_byte == 0xa5) /* yen sign */
    {
      zeile[i] = 0xbe;
      continue;
    }
    if (aktuelles_byte == 0xa6) /* broken bar */
    {
      zeile[i] = 0xdd;
      continue;
    }
    if (aktuelles_byte == 0xa7) /* section sign */
    {
      zeile[i] = 0xf5;
      continue;
    }
    if (aktuelles_byte == 0xa8) /* diaeresis */
    {
      zeile[i] = 0xf9;
      continue;
    }
    if (aktuelles_byte == 0xa9) /* copyright sign */
    {
      zeile[i] = 0xb8;
      continue;
    }
    if (aktuelles_byte == 0xaa) /* feminine ordinal indicator (^a) */
    {
      zeile[i] = 0xa6;
      continue;
    }
    if (aktuelles_byte == 0xab) /* left-pointing double angle quotation mark */
    {
      zeile[i] = 0xae;
      continue;
    }
    if (aktuelles_byte == 0xac) /* not sign */
    {
      zeile[i] = 0xaa;
      continue;
    }
    if (aktuelles_byte == 0xad) /* soft hyphen */
    {
      zeile[i] = 0xf0;
      continue;
    }
    if (aktuelles_byte == 0xae) /* registered sign */
    {
      zeile[i] = 0xa9;
      continue;
    }
    if (aktuelles_byte == 0xaf) /* macron */
    {
      zeile[i] = 0xee;
      continue;
    }
    if (aktuelles_byte == 0xb0) /* degree sign */
    {
      zeile[i] = 0xf8;
      continue;
    }
    if (aktuelles_byte == 0xb1) /* plus-minus sign */
    {
      zeile[i] = 0xf1;
      continue;
    }
    if (aktuelles_byte == 0xb2) /* superscript two */
    {
      zeile[i] = 0xfd;
      continue;
    }
    if (aktuelles_byte == 0xb3) /* superscript three */
    {
      zeile[i] = 0xfc;
      continue;
    }
    if (aktuelles_byte == 0xb4) /* acute accent */
    {
      zeile[i] = 0xef;
      continue;
    }
    if (aktuelles_byte == 0xb5) /* micro sign */
    {
      zeile[i] = 0xe6;
      continue;
    }
    if (aktuelles_byte == 0xb6) /* pilcrow sign */
    {
      zeile[i] = 0xf4;
      continue;
    }
    if (aktuelles_byte == 0xb7) /* middle dot */
    {
      zeile[i] = 0xfa;
      continue;
    }
    if (aktuelles_byte == 0xb8) /* cedilla */
    {
      zeile[i] = 0xf7;
      continue;
    }
    if (aktuelles_byte == 0xb9) /* superscript one */
    {
      zeile[i] = 0xfb;
      continue;
    }
    if (aktuelles_byte == 0xba) /* masculine ordinal indicator */
    {
      zeile[i] = 0xa7;
      continue;
    }
    if (aktuelles_byte == 0xbb) /* right-pointing double angle quotation mark */
    {
      zeile[i] = 0xaf;
      continue;
    }
    if (aktuelles_byte == 0xbc) /* vulgar fraction one quarter */
    {
      zeile[i] = 0xac;
      continue;
    }
    if (aktuelles_byte == 0xbd) /* vulgar fraction one half */
    {
      zeile[i] = 0xab;
      continue;
    }
    if (aktuelles_byte == 0xbe) /* vulgar fraction three quarters */
    {
      zeile[i] = 0xf3;
      continue;
    }
    if (aktuelles_byte == 0xbf) /* inverted quotation mark */
    {
      zeile[i] = 0xa8;
      continue;
    }
    if (aktuelles_byte == 0xc0) /* latin capital letter A with grave */
    {
      zeile[i] = 0xb7;
      continue;
    }
    if (aktuelles_byte == 0xc1) /* latin capital letter A with acute */
    {
      zeile[i] = 0xb5;
      continue;
    }
    if (aktuelles_byte == 0xc2) /* latin capital letter A with circumflex */
    {
      zeile[i] = 0xb6;
      continue;
    }
    if (aktuelles_byte == 0xc3) /* latin capital letter A with tilde */
    {
      zeile[i] = 0xc7;
      continue;
    }
    if (aktuelles_byte == 0xc4) /* latin capital letter A with diaeresis */
    {
      zeile[i] = 0x8e;
      continue;
    }
    if (aktuelles_byte == 0xc5) /* latin capital letter A with ring above */
    {
      zeile[i] = 0x8f;
      continue;
    }
    if (aktuelles_byte == 0xc6) /* latin capital letter AE */
    {
      zeile[i] = 0x92;
      continue;
    }
    if (aktuelles_byte == 0xc7) /* latin capital letter C with cedilla */
    {
      zeile[i] = 0x80;
      continue;
    }
    if (aktuelles_byte == 0xc8) /* latin capital letter E with grave */
    {
      zeile[i] = 0xd4;
      continue;
    }
    if (aktuelles_byte == 0xc9) /* latin capital letter E with acute */
    {
      zeile[i] = 0x90;
      continue;
    }
    if (aktuelles_byte == 0xca) /* latin capital letter E with circumflex */
    {
      zeile[i] = 0xd2;
      continue;
    }
    if (aktuelles_byte == 0xcb) /* latin capital letter E with diaeresis */
    {
      zeile[i] = 0xd3;
      continue;
    }
    if (aktuelles_byte == 0xcc) /* latin capital letter I with grave */
    {
      zeile[i] = 0xde;
      continue;
    }
    if (aktuelles_byte == 0xcd) /* latin capital letter I with acute */
    {
      zeile[i] = 0xd6;
      continue;
    }
    if (aktuelles_byte == 0xce) /* latin capital letter I with circumflex */
    {
      zeile[i] = 0xd7;
      continue;
    }
    if (aktuelles_byte == 0xcf) /* latin capital letter I with diaeresis */
    {
      zeile[i] = 0xd8;
      continue;
    }
    if (aktuelles_byte == 0xd0) /* latin capital letter ETH */
    {
      zeile[i] = 0xd1;
      continue;
    }
    if (aktuelles_byte == 0xd1) /* latin capital letter N with tilde */
    {
      zeile[i] = 0xa5;
      continue;
    }
    if (aktuelles_byte == 0xd2) /* latin capital letter O with grave */
    {
      zeile[i] = 0xe3;
      continue;
    }
    if (aktuelles_byte == 0xd3) /* latin capital letter O with acute */
    {
      zeile[i] = 0xe0;
      continue;
    }
    if (aktuelles_byte == 0xd4) /* latin capital letter O with circumflex */
    {
      zeile[i] = 0xe2;
      continue;
    }
    if (aktuelles_byte == 0xd5) /* latin capital letter O with tilde */
    {
      zeile[i] = 0xe5;
      continue;
    }
    if (aktuelles_byte == 0xd6) /* latin capital letter O with diaeresis */
    {
      zeile[i] = 0x99;
      continue;
    }
    if (aktuelles_byte == 0xd7) /* multiplication sign */
    {
      zeile[i] = 0x9e;
      continue;
    }
    if (aktuelles_byte == 0xd8) /* latin capital letter O with stroke */
    {
      zeile[i] = 0x9d;
      continue;
    }
    if (aktuelles_byte == 0xd9) /* latin capital letter U with grave */
    {
      zeile[i] = 0xeb;
      continue;
    }
    if (aktuelles_byte == 0xda) /* latin capital letter U with acute */
    {
      zeile[i] = 0xe9;
      continue;
    }
    if (aktuelles_byte == 0xdb) /* latin capital letter U with circumflex */
    {
      zeile[i] = 0xea;
      continue;
    }
    if (aktuelles_byte == 0xdc) /* latin capital letter U with diaeresis */
    {
      zeile[i] = 0x9a;
      continue;
    }
    if (aktuelles_byte == 0xdd) /* latin capital letter Y with acute */
    {
      zeile[i] = 0xed;
      continue;
    }
    if (aktuelles_byte == 0xde) /* latin capital letter THORN */
    {
      zeile[i] = 0xe8;
      continue;
    }
    if (aktuelles_byte == 0xdf) /* latin small letter sharp S */
    {
      zeile[i] = 0xe1;
      continue;
    }
    if (aktuelles_byte == 0xe0) /* latin small letter a with grave */
    {
      zeile[i] = 0x85;
      continue;
    }
    if (aktuelles_byte == 0xe1) /* latin small letter a with acute */
    {
      zeile[i] = 0xa0;
      continue;
    }
    if (aktuelles_byte == 0xe2) /* latin small letter a with circumflex */
    {
      zeile[i] = 0x83;
      continue;
    }
    if (aktuelles_byte == 0xe3) /* latin small letter a with tilde */
    {
      zeile[i] = 0xc6;
      continue;
    }
    if (aktuelles_byte == 0xe4) /* latin small letter a with diaeresis */
    {
      zeile[i] = 0x84;
      continue;
    }
    if (aktuelles_byte == 0xe5) /* latin small letter a with ring above */
    {
      zeile[i] = 0x86;
      continue;
    }
    if (aktuelles_byte == 0xe6) /* latin small letter ae */
    {
      zeile[i] = 0x91;
      continue;
    }
    if (aktuelles_byte == 0xe7) /* latin small letter c with cedilla */
    {
      zeile[i] = 0x87;
      continue;
    }
    if (aktuelles_byte == 0xe8) /* latin small letter e with grave */
    {
      zeile[i] = 0x8a;
      continue;
    }
    if (aktuelles_byte == 0xe9) /* latin small letter e with acute */
    {
      zeile[i] = 0x82;
      continue;
    }
    if (aktuelles_byte == 0xea) /* latin small letter e with circumflex */
    {
      zeile[i] = 0x88;
      continue;
    }
    if (aktuelles_byte == 0xeb) /* latin small letter e with diaeresis */
    {
      zeile[i] = 0x89;
      continue;
    }
    if (aktuelles_byte == 0xec) /* latin small letter i with grave */
    {
      zeile[i] = 0x8d;
      continue;
    }
    if (aktuelles_byte == 0xed) /* latin small letter i with acute */
    {
      zeile[i] = 0xa1;
      continue;
    }
    if (aktuelles_byte == 0xee) /* latin small letter i with circumflex */
    {
      zeile[i] = 0x8c;
      continue;
    }
    if (aktuelles_byte == 0xef) /* latin small letter i with diaeresis */
    {
      zeile[i] = 0x8b;
      continue;
    }
    if (aktuelles_byte == 0xf0) /* latin small letter eth */
    {
      zeile[i] = 0xd0;
      continue;
    }
    if (aktuelles_byte == 0xf1) /* latin small letter n with tilde */
    {
      zeile[i] = 0xa4;
      continue;
    }
    if (aktuelles_byte == 0xf2) /* latin small letter o with grave */
    {
      zeile[i] = 0x95;
      continue;
    }
    if (aktuelles_byte == 0xf3) /* latin small letter o with acute */
    {
      zeile[i] = 0xa2;
      continue;
    }
    if (aktuelles_byte == 0xf4) /* latin small letter o with circumflex */
    {
      zeile[i] = 0x93;
      continue;
    }
    if (aktuelles_byte == 0xf5) /* latin small letter o with tilde */
    {
      zeile[i] = 0xe4;
      continue;
    }
    if (aktuelles_byte == 0xf6) /* latin small letter o with diaeresis */
    {
      zeile[i] = 0x94;
      continue;
    }
    if (aktuelles_byte == 0xf7) /* division sign */
    {
      zeile[i] = 0xf6;
      continue;
    }
    if (aktuelles_byte == 0xf8) /* latin small letter o with stroke */
    {
      zeile[i] = 0x9b;
      continue;
    }
    if (aktuelles_byte == 0xf9) /* latin small letter u with grave */
    {
      zeile[i] = 0x97;
      continue;
    }
    if (aktuelles_byte == 0xfa) /* latin small letter u with acute */
    {
      zeile[i] = 0xa3;
      continue;
    }
    if (aktuelles_byte == 0xfb) /* latin small letter u with circumflex */
    {
      zeile[i] = 0x96;
      continue;
    }
    if (aktuelles_byte == 0xfc) /* latin small letter u with diaeresis */
    {
      zeile[i] = 0x81;
      continue;
    }
    if (aktuelles_byte == 0xfd) /* latin small letter y with acute */
    {
      zeile[i] = 0xec;
      continue;
    }
  }
  return 1;
}


// vim:tw=2000

