/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.actions;

import java.util.Arrays;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.actions.TexSelections;
import net.sourceforge.texlipse.editor.TexAutoIndentStrategy;
import net.sourceforge.texlipse.editor.TexEditorTools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class TexCorrectIndentationAction
implements IEditorActionDelegate {
    private IEditorPart targetEditor;
    private TexSelections selection;
    private TexEditorTools tools;
    private String indentationString = "";
    private String[] indentationItems;
    private int tabWidth;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.targetEditor = targetEditor;
    }

    private ITextEditor getTexEditor() {
        if (this.targetEditor instanceof ITextEditor) {
            return (ITextEditor)this.targetEditor;
        }
        throw new RuntimeException("Expecting text editor. Found:" + this.targetEditor.getClass().getName());
    }

    public void run(IAction action) {
        this.setIndetationPreferenceInfo();
        if (this.indentationItems.length == 0) {
            return;
        }
        this.selection = new TexSelections(this.getTexEditor());
        if (this.selection != null) {
            this.tools = new TexEditorTools();
            try {
                this.indent();
            }
            catch (BadLocationException e) {
                TexlipsePlugin.log("TexCorrectIndentationAction.run", e);
            }
        }
    }

    private void setIndetationPreferenceInfo() {
        this.indentationItems = TexlipsePlugin.getPreferenceArray("indentEnvs");
        Arrays.sort(this.indentationItems);
        this.indentationString = TexAutoIndentStrategy.getIndentationString();
    }

    private void indent() throws BadLocationException {
        String[] lines;
        int index = 0;
        boolean fix = false;
        IDocument document = this.selection.getDocument();
        this.selection.selectCompleteLines();
        String delimiter = document.getLineDelimiter(this.selection.getStartLineIndex());
        try {
            lines = document.get(document.getLineOffset(this.selection.getStartLineIndex()), this.selection.getSelLength()).split(delimiter);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        String selectedLine = "";
        String originalIndentation = "";
        String correctIndentation = "";
        int line = this.selection.getStartLineIndex();
        while (index < lines.length) {
            selectedLine = document.get(document.getLineOffset(line), document.getLineLength(line));
            originalIndentation = this.tools.getIndentation(selectedLine, this.tabWidth);
            correctIndentation = "";
            if (line != 0 && line != document.getLength() - 1) {
                if (line >= document.getLength()) {
                    return;
                }
                if (selectedLine.indexOf("\\end") != -1) {
                    String endText = this.tools.getEndLine(selectedLine.trim(), "\\end");
                    if (Arrays.binarySearch(this.indentationItems, this.tools.getEnvironment(endText)) >= 0) {
                        int matchingBegin = this.tools.findMatchingBeginEquation(document, line, this.tools.getEnvironment(endText));
                        correctIndentation = matchingBegin < this.selection.getStartLineIndex() ? this.tools.getIndentation(document, matchingBegin, "\\begin", this.tabWidth) : this.tools.getIndentation(lines[matchingBegin - this.selection.getStartLineIndex()], this.tabWidth);
                    }
                } else {
                    String lineText = "";
                    lineText = index == 0 ? document.get(document.getLineOffset(line - 1), document.getLineLength(line - 1)) : lines[index - 1];
                    if (lineText.indexOf("\\begin") != -1) {
                        String endText = this.tools.getEndLine(lineText.trim(), "\\begin");
                        if (Arrays.binarySearch(this.indentationItems, this.tools.getEnvironment(endText)) >= 0) {
                            correctIndentation = String.valueOf(this.tools.getIndentation(lineText, this.tabWidth)) + this.indentationString;
                        }
                    } else {
                        correctIndentation = this.tools.getIndentation(lineText, this.tabWidth);
                    }
                }
            }
            if (!correctIndentation.equals(originalIndentation)) {
                fix = true;
            }
            lines[index] = correctIndentation.concat(lines[index].trim());
            ++index;
            ++line;
        }
        String newText = lines[0];
        int i = 1;
        while (i < lines.length) {
            newText = String.valueOf(newText) + delimiter;
            newText = String.valueOf(newText) + lines[i];
            ++i;
        }
        if (fix) {
            document.replace(document.getLineOffset(this.selection.getStartLineIndex()), this.selection.getSelLength(), newText);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof ITextSelection) {
            action.setEnabled(true);
            return;
        }
        action.setEnabled(this.targetEditor instanceof ITextEditor);
    }
}

