/*
    declarations of global objects used in xetal,
    Copyright (C) 1991 Raphael Cerf (e-mail: cerf@ens.ens.fr)

    This file is part of xetal.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <malloc.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#define W_LGTH	50	/* maximal word length */

#ifdef FLEX_SCANNER
extern char *yytext;
#else
extern char yytext[];
#endif

extern int yydebug;

extern int mode;	/* current mode 0: normal, 1: math */
extern int verbatim;	/* verbatim mode */
extern int d_ok;	/* display flag */
extern long lineno;	/* current line in source text */
extern long total_lines;/* total nb of lines handled */
extern long charpos;	/* last char read */
extern long linepos;	/* last \n read */
extern long oldlpos;	/* old value of linepos */

/* output macros here */

extern int n_nl, N;
extern int n_formule;
extern long c_skipped;
extern char c_fill;
extern char s_accent;

/* options flags */
extern int d_anything, d_error;
extern int d_accent, d_bl, d_bls, d_command, d_comment, d_fname;
extern int d_macrodef, d_math, d_mot, d_nl, d_operator, d_punct;
extern int d_report, d_slashed, d_special, d_text, d_unknown;
extern int d_warning, do_fill, do_fill_acco, do_fill_slash, do_incl;

#define O_LGTH 1024
extern char S[O_LGTH]; /* output buffer */

extern FILE *devnull;	/* rubbish-bin */

typedef struct {
	char *name;
	FILE *fd;
	long line;
	char *last_string;
	char last_char;
} fich_t;		/* included file */

/* maximal nb of included files */
#define F_MAX		100
extern int n_ionly;/* nb of ionly files */
extern char *if_name[F_MAX];	/* includeonly_files */
extern char *f_name;	/* name of current file */
extern FILE **f_in;	/* input stream */

/* maximal nb of envrt names given with -e option */
#define M_ENVRT		1000
extern int n_envrt;
extern char *(envrt[M_ENVRT]);

/* maximal nb for symbols in list */
#define M_SYMBOL	10000
extern int n_symbol;
typedef struct {
	char *name;
	int token;
} symbol_t;
extern symbol_t symbol[M_SYMBOL];
extern int symbol_tcmp();

extern int n_adsymbol;
extern symbol_t adsymbol[M_SYMBOL];
