//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 25th September, 2014
//
//

package worker4math.hktex2;

import java.util.ArrayList;

public class Source {


	public static final ArrayList<String> lineblock = new ArrayList<String>();

	public void content (){

    lineblock.add("!begin{title}"
			   +          "!title Brief Introduction to HKtex (Version 2.03)!!"
			   +          "!author by Kwanleung Tse!!"
			   +          "!email email: worker4math@gmail.com!!"
			   +          "http://www.worker4math.fatcow.com!!"
			   +          "!date 25th September, 2014!!"
			   +          "!text (Notice : This brief introduction is taken from Version 2.00.!!"
			   +          "Updated introduction will be released afterward.)!!"
			   +          "!end{title}"
			   +          "!end{lineblock}");   
		lineblock.add("!ss"			   
			   +         "!noindent $!underlinetext{!large{!bf{!navy{1. Introduction}}}}$ HKtex is a formula parsing software written"
			   +         " for mobile phones and tablets using Android operating system. It is developed using Google Eclipse and thus"
			   +         " allows app developers and book writers to import the files easily. There is now a clear distinction"
			   +         " between books and apps.  It is difficult to add interactive elements into books written with"
			   +         " Tex/Latex and, in creating apps, there is no comprehensive formula parsing software easily"
			   +         " imported by Eclipse. The purpose of HKtex is to remove this distinction. HKtex will, intentionally and eventually, enable"
			   +         " developers to create apps which are also complete books by themself, and writers to write books which contain interactive examples, exercises and graphics. In writing HKtex, i understand"
			   +         " the popularity of Tex/Latex and thus make HKtex as compatible to Tex/Latex as possible. However,"
			   +         " some differences exist. I will try to explain them in this document. Before moving to next section,"
			   +         " i wish to emphasize that this is an ongoing endeavour and is by no mean a completed work. However," 
			   +         " i feel that it is presentable and thus release it to solicit feedback to make it better. !! "
			   +         "!end{lineblock}"); 
		lineblock.add("!begin{lineblock}"
			   +          "!vspace{20}"
			   +          "!noindent $!underlinetext{!large{!bf{!navy{2. Program structure}}}}$ HKtex is written with java. Since there are"
			   +          " many situations to consider, this program is inherently difficult. Avoid"
			   +          " changing the files, except the four input files: MainActivity.java"
			   +          " ,Header.java, Source.java, and Symbol.java. !!"
			   +         "!end{lineblock}"); 
		lineblock.add("!begin{lineblock}"			   
			   +          "!vspace{10}"
			   +          " The content of the document is stored in Content.java. The content is broken up into blocks. Your document can be contained inside one"
			   +          " huge block or many small blocks. Breaking up into smaller blocks allow you to parse a particular" 
			   +          " block. Each block begins with !begin{blockline} and ends with !end{blockline}. The !begin{blockline}"
			   +          " command can be omitted but the !end{blockline} command must be there. Besides, you can not begin an"
			   +          " environment, e.g. eqnarray, in one block and end the environment in another block. "
			   +          " The Header.java file contains page layout informations, for example, margins, gap width between lines, etc."
			   +          " You can have more than one Header.java file and use different one in different situation."
			   +          " The Symbol.java file contains symbols. Comment out those symbols that are not used for the purpose of efficiency. !!"
			   +          "!end{lineblock}");  
		lineblock.add("!begin{lineblock}"
			   +          "!vspace{20}"
			   +          "!noindent $!underlinetext{!large{!bf{!navy{3. Environment}}}}$  There are seven different environments in HKtex: text, eqnarray,"
			   +          " equation, table, verbatim, graphics and graphicstable. By default, the environment is text and no further specification is needed. To enclose"
			   +          " a different environment within text, use the begin and end commands. For example, the following lines : !!"
			   +          "!vspace{10}"
			   +          "!end{lineblock}"); 
		lineblock.add("!begin{lineblock}"			   
			   +          "!begin{verbatim}"
			   +          "!begin{eqnarray}{rcl}!!"
			   +          "y&=&!int!^{x!_{2}}!_{x!_{1}} 2xdx !!"
		   	   +          "&=& x!_{2}!^{2} - x!_{1}!^{2} !!" 
			   +          "!end{eqnarray}!!"
			   +          "!end{verbatim}" 
			   +          "!vspace{10}"
			   +          "!noindent will give : !!"
			   +          "!end{lineblock}");  
		lineblock.add("!begin{lineblock}"
			   +          "!begin{eqnarray}{rcl}"
			   +          "y&=&!int!^{x!_{2}}!_{x!_{1}} 2xdx !!"
			   +          "&=& x!_{2}!^{2} - x!_{1}!^{2} !!"	  
			   +          "!end{eqnarray}"
			   +          "!vspace{10}"
			   +          "Inside eqnarray, equation and table environment, the lines are automatically centered. HKtex does not provide"
			   +          " other alignment. However, for text environment, the following alignment are possible : !!"
			   +          "!vspace{10}"
			   +          "!begin{center}"
			   +          "centered text !!"
			   +          "!end{center}"
			   +          "!noindent left-aligned text !!"
			   +          "!begin{alignright}"
			   +          "right-aligned text!!"
			   +          "!end{alignright}"
			   +          "!noindent HKtex does not hyphenate the center-aligned or right-aligned text.!!"
			   +          "!vspace{10}" 
			   +          "!end{lineblock}"); 
		lineblock.add("!begin{lineblock}"
			   +          "To change the fontsize, type !Huge, !huge, !Large, !large, !normalsize, !small, !scriptsize or !tiny at the"
			   +          " beginning of line, as in the following :!!" 
			   +          "!Huge"
			   +          "!noindent Huge text!!"
			   +          "!huge"
			   +          "!noindent huge text!!"
			   +          "!Large"
			   +          "!noindent Large text!!"
			   +          "!large"
			   +          "!noindent large text!!"
			   +          "!normalsize"
			   +          "!noindent normalsize text!!"
			   +          "!small"
			   +          "!noindent small text!!"
			   +          "!scriptsize"
			   +          "!noindent scriptsize text!!"
			   +          "!tiny"
			   +          "!noindent tiny text!!"
			   +          "!normalsize"
			   +          "The default font size is defined in header.java. It cannot be bigger than the maximum size, also specified in"
			   +          " header.java. However, since the maximum can be adjusted. The size is in fact not bounded.!!"
			   +          "!end{lineblock}"); 			  
		lineblock.add("!begin{lineblock}"  
			   +          "!vspace{10}"
			   +          "The font type can be specified by the command !ss, !it, !bf, !mo, also at the beginning of the line. They stand for"
			   +          " serif, italic, bold, and mono. The next one is !asana, used for typing symbol. The last one is !rm used only for"
			   +          " trigonometric, logarithmic and hyperbolic functions. Do not specify the last two.!!"
			   +          "!it"
			   +          "!noindent italic text!!"
			   +          "!bf"
			   +          "!noindent bold text!!"
			   +          "!mo"
			   +          "!noindent monospace text!!"
			   +          "!ss"
			   +          "!end{lineblock}"); 	 
		lineblock.add("!begin{lineblock}"
			   +          "!vspace{20}"
			   +          "!noindent $!underlinetext{!large{!bf{!navy{4. Table}}}}$ The command for constructing a table is similar to Tex/Latex. However,"
			   +          " the table in HKtex is more primitive. It does not provide table within table. The following is a simple example :!!"
			   +          "!vspace{10}"
			   +          "!begin{table}{|r|c|l|}!hline"
			   +          "!begin{caption}"
			   +          "Table 1. Infinite products of hyperbolic functions!!"
			   +          "!end{caption}"
			   +          "&Hyperbolic functions& Infinite Products!!!hline!hline"
			   +          "1&!sinh z& z!bigprod!^{!infty}!_{k=1}!lparen{1 + !frac{z!^{2}}{k!^{2}!pi!_{2}}}!!!hline "
			   +          "2&!cosh z&!bigprod!^{!infty}!_{k=1}!lbrack{1 + !frac{4z!^{2}}{(2k-1)!^{2}!pi!_{2}}}!!!hline"
			   +          "!end{table}" 
			   +          "!end{lineblock}"); 
		lineblock.add("!begin{lineblock}"
			   +          "!vspace{10}"
			   +          "!noindent Using tabular within table is allowed, as demonstrated in the following example:!!"  
			   +          "!vspace{10}"
			   +          "!begin{table}{|r|l|}!hline"
			   +          "& Laplace's equations!!!hline!hline"
			   +          "Cartesian Coordinates& !tabular{l}{!line{{!frac{!partial!^{2}u}{!partial x!^{2}} + !frac{!partial!^{2}u}{!partial y!^{2}} "
			   +          "=}}!line{{!hspace{10} !frac{!partial!^{2}v}{!partial x!^{2}} + !frac{!partial!^{2}v}{!partial y!^{2}} = 0}}} !!!hline"
			   +          "Polar Coordinates& !tabular{l}{!line{{r!frac{!partial}{!partial r}!lparen{r!frac{!partial u}{!partial r}}+"
			   +          "!frac{!partial!^{2}u}{!partial!vartheta!^{2}} =}}!line{{!hspace{10}r!frac{!partial}{!partial r}"
			   +          "!lparen{r!frac{!partial v}{!partial r}}+!frac{!partial!^{2}v}{!partial!vartheta!^{2}} = 0}}}!!!hline"
			   +          "!begin{caption}"
			   +          "Table 2. Laplace's equations!!"
			   +          "!end{caption}"			   
			   +          "!end{table}" 
			   +          "!noindent Note that there is also no tabular within tabular. !!"
			   +          "!end{lineblock}"); 
		lineblock.add("!begin{lineblock}"
			   +          "HKtex does not have fbox, this can be compensated somewhat by using table and draws only the lines on the outer boundaries. For example:!!"
			   +          "!begin{table}{|c|}!hline"
               +          "The Jacobian of a transformation is :!!"
		       +          "!frac{!partial(x,y)}{!partial(u,v)}=!vert{!tabular{cc}{!line{{!frac{!partial x}{!partial u}}{!frac{!partial x}{!partial v}}}!line{{!frac{!partial y}{!partial u}}{!frac{!partial y}{!partial v}}}}}!!!hline"
			   +          "!end{table}" 
		       +          "Inside table, the default is symbol mode. If text mode is needed, enclosed it within a mbox.!!"
			   +          "!end{lineblock}"); 
		lineblock.add("!begin{lineblock}"
			   +          "!vspace{10}"
			   +          "!noindent $!underlinetext{!large{!bf{!navy{5. Eqnarray and equation}}}}$ Equation array is like table except that the font"
			   +          " is italic by default. Besides, neither vertical line nor horizontal line will be drawn. Equation is an eqnarray"
			   +          " with just one line. You can specified an equation just like an eqnarray. This is allowed in HKtex. The following"
			   +          " provides a few examples of equation and eqnarray. !!"
			   +          "!vspace{10}"
			   +          "!noindent Lagrange's Expansion Formula :!!"
			   +          "!begin{equation}"
			   +          "x=x!_{0}+!bigbigsum!^{!infty}!_{k=1}!frac{(y-y!_{0})!^{k}}{k!exclam}!lbrace{!frac{d!^{k-1}}{dx!^{k-1}}"
			   +          "!lparen{g'(x)!lbrace{!frac{x-x!_{0}}{f(x)-y!_{0}}}!^{k}}}!_{x=x!_{0}}!!"
			   +          "!end{equation}"
			   +          "!end{lineblock}"); 
		lineblock.add("!begin{lineblock}"
			   +          "!vspace{10}"
			   +          "!noindent Continued fraction :!!"
			   +          "!Large"
			   +          "!begin{equation}"
			   +          "f=b!_{0}+!frac{a!_{1}}{b!_{1}+!frac{a!_{2}}{b!_{2}+!frac{a!_{3}}{b!_{3}+!frac{a!_{4}}{b!_{4}+...}}}}!!"
			   +          "!end{equation}"
		       +          "!normalsize"
			   +          "!begin{center}"
			   +          "(arbitrary pagebreak here !)!!"
			   +          "!end{center}"
			   +          "!pagebreak"
		       +          "!noindent Algebraic equation :!!"
		       +          "!huge"  
			   +          "!begin{equation}"
			   +          "y= !lbrace{!tabular{lr}{!line{{0}{!hspace{20}x = 1}}!line{{!frac{!vert{x-1}}{!fourthroot{!vert{x-1}!^{3}}}}{x !ne 1}}}}!.!!"
		       +          "!end{equation}"
			   +          "!normalsize"			
			   +          "!noindent Fluid equations :!!"
			   +          "!begin{eqnarray}{rclr}"
			   +          "!nabla !cdot !bf{U} &=& 0 & !hspace{50} !mbox{continuity}!!"
			   +          "!underbrace{!frac{DU!_{j}}{Dt}}!_{!tiny{!lparen{!tabular{c}{!line{{time}}!line{{derivative}}}}}} &=&"
			   +          "-!overbrace{!frac{1}{!rho}!nabla p}!^{!tiny{!lparen{!tabular{c}{!line{{pressure}}!line{{term}}}}}} +"
			   +          "!underbrace{!nu!nabla!^{2}!bf{U}}!_{!tiny{!lparen{!tabular{c}{!line{{diffusion}}!line{{term}}}}}} & !mbox{momentum}!!"
			   +          "!end{eqnarray}" 
			   +          "!end{lineblock}"); 
	lineblock.add("!begin{lineblock}"
			   +          "!vspace{10}"
			   +          "!noindent $!underlinetext{!large{!bf{!navy{6. Graphics and Graphicstable}}}}$ Figures can be included within the !begin{graphics} and !end{graphics} commands.!!"
			   +          "!begin{graphics}"
               +          "leftarrow.png!!"
               +          "!begin{caption}"
			   +          "Figure 1. The left arrow.  !!"
			   +          "!end{caption}"
			   +          "!end{graphics}"
			   +          "!vspace{10}"
			   +          " If there are more than one figures, then the !begin{graphicstable} and !end{graphicstable} commands can be used. !!"
			   +          "!begin{graphicstable}{cc}"
			   +          "!begin{caption}"
			   +          "Figure 2. The left arrow, the right arrow, !!"
               +          " the left end arrow and the right end arrow. !!"
			   +          "!end{caption}"
               +          "leftarrow.png & rightarrow.png!!"
               +          "leftendarrow.png & rightendarrow.png!!"
			   +          "!end{graphicstable}"	   
			   +          "!end{lineblock}"); 			   
		lineblock.add("!begin{lineblock}"
			   +          "!vspace{10}"
			   +          "!noindent $!underlinetext{!large{!bf{!navy{7. Color}}}}$ Color can only be specified within each environment (except verbatim)."
			   +          " The following table is a list of color predefined in HKtex. You can easily add another color by adding another entry in the Color.java file."
			   +          " The name should not be the same as any other command name. For example the color tan is missing because it has the same name as the "
			   +          " trignometric function tan.!!"
			   +          "!tiny"
		       +          "!vspace{10}"
		       +          "!begin{table}{|c|c|c|c|c|c|}!hline"
			   +          "!begin{caption}"
			   +          "Table 3. Color table!!"
			   +          "!end{caption}"
		       +          "!aliceblue{aliceblue}&!antiquewhite{antiquewhite}&!aquamarine{aquamarine}&!aure{aure}&!banana{banana}&!beige{beige} !!!hline"
		       +          "!blanchedalmond{blanchedalmond} &!blueviolet{blueviolet}&!blue{blue}&!brick{brick}&!brown{brown}&!burlywood{burlywood}!!!hline"
		       +          "!cadetblue{cadetblue}&!cadmiumorange{cadmiumorange}&!cadmiumyellow{cadmiumyellow}&!carrot{carrot}&!black{black}&!burntumber{burntumber}!!!hline"
		       +          "!chocolate{chocolate}&!cobalt{cobalt}&!cobaltgreen{cobaltgreen}&!coldgrey{coldgrey}&!cornflowerblue{cornflowerblue} &!cornsilk{cornsilk}  !!!hline"
		       +          "!crimson{crimson}&!cyan{cyan}&!darkgoldenrod{darkgoldenrod}&!darkgray{darkgray}&!darkgreen{darkgreen}&!darkkhaki{darkkhaki}!!!hline"
		       +          "!bisque{bisque}&!burntsienna{burntsienna}&!chartreuse{chartreuse}&!coral{coral}&!darkolivegreen{darkolivegreen} &!darkorange{darkorange} !!!hline"
		       +          "!darkorchid{darkorchid} &!darksalmon{darksalmon}&!darkseagreen{darkseagreen}&!darkslateblue{darkslateblue}&!darkslategray{darkslategray}&!darkturquoise{darkturquoise}!!!hline "
		       +          "!ddarkviolet{ddarkviolet}&!deeppink{deeppink}&!deepskyblue{deepskyblue}&!dimgray{dimgray}&!dodgerblue{dodgerblue}&!eggshell{eggshell}!!!hline"
		       +          "!emeraldgreen{emeraldgreen}&!firebrick{firebrick}&!flesh{flesh}&!floralwhite{floralwhite}&!forestgreen{forestgreen}&!gainsboro{gainsboro}!!!hline"
		       +          "!ghostwhite{ghostwhite}&!gold{gold}&!goldenrod{goldenrod}&!gray{gray}&!green{green}&!greenyellow{greenyellow}!!!hline"
		       +          "!honeydew{honeydew}&!hotpink{hotpink}&!indianred{indianred}&!indigo{indigo}&!ivory{ivory}&!ivoryblack{ivoryblack}!!!hline"
               +          "!khaki{khaki}&!lavender{lavender}&!lavenderblush{lavenderblush}&!lawngreen{lawngreen}&!lemonchiffon{lemonchiffon}&!lightblue{lightblue}!!!hline"
		       +          "!lightcoral{lightcoral}&!lightcyan{lightcyan}&!lightgrey{lightgrey}&!lightgoldenrod{lightgoldenrod}&!lightgoldenrodyellow{lightgoldenrodyellow}&!lightpink{lightpink}!!!hline"
               +          "!lightsalmon{lightsalmon}&!lightseagreen{lightseagreen}&!lightskyblue{lightskyblue}&!lightslateblue{lightslateblue}&!lightslategray{lightslategray}&!lightsteelblue{lightsteelblue}!!!hline"
		       +          "!lightyellow{lightyellow}&!limegreen{limegreen}&!linen{linen}&!magenta{magenta}&!manganeseblue{manganeseblue}&!maroon{maroon}!!!hline"
               +          "!mediumorchid{mediumorchid}&!mediumpurple{mediumpurple}&!mediumseagreen{mediumseagreen}&!mediumslateblue{mediumslateblue}&!mediumspringgreen{mediumspringgreen}&!mediumturquoise{mediumturquoise}!!!hline"
		       +          "!mediumvioletred{mediumvioletred}&!melon{melon}&!midnightblue{midnightblue}&!mint{mint}&!mintcream{mintcream}&!mistyrose{mistyrose}!!!hline"
               +          "!moccasin{moccasin}&!navajowhite{navajowhite}&!navy{navy}&!oldlace{oldlace}&!olivedrab{olivedrab}&!olive{olive}!!!hline"
               +          "!orange{orange}&!orangered{orangered}&!orchid{orchid}&!palegoldenrod{palegoldenrod}&!palegreen{palegreen}&!palevioletred{palevioletred}!!!hline"
               +          "!paleturquoise{paleturquoise}&!papayawhip{papayawhip}&!peachpuff{peachpuff}&!peacock{peacock}&!pink{pink}&!plum{plum}!!!hline"
               +          "!powderblue{powderblue}&!purple{purple}&!raspberry{raspberry}&!rawsienna{rawsienna}&!red{red}&!royalblue{royalblue}!!!hline"
               +          "!rosybrown{rosybrown}&!salmon{salmon}&!sandybrown{sandybrown}&!sapgreen{sapgreen}&!seashell{seashell}&!sepia{sepia}!!!hline"
               +          "!sienna{sienna}&!silver{silver}&!skyblue{skyblue}&!slateblue{slateblue}&!slategray{slategray}&!snow{snow}!!!hline"
               +          "!springgreen{springgreen}&!steelblue{steelblue}&!teal{teal}&!thistle{thistle}&!tomato{tomato}&!turquoise{turquoise}!!!hline"
               +          "!turquoiseblue{turquoiseblue}&!violet{violet}&!violetred{violetred}&!warmgrey{warmgrey}&!wheat{wheat}&!white{white}!!!hline" 
               +          "!whitesmoke{whitesmoke}&!yellow{yellow}&&&&!!!hline"
               +          "!end{table}"
		       +          "!normalsize"
		       +          "!vspace{10}"
		       +          "!noindent If table pass beyond the bottom of the view container, it will be move to the next one. However, if"
		       +          " the scrollview in Header.java is specified as true, the table will not be moved.!!"
			   +          "!end{lineblock}"); 
		lineblock.add("!begin{lineblock}"
			   +          "!vspace{10}"
			   +          "!noindent $!underlinetext{!large{!bf{!navy{8. Math Symbols}}}}$ There are over one thousand symbols in HKtex corresponding to"
			   +          " the asana-math font with four unicode digits. Besides, common trigonometric, logarithmic, hyperbolic functions"
			   +          " and limit are regarded as symbol. They are classified in different types for the purpose of putting the superscript"
			   +          " and subscript. Not every symbol has superscript nor subscript. For example, if you assign a superscript to underbrace,"
			   +          " the program will stop parsing and an error message will be shown. Refer to symbol.java for the avialable symbols."
			   +          " For optimization, uncomment any symbol that is needed, and comment out any symbol that is not needed.  !!"
			   +          "!vspace{10}"
			   +          "!noindent $!underlinetext{!large{!bf{!navy{9. Final Comment}}}}$ HKtex is very much an ongoing endeavour. A huge amount"
			   +          " of work is waiting to be done, e.g. increasing its efficiency and making it more compatible with Tex/Latex."
			   +          " If you have any comment that are helpful to this course, please"
			   +          " don't hesitate to contact me. I hope my effort is helpful to you and thank you for your attention.  !!"
			   +          "!end{lineblock}");   
			}
			}
