/*****

      $Source: d:\gunther\source\grc/RCS/main.c,v $
      $Author: gunther $
      $Date: 1996/01/02 23:17:24 $
      $Revision: 1.4 $

	Changed by: Fred Kiefer (kiefer@isys.de) 1996/6/2

 *****/

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <unistd.h>
#include <errno.h>
#include "port.h"
#include "spawn.h"

#include "rcutils.h"
#include "resnt.h"
#include "rcompile.h"
#include "wstring.h"

extern ResourceTail globalTail;

extern FILE *yyin;
extern int yyparse();
/*extern int yydebug;*/

char *program_name;		/* the name of the program */
int _verbose = 0;		/* verbose mode, default = no */
int _debug = 0;			/* debug mode, default = no */

/* We should rather use a temporary directory to create the file */
static const char *res_tmp_cpp = "res$$cpp.res";
char *cpp = "cpp.exe";	/* name of the preprocessor */
#define MAX_DEFINES 10
char *defines[MAX_DEFINES];		/* Defines for preprocessor */	
int def_ind = 1;		/* Index of defines */
int ignore_include = 0;

int
run_preprocessor(const char *cpp, const char *rcfile, 
		 const char *res_tmp)
{
	/* execute the preprocessor */
	debug(("running preprocessor"))

	/* "-I dir", search include files in dir */
	/* "-nostdinc", dont search standard include dirs */
	if (spawnlp(P_WAIT, cpp, "cpp", "-DRC_INVOKED", 
		    rcfile, "-o", res_tmp, NULL) == -1)
	{
		char err[256];
		sprintf(err, "Error executing command '%s %s -o %s', code = %d\n", cpp, 
			rcfile, res_tmp, errno);
		yyerror(err);
		return GRC_ERR_CPP;
	}
	return GRC_OK;
}

int
make_res(const char *rcfile, const char *resfile)
{
  int retcode;

  if ((retcode = run_preprocessor(cpp, rcfile, 
				  res_tmp_cpp)) != GRC_OK){
    return retcode;
  }

	/* open the binary resource file */
	if (StartRes(resfile) != GRC_OK){
		remove(res_tmp_cpp);
		return GRC_ERR_OPEN;
	}

	/* open the resource script for parsing */
	yyin = fopen(res_tmp_cpp, "rt");

	if(!yyin)	{
		open_error(res_tmp_cpp);
		FinishRes(0);
		remove(resfile);
		remove(res_tmp_cpp);
		return GRC_ERR_OPEN;
	}

	debug(("starting parsing"))
	/*yydebug = 1;*/

	/* compile the resource script (bison-generated code) */
	if(yyparse())
	{
		yyerror("Parsing of resource script failed.");
		fclose(yyin);
		FinishRes(0);
		remove(resfile);
		remove(res_tmp_cpp);
		return GRC_ERR_PARSE;
	}

	debug(("finished parsing"))
	fclose(yyin);
	remove(res_tmp_cpp);

	/* write string tables to binary resource file */
	if((retcode = FinishRes(1)) != GRC_OK)
	{
		remove(resfile);
		return retcode;
	}

	return GRC_OK;
}

void usage()
{
    fprintf(stderr, "usage: %s <options> rcfile\n\n", program_name);
    fprintf(stderr, "\toptions:\n");
    fprintf(stderr, "\t-o res_file\t.res output file\n");
    fprintf(stderr, "\t-l id\t\tlanguage id\n");
    fprintf(stderr, "\t-v\t\tverbose mode\n");
    fprintf(stderr, "\t-r\t\t(optional) build only .res\n");
    fprintf(stderr, "\t-G\t\t(extention) debug mode\n");
    fprintf(stderr, "\t-c cpp_file\t(extention) name of preprocessor\n");
/*    fprintf(stderr, "\t-d symbol\tdefine a symbol for preprocessor\n");
    fprintf(stderr, "\t-i dir\tinclude directory\n");
    fprintf(stderr, "\t-x\t\tdo not use INCLUDE environment\n"); */
}

int 
main(int argc, char **argv)
{
	char *resfile = NULL;
	char *input = NULL;
	int opt;

	program_name = argv[0];

	while((opt = getopt(argc, argv, "o:c:l:vrGt:i:x")) != EOF) {
		switch (opt){
			case 'o':	resfile = optarg;
						break;
			case 'c':	cpp = optarg;
						break;
			case 'l':	/* set language */
						globalTail.LanguageId= strtol(optarg, 0, 0);
						break;
			case 'v':	_verbose = 1;
						break;
			case 'r':	break;
			case 'G':	_debug = 1;
						break;
			case 't':	if (def_ind < MAX_DEFINES) {
							defines[def_ind] = optarg;
							def_ind++;
						}
						break;
			case 'i':	break;
			case 'x':	ignore_include = 1;
			  break;
			case '?':	usage();
						return -1;
		}						
	}
	
	if (optind < argc)
		input = argv[optind];

	if(!input){
		usage();
		return -1;
	}

	if(!resfile){
		char *p;
		int len = strlen(input);

		resfile = (char *) xmalloc(len+4);
		strcpy(resfile, input);
		p = strrchr(resfile, '.');
		if (!p){
			strcat(resfile, ".res");
		}
		else{
			strcpy(p, ".res");
		}
	}

	return make_res(input, resfile);
}
