/* chmod.c (emx+gcc) -- Copyright (c) 1990-1993 by Eberhard Mattes */

#include <sys/doscalls.h>
#include <io.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "djio.h"

int chmod (const char *name, int pmode)
{
    int attr, rc;

    attr = dos_getfattr(name, &attr);
    if (attr < 0)
	return (-1);
    if (pmode & S_IWRITE)
	attr &= ~1;
    else
	attr |= 1;
    rc = dos_setfattr(name, attr);
    if (rc >= 0)
	rc = 0;
    return (rc);
}
