#define NOGDI
#define NOUSER
#define NOKERNEL
#include <windows.H>
#include <sys/rsxw32.h>
#include <sys/sv_call.h>

/* callback function from syscalls.s */
extern int wnd_dlg_proc32(void);    /* callback for Windows and Dialogs */
extern int callb32_argc5(void);     /* callback for 5 args */
extern int callb32_argc4(void);     /* callback for 4 args */
extern int callb32_argc3(void);     /* callback for 3 args */
extern int callb32_argc2(void);     /* callback for 2 args */

/* globals */
ULONG	    _rsxw32_callback;
ULONG	    _rsxw32_ds;
struct {
    ULONG eip;
    ULONG cs;
}	    _rsxw32_entry;

ULONG _sys_heap_begin;
ULONG _sys_heap_end;
ULONG _sys_base_addr;
ULONG _sys_last_addr;
ULONG _sys_first_sel;

static PrgInfoBlock prg_info_block;

void get_classes_data(ULONG *class_off, ULONG *bytes, ULONG *index);

void rsxw32_init(void)
{
    static inited = 0;

    if (inited)
	return;
    inited = 1;

    prg_info_block.WinProc32 = (ULONG) wnd_dlg_proc32;
    prg_info_block.callback_argc5 = (ULONG) callb32_argc5;
    prg_info_block.callback_argc4 = (ULONG) callb32_argc4;
    prg_info_block.callback_argc3 = (ULONG) callb32_argc3;
    prg_info_block.callback_argc2 = (ULONG) callb32_argc2;

    SV_CALL(M_WINMAIN_INIT, (ULONG) &prg_info_block);

    _rsxw32_callback = prg_info_block.WinProc16;
    _rsxw32_ds = prg_info_block.extender_ds;
    _rsxw32_entry.cs = prg_info_block.rsxw32_cs;
    _rsxw32_entry.eip = prg_info_block.rsxw32_eip;
    _sys_heap_begin = prg_info_block.heap_begin;
    _sys_heap_end = prg_info_block.heap_end;
    _sys_base_addr = prg_info_block.user_base_addr;
    _sys_last_addr = prg_info_block.user_prg_end;
    _sys_first_sel = prg_info_block.user_first_sel;

    _sys_init_selectors();
}

void rsxw32_uninit(void)
{
    static uninited = 0;

    if (uninited)
	return;
    uninited = 1;

    _sys_free_selectors();
}

int	    __argc;
char **     __argv;
char **     __env;

int main(int argc,char **argv,char **env)
{
    rsxw32_init();	/* uninit at __exit() */

    __argc = argc;
    __argv = argv;
    __env = env;

    return  WinMain(
	    prg_info_block.hInst,
	    prg_info_block.hPrevInst,
	    prg_info_block.lpCmdLine,
	    prg_info_block.nCmdShow);
}
