---
myst:
  html_meta:
    keywords: LaTeX, programmation, erreurs, messages d'erreur de LaTeX,
              dollar oublié, problème d'accolades, curly brackets, 
              mode mathématique
---

# Que signifie l'erreur : "Extra }, or forgotten \$" ?

- **Message** : `Extra }, or forgotten $`
- **Origine** : TeX

Cette erreur est déclenchée lorsque des délimiteurs 
de formules mathématiques (par exemple `$...$`, `\[...\]`) et des accolades
de groupes ne sont pas correctement emboîtés. TeX pense qu'il a trouvé 
un `}` superflu, comme dans `$x}$`, et l'ignore. Alors que dans cet exemple
 la suppression de l'accolade fermante est le bon choix, ce ne serait pas 
 le cas avec `\mbox\(a}`. Ici, un `\)` fermant a été oublié et le fait 
 de supprimer le `}` va produire des erreurs supplémentaires.


:::{sources}
- [FAQ erreurs - Lettre E](https://latex.developpez.com/faq/erreurs?page=E), 
  sur le site [Developpez.com](https://latex.developpez.com)
- *[LaTeX Companion](https://www.latex-project.org/help/books/#french)*, 
  2e édition, Frank Mittelbach, Michel Goossens, Johannes Braams, 
  David Carlisle, Chris Rowley (Pearson, 2006)
:::