/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigationevent;

import androidx.annotation.MainThread;
import androidx.annotation.RestrictTo;
import androidx.navigationevent.NavigationEvent;
import androidx.navigationevent.NavigationEventHandler;
import androidx.navigationevent.NavigationEventHistory;
import androidx.navigationevent.NavigationEventInput;
import androidx.navigationevent.NavigationEventProcessor;
import androidx.navigationevent.NavigationEventTransitionState;
import androidx.navigationevent.OnBackCompletedFallback;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 =2\u00020\u0001:\u0002<=B\u001d\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\tJ\u001e\u0010%\u001a\u00020&2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001a2\b\b\u0002\u0010(\u001a\u00020)H\u0007J\u0019\u0010*\u001a\u00020&2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0000\u00a2\u0006\u0002\b+J\u0010\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020\u001cH\u0007J\u0018\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0007J\u0010\u0010.\u001a\u00020&2\u0006\u0010-\u001a\u00020\u001cH\u0007J'\u0010/\u001a\u00020&2\u0006\u0010-\u001a\u00020\u001c2\u0006\u00100\u001a\u00020)2\b\u00101\u001a\u0004\u0018\u000102H\u0000\u00a2\u0006\u0002\b3J%\u00104\u001a\u00020&2\u0006\u0010-\u001a\u00020\u001c2\u0006\u00100\u001a\u00020)2\u0006\u00101\u001a\u000202H\u0000\u00a2\u0006\u0002\b5J\u001d\u00106\u001a\u00020&2\u0006\u0010-\u001a\u00020\u001c2\u0006\u00100\u001a\u00020)H\u0000\u00a2\u0006\u0002\b7J\u001d\u00108\u001a\u00020&2\u0006\u0010-\u001a\u00020\u001c2\u0006\u00100\u001a\u00020)H\u0000\u00a2\u0006\u0002\b9J\b\u0010:\u001a\u00020&H\u0007J\b\u0010;\u001a\u00020&H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u000b8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR&\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\f\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001e8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010!\u00a8\u0006>"}, d2={"Landroidx/navigationevent/NavigationEventDispatcher;", "", "parent", "onBackCompletedFallback", "Landroidx/navigationevent/OnBackCompletedFallback;", "<init>", "(Landroidx/navigationevent/NavigationEventDispatcher;Landroidx/navigationevent/OnBackCompletedFallback;)V", "()V", "(Landroidx/navigationevent/OnBackCompletedFallback;)V", "(Landroidx/navigationevent/NavigationEventDispatcher;)V", "isDisposed", "", "()Z", "value", "isEnabled", "setEnabled", "(Z)V", "sharedProcessor", "Landroidx/navigationevent/NavigationEventProcessor;", "getSharedProcessor$navigationevent", "()Landroidx/navigationevent/NavigationEventProcessor;", "childDispatchers", "", "getChildDispatchers$navigationevent", "()Ljava/util/Set;", "handlers", "Landroidx/navigationevent/NavigationEventHandler;", "inputs", "Landroidx/navigationevent/NavigationEventInput;", "transitionState", "Lkotlinx/coroutines/flow/StateFlow;", "Landroidx/navigationevent/NavigationEventTransitionState;", "getTransitionState", "()Lkotlinx/coroutines/flow/StateFlow;", "history", "Landroidx/navigationevent/NavigationEventHistory;", "getHistory", "addHandler", "", "handler", "priority", "", "removeHandler", "removeHandler$navigationevent", "addInput", "input", "removeInput", "dispatchOnStarted", "direction", "event", "Landroidx/navigationevent/NavigationEvent;", "dispatchOnStarted$navigationevent", "dispatchOnProgressed", "dispatchOnProgressed$navigationevent", "dispatchOnCompleted", "dispatchOnCompleted$navigationevent", "dispatchOnCancelled", "dispatchOnCancelled$navigationevent", "dispose", "checkInvariants", "Priority", "Companion", "navigationevent"})
public final class NavigationEventDispatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private NavigationEventDispatcher parent;
    @Nullable
    private final OnBackCompletedFallback onBackCompletedFallback;
    private boolean isDisposed;
    private boolean isEnabled;
    @NotNull
    private final NavigationEventProcessor sharedProcessor;
    @NotNull
    private final Set<NavigationEventDispatcher> childDispatchers;
    @NotNull
    private final Set<NavigationEventHandler<?>> handlers;
    @NotNull
    private final Set<NavigationEventInput> inputs;
    public static final int PRIORITY_OVERLAY = 0;
    public static final int PRIORITY_DEFAULT = 1;

    private NavigationEventDispatcher(NavigationEventDispatcher parent, OnBackCompletedFallback onBackCompletedFallback) {
        block1: {
            this.parent = parent;
            this.onBackCompletedFallback = onBackCompletedFallback;
            this.isEnabled = true;
            Object object = this.parent;
            if (object == null || (object = ((NavigationEventDispatcher)object).sharedProcessor) == null) {
                object = new NavigationEventProcessor();
            }
            this.sharedProcessor = object;
            this.childDispatchers = new LinkedHashSet();
            this.handlers = new LinkedHashSet();
            this.inputs = new LinkedHashSet();
            NavigationEventDispatcher navigationEventDispatcher = this.parent;
            if (navigationEventDispatcher == null) break block1;
            ((Collection)navigationEventDispatcher.childDispatchers).add(this);
        }
    }

    public NavigationEventDispatcher() {
        this(null, null);
    }

    public NavigationEventDispatcher(@NotNull OnBackCompletedFallback onBackCompletedFallback) {
        Intrinsics.checkNotNullParameter((Object)onBackCompletedFallback, (String)"onBackCompletedFallback");
        this(null, onBackCompletedFallback);
    }

    public NavigationEventDispatcher(@NotNull NavigationEventDispatcher parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this(parent, null);
    }

    private final boolean isDisposed() {
        NavigationEventDispatcher navigationEventDispatcher = this.parent;
        return (navigationEventDispatcher != null ? navigationEventDispatcher.isDisposed() : false) ? true : this.isDisposed;
    }

    public final boolean isEnabled() {
        NavigationEventDispatcher navigationEventDispatcher = this.parent;
        return (navigationEventDispatcher != null ? !navigationEventDispatcher.isEnabled() : false) ? false : this.isEnabled;
    }

    public final void setEnabled(boolean value) {
        this.checkInvariants();
        if (this.isEnabled == value) {
            return;
        }
        this.isEnabled = value;
        this.sharedProcessor.refreshEnabledHandlers();
    }

    @NotNull
    public final NavigationEventProcessor getSharedProcessor$navigationevent() {
        return this.sharedProcessor;
    }

    @NotNull
    public final Set<NavigationEventDispatcher> getChildDispatchers$navigationevent() {
        return this.childDispatchers;
    }

    @NotNull
    public final StateFlow<NavigationEventTransitionState> getTransitionState() {
        return this.sharedProcessor.getTransitionState();
    }

    @NotNull
    public final StateFlow<NavigationEventHistory> getHistory() {
        return this.sharedProcessor.getHistory();
    }

    @MainThread
    @JvmOverloads
    public final void addHandler(@NotNull NavigationEventHandler<?> handler, int priority) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.checkInvariants();
        if (this.handlers.add(handler)) {
            this.sharedProcessor.addHandler(this, handler, priority);
        }
    }

    public static /* synthetic */ void addHandler$default(NavigationEventDispatcher navigationEventDispatcher, NavigationEventHandler navigationEventHandler, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        navigationEventDispatcher.addHandler(navigationEventHandler, n);
    }

    public final void removeHandler$navigationevent(@NotNull NavigationEventHandler<?> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (this.handlers.remove(handler)) {
            this.sharedProcessor.removeHandler(handler);
        }
    }

    @MainThread
    public final void addInput(@NotNull NavigationEventInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.checkInvariants();
        if (this.inputs.add(input)) {
            this.sharedProcessor.addInput(this, input, -1);
        }
    }

    @MainThread
    public final void addInput(@NotNull NavigationEventInput input, int priority) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.checkInvariants();
        if (!(priority == 1 || priority == 0)) {
            boolean bl = false;
            String string = "Unsupported priority value: " + priority;
            throw new IllegalArgumentException(string.toString());
        }
        if (this.inputs.add(input)) {
            this.sharedProcessor.addInput(this, input, priority);
        }
    }

    @MainThread
    public final void removeInput(@NotNull NavigationEventInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.checkInvariants();
        if (this.inputs.remove(input)) {
            this.sharedProcessor.removeInput(input);
        }
    }

    public final void dispatchOnStarted$navigationevent(@NotNull NavigationEventInput input, int direction, @Nullable NavigationEvent event) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.checkInvariants();
        if (!this.isEnabled()) {
            return;
        }
        this.sharedProcessor.dispatchOnStarted(input, direction, event);
    }

    public final void dispatchOnProgressed$navigationevent(@NotNull NavigationEventInput input, int direction, @NotNull NavigationEvent event) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.checkInvariants();
        if (!this.isEnabled()) {
            return;
        }
        this.sharedProcessor.dispatchOnProgressed(input, direction, event);
    }

    public final void dispatchOnCompleted$navigationevent(@NotNull NavigationEventInput input, int direction) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.checkInvariants();
        if (!this.isEnabled()) {
            return;
        }
        this.sharedProcessor.dispatchOnCompleted(input, direction, this.onBackCompletedFallback);
    }

    public final void dispatchOnCancelled$navigationevent(@NotNull NavigationEventInput input, int direction) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.checkInvariants();
        if (!this.isEnabled()) {
            return;
        }
        this.sharedProcessor.dispatchOnCancelled(input, direction);
    }

    @MainThread
    public final void dispose() {
        this.checkInvariants();
        this.isDisposed = true;
        ArrayDeque dispatchersToDispose = new ArrayDeque();
        ((Collection)dispatchersToDispose).add(this);
        while (!((Collection)dispatchersToDispose).isEmpty()) {
            NavigationEventDispatcher currentDispatcher = (NavigationEventDispatcher)dispatchersToDispose.removeFirst();
            currentDispatcher.isDisposed = true;
            CollectionsKt.addAll((Collection)((Collection)dispatchersToDispose), (Iterable)currentDispatcher.childDispatchers);
            for (NavigationEventInput navigationEventInput : currentDispatcher.inputs) {
                this.sharedProcessor.removeInput(navigationEventInput);
            }
            currentDispatcher.inputs.clear();
            for (NavigationEventHandler navigationEventHandler : currentDispatcher.handlers) {
                navigationEventHandler.remove();
            }
            currentDispatcher.handlers.clear();
            currentDispatcher.childDispatchers.clear();
            Object object = currentDispatcher.parent;
            if (object != null && (object = ((NavigationEventDispatcher)object).childDispatchers) != null) {
                object.remove(currentDispatcher);
            }
            currentDispatcher.parent = null;
        }
    }

    private final void checkInvariants() {
        if (!(!this.isDisposed())) {
            boolean bl = false;
            String string = "This NavigationEventDispatcher has already been disposed and cannot be used.";
            throw new IllegalStateException(string.toString());
        }
    }

    @MainThread
    @JvmOverloads
    public final void addHandler(@NotNull NavigationEventHandler<?> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        NavigationEventDispatcher.addHandler$default(this, handler, 0, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/navigationevent/NavigationEventDispatcher$Companion;", "", "<init>", "()V", "PRIORITY_OVERLAY", "", "PRIORITY_DEFAULT", "navigationevent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/navigationevent/NavigationEventDispatcher$Priority;", "", "navigationevent"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface Priority {
    }
}

