﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/support/SupportRequest.h>
#include <aws/support/Support_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Support {
namespace Model {

/**
 * <p/><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/RefreshTrustedAdvisorCheckRequest">AWS
 * API Reference</a></p>
 */
class RefreshTrustedAdvisorCheckRequest : public SupportRequest {
 public:
  AWS_SUPPORT_API RefreshTrustedAdvisorCheckRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "RefreshTrustedAdvisorCheck"; }

  AWS_SUPPORT_API Aws::String SerializePayload() const override;

  AWS_SUPPORT_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The unique identifier for the Trusted Advisor check to refresh.</p>
   * <p>Specifying the check ID of a check that is automatically refreshed causes an
   * <code>InvalidParameterValue</code> error.</p>
   */
  inline const Aws::String& GetCheckId() const { return m_checkId; }
  inline bool CheckIdHasBeenSet() const { return m_checkIdHasBeenSet; }
  template <typename CheckIdT = Aws::String>
  void SetCheckId(CheckIdT&& value) {
    m_checkIdHasBeenSet = true;
    m_checkId = std::forward<CheckIdT>(value);
  }
  template <typename CheckIdT = Aws::String>
  RefreshTrustedAdvisorCheckRequest& WithCheckId(CheckIdT&& value) {
    SetCheckId(std::forward<CheckIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_checkId;
  bool m_checkIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Support
}  // namespace Aws
