/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.mindmapmode.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import org.freeplane.core.resources.components.BooleanProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.NumberSliderProperty;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.link.mindmapmode.editor.ControlGroup;
import org.freeplane.features.link.mindmapmode.editor.ControlGroupChangeListener;
import org.freeplane.features.mode.Controller;

public class OpacityControlGroup
implements ControlGroup {
    private BooleanProperty mSetOpacity;
    private NumberSliderProperty mOpacity;
    private OpacityChangeListener propertyChangeListener;
    private ConnectorModel connector;

    @Override
    public void updateValue(ConnectorModel connector) {
        this.connector = connector;
        this.propertyChangeListener.update();
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetOpacity = new BooleanProperty("set_property_text");
        this.mOpacity = new NumberSliderProperty("edit_transparency_label", 20, 255, 20);
        this.mOpacity.setNameAsLabelAndToolTip();
        this.propertyChangeListener = new OpacityChangeListener(this.mSetOpacity, (IPropertyControl)this.mOpacity);
        this.mSetOpacity.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mOpacity.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mSetOpacity.appendToForm(formBuilder);
        this.mOpacity.appendToForm(formBuilder);
    }

    private class OpacityChangeListener
    extends ControlGroupChangeListener {
        public OpacityChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, PropertyChangeEvent evt) {
            MLinkController linkController = (MLinkController)Controller.getCurrentModeController().getExtension(LinkController.class);
            try {
                linkController.setOpacity(OpacityControlGroup.this.connector, enabled ? Optional.of(Integer.valueOf(OpacityControlGroup.this.mOpacity.getValue())) : Optional.empty());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        @Override
        void updateValue() {
            LinkController linkController = LinkController.getController();
            Optional opacity = OpacityControlGroup.this.connector.getAlpha();
            Integer viewOpacity = linkController.getOpacity(OpacityControlGroup.this.connector);
            OpacityControlGroup.this.mSetOpacity.setValue(opacity.isPresent());
            OpacityControlGroup.this.mOpacity.setValue(viewOpacity.toString());
        }
    }
}

