/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.StandardComparisonStrategy;

public class LongArrays {
    private static final LongArrays INSTANCE = new LongArrays();
    private Arrays arrays = Arrays.instance();
    Failures failures = Failures.instance();

    public static LongArrays instance() {
        return INSTANCE;
    }

    LongArrays() {
        this(StandardComparisonStrategy.instance());
    }

    public LongArrays(ComparisonStrategy comparisonStrategy) {
        this.setArrays(new Arrays(comparisonStrategy));
    }

    public void setArrays(Arrays arrays) {
        this.arrays = arrays;
    }

    public Comparator<?> getComparator() {
        return this.arrays.getComparator();
    }

    public void assertNullOrEmpty(AssertionInfo info, long[] actual) {
        this.arrays.assertNullOrEmpty(info, this.failures, actual);
    }

    public void assertEmpty(AssertionInfo info, long[] actual) {
        this.arrays.assertEmpty(info, this.failures, actual);
    }

    public void assertNotEmpty(AssertionInfo info, long[] actual) {
        this.arrays.assertNotEmpty(info, this.failures, actual);
    }

    public void assertHasSize(AssertionInfo info, long[] actual, int expectedSize) {
        this.arrays.assertHasSize(info, actual, expectedSize);
    }

    public void assertHasSizeGreaterThan(AssertionInfo info, long[] actual, int boundary) {
        this.arrays.assertHasSizeGreaterThan(info, actual, boundary);
    }

    public void assertHasSizeGreaterThanOrEqualTo(AssertionInfo info, long[] actual, int boundary) {
        this.arrays.assertHasSizeGreaterThanOrEqualTo(info, actual, boundary);
    }

    public void assertHasSizeLessThan(AssertionInfo info, long[] actual, int boundary) {
        this.arrays.assertHasSizeLessThan(info, actual, boundary);
    }

    public void assertHasSizeLessThanOrEqualTo(AssertionInfo info, long[] actual, int boundary) {
        this.arrays.assertHasSizeLessThanOrEqualTo(info, actual, boundary);
    }

    public void assertHasSizeBetween(AssertionInfo info, long[] actual, int lowerBoundary, int higherBoundary) {
        this.arrays.assertHasSizeBetween(info, actual, lowerBoundary, higherBoundary);
    }

    public void assertHasSameSizeAs(AssertionInfo info, long[] actual, Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(info, (Object)actual, other);
    }

    public void assertHasSameSizeAs(AssertionInfo info, long[] actual, Object[] other) {
        this.arrays.assertHasSameSizeAs(info, (Object)actual, other);
    }

    public void assertContains(AssertionInfo info, long[] actual, long[] values) {
        this.arrays.assertContains(info, this.failures, actual, values);
    }

    public void assertContains(AssertionInfo info, long[] actual, long value, Index index) {
        this.arrays.assertContains(info, this.failures, actual, value, index);
    }

    public void assertDoesNotContain(AssertionInfo info, long[] actual, long value, Index index) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, value, index);
    }

    public void assertContainsOnly(AssertionInfo info, long[] actual, long[] values) {
        this.arrays.assertContainsOnly(info, this.failures, actual, values);
    }

    public void assertContainsExactly(AssertionInfo info, long[] actual, long[] values) {
        this.arrays.assertContainsExactly(info, this.failures, actual, values);
    }

    public void assertContainsExactlyInAnyOrder(AssertionInfo info, long[] actual, long[] values) {
        this.arrays.assertContainsExactlyInAnyOrder(info, this.failures, actual, values);
    }

    public void assertContainsOnlyOnce(AssertionInfo info, long[] actual, long[] values) {
        this.arrays.assertContainsOnlyOnce(info, this.failures, actual, values);
    }

    public void assertContainsSequence(AssertionInfo info, long[] actual, long[] sequence) {
        this.arrays.assertContainsSequence(info, this.failures, actual, sequence);
    }

    public void assertContainsSubsequence(AssertionInfo info, long[] actual, long[] subsequence) {
        this.arrays.assertContainsSubsequence(info, this.failures, actual, subsequence);
    }

    public void assertDoesNotContain(AssertionInfo info, long[] actual, long[] values) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, values);
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info, long[] actual) {
        this.arrays.assertDoesNotHaveDuplicates(info, this.failures, actual);
    }

    public void assertStartsWith(AssertionInfo info, long[] actual, long[] sequence) {
        this.arrays.assertStartsWith(info, this.failures, actual, sequence);
    }

    public void assertEndsWith(AssertionInfo info, long[] actual, long[] sequence) {
        this.arrays.assertEndsWith(info, this.failures, actual, sequence);
    }

    public void assertIsSorted(AssertionInfo info, long[] actual) {
        this.arrays.assertIsSorted(info, this.failures, actual);
    }

    public void assertIsSortedAccordingToComparator(AssertionInfo info, long[] actual, Comparator<? super Long> comparator) {
        Arrays.assertIsSortedAccordingToComparator(info, this.failures, actual, comparator);
    }

    public void assertContainsAnyOf(AssertionInfo info, long[] actual, long[] values) {
        this.arrays.assertContainsAnyOf(info, this.failures, actual, values);
    }
}

