/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage.decompressor;

import java.io.ByteArrayOutputStream;
import java.util.zip.Inflater;
import jdk.internal.jimage.decompressor.ResourceDecompressor;

final class ZipDecompressor
implements ResourceDecompressor {
    ZipDecompressor() {
    }

    @Override
    public String getName() {
        return "zip";
    }

    static byte[] decompress(byte[] bytesIn, int offset) throws Exception {
        Inflater inflater = new Inflater();
        inflater.setInput(bytesIn, offset, bytesIn.length - offset);
        ByteArrayOutputStream stream = new ByteArrayOutputStream(bytesIn.length - offset);
        byte[] buffer = new byte[1024];
        while (!inflater.finished()) {
            int count = inflater.inflate(buffer);
            stream.write(buffer, 0, count);
        }
        stream.close();
        byte[] bytesOut = stream.toByteArray();
        inflater.end();
        return bytesOut;
    }

    @Override
    public byte[] decompress(ResourceDecompressor.StringsProvider reader, byte[] content, int offset, long originalSize) throws Exception {
        byte[] decompressed = ZipDecompressor.decompress(content, offset);
        return decompressed;
    }
}

