/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.web.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.GeneralConstants;

public class PostBindingUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static String base64Encode(String stringToEncode) throws IOException {
        return Base64.getEncoder().encodeToString(stringToEncode.getBytes(GeneralConstants.SAML_CHARSET));
    }

    public static byte[] base64Decode(String encodedString) {
        if (encodedString == null) {
            throw logger.nullArgumentError("encodedString");
        }
        try {
            return Base64.getMimeDecoder().decode(encodedString);
        }
        catch (Exception e) {
            logger.error(e);
            throw logger.invalidArgumentError("base64 decode failed: " + e.getMessage());
        }
    }

    public static InputStream base64DecodeAsStream(String encodedString) {
        if (encodedString == null) {
            throw logger.nullArgumentError("encodedString");
        }
        return new ByteArrayInputStream(PostBindingUtil.base64Decode(encodedString));
    }

    public static String escapeHTML(String toEscape) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < toEscape.length(); ++i) {
            char chr = toEscape.charAt(i);
            if (chr == '\"' || chr == '<' || chr == '>') continue;
            escaped.append(chr);
        }
        return escaped.toString();
    }
}

