/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.group;

import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.fgap.evaluation.partial.PartialEvaluationPolicyProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.authorization.GroupPolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceType;

public class GroupPolicyProvider
implements PolicyProvider,
PartialEvaluationPolicyProvider {
    private static final Logger logger = Logger.getLogger(GroupPolicyProvider.class);
    private final BiFunction<Policy, AuthorizationProvider, GroupPolicyRepresentation> representationFunction;

    public GroupPolicyProvider(BiFunction<Policy, AuthorizationProvider, GroupPolicyRepresentation> representationFunction) {
        this.representationFunction = representationFunction;
    }

    public void evaluate(Evaluation evaluation) {
        AuthorizationProvider authorizationProvider = evaluation.getAuthorizationProvider();
        GroupPolicyRepresentation policy = this.representationFunction.apply(evaluation.getPolicy(), authorizationProvider);
        RealmModel realm = authorizationProvider.getRealm();
        Attributes.Entry groupsClaim = evaluation.getContext().getIdentity().getAttributes().getValue(policy.getGroupsClaim());
        if (groupsClaim == null || groupsClaim.isEmpty()) {
            List userGroups = evaluation.getRealm().getUserGroups(evaluation.getContext().getIdentity().getId());
            groupsClaim = new Attributes.Entry(policy.getGroupsClaim(), (Collection)userGroups);
        }
        if (this.isGranted(realm, policy, groupsClaim)) {
            evaluation.grant();
        }
        logger.debugf("Groups policy %s evaluated to %s with identity groups %s", (Object)policy.getName(), (Object)evaluation.getEffect(), (Object)groupsClaim);
    }

    private boolean isGranted(RealmModel realm, GroupPolicyRepresentation policy, Attributes.Entry groupsClaim) {
        for (GroupPolicyRepresentation.GroupDefinition definition : policy.getGroups()) {
            GroupModel allowedGroup = realm.getGroupById(definition.getId());
            if (allowedGroup == null) continue;
            for (int i = 0; i < groupsClaim.size(); ++i) {
                String allowedGroupPath;
                String group = groupsClaim.asString(i);
                if (group.indexOf(47) != -1 && (group.equals(allowedGroupPath = ModelToRepresentation.buildGroupPath((GroupModel)allowedGroup)) || definition.isExtendChildren() && group.startsWith(allowedGroupPath))) {
                    return true;
                }
                if (!group.equals(allowedGroup.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public Stream<Policy> getPermissions(KeycloakSession session, ResourceType resourceType, ResourceType groupResourceType, UserModel user) {
        AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        RealmModel realm = session.getContext().getRealm();
        ClientModel adminPermissionsClient = realm.getAdminPermissionsClient();
        StoreFactory storeFactory = provider.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findByClient(adminPermissionsClient);
        PolicyStore policyStore = storeFactory.getPolicyStore();
        List<String> groupIds = user.getGroupsStream().map(GroupModel::getId).toList();
        return policyStore.findDependentPolicies(resourceServer, resourceType.getType(), groupResourceType == null ? null : groupResourceType.getType(), "group", "groups", groupIds);
    }

    public boolean evaluate(KeycloakSession session, Policy policy, UserModel subject) {
        RealmModel realm = session.getContext().getRealm();
        AuthorizationProvider authorizationProvider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        GroupPolicyRepresentation groupPolicy = this.representationFunction.apply(policy, authorizationProvider);
        List userGroups = subject.getGroupsStream().map(ModelToRepresentation::buildGroupPath).collect(Collectors.toList());
        return this.isGranted(realm, groupPolicy, new Attributes.Entry(groupPolicy.getGroupsClaim(), userGroups));
    }

    public boolean supports(Policy policy) {
        return "group".equals(policy.getType());
    }

    public void close() {
    }
}

