/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.command.impl.internal;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.completer.OptionCompleter;
import org.aesh.command.converter.Converter;
import org.aesh.command.impl.converter.AeshConverterInvocation;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedCommand;
import org.aesh.command.impl.parser.AeshOptionParser;
import org.aesh.command.impl.validator.AeshValidatorInvocation;
import org.aesh.command.invocation.InvocationProviders;
import org.aesh.command.parser.OptionParser;
import org.aesh.command.parser.OptionParserException;
import org.aesh.command.renderer.OptionRenderer;
import org.aesh.command.validator.OptionValidator;
import org.aesh.command.validator.OptionValidatorException;
import org.aesh.io.PipelineResource;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.aesh.selector.SelectorType;
import org.aesh.terminal.utils.ANSI;

public final class ProcessedOption {
    private String shortName;
    private String name;
    private String description;
    private List<String> values;
    private String argument;
    private List<String> defaultValues;
    private Class<?> type;
    private Converter converter;
    private OptionType optionType;
    private boolean required = false;
    private char valueSeparator;
    private String fieldName;
    private OptionCompleter completer;
    private Map<String, String> properties;
    private boolean longNameUsed = true;
    private OptionValidator validator;
    private boolean endsWithSeparator = false;
    private OptionActivator activator;
    private OptionRenderer renderer;
    private boolean overrideRequired = false;
    private boolean ansiMode = true;
    private ProcessedCommand parent;
    private OptionParser parser;
    private boolean cursorOption = false;
    private boolean cursorValue = false;
    private boolean askIfNotSet = false;
    private final SelectorType selectorType;

    public ProcessedOption(char shortName, String name, String description, String argument, boolean required, char valueSeparator, boolean askIfNotSet, SelectorType selectorType, List<String> defaultValue, Class<?> type, String fieldName, OptionType optionType, Converter converter, OptionCompleter completer, OptionValidator optionValidator, OptionActivator activator, OptionRenderer renderer, OptionParser parser, boolean overrideRequired) throws OptionParserException {
        if (shortName != '\u0000') {
            this.shortName = String.valueOf(shortName);
        }
        this.name = name;
        this.description = description;
        this.argument = argument;
        this.required = required;
        this.valueSeparator = valueSeparator;
        this.type = type;
        this.fieldName = fieldName;
        this.overrideRequired = overrideRequired;
        this.optionType = optionType;
        this.converter = converter;
        this.completer = completer;
        this.validator = optionValidator;
        this.activator = activator;
        this.askIfNotSet = askIfNotSet;
        this.selectorType = selectorType != null ? selectorType : SelectorType.NO_OP;
        this.parser = parser != null ? parser : new AeshOptionParser();
        if (renderer != null) {
            this.renderer = renderer;
        }
        this.defaultValues = defaultValue;
        this.properties = new HashMap<String, String>();
        this.values = new ArrayList<String>();
    }

    public String shortName() {
        return this.shortName;
    }

    public String name() {
        return this.name;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public void addValues(List<String> values) {
        this.values.addAll(values);
    }

    public String getValue() {
        if (this.values.size() > 0) {
            return this.values.get(0);
        }
        return null;
    }

    public String getLastValue() {
        if (this.values.size() > 0) {
            return this.values.get(this.values.size() - 1);
        }
        return null;
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean hasValue() {
        return this.optionType != OptionType.BOOLEAN;
    }

    public boolean hasMultipleValues() {
        return this.optionType == OptionType.LIST || this.optionType == OptionType.ARGUMENTS || this.optionType == OptionType.GROUP;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean doOverrideRequired() {
        return this.overrideRequired;
    }

    public Class<?> type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public char getValueSeparator() {
        return this.valueSeparator;
    }

    public boolean isProperty() {
        return this.optionType == OptionType.GROUP;
    }

    public String getArgument() {
        return this.argument;
    }

    public List<String> getDefaultValues() {
        return this.defaultValues;
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public OptionType getOptionType() {
        return this.optionType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Converter converter() {
        return this.converter;
    }

    public OptionCompleter completer() {
        return this.completer;
    }

    public OptionValidator validator() {
        return this.validator;
    }

    public OptionActivator activator() {
        return this.activator;
    }

    public OptionParser parser() {
        return this.parser;
    }

    void setParent(ProcessedCommand parent) {
        this.parent = parent;
    }

    public ProcessedCommand parent() {
        return this.parent;
    }

    public OptionRenderer getRenderer() {
        return this.renderer;
    }

    public boolean isLongNameUsed() {
        return this.longNameUsed;
    }

    public void setLongNameUsed(boolean longNameUsed) {
        this.longNameUsed = longNameUsed;
    }

    public void setEndsWithSeparator(boolean endsWithSeparator) {
        this.endsWithSeparator = endsWithSeparator;
    }

    public boolean getEndsWithSeparator() {
        return this.endsWithSeparator;
    }

    public boolean askIfNotSet() {
        return this.askIfNotSet;
    }

    public SelectorType selectorType() {
        return this.selectorType;
    }

    public void clear() {
        if (this.values != null) {
            this.values.clear();
        }
        if (this.properties != null) {
            this.properties.clear();
        }
        this.longNameUsed = true;
        this.endsWithSeparator = false;
        this.cursorOption = false;
        this.cursorValue = false;
    }

    public String getDisplayName() {
        if (this.isLongNameUsed() && this.name != null) {
            return "--" + this.name;
        }
        if (this.shortName != null) {
            return "-" + this.shortName;
        }
        return null;
    }

    public TerminalString getRenderedNameWithDashes() {
        if (this.renderer == null || !this.ansiMode) {
            return new TerminalString(this.hasValue() ? "--" + this.name + "=" : "--" + this.name, true);
        }
        return new TerminalString(this.hasValue() ? "--" + this.name + "=" : "--" + this.name, this.renderer.getColor(), this.renderer.getTextType());
    }

    public int getFormattedLength() {
        StringBuilder sb = new StringBuilder();
        if (this.shortName != null) {
            sb.append("-").append(this.shortName);
        }
        if (this.name != null) {
            if (sb.toString().trim().length() > 0) {
                sb.append(", ");
            }
            sb.append("--").append(this.name);
        }
        if (this.argument != null && this.argument.length() > 0) {
            sb.append("=<").append(this.argument).append(">");
        }
        return sb.length();
    }

    public String getFormattedOption(int offset, int descriptionStart, int width) {
        StringBuilder sb = new StringBuilder();
        if (this.required && this.ansiMode) {
            sb.append(ANSI.BOLD);
        }
        if (offset > 0) {
            sb.append(String.format("%" + offset + "s", ""));
        }
        if (this.shortName != null) {
            sb.append("-").append(this.shortName);
        }
        if (this.name != null && this.name.length() > 0) {
            if (this.shortName != null) {
                sb.append(", ");
            }
            sb.append("--").append(this.name);
        }
        if (this.argument != null && this.argument.length() > 0) {
            sb.append("=<").append(this.argument).append(">");
        }
        if (this.required && this.ansiMode) {
            sb.append("\u001b[0;22m");
        }
        if (this.description != null && this.description.length() > 0) {
            int descOffset = descriptionStart - this.getFormattedLength() - offset;
            if (descOffset > 0) {
                sb.append(String.format("%" + descOffset + "s", ""));
            } else {
                sb.append(" ");
            }
            sb.append(this.description);
        }
        return sb.toString();
    }

    public Object doConvert(String inputValue, InvocationProviders invocationProviders, Object command, AeshContext aeshContext, boolean doValidation) throws OptionValidatorException {
        Object result = this.converter.convert(invocationProviders.getConverterProvider().enhanceConverterInvocation(new AeshConverterInvocation(inputValue, aeshContext)));
        if (this.validator != null && doValidation) {
            this.validator.validate(invocationProviders.getValidatorProvider().enhanceValidatorInvocation(new AeshValidatorInvocation<Object>(result, command, aeshContext)));
        }
        return result;
    }

    public void injectValueIntoField(Object instance, InvocationProviders invocationProviders, AeshContext aeshContext, boolean doValidation) throws OptionValidatorException {
        block21: {
            if (this.converter == null || instance == null) {
                return;
            }
            try {
                Constructor<?> constructor;
                Field field = this.getField(instance.getClass(), this.fieldName);
                if (field == null) {
                    return;
                }
                if (!Modifier.isPublic(field.getModifiers())) {
                    field.setAccessible(true);
                }
                if (!Modifier.isPublic(instance.getClass().getModifiers()) && (constructor = instance.getClass().getDeclaredConstructor(new Class[0])) != null) {
                    constructor.setAccessible(true);
                }
                if (this.optionType == OptionType.NORMAL || this.optionType == OptionType.BOOLEAN || this.optionType == OptionType.ARGUMENT) {
                    if (this.getValue() != null) {
                        field.set(instance, this.doConvert(this.getValue(), invocationProviders, instance, aeshContext, doValidation));
                    } else if (this.defaultValues.size() > 0) {
                        field.set(instance, this.doConvert(this.defaultValues.get(0), invocationProviders, instance, aeshContext, doValidation));
                    }
                    break block21;
                }
                if (this.optionType == OptionType.LIST || this.optionType == OptionType.ARGUMENTS) {
                    Collection<Object> tmpSet = this.initializeCollection(field);
                    if (this.values.size() > 0) {
                        for (String in : this.values) {
                            tmpSet.add(this.doConvert(in, invocationProviders, instance, aeshContext, doValidation));
                        }
                    } else if (this.defaultValues.size() > 0) {
                        for (String in : this.defaultValues) {
                            tmpSet.add(this.doConvert(in, invocationProviders, instance, aeshContext, doValidation));
                        }
                    }
                    field.set(instance, tmpSet);
                    break block21;
                }
                if (this.optionType == OptionType.GROUP) {
                    Map tmpMap;
                    if (field.getType().isInterface() || Modifier.isAbstract(field.getType().getModifiers())) {
                        tmpMap = this.newHashMap();
                        for (String propertyKey : this.properties.keySet()) {
                            tmpMap.put(propertyKey, this.doConvert(this.properties.get(propertyKey), invocationProviders, instance, aeshContext, doValidation));
                        }
                        field.set(instance, tmpMap);
                    } else {
                        tmpMap = (Map)field.getType().newInstance();
                        for (String propertyKey : this.properties.keySet()) {
                            tmpMap.put(propertyKey, this.doConvert(this.properties.get(propertyKey), invocationProviders, instance, aeshContext, doValidation));
                        }
                        field.set(instance, tmpMap);
                    }
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    private Collection<Object> initializeCollection(Field field) throws IllegalAccessException, InstantiationException {
        if (field.getType().isInterface() || Modifier.isAbstract(field.getType().getModifiers())) {
            if (Set.class.isAssignableFrom(field.getType())) {
                return new HashSet<Object>();
            }
            if (List.class.isAssignableFrom(field.getType())) {
                return new ArrayList<Object>();
            }
            return null;
        }
        return (Collection)field.getType().newInstance();
    }

    public void injectResource(PipelineResource resource, Object instance) {
        try {
            Field field = this.getField(instance.getClass(), this.fieldName);
            if (!Modifier.isPublic(field.getModifiers())) {
                field.setAccessible(true);
            }
            if (this.optionType == OptionType.ARGUMENT) {
                field.set(instance, resource);
            } else {
                Collection<Object> set = this.initializeCollection(field);
                if (set != null) {
                    set.add(resource);
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public void updateInvocationProviders(InvocationProviders invocationProviders) {
        this.activator = invocationProviders.getOptionActivatorProvider().enhanceOptionActivator(this.activator);
    }

    public void updateAnsiMode(boolean ansiMode) {
        this.ansiMode = ansiMode;
    }

    private <S, T> Map<S, T> newHashMap() {
        return new HashMap();
    }

    private Field getField(Class clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException nsfe) {
            if (clazz.getSuperclass() != null) {
                return this.getField(clazz.getSuperclass(), fieldName);
            }
            return null;
        }
    }

    public boolean isCursorOption() {
        return this.cursorOption;
    }

    public void setCursorOption(boolean cursorOption) {
        this.cursorOption = cursorOption;
    }

    public boolean isCursorValue() {
        return this.cursorValue;
    }

    public void setCursorValue(boolean cursorValue) {
        this.cursorValue = cursorValue;
    }

    public boolean hasDefaultValue() {
        return this.getDefaultValues() != null && this.getDefaultValues().size() > 0;
    }

    boolean isTypeAssignableByResourcesOrFile() {
        return Resource.class.isAssignableFrom(this.type) || File.class.isAssignableFrom(this.type) || Path.class.isAssignableFrom(this.type);
    }

    public String toString() {
        return "ProcessedOption{shortName='" + this.shortName + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", values=" + this.values + ", defaultValues=" + this.defaultValues + ", arguments='" + this.argument + '\'' + ", type=" + this.type + ", required=" + this.required + ", valueSeparator=" + this.valueSeparator + ", properties=" + this.properties + '}';
    }
}

