/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tasks;

import com.google.common.base.Stopwatch;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import mediathek.config.Daten;
import mediathek.config.StandardLocations;
import mediathek.daten.DatenFilm;
import mediathek.daten.IndexedFilmList;
import mediathek.daten.ListeFilme;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.FileUtils;
import mediathek.tool.LuceneDefaultAnalyzer;
import mediathek.tool.SwingErrorDialog;
import mediathek.tool.datum.DateUtil;
import mediathek.tool.datum.DatumFilm;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0014J\b\u0010\u0017\u001a\u00020\u000eH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lmediathek/gui/tasks/LuceneIndexWorker;", "Ljavax/swing/SwingWorker;", "Ljava/lang/Void;", "progLabel", "Ljavax/swing/JLabel;", "progressBar", "Ljavax/swing/JProgressBar;", "<init>", "(Ljavax/swing/JLabel;Ljavax/swing/JProgressBar;)V", "createIndexDocument", "Lorg/apache/lucene/document/Document;", "film", "Lmediathek/daten/DatenFilm;", "addSendeZeit", "", "doc", "addWochentag", "addSendeDatum", "createIndexWriter", "Lorg/apache/lucene/index/IndexWriter;", "liste", "Lmediathek/daten/IndexedFilmList;", "doInBackground", "done", "Companion", "MediathekView"})
public final class LuceneIndexWorker
extends SwingWorker<Void, Void> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JLabel progLabel;
    @NotNull
    private final JProgressBar progressBar;
    @NotNull
    private static final Logger LOG;
    private static final DateTimeFormatter FORMATTER;

    public LuceneIndexWorker(@NotNull JLabel progLabel, @NotNull JProgressBar progressBar) {
        Intrinsics.checkNotNullParameter((Object)progLabel, (String)"progLabel");
        Intrinsics.checkNotNullParameter((Object)progressBar, (String)"progressBar");
        this.progLabel = progLabel;
        this.progressBar = progressBar;
        SwingUtilities.invokeLater(() -> LuceneIndexWorker._init_$lambda$0(this));
    }

    private final Document createIndexDocument(DatenFilm film) throws IOException {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", String.valueOf(film.getFilmNr()), Field.Store.YES));
        doc.add((IndexableField)new StringField("neu", String.valueOf(film.isNew()), Field.Store.NO));
        String string = film.getSender();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSender(...)");
        Object object = string;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        doc.add((IndexableField)new StringField("sender", string2, Field.Store.NO));
        doc.add((IndexableField)new TextField("titel", film.getTitle(), Field.Store.NO));
        doc.add((IndexableField)new TextField("thema", film.getThema(), Field.Store.NO));
        object = new int[1];
        object[0] = film.getFilmLength();
        doc.add((IndexableField)new IntPoint("l\u00e4nge", (int[])object));
        object = new int[1];
        Integer n = film.getFileSize().toInteger();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"toInteger(...)");
        object[0] = ((Number)n).intValue();
        doc.add((IndexableField)new IntPoint("gr\u00f6\u00dfe", (int[])object));
        doc.add((IndexableField)new TextField("beschreibung", film.getDescription(), Field.Store.NO));
        doc.add((IndexableField)new StringField("livestream", String.valueOf(film.isLivestream()), Field.Store.NO));
        doc.add((IndexableField)new StringField("highquality", String.valueOf(film.isHighQuality()), Field.Store.NO));
        doc.add((IndexableField)new StringField("untertitel", String.valueOf(film.hasSubtitle() || film.hasBurnedInSubtitles()), Field.Store.NO));
        doc.add((IndexableField)new StringField("trailerteaser", String.valueOf(film.isTrailerTeaser()), Field.Store.NO));
        doc.add((IndexableField)new StringField("audioversion", String.valueOf(film.isAudioVersion()), Field.Store.NO));
        doc.add((IndexableField)new StringField("signlanguage", String.valueOf(film.isSignLanguage()), Field.Store.NO));
        doc.add((IndexableField)new StringField("duplicate", String.valueOf(film.isDuplicate()), Field.Store.NO));
        object = new int[1];
        object[0] = film.getSeason();
        doc.add((IndexableField)new IntPoint("season", (int[])object));
        object = new int[1];
        object[0] = film.getEpisode();
        doc.add((IndexableField)new IntPoint("episode", (int[])object));
        this.addSendeDatum(doc, film);
        this.addSendeZeit(doc, film);
        this.addWochentag(doc, film);
        return doc;
    }

    private final void addSendeZeit(Document doc, DatenFilm film) {
        String startzeit = film.getSendeZeit();
        Intrinsics.checkNotNull((Object)startzeit);
        if (!(((CharSequence)startzeit).length() == 0)) {
            doc.add((IndexableField)new StringField("startzeit", startzeit, Field.Store.NO));
        }
    }

    private final void addWochentag(Document doc, DatenFilm film) {
        DatumFilm date = film.getDatumFilm();
        if (date != DatumFilm.UNDEFINED_FILM_DATE) {
            String strDate = FORMATTER.format(date.getZonedDateTime());
            doc.add((IndexableField)new TextField("wochentag", strDate, Field.Store.NO));
        }
    }

    private final void addSendeDatum(Document doc, DatenFilm film) {
        String sendeDatumStr = DateTools.timeToString((long)DateUtil.convertFilmDateToLuceneDate(film), (DateTools.Resolution)DateTools.Resolution.DAY);
        doc.add((IndexableField)new StringField("sendedatum", sendeDatumStr, Field.Store.NO));
    }

    private final IndexWriter createIndexWriter(IndexedFilmList liste) {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(LuceneDefaultAnalyzer.buildPerFieldAnalyzer());
        indexWriterConfig.setRAMBufferSizeMB(256.0);
        IndexWriter writer = new IndexWriter(liste.getLuceneDirectory(), indexWriterConfig);
        writer.deleteAll();
        writer.commit();
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Void doInBackground() {
        try {
            SwingUtilities.invokeLater(() -> LuceneIndexWorker.doInBackground$lambda$0(this));
            ListeFilme listeFilme = Daten.getInstance().getListeFilmeNachBlackList();
            Intrinsics.checkNotNull((Object)listeFilme, (String)"null cannot be cast to non-null type mediathek.daten.IndexedFilmList");
            IndexedFilmList filmListe = (IndexedFilmList)listeFilme;
            Closeable closeable = (Closeable)this.createIndexWriter(filmListe);
            Throwable throwable = null;
            try {
                IndexWriter writer = (IndexWriter)closeable;
                boolean bl = false;
                Stopwatch stopwatch = Stopwatch.createStarted();
                Intrinsics.checkNotNullExpressionValue((Object)stopwatch, (String)"createStarted(...)");
                Stopwatch watch = stopwatch;
                AtomicInteger counter = new AtomicInteger(0);
                int totalCount = filmListe.size();
                Ref.IntRef oldProgress = new Ref.IntRef();
                ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                Iterator iterator = filmListe.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    DatenFilm film = (DatenFilm)iterator2.next();
                    executor.submit(() -> LuceneIndexWorker.doInBackground$lambda$1$0(this, film, writer, counter, totalCount, oldProgress));
                }
                SwingUtilities.invokeLater(() -> LuceneIndexWorker.doInBackground$lambda$1$1(this));
                executor.shutdown();
                executor.awaitTermination(5L, TimeUnit.MINUTES);
                SwingUtilities.invokeLater(() -> LuceneIndexWorker.doInBackground$lambda$1$2(this));
                writer.commit();
                watch.stop();
                LOG.trace("Lucene index creation took {}", (Object)watch);
                DirectoryReader directoryReader = filmListe.getReader();
                if (directoryReader != null) {
                    directoryReader.close();
                }
                filmListe.setReader(DirectoryReader.open((Directory)filmListe.getLuceneDirectory()));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception ex) {
            LOG.error("Lucene film index most probably damaged, deleting it.");
            try {
                Path indexPath = StandardLocations.getFilmIndexPath();
                if (Files.exists(indexPath, new LinkOption[0])) {
                    FileUtils.deletePathRecursively(indexPath);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to delete lucene index path", (Throwable)e);
            }
            SwingUtilities.invokeLater(() -> LuceneIndexWorker.doInBackground$lambda$2(ex));
        }
        return null;
    }

    @Override
    protected void done() {
        MediathekGui ui = MediathekGui.ui();
        ui.toggleBlacklistAction.setEnabled(true);
        ui.editBlacklistAction.setEnabled(true);
        ui.loadFilmListAction.setEnabled(true);
    }

    private static final void _init_$lambda$0(LuceneIndexWorker this$0) {
        MediathekGui ui = MediathekGui.ui();
        ui.toggleBlacklistAction.setEnabled(false);
        ui.editBlacklistAction.setEnabled(false);
        ui.loadFilmListAction.setEnabled(false);
        this$0.progLabel.setText("Blacklist anwenden");
        this$0.progressBar.setIndeterminate(true);
    }

    private static final void doInBackground$lambda$0(LuceneIndexWorker this$0) {
        this$0.progLabel.setText("Indiziere Filme");
        this$0.progressBar.setIndeterminate(false);
        this$0.progressBar.setMinimum(0);
        this$0.progressBar.setMaximum(100);
        this$0.progressBar.setValue(0);
    }

    private static final void doInBackground$lambda$1$0(LuceneIndexWorker this$0, DatenFilm $film, IndexWriter $writer, AtomicInteger $counter, int $totalCount, Ref.IntRef $oldProgress) {
        try {
            Intrinsics.checkNotNull((Object)$film);
            Document doc = this$0.createIndexDocument($film);
            $writer.addDocument((Iterable)doc);
            int progress = $counter.incrementAndGet() * 100 / $totalCount;
            if (progress > $oldProgress.element) {
                SwingUtilities.invokeLater(() -> LuceneIndexWorker.doInBackground$lambda$1$0$0(this$0, progress));
                $oldProgress.element = progress;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static final void doInBackground$lambda$1$0$0(LuceneIndexWorker this$0, int $progress) {
        this$0.progressBar.setValue($progress);
    }

    private static final void doInBackground$lambda$1$1(LuceneIndexWorker this$0) {
        this$0.progressBar.setValue(100);
    }

    private static final void doInBackground$lambda$1$2(LuceneIndexWorker this$0) {
        this$0.progressBar.setIndeterminate(true);
        this$0.progLabel.setText("Schreibe Index");
    }

    private static final void doInBackground$lambda$2(Exception $ex) {
        SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), "Der Filmindex ist besch\u00e4digt und wurde gel\u00f6scht.\nDas Programm wird beendet, bitte starten Sie es erneut.", $ex);
        MediathekGui.ui().quitApplication();
    }

    static {
        Logger logger = LogManager.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        FORMATTER = DateTimeFormatter.ofPattern("EEEE", Locale.GERMAN);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lmediathek/gui/tasks/LuceneIndexWorker$Companion;", "", "<init>", "()V", "LOG", "Lorg/apache/logging/log4j/Logger;", "FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

