var __defProp = Object.defineProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });

// src/atn/ParseInfo.ts
var ParseInfo = class {
  static {
    __name(this, "ParseInfo");
  }
  atnSimulator;
  constructor(atnSimulator) {
    this.atnSimulator = atnSimulator;
  }
  /**
   * Gets an array of {@link DecisionInfo} instances containing the profiling
   * information gathered for each decision in the ATN.
   *
   * @returns An array of {@link DecisionInfo} instances, indexed by decision
   * number.
   */
  getDecisionInfo() {
    return this.atnSimulator.getDecisionInfo();
  }
  /**
   * Gets the decision numbers for decisions that required one or more
   * full-context predictions during parsing. These are decisions for which
   * {@link DecisionInfo#llFallback} is non-zero.
   *
   * @returns A list of decision numbers which required one or more
   * full-context predictions during parsing.
   */
  getLLDecisions() {
    const decisions = this.atnSimulator.getDecisionInfo();
    const result = new Array();
    for (let i = 0; i < decisions.length; i++) {
      const fallBack = decisions[i].llFallback;
      if (fallBack > 0) {
        result.push(i);
      }
    }
    return result;
  }
  /**
   * Gets the total time spent during prediction across all decisions made
   * during parsing. This value is the sum of
   * {@link DecisionInfo#timeInPrediction} for all decisions.
   */
  getTotalTimeInPrediction() {
    const decisions = this.atnSimulator.getDecisionInfo();
    let t = 0;
    for (const decision of decisions) {
      t += decision.timeInPrediction;
    }
    return t;
  }
  /**
   * Gets the total number of SLL lookahead operations across all decisions
   * made during parsing. This value is the sum of
   * {@link DecisionInfo#sllTotalLook} for all decisions.
   */
  getTotalSLLLookaheadOps() {
    const decisions = this.atnSimulator.getDecisionInfo();
    let k = 0;
    for (const decision of decisions) {
      k += decision.sllTotalLook;
    }
    return k;
  }
  /**
   * Gets the total number of LL lookahead operations across all decisions
   * made during parsing. This value is the sum of
   * {@link DecisionInfo#llTotalLook} for all decisions.
   */
  getTotalLLLookaheadOps() {
    const decisions = this.atnSimulator.getDecisionInfo();
    let k = 0;
    for (const decision of decisions) {
      k += decision.llTotalLook;
    }
    return k;
  }
  /**
   * Gets the total number of ATN lookahead operations for SLL prediction
   * across all decisions made during parsing.
   */
  getTotalSLLATNLookaheadOps() {
    const decisions = this.atnSimulator.getDecisionInfo();
    let k = 0;
    for (const decision of decisions) {
      k += decision.sllATNTransitions;
    }
    return k;
  }
  /**
   * Gets the total number of ATN lookahead operations for LL prediction
   * across all decisions made during parsing.
   */
  getTotalLLATNLookaheadOps() {
    const decisions = this.atnSimulator.getDecisionInfo();
    let k = 0;
    for (const decision of decisions) {
      k += decision.llATNTransitions;
    }
    return k;
  }
  /**
   * Gets the total number of ATN lookahead operations for SLL and LL
   * prediction across all decisions made during parsing.
   *
   *
   * This value is the sum of {@link #getTotalSLLATNLookaheadOps} and
   * {@link #getTotalLLATNLookaheadOps}.
   */
  getTotalATNLookaheadOps() {
    const decisions = this.atnSimulator.getDecisionInfo();
    let k = 0;
    for (const decision of decisions) {
      k += decision.sllATNTransitions;
      k += decision.llATNTransitions;
    }
    return k;
  }
  getDFASize(decision) {
    if (decision === void 0) {
      let n = 0;
      const decisionToDFA = this.atnSimulator.decisionToDFA;
      for (let i = 0; i < decisionToDFA.length; i++) {
        n += this.getDFASize(i);
      }
      return n;
    } else {
      const decisionToDFA = this.atnSimulator.decisionToDFA[decision];
      return decisionToDFA.length;
    }
  }
};
export {
  ParseInfo
};
