/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.tree;

import com.intellij.history.core.DataStreamUtil;
import com.intellij.history.core.Paths;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.utils.LocalHistoryLog;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.io.DataInputOutputUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class DirectoryEntry
extends Entry {
    private final ArrayList<Entry> myChildren;

    public DirectoryEntry(String name) {
        this(DirectoryEntry.toNameId(name));
    }

    public DirectoryEntry(int nameId) {
        super(nameId);
        this.myChildren = new ArrayList(3);
    }

    public DirectoryEntry(DataInput in, boolean dummy) throws IOException {
        super(in);
        int count = DataInputOutputUtil.readINT((DataInput)in);
        this.myChildren = new ArrayList(count);
        while (count-- > 0) {
            this.unsafeAddChild(DataStreamUtil.readEntry(in));
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myChildren.size());
        for (Entry child : this.myChildren) {
            DataStreamUtil.writeEntry(out, child);
        }
    }

    @Override
    public long getTimestamp() {
        return -1L;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public void addChild(Entry child) {
        if (!this.checkDoesNotExist(child, child.getName())) {
            return;
        }
        this.unsafeAddChild(child);
    }

    @Override
    public void addChildren(Collection<? extends Entry> children) {
        this.myChildren.ensureCapacity(this.myChildren.size() + children.size());
        for (Entry entry : children) {
            this.unsafeAddChild(entry);
        }
    }

    private void unsafeAddChild(Entry child) {
        this.myChildren.add(child);
        child.setParent(this);
    }

    protected boolean checkDoesNotExist(Entry e, String name) {
        Entry found = this.findChild(name);
        if (found == null) {
            return true;
        }
        if (found == e) {
            return false;
        }
        this.removeChild(found);
        LocalHistoryLog.LOG.warn(String.format("entry '%s' already exists in '%s'", name, this.getPath()));
        return true;
    }

    @Override
    public void removeChild(Entry child) {
        this.myChildren.remove(child);
        child.setParent(null);
    }

    @Override
    public List<Entry> getChildren() {
        return this.myChildren;
    }

    @Override
    public boolean hasUnavailableContent(List<? super Entry> entriesWithUnavailableContent) {
        for (Entry e : this.myChildren) {
            e.hasUnavailableContent(entriesWithUnavailableContent);
        }
        return !entriesWithUnavailableContent.isEmpty();
    }

    @Override
    @NotNull
    public DirectoryEntry copy() {
        DirectoryEntry result = this.copyEntry();
        result.myChildren.ensureCapacity(this.myChildren.size());
        for (Entry child : this.myChildren) {
            result.unsafeAddChild(child.copy());
        }
        DirectoryEntry directoryEntry = result;
        if (directoryEntry == null) {
            DirectoryEntry.$$$reportNull$$$0(0);
        }
        return directoryEntry;
    }

    protected DirectoryEntry copyEntry() {
        return new DirectoryEntry(this.getNameId());
    }

    @Override
    public void collectDifferencesWith(@NotNull Entry right, @NotNull BiConsumer<Entry, Entry> consumer) {
        Entry myChildEntry;
        int commonIndex;
        if (right == null) {
            DirectoryEntry.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            DirectoryEntry.$$$reportNull$$$0(2);
        }
        DirectoryEntry e = (DirectoryEntry)right;
        if (!this.getPath().equals(e.getPath())) {
            consumer.accept(this, e);
        }
        int myChildrenSize = this.myChildren.size();
        int rightChildrenSize = e.myChildren.size();
        int minChildrenSize = Math.min(myChildrenSize, rightChildrenSize);
        for (commonIndex = 0; commonIndex < minChildrenSize; ++commonIndex) {
            Entry childEntry = this.myChildren.get(commonIndex);
            Entry rightChildEntry = e.myChildren.get(commonIndex);
            if (childEntry.getNameId() != rightChildEntry.getNameId() || childEntry.isDirectory() != rightChildEntry.isDirectory()) break;
            childEntry.collectDifferencesWith(rightChildEntry, consumer);
        }
        if (commonIndex == myChildrenSize && commonIndex == rightChildrenSize) {
            return;
        }
        Int2ObjectOpenHashMap uniqueNameIdToMyChildEntries = new Int2ObjectOpenHashMap(myChildrenSize - commonIndex);
        for (int i = commonIndex; i < myChildrenSize; ++i) {
            Entry childEntry = this.myChildren.get(i);
            uniqueNameIdToMyChildEntries.put(childEntry.getNameId(), (Object)childEntry);
        }
        Int2ObjectOpenHashMap uniqueNameIdToRightChildEntries = new Int2ObjectOpenHashMap(rightChildrenSize - commonIndex);
        Int2ObjectOpenHashMap myNameIdToRightChildEntries = new Int2ObjectOpenHashMap(rightChildrenSize - commonIndex);
        for (int i = commonIndex; i < rightChildrenSize; ++i) {
            Entry rightChildEntry = e.myChildren.get(i);
            int rightChildEntryNameId = rightChildEntry.getNameId();
            myChildEntry = (Entry)uniqueNameIdToMyChildEntries.get(rightChildEntryNameId);
            if (myChildEntry != null && myChildEntry.isDirectory() == rightChildEntry.isDirectory()) {
                uniqueNameIdToMyChildEntries.remove(rightChildEntryNameId);
                myNameIdToRightChildEntries.put(rightChildEntryNameId, (Object)rightChildEntry);
                continue;
            }
            uniqueNameIdToRightChildEntries.put(rightChildEntryNameId, (Object)rightChildEntry);
        }
        if (!(Paths.isCaseSensitive() || uniqueNameIdToMyChildEntries.isEmpty() || uniqueNameIdToRightChildEntries.isEmpty())) {
            Map nameToEntryMap = CollectionFactory.createCaseInsensitiveStringMap((int)uniqueNameIdToMyChildEntries.size());
            for (Entry entry : uniqueNameIdToMyChildEntries.values()) {
                nameToEntryMap.put(entry.getName(), entry);
            }
            ObjectIterator rightChildEntryIterator = uniqueNameIdToRightChildEntries.values().iterator();
            while (rightChildEntryIterator.hasNext()) {
                Entry rightChildEntry = (Entry)rightChildEntryIterator.next();
                myChildEntry = (Entry)nameToEntryMap.get(rightChildEntry.getName());
                if (myChildEntry == null || rightChildEntry.isDirectory() != myChildEntry.isDirectory()) continue;
                myNameIdToRightChildEntries.put(myChildEntry.getNameId(), (Object)rightChildEntry);
                uniqueNameIdToMyChildEntries.remove(myChildEntry.getNameId());
                rightChildEntryIterator.remove();
            }
        }
        for (Entry child : e.myChildren) {
            if (!uniqueNameIdToRightChildEntries.containsKey(child.getNameId())) continue;
            child.collectCreatedDifferences(consumer);
        }
        for (Entry child : this.myChildren) {
            if (uniqueNameIdToMyChildEntries.containsKey(child.getNameId())) {
                child.collectDeletedDifferences(consumer);
                continue;
            }
            Entry itsChild = (Entry)myNameIdToRightChildEntries.get(child.getNameId());
            if (itsChild == null) continue;
            child.collectDifferencesWith(itsChild, consumer);
        }
    }

    public Entry findDirectChild(String name, boolean isDirectory) {
        int nameHash = DirectoryEntry.calcNameHash(name);
        for (Entry child : this.getChildren()) {
            if (child.isDirectory() != isDirectory || nameHash != child.getNameHash() || !child.nameEquals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    protected void collectCreatedDifferences(@NotNull BiConsumer<Entry, Entry> consumer) {
        if (consumer == null) {
            DirectoryEntry.$$$reportNull$$$0(3);
        }
        consumer.accept(null, this);
        for (Entry child : this.myChildren) {
            child.collectCreatedDifferences(consumer);
        }
    }

    @Override
    protected void collectDeletedDifferences(@NotNull BiConsumer<Entry, Entry> consumer) {
        if (consumer == null) {
            DirectoryEntry.$$$reportNull$$$0(4);
        }
        consumer.accept(this, null);
        for (Entry child : this.myChildren) {
            child.collectDeletedDifferences(consumer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/history/core/tree/DirectoryEntry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/history/core/tree/DirectoryEntry";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectDifferencesWith";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectCreatedDifferences";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectDeletedDifferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

