/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.uk;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.DateChecker;
import ai.grazie.rules.common.FeatureRestriction;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.uk.AgreementSet;
import ai.grazie.rules.uk.Case;
import ai.grazie.rules.uk.UkrainianTreeSupport;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tools.StringTools;

class UkrainianDateChecker
extends DateChecker {
    private static final List<String> shortDayNames = List.of("\u043f\u043d", "\u0432\u0442", "\u0441\u0440", "\u0447\u0442", "\u043f\u0442", "\u0441\u0431", "\u043d\u0434");
    private static final Map<String, Integer> middleDayNames = Map.of("\u043f\u043e\u043d", 1, "\u0447\u0435\u0442", 4, "\u0441\u0443\u0431", 6, "\u043d\u0435\u0434", 7);
    static final UkrainianDateChecker INSTANCE = new UkrainianDateChecker();
    private static final NodePattern probablyNom = Case.v_naz.posPattern.withHeadRelation("root|nsubj.*");
    private static final NodePattern probablyGen = Case.v_rod.posPattern.withHeadRelation("obl");
    private static final NodePattern probablyAcc = Case.v_zna.posPattern.withDependent("case", NodePattern.N.form("[\u0443\u0432]|\u043f\u043e"));
    private static final NodePattern yearWord = NodePattern.or(NodePattern.N.form("\u0440\\.?"), NodePattern.N.lemma("\u0440\u0456\u043a"));
    private final NodePattern longMonth;
    private final NodePattern genLongMonth;
    private final NodePattern shortMonth;
    private final NodePattern dayOfMonth;
    private final NodePattern spelledMonthDate;
    private final NodePattern dayOfWeek;
    private static final NodePattern pastVerb = NodePattern.N.pos("verb:.*past:.*").message("\u0414\u0430\u0442\u0430 \u0437 \u043c\u0430\u0439\u0431\u0443\u0442\u043d\u044c\u043e\u0433\u043e \u043d\u0435 \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u0430\u0454 \u043c\u0438\u043d\u0443\u043b\u043e\u043c\u0443 \u0447\u0430\u0441\u0443 \u0434\u0456\u0454\u0441\u043b\u043e\u0432\u0430 \u00ab$_\u00bb");
    private static final NodePattern pastClause = NodePattern.or(pastVerb, NodePattern.N.withDependent("cop", pastVerb));

    private UkrainianDateChecker() {
        super(Locale.forLanguageTag("uk"), "d MMMM uuuu", "d MMMM");
        this.longMonth = NodePattern.N.lemma(String.join((CharSequence)"|", this.monthNames));
        this.genLongMonth = Case.v_rod.posPattern.and(this.longMonth);
        this.shortMonth = NodePattern.N.form(StreamEx.of((Collection)this.monthNames).map(s -> s.substring(0, 3)).joining((CharSequence)"|"));
        this.dayOfMonth = NodePattern.N.form("\\d\\d?");
        this.spelledMonthDate = this.dayOfMonth.markAs("Day").directlyBefore(NodePattern.or(this.genLongMonth, this.shortMonth).markAs("Month")).andOptionally(NodePattern.N.withNeighbor(2, year.markAs("Year")));
        this.dayOfWeek = NodePattern.or(NodePattern.N.lemma(String.join((CharSequence)"|", this.dayNames)), NodePattern.N.form(String.join((CharSequence)"|", shortDayNames) + "|" + String.join((CharSequence)"|", middleDayNames.keySet())));
    }

    @Override
    protected String weekdayExampleSentence(String date, String day) {
        return "\u0421\u044c\u043e\u0433\u043e\u0434\u043d\u0456 <b>" + day.replace("\u02bc", "'") + ", " + date.replaceFirst("(\\d+)", "$1</b>") + ".";
    }

    @Override
    protected String wrongWeekdayMessage(LocalDate date, DayOfWeek day, String sentenceText, DateChecker.YearStrategy strategy) {
        String prefix = strategy == DateChecker.YearStrategy.current ? "\u0412\u0438 \u043c\u0430\u043b\u0438 \u043d\u0430 \u0443\u0432\u0430\u0437\u0456 \u0446\u0435\u0439 \u0440\u0456\u043a? " : "";
        return prefix + this.canonicalDateFormat.format(date) + " \u0440\u043e\u043a\u0443 \u043d\u0435 " + this.renderDay(this.locale, day);
    }

    NodePattern absolutePattern() {
        return NodePattern.or(this.wrongWeekday(DateChecker.YearStrategy.absolute), this.invalidDate(), UkrainianDateChecker.fiveDigitYear());
    }

    NodePattern relativePattern() {
        return NodePattern.or(this.futureDatePastVerb(), this.dateFromLastYear(), this.wrongWeekday(DateChecker.YearStrategy.current));
    }

    private NodePattern dateFromLastYear() {
        return NodePattern.or(this.spelledMonthDate.and(NodePattern.markedNodeMatches("Year", NodePattern.N.includeIntoReport())), dashDate, dottedDateNode).andNot(NodePattern.N.after(this.dayOfWeek)).andNot(CommonPatterns.possiblySkipUp("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("\u0432\u0456\u0434|\u043f\u0456\u0441\u043b\u044f|\u0437|\u0437\u0456|\u0456\u0437")))).and((node, match) -> this.checkDateFromLastYear(node, match, this.extractFullDate(node, DateChecker.YearStrategy.absolute), "\u0412\u0438 \u043c\u0430\u043b\u0438 \u043d\u0430 \u0443\u0432\u0430\u0437\u0456 %s-\u0439 \u0440\u0456\u043a, \u0449\u043e \u043d\u0430\u0441\u0442\u0430\u0432?"));
    }

    private NodePattern futureDatePastVerb() {
        NodePattern withFutureAllowingPrep = NodePattern.N.withDependent("case", NodePattern.N.form("\u043d\u0430"));
        NodePattern allowFuture = NodePattern.or(withFutureAllowingPrep, NodePattern.N.withPrevSibling(CommonPatterns.possiblySkipDown("nmod", withFutureAllowingPrep)));
        return NodePattern.or(NodePattern.or(this.spelledMonthDate, dottedDateNode).reportEverythingTouched().andNot(allowFuture).and(node -> {
            DateChecker.ParsedDate date = this.extractFullDate((Node)node, DateChecker.YearStrategy.absolute);
            return date != null && date.isInFuture();
        }), year.andOptionally(NodePattern.N.directlyAfter(this.longMonth.markAs("Month"))).andOptionally(NodePattern.N.directlyBefore(yearWord.markAs("YearWord"))).reportEverythingTouched().and((node, match) -> {
            Node month = match.findMarkedNode("Month");
            Node yearWord = match.findMarkedNode("YearWord");
            if (month == null && yearWord == null) {
                return null;
            }
            if (Stream.of(month, yearWord, node).anyMatch(allowFuture::matches)) {
                return null;
            }
            LocalDate date = UkrainianDateChecker.validDate(Integer.parseInt(node.form()), month == null ? Month.JANUARY : this.findMonth(month), 1);
            return date != null && date.isAfter(UkrainianDateChecker.now()) ? match : null;
        })).withHead("amod|nmod|nummod|obl", CommonPatterns.skipUp("nmod", CommonPatterns.skipUp("obl", pastClause)));
    }

    private static NodePattern fiveDigitYear() {
        return NodePattern.N.withHead("amod|nmod|nummod", yearWord).directlyBeforeHead().and(UkrainianDateChecker.fiveDigitYear("\u0412\u0438 \u043c\u0430\u043b\u0438 \u043d\u0430 \u0443\u0432\u0430\u0437\u0456 \u0447\u043e\u0442\u0438\u0440\u0438\u0437\u043d\u0430\u0447\u043d\u0438\u0439 \u0440\u0456\u043a?"));
    }

    private NodePattern wrongWeekday(DateChecker.YearStrategy strategy) {
        return this.dayOfWeek.and((weekday, match) -> {
            Node next = weekday.nextNode();
            if (CommonPatterns.comma.matches(next)) {
                next = next.nextNode();
            }
            DateChecker.ParsedDate date = next == null ? null : this.extractFullDate(next, strategy);
            return date == null ? null : this.checkWeekday(weekday, match, date, strategy);
        });
    }

    @Override
    protected boolean hasPastTenseAround(Node dayName) {
        return dayName.hierarchy().anyMatch(pastClause::matches);
    }

    @Nullable
    private DateChecker.ParsedDate extractFullDate(@NotNull Node start, DateChecker.YearStrategy strategy) {
        NodeMatch match = this.spelledMonthDate.match(start);
        if (match != null) {
            return DateChecker.ParsedDate.fromNodes(match.getMarkedNode("Day"), match.getMarkedNode("Month"), match.findMarkedNode("Year"), strategy, this::findMonth);
        }
        return DateChecker.ParsedDate.fromDMYDotDate(start, strategy);
    }

    private NodePattern invalidDate() {
        NodePattern startDate = this.dayOfMonth.withDependent("case", NodePattern.N.form("\u0456?\u0437")).markAs("Start").noDependents(NodePattern.or(this.genLongMonth, this.shortMonth));
        return NodePattern.or(this.spelledMonthDate.reportEverythingTouched().and((node, match) -> {
            Node year = match.findMarkedNode("Year");
            return this.checkInvalidDayOfMonth(match, this.findMonth(match.getMarkedNode("Month")), match.getMarkedNode("Day").form(), null, year == null ? null : year.form());
        }), this.genLongMonth.withHead(this.dayOfMonth.withDependent("case", NodePattern.N.form("\u0434\u043e|\u043f\u043e")).markAs("End").andOr(NodePattern.N.withHead("amod|nmod|nummod", startDate), NodePattern.N.withPrevSibling(startDate))).reportRangeTo("Start").and((node, match) -> {
            String start = match.getMarkedNode("Start").form();
            String end = match.getMarkedNode("End").form();
            if (Integer.parseInt(start) >= Integer.parseInt(end)) {
                return match.withMessage("\u0414\u0430\u0442\u0430 \u043f\u043e\u0447\u0430\u0442\u043a\u0443 \u043c\u0430\u0454 \u0431\u0443\u0442\u0438 \u0440\u0430\u043d\u0456\u0448\u0435 \u0434\u0430\u0442\u0438 \u043a\u0456\u043d\u0446\u044f");
            }
            Node next = node.nextNode();
            return this.checkInvalidDayOfMonth(match, this.findMonth(node), start, end, year.matches(next) ? next.form() : null);
        }));
    }

    @Override
    protected DayOfWeek findDayOfWeek(Node weekday) {
        Integer middle = middleDayNames.get(weekday.lowForm());
        if (middle != null) {
            return DayOfWeek.of(middle);
        }
        int shortIndex = shortDayNames.indexOf(weekday.lowForm());
        return DayOfWeek.of(shortIndex >= 0 ? shortIndex + 1 : UkrainianDateChecker.findStarting(weekday.lemmaReadings().get(0), this.dayNames) + 1);
    }

    private Month findMonth(Node month) {
        List<String> lemmaReadings = month.lemmaReadings();
        for (String reading : lemmaReadings) {
            int index = this.monthNames.indexOf(reading);
            if (index < 0) continue;
            return Month.of(index + 1);
        }
        return Month.of(UkrainianDateChecker.findStarting(month.form(), this.monthNames) + 1);
    }

    @Override
    protected String renderDay(Locale locale, DayOfWeek day) {
        return UkrainianTreeSupport.normalizeApostrophes(super.renderDay(locale, day));
    }

    @Override
    protected NodeCorrector weekdayCorrector(Node dayName, DayOfWeek expected) {
        return dayName.form().length() <= 3 ? NodeCorrector.replace(dayName, shortDayNames.get(expected.ordinal())) : NodeCorrector.replace(dayName, this.inflectedFullName(dayName, expected));
    }

    private List<String> inflectedFullName(Node dayName, DayOfWeek expected) {
        String base = this.renderDay(this.locale, expected);
        Set<Case> possible = UkrainianDateChecker.casesToSuggest(dayName);
        List present = ((StreamEx)StreamEx.of((Object[])Case.values()).filter(c -> c.isPresentOn(dayName))).toList();
        List intersection = possible == null ? present : ((StreamEx)StreamEx.of((Collection)present).filter(possible::contains)).toList();
        return dayName.tree().treeSupport().synthesize(base, base, ".*", "noun:inanim:[fm]:(" + StreamEx.of((Collection)intersection).map(Enum::toString).joining((CharSequence)"|") + ")($|:.*)");
    }

    @Nullable
    private static Set<Case> casesToSuggest(Node dayName) {
        if (probablyNom.matches(dayName)) {
            return Set.of(Case.v_naz);
        }
        if (probablyAcc.matches(dayName)) {
            return Set.of(Case.v_zna);
        }
        if (probablyGen.matches(dayName)) {
            return Set.of(Case.v_rod);
        }
        FeatureRestriction<Case> restriction = AgreementSet.calcPossibleCases(dayName);
        return restriction == null ? null : restriction.allowed();
    }

    @Nullable
    private NodeMatch checkInvalidDayOfMonth(NodeMatch match, Month month, @Nullable String startDay, @Nullable String endDay, @Nullable String year) {
        int maxDays;
        int n = maxDays = year == null ? month.maxLength() : month.length(UkrainianDateChecker.isLeapYear(year));
        if (startDay != null && Integer.parseInt(startDay) > maxDays || endDay != null && Integer.parseInt(endDay) > maxDays) {
            if (month == Month.FEBRUARY && year != null) {
                return match.withMessage("\u041b\u044e\u0442\u0438\u0439 \u0443 " + year + " \u0440\u043e\u0446\u0456 \u043c\u0456\u0441\u0442\u0438\u0442\u044c \u043b\u0438\u0448\u0435 " + maxDays + " \u0434\u043d\u0456\u0432");
            }
            return match.withMessage(StringTools.uppercaseFirstChar((String)this.renderMonth(month)) + " \u043c\u0456\u0441\u0442\u0438\u0442\u044c \u043b\u0438\u0448\u0435 " + maxDays + " \u0434\u043d\u0456\u0432");
        }
        return null;
    }
}

