/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.core.Utils;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.AzureIdpHostUtil;
import com.amazon.redshift.plugin.SamlCredentialsProvider;
import java.io.IOException;
import software.amazon.awssdk.core.exception.SdkClientException;

public class AzureCredentialsProvider
extends SamlCredentialsProvider {
    private static final String KEY_IDP_TENANT = "idp_tenant";
    private static final String KEY_IDP_PARTITION = "idp_partition";
    private static final String KEY_CLIENT_SECRET = "client_secret";
    private static final String KEY_CLIENT_ID = "client_id";
    private String m_idpTenant;
    private String m_idpPartition;
    private String m_clientSecret;
    private String m_clientId;

    @Override
    protected String getSamlAssertion() throws IOException {
        if (Utils.isNullOrEmpty(this.m_idpTenant)) {
            throw new IOException("Missing required property: idp_tenant");
        }
        if (Utils.isNullOrEmpty(this.m_userName)) {
            throw new IOException("Missing required property: " + RedshiftProperty.UID.getName() + " or " + RedshiftProperty.USER.getName());
        }
        if (Utils.isNullOrEmpty(this.m_password)) {
            throw new IOException("Missing required property: " + RedshiftProperty.PWD.getName() + " or " + RedshiftProperty.PASSWORD.getName());
        }
        if (Utils.isNullOrEmpty(this.m_clientSecret)) {
            throw new IOException("Missing required property: client_secret");
        }
        if (Utils.isNullOrEmpty(this.m_clientId)) {
            throw new IOException("Missing required property: client_id");
        }
        return this.azureOauthBasedAuthentication();
    }

    @Override
    public void addParameter(String key, String value) {
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("key: {0}", key);
        }
        if (KEY_IDP_TENANT.equalsIgnoreCase(key)) {
            this.m_idpTenant = value;
        } else if (KEY_IDP_PARTITION.equalsIgnoreCase(key)) {
            AzureIdpHostUtil.validatePartition(value);
            this.m_idpPartition = value;
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("m_idpPartition: {0}", this.m_idpPartition);
            }
        } else if (KEY_CLIENT_SECRET.equalsIgnoreCase(key)) {
            this.m_clientSecret = value;
        } else if (KEY_CLIENT_ID.equalsIgnoreCase(key)) {
            this.m_clientId = value;
        } else {
            super.addParameter(key, value);
        }
    }

    @Override
    public String getPluginSpecificCacheKey() {
        return (this.m_idpTenant != null ? this.m_idpTenant : "") + (this.m_clientId != null ? this.m_clientId : "") + (this.m_clientSecret != null ? this.m_clientSecret : "");
    }

    /*
     * Exception decompiling
     */
    private String azureOauthBasedAuthentication() throws IOException, SdkClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

