/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.firebirdsql.jaybird.util.CollectionUtils;
import org.firebirdsql.jdbc.FBProcedureParam;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class FBProcedureCall {
    private static final String NATIVE_CALL_COMMAND = "EXECUTE PROCEDURE ";
    private static final String NATIVE_SELECT_COMMAND = "SELECT * FROM ";
    private @Nullable String name;
    private List<@Nullable FBProcedureParam> inputParams = new ArrayList<FBProcedureParam>();
    private List<@Nullable FBProcedureParam> outputParams = new ArrayList<FBProcedureParam>();

    public FBProcedureCall() {
    }

    private FBProcedureCall(FBProcedureCall source) {
        this.name = source.name;
        this.inputParams = FBProcedureCall.cloneParameters(source.inputParams);
        this.outputParams = FBProcedureCall.cloneParameters(source.outputParams);
    }

    public static FBProcedureCall copyOf(FBProcedureCall source) {
        return new FBProcedureCall(source);
    }

    private static List<@Nullable FBProcedureParam> cloneParameters(List<@Nullable FBProcedureParam> parameters) {
        ArrayList<@Nullable FBProcedureParam> clonedParameters = new ArrayList<FBProcedureParam>(parameters.size());
        for (FBProcedureParam param : parameters) {
            clonedParameters.add(param != null ? (FBProcedureParam)param.clone() : null);
        }
        return clonedParameters;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FBProcedureParam getInputParam(int index) {
        FBProcedureParam result = FBProcedureCall.getParam(this.inputParams, index);
        if (result == NullParam.NULL_PARAM) {
            result = FBProcedureCall.getParam(this.outputParams, index);
            CollectionUtils.growToSize(this.inputParams, index);
            this.inputParams.set(index - 1, result);
        }
        return result;
    }

    public FBProcedureParam getOutputParam(int index) {
        return FBProcedureCall.getParam(this.outputParams, index);
    }

    private static FBProcedureParam getParam(Collection<@Nullable FBProcedureParam> params, int index) {
        for (FBProcedureParam param : params) {
            if (param == null || param.getIndex() != index) continue;
            return param;
        }
        return NullParam.NULL_PARAM;
    }

    public int mapOutParamIndexToPosition(int index) throws SQLException {
        int position = 0;
        for (FBProcedureParam param : this.outputParams) {
            if (param == null || !param.isParam()) continue;
            ++position;
            if (param.getIndex() != index) continue;
            return position;
        }
        return index;
    }

    public List<@Nullable FBProcedureParam> getInputParams() {
        return this.inputParams;
    }

    public List<@Nullable FBProcedureParam> getOutputParams() {
        return this.outputParams;
    }

    public void addInputParam(FBProcedureParam param) {
        FBProcedureCall.addParam(this.inputParams, param);
    }

    public void addOutputParam(FBProcedureParam param) {
        FBProcedureCall.addParam(this.outputParams, param);
    }

    private static void addParam(List<@Nullable FBProcedureParam> params, FBProcedureParam param) {
        CollectionUtils.growToSize(params, param.getPosition() + 1);
        params.set(param.getPosition(), param);
    }

    public FBProcedureParam addParam(int position, String param) {
        String possibleInIndicator;
        String possibleOutIndicator;
        param = param.trim();
        boolean isInputParam = true;
        if (param.length() > 4 && "OUT".equalsIgnoreCase(possibleOutIndicator = param.substring(0, 3)) && Character.isSpaceChar(param.charAt(3))) {
            isInputParam = false;
            param = param.substring(4).trim();
        }
        if (isInputParam && param.length() > 4 && "IN".equalsIgnoreCase(possibleInIndicator = param.substring(0, 2)) && Character.isSpaceChar(param.charAt(2))) {
            param = param.substring(3).trim();
        }
        FBProcedureParam callParam = new FBProcedureParam(position, param);
        if (isInputParam) {
            this.addInputParam(callParam);
        } else {
            this.addOutputParam(callParam);
        }
        return callParam;
    }

    public void registerOutParam(int index, int type) throws SQLException {
        FBProcedureParam param = this.getInputParam(index);
        if (param == NullParam.NULL_PARAM) {
            param = this.getOutputParam(index);
        } else {
            this.addOutputParam(param);
            if (!param.isValueSet()) {
                this.inputParams.set(param.getPosition(), null);
            }
        }
        if (param == NullParam.NULL_PARAM) {
            throw new SQLException("Cannot find parameter with the specified position", "HY091");
        }
        param.setType(type);
    }

    public String getSQL(boolean select) throws SQLException {
        StringBuilder sb = new StringBuilder(select ? NATIVE_SELECT_COMMAND : NATIVE_CALL_COMMAND);
        sb.append(this.name);
        boolean firstParam = true;
        sb.append('(');
        for (FBProcedureParam param : this.inputParams) {
            if (param == null) continue;
            if (!firstParam) {
                sb.append(',');
            } else {
                firstParam = false;
            }
            sb.append(param.getParamValue());
        }
        if (firstParam) {
            sb.setLength(sb.length() - 1);
        } else {
            sb.append(')');
        }
        return sb.toString();
    }

    public void checkParameters() throws SQLException {
        for (FBProcedureParam param : this.inputParams) {
            if (param == null || param.isValueSet() || !param.isParam() || this.outputParams.isEmpty() || this.outputParams.get(param.getPosition()) != null) continue;
            throw new SQLException("Value of parameter %d not set and it was not registered as output parameter".formatted(param.getIndex()), "07001");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FBProcedureCall)) return false;
        FBProcedureCall other = (FBProcedureCall)obj;
        if (!Objects.equals(this.name, other.name)) return false;
        if (!this.inputParams.equals(other.inputParams)) return false;
        if (!this.outputParams.equals(other.outputParams)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.inputParams, this.outputParams);
    }

    private static final class NullParam
    extends FBProcedureParam {
        private static final NullParam NULL_PARAM = new NullParam();

        private NullParam() {
            super(-1, "NULL");
        }

        @Override
        public void setValue(@Nullable Object value) throws SQLException {
            throw new SQLException("You cannot set value of a non-existing parameter", "HY011");
        }

        @Override
        public void setIndex(int index) {
            throw new UnsupportedOperationException("You cannot set index of a non-existing parameter");
        }

        @Override
        public void setType(int type) {
            throw new UnsupportedOperationException("You cannot set type of a non-existing parameter");
        }
    }
}

