/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.table;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.zaproxy.zap.view.table.AbstractHistoryReferencesTableModel;
import org.zaproxy.zap.view.table.HistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;

public abstract class AbstractCustomColumnHistoryReferencesTableModel<T extends HistoryReferencesTableEntry>
extends AbstractHistoryReferencesTableModel<T> {
    private static final long serialVersionUID = 3943406327364886416L;
    private final Map<Integer, Integer> cacheColumnIdxToIdxCustomColumnsOnly;

    public AbstractCustomColumnHistoryReferencesTableModel(HistoryReferencesTableModel.Column[] columns) {
        super(columns);
        this.cacheColumnIdxToIdxCustomColumnsOnly = AbstractCustomColumnHistoryReferencesTableModel.buildCacheColumnIdxToIdxCustomColumnsOnly(columns);
    }

    private static Map<Integer, Integer> buildCacheColumnIdxToIdxCustomColumnsOnly(HistoryReferencesTableModel.Column[] columns) {
        TreeMap<Integer, Integer> tempCustomColumnIndexesMap = new TreeMap<Integer, Integer>();
        int countCustomColumns = 0;
        for (int columnIndex = 0; columnIndex < columns.length; ++columnIndex) {
            if (!AbstractCustomColumnHistoryReferencesTableModel.isCustomColumn(columns, columnIndex)) continue;
            tempCustomColumnIndexesMap.put(columnIndex, countCustomColumns);
            ++countCustomColumns;
        }
        if (tempCustomColumnIndexesMap.isEmpty()) {
            return Collections.emptyMap();
        }
        return tempCustomColumnIndexesMap;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object entry = this.getEntry(rowIndex);
        HistoryReferencesTableModel.Column column = this.getColumn(columnIndex);
        if (column == HistoryReferencesTableModel.Column.CUSTOM) {
            return this.getCustomValueAt(entry, columnIndex);
        }
        return entry.getValue(column);
    }

    protected abstract Object getCustomValueAt(T var1, int var2);

    @Override
    public String getColumnName(int columnIndex) {
        if (this.isCustomColumn(columnIndex)) {
            return this.getCustomColumnName(columnIndex);
        }
        return super.getColumnName(columnIndex);
    }

    protected abstract String getCustomColumnName(int var1);

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        HistoryReferencesTableModel.Column column = this.getColumn(columnIndex);
        if (column == HistoryReferencesTableModel.Column.CUSTOM) {
            return this.getCustomColumnClass(columnIndex);
        }
        return this.getColumnClass(column);
    }

    protected abstract Class<?> getColumnClass(HistoryReferencesTableModel.Column var1);

    protected abstract Class<?> getCustomColumnClass(int var1);

    @Override
    public Object getPrototypeValue(int columnIndex) {
        HistoryReferencesTableModel.Column column = this.getColumn(columnIndex);
        if (column == HistoryReferencesTableModel.Column.CUSTOM) {
            return this.getCustomPrototypeValue(columnIndex);
        }
        return this.getPrototypeValue(column);
    }

    protected abstract Object getPrototypeValue(HistoryReferencesTableModel.Column var1);

    protected abstract Object getCustomPrototypeValue(int var1);

    protected int getCustomColumnIndex(int columnIndex) {
        Integer customColumnIndex = this.cacheColumnIdxToIdxCustomColumnsOnly.get(columnIndex);
        if (customColumnIndex != null) {
            return customColumnIndex;
        }
        return -1;
    }
}

