#!/bin/bash

sign()
{
   unsigned=
   for i in $list ; do
      if ! rpm -K redhat/RPMS/$i | grep -q gpg ; then
         unsigned="$unsigned redhat/RPMS/$i"
      fi
   done

   if [ -n "$unsigned" ] ; then
      command="rpm $macro --resign $unsigned"
      echo $command
      eval "$command"
   fi
}

arch()
{
echo $url$1/
   ../../rpmlist $url$1/ | cut -c3- > $1.tmp
   ../../rpmlist $url2$1/ | cut -c3- > $1.tmp2
   for i in $(ls redhat/RPMS/$1/) ; do
      if grep -q $i $1.tmp ; then
         #echo $i already uploaded
         echo -n
      else
         # perhaps this has been archived?
         if grep -q $i $1.tmp2 ; then
        # if [ -f /tmp/centos2update-archive/$1/$i ] ; then
            echo $i is archived > /dev/null
         else
            list="$list $1/$i"
         fi
      fi
   done
   rm $1.tmp
   rm $1.tmp2
}

upload()
{
   for i in $list ; do
      if rpm -K redhat/RPMS/$i | grep -q gpg ; then
         echo uploading $i
         scp -Bq redhat/RPMS/$i $UPLOAD/$i
      else
         echo not signed $i
      fi
   done
}

if [ -d "$1" ] ; then
   export startdir=$1
   cd $1
else
   echo $0 directory
   exit
fi

. config

macro=""
macro="$macro --define \"_gpg_name $KEY\" "

url=$UPLOADED
url2=$ARCHIVED
dir=`echo $url | cut -d / -f 4-`
#url=`cat url.txt`
#dir=`cat url.txt | cut -d / -f 4-`

arch i386
arch i686
arch athlon
arch noarch

sign 

#echo $list
upload

if [ -d $UPLOAD ] ; then
   (cd $UPLOAD ; yum-arch . | grep -v "ignoring ")
fi
