/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import java.net.URI;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.flavours.commonmark.CommonMarkFlavourDescriptor;
import org.intellij.markdown.flavours.gfm.CheckedListItemGeneratingProvider;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMMarkerProcessor;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.flavours.gfm.StrikeThroughDelimiterParser;
import org.intellij.markdown.flavours.gfm.TableAwareCodeSpanGeneratingProvider;
import org.intellij.markdown.flavours.gfm.TablesGeneratingProvider;
import org.intellij.markdown.flavours.gfm.lexer._GFMLexer;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.SimpleInlineTagProvider;
import org.intellij.markdown.html.TrimmingInlineHolderProvider;
import org.intellij.markdown.html.XssSafeLinksKt;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.lexer.MarkdownLexer;
import org.intellij.markdown.parser.LinkMap;
import org.intellij.markdown.parser.MarkerProcessorFactory;
import org.intellij.markdown.parser.sequentialparsers.DelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.EmphasisLikeParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParserManager;
import org.intellij.markdown.parser.sequentialparsers.impl.AutolinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.BacktickParser;
import org.intellij.markdown.parser.sequentialparsers.impl.EmphStrongDelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ImageParser;
import org.intellij.markdown.parser.sequentialparsers.impl.InlineLinkParser;
import org.intellij.markdown.parser.sequentialparsers.impl.ReferenceLinkParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J,\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/intellij/markdown/flavours/gfm/GFMFlavourDescriptor;", "Lorg/intellij/markdown/flavours/commonmark/CommonMarkFlavourDescriptor;", "useSafeLinks", "", "absolutizeAnchorLinks", "makeHttpsAutoLinks", "(ZZZ)V", "markerProcessorFactory", "Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "getMarkerProcessorFactory", "()Lorg/intellij/markdown/parser/MarkerProcessorFactory;", "sequentialParserManager", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "getSequentialParserManager", "()Lorg/intellij/markdown/parser/sequentialparsers/SequentialParserManager;", "createHtmlGeneratingProviders", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "baseURI", "Ljava/net/URI;", "Lorg/intellij/markdown/html/URI;", "createInlinesLexer", "Lorg/intellij/markdown/lexer/MarkdownLexer;", "markdown"})
public class GFMFlavourDescriptor
extends CommonMarkFlavourDescriptor {
    private final boolean makeHttpsAutoLinks;
    @NotNull
    private final MarkerProcessorFactory markerProcessorFactory;
    @NotNull
    private final SequentialParserManager sequentialParserManager;

    public GFMFlavourDescriptor(boolean useSafeLinks, boolean absolutizeAnchorLinks, boolean makeHttpsAutoLinks) {
        super(useSafeLinks, absolutizeAnchorLinks);
        this.makeHttpsAutoLinks = makeHttpsAutoLinks;
        this.markerProcessorFactory = GFMMarkerProcessor.Factory.INSTANCE;
        this.sequentialParserManager = new SequentialParserManager(){

            @NotNull
            public List<SequentialParser> getParserSequence() {
                SequentialParser[] sequentialParserArray = new SequentialParser[6];
                Object[] objectArray = new IElementType[]{MarkdownTokenTypes.AUTOLINK, GFMTokenTypes.GFM_AUTOLINK};
                sequentialParserArray[0] = new AutolinkParser(CollectionsKt.listOf(objectArray));
                sequentialParserArray[1] = new BacktickParser();
                sequentialParserArray[2] = new ImageParser();
                sequentialParserArray[3] = new InlineLinkParser();
                sequentialParserArray[4] = new ReferenceLinkParser();
                objectArray = new DelimiterParser[]{new EmphStrongDelimiterParser(), new StrikeThroughDelimiterParser()};
                sequentialParserArray[5] = new EmphasisLikeParser((DelimiterParser[])objectArray);
                return CollectionsKt.listOf(sequentialParserArray);
            }
        };
    }

    public /* synthetic */ GFMFlavourDescriptor(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        this(bl, bl2, bl3);
    }

    @Override
    @NotNull
    public MarkerProcessorFactory getMarkerProcessorFactory() {
        return this.markerProcessorFactory;
    }

    @Override
    @NotNull
    public MarkdownLexer createInlinesLexer() {
        return new MarkdownLexer(new _GFMLexer());
    }

    @Override
    @NotNull
    public SequentialParserManager getSequentialParserManager() {
        return this.sequentialParserManager;
    }

    @Override
    @NotNull
    public Map<IElementType, GeneratingProvider> createHtmlGeneratingProviders(@NotNull LinkMap linkMap, @Nullable URI baseURI) {
        Intrinsics.checkNotNullParameter(linkMap, "linkMap");
        Pair[] pairArray = new Pair[]{TuplesKt.to(GFMElementTypes.STRIKETHROUGH, new SimpleInlineTagProvider(){

            public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text2, @NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter(visitor2, "visitor");
                Intrinsics.checkNotNullParameter(text2, "text");
                Intrinsics.checkNotNullParameter(node, "node");
                CharSequence[] charSequenceArray = new CharSequence[]{"class=\"user-del\""};
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor2, node, this.getTagName(), charSequenceArray, false, 8, null);
            }
        }), TuplesKt.to(GFMElementTypes.TABLE, new TablesGeneratingProvider()), TuplesKt.to(GFMTokenTypes.CELL, new TrimmingInlineHolderProvider()), TuplesKt.to(MarkdownElementTypes.CODE_SPAN, new TableAwareCodeSpanGeneratingProvider()), TuplesKt.to(GFMTokenTypes.GFM_AUTOLINK, new GeneratingProvider(this){
            final /* synthetic */ GFMFlavourDescriptor this$0;
            {
                this.this$0 = $receiver;
            }

            public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor2, @NotNull String text2, @NotNull ASTNode node) {
                Intrinsics.checkNotNullParameter(visitor2, "visitor");
                Intrinsics.checkNotNullParameter(text2, "text");
                Intrinsics.checkNotNullParameter(node, "node");
                CharSequence linkText = ASTUtilKt.getTextInNode(node, text2);
                IElementType[] iElementTypeArray = new IElementType[]{MarkdownElementTypes.LINK_LABEL, MarkdownElementTypes.LINK_TEXT};
                if (ASTUtilKt.getParentOfType(node, iElementTypeArray) != null) {
                    visitor2.consumeHtml(linkText);
                    return;
                }
                CharSequence absoluteLink = this.hasSchema(linkText) ? linkText : (CharSequence)(GFMFlavourDescriptor.access$getMakeHttpsAutoLinks$p(this.this$0) ? Intrinsics.stringPlus("https://", linkText) : Intrinsics.stringPlus("http://", linkText));
                String link = EntityConverter.INSTANCE.replaceEntities(linkText, true, false);
                CharSequence[] charSequenceArray = LinkMap.Builder.normalizeDestination(absoluteLink, false);
                GFMFlavourDescriptor gFMFlavourDescriptor = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                CharSequence[] it = charSequenceArray;
                boolean bl3 = false;
                CharSequence[] normalizedDestination = GFMFlavourDescriptor.access$getUseSafeLinks(gFMFlavourDescriptor) ? XssSafeLinksKt.makeXssSafeDestination((CharSequence)it) : it;
                charSequenceArray = new CharSequence[]{"href=\"" + normalizedDestination + '\"'};
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor2, node, "a", charSequenceArray, false, 8, null);
                visitor2.consumeHtml(link);
                visitor2.consumeTagClose("a");
            }

            private final boolean hasSchema(CharSequence linkText) {
                int index = StringsKt.indexOf$default(linkText, '/', 0, false, 6, null);
                if (index == -1) {
                    return false;
                }
                return index != 0 && index + 1 < linkText.length() && linkText.charAt(index - 1) == ':' && linkText.charAt(index + 1) == '/';
            }
        }), TuplesKt.to(MarkdownElementTypes.LIST_ITEM, new CheckedListItemGeneratingProvider())};
        return MapsKt.plus(super.createHtmlGeneratingProviders(linkMap, baseURI), MapsKt.hashMapOf(pairArray));
    }

    public GFMFlavourDescriptor() {
        this(false, false, false, 7, null);
    }

    public static final /* synthetic */ boolean access$getMakeHttpsAutoLinks$p(GFMFlavourDescriptor $this) {
        return $this.makeHttpsAutoLinks;
    }

    public static final /* synthetic */ boolean access$getUseSafeLinks(GFMFlavourDescriptor $this) {
        return $this.getUseSafeLinks();
    }
}

