#
# spec file for caja-follow-symlink rpm
#
# based on the spec file for nautilus-follow-symlink
#

%define is_mandrake %(test -e /etc/mandrake-release && echo 1 || echo 0)
%define is_suse %(test -e /etc/SuSE-release && echo 1 || echo 0)
%define is_fedora 0%{?fedora}
%define is_redhat 0%{?rhl}
%define is_rhel 0%{?rhel}

%define distname generic
%define disttag .generic_lsb

%if %{is_fedora}
%define distname fedora
%define disttag %{dist}
%endif
%if %{is_redhat}
%define distname redhat
%define disttag %{dist}
%endif
%if %{is_mandrake}
%define distname mandrake
%define disttag .mdk
%endif
%if %{is_suse}
%define distname suse
%define disttag .suse
%endif
%if %{is_rhel}
%define distname rhel
%define disttag %{dist}
%endif

%define api_version 2.0

Name:	caja-follow-symlink
Version:	1.2.0
Release:	1%{?disttag}
Summary:	caja plugin to open the location pointed by a symlink

Group:		User Interface/Desktops
License:	LGPL
URL:		http://p.outlyer.net./caja-follow-symlink/
Source0:	%{url}/files/%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires:	intltool, libtool, caja-devel, gtk2-devel
Requires:	caja-extensions
AutoReqProv: yes
Prefix: /usr

%description
This extension adds a context menu option to symbolic links to folders which
opens the pointed folder instead of the symbolic link.

%prep
echo Building %{name}-%{version}-%{release}
%setup -q -n %{name}-%{version}


%build
%configure
make %{?_smp_mflags}


%install
make install DESTDIR=%buildroot
rm -f $RPM_BUILD_ROOT/%{_libdir}/caja/extensions-%{api_version}/*.{l,}a

# create %{name}.lang with the locale data. To be included by %files
%find_lang %{name}

%clean
[ ${RPM_BUILD_ROOT} != "/" ] && rm -rf $RPM_BUILD_ROOT


%files -f %{name}.lang
%defattr(-,root,root,-)
%doc AUTHORS ChangeLog
%_libdir/caja/extensions-%{api_version}/*.so


%changelog
* Thu Aug  9 2012 Toni Corvera <outlyer@gmail.com> - 1.2.1
- Removed the *upstream revision

* Thu Apr 30 2009 Toni Corvera <outlyer@gmail.com> - 1.1-1~upstream
- Packaging cleanup

* Wed Jun  4 2008 Toni Corvera <outlyer@gmail.com> - 1.0.99+pre.2-1upstream
- Initial package
