/* DMPage.c generated by valac 0.34.6, the Vala compiler
 * generated from DMPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <float.h>
#include <math.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "CbTypes.h"
#include "CbTextTransform.h"
#include <gio/gio.h>
#include <cairo.h>
#include <rest/rest-proxy-call.h>
#include <rest/rest-proxy.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_DM_PAGE (dm_page_get_type ())
#define DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_PAGE, DMPage))
#define DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_PAGE, DMPageClass))
#define IS_DM_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_PAGE))
#define IS_DM_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_PAGE))
#define DM_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_PAGE, DMPageClass))

typedef struct _DMPage DMPage;
typedef struct _DMPageClass DMPageClass;
typedef struct _DMPagePrivate DMPagePrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_COMPLETION_TEXT_VIEW (completion_text_view_get_type ())
#define COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextView))
#define COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))
#define IS_COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_TEXT_VIEW))
#define IS_COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_TEXT_VIEW))
#define COMPLETION_TEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))

typedef struct _CompletionTextView CompletionTextView;
typedef struct _CompletionTextViewClass CompletionTextViewClass;

#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;

#define TYPE_DM_PLACEHOLDER_BOX (dm_placeholder_box_get_type ())
#define DM_PLACEHOLDER_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_PLACEHOLDER_BOX, DMPlaceholderBox))
#define DM_PLACEHOLDER_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_PLACEHOLDER_BOX, DMPlaceholderBoxClass))
#define IS_DM_PLACEHOLDER_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_PLACEHOLDER_BOX))
#define IS_DM_PLACEHOLDER_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_PLACEHOLDER_BOX))
#define DM_PLACEHOLDER_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_PLACEHOLDER_BOX, DMPlaceholderBoxClass))

typedef struct _DMPlaceholderBox DMPlaceholderBox;
typedef struct _DMPlaceholderBoxClass DMPlaceholderBoxClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;

#define TYPE_DM_LIST_ENTRY (dm_list_entry_get_type ())
#define DM_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_LIST_ENTRY, DMListEntry))
#define DM_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_LIST_ENTRY, DMListEntryClass))
#define IS_DM_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_LIST_ENTRY))
#define IS_DM_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_LIST_ENTRY))
#define DM_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_LIST_ENTRY, DMListEntryClass))

typedef struct _DMListEntry DMListEntry;
typedef struct _DMListEntryClass DMListEntryClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _DMListEntryPrivate DMListEntryPrivate;
typedef struct _Block8Data Block8Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block9Data Block9Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block10Data Block10Data;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
typedef struct _Block11Data Block11Data;

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _Block12Data Block12Data;
typedef struct _DMPlaceholderBoxPrivate DMPlaceholderBoxPrivate;

#define TYPE_DM_THREADS_PAGE (dm_threads_page_get_type ())
#define DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPage))
#define DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))
#define IS_DM_THREADS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DM_THREADS_PAGE))
#define IS_DM_THREADS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DM_THREADS_PAGE))
#define DM_THREADS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DM_THREADS_PAGE, DMThreadsPageClass))

typedef struct _DMThreadsPage DMThreadsPage;
typedef struct _DMThreadsPageClass DMThreadsPageClass;

#define TYPE_PAGE (page_get_type ())
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE,
	STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _DMPage {
	GtkBox parent_instance;
	DMPagePrivate * priv;
	Account* account;
	DeltaUpdater* delta_updater;
	gint64 user_id;
};

struct _DMPageClass {
	GtkBoxClass parent_class;
};

struct _DMPagePrivate {
	MainWindow* main_window;
	gint _id;
	GtkButton* send_button;
	CompletionTextView* text_view;
	GtkListBox* messages_list;
	ScrollWidget* scroll_widget;
	DMPlaceholderBox* placeholder_box;
	gint64 lowest_id;
	gboolean was_scrolled_down;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
};

struct _DMListEntry {
	GtkListBoxRow parent_instance;
	DMListEntryPrivate * priv;
	gint64 timestamp;
	gint64 id;
	gint64 user_id;
	MainWindow* main_window;
};

struct _DMListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _Block8Data {
	int _ref_count_;
	DMPage* self;
	CbTextEntity* url_list;
	gint url_list_length1;
	gint _url_list_size_;
};

struct _Block9Data {
	int _ref_count_;
	DMPage* self;
	CbTextEntity* url_list;
	gint url_list_length1;
	gint _url_list_size_;
};

struct _Block10Data {
	int _ref_count_;
	DMPage* self;
	GDateTime* now;
};

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);
struct _Block11Data {
	int _ref_count_;
	Block10Data * _data10_;
	DMListEntry* entry;
};

struct _Block12Data {
	int _ref_count_;
	DMPage* self;
	gchar* screen_name;
	gchar* name;
	GDateTime* now;
};

struct _DMPlaceholderBox {
	GtkBox parent_instance;
	DMPlaceholderBoxPrivate * priv;
	gint64 user_id;
	gchar* avatar_url;
};

struct _DMPlaceholderBoxClass {
	GtkBoxClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Block13Data {
	int _ref_count_;
	Block12Data * _data12_;
	DMListEntry* entry;
};

struct _Block14Data {
	int _ref_count_;
	DMPage* self;
	RestProxyCall* call;
};


static gpointer dm_page_parent_class = NULL;
static IPageIface* dm_page_ipage_parent_iface = NULL;
static IMessageReceiverIface* dm_page_imessage_receiver_parent_iface = NULL;

GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType dm_page_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType completion_text_view_get_type (void) G_GNUC_CONST;
GType scroll_widget_get_type (void) G_GNUC_CONST;
GType dm_placeholder_box_get_type (void) G_GNUC_CONST;
#define DM_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DM_PAGE, DMPagePrivate))
enum  {
	DM_PAGE_DUMMY_PROPERTY,
	DM_PAGE_UNREAD_COUNT,
	DM_PAGE_WINDOW,
	DM_PAGE_ID
};
DMPlaceholderBox* dm_placeholder_box_new (void);
DMPlaceholderBox* dm_placeholder_box_construct (GType object_type);
DMPage* dm_page_new (gint id, Account* account, DeltaUpdater* delta_updater);
DMPage* dm_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater);
void ipage_set_id (IPage* self, gint value);
static void dm_page_recalc_length (DMPage* self);
static void _dm_page_recalc_length_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
gint itwitter_item_sort_func_inv (GtkListBoxRow* a, GtkListBoxRow* b);
static gint _itwitter_item_sort_func_inv_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
static void dm_page_load_older (DMPage* self);
static void _dm_page_load_older_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self);
static void __lambda95_ (DMPage* self);
void scroll_widget_scroll_down_next (ScrollWidget* self, gboolean animate, gboolean force_wait);
static void ___lambda95__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static void __lambda96_ (DMPage* self);
gboolean scroll_widget_get_scrolled_down (ScrollWidget* self);
static void ___lambda96__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
static void dm_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
GType dm_list_entry_get_type (void) G_GNUC_CONST;
GType itwitter_item_get_type (void) G_GNUC_CONST;
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void _vala_CbTextEntity_array_free (CbTextEntity* array, gint array_length);
static void block8_data_unref (void * _userdata_);
static void _______lambda97_ (Block8Data* _data8_, JsonArray* arr, guint index, JsonNode* node);
static void ________lambda97__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
void dm_list_entry_set_text (DMListEntry* self, const gchar* value);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void ____lambda98_ (Block9Data* _data9_, JsonArray* arr, guint index, JsonNode* node);
static void _____lambda98__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
DMListEntry* dm_list_entry_new (void);
DMListEntry* dm_list_entry_construct (GType object_type);
void dm_list_entry_set_name (DMListEntry* self, const gchar* value);
void dm_list_entry_set_screen_name (DMListEntry* self, const gchar* value);
GDateTime* utils_parse_date (const gchar* input);
gint itwitter_item_update_time_delta (ITwitterItem* self, GDateTime* now);
void dm_list_entry_load_avatar (DMListEntry* self, const gchar* avatar_url);
void delta_updater_add (DeltaUpdater* self, ITwitterItem* entry);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode);
#define TOP 1
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
SqlSelectStatement* sql_select_statement_where (SqlSelectStatement* self, const gchar* stmt);
SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by);
SqlSelectStatement* sql_select_statement_limit (SqlSelectStatement* self, gint limit);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
static gboolean __lambda92_ (Block10Data* _data10_, gchar** vals, int vals_length1);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
void twitter_load_avatar_for_user_id (Twitter* self, Account* account, gint64 user_id, gint size, GAsyncReadyCallback _callback_, gpointer _user_data_);
cairo_surface_t* twitter_load_avatar_for_user_id_finish (Twitter* self, GAsyncResult* _res_);
static void __lambda94_ (Block11Data* _data11_, GObject* obj, GAsyncResult* res);
void dm_list_entry_set_avatar (DMListEntry* self, cairo_surface_t* value);
static void ___lambda94__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean ___lambda92__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
static void dm_page_real_on_join (IPage* base, gint page_id, Bundle* args);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
gint64 bundle_get_int64 (Bundle* self, const gchar* key);
gchar* bundle_get_string (Bundle* self, const gchar* key);
void dm_placeholder_box_set_screen_name (DMPlaceholderBox* self, const gchar* value);
void dm_placeholder_box_set_name (DMPlaceholderBox* self, const gchar* value);
void dm_placeholder_box_load_avatar (DMPlaceholderBox* self);
void completion_text_view_set_account (CompletionTextView* self, Account* account);
static void __lambda99_ (DMPage* self, GtkWidget* w);
static void ___lambda99__gtk_callback (GtkWidget* widget, gpointer self);
GType dm_threads_page_get_type (void) G_GNUC_CONST;
IPage* main_window_get_page (MainWindow* self, gint page_id);
GType page_get_type (void) G_GNUC_CONST;
void dm_threads_page_adjust_unread_count_for_user_id (DMThreadsPage* self, gint64 user_id);
static gboolean __lambda100_ (Block12Data* _data12_, gchar** vals, int vals_length1);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void __lambda101_ (Block13Data* _data13_, GObject* obj, GAsyncResult* res);
static void ___lambda101__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean ___lambda100__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
static void dm_page_real_on_leave (IPage* base);
static void dm_page_send_button_clicked_cb (DMPage* self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
gchar* dm_threads_page_get_notification_id_for_user_id (DMThreadsPage* self, gint64 user_id);
const gchar* account_get_screen_name (Account* self);
const gchar* account_get_name (Account* self);
cairo_surface_t* account_get_avatar (Account* self);
static void __lambda102_ (Block14Data* _data14_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda102__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _dm_page_send_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean dm_page_text_view_key_press_cb (DMPage* self, GdkEventKey* evt);
static gboolean _dm_page_text_view_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gchar* dm_page_real_get_title (IPage* base);
static void dm_page_real_create_radio_button (IPage* base, GtkRadioButton* group);
static GtkRadioButton* dm_page_real_get_radio_button (IPage* base);
gint dm_page_get_unread_count (DMPage* self);
static void dm_page_finalize (GObject* obj);
gint ipage_get_id (IPage* self);
static void _vala_dm_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_window (IPage* self, MainWindow* value);
static void _vala_dm_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _dm_page_recalc_length_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	dm_page_recalc_length ((DMPage*) self);
}


static gint _itwitter_item_sort_func_inv_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = itwitter_item_sort_func_inv (row1, row2);
	return result;
}


static void _dm_page_load_older_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self) {
	dm_page_load_older ((DMPage*) self);
}


static void __lambda95_ (DMPage* self) {
	gboolean _tmp0_ = FALSE;
	_tmp0_ = self->priv->was_scrolled_down;
	if (_tmp0_) {
		ScrollWidget* _tmp1_ = NULL;
		_tmp1_ = self->priv->scroll_widget;
		scroll_widget_scroll_down_next (_tmp1_, FALSE, FALSE);
	}
}


static void ___lambda95__gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	__lambda95_ ((DMPage*) self);
}


static void __lambda96_ (DMPage* self) {
	ScrollWidget* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->scroll_widget;
	_tmp1_ = scroll_widget_get_scrolled_down (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		self->priv->was_scrolled_down = TRUE;
	} else {
		self->priv->was_scrolled_down = FALSE;
	}
}


static void ___lambda96__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
	__lambda96_ ((DMPage*) self);
}


DMPage* dm_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater) {
	DMPage * self = NULL;
	gint _tmp0_ = 0;
	Account* _tmp1_ = NULL;
	DeltaUpdater* _tmp2_ = NULL;
	CompletionTextView* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkListBox* _tmp6_ = NULL;
	DMPlaceholderBox* _tmp7_ = NULL;
	GtkListBox* _tmp8_ = NULL;
	DMPlaceholderBox* _tmp9_ = NULL;
	ScrollWidget* _tmp10_ = NULL;
	CompletionTextView* _tmp11_ = NULL;
	ScrollWidget* _tmp12_ = NULL;
	GtkAdjustment* _tmp13_ = NULL;
	GtkAdjustment* _tmp14_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	g_return_val_if_fail (IS_DELTA_UPDATER (delta_updater), NULL);
	self = (DMPage*) g_object_new (object_type, NULL);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = account;
	self->account = _tmp1_;
	_tmp2_ = delta_updater;
	self->delta_updater = _tmp2_;
	_tmp3_ = self->priv->text_view;
	_tmp4_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_text_view_get_type (), GtkTextView));
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "changed", (GCallback) _dm_page_recalc_length_gtk_text_buffer_changed, self, 0);
	_tmp6_ = self->priv->messages_list;
	gtk_list_box_set_sort_func (_tmp6_, _itwitter_item_sort_func_inv_gtk_list_box_sort_func, NULL, NULL);
	_tmp7_ = self->priv->placeholder_box;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_tmp8_ = self->priv->messages_list;
	_tmp9_ = self->priv->placeholder_box;
	gtk_list_box_set_placeholder (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	_tmp10_ = self->priv->scroll_widget;
	g_signal_connect_object (_tmp10_, "scrolled-to-start", (GCallback) _dm_page_load_older_scroll_widget_scrolled_to_start, self, 0);
	_tmp11_ = self->priv->text_view;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget), "size-allocate", (GCallback) ___lambda95__gtk_widget_size_allocate, self, 0);
	_tmp12_ = self->priv->scroll_widget;
	_tmp13_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp14_ = _tmp13_;
	g_signal_connect_object (_tmp14_, "value-changed", (GCallback) ___lambda96__gtk_adjustment_value_changed, self, 0);
	return self;
}


DMPage* dm_page_new (gint id, Account* account, DeltaUpdater* delta_updater) {
	return dm_page_construct (TYPE_DM_PAGE, id, account, delta_updater);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void _vala_CbTextEntity_array_free (CbTextEntity* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			cb_text_entity_free (&array[i]);
		}
	}
	g_free (array);
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		DMPage* self;
		self = _data8_->self;
		_data8_->url_list = (_vala_CbTextEntity_array_free (_data8_->url_list, _data8_->url_list_length1), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch8_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally8;
	__catch8_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void _______lambda97_ (Block8Data* _data8_, JsonArray* arr, guint index, JsonNode* node) {
	DMPage* self;
	JsonObject* url = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	JsonArray* indices = NULL;
	JsonArray* _tmp5_ = NULL;
	JsonArray* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	CbTextEntity* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	guint _tmp10_ = 0U;
	gint64 _tmp11_ = 0LL;
	gint64 _tmp12_ = 0LL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	CbTextEntity _tmp17_ = {0};
	CbTextEntity _tmp18_ = {0};
	self = _data8_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = json_object_get_string_member (url, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = json_object_get_array_member (url, "indices");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	indices = _tmp6_;
	_tmp7_ = expanded_url;
	_tmp8_ = string_replace (_tmp7_, "&", "&amp;");
	_g_free0 (expanded_url);
	expanded_url = _tmp8_;
	_tmp9_ = _data8_->url_list;
	_tmp9__length1 = _data8_->url_list_length1;
	_tmp10_ = index;
	_tmp11_ = json_array_get_int_element (indices, (guint) 0);
	_tmp12_ = json_array_get_int_element (indices, (guint) 1);
	_tmp13_ = expanded_url;
	_tmp14_ = g_strdup (_tmp13_);
	_tmp15_ = json_object_get_string_member (url, "display_url");
	_tmp16_ = g_strdup (_tmp15_);
	memset (&_tmp17_, 0, sizeof (CbTextEntity));
	_tmp17_.from = (guint) ((gint) _tmp11_);
	_tmp17_.to = (guint) ((gint) _tmp12_);
	_g_free0 (_tmp17_.target);
	_tmp17_.target = _tmp14_;
	_g_free0 (_tmp17_.display_text);
	_tmp17_.display_text = _tmp16_;
	cb_text_entity_free (&_tmp9_[_tmp10_]);
	_tmp9_[_tmp10_] = _tmp17_;
	_tmp18_ = _tmp9_[_tmp10_];
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void ________lambda97__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	_______lambda97_ (self, array, index_, element_node);
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		DMPage* self;
		self = _data9_->self;
		_data9_->url_list = (_vala_CbTextEntity_array_free (_data9_->url_list, _data9_->url_list_length1), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}


static void ____lambda98_ (Block9Data* _data9_, JsonArray* arr, guint index, JsonNode* node) {
	DMPage* self;
	JsonObject* url = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	gchar* expanded_url = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	JsonArray* indices = NULL;
	JsonArray* _tmp5_ = NULL;
	JsonArray* _tmp6_ = NULL;
	CbTextEntity* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	guint _tmp8_ = 0U;
	gint64 _tmp9_ = 0LL;
	gint64 _tmp10_ = 0LL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	CbTextEntity _tmp15_ = {0};
	CbTextEntity _tmp16_ = {0};
	self = _data9_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	url = _tmp2_;
	_tmp3_ = json_object_get_string_member (url, "expanded_url");
	_tmp4_ = g_strdup (_tmp3_);
	expanded_url = _tmp4_;
	_tmp5_ = json_object_get_array_member (url, "indices");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	indices = _tmp6_;
	_tmp7_ = _data9_->url_list;
	_tmp7__length1 = _data9_->url_list_length1;
	_tmp8_ = index;
	_tmp9_ = json_array_get_int_element (indices, (guint) 0);
	_tmp10_ = json_array_get_int_element (indices, (guint) 1);
	_tmp11_ = string_replace (expanded_url, "&", "&amp;");
	_tmp12_ = g_strdup (expanded_url);
	_tmp13_ = json_object_get_string_member (url, "display_url");
	_tmp14_ = g_strdup (_tmp13_);
	memset (&_tmp15_, 0, sizeof (CbTextEntity));
	_tmp15_.from = (guint) _tmp9_;
	_tmp15_.to = (guint) _tmp10_;
	_g_free0 (_tmp15_.target);
	_tmp15_.target = _tmp11_;
	_g_free0 (_tmp15_.tooltip_text);
	_tmp15_.tooltip_text = _tmp12_;
	_g_free0 (_tmp15_.display_text);
	_tmp15_.display_text = _tmp14_;
	cb_text_entity_free (&_tmp7_[_tmp8_]);
	_tmp7_[_tmp8_] = _tmp15_;
	_tmp16_ = _tmp7_[_tmp8_];
	_json_array_unref0 (indices);
	_g_free0 (expanded_url);
	_json_object_unref0 (url);
}


static void _____lambda98__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	____lambda98_ (self, array, index_, element_node);
}


static void dm_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root) {
	DMPage * self;
	StreamMessageType _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == STREAM_MESSAGE_TYPE_DIRECT_MESSAGE) {
		JsonObject* obj = NULL;
		JsonNode* _tmp1_ = NULL;
		JsonObject* _tmp2_ = NULL;
		JsonObject* _tmp3_ = NULL;
		JsonObject* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		JsonObject* _tmp6_ = NULL;
		gint64 _tmp7_ = 0LL;
		Account* _tmp8_ = NULL;
		gint64 _tmp9_ = 0LL;
		JsonObject* _tmp44_ = NULL;
		gint64 _tmp45_ = 0LL;
		gint64 _tmp46_ = 0LL;
		gchar* text = NULL;
		JsonObject* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		JsonObject* _tmp50_ = NULL;
		gboolean _tmp51_ = FALSE;
		JsonObject* sender = NULL;
		JsonObject* _tmp63_ = NULL;
		JsonObject* _tmp64_ = NULL;
		JsonObject* _tmp65_ = NULL;
		DMListEntry* new_msg = NULL;
		DMListEntry* _tmp66_ = NULL;
		DMListEntry* _tmp67_ = NULL;
		const gchar* _tmp68_ = NULL;
		DMListEntry* _tmp69_ = NULL;
		JsonObject* _tmp70_ = NULL;
		const gchar* _tmp71_ = NULL;
		DMListEntry* _tmp72_ = NULL;
		JsonObject* _tmp73_ = NULL;
		const gchar* _tmp74_ = NULL;
		DMListEntry* _tmp75_ = NULL;
		JsonObject* _tmp76_ = NULL;
		const gchar* _tmp77_ = NULL;
		GDateTime* _tmp78_ = NULL;
		GDateTime* _tmp79_ = NULL;
		gint64 _tmp80_ = 0LL;
		DMListEntry* _tmp81_ = NULL;
		MainWindow* _tmp82_ = NULL;
		DMListEntry* _tmp83_ = NULL;
		JsonObject* _tmp84_ = NULL;
		gint64 _tmp85_ = 0LL;
		DMListEntry* _tmp86_ = NULL;
		DMListEntry* _tmp87_ = NULL;
		JsonObject* _tmp88_ = NULL;
		const gchar* _tmp89_ = NULL;
		DeltaUpdater* _tmp90_ = NULL;
		DMListEntry* _tmp91_ = NULL;
		GtkListBox* _tmp92_ = NULL;
		DMListEntry* _tmp93_ = NULL;
		ScrollWidget* _tmp94_ = NULL;
		gboolean _tmp95_ = FALSE;
		gboolean _tmp96_ = FALSE;
		_tmp1_ = root;
		_tmp2_ = json_node_get_object (_tmp1_);
		_tmp3_ = json_object_get_object_member (_tmp2_, "direct_message");
		_tmp4_ = _json_object_ref0 (_tmp3_);
		obj = _tmp4_;
		_tmp6_ = obj;
		_tmp7_ = json_object_get_int_member (_tmp6_, "sender_id");
		_tmp8_ = self->account;
		_tmp9_ = _tmp8_->id;
		if (_tmp7_ == _tmp9_) {
			JsonObject* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			_tmp10_ = obj;
			_tmp11_ = json_object_has_member (_tmp10_, "entities");
			_tmp5_ = _tmp11_;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GList* entries = NULL;
			GtkListBox* _tmp12_ = NULL;
			GList* _tmp13_ = NULL;
			gint64 dm_id = 0LL;
			JsonObject* _tmp14_ = NULL;
			gint64 _tmp15_ = 0LL;
			GList* _tmp16_ = NULL;
			_tmp12_ = self->priv->messages_list;
			_tmp13_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_container_get_type (), GtkContainer));
			entries = _tmp13_;
			_tmp14_ = obj;
			_tmp15_ = json_object_get_int_member (_tmp14_, "id");
			dm_id = _tmp15_;
			_tmp16_ = entries;
			{
				GList* entry_collection = NULL;
				GList* entry_it = NULL;
				entry_collection = _tmp16_;
				for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
					GtkWidget* entry = NULL;
					entry = (GtkWidget*) entry_it->data;
					{
						DMListEntry* e = NULL;
						GtkWidget* _tmp17_ = NULL;
						DMListEntry* _tmp18_ = NULL;
						gboolean _tmp19_ = FALSE;
						DMListEntry* _tmp20_ = NULL;
						gint64 _tmp21_ = 0LL;
						Account* _tmp22_ = NULL;
						gint64 _tmp23_ = 0LL;
						_tmp17_ = entry;
						_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_DM_LIST_ENTRY, DMListEntry));
						e = _tmp18_;
						_tmp20_ = e;
						_tmp21_ = _tmp20_->user_id;
						_tmp22_ = self->account;
						_tmp23_ = _tmp22_->id;
						if (_tmp21_ == _tmp23_) {
							DMListEntry* _tmp24_ = NULL;
							gint64 _tmp25_ = 0LL;
							_tmp24_ = e;
							_tmp25_ = _tmp24_->id;
							_tmp19_ = _tmp25_ == ((gint64) -1);
						} else {
							_tmp19_ = FALSE;
						}
						if (_tmp19_) {
							Block8Data* _data8_;
							gchar* text = NULL;
							JsonObject* _tmp26_ = NULL;
							const gchar* _tmp27_ = NULL;
							gchar* _tmp28_ = NULL;
							JsonArray* urls = NULL;
							JsonObject* _tmp29_ = NULL;
							JsonObject* _tmp30_ = NULL;
							JsonArray* _tmp31_ = NULL;
							JsonArray* _tmp32_ = NULL;
							JsonArray* _tmp33_ = NULL;
							guint _tmp34_ = 0U;
							CbTextEntity* _tmp35_ = NULL;
							JsonArray* _tmp36_ = NULL;
							DMListEntry* _tmp37_ = NULL;
							const gchar* _tmp38_ = NULL;
							CbTextEntity* _tmp39_ = NULL;
							gint _tmp39__length1 = 0;
							gchar* _tmp40_ = NULL;
							gchar* _tmp41_ = NULL;
							DMListEntry* _tmp42_ = NULL;
							gint64 _tmp43_ = 0LL;
							_data8_ = g_slice_new0 (Block8Data);
							_data8_->_ref_count_ = 1;
							_data8_->self = g_object_ref (self);
							_tmp26_ = obj;
							_tmp27_ = json_object_get_string_member (_tmp26_, "text");
							_tmp28_ = g_strdup (_tmp27_);
							text = _tmp28_;
							_tmp29_ = obj;
							_tmp30_ = json_object_get_object_member (_tmp29_, "entities");
							_tmp31_ = json_object_get_array_member (_tmp30_, "urls");
							_tmp32_ = _json_array_ref0 (_tmp31_);
							urls = _tmp32_;
							_tmp33_ = urls;
							_tmp34_ = json_array_get_length (_tmp33_);
							_tmp35_ = g_new0 (CbTextEntity, _tmp34_);
							_data8_->url_list = _tmp35_;
							_data8_->url_list_length1 = _tmp34_;
							_data8_->_url_list_size_ = _data8_->url_list_length1;
							_tmp36_ = urls;
							json_array_foreach_element (_tmp36_, ________lambda97__json_array_foreach, _data8_);
							_tmp37_ = e;
							_tmp38_ = text;
							_tmp39_ = _data8_->url_list;
							_tmp39__length1 = _data8_->url_list_length1;
							_tmp40_ = cb_text_transform_text (_tmp38_, _tmp39_, _tmp39__length1, (guint) 0, (gsize) 0, (gint64) 0);
							_tmp41_ = _tmp40_;
							dm_list_entry_set_text (_tmp37_, _tmp41_);
							_g_free0 (_tmp41_);
							_tmp42_ = e;
							_tmp43_ = dm_id;
							_tmp42_->id = _tmp43_;
							_json_array_unref0 (urls);
							_g_free0 (text);
							block8_data_unref (_data8_);
							_data8_ = NULL;
							_g_object_unref0 (e);
							break;
						}
						_g_object_unref0 (e);
					}
				}
			}
			_g_list_free0 (entries);
		}
		_tmp44_ = obj;
		_tmp45_ = json_object_get_int_member (_tmp44_, "sender_id");
		_tmp46_ = self->user_id;
		if (_tmp45_ != _tmp46_) {
			_json_object_unref0 (obj);
			return;
		}
		_tmp47_ = obj;
		_tmp48_ = json_object_get_string_member (_tmp47_, "text");
		_tmp49_ = g_strdup (_tmp48_);
		text = _tmp49_;
		_tmp50_ = obj;
		_tmp51_ = json_object_has_member (_tmp50_, "entities");
		if (_tmp51_) {
			Block9Data* _data9_;
			JsonArray* urls = NULL;
			JsonObject* _tmp52_ = NULL;
			JsonObject* _tmp53_ = NULL;
			JsonArray* _tmp54_ = NULL;
			JsonArray* _tmp55_ = NULL;
			JsonArray* _tmp56_ = NULL;
			guint _tmp57_ = 0U;
			CbTextEntity* _tmp58_ = NULL;
			JsonArray* _tmp59_ = NULL;
			const gchar* _tmp60_ = NULL;
			CbTextEntity* _tmp61_ = NULL;
			gint _tmp61__length1 = 0;
			gchar* _tmp62_ = NULL;
			_data9_ = g_slice_new0 (Block9Data);
			_data9_->_ref_count_ = 1;
			_data9_->self = g_object_ref (self);
			_tmp52_ = obj;
			_tmp53_ = json_object_get_object_member (_tmp52_, "entities");
			_tmp54_ = json_object_get_array_member (_tmp53_, "urls");
			_tmp55_ = _json_array_ref0 (_tmp54_);
			urls = _tmp55_;
			_tmp56_ = urls;
			_tmp57_ = json_array_get_length (_tmp56_);
			_tmp58_ = g_new0 (CbTextEntity, _tmp57_);
			_data9_->url_list = _tmp58_;
			_data9_->url_list_length1 = _tmp57_;
			_data9_->_url_list_size_ = _data9_->url_list_length1;
			_tmp59_ = urls;
			json_array_foreach_element (_tmp59_, _____lambda98__json_array_foreach, _data9_);
			_tmp60_ = text;
			_tmp61_ = _data9_->url_list;
			_tmp61__length1 = _data9_->url_list_length1;
			_tmp62_ = cb_text_transform_text (_tmp60_, _tmp61_, _tmp61__length1, (guint) 0, (gsize) 0, (gint64) 0);
			_g_free0 (text);
			text = _tmp62_;
			_json_array_unref0 (urls);
			block9_data_unref (_data9_);
			_data9_ = NULL;
		}
		_tmp63_ = obj;
		_tmp64_ = json_object_get_object_member (_tmp63_, "sender");
		_tmp65_ = _json_object_ref0 (_tmp64_);
		sender = _tmp65_;
		_tmp66_ = dm_list_entry_new ();
		g_object_ref_sink (_tmp66_);
		new_msg = _tmp66_;
		_tmp67_ = new_msg;
		_tmp68_ = text;
		dm_list_entry_set_text (_tmp67_, _tmp68_);
		_tmp69_ = new_msg;
		_tmp70_ = sender;
		_tmp71_ = json_object_get_string_member (_tmp70_, "name");
		dm_list_entry_set_name (_tmp69_, _tmp71_);
		_tmp72_ = new_msg;
		_tmp73_ = sender;
		_tmp74_ = json_object_get_string_member (_tmp73_, "screen_name");
		dm_list_entry_set_screen_name (_tmp72_, _tmp74_);
		_tmp75_ = new_msg;
		_tmp76_ = obj;
		_tmp77_ = json_object_get_string_member (_tmp76_, "created_at");
		_tmp78_ = utils_parse_date (_tmp77_);
		_tmp79_ = _tmp78_;
		_tmp80_ = g_date_time_to_unix (_tmp79_);
		_tmp75_->timestamp = _tmp80_;
		_g_date_time_unref0 (_tmp79_);
		_tmp81_ = new_msg;
		_tmp82_ = self->priv->main_window;
		_tmp81_->main_window = _tmp82_;
		_tmp83_ = new_msg;
		_tmp84_ = sender;
		_tmp85_ = json_object_get_int_member (_tmp84_, "id");
		_tmp83_->user_id = _tmp85_;
		_tmp86_ = new_msg;
		itwitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, TYPE_ITWITTER_ITEM, ITwitterItem), NULL);
		_tmp87_ = new_msg;
		_tmp88_ = sender;
		_tmp89_ = json_object_get_string_member (_tmp88_, "profile_image_url");
		dm_list_entry_load_avatar (_tmp87_, _tmp89_);
		_tmp90_ = self->delta_updater;
		_tmp91_ = new_msg;
		delta_updater_add (_tmp90_, G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, TYPE_ITWITTER_ITEM, ITwitterItem));
		_tmp92_ = self->priv->messages_list;
		_tmp93_ = new_msg;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, gtk_widget_get_type (), GtkWidget));
		_tmp94_ = self->priv->scroll_widget;
		_tmp95_ = scroll_widget_get_scrolled_down (_tmp94_);
		_tmp96_ = _tmp95_;
		if (_tmp96_) {
			ScrollWidget* _tmp97_ = NULL;
			_tmp97_ = self->priv->scroll_widget;
			scroll_widget_scroll_down_next (_tmp97_, TRUE, FALSE);
		}
		_g_object_unref0 (new_msg);
		_json_object_unref0 (sender);
		_g_free0 (text);
		_json_object_unref0 (obj);
	}
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		DMPage* self;
		self = _data10_->self;
		_g_date_time_unref0 (_data10_->now);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (void * _userdata_) {
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		DMPage* self;
		self = _data11_->_data10_->self;
		_g_object_unref0 (_data11_->entry);
		block10_data_unref (_data11_->_data10_);
		_data11_->_data10_ = NULL;
		g_slice_free (Block11Data, _data11_);
	}
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static void __lambda94_ (Block11Data* _data11_, GObject* obj, GAsyncResult* res) {
	Block10Data* _data10_;
	DMPage* self;
	cairo_surface_t* s = NULL;
	Twitter* _tmp0_ = NULL;
	Twitter* _tmp1_ = NULL;
	GAsyncResult* _tmp2_ = NULL;
	cairo_surface_t* _tmp3_ = NULL;
	cairo_surface_t* _tmp4_ = NULL;
	_data10_ = _data11_->_data10_;
	self = _data10_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = twitter_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = res;
	_tmp3_ = twitter_load_avatar_for_user_id_finish (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	s = _tmp4_;
	dm_list_entry_set_avatar (_data11_->entry, s);
	_cairo_surface_destroy0 (s);
}


static void ___lambda94__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda94_ (self, source_object, res);
	block11_data_unref (self);
}


static gboolean __lambda92_ (Block10Data* _data10_, gchar** vals, int vals_length1) {
	DMPage* self;
	gboolean result = FALSE;
	Block11Data* _data11_;
	gint64 id = 0LL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	DMListEntry* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	const gchar* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	const gchar* _tmp12_ = NULL;
	gint64 _tmp13_ = 0LL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	const gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	const gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	const gchar* _tmp19_ = NULL;
	MainWindow* _tmp20_ = NULL;
	Twitter* _tmp21_ = NULL;
	Twitter* _tmp22_ = NULL;
	Account* _tmp23_ = NULL;
	gint64 _tmp24_ = 0LL;
	gint _tmp25_ = 0;
	DeltaUpdater* _tmp26_ = NULL;
	GtkListBox* _tmp27_ = NULL;
	self = _data10_->self;
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->_data10_ = block10_data_ref (_data10_);
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[6];
	_tmp2_ = int64_parse (_tmp1_);
	id = _tmp2_;
	_tmp3_ = id;
	_tmp4_ = self->priv->lowest_id;
	if (_tmp3_ < _tmp4_) {
		gint64 _tmp5_ = 0LL;
		_tmp5_ = id;
		self->priv->lowest_id = _tmp5_;
	}
	_tmp6_ = dm_list_entry_new ();
	g_object_ref_sink (_tmp6_);
	_data11_->entry = _tmp6_;
	_tmp7_ = id;
	_data11_->entry->id = _tmp7_;
	_tmp8_ = vals;
	_tmp8__length1 = vals_length1;
	_tmp9_ = _tmp8_[0];
	_tmp10_ = int64_parse (_tmp9_);
	_data11_->entry->user_id = _tmp10_;
	_tmp11_ = vals;
	_tmp11__length1 = vals_length1;
	_tmp12_ = _tmp11_[5];
	_tmp13_ = int64_parse (_tmp12_);
	_data11_->entry->timestamp = _tmp13_;
	_tmp14_ = vals;
	_tmp14__length1 = vals_length1;
	_tmp15_ = _tmp14_[2];
	dm_list_entry_set_text (_data11_->entry, _tmp15_);
	_tmp16_ = vals;
	_tmp16__length1 = vals_length1;
	_tmp17_ = _tmp16_[3];
	dm_list_entry_set_name (_data11_->entry, _tmp17_);
	_tmp18_ = vals;
	_tmp18__length1 = vals_length1;
	_tmp19_ = _tmp18_[4];
	dm_list_entry_set_screen_name (_data11_->entry, _tmp19_);
	_tmp20_ = self->priv->main_window;
	_data11_->entry->main_window = _tmp20_;
	itwitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (_data11_->entry, TYPE_ITWITTER_ITEM, ITwitterItem), _data10_->now);
	_tmp21_ = twitter_get ();
	_tmp22_ = _tmp21_;
	_tmp23_ = self->account;
	_tmp24_ = _data11_->entry->user_id;
	_tmp25_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	twitter_load_avatar_for_user_id (_tmp22_, _tmp23_, _tmp24_, 48 * _tmp25_, ___lambda94__gasync_ready_callback, block11_data_ref (_data11_));
	_g_object_unref0 (_tmp22_);
	_tmp26_ = self->delta_updater;
	delta_updater_add (_tmp26_, G_TYPE_CHECK_INSTANCE_CAST (_data11_->entry, TYPE_ITWITTER_ITEM, ITwitterItem));
	_tmp27_ = self->priv->messages_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_data11_->entry, gtk_widget_get_type (), GtkWidget));
	result = TRUE;
	block11_data_unref (_data11_);
	_data11_ = NULL;
	return result;
}


static gboolean ___lambda92__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda92_ (self, vals, vals_length1);
	return result;
}


static void dm_page_load_older (DMPage* self) {
	Block10Data* _data10_;
	GDateTime* _tmp0_ = NULL;
	ScrollWidget* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	SqlDatabase* _tmp3_ = NULL;
	SqlSelectStatement* _tmp4_ = NULL;
	SqlSelectStatement* _tmp5_ = NULL;
	SqlSelectStatement* _tmp6_ = NULL;
	SqlSelectStatement* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gint64 _tmp11_ = 0LL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gint64 _tmp14_ = 0LL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	SqlSelectStatement* _tmp19_ = NULL;
	SqlSelectStatement* _tmp20_ = NULL;
	SqlSelectStatement* _tmp21_ = NULL;
	SqlSelectStatement* _tmp22_ = NULL;
	SqlSelectStatement* _tmp23_ = NULL;
	SqlSelectStatement* _tmp24_ = NULL;
	g_return_if_fail (IS_DM_PAGE (self));
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = g_date_time_new_now_local ();
	_data10_->now = _tmp0_;
	_tmp1_ = self->priv->scroll_widget;
	scroll_widget_balance_next_upper_change (_tmp1_, TOP);
	_tmp2_ = self->account;
	_tmp3_ = _tmp2_->db;
	_tmp4_ = sql_database_select (_tmp3_, "dms");
	_tmp5_ = _tmp4_;
	_tmp6_ = sql_select_statement_cols (_tmp5_, "from_id", "to_id", "text", "from_name", "from_screen_name", "timestamp", "id", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->user_id;
	_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->user_id;
	_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->lowest_id;
	_tmp15_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat ("(`from_id`='", _tmp10_, "' OR `to_id`='", _tmp13_, "') AND `id` < '", _tmp16_, "'", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = sql_select_statement_where (_tmp7_, _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = sql_select_statement_order (_tmp20_, "timestamp DESC");
	_tmp22_ = _tmp21_;
	_tmp23_ = sql_select_statement_limit (_tmp22_, 35);
	_tmp24_ = _tmp23_;
	sql_select_statement_run (_tmp24_, ___lambda92__sql_select_callback, _data10_);
	_g_object_unref0 (_tmp24_);
	_g_object_unref0 (_tmp22_);
	_g_object_unref0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp10_);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}


static void block12_data_unref (void * _userdata_) {
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		DMPage* self;
		self = _data12_->self;
		_g_date_time_unref0 (_data12_->now);
		_g_free0 (_data12_->name);
		_g_free0 (_data12_->screen_name);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}


static void __lambda99_ (DMPage* self, GtkWidget* w) {
	GtkListBox* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = self->priv->messages_list;
	_tmp1_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), _tmp1_);
}


static void ___lambda99__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda99_ ((DMPage*) self, widget);
}


static Block13Data* block13_data_ref (Block13Data* _data13_) {
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}


static void block13_data_unref (void * _userdata_) {
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		DMPage* self;
		self = _data13_->_data12_->self;
		_g_object_unref0 (_data13_->entry);
		block12_data_unref (_data13_->_data12_);
		_data13_->_data12_ = NULL;
		g_slice_free (Block13Data, _data13_);
	}
}


static void __lambda101_ (Block13Data* _data13_, GObject* obj, GAsyncResult* res) {
	Block12Data* _data12_;
	DMPage* self;
	cairo_surface_t* s = NULL;
	Twitter* _tmp0_ = NULL;
	Twitter* _tmp1_ = NULL;
	GAsyncResult* _tmp2_ = NULL;
	cairo_surface_t* _tmp3_ = NULL;
	cairo_surface_t* _tmp4_ = NULL;
	_data12_ = _data13_->_data12_;
	self = _data12_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = twitter_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = res;
	_tmp3_ = twitter_load_avatar_for_user_id_finish (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	s = _tmp4_;
	dm_list_entry_set_avatar (_data13_->entry, s);
	_cairo_surface_destroy0 (s);
}


static void ___lambda101__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda101_ (self, source_object, res);
	block13_data_unref (self);
}


static gboolean __lambda100_ (Block12Data* _data12_, gchar** vals, int vals_length1) {
	DMPage* self;
	gboolean result = FALSE;
	Block13Data* _data13_;
	gint64 id = 0LL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	const gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gint64 _tmp4_ = 0LL;
	DMListEntry* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	const gchar* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	const gchar* _tmp12_ = NULL;
	gint64 _tmp13_ = 0LL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	const gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	const gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	const gchar* _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	const gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	MainWindow* _tmp26_ = NULL;
	GDateTime* _tmp27_ = NULL;
	Twitter* _tmp28_ = NULL;
	Twitter* _tmp29_ = NULL;
	Account* _tmp30_ = NULL;
	gint64 _tmp31_ = 0LL;
	gint _tmp32_ = 0;
	DeltaUpdater* _tmp33_ = NULL;
	GtkListBox* _tmp34_ = NULL;
	self = _data12_->self;
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->_data12_ = block12_data_ref (_data12_);
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[6];
	_tmp2_ = int64_parse (_tmp1_);
	id = _tmp2_;
	_tmp3_ = id;
	_tmp4_ = self->priv->lowest_id;
	if (_tmp3_ < _tmp4_) {
		gint64 _tmp5_ = 0LL;
		_tmp5_ = id;
		self->priv->lowest_id = _tmp5_;
	}
	_tmp6_ = dm_list_entry_new ();
	g_object_ref_sink (_tmp6_);
	_data13_->entry = _tmp6_;
	_tmp7_ = id;
	_data13_->entry->id = _tmp7_;
	_tmp8_ = vals;
	_tmp8__length1 = vals_length1;
	_tmp9_ = _tmp8_[0];
	_tmp10_ = int64_parse (_tmp9_);
	_data13_->entry->user_id = _tmp10_;
	_tmp11_ = vals;
	_tmp11__length1 = vals_length1;
	_tmp12_ = _tmp11_[5];
	_tmp13_ = int64_parse (_tmp12_);
	_data13_->entry->timestamp = _tmp13_;
	_tmp14_ = vals;
	_tmp14__length1 = vals_length1;
	_tmp15_ = _tmp14_[2];
	dm_list_entry_set_text (_data13_->entry, _tmp15_);
	_tmp16_ = vals;
	_tmp16__length1 = vals_length1;
	_tmp17_ = _tmp16_[3];
	dm_list_entry_set_name (_data13_->entry, _tmp17_);
	_tmp18_ = vals;
	_tmp18__length1 = vals_length1;
	_tmp19_ = _tmp18_[3];
	_tmp20_ = g_strdup (_tmp19_);
	_g_free0 (_data12_->name);
	_data12_->name = _tmp20_;
	_tmp21_ = vals;
	_tmp21__length1 = vals_length1;
	_tmp22_ = _tmp21_[4];
	dm_list_entry_set_screen_name (_data13_->entry, _tmp22_);
	_tmp23_ = vals;
	_tmp23__length1 = vals_length1;
	_tmp24_ = _tmp23_[4];
	_tmp25_ = g_strdup (_tmp24_);
	_g_free0 (_data12_->screen_name);
	_data12_->screen_name = _tmp25_;
	_tmp26_ = self->priv->main_window;
	_data13_->entry->main_window = _tmp26_;
	_tmp27_ = _data12_->now;
	itwitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (_data13_->entry, TYPE_ITWITTER_ITEM, ITwitterItem), _tmp27_);
	_tmp28_ = twitter_get ();
	_tmp29_ = _tmp28_;
	_tmp30_ = self->account;
	_tmp31_ = _data13_->entry->user_id;
	_tmp32_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	twitter_load_avatar_for_user_id (_tmp29_, _tmp30_, _tmp31_, 48 * _tmp32_, ___lambda101__gasync_ready_callback, block13_data_ref (_data13_));
	_g_object_unref0 (_tmp29_);
	_tmp33_ = self->delta_updater;
	delta_updater_add (_tmp33_, G_TYPE_CHECK_INSTANCE_CAST (_data13_->entry, TYPE_ITWITTER_ITEM, ITwitterItem));
	_tmp34_ = self->priv->messages_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_data13_->entry, gtk_widget_get_type (), GtkWidget));
	result = TRUE;
	block13_data_unref (_data13_);
	_data13_ = NULL;
	return result;
}


static gboolean ___lambda100__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda100_ (self, vals, vals_length1);
	return result;
}


static void dm_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	DMPage * self;
	Block12Data* _data12_;
	gint64 user_id = 0LL;
	Bundle* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	Bundle* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	CompletionTextView* _tmp19_ = NULL;
	Account* _tmp20_ = NULL;
	GtkListBox* _tmp21_ = NULL;
	DMThreadsPage* threads_page = NULL;
	MainWindow* _tmp22_ = NULL;
	IPage* _tmp23_ = NULL;
	DMThreadsPage* _tmp24_ = NULL;
	gint64 _tmp25_ = 0LL;
	GDateTime* _tmp26_ = NULL;
	Account* _tmp27_ = NULL;
	SqlDatabase* _tmp28_ = NULL;
	SqlSelectStatement* _tmp29_ = NULL;
	SqlSelectStatement* _tmp30_ = NULL;
	SqlSelectStatement* _tmp31_ = NULL;
	SqlSelectStatement* _tmp32_ = NULL;
	gint64 _tmp33_ = 0LL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gint64 _tmp36_ = 0LL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	SqlSelectStatement* _tmp41_ = NULL;
	SqlSelectStatement* _tmp42_ = NULL;
	SqlSelectStatement* _tmp43_ = NULL;
	SqlSelectStatement* _tmp44_ = NULL;
	SqlSelectStatement* _tmp45_ = NULL;
	SqlSelectStatement* _tmp46_ = NULL;
	Account* _tmp47_ = NULL;
	CbUserCounter* _tmp48_ = NULL;
	gint64 _tmp49_ = 0LL;
	const gchar* _tmp50_ = NULL;
	const gchar* _tmp51_ = NULL;
	ScrollWidget* _tmp52_ = NULL;
	CompletionTextView* _tmp53_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = args;
	_tmp1_ = bundle_get_int64 (_tmp0_, "sender_id");
	user_id = _tmp1_;
	_tmp2_ = user_id;
	if (_tmp2_ == ((gint64) 0)) {
		block12_data_unref (_data12_);
		_data12_ = NULL;
		return;
	}
	self->priv->lowest_id = G_MAXINT64;
	_tmp3_ = user_id;
	self->user_id = _tmp3_;
	_data12_->name = NULL;
	_tmp4_ = args;
	_tmp5_ = bundle_get_string (_tmp4_, "screen_name");
	_g_free0 (_data12_->screen_name);
	_data12_->screen_name = _tmp5_;
	_tmp6_ = _data12_->screen_name;
	if (_tmp6_ != NULL) {
		Bundle* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		DMPlaceholderBox* _tmp9_ = NULL;
		gint64 _tmp10_ = 0LL;
		DMPlaceholderBox* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		DMPlaceholderBox* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		DMPlaceholderBox* _tmp15_ = NULL;
		Bundle* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		DMPlaceholderBox* _tmp18_ = NULL;
		_tmp7_ = args;
		_tmp8_ = bundle_get_string (_tmp7_, "name");
		_g_free0 (_data12_->name);
		_data12_->name = _tmp8_;
		_tmp9_ = self->priv->placeholder_box;
		_tmp10_ = user_id;
		_tmp9_->user_id = _tmp10_;
		_tmp11_ = self->priv->placeholder_box;
		_tmp12_ = _data12_->screen_name;
		dm_placeholder_box_set_screen_name (_tmp11_, _tmp12_);
		_tmp13_ = self->priv->placeholder_box;
		_tmp14_ = _data12_->name;
		dm_placeholder_box_set_name (_tmp13_, _tmp14_);
		_tmp15_ = self->priv->placeholder_box;
		_tmp16_ = args;
		_tmp17_ = bundle_get_string (_tmp16_, "avatar_url");
		_g_free0 (_tmp15_->avatar_url);
		_tmp15_->avatar_url = _tmp17_;
		_tmp18_ = self->priv->placeholder_box;
		dm_placeholder_box_load_avatar (_tmp18_);
	}
	_tmp19_ = self->priv->text_view;
	_tmp20_ = self->account;
	completion_text_view_set_account (_tmp19_, _tmp20_);
	_tmp21_ = self->priv->messages_list;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_container_get_type (), GtkContainer), ___lambda99__gtk_callback, self);
	_tmp22_ = self->priv->main_window;
	_tmp23_ = main_window_get_page (_tmp22_, (gint) PAGE_DM_THREADS);
	threads_page = G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp24_ = threads_page;
	_tmp25_ = user_id;
	dm_threads_page_adjust_unread_count_for_user_id (_tmp24_, _tmp25_);
	_tmp26_ = g_date_time_new_now_local ();
	_data12_->now = _tmp26_;
	_tmp27_ = self->account;
	_tmp28_ = _tmp27_->db;
	_tmp29_ = sql_database_select (_tmp28_, "dms");
	_tmp30_ = _tmp29_;
	_tmp31_ = sql_select_statement_cols (_tmp30_, "from_id", "to_id", "text", "from_name", "from_screen_name", "timestamp", "id", NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = user_id;
	_tmp34_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = user_id;
	_tmp37_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_strconcat ("`from_id`='", _tmp35_, "' OR `to_id`='", _tmp38_, "'", NULL);
	_tmp40_ = _tmp39_;
	_tmp41_ = sql_select_statement_where (_tmp32_, _tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = sql_select_statement_order (_tmp42_, "timestamp DESC");
	_tmp44_ = _tmp43_;
	_tmp45_ = sql_select_statement_limit (_tmp44_, 35);
	_tmp46_ = _tmp45_;
	sql_select_statement_run (_tmp46_, ___lambda100__sql_select_callback, _data12_);
	_g_object_unref0 (_tmp46_);
	_g_object_unref0 (_tmp44_);
	_g_object_unref0 (_tmp42_);
	_g_free0 (_tmp40_);
	_g_free0 (_tmp38_);
	_g_free0 (_tmp35_);
	_g_object_unref0 (_tmp32_);
	_g_object_unref0 (_tmp30_);
	_tmp47_ = self->account;
	_tmp48_ = _tmp47_->user_counter;
	_tmp49_ = user_id;
	_tmp50_ = _data12_->screen_name;
	_tmp51_ = _data12_->name;
	cb_user_counter_user_seen (_tmp48_, _tmp49_, _tmp50_, _tmp51_);
	_tmp52_ = self->priv->scroll_widget;
	scroll_widget_scroll_down_next (_tmp52_, FALSE, TRUE);
	_tmp53_ = self->priv->text_view;
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (threads_page);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}


static void dm_page_real_on_leave (IPage* base) {
	DMPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}


static void block14_data_unref (void * _userdata_) {
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		DMPage* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->call);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}


static void __lambda102_ (Block14Data* _data14_, GObject* obj, GAsyncResult* res) {
	DMPage* self;
	GError * _inner_error_ = NULL;
	self = _data14_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data14_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		MainWindow* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data14_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = self->priv->main_window;
		utils_show_error_object (_tmp3_, _tmp5_, 299, "DMPage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_window_get_type (), GtkWindow));
		_g_error_free0 (e);
		return;
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda102__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda102_ (self, source_object, res);
	block14_data_unref (self);
}


static void dm_page_send_button_clicked_cb (DMPage* self) {
	Block14Data* _data14_;
	CompletionTextView* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	DMThreadsPage* threads_page = NULL;
	MainWindow* _tmp9_ = NULL;
	IPage* _tmp10_ = NULL;
	gchar* notification_id = NULL;
	DMThreadsPage* _tmp11_ = NULL;
	gint64 _tmp12_ = 0LL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	DMListEntry* entry = NULL;
	DMListEntry* _tmp17_ = NULL;
	DMListEntry* _tmp18_ = NULL;
	DMListEntry* _tmp19_ = NULL;
	Account* _tmp20_ = NULL;
	gint64 _tmp21_ = 0LL;
	DMListEntry* _tmp22_ = NULL;
	Account* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	DMListEntry* _tmp26_ = NULL;
	GDateTime* _tmp27_ = NULL;
	GDateTime* _tmp28_ = NULL;
	gint64 _tmp29_ = 0LL;
	DMListEntry* _tmp30_ = NULL;
	CompletionTextView* _tmp31_ = NULL;
	GtkTextBuffer* _tmp32_ = NULL;
	GtkTextBuffer* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	DMListEntry* _tmp39_ = NULL;
	MainWindow* _tmp40_ = NULL;
	DMListEntry* _tmp41_ = NULL;
	Account* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	DMListEntry* _tmp45_ = NULL;
	Account* _tmp46_ = NULL;
	cairo_surface_t* _tmp47_ = NULL;
	cairo_surface_t* _tmp48_ = NULL;
	DMListEntry* _tmp49_ = NULL;
	DeltaUpdater* _tmp50_ = NULL;
	DMListEntry* _tmp51_ = NULL;
	GtkListBox* _tmp52_ = NULL;
	DMListEntry* _tmp53_ = NULL;
	Account* _tmp54_ = NULL;
	OAuthProxy* _tmp55_ = NULL;
	RestProxyCall* _tmp56_ = NULL;
	RestProxyCall* _tmp57_ = NULL;
	RestProxyCall* _tmp58_ = NULL;
	RestProxyCall* _tmp59_ = NULL;
	gint64 _tmp60_ = 0LL;
	gchar* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	RestProxyCall* _tmp63_ = NULL;
	CompletionTextView* _tmp64_ = NULL;
	GtkTextBuffer* _tmp65_ = NULL;
	GtkTextBuffer* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
	gchar* _tmp68_ = NULL;
	gchar* _tmp69_ = NULL;
	RestProxyCall* _tmp70_ = NULL;
	CompletionTextView* _tmp71_ = NULL;
	GtkTextBuffer* _tmp72_ = NULL;
	GtkTextBuffer* _tmp73_ = NULL;
	ScrollWidget* _tmp74_ = NULL;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp76_ = FALSE;
	g_return_if_fail (IS_DM_PAGE (self));
	_data14_ = g_slice_new0 (Block14Data);
	_data14_->_ref_count_ = 1;
	_data14_->self = g_object_ref (self);
	_tmp0_ = self->priv->text_view;
	_tmp1_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_text_view_get_type (), GtkTextView));
	_tmp2_ = _tmp1_;
	g_object_get (_tmp2_, "text", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_ == 0;
	_g_free0 (_tmp5_);
	if (_tmp8_) {
		block14_data_unref (_data14_);
		_data14_ = NULL;
		return;
	}
	_tmp9_ = self->priv->main_window;
	_tmp10_ = main_window_get_page (_tmp9_, (gint) PAGE_DM_THREADS);
	threads_page = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DM_THREADS_PAGE, DMThreadsPage);
	_tmp11_ = threads_page;
	_tmp12_ = self->user_id;
	_tmp13_ = dm_threads_page_get_notification_id_for_user_id (_tmp11_, _tmp12_);
	notification_id = _tmp13_;
	_tmp14_ = notification_id;
	if (_tmp14_ != NULL) {
		GApplication* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp15_ = g_application_get_default ();
		_tmp16_ = notification_id;
		g_application_withdraw_notification (_tmp15_, _tmp16_);
	}
	_tmp17_ = dm_list_entry_new ();
	g_object_ref_sink (_tmp17_);
	entry = _tmp17_;
	_tmp18_ = entry;
	_tmp18_->id = (gint64) -1;
	_tmp19_ = entry;
	_tmp20_ = self->account;
	_tmp21_ = _tmp20_->id;
	_tmp19_->user_id = _tmp21_;
	_tmp22_ = entry;
	_tmp23_ = self->account;
	_tmp24_ = account_get_screen_name (_tmp23_);
	_tmp25_ = _tmp24_;
	dm_list_entry_set_screen_name (_tmp22_, _tmp25_);
	_tmp26_ = entry;
	_tmp27_ = g_date_time_new_now_local ();
	_tmp28_ = _tmp27_;
	_tmp29_ = g_date_time_to_unix (_tmp28_);
	_tmp26_->timestamp = _tmp29_;
	_g_date_time_unref0 (_tmp28_);
	_tmp30_ = entry;
	_tmp31_ = self->priv->text_view;
	_tmp32_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_text_view_get_type (), GtkTextView));
	_tmp33_ = _tmp32_;
	g_object_get (_tmp33_, "text", &_tmp34_, NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_;
	_tmp37_ = g_markup_escape_text (_tmp36_, (gssize) -1);
	_tmp38_ = _tmp37_;
	dm_list_entry_set_text (_tmp30_, _tmp38_);
	_g_free0 (_tmp38_);
	_g_free0 (_tmp36_);
	_tmp39_ = entry;
	_tmp40_ = self->priv->main_window;
	_tmp39_->main_window = _tmp40_;
	_tmp41_ = entry;
	_tmp42_ = self->account;
	_tmp43_ = account_get_name (_tmp42_);
	_tmp44_ = _tmp43_;
	dm_list_entry_set_name (_tmp41_, _tmp44_);
	_tmp45_ = entry;
	_tmp46_ = self->account;
	_tmp47_ = account_get_avatar (_tmp46_);
	_tmp48_ = _tmp47_;
	dm_list_entry_set_avatar (_tmp45_, _tmp48_);
	_tmp49_ = entry;
	itwitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, TYPE_ITWITTER_ITEM, ITwitterItem), NULL);
	_tmp50_ = self->delta_updater;
	_tmp51_ = entry;
	delta_updater_add (_tmp50_, G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, TYPE_ITWITTER_ITEM, ITwitterItem));
	_tmp52_ = self->priv->messages_list;
	_tmp53_ = entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_widget_get_type (), GtkWidget));
	_tmp54_ = self->account;
	_tmp55_ = _tmp54_->proxy;
	_tmp56_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, rest_proxy_get_type (), RestProxy));
	_data14_->call = _tmp56_;
	_tmp57_ = _data14_->call;
	rest_proxy_call_set_function (_tmp57_, "1.1/direct_messages/new.json");
	_tmp58_ = _data14_->call;
	rest_proxy_call_set_method (_tmp58_, "POST");
	_tmp59_ = _data14_->call;
	_tmp60_ = self->user_id;
	_tmp61_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp60_);
	_tmp62_ = _tmp61_;
	rest_proxy_call_add_param (_tmp59_, "user_id", _tmp62_);
	_g_free0 (_tmp62_);
	_tmp63_ = _data14_->call;
	_tmp64_ = self->priv->text_view;
	_tmp65_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, gtk_text_view_get_type (), GtkTextView));
	_tmp66_ = _tmp65_;
	g_object_get (_tmp66_, "text", &_tmp67_, NULL);
	_tmp68_ = _tmp67_;
	_tmp69_ = _tmp68_;
	rest_proxy_call_add_param (_tmp63_, "text", _tmp69_);
	_g_free0 (_tmp69_);
	_tmp70_ = _data14_->call;
	rest_proxy_call_invoke_async (_tmp70_, NULL, ___lambda102__gasync_ready_callback, block14_data_ref (_data14_));
	_tmp71_ = self->priv->text_view;
	_tmp72_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, gtk_text_view_get_type (), GtkTextView));
	_tmp73_ = _tmp72_;
	g_object_set (_tmp73_, "text", "", NULL);
	_tmp74_ = self->priv->scroll_widget;
	_tmp75_ = scroll_widget_get_scrolled_down (_tmp74_);
	_tmp76_ = _tmp75_;
	if (_tmp76_) {
		ScrollWidget* _tmp77_ = NULL;
		_tmp77_ = self->priv->scroll_widget;
		scroll_widget_scroll_down_next (_tmp77_, TRUE, FALSE);
	}
	_g_object_unref0 (entry);
	_g_free0 (notification_id);
	_g_object_unref0 (threads_page);
	block14_data_unref (_data14_);
	_data14_ = NULL;
}


static void _dm_page_send_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	dm_page_send_button_clicked_cb ((DMPage*) self);
}


static gboolean dm_page_text_view_key_press_cb (DMPage* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (IS_DM_PAGE (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->keyval;
	if (_tmp2_ == ((guint) GDK_KEY_Return)) {
		GdkEventKey* _tmp3_ = NULL;
		GdkModifierType _tmp4_ = 0;
		_tmp3_ = evt;
		_tmp4_ = _tmp3_->state;
		_tmp0_ = (_tmp4_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		dm_page_send_button_clicked_cb (self);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean _dm_page_text_view_key_press_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = dm_page_text_view_key_press_cb ((DMPage*) self, event);
	return result;
}


static void dm_page_recalc_length (DMPage* self) {
	guint text_length = 0U;
	CompletionTextView* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	guint _tmp8_ = 0U;
	GtkButton* _tmp9_ = NULL;
	g_return_if_fail (IS_DM_PAGE (self));
	_tmp0_ = self->priv->text_view;
	_tmp1_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_text_view_get_type (), GtkTextView));
	_tmp2_ = _tmp1_;
	g_object_get (_tmp2_, "text", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = (guint) _tmp7_;
	_g_free0 (_tmp5_);
	text_length = _tmp8_;
	_tmp9_ = self->priv->send_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), text_length > ((guint) 0));
}


static gchar* dm_page_real_get_title (IPage* base) {
	DMPage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	_tmp0_ = _ ("Direct Conversation");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void dm_page_real_create_radio_button (IPage* base, GtkRadioButton* group) {
	DMPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
}


static GtkRadioButton* dm_page_real_get_radio_button (IPage* base) {
	DMPage * self;
	GtkRadioButton* result = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	result = NULL;
	return result;
}


gint dm_page_get_unread_count (DMPage* self) {
	gint result;
	g_return_val_if_fail (IS_DM_PAGE (self), 0);
	result = 0;
	return result;
}


static void dm_page_real_set_window (IPage* base, MainWindow* value) {
	DMPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	_tmp0_ = value;
	self->priv->main_window = _tmp0_;
	g_object_notify ((GObject *) self, "window");
}


static gint dm_page_real_get_id (IPage* base) {
	gint result;
	DMPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void dm_page_real_set_id (IPage* base, gint value) {
	DMPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_DM_PAGE, DMPage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static void dm_page_class_init (DMPageClass * klass) {
	gint DMPage_private_offset;
	dm_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DMPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dm_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dm_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = dm_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_PAGE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_PAGE_WINDOW, g_param_spec_object ("window", "window", "window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DM_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	DMPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/dm-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "send_button", FALSE, DMPage_private_offset + G_STRUCT_OFFSET (DMPagePrivate, send_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_view", FALSE, DMPage_private_offset + G_STRUCT_OFFSET (DMPagePrivate, text_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "messages_list", FALSE, DMPage_private_offset + G_STRUCT_OFFSET (DMPagePrivate, messages_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scroll_widget", FALSE, DMPage_private_offset + G_STRUCT_OFFSET (DMPagePrivate, scroll_widget));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "send_button_clicked_cb", G_CALLBACK(_dm_page_send_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "text_view_key_press_cb", G_CALLBACK(_dm_page_text_view_key_press_cb_gtk_widget_key_press_event));
}


static void dm_page_ipage_interface_init (IPageIface * iface) {
	dm_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) dm_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) dm_page_real_on_leave;
	iface->get_title = (gchar* (*)(IPage*)) dm_page_real_get_title;
	iface->create_radio_button = (void (*)(IPage*, GtkRadioButton*)) dm_page_real_create_radio_button;
	iface->get_radio_button = (GtkRadioButton* (*)(IPage*)) dm_page_real_get_radio_button;
	iface->set_window = dm_page_real_set_window;
	iface->get_id = dm_page_real_get_id;
	iface->set_id = dm_page_real_set_id;
}


static void dm_page_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	dm_page_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) dm_page_real_stream_message_received;
}


static void dm_page_instance_init (DMPage * self) {
	DMPlaceholderBox* _tmp0_ = NULL;
	self->priv = DM_PAGE_GET_PRIVATE (self);
	_tmp0_ = dm_placeholder_box_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->placeholder_box = _tmp0_;
	self->priv->lowest_id = G_MAXINT64;
	self->priv->was_scrolled_down = FALSE;
	g_type_ensure (TYPE_COMPLETION_TEXT_VIEW);
	g_type_ensure (TYPE_SCROLL_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void dm_page_finalize (GObject* obj) {
	DMPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DM_PAGE, DMPage);
	_g_object_unref0 (self->priv->send_button);
	_g_object_unref0 (self->priv->text_view);
	_g_object_unref0 (self->priv->messages_list);
	_g_object_unref0 (self->priv->scroll_widget);
	_g_object_unref0 (self->priv->placeholder_box);
	G_OBJECT_CLASS (dm_page_parent_class)->finalize (obj);
}


GType dm_page_get_type (void) {
	static volatile gsize dm_page_type_id__volatile = 0;
	if (g_once_init_enter (&dm_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DMPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dm_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DMPage), 0, (GInstanceInitFunc) dm_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) dm_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) dm_page_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dm_page_type_id;
		dm_page_type_id = g_type_register_static (gtk_box_get_type (), "DMPage", &g_define_type_info, 0);
		g_type_add_interface_static (dm_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (dm_page_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&dm_page_type_id__volatile, dm_page_type_id);
	}
	return dm_page_type_id__volatile;
}


static void _vala_dm_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DMPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_PAGE, DMPage);
	switch (property_id) {
		case DM_PAGE_UNREAD_COUNT:
		g_value_set_int (value, dm_page_get_unread_count (self));
		break;
		case DM_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dm_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DMPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DM_PAGE, DMPage);
	switch (property_id) {
		case DM_PAGE_WINDOW:
		ipage_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		case DM_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



