/* MainWindow.c generated by valac 0.34.6, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <cairo.h>
#include "CbTweet.h"


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_ADD_LIST_ENTRY (add_list_entry_get_type ())
#define ADD_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_LIST_ENTRY, AddListEntry))
#define ADD_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_LIST_ENTRY, AddListEntryClass))
#define IS_ADD_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_LIST_ENTRY))
#define IS_ADD_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_LIST_ENTRY))
#define ADD_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_LIST_ENTRY, AddListEntryClass))

typedef struct _AddListEntry AddListEntry;
typedef struct _AddListEntryClass AddListEntryClass;

#define TYPE_USER_LIST_ENTRY (user_list_entry_get_type ())
#define USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LIST_ENTRY, UserListEntry))
#define USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LIST_ENTRY, UserListEntryClass))
#define IS_USER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LIST_ENTRY))
#define IS_USER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LIST_ENTRY))
#define USER_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LIST_ENTRY, UserListEntryClass))

typedef struct _UserListEntry UserListEntry;
typedef struct _UserListEntryClass UserListEntryClass;

#define TYPE_COREBIRD (corebird_get_type ())
#define COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COREBIRD, Corebird))
#define COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COREBIRD, CorebirdClass))
#define IS_COREBIRD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COREBIRD))
#define IS_COREBIRD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COREBIRD))
#define COREBIRD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COREBIRD, CorebirdClass))

typedef struct _Corebird Corebird;
typedef struct _CorebirdClass CorebirdClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_PAGE (page_get_type ())
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;

#define TYPE_ACCOUNT_CREATE_WIDGET (account_create_widget_get_type ())
#define ACCOUNT_CREATE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidget))
#define ACCOUNT_CREATE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidgetClass))
#define IS_ACCOUNT_CREATE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_CREATE_WIDGET))
#define IS_ACCOUNT_CREATE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_CREATE_WIDGET))
#define ACCOUNT_CREATE_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_CREATE_WIDGET, AccountCreateWidgetClass))

typedef struct _AccountCreateWidget AccountCreateWidget;
typedef struct _AccountCreateWidgetClass AccountCreateWidgetClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())

#define TYPE_ACCOUNT_DIALOG (account_dialog_get_type ())
#define ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_DIALOG, AccountDialog))
#define ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_DIALOG, AccountDialogClass))
#define IS_ACCOUNT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_DIALOG))
#define IS_ACCOUNT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_DIALOG))
#define ACCOUNT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_DIALOG, AccountDialogClass))

typedef struct _AccountDialog AccountDialog;
typedef struct _AccountDialogClass AccountDialogClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;
typedef struct _DefaultTimelinePrivate DefaultTimelinePrivate;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_BADGE_RADIO_BUTTON (badge_radio_button_get_type ())
#define BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButton))
#define BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))
#define IS_BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_BUTTON))
#define IS_BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_BUTTON))
#define BADGE_RADIO_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))

typedef struct _BadgeRadioButton BadgeRadioButton;
typedef struct _BadgeRadioButtonClass BadgeRadioButtonClass;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _MainWindowPrivate {
	GtkHeaderBar* headerbar;
	AvatarWidget* avatar_image;
	GtkListBox* account_list;
	GtkPopover* account_popover;
	GtkBox* header_box;
	GtkToggleButton* account_button;
	GtkLabel* title_label;
	GtkLabel* last_page_label;
	GtkStack* title_stack;
	GtkMenuButton* app_menu_button;
	ComposeTweetWindow* compose_tweet_window;
	GtkGestureMultiPress* thumb_button_gesture;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _DefaultTimeline {
	ScrollWidget parent_instance;
	DefaultTimelinePrivate * priv;
	gboolean initialized;
	MainWindow* main_window;
	TweetListBox* tweet_list;
	Account* account;
	BadgeRadioButton* radio_button;
	guint tweet_remove_timeout;
	gboolean loading;
	GtkWidget* last_focus_widget;
};

struct _DefaultTimelineClass {
	ScrollWidgetClass parent_class;
	void (*on_join) (DefaultTimeline* self, gint page_id, Bundle* args);
	void (*on_leave) (DefaultTimeline* self);
	gchar* (*get_title) (DefaultTimeline* self);
	void (*create_radio_button) (DefaultTimeline* self, GtkRadioButton* group);
	const gchar* (*get_function) (DefaultTimeline* self);
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	DeltaUpdater* delta_updater;
	Account* account;
	TweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};


static gpointer main_window_parent_class = NULL;

GType main_window_get_type (void) G_GNUC_CONST;
GType main_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
#define MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW, MainWindowPrivate))
enum  {
	MAIN_WINDOW_DUMMY_PROPERTY,
	MAIN_WINDOW_CUR_PAGE_ID
};
static void main_window_show_hide_compose_window (MainWindow* self);
static void _main_window_show_hide_compose_window_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void settings_toggle_sidebar_visible (void);
static void _settings_toggle_sidebar_visible_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void main_window_simple_switch_page (MainWindow* self, GSimpleAction* a, GVariant* param);
static void _main_window_simple_switch_page_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void main_window_show_account_dialog (MainWindow* self);
static void _main_window_show_account_dialog_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void main_window_show_account_list (MainWindow* self);
static void _main_window_show_account_list_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void main_window_previous (MainWindow* self, GSimpleAction* a, GVariant* param);
static void _main_window_previous_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void main_window_next (MainWindow* self, GSimpleAction* a, GVariant* param);
static void _main_window_next_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
MainWindow* main_window_new (GtkApplication* app, Account* account);
MainWindow* main_window_construct (GType object_type, GtkApplication* app, Account* account);
void main_window_change_account (MainWindow* self, Account* account);
static gint main_window_account_sort_func (MainWindow* self, GtkListBoxRow* a, GtkListBoxRow* b);
static gint _main_window_account_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before);
static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
GType add_list_entry_get_type (void) G_GNUC_CONST;
AddListEntry* add_list_entry_new (const gchar* label);
AddListEntry* add_list_entry_construct (GType object_type, const gchar* label);
guint account_get_n (void);
Account* account_get_nth (guint index);
const gchar* account_get_screen_name (Account* self);
#define ACCOUNT_DUMMY "screen_name"
GType user_list_entry_get_type (void) G_GNUC_CONST;
UserListEntry* user_list_entry_new_from_account (Account* acc);
UserListEntry* user_list_entry_construct_from_account (GType object_type, Account* acc);
void user_list_entry_set_show_settings (UserListEntry* self, gboolean value);
static void _____lambda186_ (MainWindow* self);
static void ______lambda186__user_list_entry_action_clicked (UserListEntry* _sender, gpointer self);
GType corebird_get_type (void) G_GNUC_CONST;
static void __lambda187_ (MainWindow* self, Account* new_acc);
gchar* user_list_entry_get_screen_name (UserListEntry* self);
static void __lambda188_ (MainWindow* self);
static void ___lambda188__user_list_entry_action_clicked (UserListEntry* _sender, gpointer self);
static void ___lambda187__corebird_account_added (Corebird* _sender, Account* acc, gpointer self);
static void __lambda189_ (MainWindow* self, Account* acc);
static void ___lambda189__corebird_account_removed (Corebird* _sender, Account* acc, gpointer self);
static gboolean __lambda190_ (MainWindow* self, GdkEventKey* evt);
GType bundle_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
IPage* main_widget_get_page (MainWidget* self, gint page_id);
gint main_widget_get_cur_page_id (MainWidget* self);
static gboolean ___lambda190__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void main_window_thumb_button_pressed_cb (MainWindow* self, GtkGestureMultiPress* gesture, gint n_press, gdouble x, gdouble y);
static void _main_window_thumb_button_pressed_cb_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender, gint p0, gdouble p1, gdouble p2, gpointer self);
static void main_window_load_geometry (MainWindow* self);
static void main_window_back_button_clicked_cb (MainWindow* self);
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void _main_window_back_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static gint64* _int64_dup (gint64* self);
static void main_window_account_info_changed (MainWindow* self, const gchar* screen_name, const gchar* name, cairo_surface_t* small_avatar, cairo_surface_t* avatar);
static void _main_window_account_info_changed_account_info_changed (Account* _sender, const gchar* screen_name, const gchar* name, cairo_surface_t* avatar_small, cairo_surface_t* avatar, gpointer self);
void main_widget_stop (MainWidget* self);
MainWidget* main_widget_new (Account* account, MainWindow* parent, Corebird* app);
MainWidget* main_widget_construct (GType object_type, Account* account, MainWindow* parent, Corebird* app);
void main_window_set_window_title (MainWindow* self, const gchar* title, GtkStackTransitionType transition_type);
gchar* ipage_get_title (IPage* self);
cairo_surface_t* account_get_avatar_small (Account* self);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
static void ___lambda144_ (MainWindow* self);
static void ____lambda144__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
Account* account_new (gint64 id, const gchar* screen_name, const gchar* name);
Account* account_construct (GType object_type, gint64 id, const gchar* screen_name, const gchar* name);
void account_add_account (Account* acc);
GType account_create_widget_get_type (void) G_GNUC_CONST;
AccountCreateWidget* account_create_widget_new (Account* acc, Corebird* corebird, MainWindow* main_window);
AccountCreateWidget* account_create_widget_construct (GType object_type, Account* acc, Corebird* corebird, MainWindow* main_window);
static void ___lambda148_ (MainWindow* self, gboolean _result_, Account* acc);
static void ____lambda148__account_create_widget_result_received (AccountCreateWidget* _sender, gboolean _result_, Account* acc, gpointer self);
static void main_window_account_row_activated_cb (MainWindow* self, GtkListBoxRow* row);
gint64 user_list_entry_get_user_id (UserListEntry* self);
gboolean corebird_is_window_open_for_user_id (Corebird* self, gint64 user_id, MainWindow** window);
Account* account_query_account_by_id (gint64 id);
static void _main_window_account_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
static void ___lambda184_ (MainWindow* self);
static void ____lambda184__gtk_widget_hide (GtkWidget* _sender, gpointer self);
static void ___lambda185_ (MainWindow* self);
static void ____lambda185__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
GType account_dialog_get_type (void) G_GNUC_CONST;
AccountDialog* account_dialog_new (Account* account);
AccountDialog* account_dialog_construct (GType object_type, Account* account);
IPage* main_window_get_page (MainWindow* self, gint page_id);
static void main_window_account_button_clicked_cb (MainWindow* self);
static void _main_window_account_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void main_window_account_popover_closed_cb (MainWindow* self);
static void _main_window_account_popover_closed_cb_gtk_popover_closed (GtkPopover* _sender, gpointer self);
static gboolean main_window_window_delete_cb (MainWindow* self, GdkEventAny* evt);
GSettings* settings_get (void);
void main_window_save_geometry (MainWindow* self);
static gboolean _main_window_window_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
void main_window_rerun_filters (MainWindow* self);
GType scroll_widget_get_type (void) G_GNUC_CONST;
GType default_timeline_get_type (void) G_GNUC_CONST;
void default_timeline_rerun_filters (DefaultTimeline* self);
void main_window_reply_to_tweet (MainWindow* self, gint64 tweet_id);
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType badge_radio_button_get_type (void) G_GNUC_CONST;
GType delta_updater_get_type (void) G_GNUC_CONST;
GType tweet_model_get_type (void) G_GNUC_CONST;
CbTweet* tweet_model_get_from_id (TweetModel* self, gint64 id, gint diff);
void main_window_mark_tweet_as_read (MainWindow* self, gint64 tweet_id);
gint default_timeline_get_unread_count (DefaultTimeline* self);
void default_timeline_set_unread_count (DefaultTimeline* self, gint value);
gint main_window_get_cur_page_id (MainWindow* self);
static void main_window_finalize (GObject* obj);
static void _vala_main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry MAIN_WINDOW_win_entries[7] = {{"compose-tweet", _main_window_show_hide_compose_window_gsimple_action_activate_callback}, {"toggle-sidebar", _settings_toggle_sidebar_visible_gsimple_action_activate_callback}, {"switch-page", _main_window_simple_switch_page_gsimple_action_activate_callback, "i"}, {"show-account-dialog", _main_window_show_account_dialog_gsimple_action_activate_callback}, {"show-account-list", _main_window_show_account_list_gsimple_action_activate_callback}, {"previous", _main_window_previous_gsimple_action_activate_callback}, {"next", _main_window_next_gsimple_action_activate_callback}};

static void _main_window_show_hide_compose_window_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_show_hide_compose_window ((MainWindow*) self);
}


static void _settings_toggle_sidebar_visible_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	settings_toggle_sidebar_visible ();
}


static void _main_window_simple_switch_page_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_simple_switch_page ((MainWindow*) self, action, parameter);
}


static void _main_window_show_account_dialog_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_show_account_dialog ((MainWindow*) self);
}


static void _main_window_show_account_list_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_show_account_list ((MainWindow*) self);
}


static void _main_window_previous_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_previous ((MainWindow*) self, action, parameter);
}


static void _main_window_next_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	main_window_next ((MainWindow*) self, action, parameter);
}


static gint _main_window_account_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = main_window_account_sort_func ((MainWindow*) self, row1, row2);
	return result;
}


static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	default_header_func (row, before);
}


static void _____lambda186_ (MainWindow* self) {
	GtkPopover* _tmp0_ = NULL;
	_tmp0_ = self->priv->account_popover;
	gtk_popover_popdown (_tmp0_);
}


static void ______lambda186__user_list_entry_action_clicked (UserListEntry* _sender, gpointer self) {
	_____lambda186_ ((MainWindow*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda188_ (MainWindow* self) {
	GtkPopover* _tmp0_ = NULL;
	_tmp0_ = self->priv->account_popover;
	gtk_popover_popdown (_tmp0_);
}


static void ___lambda188__user_list_entry_action_clicked (UserListEntry* _sender, gpointer self) {
	__lambda188_ ((MainWindow*) self);
}


static void __lambda187_ (MainWindow* self, Account* new_acc) {
	GList* entries = NULL;
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	UserListEntry* ule = NULL;
	Account* _tmp13_ = NULL;
	UserListEntry* _tmp14_ = NULL;
	UserListEntry* _tmp15_ = NULL;
	UserListEntry* _tmp16_ = NULL;
	GtkListBox* _tmp17_ = NULL;
	UserListEntry* _tmp18_ = NULL;
	UserListEntry* _tmp19_ = NULL;
	g_return_if_fail (IS_ACCOUNT (new_acc));
	_tmp0_ = self->priv->account_list;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	entries = _tmp1_;
	_tmp2_ = entries;
	{
		GList* ule_collection = NULL;
		GList* ule_it = NULL;
		ule_collection = _tmp2_;
		for (ule_it = ule_collection; ule_it != NULL; ule_it = ule_it->next) {
			GtkWidget* _tmp3_ = NULL;
			GtkWidget* ule = NULL;
			_tmp3_ = _g_object_ref0 ((GtkWidget*) ule_it->data);
			ule = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				GtkWidget* _tmp5_ = NULL;
				_tmp5_ = ule;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_USER_LIST_ENTRY)) {
					Account* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					GtkWidget* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					_tmp6_ = new_acc;
					_tmp7_ = account_get_screen_name (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = ule;
					_tmp10_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_USER_LIST_ENTRY, UserListEntry));
					_tmp11_ = _tmp10_;
					_tmp12_ = _tmp11_;
					_tmp4_ = g_strcmp0 (_tmp8_, _tmp12_) == 0;
					_g_free0 (_tmp12_);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					_g_object_unref0 (ule);
					_g_list_free0 (entries);
					return;
				}
				_g_object_unref0 (ule);
			}
		}
	}
	_tmp13_ = new_acc;
	_tmp14_ = user_list_entry_new_from_account (_tmp13_);
	g_object_ref_sink (_tmp14_);
	ule = _tmp14_;
	_tmp15_ = ule;
	user_list_entry_set_show_settings (_tmp15_, TRUE);
	_tmp16_ = ule;
	g_signal_connect_object (_tmp16_, "action-clicked", (GCallback) ___lambda188__user_list_entry_action_clicked, self, 0);
	_tmp17_ = self->priv->account_list;
	_tmp18_ = ule;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
	_tmp19_ = ule;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ule);
	_g_list_free0 (entries);
}


static void ___lambda187__corebird_account_added (Corebird* _sender, Account* acc, gpointer self) {
	__lambda187_ ((MainWindow*) self, acc);
}


static void __lambda189_ (MainWindow* self, Account* acc) {
	GList* entries = NULL;
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	g_return_if_fail (IS_ACCOUNT (acc));
	_tmp0_ = self->priv->account_list;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	entries = _tmp1_;
	_tmp2_ = entries;
	{
		GList* ule_collection = NULL;
		GList* ule_it = NULL;
		ule_collection = _tmp2_;
		for (ule_it = ule_collection; ule_it != NULL; ule_it = ule_it->next) {
			GtkWidget* _tmp3_ = NULL;
			GtkWidget* ule = NULL;
			_tmp3_ = _g_object_ref0 ((GtkWidget*) ule_it->data);
			ule = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				GtkWidget* _tmp5_ = NULL;
				_tmp5_ = ule;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_USER_LIST_ENTRY)) {
					Account* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					GtkWidget* _tmp9_ = NULL;
					gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_ = NULL;
					_tmp6_ = acc;
					_tmp7_ = account_get_screen_name (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = ule;
					_tmp10_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_USER_LIST_ENTRY, UserListEntry));
					_tmp11_ = _tmp10_;
					_tmp12_ = _tmp11_;
					_tmp4_ = g_strcmp0 (_tmp8_, _tmp12_) == 0;
					_g_free0 (_tmp12_);
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					GtkListBox* _tmp13_ = NULL;
					GtkWidget* _tmp14_ = NULL;
					_tmp13_ = self->priv->account_list;
					_tmp14_ = ule;
					gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_container_get_type (), GtkContainer), _tmp14_);
					_g_object_unref0 (ule);
					break;
				}
				_g_object_unref0 (ule);
			}
		}
	}
	_g_list_free0 (entries);
}


static void ___lambda189__corebird_account_removed (Corebird* _sender, Account* acc, gpointer self) {
	__lambda189_ ((MainWindow*) self, acc);
}


static gboolean __lambda190_ (MainWindow* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->keyval;
	if (_tmp2_ == ((guint) GDK_KEY_Down)) {
		MainWidget* _tmp3_ = NULL;
		_tmp3_ = self->main_widget;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		MainWidget* _tmp4_ = NULL;
		MainWidget* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		IPage* _tmp8_ = NULL;
		IPage* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp4_ = self->main_widget;
		_tmp5_ = self->main_widget;
		_tmp6_ = main_widget_get_cur_page_id (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = main_widget_get_page (_tmp4_, _tmp7_);
		_tmp9_ = _tmp8_;
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), "focus", GTK_DIR_RIGHT, &_tmp10_);
		_g_object_unref0 (_tmp9_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda190__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = __lambda190_ ((MainWindow*) self, event);
	return result;
}


static void _main_window_thumb_button_pressed_cb_gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender, gint p0, gdouble p1, gdouble p2, gpointer self) {
	main_window_thumb_button_pressed_cb ((MainWindow*) self, _sender, p0, p1, p2);
}


MainWindow* main_window_construct (GType object_type, GtkApplication* app, Account* account) {
	MainWindow * self = NULL;
	GtkWindowGroup* group = NULL;
	GtkWindowGroup* _tmp0_ = NULL;
	GtkWindowGroup* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	GtkListBox* _tmp4_ = NULL;
	AddListEntry* add_entry = NULL;
	const gchar* _tmp5_ = NULL;
	AddListEntry* _tmp6_ = NULL;
	AddListEntry* _tmp7_ = NULL;
	GtkListBox* _tmp8_ = NULL;
	AddListEntry* _tmp9_ = NULL;
	GtkApplication* _tmp25_ = NULL;
	GtkApplication* _tmp26_ = NULL;
	GtkHeaderBar* _tmp27_ = NULL;
	GtkGestureMultiPress* _tmp28_ = NULL;
	GtkGestureMultiPress* _tmp29_ = NULL;
	GtkGestureMultiPress* _tmp30_ = NULL;
	GtkGestureMultiPress* _tmp31_ = NULL;
	g_return_val_if_fail (GTK_IS_APPLICATION (app), NULL);
	g_return_val_if_fail ((account == NULL) || IS_ACCOUNT (account), NULL);
	self = (MainWindow*) g_object_new (object_type, NULL);
	gtk_window_set_default_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), 480, 700);
	_tmp0_ = gtk_window_group_new ();
	group = _tmp0_;
	_tmp1_ = group;
	gtk_window_group_add_window (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp2_ = account;
	main_window_change_account (self, _tmp2_);
	_tmp3_ = self->priv->account_list;
	gtk_list_box_set_sort_func (_tmp3_, _main_window_account_sort_func_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp4_ = self->priv->account_list;
	gtk_list_box_set_header_func (_tmp4_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp5_ = _ ("Add new Account");
	_tmp6_ = add_list_entry_new (_tmp5_);
	g_object_ref_sink (_tmp6_);
	add_entry = _tmp6_;
	_tmp7_ = add_entry;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_tmp8_ = self->priv->account_list;
	_tmp9_ = add_entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				guint _tmp12_ = 0U;
				guint _tmp13_ = 0U;
				Account* acc = NULL;
				guint _tmp14_ = 0U;
				Account* _tmp15_ = NULL;
				Account* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				const gchar* _tmp18_ = NULL;
				UserListEntry* e = NULL;
				Account* _tmp19_ = NULL;
				UserListEntry* _tmp20_ = NULL;
				UserListEntry* _tmp21_ = NULL;
				UserListEntry* _tmp22_ = NULL;
				GtkListBox* _tmp23_ = NULL;
				UserListEntry* _tmp24_ = NULL;
				if (!_tmp10_) {
					guint _tmp11_ = 0U;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = account_get_n ();
				if (!(_tmp12_ < _tmp13_)) {
					break;
				}
				_tmp14_ = i;
				_tmp15_ = account_get_nth (_tmp14_);
				acc = _tmp15_;
				_tmp16_ = acc;
				_tmp17_ = account_get_screen_name (_tmp16_);
				_tmp18_ = _tmp17_;
				if (g_strcmp0 (_tmp18_, ACCOUNT_DUMMY) == 0) {
					_g_object_unref0 (acc);
					continue;
				}
				_tmp19_ = acc;
				_tmp20_ = user_list_entry_new_from_account (_tmp19_);
				g_object_ref_sink (_tmp20_);
				e = _tmp20_;
				_tmp21_ = e;
				user_list_entry_set_show_settings (_tmp21_, TRUE);
				_tmp22_ = e;
				g_signal_connect_object (_tmp22_, "action-clicked", (GCallback) ______lambda186__user_list_entry_action_clicked, self, 0);
				_tmp23_ = self->priv->account_list;
				_tmp24_ = e;
				gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (e);
				_g_object_unref0 (acc);
			}
		}
	}
	_tmp25_ = app;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_COREBIRD, Corebird), "account-added", (GCallback) ___lambda187__corebird_account_added, self, 0);
	_tmp26_ = app;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_COREBIRD, Corebird), "account-removed", (GCallback) ___lambda189__corebird_account_removed, self, 0);
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (self, g_action_map_get_type (), GActionMap), MAIN_WINDOW_win_entries, G_N_ELEMENTS (MAIN_WINDOW_win_entries), self);
	_tmp27_ = self->priv->headerbar;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget), "key-press-event", (GCallback) ___lambda190__gtk_widget_key_press_event, self, 0);
	_tmp28_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (self->priv->thumb_button_gesture);
	self->priv->thumb_button_gesture = _tmp28_;
	_tmp29_ = self->priv->thumb_button_gesture;
	gtk_gesture_single_set_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_gesture_single_get_type (), GtkGestureSingle), (guint) 0);
	_tmp30_ = self->priv->thumb_button_gesture;
	gtk_event_controller_set_propagation_phase (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_event_controller_get_type (), GtkEventController), GTK_PHASE_CAPTURE);
	_tmp31_ = self->priv->thumb_button_gesture;
	g_signal_connect_object (_tmp31_, "pressed", (GCallback) _main_window_thumb_button_pressed_cb_gtk_gesture_multi_press_pressed, self, 0);
	main_window_load_geometry (self);
	_g_object_unref0 (add_entry);
	_g_object_unref0 (group);
	return self;
}


MainWindow* main_window_new (GtkApplication* app, Account* account) {
	return main_window_construct (TYPE_MAIN_WINDOW, app, account);
}


static void main_window_back_button_clicked_cb (MainWindow* self) {
	MainWidget* _tmp0_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = self->main_widget;
	main_widget_switch_page (_tmp0_, (gint) PAGE_PREVIOUS, NULL);
}


static void _main_window_back_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	main_window_back_button_clicked_cb ((MainWindow*) self);
}


static gint64* _int64_dup (gint64* self) {
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}


static gpointer __int64_dup0 (gpointer self) {
	return self ? _int64_dup (self) : NULL;
}


static void _main_window_account_info_changed_account_info_changed (Account* _sender, const gchar* screen_name, const gchar* name, cairo_surface_t* avatar_small, cairo_surface_t* avatar, gpointer self) {
	main_window_account_info_changed ((MainWindow*) self, screen_name, name, avatar_small, avatar);
}


static void ___lambda144_ (MainWindow* self) {
	AvatarWidget* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
	cairo_surface_t* _tmp3_ = NULL;
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = self->account;
	_tmp2_ = account_get_avatar_small (_tmp1_);
	_tmp3_ = _tmp2_;
	avatar_widget_set_surface (_tmp0_, _tmp3_);
}


static void ____lambda144__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda144_ ((MainWindow*) self);
}


static void ___lambda148_ (MainWindow* self, gboolean _result_, Account* acc) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_ACCOUNT (acc));
	_tmp0_ = _result_;
	if (_tmp0_) {
		Account* _tmp1_ = NULL;
		_tmp1_ = acc;
		main_window_change_account (self, _tmp1_);
	} else {
	}
}


static void ____lambda148__account_create_widget_result_received (AccountCreateWidget* _sender, gboolean _result_, Account* acc, gpointer self) {
	___lambda148_ ((MainWindow*) self, _result_, acc);
}


void main_window_change_account (MainWindow* self, Account* account) {
	gint64* old_user_id = NULL;
	Account* _tmp0_ = NULL;
	Account* _tmp6_ = NULL;
	MainWidget* _tmp7_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkBox* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	Corebird* cb = NULL;
	GApplication* _tmp15_ = NULL;
	Corebird* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	Account* _tmp18_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail ((account == NULL) || IS_ACCOUNT (account));
	old_user_id = NULL;
	_tmp0_ = self->account;
	if (_tmp0_ != NULL) {
		Account* _tmp1_ = NULL;
		gint64 _tmp2_ = 0LL;
		gint64* _tmp3_ = NULL;
		Account* _tmp4_ = NULL;
		guint _tmp5_ = 0U;
		_tmp1_ = self->account;
		_tmp2_ = _tmp1_->id;
		_tmp3_ = __int64_dup0 (&_tmp2_);
		_g_free0 (old_user_id);
		old_user_id = _tmp3_;
		_tmp4_ = self->account;
		g_signal_parse_name ("info-changed", TYPE_ACCOUNT, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _main_window_account_info_changed_account_info_changed, self);
	}
	_tmp6_ = account;
	self->account = _tmp6_;
	_tmp7_ = self->main_widget;
	if (_tmp7_ != NULL) {
		MainWidget* _tmp8_ = NULL;
		_tmp8_ = self->main_widget;
		main_widget_stop (_tmp8_);
	}
	_tmp9_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_bin_get_type (), GtkBin));
	if (_tmp9_ != NULL) {
		GtkWidget* _tmp10_ = NULL;
		_tmp10_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_bin_get_type (), GtkBin));
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), _tmp10_);
	}
	_tmp11_ = self->priv->header_box;
	_tmp12_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	_tmp13_ = _tmp12_;
	if (!_tmp13_) {
		GtkBox* _tmp14_ = NULL;
		_tmp14_ = self->priv->header_box;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), TRUE);
	}
	_tmp15_ = g_application_get_default ();
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_COREBIRD, Corebird));
	cb = _tmp16_;
	_tmp18_ = account;
	if (_tmp18_ != NULL) {
		Account* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		_tmp19_ = account;
		_tmp20_ = account_get_screen_name (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp17_ = g_strcmp0 (_tmp21_, ACCOUNT_DUMMY) != 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		Account* _tmp22_ = NULL;
		Corebird* _tmp23_ = NULL;
		MainWidget* _tmp24_ = NULL;
		MainWidget* _tmp25_ = NULL;
		MainWidget* _tmp26_ = NULL;
		MainWidget* _tmp27_ = NULL;
		MainWidget* _tmp28_ = NULL;
		IPage* _tmp29_ = NULL;
		IPage* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		AvatarWidget* _tmp33_ = NULL;
		Account* _tmp34_ = NULL;
		cairo_surface_t* _tmp35_ = NULL;
		cairo_surface_t* _tmp36_ = NULL;
		Account* _tmp37_ = NULL;
		Account* _tmp38_ = NULL;
		Corebird* _tmp39_ = NULL;
		gint64* _tmp40_ = NULL;
		Account* _tmp41_ = NULL;
		gint64 _tmp42_ = 0LL;
		GtkSettings* _tmp43_ = NULL;
		gboolean _tmp44_ = FALSE;
		gboolean _tmp45_ = FALSE;
		_tmp22_ = account;
		_tmp23_ = cb;
		_tmp24_ = main_widget_new (_tmp22_, self, _tmp23_);
		g_object_ref_sink (_tmp24_);
		_g_object_unref0 (self->main_widget);
		self->main_widget = _tmp24_;
		_tmp25_ = self->main_widget;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
		_tmp26_ = self->main_widget;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget));
		_tmp27_ = self->main_widget;
		main_widget_switch_page (_tmp27_, 0, NULL);
		_tmp28_ = self->main_widget;
		_tmp29_ = main_widget_get_page (_tmp28_, 0);
		_tmp30_ = _tmp29_;
		_tmp31_ = ipage_get_title (_tmp30_);
		_tmp32_ = _tmp31_;
		main_window_set_window_title (self, _tmp32_, GTK_STACK_TRANSITION_TYPE_NONE);
		_g_free0 (_tmp32_);
		_g_object_unref0 (_tmp30_);
		_tmp33_ = self->priv->avatar_image;
		_tmp34_ = account;
		_tmp35_ = account_get_avatar_small (_tmp34_);
		_tmp36_ = _tmp35_;
		avatar_widget_set_surface (_tmp33_, _tmp36_);
		_tmp37_ = account;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, G_TYPE_OBJECT, GObject), "notify::avatar-small", (GCallback) ____lambda144__g_object_notify, self, 0);
		_tmp38_ = account;
		g_signal_connect_object (_tmp38_, "info-changed", (GCallback) _main_window_account_info_changed_account_info_changed, self, 0);
		_tmp39_ = cb;
		_tmp40_ = old_user_id;
		_tmp41_ = account;
		_tmp42_ = _tmp41_->id;
		g_signal_emit_by_name (_tmp39_, "account-window-changed", _tmp40_, _tmp42_);
		_tmp43_ = gtk_settings_get_default ();
		g_object_get (_tmp43_, "gtk-shell-shows-app-menu", &_tmp44_, NULL);
		_tmp45_ = _tmp44_;
		if (!_tmp45_) {
			GtkMenuButton* _tmp46_ = NULL;
			_tmp46_ = self->priv->app_menu_button;
			if (_tmp46_ == NULL) {
				GtkMenuButton* _tmp47_ = NULL;
				GtkMenuButton* _tmp48_ = NULL;
				GtkImage* _tmp49_ = NULL;
				GtkImage* _tmp50_ = NULL;
				GtkMenuButton* _tmp51_ = NULL;
				GtkStyleContext* _tmp52_ = NULL;
				GtkMenuButton* _tmp53_ = NULL;
				Corebird* _tmp54_ = NULL;
				GMenuModel* _tmp55_ = NULL;
				GMenuModel* _tmp56_ = NULL;
				GtkHeaderBar* _tmp57_ = NULL;
				GtkMenuButton* _tmp58_ = NULL;
				_tmp47_ = (GtkMenuButton*) gtk_menu_button_new ();
				g_object_ref_sink (_tmp47_);
				_g_object_unref0 (self->priv->app_menu_button);
				self->priv->app_menu_button = _tmp47_;
				_tmp48_ = self->priv->app_menu_button;
				_tmp49_ = (GtkImage*) gtk_image_new_from_icon_name ("emblem-system-symbolic", GTK_ICON_SIZE_MENU);
				g_object_ref_sink (_tmp49_);
				_tmp50_ = _tmp49_;
				gtk_button_set_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_button_get_type (), GtkButton), G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_widget_get_type (), GtkWidget));
				_g_object_unref0 (_tmp50_);
				_tmp51_ = self->priv->app_menu_button;
				_tmp52_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_widget_get_type (), GtkWidget));
				gtk_style_context_add_class (_tmp52_, "image-button");
				_tmp53_ = self->priv->app_menu_button;
				_tmp54_ = cb;
				_tmp55_ = gtk_application_get_app_menu (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_application_get_type (), GtkApplication));
				_tmp56_ = _tmp55_;
				gtk_menu_button_set_menu_model (_tmp53_, _tmp56_);
				_tmp57_ = self->priv->headerbar;
				_tmp58_ = self->priv->app_menu_button;
				gtk_header_bar_pack_end (_tmp57_, G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, gtk_widget_get_type (), GtkWidget));
			} else {
				GtkMenuButton* _tmp59_ = NULL;
				_tmp59_ = self->priv->app_menu_button;
				gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_widget_get_type (), GtkWidget));
			}
		}
	} else {
		GtkBox* _tmp60_ = NULL;
		GtkMenuButton* _tmp61_ = NULL;
		Account* acc_ = NULL;
		Account* _tmp63_ = NULL;
		Account* _tmp67_ = NULL;
		GtkLabel* _tmp68_ = NULL;
		Account* _tmp69_ = NULL;
		AccountCreateWidget* create_widget = NULL;
		Account* _tmp70_ = NULL;
		Corebird* _tmp71_ = NULL;
		AccountCreateWidget* _tmp72_ = NULL;
		AccountCreateWidget* _tmp73_ = NULL;
		AccountCreateWidget* _tmp74_ = NULL;
		_tmp60_ = self->priv->header_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, gtk_widget_get_type (), GtkWidget));
		_tmp61_ = self->priv->app_menu_button;
		if (_tmp61_ != NULL) {
			GtkMenuButton* _tmp62_ = NULL;
			_tmp62_ = self->priv->app_menu_button;
			gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_widget_get_type (), GtkWidget));
		}
		_tmp63_ = account;
		if (_tmp63_ == NULL) {
			Account* _tmp64_ = NULL;
			_tmp64_ = account_new ((gint64) 0, ACCOUNT_DUMMY, "name");
			_g_object_unref0 (acc_);
			acc_ = _tmp64_;
		} else {
			Account* _tmp65_ = NULL;
			Account* _tmp66_ = NULL;
			_tmp65_ = account;
			_tmp66_ = _g_object_ref0 (_tmp65_);
			_g_object_unref0 (acc_);
			acc_ = _tmp66_;
		}
		_tmp67_ = acc_;
		self->account = _tmp67_;
		_tmp68_ = self->priv->title_label;
		gtk_label_set_label (_tmp68_, "Corebird");
		_tmp69_ = acc_;
		account_add_account (_tmp69_);
		_tmp70_ = acc_;
		_tmp71_ = cb;
		_tmp72_ = account_create_widget_new (_tmp70_, _tmp71_, self);
		g_object_ref_sink (_tmp72_);
		create_widget = _tmp72_;
		_tmp73_ = create_widget;
		g_signal_connect_object (_tmp73_, "result-received", (GCallback) ____lambda148__account_create_widget_result_received, self, 0);
		_tmp74_ = create_widget;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (create_widget);
		_g_object_unref0 (acc_);
	}
	_g_object_unref0 (cb);
	_g_free0 (old_user_id);
}


static void main_window_account_row_activated_cb (MainWindow* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_ = NULL;
	UserListEntry* e = NULL;
	GtkListBoxRow* _tmp10_ = NULL;
	UserListEntry* _tmp11_ = NULL;
	gint64 user_id = 0LL;
	UserListEntry* _tmp12_ = NULL;
	gint64 _tmp13_ = 0LL;
	gint64 _tmp14_ = 0LL;
	Corebird* cb = NULL;
	GtkApplication* _tmp15_ = NULL;
	Corebird* _tmp16_ = NULL;
	MainWindow* account_window = NULL;
	gboolean _tmp17_ = FALSE;
	gint64 _tmp18_ = 0LL;
	Account* _tmp19_ = NULL;
	gint64 _tmp20_ = 0LL;
	Account* acc = NULL;
	gint64 _tmp28_ = 0LL;
	Account* _tmp29_ = NULL;
	Account* _tmp30_ = NULL;
	Account* _tmp31_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_ADD_LIST_ENTRY)) {
		GtkPopover* _tmp1_ = NULL;
		Account* dummy_acc = NULL;
		Account* _tmp2_ = NULL;
		MainWindow* window = NULL;
		GtkApplication* _tmp3_ = NULL;
		GtkApplication* _tmp4_ = NULL;
		Account* _tmp5_ = NULL;
		MainWindow* _tmp6_ = NULL;
		GtkApplication* _tmp7_ = NULL;
		MainWindow* _tmp8_ = NULL;
		MainWindow* _tmp9_ = NULL;
		_tmp1_ = self->priv->account_popover;
		gtk_popover_popdown (_tmp1_);
		_tmp2_ = account_new ((gint64) 0, ACCOUNT_DUMMY, "name");
		dummy_acc = _tmp2_;
		_tmp3_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_tmp4_ = _tmp3_;
		_tmp5_ = dummy_acc;
		_tmp6_ = main_window_new (_tmp4_, _tmp5_);
		g_object_ref_sink (_tmp6_);
		window = _tmp6_;
		_tmp7_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
		_tmp8_ = window;
		gtk_application_add_window (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_window_get_type (), GtkWindow));
		_tmp9_ = window;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (window);
		_g_object_unref0 (dummy_acc);
		return;
	}
	_tmp10_ = row;
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_USER_LIST_ENTRY, UserListEntry));
	e = _tmp11_;
	_tmp12_ = e;
	_tmp13_ = user_list_entry_get_user_id (_tmp12_);
	_tmp14_ = _tmp13_;
	user_id = _tmp14_;
	_tmp15_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_COREBIRD, Corebird));
	cb = _tmp16_;
	account_window = NULL;
	_tmp18_ = user_id;
	_tmp19_ = self->account;
	_tmp20_ = _tmp19_->id;
	if (_tmp18_ == _tmp20_) {
		_tmp17_ = TRUE;
	} else {
		Corebird* _tmp21_ = NULL;
		gint64 _tmp22_ = 0LL;
		MainWindow* _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
		_tmp21_ = cb;
		_tmp22_ = user_id;
		_tmp24_ = corebird_is_window_open_for_user_id (_tmp21_, _tmp22_, &_tmp23_);
		_g_object_unref0 (account_window);
		account_window = _tmp23_;
		_tmp17_ = _tmp24_;
	}
	if (_tmp17_) {
		GtkPopover* _tmp25_ = NULL;
		MainWindow* _tmp26_ = NULL;
		_tmp25_ = self->priv->account_popover;
		gtk_popover_popdown (_tmp25_);
		_tmp26_ = account_window;
		if (_tmp26_ != NULL) {
			MainWindow* _tmp27_ = NULL;
			_tmp27_ = account_window;
			gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_window_get_type (), GtkWindow));
		}
		_g_object_unref0 (account_window);
		_g_object_unref0 (cb);
		_g_object_unref0 (e);
		return;
	}
	_tmp28_ = user_id;
	_tmp29_ = account_query_account_by_id (_tmp28_);
	_tmp30_ = _g_object_ref0 (_tmp29_);
	acc = _tmp30_;
	_tmp31_ = acc;
	if (_tmp31_ != NULL) {
		Account* _tmp32_ = NULL;
		GtkPopover* _tmp33_ = NULL;
		_tmp32_ = acc;
		main_window_change_account (self, _tmp32_);
		_tmp33_ = self->priv->account_popover;
		gtk_popover_popdown (_tmp33_);
	} else {
		g_warning ("MainWindow.vala:274: account == null");
	}
	_g_object_unref0 (acc);
	_g_object_unref0 (account_window);
	_g_object_unref0 (cb);
	_g_object_unref0 (e);
}


static void _main_window_account_row_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	main_window_account_row_activated_cb ((MainWindow*) self, row);
}


static void main_window_thumb_button_pressed_cb (MainWindow* self, GtkGestureMultiPress* gesture, gint n_press, gdouble x, gdouble y) {
	guint button = 0U;
	GtkGestureMultiPress* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (GTK_IS_GESTURE_MULTI_PRESS (gesture));
	_tmp0_ = gesture;
	_tmp1_ = gtk_gesture_single_get_current_button (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_gesture_single_get_type (), GtkGestureSingle));
	button = _tmp1_;
	_tmp2_ = button;
	if (_tmp2_ == ((guint) 9)) {
		MainWidget* _tmp3_ = NULL;
		GtkGestureMultiPress* _tmp4_ = NULL;
		_tmp3_ = self->main_widget;
		main_widget_switch_page (_tmp3_, (gint) PAGE_NEXT, NULL);
		_tmp4_ = gesture;
		gtk_gesture_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_gesture_get_type (), GtkGesture), GTK_EVENT_SEQUENCE_CLAIMED);
	} else {
		guint _tmp5_ = 0U;
		_tmp5_ = button;
		if (_tmp5_ == ((guint) 8)) {
			MainWidget* _tmp6_ = NULL;
			GtkGestureMultiPress* _tmp7_ = NULL;
			_tmp6_ = self->main_widget;
			main_widget_switch_page (_tmp6_, (gint) PAGE_PREVIOUS, NULL);
			_tmp7_ = gesture;
			gtk_gesture_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_gesture_get_type (), GtkGesture), GTK_EVENT_SEQUENCE_CLAIMED);
		}
	}
}


static void ___lambda184_ (MainWindow* self) {
	GtkToggleButton* _tmp0_ = NULL;
	_tmp0_ = self->compose_tweet_button;
	gtk_toggle_button_set_active (_tmp0_, FALSE);
}


static void ____lambda184__gtk_widget_hide (GtkWidget* _sender, gpointer self) {
	___lambda184_ ((MainWindow*) self);
}


static void ___lambda185_ (MainWindow* self) {
	_g_object_unref0 (self->priv->compose_tweet_window);
	self->priv->compose_tweet_window = NULL;
}


static void ____lambda185__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	___lambda185_ ((MainWindow*) self);
}


static void main_window_show_hide_compose_window (MainWindow* self) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_ = NULL;
	ComposeTweetWindow* _tmp5_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp1_ = self->account;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Account* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = self->account;
		_tmp3_ = account_get_screen_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, ACCOUNT_DUMMY) == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = self->priv->compose_tweet_window;
	if (_tmp5_ == NULL) {
		Account* _tmp6_ = NULL;
		ComposeTweetWindow* _tmp7_ = NULL;
		ComposeTweetWindow* _tmp8_ = NULL;
		ComposeTweetWindow* _tmp9_ = NULL;
		ComposeTweetWindow* _tmp10_ = NULL;
		_tmp6_ = self->account;
		_tmp7_ = compose_tweet_window_new (self, _tmp6_, NULL, COMPOSE_TWEET_WINDOW_MODE_NORMAL);
		g_object_ref_sink (_tmp7_);
		_g_object_unref0 (self->priv->compose_tweet_window);
		self->priv->compose_tweet_window = _tmp7_;
		_tmp8_ = self->priv->compose_tweet_window;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		_tmp9_ = self->priv->compose_tweet_window;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), "hide", (GCallback) ____lambda184__gtk_widget_hide, self, 0);
		_tmp10_ = self->priv->compose_tweet_window;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), "destroy", (GCallback) ____lambda185__gtk_widget_destroy, self, 0);
	} else {
		ComposeTweetWindow* _tmp11_ = NULL;
		ComposeTweetWindow* _tmp12_ = NULL;
		_tmp11_ = self->priv->compose_tweet_window;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
		_tmp12_ = self->priv->compose_tweet_window;
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
	}
}


/**
   * GSimpleActionActivateCallback version of switch_page, used
   * for keyboard accelerators.
   */
static void main_window_simple_switch_page (MainWindow* self, GSimpleAction* a, GVariant* param) {
	MainWidget* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	gint32 _tmp2_ = 0;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp0_ = self->main_widget;
	_tmp1_ = param;
	_tmp2_ = g_variant_get_int32 (_tmp1_);
	main_widget_switch_page (_tmp0_, (gint) _tmp2_, NULL);
}


static void main_window_previous (MainWindow* self, GSimpleAction* a, GVariant* param) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_ = NULL;
	MainWidget* _tmp5_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp1_ = self->account;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Account* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = self->account;
		_tmp3_ = account_get_screen_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, ACCOUNT_DUMMY) == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = self->main_widget;
	main_widget_switch_page (_tmp5_, (gint) PAGE_PREVIOUS, NULL);
}


static void main_window_next (MainWindow* self, GSimpleAction* a, GVariant* param) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_ = NULL;
	MainWidget* _tmp5_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (G_IS_SIMPLE_ACTION (a));
	_tmp1_ = self->account;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Account* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = self->account;
		_tmp3_ = account_get_screen_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, ACCOUNT_DUMMY) == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = self->main_widget;
	main_widget_switch_page (_tmp5_, (gint) PAGE_NEXT, NULL);
}


static void main_window_show_account_dialog (MainWindow* self) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_ = NULL;
	AccountDialog* dialog = NULL;
	Account* _tmp5_ = NULL;
	AccountDialog* _tmp6_ = NULL;
	AccountDialog* _tmp7_ = NULL;
	AccountDialog* _tmp8_ = NULL;
	AccountDialog* _tmp9_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp1_ = self->account;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Account* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = self->account;
		_tmp3_ = account_get_screen_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, ACCOUNT_DUMMY) == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = self->account;
	_tmp6_ = account_dialog_new (_tmp5_);
	g_object_ref_sink (_tmp6_);
	dialog = _tmp6_;
	_tmp7_ = dialog;
	gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp8_ = dialog;
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_window_get_type (), GtkWindow), TRUE);
	_tmp9_ = dialog;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (dialog);
}


static void main_window_show_account_list (MainWindow* self) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp1_ = self->account;
	if (_tmp1_ != NULL) {
		Account* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = self->account;
		_tmp3_ = account_get_screen_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, ACCOUNT_DUMMY) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkPopover* _tmp5_ = NULL;
		_tmp5_ = self->priv->account_popover;
		gtk_popover_popup (_tmp5_);
	}
}


IPage* main_window_get_page (MainWindow* self, gint page_id) {
	IPage* result = NULL;
	MainWidget* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	IPage* _tmp2_ = NULL;
	g_return_val_if_fail (IS_MAIN_WINDOW (self), NULL);
	_tmp0_ = self->main_widget;
	_tmp1_ = page_id;
	_tmp2_ = main_widget_get_page (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static void main_window_account_button_clicked_cb (MainWindow* self) {
	GtkPopover* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->account_popover;
	_tmp1_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkPopover* _tmp3_ = NULL;
		_tmp3_ = self->priv->account_popover;
		gtk_popover_popdown (_tmp3_);
	} else {
		GtkPopover* _tmp4_ = NULL;
		_tmp4_ = self->priv->account_popover;
		gtk_popover_popup (_tmp4_);
	}
}


static void _main_window_account_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	main_window_account_button_clicked_cb ((MainWindow*) self);
}


static void main_window_account_popover_closed_cb (MainWindow* self) {
	GtkToggleButton* _tmp0_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = self->priv->account_button;
	gtk_toggle_button_set_active (_tmp0_, FALSE);
}


static void _main_window_account_popover_closed_cb_gtk_popover_closed (GtkPopover* _sender, gpointer self) {
	main_window_account_popover_closed_cb ((MainWindow*) self);
}


static gboolean main_window_window_delete_cb (MainWindow* self, GdkEventAny* evt) {
	gboolean result = FALSE;
	MainWidget* _tmp0_ = NULL;
	Account* _tmp2_ = NULL;
	GList* ws = NULL;
	GtkApplication* _tmp3_ = NULL;
	GtkApplication* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	gchar** startup_accounts = NULL;
	GSettings* _tmp8_ = NULL;
	GSettings* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint startup_accounts_length1 = 0;
	gint _startup_accounts_size_ = 0;
	gboolean _tmp13_ = FALSE;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint n_main_windows = 0;
	GList* _tmp19_ = NULL;
	gint _tmp31_ = 0;
	g_return_val_if_fail (IS_MAIN_WINDOW (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp0_ = self->main_widget;
	if (_tmp0_ != NULL) {
		MainWidget* _tmp1_ = NULL;
		_tmp1_ = self->main_widget;
		main_widget_stop (_tmp1_);
	}
	_tmp2_ = self->account;
	if (_tmp2_ == NULL) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp3_ = gtk_window_get_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_application_get_windows (_tmp4_);
	ws = _tmp5_;
	_tmp6_ = ws;
	_tmp7_ = g_list_length (_tmp6_);
	g_debug ("MainWindow.vala:393: Windows: %u", _tmp7_);
	_tmp8_ = settings_get ();
	_tmp9_ = _tmp8_;
	_tmp11_ = _tmp10_ = g_settings_get_strv (_tmp9_, "startup-accounts");
	_tmp12_ = _tmp11_;
	_tmp12__length1 = _vala_array_length (_tmp10_);
	_g_object_unref0 (_tmp9_);
	startup_accounts = _tmp12_;
	startup_accounts_length1 = _tmp12__length1;
	_startup_accounts_size_ = startup_accounts_length1;
	_tmp14_ = startup_accounts;
	_tmp14__length1 = startup_accounts_length1;
	if (_tmp14__length1 == 1) {
		gchar** _tmp15_ = NULL;
		gint _tmp15__length1 = 0;
		const gchar* _tmp16_ = NULL;
		_tmp15_ = startup_accounts;
		_tmp15__length1 = startup_accounts_length1;
		_tmp16_ = _tmp15_[0];
		_tmp13_ = g_strcmp0 (_tmp16_, "") == 0;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gint _tmp17_ = 0;
		_tmp17_ = 0;
		startup_accounts = g_renew (gchar*, startup_accounts, 0);
		(_tmp17_ > startup_accounts_length1) ? memset (startup_accounts + startup_accounts_length1, 0, sizeof (gchar*) * (_tmp17_ - startup_accounts_length1)) : NULL;
		startup_accounts_length1 = _tmp17_;
		_startup_accounts_size_ = _tmp17_;
	}
	main_window_save_geometry (self);
	_tmp18_ = startup_accounts;
	_tmp18__length1 = startup_accounts_length1;
	if (_tmp18__length1 > 0) {
		result = GDK_EVENT_PROPAGATE;
		startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	n_main_windows = 0;
	_tmp19_ = ws;
	{
		GList* win_collection = NULL;
		GList* win_it = NULL;
		win_collection = _tmp19_;
		for (win_it = win_collection; win_it != NULL; win_it = win_it->next) {
			GtkWindow* _tmp20_ = NULL;
			GtkWindow* win = NULL;
			_tmp20_ = _g_object_ref0 ((GtkWindow*) win_it->data);
			win = _tmp20_;
			{
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				GtkWindow* _tmp23_ = NULL;
				_tmp23_ = win;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, TYPE_MAIN_WINDOW)) {
					GtkWindow* _tmp24_ = NULL;
					Account* _tmp25_ = NULL;
					_tmp24_ = win;
					_tmp25_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_MAIN_WINDOW, MainWindow)->account;
					_tmp22_ = _tmp25_ != NULL;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					GtkWindow* _tmp26_ = NULL;
					Account* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					const gchar* _tmp29_ = NULL;
					_tmp26_ = win;
					_tmp27_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_MAIN_WINDOW, MainWindow)->account;
					_tmp28_ = account_get_screen_name (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = g_strcmp0 (_tmp29_, ACCOUNT_DUMMY) != 0;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					gint _tmp30_ = 0;
					_tmp30_ = n_main_windows;
					n_main_windows = _tmp30_ + 1;
				}
				_g_object_unref0 (win);
			}
		}
	}
	_tmp31_ = n_main_windows;
	if (_tmp31_ == 1) {
		gchar** new_startup_accounts = NULL;
		gchar** _tmp32_ = NULL;
		gint new_startup_accounts_length1 = 0;
		gint _new_startup_accounts_size_ = 0;
		gchar** _tmp33_ = NULL;
		gint _tmp33__length1 = 0;
		GList* _tmp34_ = NULL;
		gconstpointer _tmp35_ = NULL;
		Account* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		GSettings* _tmp41_ = NULL;
		GSettings* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		GList* _tmp44_ = NULL;
		gconstpointer _tmp45_ = NULL;
		Account* _tmp46_ = NULL;
		const gchar* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		_tmp32_ = g_new0 (gchar*, 1 + 1);
		new_startup_accounts = _tmp32_;
		new_startup_accounts_length1 = 1;
		_new_startup_accounts_size_ = new_startup_accounts_length1;
		_tmp33_ = new_startup_accounts;
		_tmp33__length1 = new_startup_accounts_length1;
		_tmp34_ = ws;
		_tmp35_ = g_list_nth_data (_tmp34_, (guint) 0);
		_tmp36_ = G_TYPE_CHECK_INSTANCE_CAST ((GtkWindow*) _tmp35_, TYPE_MAIN_WINDOW, MainWindow)->account;
		_tmp37_ = account_get_screen_name (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strdup (_tmp38_);
		_g_free0 (_tmp33_[0]);
		_tmp33_[0] = _tmp39_;
		_tmp40_ = _tmp33_[0];
		_tmp41_ = settings_get ();
		_tmp42_ = _tmp41_;
		_tmp43_ = new_startup_accounts;
		_tmp43__length1 = new_startup_accounts_length1;
		g_settings_set_strv (_tmp42_, "startup-accounts", _tmp43_);
		_g_object_unref0 (_tmp42_);
		_tmp44_ = ws;
		_tmp45_ = g_list_nth_data (_tmp44_, (guint) 0);
		_tmp46_ = G_TYPE_CHECK_INSTANCE_CAST ((GtkWindow*) _tmp45_, TYPE_MAIN_WINDOW, MainWindow)->account;
		_tmp47_ = account_get_screen_name (_tmp46_);
		_tmp48_ = _tmp47_;
		g_debug ("MainWindow.vala:417: Saving the account %s", _tmp48_);
		new_startup_accounts = (_vala_array_free (new_startup_accounts, new_startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	}
	result = GDK_EVENT_PROPAGATE;
	startup_accounts = (_vala_array_free (startup_accounts, startup_accounts_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gboolean _main_window_window_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = main_window_window_delete_cb ((MainWindow*) self, event);
	return result;
}


static void main_window_account_info_changed (MainWindow* self, const gchar* screen_name, const gchar* name, cairo_surface_t* small_avatar, cairo_surface_t* avatar) {
	MainWidget* _tmp0_ = NULL;
	MainWidget* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	IPage* _tmp4_ = NULL;
	IPage* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (screen_name != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (small_avatar != NULL);
	g_return_if_fail (avatar != NULL);
	_tmp0_ = self->main_widget;
	_tmp1_ = self->main_widget;
	_tmp2_ = main_widget_get_cur_page_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = main_widget_get_page (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = ipage_get_title (_tmp5_);
	_tmp7_ = _tmp6_;
	main_window_set_window_title (self, _tmp7_, GTK_STACK_TRANSITION_TYPE_NONE);
	_g_free0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
}


/**
   *
   */
static void main_window_load_geometry (MainWindow* self) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_ = NULL;
	GVariant* win_geom = NULL;
	GSettings* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	GVariant* _tmp9_ = NULL;
	Account* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gint _tmp18_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp1_ = self->account;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Account* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = self->account;
		_tmp3_ = account_get_screen_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, ACCOUNT_DUMMY) == 0;
	}
	if (_tmp0_) {
		g_debug ("MainWindow.vala:435: Could not load geometry, account == null");
		return;
	}
	_tmp5_ = settings_get ();
	_tmp6_ = _tmp5_;
	_tmp7_ = g_settings_get_value (_tmp6_, "window-geometry");
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	win_geom = _tmp8_;
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	_tmp9_ = win_geom;
	_tmp10_ = self->account;
	_tmp11_ = account_get_screen_name (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_lookup (_tmp9_, _tmp12_, "(iiii)", &x, &y, &w, &h, NULL);
	if (!_tmp13_) {
		Account* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_tmp14_ = self->account;
		_tmp15_ = account_get_screen_name (_tmp14_);
		_tmp16_ = _tmp15_;
		g_warning ("MainWindow.vala:445: Couldn't load window geometry for screen_name `%s" \
"'", _tmp16_);
		_g_variant_unref0 (win_geom);
		return;
	}
	_tmp18_ = w;
	if (_tmp18_ == 0) {
		_tmp17_ = TRUE;
	} else {
		gint _tmp19_ = 0;
		_tmp19_ = h;
		_tmp17_ = _tmp19_ == 0;
	}
	if (_tmp17_) {
		_g_variant_unref0 (win_geom);
		return;
	}
	_tmp20_ = x;
	_tmp21_ = y;
	gtk_window_move (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp20_, _tmp21_);
	_tmp22_ = w;
	_tmp23_ = h;
	gtk_window_set_default_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp22_, _tmp23_);
	_g_variant_unref0 (win_geom);
}


/**
   * Saves this window's geometry in the window-geometry gsettings key.
   */
void main_window_save_geometry (MainWindow* self) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_ = NULL;
	GVariant* win_geom = NULL;
	GSettings* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	GVariant* new_geom = NULL;
	GVariantBuilder* builder = NULL;
	GVariantType* _tmp9_ = NULL;
	GVariantType* _tmp10_ = NULL;
	GVariantBuilder* _tmp11_ = NULL;
	GVariantBuilder* _tmp12_ = NULL;
	GVariantIter* iter = NULL;
	GVariant* _tmp13_ = NULL;
	GVariantIter* _tmp14_ = NULL;
	gchar* key = NULL;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	GVariantBuilder* _tmp31_ = NULL;
	Account* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	GVariantBuilder* _tmp39_ = NULL;
	GVariant* _tmp40_ = NULL;
	Account* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	GSettings* _tmp48_ = NULL;
	GSettings* _tmp49_ = NULL;
	GVariant* _tmp50_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp1_ = self->account;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Account* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		_tmp2_ = self->account;
		_tmp3_ = account_get_screen_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, ACCOUNT_DUMMY) == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp5_ = settings_get ();
	_tmp6_ = _tmp5_;
	_tmp7_ = g_settings_get_value (_tmp6_, "window-geometry");
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	win_geom = _tmp8_;
	_tmp9_ = g_variant_type_new ("a{s(iiii)}");
	_tmp10_ = _tmp9_;
	_tmp11_ = g_variant_builder_new (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_variant_type_free0 (_tmp10_);
	builder = _tmp12_;
	_tmp13_ = win_geom;
	_tmp14_ = g_variant_iter_new (_tmp13_);
	iter = _tmp14_;
	key = NULL;
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	while (TRUE) {
		GVariantIter* _tmp15_ = NULL;
		gboolean _tmp16_ = FALSE;
		const gchar* _tmp17_ = NULL;
		Account* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		_tmp15_ = iter;
		_tmp16_ = g_variant_iter_next (_tmp15_, "{s(iiii)}", &key, &x, &y, &w, &h, NULL);
		if (!_tmp16_) {
			break;
		}
		_tmp17_ = key;
		_tmp18_ = self->account;
		_tmp19_ = account_get_screen_name (_tmp18_);
		_tmp20_ = _tmp19_;
		if (g_strcmp0 (_tmp17_, _tmp20_) != 0) {
			GVariantBuilder* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			_tmp21_ = builder;
			_tmp22_ = key;
			_tmp23_ = x;
			_tmp24_ = y;
			_tmp25_ = w;
			_tmp26_ = h;
			g_variant_builder_add (_tmp21_, "{s(iiii)}", _tmp22_, _tmp23_, _tmp24_, _tmp25_, _tmp26_, NULL);
		}
		_g_free0 (key);
		key = NULL;
	}
	gtk_window_get_position (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp27_, &_tmp28_);
	x = _tmp27_;
	y = _tmp28_;
	gtk_window_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), &_tmp29_, &_tmp30_);
	w = _tmp29_;
	h = _tmp30_;
	_tmp31_ = builder;
	_tmp32_ = self->account;
	_tmp33_ = account_get_screen_name (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = x;
	_tmp36_ = y;
	_tmp37_ = w;
	_tmp38_ = h;
	g_variant_builder_add (_tmp31_, "{s(iiii)}", _tmp34_, _tmp35_, _tmp36_, _tmp37_, _tmp38_, NULL);
	_tmp39_ = builder;
	_tmp40_ = g_variant_builder_end (_tmp39_);
	g_variant_ref_sink (_tmp40_);
	_g_variant_unref0 (new_geom);
	new_geom = _tmp40_;
	_tmp41_ = self->account;
	_tmp42_ = account_get_screen_name (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = x;
	_tmp45_ = y;
	_tmp46_ = w;
	_tmp47_ = h;
	g_debug ("MainWindow.vala:483: Saving geomentry for %s: %d,%d,%d,%d", _tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_);
	_tmp48_ = settings_get ();
	_tmp49_ = _tmp48_;
	_tmp50_ = new_geom;
	g_settings_set_value (_tmp49_, "window-geometry", _tmp50_);
	_g_object_unref0 (_tmp49_);
	_g_free0 (key);
	_g_variant_iter_free0 (iter);
	_g_variant_builder_unref0 (builder);
	_g_variant_unref0 (new_geom);
	_g_variant_unref0 (win_geom);
}


static gint main_window_account_sort_func (MainWindow* self, GtkListBoxRow* a, GtkListBoxRow* b) {
	gint result = 0;
	GtkListBoxRow* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GtkListBoxRow* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	g_return_val_if_fail (IS_MAIN_WINDOW (self), 0);
	g_return_val_if_fail (GTK_IS_LIST_BOX_ROW (a), 0);
	g_return_val_if_fail (GTK_IS_LIST_BOX_ROW (b), 0);
	_tmp0_ = a;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_ADD_LIST_ENTRY)) {
		result = 1;
		return result;
	}
	_tmp1_ = a;
	_tmp2_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_USER_LIST_ENTRY, UserListEntry));
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = b;
	_tmp6_ = user_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_USER_LIST_ENTRY, UserListEntry));
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = g_ascii_strcasecmp (_tmp4_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp4_);
	result = _tmp10_;
	return result;
}


void main_window_rerun_filters (MainWindow* self) {
	IPage* _tmp0_ = NULL;
	DefaultTimeline* _tmp1_ = NULL;
	IPage* _tmp2_ = NULL;
	DefaultTimeline* _tmp3_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = main_window_get_page (self, (gint) PAGE_STREAM);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	default_timeline_rerun_filters (_tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = main_window_get_page (self, (gint) PAGE_MENTIONS);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	default_timeline_rerun_filters (_tmp3_);
	_g_object_unref0 (_tmp3_);
}


void main_window_set_window_title (MainWindow* self, const gchar* title, GtkStackTransitionType transition_type) {
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkStack* _tmp4_ = NULL;
	GtkStack* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkStack* _tmp7_ = NULL;
	GtkStackTransitionType _tmp8_ = 0;
	GtkLabel* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GtkStack* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->last_page_label;
	_tmp1_ = self->priv->title_label;
	_tmp2_ = gtk_label_get_label (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_tmp4_ = self->priv->title_stack;
	gtk_stack_set_transition_type (_tmp4_, GTK_STACK_TRANSITION_TYPE_NONE);
	_tmp5_ = self->priv->title_stack;
	_tmp6_ = self->priv->last_page_label;
	gtk_stack_set_visible_child (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = self->priv->title_stack;
	_tmp8_ = transition_type;
	gtk_stack_set_transition_type (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->title_label;
	_tmp10_ = title;
	gtk_label_set_label (_tmp9_, _tmp10_);
	_tmp11_ = self->priv->title_stack;
	_tmp12_ = self->priv->title_label;
	gtk_stack_set_visible_child (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
}


void main_window_reply_to_tweet (MainWindow* self, gint64 tweet_id) {
	CbTweet* tweet = NULL;
	MainWidget* _tmp0_ = NULL;
	IPage* _tmp1_ = NULL;
	DefaultTimeline* _tmp2_ = NULL;
	TweetListBox* _tmp3_ = NULL;
	TweetModel* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	CbTweet* _tmp6_ = NULL;
	CbTweet* _tmp7_ = NULL;
	ComposeTweetWindow* ctw = NULL;
	Account* _tmp11_ = NULL;
	CbTweet* _tmp12_ = NULL;
	ComposeTweetWindow* _tmp13_ = NULL;
	ComposeTweetWindow* _tmp14_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	tweet = NULL;
	_tmp0_ = self->main_widget;
	_tmp1_ = main_widget_get_page (_tmp0_, (gint) PAGE_STREAM);
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp3_ = _tmp2_->tweet_list;
	_tmp4_ = _tmp3_->model;
	_tmp5_ = tweet_id;
	_tmp6_ = tweet_model_get_from_id (_tmp4_, _tmp5_, 0);
	_g_object_unref0 (tweet);
	tweet = _tmp6_;
	_g_object_unref0 (_tmp2_);
	_tmp7_ = tweet;
	if (_tmp7_ == NULL) {
		gint64 _tmp8_ = 0LL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp8_ = tweet_id;
		_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp8_);
		_tmp10_ = _tmp9_;
		g_warning ("MainWindow.vala:518: tweet with id %s could not be found", _tmp10_);
		_g_free0 (_tmp10_);
		_g_object_unref0 (tweet);
		return;
	}
	_tmp11_ = self->account;
	_tmp12_ = tweet;
	_tmp13_ = compose_tweet_window_new (self, _tmp11_, _tmp12_, COMPOSE_TWEET_WINDOW_MODE_REPLY);
	g_object_ref_sink (_tmp13_);
	ctw = _tmp13_;
	_tmp14_ = ctw;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
	_g_object_unref0 (tweet);
}


void main_window_mark_tweet_as_read (MainWindow* self, gint64 tweet_id) {
	DefaultTimeline* home_timeline = NULL;
	MainWidget* _tmp0_ = NULL;
	IPage* _tmp1_ = NULL;
	DefaultTimeline* mentions_timeline = NULL;
	MainWidget* _tmp2_ = NULL;
	IPage* _tmp3_ = NULL;
	CbTweet* tweet = NULL;
	DefaultTimeline* _tmp4_ = NULL;
	TweetListBox* _tmp5_ = NULL;
	TweetModel* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	CbTweet* _tmp8_ = NULL;
	CbTweet* _tmp9_ = NULL;
	DefaultTimeline* _tmp14_ = NULL;
	TweetListBox* _tmp15_ = NULL;
	TweetModel* _tmp16_ = NULL;
	gint64 _tmp17_ = 0LL;
	CbTweet* _tmp18_ = NULL;
	CbTweet* _tmp19_ = NULL;
	g_return_if_fail (IS_MAIN_WINDOW (self));
	_tmp0_ = self->main_widget;
	_tmp1_ = main_widget_get_page (_tmp0_, (gint) PAGE_STREAM);
	home_timeline = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	_tmp2_ = self->main_widget;
	_tmp3_ = main_widget_get_page (_tmp2_, (gint) PAGE_MENTIONS);
	mentions_timeline = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_DEFAULT_TIMELINE, DefaultTimeline);
	tweet = NULL;
	_tmp4_ = home_timeline;
	_tmp5_ = _tmp4_->tweet_list;
	_tmp6_ = _tmp5_->model;
	_tmp7_ = tweet_id;
	_tmp8_ = tweet_model_get_from_id (_tmp6_, _tmp7_, 0);
	_g_object_unref0 (tweet);
	tweet = _tmp8_;
	_tmp9_ = tweet;
	if (_tmp9_ != NULL) {
		CbTweet* _tmp10_ = NULL;
		DefaultTimeline* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp10_ = tweet;
		cb_tweet_set_seen (_tmp10_, TRUE);
		_tmp11_ = home_timeline;
		_tmp12_ = default_timeline_get_unread_count (_tmp11_);
		_tmp13_ = _tmp12_;
		default_timeline_set_unread_count (_tmp11_, _tmp13_ - 1);
	}
	_tmp14_ = mentions_timeline;
	_tmp15_ = _tmp14_->tweet_list;
	_tmp16_ = _tmp15_->model;
	_tmp17_ = tweet_id;
	_tmp18_ = tweet_model_get_from_id (_tmp16_, _tmp17_, 0);
	_g_object_unref0 (tweet);
	tweet = _tmp18_;
	_tmp19_ = tweet;
	if (_tmp19_ != NULL) {
		CbTweet* _tmp20_ = NULL;
		DefaultTimeline* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp20_ = tweet;
		cb_tweet_set_seen (_tmp20_, TRUE);
		_tmp21_ = mentions_timeline;
		_tmp22_ = default_timeline_get_unread_count (_tmp21_);
		_tmp23_ = _tmp22_;
		default_timeline_set_unread_count (_tmp21_, _tmp23_ - 1);
	}
	_g_object_unref0 (tweet);
	_g_object_unref0 (mentions_timeline);
	_g_object_unref0 (home_timeline);
}


gint main_window_get_cur_page_id (MainWindow* self) {
	gint result;
	MainWidget* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_val_if_fail (IS_MAIN_WINDOW (self), 0);
	_tmp0_ = self->main_widget;
	_tmp1_ = main_widget_get_cur_page_id (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void main_window_class_init (MainWindowClass * klass) {
	gint MainWindow_private_offset;
	main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MainWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_main_window_get_property;
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_CUR_PAGE_ID, g_param_spec_int ("cur-page-id", "cur-page-id", "cur-page-id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	MainWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/main-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, MainWindow_private_offset + G_STRUCT_OFFSET (MainWindowPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, MainWindow_private_offset + G_STRUCT_OFFSET (MainWindowPrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "account_list", FALSE, MainWindow_private_offset + G_STRUCT_OFFSET (MainWindowPrivate, account_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "account_popover", FALSE, MainWindow_private_offset + G_STRUCT_OFFSET (MainWindowPrivate, account_popover));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header_box", FALSE, MainWindow_private_offset + G_STRUCT_OFFSET (MainWindowPrivate, header_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "account_button", FALSE, MainWindow_private_offset + G_STRUCT_OFFSET (MainWindowPrivate, account_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_button", FALSE, G_STRUCT_OFFSET (MainWindow, back_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "compose_tweet_button", FALSE, G_STRUCT_OFFSET (MainWindow, compose_tweet_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_label", FALSE, MainWindow_private_offset + G_STRUCT_OFFSET (MainWindowPrivate, title_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "last_page_label", FALSE, MainWindow_private_offset + G_STRUCT_OFFSET (MainWindowPrivate, last_page_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_stack", FALSE, MainWindow_private_offset + G_STRUCT_OFFSET (MainWindowPrivate, title_stack));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "back_button_clicked_cb", G_CALLBACK(_main_window_back_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "account_row_activated_cb", G_CALLBACK(_main_window_account_row_activated_cb_gtk_list_box_row_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "account_button_clicked_cb", G_CALLBACK(_main_window_account_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "account_popover_closed_cb", G_CALLBACK(_main_window_account_popover_closed_cb_gtk_popover_closed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "window_delete_cb", G_CALLBACK(_main_window_window_delete_cb_gtk_widget_delete_event));
}


static void main_window_instance_init (MainWindow * self) {
	self->priv = MAIN_WINDOW_GET_PRIVATE (self);
	self->priv->app_menu_button = NULL;
	self->priv->compose_tweet_window = NULL;
	g_type_ensure (TYPE_AVATAR_WIDGET);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void main_window_finalize (GObject* obj) {
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW, MainWindow);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->account_list);
	_g_object_unref0 (self->priv->account_popover);
	_g_object_unref0 (self->priv->header_box);
	_g_object_unref0 (self->priv->account_button);
	_g_object_unref0 (self->back_button);
	_g_object_unref0 (self->compose_tweet_button);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->last_page_label);
	_g_object_unref0 (self->priv->title_stack);
	_g_object_unref0 (self->priv->app_menu_button);
	_g_object_unref0 (self->main_widget);
	_g_object_unref0 (self->priv->compose_tweet_window);
	_g_object_unref0 (self->priv->thumb_button_gesture);
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
}


GType main_window_get_type (void) {
	static volatile gsize main_window_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
		GType main_window_type_id;
		main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "MainWindow", &g_define_type_info, 0);
		g_once_init_leave (&main_window_type_id__volatile, main_window_type_id);
	}
	return main_window_type_id__volatile;
}


static void _vala_main_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WINDOW, MainWindow);
	switch (property_id) {
		case MAIN_WINDOW_CUR_PAGE_ID:
		g_value_set_int (value, main_window_get_cur_page_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



