/* CompletionTextView.c generated by valac 0.34.6, the Vala compiler
 * generated from CompletionTextView.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include "CbUserCounter.h"
#include <rest/oauth-proxy.h>
#include "CbFilter.h"
#include <sqlite3.h>
#include <glib/gi18n-lib.h>
#include <gspell/gspell.h>


#define TYPE_COMPLETION_TEXT_VIEW (completion_text_view_get_type ())
#define COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextView))
#define COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))
#define IS_COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_TEXT_VIEW))
#define IS_COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_TEXT_VIEW))
#define COMPLETION_TEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))

typedef struct _CompletionTextView CompletionTextView;
typedef struct _CompletionTextViewClass CompletionTextViewClass;
typedef struct _CompletionTextViewPrivate CompletionTextViewPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SNIPPET_MANAGER (snippet_manager_get_type ())
#define SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNIPPET_MANAGER, SnippetManager))
#define SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNIPPET_MANAGER, SnippetManagerClass))
#define IS_SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNIPPET_MANAGER))
#define IS_SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNIPPET_MANAGER))
#define SNIPPET_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNIPPET_MANAGER, SnippetManagerClass))

typedef struct _SnippetManager SnippetManager;
typedef struct _SnippetManagerClass SnippetManagerClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CompletionTextView {
	GtkTextView parent_instance;
	CompletionTextViewPrivate * priv;
};

struct _CompletionTextViewClass {
	GtkTextViewClass parent_class;
};

struct _CompletionTextViewPrivate {
	GtkListBox* completion_list;
	GtkWindow* completion_window;
	gint current_match;
	gchar* current_word;
	Account* account;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};


static gpointer completion_text_view_parent_class = NULL;
extern SnippetManager* corebird_snippet_manager;

GType completion_text_view_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define COMPLETION_TEXT_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewPrivate))
enum  {
	COMPLETION_TEXT_VIEW_DUMMY_PROPERTY
};
void completion_text_view_set_account (CompletionTextView* self, Account* account);
static gboolean completion_text_view_insert_snippet (CompletionTextView* self);
static gchar* completion_text_view_get_cursor_word (CompletionTextView* self, GtkTextIter* start_iter, GtkTextIter* end_iter);
GType snippet_manager_get_type (void) G_GNUC_CONST;
gchar* snippet_manager_get_snippet (SnippetManager* self, const gchar* key);
static inline gboolean completion_text_view_snippets_configured (CompletionTextView* self);
guint snippet_manager_n_snippets (SnippetManager* self);
static gboolean completion_text_view_key_press_event_cb (CompletionTextView* self, GdkEventKey* evt);
static void completion_text_view_insert_completion (CompletionTextView* self, const gchar* compl);
static void completion_text_view_hide_completion_window (CompletionTextView* self);
static void completion_text_view_buffer_changed_cb (CompletionTextView* self);
static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self);
void tweet_utils_annotate_text (GtkTextBuffer* buffer);
static void completion_text_view_show_completion_window (CompletionTextView* self);
static void __lambda41_ (CompletionTextView* self, GtkWidget* w);
static void ___lambda41__gtk_callback (GtkWidget* widget, gpointer self);
static gboolean completion_text_view_completion_window_focus_out_cb (CompletionTextView* self);
static void completion_text_view_update_completion (CompletionTextView* self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
sqlite3* sql_database_get_sqlite_db (SqlDatabase* self);
static void _vala_CbUserInfo_array_free (CbUserInfo* array, gint array_length);
CompletionTextView* completion_text_view_new (void);
CompletionTextView* completion_text_view_construct (GType object_type);
static GObject * completion_text_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
#define TWEET_UTILS_NO_SPELL_CHECK "gtksourceview:context-classes:no-spell-check"
static void _completion_text_view_update_completion_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _completion_text_view_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static gboolean _completion_text_view_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void completion_text_view_finalize (GObject* obj);

static const gchar* COMPLETION_TEXT_VIEW_TEXT_TAGS[4] = {"link", "mention", "hashtag", "snippet"};

void completion_text_view_set_account (CompletionTextView* self, Account* account) {
	Account* _tmp0_ = NULL;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	g_return_if_fail (IS_ACCOUNT (account));
	_tmp0_ = account;
	self->priv->account = _tmp0_;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean completion_text_view_insert_snippet (CompletionTextView* self) {
	gboolean result = FALSE;
	GtkTextIter cursor_word_start = {0};
	GtkTextIter cursor_word_end = {0};
	gchar* cursor_word = NULL;
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_ = NULL;
	gunichar _tmp6_ = 0U;
	gchar* snippet = NULL;
	SnippetManager* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GtkTextIter start_word_iter = {0};
	GtkTextBuffer* _tmp21_ = NULL;
	GtkTextBuffer* _tmp22_ = NULL;
	GtkTextBuffer* _tmp23_ = NULL;
	GtkTextBuffer* _tmp24_ = NULL;
	GtkTextIter _tmp25_ = {0};
	GtkTextIter _tmp26_ = {0};
	GtkTextMark* cursor_mark = NULL;
	GtkTextBuffer* _tmp27_ = NULL;
	GtkTextBuffer* _tmp28_ = NULL;
	GtkTextMark* _tmp29_ = NULL;
	GtkTextMark* _tmp30_ = NULL;
	GtkTextBuffer* _tmp31_ = NULL;
	GtkTextBuffer* _tmp32_ = NULL;
	GtkTextMark* _tmp33_ = NULL;
	GtkTextIter _tmp34_ = {0};
	GtkTextBuffer* _tmp35_ = NULL;
	GtkTextBuffer* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	GtkTextBuffer* _tmp41_ = NULL;
	GtkTextBuffer* _tmp42_ = NULL;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	_tmp2_ = completion_text_view_get_cursor_word (self, &_tmp0_, &_tmp1_);
	cursor_word_start = _tmp0_;
	cursor_word_end = _tmp1_;
	cursor_word = _tmp2_;
	_tmp5_ = cursor_word;
	_tmp6_ = string_get_char (_tmp5_, (glong) 0);
	if (_tmp6_ == ((gunichar) ' ')) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp7_ = NULL;
		gunichar _tmp8_ = 0U;
		_tmp7_ = cursor_word;
		_tmp8_ = string_get_char (_tmp7_, (glong) 0);
		_tmp4_ = _tmp8_ == ((gunichar) '\t');
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp9_ = NULL;
		gunichar _tmp10_ = 0U;
		_tmp9_ = cursor_word;
		_tmp10_ = string_get_char (_tmp9_, (glong) 0);
		_tmp3_ = _tmp10_ == ((gunichar) '\n');
	}
	if (_tmp3_) {
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp11_ = cursor_word;
		_tmp12_ = string_substring (_tmp11_, (glong) 1, (glong) -1);
		_g_free0 (cursor_word);
		cursor_word = _tmp12_;
		gtk_text_iter_forward_char (&cursor_word_start);
	}
	_tmp13_ = corebird_snippet_manager;
	_tmp14_ = cursor_word;
	_tmp15_ = string_strip (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = snippet_manager_get_snippet (_tmp13_, _tmp16_);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	snippet = _tmp18_;
	_tmp19_ = snippet;
	if (_tmp19_ == NULL) {
		const gchar* _tmp20_ = NULL;
		_tmp20_ = cursor_word;
		g_debug ("CompletionTextView.vala:133: No snippet for cursor_word '%s' found.", _tmp20_);
		result = FALSE;
		_g_free0 (snippet);
		_g_free0 (cursor_word);
		return result;
	}
	_tmp21_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp22_ = _tmp21_;
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, G_TYPE_OBJECT, GObject));
	_tmp23_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp24_ = _tmp23_;
	_tmp25_ = cursor_word_start;
	_tmp26_ = cursor_word_end;
	g_signal_emit_by_name (_tmp24_, "delete-range", &_tmp25_, &_tmp26_);
	_tmp27_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp28_ = _tmp27_;
	_tmp29_ = gtk_text_buffer_get_insert (_tmp28_);
	_tmp30_ = _g_object_ref0 (_tmp29_);
	cursor_mark = _tmp30_;
	_tmp31_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp32_ = _tmp31_;
	_tmp33_ = cursor_mark;
	gtk_text_buffer_get_iter_at_mark (_tmp32_, &_tmp34_, _tmp33_);
	start_word_iter = _tmp34_;
	_tmp35_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp36_ = _tmp35_;
	_tmp37_ = snippet;
	_tmp38_ = snippet;
	_tmp39_ = strlen (_tmp38_);
	_tmp40_ = _tmp39_;
	g_signal_emit_by_name (_tmp36_, "insert-text", &start_word_iter, _tmp37_, _tmp40_);
	_tmp41_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp42_ = _tmp41_;
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, G_TYPE_OBJECT, GObject));
	result = TRUE;
	_g_object_unref0 (cursor_mark);
	_g_free0 (snippet);
	_g_free0 (cursor_word);
	return result;
}


static inline gboolean completion_text_view_snippets_configured (CompletionTextView* self) {
	gboolean result = FALSE;
	SnippetManager* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	_tmp0_ = corebird_snippet_manager;
	_tmp1_ = snippet_manager_n_snippets (_tmp0_);
	result = _tmp1_ > ((guint) 0);
	return result;
}


static gboolean completion_text_view_key_press_event_cb (CompletionTextView* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GtkWindow* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gint n_results = 0;
	GtkListBox* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	GList* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	gint _tmp12_ = 0;
	GdkEventKey* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->keyval;
	if (_tmp2_ == ((guint) GDK_KEY_Tab)) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = completion_text_view_snippets_configured (self);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = completion_text_view_insert_snippet (self);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = self->priv->completion_window;
	_tmp6_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = _tmp6_;
	if (!_tmp7_) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp8_ = self->priv->completion_list;
	_tmp9_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_container_get_type (), GtkContainer));
	_tmp10_ = _tmp9_;
	_tmp11_ = g_list_length (_tmp10_);
	_tmp12_ = (gint) _tmp11_;
	_g_list_free0 (_tmp10_);
	n_results = _tmp12_;
	_tmp13_ = evt;
	_tmp14_ = _tmp13_->keyval;
	if (_tmp14_ == ((guint) GDK_KEY_Down)) {
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		GtkListBoxRow* row = NULL;
		GtkListBox* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		GtkListBoxRow* _tmp20_ = NULL;
		GtkListBoxRow* _tmp21_ = NULL;
		GtkListBox* _tmp22_ = NULL;
		GtkListBoxRow* _tmp23_ = NULL;
		_tmp15_ = n_results;
		if (_tmp15_ == 0) {
			result = GDK_EVENT_PROPAGATE;
			return result;
		}
		_tmp16_ = self->priv->current_match;
		_tmp17_ = n_results;
		self->priv->current_match = (_tmp16_ + 1) % _tmp17_;
		_tmp18_ = self->priv->completion_list;
		_tmp19_ = self->priv->current_match;
		_tmp20_ = gtk_list_box_get_row_at_index (_tmp18_, _tmp19_);
		_tmp21_ = _g_object_ref0 (_tmp20_);
		row = _tmp21_;
		_tmp22_ = self->priv->completion_list;
		_tmp23_ = row;
		gtk_list_box_select_row (_tmp22_, _tmp23_);
		result = GDK_EVENT_STOP;
		_g_object_unref0 (row);
		return result;
	} else {
		GdkEventKey* _tmp24_ = NULL;
		guint _tmp25_ = 0U;
		_tmp24_ = evt;
		_tmp25_ = _tmp24_->keyval;
		if (_tmp25_ == ((guint) GDK_KEY_Up)) {
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			GtkListBoxRow* row = NULL;
			GtkListBox* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			GtkListBoxRow* _tmp31_ = NULL;
			GtkListBoxRow* _tmp32_ = NULL;
			GtkListBox* _tmp33_ = NULL;
			GtkListBoxRow* _tmp34_ = NULL;
			_tmp26_ = self->priv->current_match;
			self->priv->current_match = _tmp26_ - 1;
			_tmp27_ = self->priv->current_match;
			if (_tmp27_ < 0) {
				gint _tmp28_ = 0;
				_tmp28_ = n_results;
				self->priv->current_match = _tmp28_ - 1;
			}
			_tmp29_ = self->priv->completion_list;
			_tmp30_ = self->priv->current_match;
			_tmp31_ = gtk_list_box_get_row_at_index (_tmp29_, _tmp30_);
			_tmp32_ = _g_object_ref0 (_tmp31_);
			row = _tmp32_;
			_tmp33_ = self->priv->completion_list;
			_tmp34_ = row;
			gtk_list_box_select_row (_tmp33_, _tmp34_);
			result = GDK_EVENT_STOP;
			_g_object_unref0 (row);
			return result;
		} else {
			GdkEventKey* _tmp35_ = NULL;
			guint _tmp36_ = 0U;
			_tmp35_ = evt;
			_tmp36_ = _tmp35_->keyval;
			if (_tmp36_ == ((guint) GDK_KEY_Return)) {
				gint _tmp37_ = 0;
				gint _tmp38_ = 0;
				GtkListBoxRow* row = NULL;
				GtkListBox* _tmp39_ = NULL;
				gint _tmp40_ = 0;
				GtkListBoxRow* _tmp41_ = NULL;
				GtkListBoxRow* _tmp42_ = NULL;
				gchar* compl = NULL;
				GtkListBoxRow* _tmp43_ = NULL;
				GtkWidget* _tmp44_ = NULL;
				const gchar* _tmp45_ = NULL;
				const gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				gchar* _tmp50_ = NULL;
				_tmp37_ = n_results;
				if (_tmp37_ == 0) {
					result = FALSE;
					return result;
				}
				_tmp38_ = self->priv->current_match;
				if (_tmp38_ == -1) {
					self->priv->current_match = 0;
				}
				_tmp39_ = self->priv->completion_list;
				_tmp40_ = self->priv->current_match;
				_tmp41_ = gtk_list_box_get_row_at_index (_tmp39_, _tmp40_);
				_tmp42_ = _g_object_ref0 (_tmp41_);
				row = _tmp42_;
				_tmp43_ = row;
				_tmp44_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, gtk_list_box_row_get_type (), GtkListBoxRow), gtk_bin_get_type (), GtkBin));
				_tmp45_ = gtk_label_get_label (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, gtk_label_get_type (), GtkLabel));
				_tmp46_ = _tmp45_;
				_tmp47_ = g_strdup (_tmp46_);
				compl = _tmp47_;
				_tmp48_ = compl;
				_tmp49_ = string_substring (_tmp48_, (glong) 1, (glong) -1);
				_tmp50_ = _tmp49_;
				completion_text_view_insert_completion (self, _tmp50_);
				_g_free0 (_tmp50_);
				self->priv->current_match = -1;
				completion_text_view_hide_completion_window (self);
				result = GDK_EVENT_STOP;
				_g_free0 (compl);
				_g_object_unref0 (row);
				return result;
			} else {
				GdkEventKey* _tmp51_ = NULL;
				guint _tmp52_ = 0U;
				_tmp51_ = evt;
				_tmp52_ = _tmp51_->keyval;
				if (_tmp52_ == ((guint) GDK_KEY_Escape)) {
					completion_text_view_hide_completion_window (self);
					result = GDK_EVENT_STOP;
					return result;
				}
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static GtkTextIter* _gtk_text_iter_dup (GtkTextIter* self) {
	GtkTextIter* dup;
	dup = g_new0 (GtkTextIter, 1);
	memcpy (dup, self, sizeof (GtkTextIter));
	return dup;
}


static gpointer __gtk_text_iter_dup0 (gpointer self) {
	return self ? _gtk_text_iter_dup (self) : NULL;
}


static void completion_text_view_buffer_changed_cb (CompletionTextView* self) {
	GtkTextIter* start_iter = NULL;
	GtkTextIter* end_iter = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextBuffer* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter _tmp8_ = {0};
	GtkTextIter* _tmp9_ = NULL;
	GtkTextTagTable* tag_table = NULL;
	GtkTextBuffer* _tmp10_ = NULL;
	GtkTextBuffer* _tmp11_ = NULL;
	GtkTextTagTable* _tmp12_ = NULL;
	GtkTextTagTable* _tmp13_ = NULL;
	GtkTextBuffer* _tmp27_ = NULL;
	GtkTextBuffer* _tmp28_ = NULL;
	GtkTextBuffer* _tmp29_ = NULL;
	GtkTextBuffer* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	gboolean _tmp36_ = FALSE;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	_tmp0_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp1_ = _tmp0_;
	gtk_text_buffer_get_start_iter (_tmp1_, &_tmp2_);
	_g_free0 (start_iter);
	_tmp3_ = _tmp2_;
	_tmp4_ = __gtk_text_iter_dup0 (&_tmp3_);
	start_iter = _tmp4_;
	_tmp5_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp6_ = _tmp5_;
	gtk_text_buffer_get_end_iter (_tmp6_, &_tmp7_);
	_g_free0 (end_iter);
	_tmp8_ = _tmp7_;
	_tmp9_ = __gtk_text_iter_dup0 (&_tmp8_);
	end_iter = _tmp9_;
	_tmp10_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp11_ = _tmp10_;
	_tmp12_ = gtk_text_buffer_get_tag_table (_tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	tag_table = _tmp13_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				gint _tmp16_ = 0;
				GtkTextBuffer* _tmp17_ = NULL;
				GtkTextBuffer* _tmp18_ = NULL;
				GtkTextTagTable* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				const gchar* _tmp21_ = NULL;
				GtkTextTag* _tmp22_ = NULL;
				GtkTextIter* _tmp23_ = NULL;
				GtkTextIter* _tmp24_ = NULL;
				GtkTextIter _tmp25_ = {0};
				GtkTextIter _tmp26_ = {0};
				if (!_tmp14_) {
					gint _tmp15_ = 0;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = i;
				if (!(_tmp16_ < G_N_ELEMENTS (COMPLETION_TEXT_VIEW_TEXT_TAGS))) {
					break;
				}
				_tmp17_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
				_tmp18_ = _tmp17_;
				_tmp19_ = tag_table;
				_tmp20_ = i;
				_tmp21_ = COMPLETION_TEXT_VIEW_TEXT_TAGS[_tmp20_];
				_tmp22_ = gtk_text_tag_table_lookup (_tmp19_, _tmp21_);
				_tmp23_ = start_iter;
				_tmp24_ = end_iter;
				_tmp25_ = *_tmp23_;
				_tmp26_ = *_tmp24_;
				gtk_text_buffer_remove_tag (_tmp18_, _tmp22_, &_tmp25_, &_tmp26_);
			}
		}
	}
	_tmp27_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp28_ = _tmp27_;
	tweet_utils_annotate_text (_tmp28_);
	_tmp29_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp30_ = _tmp29_;
	g_object_get (_tmp30_, "text", &_tmp31_, NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = _tmp32_;
	_tmp34_ = strlen (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_ == 0;
	_g_free0 (_tmp33_);
	if (_tmp36_) {
		GtkWindow* _tmp37_ = NULL;
		_tmp37_ = self->priv->completion_window;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
	}
	_g_object_unref0 (tag_table);
	_g_free0 (end_iter);
	_g_free0 (start_iter);
}


static void __lambda41_ (CompletionTextView* self, GtkWidget* w) {
	GtkListBox* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = self->priv->completion_list;
	_tmp1_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), _tmp1_);
}


static void ___lambda41__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda41_ ((CompletionTextView*) self, widget);
}


static void completion_text_view_show_completion_window (CompletionTextView* self) {
	gboolean _tmp0_ = FALSE;
	gint x = 0;
	gint y = 0;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp1_ = {0};
	GdkWindow* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkAllocation _tmp6_ = {0};
	gint _tmp7_ = 0;
	GtkWindow* _tmp8_ = NULL;
	GtkWindow* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkWindow* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GtkWindow* _tmp14_ = NULL;
	GtkAllocation _tmp15_ = {0};
	gint _tmp16_ = 0;
	GtkListBox* _tmp17_ = NULL;
	GtkWindow* _tmp18_ = NULL;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	_tmp0_ = gtk_widget_get_mapped (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (!_tmp0_) {
		return;
	}
	g_debug ("CompletionTextView.vala:226: show_completion_window");
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp1_);
	alloc = _tmp1_;
	_tmp2_ = gtk_text_view_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), GTK_TEXT_WINDOW_WIDGET);
	gdk_window_get_origin (_tmp2_, &_tmp3_, &_tmp4_);
	x = _tmp3_;
	y = _tmp4_;
	_tmp5_ = y;
	_tmp6_ = alloc;
	_tmp7_ = _tmp6_.height;
	y = _tmp5_ + _tmp7_;
	_tmp8_ = self->priv->completion_window;
	gtk_window_set_attached_to (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp9_ = self->priv->completion_window;
	_tmp10_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_window_set_transient_for (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_window_get_type (), GtkWindow));
	_tmp11_ = self->priv->completion_window;
	_tmp12_ = x;
	_tmp13_ = y;
	gtk_window_move (_tmp11_, _tmp12_ - 1, _tmp13_);
	_tmp14_ = self->priv->completion_window;
	_tmp15_ = alloc;
	_tmp16_ = _tmp15_.width;
	gtk_window_resize (_tmp14_, _tmp16_ + 2, 50);
	_tmp17_ = self->priv->completion_list;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_container_get_type (), GtkContainer), ___lambda41__gtk_callback, self);
	_tmp18_ = self->priv->completion_window;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
}


static void completion_text_view_hide_completion_window (CompletionTextView* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	_tmp0_ = self->priv->completion_window;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_g_free0 (self->priv->current_word);
	self->priv->current_word = NULL;
}


static gboolean completion_text_view_completion_window_focus_out_cb (CompletionTextView* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), FALSE);
	completion_text_view_hide_completion_window (self);
	result = FALSE;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void _vala_CbUserInfo_array_free (CbUserInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			cb_user_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void completion_text_view_update_completion (CompletionTextView* self) {
	gchar* cur_word = NULL;
	gchar* _tmp0_ = NULL;
	gint n_chars = 0;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar end_char = '\0';
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar _tmp6_ = '\0';
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gchar _tmp10_ = '\0';
	gboolean _tmp11_ = FALSE;
	gboolean word_has_alpha_end = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	_tmp0_ = completion_text_view_get_cursor_word (self, NULL, NULL);
	cur_word = _tmp0_;
	_tmp1_ = cur_word;
	_tmp2_ = g_utf8_strlen (_tmp1_, (gssize) -1);
	n_chars = _tmp2_;
	_tmp3_ = n_chars;
	if (_tmp3_ == 0) {
		_g_free0 (cur_word);
		return;
	}
	_tmp4_ = cur_word;
	_tmp5_ = n_chars;
	_tmp6_ = string_get (_tmp4_, (glong) (_tmp5_ - 1));
	end_char = _tmp6_;
	_tmp10_ = end_char;
	_tmp11_ = g_ascii_isalpha (_tmp10_);
	if (_tmp11_) {
		_tmp9_ = TRUE;
	} else {
		gchar _tmp12_ = '\0';
		gboolean _tmp13_ = FALSE;
		_tmp12_ = end_char;
		_tmp13_ = g_ascii_isdigit (_tmp12_);
		_tmp9_ = _tmp13_;
	}
	if (_tmp9_) {
		gchar _tmp14_ = '\0';
		gboolean _tmp15_ = FALSE;
		_tmp14_ = end_char;
		_tmp15_ = g_ascii_isgraph (_tmp14_);
		_tmp8_ = _tmp15_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		gchar _tmp16_ = '\0';
		_tmp16_ = end_char;
		_tmp7_ = _tmp16_ == '@';
	}
	word_has_alpha_end = _tmp7_;
	_tmp19_ = cur_word;
	_tmp20_ = g_str_has_prefix (_tmp19_, "@");
	if (!_tmp20_) {
		_tmp18_ = TRUE;
	} else {
		gboolean _tmp21_ = FALSE;
		_tmp21_ = word_has_alpha_end;
		_tmp18_ = !_tmp21_;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		GtkTextBuffer* _tmp22_ = NULL;
		GtkTextBuffer* _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		_tmp22_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
		_tmp23_ = _tmp22_;
		_tmp24_ = gtk_text_buffer_get_has_selection (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp17_ = _tmp25_;
	}
	if (_tmp17_) {
		completion_text_view_hide_completion_window (self);
		_g_free0 (cur_word);
		return;
	}
	_tmp26_ = cur_word;
	_tmp27_ = string_substring (_tmp26_, (glong) 1, (glong) -1);
	_g_free0 (cur_word);
	cur_word = _tmp27_;
	_tmp28_ = cur_word;
	_tmp29_ = self->priv->current_word;
	if (g_strcmp0 (_tmp28_, _tmp29_) != 0) {
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		CbUserInfo* corpus = NULL;
		gint corpus_length1 = 0;
		gint _corpus_size_ = 0;
		Account* _tmp32_ = NULL;
		CbUserCounter* _tmp33_ = NULL;
		Account* _tmp34_ = NULL;
		SqlDatabase* _tmp35_ = NULL;
		sqlite3* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		CbUserInfo* _tmp38_ = NULL;
		gint _tmp39_ = 0;
		CbUserInfo* _tmp55_ = NULL;
		gint _tmp55__length1 = 0;
		GtkListBox* _tmp59_ = NULL;
		completion_text_view_show_completion_window (self);
		_tmp30_ = cur_word;
		_tmp31_ = g_strdup (_tmp30_);
		_g_free0 (self->priv->current_word);
		self->priv->current_word = _tmp31_;
		_tmp32_ = self->priv->account;
		_tmp33_ = _tmp32_->user_counter;
		_tmp34_ = self->priv->account;
		_tmp35_ = _tmp34_->db;
		_tmp36_ = sql_database_get_sqlite_db (_tmp35_);
		_tmp37_ = cur_word;
		cb_user_counter_query_by_prefix (_tmp33_, _tmp36_, _tmp37_, 10, &_tmp38_, &_tmp39_);
		corpus = (_vala_CbUserInfo_array_free (corpus, corpus_length1), NULL);
		corpus = _tmp38_;
		corpus_length1 = _tmp39_;
		_corpus_size_ = corpus_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp40_ = FALSE;
				_tmp40_ = TRUE;
				while (TRUE) {
					gint _tmp42_ = 0;
					CbUserInfo* _tmp43_ = NULL;
					gint _tmp43__length1 = 0;
					GtkLabel* l = NULL;
					CbUserInfo* _tmp44_ = NULL;
					gint _tmp44__length1 = 0;
					gint _tmp45_ = 0;
					CbUserInfo _tmp46_ = {0};
					const gchar* _tmp47_ = NULL;
					gchar* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					GtkLabel* _tmp50_ = NULL;
					GtkLabel* _tmp51_ = NULL;
					GtkLabel* _tmp52_ = NULL;
					GtkListBox* _tmp53_ = NULL;
					GtkLabel* _tmp54_ = NULL;
					if (!_tmp40_) {
						gint _tmp41_ = 0;
						_tmp41_ = i;
						i = _tmp41_ + 1;
					}
					_tmp40_ = FALSE;
					_tmp42_ = i;
					_tmp43_ = corpus;
					_tmp43__length1 = corpus_length1;
					if (!(_tmp42_ < _tmp43__length1)) {
						break;
					}
					_tmp44_ = corpus;
					_tmp44__length1 = corpus_length1;
					_tmp45_ = i;
					_tmp46_ = _tmp44_[_tmp45_];
					_tmp47_ = _tmp46_.screen_name;
					_tmp48_ = g_strconcat ("@", _tmp47_, NULL);
					_tmp49_ = _tmp48_;
					_tmp50_ = (GtkLabel*) gtk_label_new (_tmp49_);
					g_object_ref_sink (_tmp50_);
					_tmp51_ = _tmp50_;
					_g_free0 (_tmp49_);
					l = _tmp51_;
					_tmp52_ = l;
					gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_START);
					_tmp53_ = self->priv->completion_list;
					_tmp54_ = l;
					gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, gtk_widget_get_type (), GtkWidget));
					_g_object_unref0 (l);
				}
			}
		}
		_tmp55_ = corpus;
		_tmp55__length1 = corpus_length1;
		if (_tmp55__length1 > 0) {
			GtkListBox* _tmp56_ = NULL;
			GtkListBox* _tmp57_ = NULL;
			GtkListBoxRow* _tmp58_ = NULL;
			_tmp56_ = self->priv->completion_list;
			_tmp57_ = self->priv->completion_list;
			_tmp58_ = gtk_list_box_get_row_at_index (_tmp57_, 0);
			gtk_list_box_select_row (_tmp56_, _tmp58_);
			self->priv->current_match = 0;
		}
		_tmp59_ = self->priv->completion_list;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_widget_get_type (), GtkWidget));
		corpus = (_vala_CbUserInfo_array_free (corpus, corpus_length1), NULL);
	}
	_g_free0 (cur_word);
}


static gchar* completion_text_view_get_cursor_word (CompletionTextView* self, GtkTextIter* start_iter, GtkTextIter* end_iter) {
	GtkTextIter _vala_start_iter = {0};
	GtkTextIter _vala_end_iter = {0};
	gchar* result = NULL;
	GtkTextMark* cursor_mark = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextMark* _tmp3_ = NULL;
	GtkTextIter cursor_iter = {0};
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextMark* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter test_iter = {0};
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp31_ = {0};
	GtkTextIter _tmp32_ = {0};
	GtkTextIter _tmp33_ = {0};
	GtkTextIter _tmp34_ = {0};
	GtkTextBuffer* _tmp35_ = NULL;
	GtkTextBuffer* _tmp36_ = NULL;
	GtkTextIter _tmp37_ = {0};
	GtkTextIter _tmp38_ = {0};
	gchar* _tmp39_ = NULL;
	g_return_val_if_fail (IS_COMPLETION_TEXT_VIEW (self), NULL);
	_tmp0_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	cursor_mark = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp5_ = _tmp4_;
	_tmp6_ = cursor_mark;
	gtk_text_buffer_get_iter_at_mark (_tmp5_, &_tmp7_, _tmp6_);
	cursor_iter = _tmp7_;
	memset (&test_iter, 0, sizeof (GtkTextIter));
	_tmp8_ = cursor_iter;
	gtk_text_iter_assign (&test_iter, &_tmp8_);
	{
		gboolean _tmp9_ = FALSE;
		_tmp9_ = TRUE;
		while (TRUE) {
			GtkTextIter left_iter = {0};
			GtkTextIter _tmp10_ = {0};
			GtkTextIter _tmp11_ = {0};
			gchar* s = NULL;
			GtkTextBuffer* _tmp12_ = NULL;
			GtkTextBuffer* _tmp13_ = NULL;
			GtkTextIter _tmp14_ = {0};
			GtkTextIter _tmp15_ = {0};
			gchar* _tmp16_ = NULL;
			gunichar c = 0U;
			const gchar* _tmp17_ = NULL;
			gunichar _tmp18_ = 0U;
			gboolean _tmp19_ = FALSE;
			const gchar* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp26_ = FALSE;
			gunichar _tmp27_ = 0U;
			gboolean _tmp28_ = FALSE;
			GtkTextIter _tmp30_ = {0};
			if (!_tmp9_) {
			}
			_tmp9_ = FALSE;
			_tmp10_ = test_iter;
			left_iter = _tmp10_;
			_tmp11_ = test_iter;
			gtk_text_iter_assign (&left_iter, &_tmp11_);
			gtk_text_iter_backward_char (&left_iter);
			_tmp12_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
			_tmp13_ = _tmp12_;
			_tmp14_ = left_iter;
			_tmp15_ = test_iter;
			_tmp16_ = gtk_text_buffer_get_text (_tmp13_, &_tmp14_, &_tmp15_, FALSE);
			s = _tmp16_;
			_tmp17_ = s;
			_tmp18_ = string_get_char (_tmp17_, (glong) 0);
			c = _tmp18_;
			_tmp20_ = s;
			_tmp21_ = g_utf8_strlen (_tmp20_, (gssize) -1);
			if (_tmp21_ == 1) {
				_tmp19_ = TRUE;
			} else {
				const gchar* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				_tmp22_ = s;
				_tmp23_ = g_utf8_strlen (_tmp22_, (gssize) -1);
				_tmp19_ = _tmp23_ == 0;
			}
			_vala_assert (_tmp19_, "s.char_count () == 1 ||               s.char_count () == 0");
			_tmp24_ = gtk_text_iter_is_start (&left_iter);
			if (_tmp24_) {
				GtkTextIter _tmp25_ = {0};
				_tmp25_ = left_iter;
				gtk_text_iter_assign (&test_iter, &_tmp25_);
			}
			_tmp27_ = c;
			_tmp28_ = g_unichar_isspace (_tmp27_);
			if (_tmp28_) {
				_tmp26_ = TRUE;
			} else {
				gboolean _tmp29_ = FALSE;
				_tmp29_ = gtk_text_iter_is_start (&left_iter);
				_tmp26_ = _tmp29_;
			}
			if (_tmp26_) {
				_g_free0 (s);
				break;
			}
			_tmp30_ = left_iter;
			gtk_text_iter_assign (&test_iter, &_tmp30_);
			_g_free0 (s);
		}
	}
	_tmp31_ = test_iter;
	_vala_start_iter = _tmp31_;
	_tmp32_ = test_iter;
	gtk_text_iter_assign (&_vala_start_iter, &_tmp32_);
	_tmp33_ = cursor_iter;
	_vala_end_iter = _tmp33_;
	_tmp34_ = cursor_iter;
	gtk_text_iter_assign (&_vala_end_iter, &_tmp34_);
	_tmp35_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp36_ = _tmp35_;
	_tmp37_ = test_iter;
	_tmp38_ = cursor_iter;
	_tmp39_ = gtk_text_buffer_get_text (_tmp36_, &_tmp37_, &_tmp38_, FALSE);
	result = _tmp39_;
	_g_object_unref0 (cursor_mark);
	if (start_iter) {
		*start_iter = _vala_start_iter;
	}
	if (end_iter) {
		*end_iter = _vala_end_iter;
	}
	return result;
}


static void completion_text_view_insert_completion (CompletionTextView* self, const gchar* compl) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextIter start_word_iter = {0};
	GtkTextIter end_word_iter = {0};
	gchar* word_to_delete = NULL;
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	gchar* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextBuffer* _tmp6_ = NULL;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter _tmp8_ = {0};
	GtkTextMark* cursor_mark = NULL;
	GtkTextBuffer* _tmp9_ = NULL;
	GtkTextBuffer* _tmp10_ = NULL;
	GtkTextMark* _tmp11_ = NULL;
	GtkTextMark* _tmp12_ = NULL;
	GtkTextBuffer* _tmp13_ = NULL;
	GtkTextBuffer* _tmp14_ = NULL;
	GtkTextIter _tmp15_ = {0};
	GtkTextBuffer* _tmp16_ = NULL;
	GtkTextBuffer* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GtkTextBuffer* _tmp26_ = NULL;
	GtkTextBuffer* _tmp27_ = NULL;
	g_return_if_fail (IS_COMPLETION_TEXT_VIEW (self));
	g_return_if_fail (compl != NULL);
	_tmp0_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp1_ = _tmp0_;
	g_object_freeze_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject));
	_tmp4_ = completion_text_view_get_cursor_word (self, &_tmp2_, &_tmp3_);
	start_word_iter = _tmp2_;
	end_word_iter = _tmp3_;
	word_to_delete = _tmp4_;
	g_debug ("CompletionTextView.vala:344: Delete word: %s", word_to_delete);
	_tmp5_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp6_ = _tmp5_;
	_tmp7_ = start_word_iter;
	_tmp8_ = end_word_iter;
	g_signal_emit_by_name (_tmp6_, "delete-range", &_tmp7_, &_tmp8_);
	_tmp9_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp10_ = _tmp9_;
	_tmp11_ = gtk_text_buffer_get_insert (_tmp10_);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	cursor_mark = _tmp12_;
	_tmp13_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp14_ = _tmp13_;
	gtk_text_buffer_get_iter_at_mark (_tmp14_, &_tmp15_, cursor_mark);
	start_word_iter = _tmp15_;
	_tmp16_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp17_ = _tmp16_;
	_tmp18_ = compl;
	_tmp19_ = g_strconcat ("@", _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_strconcat (_tmp20_, " ", NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = compl;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	g_signal_emit_by_name (_tmp17_, "insert-text", &start_word_iter, _tmp22_, _tmp25_ + 2);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	_tmp26_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp27_ = _tmp26_;
	g_object_thaw_notify (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, G_TYPE_OBJECT, GObject));
	_g_object_unref0 (cursor_mark);
	_g_free0 (word_to_delete);
}


CompletionTextView* completion_text_view_construct (GType object_type) {
	CompletionTextView * self = NULL;
	self = (CompletionTextView*) g_object_new (object_type, NULL);
	return self;
}


CompletionTextView* completion_text_view_new (void) {
	return completion_text_view_construct (TYPE_COMPLETION_TEXT_VIEW);
}


static gboolean _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = completion_text_view_completion_window_focus_out_cb ((CompletionTextView*) self);
	return result;
}


static void _completion_text_view_update_completion_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	completion_text_view_update_completion ((CompletionTextView*) self);
}


static void _completion_text_view_buffer_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	completion_text_view_buffer_changed_cb ((CompletionTextView*) self);
}


static gboolean _completion_text_view_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = completion_text_view_key_press_event_cb ((CompletionTextView*) self, event);
	return result;
}


static GObject * completion_text_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	CompletionTextView * self;
	GtkWindow* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkWindow* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	GdkScreen* _tmp4_ = NULL;
	GtkListBox* _tmp5_ = NULL;
	GtkLabel* placeholder_label = NULL;
	const gchar* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkStyleContext* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkListBox* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkScrolledWindow* scroller = NULL;
	GtkScrolledWindow* _tmp13_ = NULL;
	GtkScrolledWindow* _tmp14_ = NULL;
	GtkListBox* _tmp15_ = NULL;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp16_ = NULL;
	GtkFrame* _tmp17_ = NULL;
	GtkScrolledWindow* _tmp18_ = NULL;
	GtkWindow* _tmp19_ = NULL;
	GtkFrame* _tmp20_ = NULL;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp21_ = NULL;
	GtkStyleContext* _tmp22_ = NULL;
	GtkStyleContext* _tmp23_ = NULL;
	GtkStyleContext* _tmp24_ = NULL;
	GdkRGBA link_color = {0};
	GtkStyleContext* _tmp25_ = NULL;
	GtkStyleContext* _tmp26_ = NULL;
	GtkStateFlags _tmp27_ = 0;
	GdkRGBA _tmp28_ = {0};
	GtkStyleContext* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	GdkRGBA _tmp33_ = {0};
	gdouble _tmp34_ = 0.0;
	GdkRGBA snippet_color = {0};
	GdkRGBA _tmp42_ = {0};
	GtkTextBuffer* _tmp43_ = NULL;
	GtkTextBuffer* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	GdkRGBA _tmp46_ = {0};
	GtkTextBuffer* _tmp47_ = NULL;
	GtkTextBuffer* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	GdkRGBA _tmp50_ = {0};
	GtkTextBuffer* _tmp51_ = NULL;
	GtkTextBuffer* _tmp52_ = NULL;
	const gchar* _tmp53_ = NULL;
	GdkRGBA _tmp54_ = {0};
	GtkTextBuffer* _tmp55_ = NULL;
	GtkTextBuffer* _tmp56_ = NULL;
	const gchar* _tmp57_ = NULL;
	GdkRGBA _tmp58_ = {0};
	GtkTextBuffer* _tmp59_ = NULL;
	GtkTextBuffer* _tmp60_ = NULL;
	GtkTextBuffer* _tmp61_ = NULL;
	GtkTextBuffer* _tmp62_ = NULL;
	GtkTextBuffer* _tmp63_ = NULL;
	GtkTextBuffer* _tmp64_ = NULL;
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp65_ = NULL;
	GspellTextView* _tmp66_ = NULL;
	GspellTextView* _tmp67_ = NULL;
	GspellTextBuffer* gspell_buffer = NULL;
	GtkTextBuffer* _tmp68_ = NULL;
	GtkTextBuffer* _tmp69_ = NULL;
	GspellTextBuffer* _tmp70_ = NULL;
	GspellTextBuffer* _tmp71_ = NULL;
	GspellChecker* checker = NULL;
	GspellLanguage* _tmp72_ = NULL;
	GspellChecker* _tmp73_ = NULL;
	GspellTextBuffer* _tmp74_ = NULL;
	GspellChecker* _tmp75_ = NULL;
	parent_class = G_OBJECT_CLASS (completion_text_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_TEXT_VIEW, CompletionTextView);
	_tmp0_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_POPUP);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->completion_window);
	self->priv->completion_window = _tmp0_;
	_tmp1_ = self->priv->completion_window;
	gtk_window_set_type_hint (_tmp1_, GDK_WINDOW_TYPE_HINT_COMBO);
	_tmp2_ = self->priv->completion_window;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event, self, 0);
	_tmp3_ = self->priv->completion_window;
	_tmp4_ = gtk_widget_get_screen (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_window_set_screen (_tmp3_, _tmp4_);
	_tmp5_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->completion_list);
	self->priv->completion_list = _tmp5_;
	_tmp6_ = _ ("No users found");
	_tmp7_ = (GtkLabel*) gtk_label_new (_tmp6_);
	g_object_ref_sink (_tmp7_);
	placeholder_label = _tmp7_;
	_tmp8_ = placeholder_label;
	_tmp9_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp9_, "dim-label");
	_tmp10_ = placeholder_label;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
	_tmp11_ = self->priv->completion_list;
	_tmp12_ = placeholder_label;
	gtk_list_box_set_placeholder (_tmp11_, G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
	_tmp13_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp13_);
	scroller = _tmp13_;
	_tmp14_ = scroller;
	_tmp15_ = self->priv->completion_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
	_tmp16_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp16_);
	frame = _tmp16_;
	_tmp17_ = frame;
	_tmp18_ = scroller;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
	_tmp19_ = self->priv->completion_window;
	_tmp20_ = frame;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) _completion_text_view_completion_window_focus_out_cb_gtk_widget_focus_out_event, self, 0);
	_tmp21_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp22_ = _g_object_ref0 (_tmp21_);
	style_context = _tmp22_;
	_tmp23_ = style_context;
	gtk_style_context_save (_tmp23_);
	_tmp24_ = style_context;
	gtk_style_context_set_state (_tmp24_, GTK_STATE_FLAG_LINK);
	_tmp25_ = style_context;
	_tmp26_ = style_context;
	_tmp27_ = gtk_style_context_get_state (_tmp26_);
	gtk_style_context_get_color (_tmp25_, _tmp27_, &_tmp28_);
	link_color = _tmp28_;
	_tmp29_ = style_context;
	gtk_style_context_restore (_tmp29_);
	_tmp33_ = link_color;
	_tmp34_ = _tmp33_.red;
	if (_tmp34_ == 1.0) {
		GdkRGBA _tmp35_ = {0};
		gdouble _tmp36_ = 0.0;
		_tmp35_ = link_color;
		_tmp36_ = _tmp35_.green;
		_tmp32_ = _tmp36_ == 1.0;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		GdkRGBA _tmp37_ = {0};
		gdouble _tmp38_ = 0.0;
		_tmp37_ = link_color;
		_tmp38_ = _tmp37_.blue;
		_tmp31_ = _tmp38_ == 1.0;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		GdkRGBA _tmp39_ = {0};
		gdouble _tmp40_ = 0.0;
		_tmp39_ = link_color;
		_tmp40_ = _tmp39_.alpha;
		_tmp30_ = _tmp40_ == 1.0;
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		GdkRGBA _tmp41_ = {0};
		_tmp41_.red = 0.16470;
		_tmp41_.green = 0.462735;
		_tmp41_.blue = 0.77647;
		_tmp41_.alpha = 1.0;
		link_color = _tmp41_;
	}
	_tmp42_.red = 0.0;
	_tmp42_.green = 0.65;
	_tmp42_.blue = 0.0627;
	_tmp42_.alpha = 1.0;
	snippet_color = _tmp42_;
	_tmp43_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp44_ = _tmp43_;
	_tmp45_ = COMPLETION_TEXT_VIEW_TEXT_TAGS[0];
	_tmp46_ = link_color;
	gtk_text_buffer_create_tag (_tmp44_, _tmp45_, "foreground_rgba", &_tmp46_, NULL, NULL);
	_tmp47_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp48_ = _tmp47_;
	_tmp49_ = COMPLETION_TEXT_VIEW_TEXT_TAGS[1];
	_tmp50_ = link_color;
	gtk_text_buffer_create_tag (_tmp48_, _tmp49_, "foreground_rgba", &_tmp50_, NULL, NULL);
	_tmp51_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp52_ = _tmp51_;
	_tmp53_ = COMPLETION_TEXT_VIEW_TEXT_TAGS[2];
	_tmp54_ = link_color;
	gtk_text_buffer_create_tag (_tmp52_, _tmp53_, "foreground_rgba", &_tmp54_, NULL, NULL);
	_tmp55_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp56_ = _tmp55_;
	_tmp57_ = COMPLETION_TEXT_VIEW_TEXT_TAGS[3];
	_tmp58_ = snippet_color;
	gtk_text_buffer_create_tag (_tmp56_, _tmp57_, "foreground_rgba", &_tmp58_, NULL, NULL);
	_tmp59_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp60_ = _tmp59_;
	gtk_text_buffer_create_tag (_tmp60_, TWEET_UTILS_NO_SPELL_CHECK, NULL, NULL);
	_tmp61_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp62_ = _tmp61_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, G_TYPE_OBJECT, GObject), "notify::cursor-position", (GCallback) _completion_text_view_update_completion_g_object_notify, self, 0);
	_tmp63_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp64_ = _tmp63_;
	g_signal_connect_object (_tmp64_, "changed", (GCallback) _completion_text_view_buffer_changed_cb_gtk_text_buffer_changed, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "key-press-event", (GCallback) _completion_text_view_key_press_event_cb_gtk_widget_key_press_event, self, 0);
	gtk_text_view_set_right_margin (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), 6);
	gtk_text_view_set_left_margin (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), 6);
	gtk_text_view_set_top_margin (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), 6);
	gtk_text_view_set_bottom_margin (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView), 6);
	_tmp65_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp66_ = _g_object_ref0 (_tmp65_);
	gspell_view = _tmp66_;
	_tmp67_ = gspell_view;
	gspell_text_view_set_inline_spell_checking (_tmp67_, TRUE);
	_tmp68_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_text_view_get_type (), GtkTextView));
	_tmp69_ = _tmp68_;
	_tmp70_ = gspell_text_buffer_get_from_gtk_text_buffer (_tmp69_);
	_tmp71_ = _g_object_ref0 (_tmp70_);
	gspell_buffer = _tmp71_;
	_tmp72_ = gspell_language_get_default ();
	_tmp73_ = gspell_checker_new (_tmp72_);
	checker = _tmp73_;
	_tmp74_ = gspell_buffer;
	_tmp75_ = checker;
	gspell_text_buffer_set_spell_checker (_tmp74_, _tmp75_);
	_g_object_unref0 (checker);
	_g_object_unref0 (gspell_buffer);
	_g_object_unref0 (gspell_view);
	_g_object_unref0 (style_context);
	_g_object_unref0 (frame);
	_g_object_unref0 (scroller);
	_g_object_unref0 (placeholder_label);
	return obj;
}


static void completion_text_view_class_init (CompletionTextViewClass * klass) {
	completion_text_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CompletionTextViewPrivate));
	G_OBJECT_CLASS (klass)->constructor = completion_text_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = completion_text_view_finalize;
}


static void completion_text_view_instance_init (CompletionTextView * self) {
	self->priv = COMPLETION_TEXT_VIEW_GET_PRIVATE (self);
	self->priv->current_match = 0;
	self->priv->current_word = NULL;
}


static void completion_text_view_finalize (GObject* obj) {
	CompletionTextView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_TEXT_VIEW, CompletionTextView);
	_g_object_unref0 (self->priv->completion_list);
	_g_object_unref0 (self->priv->completion_window);
	_g_free0 (self->priv->current_word);
	G_OBJECT_CLASS (completion_text_view_parent_class)->finalize (obj);
}


GType completion_text_view_get_type (void) {
	static volatile gsize completion_text_view_type_id__volatile = 0;
	if (g_once_init_enter (&completion_text_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CompletionTextViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_text_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionTextView), 0, (GInstanceInitFunc) completion_text_view_instance_init, NULL };
		GType completion_text_view_type_id;
		completion_text_view_type_id = g_type_register_static (gtk_text_view_get_type (), "CompletionTextView", &g_define_type_info, 0);
		g_once_init_leave (&completion_text_view_type_id__volatile, completion_text_view_type_id);
	}
	return completion_text_view_type_id__volatile;
}



