/* StartConversationEntry.c generated by valac 0.36.4, the Vala compiler
 * generated from StartConversationEntry.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include "rest/rest-proxy-call.h"
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "rest/rest-proxy.h"
#include <gio/gio.h>
#include <json-glib/json-glib.h>
#include <pango/pango.h>


#define TYPE_START_CONVERSATION_ENTRY (start_conversation_entry_get_type ())
#define START_CONVERSATION_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_START_CONVERSATION_ENTRY, StartConversationEntry))
#define START_CONVERSATION_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_START_CONVERSATION_ENTRY, StartConversationEntryClass))
#define IS_START_CONVERSATION_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_START_CONVERSATION_ENTRY))
#define IS_START_CONVERSATION_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_START_CONVERSATION_ENTRY))
#define START_CONVERSATION_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_START_CONVERSATION_ENTRY, StartConversationEntryClass))

typedef struct _StartConversationEntry StartConversationEntry;
typedef struct _StartConversationEntryClass StartConversationEntryClass;
typedef struct _StartConversationEntryPrivate StartConversationEntryPrivate;

#define TYPE_REPLY_ENTRY (reply_entry_get_type ())
#define REPLY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REPLY_ENTRY, ReplyEntry))
#define REPLY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REPLY_ENTRY, ReplyEntryClass))
#define IS_REPLY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REPLY_ENTRY))
#define IS_REPLY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REPLY_ENTRY))
#define REPLY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REPLY_ENTRY, ReplyEntryClass))

typedef struct _ReplyEntry ReplyEntry;
typedef struct _ReplyEntryClass ReplyEntryClass;

#define TYPE_USER_COMPLETION (user_completion_get_type ())
#define USER_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_COMPLETION, UserCompletion))
#define USER_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_COMPLETION, UserCompletionClass))
#define IS_USER_COMPLETION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_COMPLETION))
#define IS_USER_COMPLETION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_COMPLETION))
#define USER_COMPLETION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_COMPLETION, UserCompletionClass))

typedef struct _UserCompletion UserCompletion;
typedef struct _UserCompletionClass UserCompletionClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_COMPLETION_LIST_ENTRY (completion_list_entry_get_type ())
#define COMPLETION_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_LIST_ENTRY, CompletionListEntry))
#define COMPLETION_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_LIST_ENTRY, CompletionListEntryClass))
#define IS_COMPLETION_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_LIST_ENTRY))
#define IS_COMPLETION_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_LIST_ENTRY))
#define COMPLETION_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_LIST_ENTRY, CompletionListEntryClass))

typedef struct _CompletionListEntry CompletionListEntry;
typedef struct _CompletionListEntryClass CompletionListEntryClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block64Data Block64Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
typedef struct _Block65Data Block65Data;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	START_CONVERSATION_ENTRY_START_SIGNAL,
	START_CONVERSATION_ENTRY_LAST_SIGNAL
};
static guint start_conversation_entry_signals[START_CONVERSATION_ENTRY_LAST_SIGNAL] = {0};
typedef struct _CompletionListEntryPrivate CompletionListEntryPrivate;

struct _StartConversationEntry {
	GtkListBoxRow parent_instance;
	StartConversationEntryPrivate * priv;
};

struct _StartConversationEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _StartConversationEntryPrivate {
	GtkRevealer* revealer;
	ReplyEntry* name_entry;
	GtkStack* go_stack;
	GtkSpinner* go_spinner;
	UserCompletion* user_completion;
	GtkWindow* completion_window;
	GtkListBox* completion_list;
	gint current_match;
	Account* account;
};

struct _Block64Data {
	int _ref_count_;
	StartConversationEntry* self;
	gchar* screen_name;
	RestProxyCall* call;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block65Data {
	int _ref_count_;
	Block64Data * _data64_;
	JsonObject* root;
	gint64 user_id;
};

struct _CompletionListEntry {
	GtkListBoxRow parent_instance;
	CompletionListEntryPrivate * priv;
};

struct _CompletionListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _CompletionListEntryPrivate {
	GtkLabel* name_label;
	GtkLabel* screen_name_label;
};


static gpointer start_conversation_entry_parent_class = NULL;
static gpointer completion_list_entry_parent_class = NULL;

GType start_conversation_entry_get_type (void) G_GNUC_CONST;
GType reply_entry_get_type (void) G_GNUC_CONST;
GType user_completion_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define START_CONVERSATION_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_START_CONVERSATION_ENTRY, StartConversationEntryPrivate))
enum  {
	START_CONVERSATION_ENTRY_DUMMY_PROPERTY
};
#define START_CONVERSATION_ENTRY_MAX_RESULTS 7
StartConversationEntry* start_conversation_entry_new (Account* account);
StartConversationEntry* start_conversation_entry_construct (GType object_type, Account* account);
static gboolean __lambda90_ (StartConversationEntry* self);
static gboolean ___lambda90__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean __lambda91_ (StartConversationEntry* self);
static gboolean ___lambda91__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void start_conversation_entry_go_button_clicked_cb (StartConversationEntry* self);
static void _start_conversation_entry_go_button_clicked_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
UserCompletion* user_completion_new (Account* account, gint num_results);
UserCompletion* user_completion_construct (GType object_type, Account* account, gint num_results);
void user_completion_connect_to (UserCompletion* self, GObject* obj, const gchar* name_property_name);
static void __lambda94_ (StartConversationEntry* self);
static void start_conversation_entry_position_popup_window (StartConversationEntry* self);
static void __lambda95_ (StartConversationEntry* self, GtkWidget* w);
static void ___lambda95__gtk_callback (GtkWidget* widget, gpointer self);
static void ___lambda94__user_completion_start_completion (UserCompletion* _sender, gpointer self);
static void __lambda96_ (StartConversationEntry* self, const gchar* screen_name, const gchar* name);
GType completion_list_entry_get_type (void) G_GNUC_CONST;
CompletionListEntry* completion_list_entry_new (const gchar* screen_name, const gchar* name);
CompletionListEntry* completion_list_entry_construct (GType object_type, const gchar* screen_name, const gchar* name);
static void ___lambda96__user_completion_populate_completion (UserCompletion* _sender, const gchar* screen_name, const gchar* name, gpointer self);
static gboolean start_conversation_entry_name_entry_key_pressed (StartConversationEntry* self, GdkEventKey* evt);
static gboolean _start_conversation_entry_name_entry_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
void start_conversation_entry_reveal (StartConversationEntry* self);
void start_conversation_entry_unreveal (StartConversationEntry* self);
static Block64Data* block64_data_ref (Block64Data* _data64_);
static void block64_data_unref (void * _userdata_);
gchar* completion_list_entry_get_screen_name (CompletionListEntry* self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void __lambda92_ (Block64Data* _data64_, GObject* obj, GAsyncResult* res);
static Block65Data* block65_data_ref (Block65Data* _data65_);
static void block65_data_unref (void * _userdata_);
void user_utils_load_friendship (Account* account, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint user_utils_load_friendship_finish (GAsyncResult* _res_);
static void __lambda93_ (Block65Data* _data65_, GObject* obj, GAsyncResult* res);
#define FRIENDSHIP_CAN_DM ((guint) (1 << 4))
static void ___lambda93__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda92__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _start_conversation_entry_go_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void g_cclosure_user_marshal_VOID__INT64_STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * start_conversation_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _start_conversation_entry___lambda97_ (StartConversationEntry* self);
static void __start_conversation_entry___lambda97__reply_entry_cancelled (ReplyEntry* _sender, gpointer self);
static void start_conversation_entry_finalize (GObject * obj);
#define COMPLETION_LIST_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPLETION_LIST_ENTRY, CompletionListEntryPrivate))
enum  {
	COMPLETION_LIST_ENTRY_DUMMY_PROPERTY
};
static void completion_list_entry_finalize (GObject * obj);


static gboolean __lambda90_ (StartConversationEntry* self) {
	gboolean result = FALSE;
	GtkWindow* _tmp0_;
	_tmp0_ = self->priv->completion_window;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	result = FALSE;
	return result;
}


static gboolean ___lambda90__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda90_ ((StartConversationEntry*) self);
	return result;
}


static gboolean __lambda91_ (StartConversationEntry* self) {
	gboolean result = FALSE;
	GtkWindow* _tmp0_;
	_tmp0_ = self->priv->completion_window;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	result = FALSE;
	return result;
}


static gboolean ___lambda91__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda91_ ((StartConversationEntry*) self);
	return result;
}


static void _start_conversation_entry_go_button_clicked_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	start_conversation_entry_go_button_clicked_cb ((StartConversationEntry*) self);
}


static void __lambda95_ (StartConversationEntry* self, GtkWidget* w) {
	GtkListBox* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = self->priv->completion_list;
	_tmp1_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), _tmp1_);
}


static void ___lambda95__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda95_ ((StartConversationEntry*) self, widget);
}


static void __lambda94_ (StartConversationEntry* self) {
	GtkWindow* _tmp0_;
	ReplyEntry* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWindow* _tmp4_;
	GtkListBox* _tmp5_;
	_tmp0_ = self->priv->completion_window;
	_tmp1_ = self->priv->name_entry;
	gtk_window_set_attached_to (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = self->priv->completion_window;
	_tmp3_ = gtk_widget_get_toplevel (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_window_set_transient_for (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow));
	start_conversation_entry_position_popup_window (self);
	_tmp4_ = self->priv->completion_window;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = self->priv->completion_list;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), ___lambda95__gtk_callback, self);
}


static void ___lambda94__user_completion_start_completion (UserCompletion* _sender, gpointer self) {
	__lambda94_ ((StartConversationEntry*) self);
}


static void __lambda96_ (StartConversationEntry* self, const gchar* screen_name, const gchar* name) {
	CompletionListEntry* l = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	CompletionListEntry* _tmp2_;
	GtkListBox* _tmp3_;
	g_return_if_fail (screen_name != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = screen_name;
	_tmp1_ = name;
	_tmp2_ = completion_list_entry_new (_tmp0_, _tmp1_);
	g_object_ref_sink (_tmp2_);
	l = _tmp2_;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (l, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = self->priv->completion_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (l, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (l);
}


static void ___lambda96__user_completion_populate_completion (UserCompletion* _sender, const gchar* screen_name, const gchar* name, gpointer self) {
	__lambda96_ ((StartConversationEntry*) self, screen_name, name);
}


static gboolean _start_conversation_entry_name_entry_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = start_conversation_entry_name_entry_key_pressed ((StartConversationEntry*) self, event);
	return result;
}


StartConversationEntry* start_conversation_entry_construct (GType object_type, Account* account) {
	StartConversationEntry * self = NULL;
	Account* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	GtkWindow* _tmp3_;
	ReplyEntry* _tmp4_;
	GdkScreen* _tmp5_;
	GtkWindow* _tmp6_;
	GtkWindow* _tmp7_;
	ReplyEntry* _tmp8_;
	GtkFrame* popup_frame = NULL;
	GtkFrame* _tmp9_;
	GtkScrolledWindow* scroller = NULL;
	GtkScrolledWindow* _tmp10_;
	GtkListBox* _tmp11_;
	GtkWindow* _tmp12_;
	GtkListBox* _tmp13_;
	GtkListBox* _tmp14_;
	Account* _tmp15_;
	UserCompletion* _tmp16_;
	UserCompletion* _tmp17_;
	ReplyEntry* _tmp18_;
	GtkEntryBuffer* _tmp19_;
	GtkEntryBuffer* _tmp20_;
	UserCompletion* _tmp21_;
	UserCompletion* _tmp22_;
	ReplyEntry* _tmp23_;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (StartConversationEntry*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	_tmp1_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_POPUP);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->completion_window);
	self->priv->completion_window = _tmp1_;
	_tmp2_ = self->priv->completion_window;
	gtk_window_set_type_hint (_tmp2_, GDK_WINDOW_TYPE_HINT_COMBO);
	_tmp3_ = self->priv->completion_window;
	_tmp4_ = self->priv->name_entry;
	_tmp5_ = gtk_widget_get_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	gtk_window_set_screen (_tmp3_, _tmp5_);
	_tmp6_ = self->priv->completion_window;
	gtk_window_set_destroy_with_parent (_tmp6_, TRUE);
	_tmp7_ = self->priv->completion_window;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) ___lambda90__gtk_widget_focus_out_event, self, 0);
	_tmp8_ = self->priv->name_entry;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), "focus-out-event", (GCallback) ___lambda91__gtk_widget_focus_out_event, self, 0);
	_tmp9_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp9_);
	popup_frame = _tmp9_;
	_tmp10_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp10_);
	scroller = _tmp10_;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (popup_frame, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (scroller, gtk_widget_get_type (), GtkWidget));
	_tmp11_ = self->priv->completion_list;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (scroller, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	_tmp12_ = self->priv->completion_window;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (popup_frame, gtk_widget_get_type (), GtkWidget));
	_tmp13_ = self->priv->completion_list;
	gtk_list_box_set_activate_on_single_click (_tmp13_, FALSE);
	_tmp14_ = self->priv->completion_list;
	g_signal_connect_object (_tmp14_, "row-activated", (GCallback) _start_conversation_entry_go_button_clicked_cb_gtk_list_box_row_activated, self, 0);
	_tmp15_ = account;
	_tmp16_ = user_completion_new (_tmp15_, START_CONVERSATION_ENTRY_MAX_RESULTS);
	_g_object_unref0 (self->priv->user_completion);
	self->priv->user_completion = _tmp16_;
	_tmp17_ = self->priv->user_completion;
	_tmp18_ = self->priv->name_entry;
	_tmp19_ = gtk_entry_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_entry_get_type (), GtkEntry));
	_tmp20_ = _tmp19_;
	user_completion_connect_to (_tmp17_, G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, G_TYPE_OBJECT, GObject), "text");
	_tmp21_ = self->priv->user_completion;
	g_signal_connect_object (_tmp21_, "start-completion", (GCallback) ___lambda94__user_completion_start_completion, self, 0);
	_tmp22_ = self->priv->user_completion;
	g_signal_connect_object (_tmp22_, "populate-completion", (GCallback) ___lambda96__user_completion_populate_completion, self, 0);
	_tmp23_ = self->priv->name_entry;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), "key-press-event", (GCallback) _start_conversation_entry_name_entry_key_pressed_gtk_widget_key_press_event, self, 0);
	_g_object_unref0 (scroller);
	_g_object_unref0 (popup_frame);
	return self;
}


StartConversationEntry* start_conversation_entry_new (Account* account) {
	return start_conversation_entry_construct (TYPE_START_CONVERSATION_ENTRY, account);
}


static void start_conversation_entry_position_popup_window (StartConversationEntry* self) {
	gint x = 0;
	gint y = 0;
	GtkAllocation alloc = {0};
	ReplyEntry* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	ReplyEntry* _tmp2_;
	GdkWindow* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_;
	GtkAllocation _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GtkAllocation _tmp10_;
	gint _tmp11_;
	GtkAllocation _tmp12_;
	gint _tmp13_;
	GtkWindow* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GtkWindow* _tmp17_;
	GtkAllocation _tmp18_;
	gint _tmp19_;
	g_return_if_fail (IS_START_CONVERSATION_ENTRY (self));
	_tmp0_ = self->priv->name_entry;
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), &_tmp1_);
	alloc = _tmp1_;
	_tmp2_ = self->priv->name_entry;
	_tmp3_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
	gdk_window_get_origin (_tmp3_, &_tmp4_, &_tmp5_);
	x = _tmp4_;
	y = _tmp5_;
	_tmp6_ = x;
	_tmp7_ = alloc;
	_tmp8_ = _tmp7_.x;
	x = _tmp6_ + _tmp8_;
	_tmp9_ = y;
	_tmp10_ = alloc;
	_tmp11_ = _tmp10_.y;
	_tmp12_ = alloc;
	_tmp13_ = _tmp12_.height;
	y = _tmp9_ + (_tmp11_ + _tmp13_);
	_tmp14_ = self->priv->completion_window;
	_tmp15_ = x;
	_tmp16_ = y;
	gtk_window_move (_tmp14_, _tmp15_, _tmp16_);
	_tmp17_ = self->priv->completion_window;
	_tmp18_ = alloc;
	_tmp19_ = _tmp18_.width;
	gtk_window_resize (_tmp17_, _tmp19_, 50);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean start_conversation_entry_name_entry_key_pressed (StartConversationEntry* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	guint num_results = 0U;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	GdkEventKey* _tmp6_;
	guint _tmp7_;
	g_return_val_if_fail (IS_START_CONVERSATION_ENTRY (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp0_ = self->priv->completion_list;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_length (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_list_free0 (_tmp2_);
	num_results = _tmp4_;
	_tmp5_ = num_results;
	if (_tmp5_ == ((guint) 0)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp6_ = evt;
	_tmp7_ = _tmp6_->keyval;
	if (_tmp7_ == ((guint) GDK_KEY_Down)) {
		gint _tmp8_;
		guint _tmp9_;
		GtkListBoxRow* row = NULL;
		GtkListBox* _tmp10_;
		gint _tmp11_;
		GtkListBoxRow* _tmp12_;
		GtkListBoxRow* _tmp13_;
		GtkListBox* _tmp14_;
		GtkListBoxRow* _tmp15_;
		_tmp8_ = self->priv->current_match;
		_tmp9_ = num_results;
		self->priv->current_match = (_tmp8_ + 1) % ((gint) _tmp9_);
		_tmp10_ = self->priv->completion_list;
		_tmp11_ = self->priv->current_match;
		_tmp12_ = gtk_list_box_get_row_at_index (_tmp10_, _tmp11_);
		_tmp13_ = _g_object_ref0 (_tmp12_);
		row = _tmp13_;
		_tmp14_ = self->priv->completion_list;
		_tmp15_ = row;
		gtk_list_box_select_row (_tmp14_, _tmp15_);
		result = GDK_EVENT_STOP;
		_g_object_unref0 (row);
		return result;
	} else {
		GdkEventKey* _tmp16_;
		guint _tmp17_;
		_tmp16_ = evt;
		_tmp17_ = _tmp16_->keyval;
		if (_tmp17_ == ((guint) GDK_KEY_Up)) {
			gint _tmp18_;
			gint _tmp19_;
			GtkListBoxRow* row = NULL;
			GtkListBox* _tmp21_;
			gint _tmp22_;
			GtkListBoxRow* _tmp23_;
			GtkListBoxRow* _tmp24_;
			GtkListBox* _tmp25_;
			GtkListBoxRow* _tmp26_;
			_tmp18_ = self->priv->current_match;
			self->priv->current_match = _tmp18_ - 1;
			_tmp19_ = self->priv->current_match;
			if (_tmp19_ < 0) {
				guint _tmp20_;
				_tmp20_ = num_results;
				self->priv->current_match = ((gint) _tmp20_) - 1;
			}
			_tmp21_ = self->priv->completion_list;
			_tmp22_ = self->priv->current_match;
			_tmp23_ = gtk_list_box_get_row_at_index (_tmp21_, _tmp22_);
			_tmp24_ = _g_object_ref0 (_tmp23_);
			row = _tmp24_;
			_tmp25_ = self->priv->completion_list;
			_tmp26_ = row;
			gtk_list_box_select_row (_tmp25_, _tmp26_);
			result = GDK_EVENT_STOP;
			_g_object_unref0 (row);
			return result;
		} else {
			GdkEventKey* _tmp27_;
			guint _tmp28_;
			_tmp27_ = evt;
			_tmp28_ = _tmp27_->keyval;
			if (_tmp28_ == ((guint) GDK_KEY_Return)) {
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


void start_conversation_entry_reveal (StartConversationEntry* self) {
	GtkRevealer* _tmp0_;
	ReplyEntry* _tmp1_;
	g_return_if_fail (IS_START_CONVERSATION_ENTRY (self));
	_tmp0_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
	_tmp1_ = self->priv->name_entry;
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), FALSE);
}


void start_conversation_entry_unreveal (StartConversationEntry* self) {
	GtkRevealer* _tmp0_;
	GtkWindow* _tmp1_;
	g_return_if_fail (IS_START_CONVERSATION_ENTRY (self));
	_tmp0_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	_tmp1_ = self->priv->completion_window;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), TRUE);
}


static Block64Data* block64_data_ref (Block64Data* _data64_) {
	g_atomic_int_inc (&_data64_->_ref_count_);
	return _data64_;
}


static void block64_data_unref (void * _userdata_) {
	Block64Data* _data64_;
	_data64_ = (Block64Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data64_->_ref_count_)) {
		StartConversationEntry* self;
		self = _data64_->self;
		_g_object_unref0 (_data64_->call);
		_g_free0 (_data64_->screen_name);
		_g_object_unref0 (self);
		g_slice_free (Block64Data, _data64_);
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	glong _tmp8_;
	glong _tmp14_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	gchar* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_;
		glong _tmp4_;
		glong _tmp5_;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_;
		gint _tmp7_;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_;
		glong _tmp10_;
		glong _tmp11_;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_;
		glong _tmp13_;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static Block65Data* block65_data_ref (Block65Data* _data65_) {
	g_atomic_int_inc (&_data65_->_ref_count_);
	return _data65_;
}


static void block65_data_unref (void * _userdata_) {
	Block65Data* _data65_;
	_data65_ = (Block65Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data65_->_ref_count_)) {
		StartConversationEntry* self;
		self = _data65_->_data64_->self;
		_json_object_unref0 (_data65_->root);
		block64_data_unref (_data65_->_data64_);
		_data65_->_data64_ = NULL;
		g_slice_free (Block65Data, _data65_);
	}
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void __lambda93_ (Block65Data* _data65_, GObject* obj, GAsyncResult* res) {
	Block64Data* _data64_;
	StartConversationEntry* self;
	guint fr = 0U;
	GAsyncResult* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gchar* name = NULL;
	JsonObject* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* avatar_url = NULL;
	JsonObject* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gint64 _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	ReplyEntry* _tmp15_;
	GtkStack* _tmp16_;
	_data64_ = _data65_->_data64_;
	self = _data64_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = res;
	_tmp1_ = user_utils_load_friendship_finish (_tmp0_);
	fr = _tmp1_;
	_tmp2_ = fr;
	if ((_tmp2_ & FRIENDSHIP_CAN_DM) == ((guint) 0)) {
		GtkStack* _tmp3_;
		ReplyEntry* _tmp4_;
		_tmp3_ = self->priv->go_stack;
		gtk_stack_set_visible_child_name (_tmp3_, "button");
		_tmp4_ = self->priv->name_entry;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), TRUE);
		return;
	}
	_tmp5_ = _data65_->root;
	_tmp6_ = json_object_get_string_member (_tmp5_, "name");
	_tmp7_ = g_strdup (_tmp6_);
	name = _tmp7_;
	_tmp8_ = _data65_->root;
	_tmp9_ = json_object_get_string_member (_tmp8_, "profile_image_url");
	_tmp10_ = g_strdup (_tmp9_);
	avatar_url = _tmp10_;
	_tmp11_ = _data65_->user_id;
	_tmp12_ = _data64_->screen_name;
	_tmp13_ = name;
	_tmp14_ = avatar_url;
	g_signal_emit (self, start_conversation_entry_signals[START_CONVERSATION_ENTRY_START_SIGNAL], 0, _tmp11_, _tmp12_, _tmp13_, _tmp14_);
	_tmp15_ = self->priv->name_entry;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp16_ = self->priv->go_stack;
	gtk_stack_set_visible_child_name (_tmp16_, "button");
	_g_free0 (avatar_url);
	_g_free0 (name);
}


static void ___lambda93__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda93_ (self, source_object, res);
	block65_data_unref (self);
}


static void __lambda92_ (Block64Data* _data64_, GObject* obj, GAsyncResult* res) {
	StartConversationEntry* self;
	Block65Data* _data65_;
	JsonParser* parser = NULL;
	JsonParser* _tmp6_;
	JsonParser* _tmp14_;
	JsonNode* _tmp15_;
	JsonObject* _tmp16_;
	JsonObject* _tmp17_;
	JsonObject* _tmp18_;
	gint64 _tmp19_;
	Account* _tmp20_;
	gint64 _tmp21_;
	GError * _inner_error_ = NULL;
	self = _data64_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_data65_ = g_slice_new0 (Block65Data);
	_data65_->_ref_count_ = 1;
	_data65_->_data64_ = block64_data_ref (_data64_);
	{
		RestProxyCall* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data64_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch76_g_error;
		}
	}
	goto __finally76;
	__catch76_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		GtkStack* _tmp4_;
		ReplyEntry* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("StartConversationEntry.vala:168: %s", _tmp3_);
		_tmp4_ = self->priv->go_stack;
		gtk_stack_set_visible_child_name (_tmp4_, "button");
		_tmp5_ = self->priv->name_entry;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), TRUE);
		_g_error_free0 (e);
		block65_data_unref (_data65_);
		_data65_ = NULL;
		return;
	}
	__finally76:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		block65_data_unref (_data65_);
		_data65_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = json_parser_new ();
	parser = _tmp6_;
	{
		JsonParser* _tmp7_;
		RestProxyCall* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = parser;
		_tmp8_ = _data64_->call;
		_tmp9_ = rest_proxy_call_get_payload (_tmp8_);
		json_parser_load_from_data (_tmp7_, _tmp9_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch77_g_error;
		}
	}
	goto __finally77;
	__catch77_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		GtkStack* _tmp12_;
		ReplyEntry* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_critical ("StartConversationEntry.vala:178: %s", _tmp11_);
		_tmp12_ = self->priv->go_stack;
		gtk_stack_set_visible_child_name (_tmp12_, "button");
		_tmp13_ = self->priv->name_entry;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), TRUE);
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		block65_data_unref (_data65_);
		_data65_ = NULL;
		return;
	}
	__finally77:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		block65_data_unref (_data65_);
		_data65_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = parser;
	_tmp15_ = json_parser_get_root (_tmp14_);
	_tmp16_ = json_node_get_object (_tmp15_);
	_tmp17_ = _json_object_ref0 (_tmp16_);
	_data65_->root = _tmp17_;
	_tmp18_ = _data65_->root;
	_tmp19_ = json_object_get_int_member (_tmp18_, "id");
	_data65_->user_id = _tmp19_;
	_tmp20_ = self->priv->account;
	_tmp21_ = _data65_->user_id;
	user_utils_load_friendship (_tmp20_, _tmp21_, ___lambda93__gasync_ready_callback, block65_data_ref (_data65_));
	_g_object_unref0 (parser);
	block65_data_unref (_data65_);
	_data65_ = NULL;
}


static void ___lambda92__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda92_ (self, source_object, res);
	block64_data_unref (self);
}


static void start_conversation_entry_go_button_clicked_cb (StartConversationEntry* self) {
	Block64Data* _data64_;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GtkStack* _tmp18_;
	GtkSpinner* _tmp19_;
	ReplyEntry* _tmp20_;
	Account* _tmp21_;
	OAuthProxy* _tmp22_;
	RestProxyCall* _tmp23_;
	RestProxyCall* _tmp24_;
	RestProxyCall* _tmp25_;
	RestProxyCall* _tmp26_;
	RestProxyCall* _tmp27_;
	const gchar* _tmp28_;
	RestProxyCall* _tmp29_;
	g_return_if_fail (IS_START_CONVERSATION_ENTRY (self));
	_data64_ = g_slice_new0 (Block64Data);
	_data64_->_ref_count_ = 1;
	_data64_->self = g_object_ref (self);
	_tmp0_ = self->priv->completion_list;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	if (_tmp1_ != NULL) {
		GtkListBox* _tmp2_;
		GtkListBoxRow* _tmp3_;
		gchar* _tmp4_;
		ReplyEntry* _tmp5_;
		const gchar* _tmp6_;
		_tmp2_ = self->priv->completion_list;
		_tmp3_ = gtk_list_box_get_selected_row (_tmp2_);
		_tmp4_ = completion_list_entry_get_screen_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_COMPLETION_LIST_ENTRY, CompletionListEntry));
		_g_free0 (_data64_->screen_name);
		_data64_->screen_name = _tmp4_;
		_tmp5_ = self->priv->name_entry;
		_tmp6_ = _data64_->screen_name;
		gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_entry_get_type (), GtkEntry), _tmp6_);
	} else {
		ReplyEntry* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp7_ = self->priv->name_entry;
		_tmp8_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_entry_get_type (), GtkEntry));
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (_data64_->screen_name);
		_data64_->screen_name = _tmp10_;
	}
	_tmp11_ = _data64_->screen_name;
	_tmp12_ = g_str_has_prefix (_tmp11_, "@");
	if (_tmp12_) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = _data64_->screen_name;
		_tmp14_ = string_substring (_tmp13_, (glong) 1, (glong) -1);
		_g_free0 (_data64_->screen_name);
		_data64_->screen_name = _tmp14_;
	}
	_tmp15_ = _data64_->screen_name;
	_tmp16_ = strlen (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ <= 0) {
		block64_data_unref (_data64_);
		_data64_ = NULL;
		return;
	}
	_tmp18_ = self->priv->go_stack;
	gtk_stack_set_visible_child_name (_tmp18_, "spinner");
	_tmp19_ = self->priv->go_spinner;
	gtk_spinner_start (_tmp19_);
	_tmp20_ = self->priv->name_entry;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp21_ = self->priv->account;
	_tmp22_ = _tmp21_->proxy;
	_tmp23_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, rest_proxy_get_type (), RestProxy));
	_data64_->call = _tmp23_;
	_tmp24_ = _data64_->call;
	rest_proxy_call_set_function (_tmp24_, "1.1/users/show.json");
	_tmp25_ = _data64_->call;
	rest_proxy_call_set_method (_tmp25_, "GET");
	_tmp26_ = _data64_->call;
	rest_proxy_call_add_param (_tmp26_, "include_entities", "false");
	_tmp27_ = _data64_->call;
	_tmp28_ = _data64_->screen_name;
	rest_proxy_call_add_param (_tmp27_, "screen_name", _tmp28_);
	_tmp29_ = _data64_->call;
	rest_proxy_call_invoke_async (_tmp29_, NULL, ___lambda92__gasync_ready_callback, block64_data_ref (_data64_));
	block64_data_unref (_data64_);
	_data64_ = NULL;
}


static void _start_conversation_entry_go_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	start_conversation_entry_go_button_clicked_cb ((StartConversationEntry*) self);
}


static void g_cclosure_user_marshal_VOID__INT64_STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT64_STRING_STRING_STRING) (gpointer data1, gint64 arg_1, const char* arg_2, const char* arg_3, const char* arg_4, gpointer data2);
	register GMarshalFunc_VOID__INT64_STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT64_STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int64 (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), data2);
}


static void _start_conversation_entry___lambda97_ (StartConversationEntry* self) {
	start_conversation_entry_unreveal (self);
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}


static void __start_conversation_entry___lambda97__reply_entry_cancelled (ReplyEntry* _sender, gpointer self) {
	_start_conversation_entry___lambda97_ ((StartConversationEntry*) self);
}


static GObject * start_conversation_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	StartConversationEntry * self;
	ReplyEntry* _tmp0_;
	parent_class = G_OBJECT_CLASS (start_conversation_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_START_CONVERSATION_ENTRY, StartConversationEntry);
	_tmp0_ = self->priv->name_entry;
	g_signal_connect_object (_tmp0_, "cancelled", (GCallback) __start_conversation_entry___lambda97__reply_entry_cancelled, self, 0);
	return obj;
}


static void start_conversation_entry_class_init (StartConversationEntryClass * klass) {
	gint StartConversationEntry_private_offset;
	start_conversation_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StartConversationEntryPrivate));
	G_OBJECT_CLASS (klass)->constructor = start_conversation_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = start_conversation_entry_finalize;
	StartConversationEntry_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/start-conversation-entry.ui");
	start_conversation_entry_signals[START_CONVERSATION_ENTRY_START_SIGNAL] = g_signal_new ("start", TYPE_START_CONVERSATION_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT64_STRING_STRING_STRING, G_TYPE_NONE, 4, G_TYPE_INT64, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "revealer", FALSE, StartConversationEntry_private_offset + G_STRUCT_OFFSET (StartConversationEntryPrivate, revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_entry", FALSE, StartConversationEntry_private_offset + G_STRUCT_OFFSET (StartConversationEntryPrivate, name_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "go_stack", FALSE, StartConversationEntry_private_offset + G_STRUCT_OFFSET (StartConversationEntryPrivate, go_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "go_spinner", FALSE, StartConversationEntry_private_offset + G_STRUCT_OFFSET (StartConversationEntryPrivate, go_spinner));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "go_button_clicked_cb", G_CALLBACK(_start_conversation_entry_go_button_clicked_cb_gtk_button_clicked));
}


static void start_conversation_entry_instance_init (StartConversationEntry * self) {
	GtkListBox* _tmp0_;
	self->priv = START_CONVERSATION_ENTRY_GET_PRIVATE (self);
	_tmp0_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->completion_list = _tmp0_;
	self->priv->current_match = -1;
	g_type_ensure (TYPE_REPLY_ENTRY);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void start_conversation_entry_finalize (GObject * obj) {
	StartConversationEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_START_CONVERSATION_ENTRY, StartConversationEntry);
	_g_object_unref0 (self->priv->revealer);
	_g_object_unref0 (self->priv->name_entry);
	_g_object_unref0 (self->priv->go_stack);
	_g_object_unref0 (self->priv->go_spinner);
	_g_object_unref0 (self->priv->user_completion);
	_g_object_unref0 (self->priv->completion_window);
	_g_object_unref0 (self->priv->completion_list);
	G_OBJECT_CLASS (start_conversation_entry_parent_class)->finalize (obj);
}


GType start_conversation_entry_get_type (void) {
	static volatile gsize start_conversation_entry_type_id__volatile = 0;
	if (g_once_init_enter (&start_conversation_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StartConversationEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) start_conversation_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StartConversationEntry), 0, (GInstanceInitFunc) start_conversation_entry_instance_init, NULL };
		GType start_conversation_entry_type_id;
		start_conversation_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "StartConversationEntry", &g_define_type_info, 0);
		g_once_init_leave (&start_conversation_entry_type_id__volatile, start_conversation_entry_type_id);
	}
	return start_conversation_entry_type_id__volatile;
}


CompletionListEntry* completion_list_entry_construct (GType object_type, const gchar* screen_name, const gchar* name) {
	CompletionListEntry * self = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	const gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkStyleContext* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	g_return_val_if_fail (screen_name != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (CompletionListEntry*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp1_ = name;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->name_label);
	self->priv->name_label = _tmp2_;
	_tmp3_ = self->priv->name_label;
	gtk_label_set_ellipsize (_tmp3_, PANGO_ELLIPSIZE_END);
	_tmp4_ = self->priv->name_label;
	gtk_label_set_use_markup (_tmp4_, TRUE);
	_tmp5_ = screen_name;
	_tmp6_ = g_strconcat ("@", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = (GtkLabel*) gtk_label_new (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->screen_name_label);
	self->priv->screen_name_label = _tmp8_;
	_g_free0 (_tmp7_);
	_tmp9_ = self->priv->name_label;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_BASELINE);
	_tmp10_ = self->priv->screen_name_label;
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_BASELINE);
	_tmp11_ = self->priv->screen_name_label;
	_tmp12_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp12_, "dim-label");
	_tmp13_ = self->priv->name_label;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (box, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
	_tmp14_ = self->priv->screen_name_label;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (box, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (box, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (box);
	return self;
}


CompletionListEntry* completion_list_entry_new (const gchar* screen_name, const gchar* name) {
	return completion_list_entry_construct (TYPE_COMPLETION_LIST_ENTRY, screen_name, name);
}


gchar* completion_list_entry_get_screen_name (CompletionListEntry* self) {
	gchar* result = NULL;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (IS_COMPLETION_LIST_ENTRY (self), NULL);
	_tmp0_ = self->priv->screen_name_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = string_substring (_tmp1_, (glong) 1, (glong) -1);
	result = _tmp2_;
	return result;
}


static void completion_list_entry_class_init (CompletionListEntryClass * klass) {
	completion_list_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CompletionListEntryPrivate));
	G_OBJECT_CLASS (klass)->finalize = completion_list_entry_finalize;
}


static void completion_list_entry_instance_init (CompletionListEntry * self) {
	self->priv = COMPLETION_LIST_ENTRY_GET_PRIVATE (self);
}


static void completion_list_entry_finalize (GObject * obj) {
	CompletionListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_LIST_ENTRY, CompletionListEntry);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->screen_name_label);
	G_OBJECT_CLASS (completion_list_entry_parent_class)->finalize (obj);
}


GType completion_list_entry_get_type (void) {
	static volatile gsize completion_list_entry_type_id__volatile = 0;
	if (g_once_init_enter (&completion_list_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CompletionListEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_list_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionListEntry), 0, (GInstanceInitFunc) completion_list_entry_instance_init, NULL };
		GType completion_list_entry_type_id;
		completion_list_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "CompletionListEntry", &g_define_type_info, 0);
		g_once_init_leave (&completion_list_entry_type_id__volatile, completion_list_entry_type_id);
	}
	return completion_list_entry_type_id__volatile;
}



