/* PixbufButton.c generated by valac 0.38.7, the Vala compiler
 * generated from PixbufButton.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>


#define TYPE_PIXBUF_BUTTON (pixbuf_button_get_type ())
#define PIXBUF_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXBUF_BUTTON, PixbufButton))
#define PIXBUF_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXBUF_BUTTON, PixbufButtonClass))
#define IS_PIXBUF_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXBUF_BUTTON))
#define IS_PIXBUF_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXBUF_BUTTON))
#define PIXBUF_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXBUF_BUTTON, PixbufButtonClass))

typedef struct _PixbufButton PixbufButton;
typedef struct _PixbufButtonClass PixbufButtonClass;
typedef struct _PixbufButtonPrivate PixbufButtonPrivate;
enum  {
	PIXBUF_BUTTON_0_PROPERTY,
	PIXBUF_BUTTON_ROUND_PROPERTY,
	PIXBUF_BUTTON_NUM_PROPERTIES
};
static GParamSpec* pixbuf_button_properties[PIXBUF_BUTTON_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _PixbufButton {
	GtkButton parent_instance;
	PixbufButtonPrivate * priv;
};

struct _PixbufButtonClass {
	GtkButtonClass parent_class;
};

struct _PixbufButtonPrivate {
	cairo_surface_t* bg;
	gboolean _round;
};


static gpointer pixbuf_button_parent_class = NULL;

GType pixbuf_button_get_type (void) G_GNUC_CONST;
#define PIXBUF_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PIXBUF_BUTTON, PixbufButtonPrivate))
PixbufButton* pixbuf_button_new (void);
PixbufButton* pixbuf_button_construct (GType object_type);
static gboolean pixbuf_button_real_draw (GtkWidget* base, cairo_t* ct);
void pixbuf_button_set_bg (PixbufButton* self, cairo_surface_t* bg);
void pixbuf_button_set_pixbuf (PixbufButton* self, GdkPixbuf* pixbuf);
gboolean pixbuf_button_get_round (PixbufButton* self);
void pixbuf_button_set_round (PixbufButton* self, gboolean value);
static GObject * pixbuf_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void pixbuf_button_finalize (GObject * obj);
static void _vala_pixbuf_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_pixbuf_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


PixbufButton* pixbuf_button_construct (GType object_type) {
	PixbufButton * self = NULL;
	self = (PixbufButton*) g_object_new (object_type, NULL);
	return self;
}


PixbufButton* pixbuf_button_new (void) {
	return pixbuf_button_construct (TYPE_PIXBUF_BUTTON);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean pixbuf_button_real_draw (GtkWidget* base, cairo_t* ct) {
	PixbufButton * self;
	gboolean result = FALSE;
	GtkStyleContext* sc = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	gint widget_width = 0;
	gint _tmp2_;
	gint widget_height = 0;
	gint _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_t* _tmp47_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PIXBUF_BUTTON, PixbufButton);
	g_return_val_if_fail (ct != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = _g_object_ref0 (_tmp0_);
	sc = _tmp1_;
	_tmp2_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_width = _tmp2_;
	_tmp3_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	widget_height = _tmp3_;
	_tmp4_ = self->priv->bg;
	if (_tmp4_ != NULL) {
		cairo_surface_t* surface = NULL;
		cairo_t* _tmp5_;
		cairo_surface_t* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		cairo_surface_t* _tmp9_;
		cairo_t* ctx = NULL;
		cairo_surface_t* _tmp10_;
		cairo_t* _tmp11_;
		cairo_t* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gdouble scale_x = 0.0;
		gint _tmp15_;
		cairo_surface_t* _tmp16_;
		gint _tmp17_;
		gdouble scale_y = 0.0;
		gint _tmp18_;
		cairo_surface_t* _tmp19_;
		gint _tmp20_;
		cairo_t* _tmp21_;
		cairo_t* _tmp22_;
		gdouble _tmp23_;
		gdouble _tmp24_;
		cairo_t* _tmp25_;
		cairo_surface_t* _tmp26_;
		cairo_t* _tmp27_;
		cairo_t* _tmp28_;
		gboolean _tmp29_;
		cairo_t* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		cairo_t* _tmp44_;
		cairo_surface_t* _tmp45_;
		cairo_t* _tmp46_;
		_tmp5_ = ct;
		_tmp6_ = cairo_get_target (_tmp5_);
		_tmp7_ = widget_width;
		_tmp8_ = widget_height;
		_tmp9_ = cairo_surface_create_similar (_tmp6_, CAIRO_CONTENT_COLOR_ALPHA, _tmp7_, _tmp8_);
		surface = _tmp9_;
		_tmp10_ = surface;
		_tmp11_ = cairo_create (_tmp10_);
		ctx = _tmp11_;
		_tmp12_ = ctx;
		_tmp13_ = widget_width;
		_tmp14_ = widget_height;
		cairo_rectangle (_tmp12_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp13_, (gdouble) _tmp14_);
		_tmp15_ = widget_width;
		_tmp16_ = self->priv->bg;
		_tmp17_ = cairo_image_surface_get_width (_tmp16_);
		scale_x = ((gdouble) _tmp15_) / _tmp17_;
		_tmp18_ = widget_height;
		_tmp19_ = self->priv->bg;
		_tmp20_ = cairo_image_surface_get_height (_tmp19_);
		scale_y = ((gdouble) _tmp18_) / _tmp20_;
		_tmp21_ = ctx;
		cairo_save (_tmp21_);
		_tmp22_ = ctx;
		_tmp23_ = scale_x;
		_tmp24_ = scale_y;
		cairo_scale (_tmp22_, _tmp23_, _tmp24_);
		_tmp25_ = ctx;
		_tmp26_ = self->priv->bg;
		cairo_set_source_surface (_tmp25_, _tmp26_, (gdouble) 0, (gdouble) 0);
		_tmp27_ = ctx;
		cairo_fill (_tmp27_);
		_tmp28_ = ctx;
		cairo_restore (_tmp28_);
		_tmp29_ = self->priv->_round;
		if (_tmp29_) {
			cairo_t* _tmp30_;
			cairo_t* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			cairo_t* _tmp34_;
			gint _tmp35_;
			cairo_t* _tmp36_;
			GtkStyleContext* _tmp37_;
			cairo_t* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			_tmp30_ = ctx;
			cairo_set_operator (_tmp30_, CAIRO_OPERATOR_DEST_IN);
			_tmp31_ = ctx;
			_tmp32_ = widget_width;
			_tmp33_ = widget_height;
			cairo_translate (_tmp31_, (gdouble) (_tmp32_ / 2), (gdouble) (_tmp33_ / 2));
			_tmp34_ = ctx;
			_tmp35_ = widget_width;
			cairo_arc (_tmp34_, (gdouble) 0, (gdouble) 0, (gdouble) (_tmp35_ / 2), (gdouble) 0, 2 * G_PI);
			_tmp36_ = ctx;
			cairo_fill (_tmp36_);
			_tmp37_ = sc;
			_tmp38_ = ct;
			_tmp39_ = widget_width;
			_tmp40_ = widget_height;
			gtk_render_frame (_tmp37_, _tmp38_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp39_, (gdouble) _tmp40_);
		}
		_tmp41_ = ct;
		_tmp42_ = widget_width;
		_tmp43_ = widget_height;
		cairo_rectangle (_tmp41_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp42_, (gdouble) _tmp43_);
		_tmp44_ = ct;
		_tmp45_ = surface;
		cairo_set_source_surface (_tmp44_, _tmp45_, (gdouble) 0, (gdouble) 0);
		_tmp46_ = ct;
		cairo_fill (_tmp46_);
		_cairo_destroy0 (ctx);
		_cairo_surface_destroy0 (surface);
	}
	_tmp47_ = ct;
	GTK_WIDGET_CLASS (pixbuf_button_parent_class)->draw (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), gtk_widget_get_type (), GtkWidget), _tmp47_);
	result = G_SOURCE_CONTINUE;
	_g_object_unref0 (sc);
	return result;
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


void pixbuf_button_set_bg (PixbufButton* self, cairo_surface_t* bg) {
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* _tmp2_;
	gint _tmp3_;
	cairo_surface_t* _tmp4_;
	gint _tmp5_;
	g_return_if_fail (IS_PIXBUF_BUTTON (self));
	g_return_if_fail (bg != NULL);
	_tmp0_ = bg;
	_tmp1_ = _cairo_surface_reference0 (_tmp0_);
	_cairo_surface_destroy0 (self->priv->bg);
	self->priv->bg = _tmp1_;
	_tmp2_ = bg;
	_tmp3_ = cairo_image_surface_get_width (_tmp2_);
	_tmp4_ = bg;
	_tmp5_ = cairo_image_surface_get_height (_tmp4_);
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp3_, _tmp5_);
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}


void pixbuf_button_set_pixbuf (PixbufButton* self, GdkPixbuf* pixbuf) {
	GdkPixbuf* _tmp0_;
	cairo_surface_t* _tmp1_;
	g_return_if_fail (IS_PIXBUF_BUTTON (self));
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
	_tmp0_ = pixbuf;
	_tmp1_ = gdk_cairo_surface_create_from_pixbuf (_tmp0_, 1, NULL);
	_cairo_surface_destroy0 (self->priv->bg);
	self->priv->bg = (cairo_surface_t*) _tmp1_;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}


gboolean pixbuf_button_get_round (PixbufButton* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (IS_PIXBUF_BUTTON (self), FALSE);
	_tmp0_ = self->priv->_round;
	result = _tmp0_;
	return result;
}


void pixbuf_button_set_round (PixbufButton* self, gboolean value) {
	gboolean _tmp0_;
	gboolean _tmp3_;
	g_return_if_fail (IS_PIXBUF_BUTTON (self));
	_tmp0_ = value;
	if (_tmp0_) {
		GtkStyleContext* _tmp1_;
		_tmp1_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp1_, "pixbuf-button-round");
	} else {
		GtkStyleContext* _tmp2_;
		_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_remove_class (_tmp2_, "pixbuf-button-round");
	}
	_tmp3_ = value;
	self->priv->_round = _tmp3_;
	g_object_notify_by_pspec ((GObject *) self, pixbuf_button_properties[PIXBUF_BUTTON_ROUND_PROPERTY]);
}


static GObject * pixbuf_button_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	PixbufButton * self;
	GtkStyleContext* _tmp0_;
	parent_class = G_OBJECT_CLASS (pixbuf_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXBUF_BUTTON, PixbufButton);
	gtk_container_set_border_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), (guint) 0);
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp0_, "pixbuf-button");
	return obj;
}


static void pixbuf_button_class_init (PixbufButtonClass * klass) {
	pixbuf_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PixbufButtonPrivate));
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) pixbuf_button_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_pixbuf_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pixbuf_button_set_property;
	G_OBJECT_CLASS (klass)->constructor = pixbuf_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = pixbuf_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PIXBUF_BUTTON_ROUND_PROPERTY, pixbuf_button_properties[PIXBUF_BUTTON_ROUND_PROPERTY] = g_param_spec_boolean ("round", "round", "round", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void pixbuf_button_instance_init (PixbufButton * self) {
	self->priv = PIXBUF_BUTTON_GET_PRIVATE (self);
	self->priv->_round = FALSE;
}


static void pixbuf_button_finalize (GObject * obj) {
	PixbufButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PIXBUF_BUTTON, PixbufButton);
	_cairo_surface_destroy0 (self->priv->bg);
	G_OBJECT_CLASS (pixbuf_button_parent_class)->finalize (obj);
}


GType pixbuf_button_get_type (void) {
	static volatile gsize pixbuf_button_type_id__volatile = 0;
	if (g_once_init_enter (&pixbuf_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PixbufButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pixbuf_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PixbufButton), 0, (GInstanceInitFunc) pixbuf_button_instance_init, NULL };
		GType pixbuf_button_type_id;
		pixbuf_button_type_id = g_type_register_static (gtk_button_get_type (), "PixbufButton", &g_define_type_info, 0);
		g_once_init_leave (&pixbuf_button_type_id__volatile, pixbuf_button_type_id);
	}
	return pixbuf_button_type_id__volatile;
}


static void _vala_pixbuf_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	PixbufButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PIXBUF_BUTTON, PixbufButton);
	switch (property_id) {
		case PIXBUF_BUTTON_ROUND_PROPERTY:
		g_value_set_boolean (value, pixbuf_button_get_round (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_pixbuf_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	PixbufButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PIXBUF_BUTTON, PixbufButton);
	switch (property_id) {
		case PIXBUF_BUTTON_ROUND_PROPERTY:
		pixbuf_button_set_round (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



