/* AssistantRestore.c generated by valac 0.30.2, the Vala compiler
 * generated from AssistantRestore.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "deja.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "widgets.h"
#include <glib/gi18n-lib.h>
#include <time.h>
#include <float.h>
#include <math.h>


#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define ASSISTANT_TYPE_PAGE_INFO (assistant_page_info_get_type ())
#define ASSISTANT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo))
#define ASSISTANT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))
#define ASSISTANT_IS_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_IS_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))

typedef struct _AssistantPageInfo AssistantPageInfo;
typedef struct _AssistantPageInfoClass AssistantPageInfoClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

#define TYPE_STATUS_ICON (status_icon_get_type ())
#define STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS_ICON, StatusIcon))
#define STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATUS_ICON, StatusIconClass))
#define IS_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS_ICON))
#define IS_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATUS_ICON))
#define STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATUS_ICON, StatusIconClass))

typedef struct _StatusIcon StatusIcon;
typedef struct _StatusIconClass StatusIconClass;

#define TYPE_ASSISTANT_RESTORE (assistant_restore_get_type ())
#define ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestore))
#define ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))
#define IS_ASSISTANT_RESTORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_RESTORE))
#define IS_ASSISTANT_RESTORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_RESTORE))
#define ASSISTANT_RESTORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_RESTORE, AssistantRestoreClass))

typedef struct _AssistantRestore AssistantRestore;
typedef struct _AssistantRestoreClass AssistantRestoreClass;
typedef struct _AssistantRestorePrivate AssistantRestorePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _deja_dup_operation_state_unref0(var) ((var == NULL) ? NULL : (var = (deja_dup_operation_state_unref (var), NULL)))

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

#define TYPE_MOUNT_OPERATION_ASSISTANT (mount_operation_assistant_get_type ())
#define MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant))
#define MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))
#define IS_MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_OPERATION_ASSISTANT))
#define IS_MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_OPERATION_ASSISTANT))
#define MOUNT_OPERATION_ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))

typedef struct _MountOperationAssistant MountOperationAssistant;
typedef struct _MountOperationAssistantClass MountOperationAssistantClass;
typedef struct _AssistantRestoreDoQueryData AssistantRestoreDoQueryData;

struct _Assistant {
	GtkWindow parent_instance;
	AssistantPrivate * priv;
	GtkImage* header_icon;
	GtkEventBox* page_box;
	GList* current;
};

struct _AssistantClass {
	GtkWindowClass parent_class;
};

struct _AssistantOperation {
	Assistant parent_instance;
	AssistantOperationPrivate * priv;
	StatusIcon* status_icon;
	gboolean succeeded;
	gboolean nagged;
	GtkLabel* summary_label;
	GtkWidget* detail_widget;
	DejaDupOperation* op;
};

struct _AssistantOperationClass {
	AssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	DejaDupOperation* (*create_op) (AssistantOperation* self);
	gchar* (*get_progress_file_prefix) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, const gchar* _error_, const gchar* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*apply_finished) (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
	void (*do_prepare) (AssistantOperation* self, Assistant* assist, GtkWidget* page);
	void (*do_cancel) (AssistantOperation* self);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantRestore {
	AssistantOperation parent_instance;
	AssistantRestorePrivate * priv;
	GList* _restore_files;
	DejaDupOperationStatus* query_op;
	DejaDupOperationState* op_state;
};

struct _AssistantRestoreClass {
	AssistantOperationClass parent_class;
	void (*handle_collection_dates) (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates);
	void (*query_finished) (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
};

struct _AssistantRestorePrivate {
	gchar* _restore_location;
	GtkProgressBar* query_progress_bar;
	guint query_timeout_id;
	GtkComboBoxText* date_combo;
	GtkListStore* date_store;
	GtkBox* cust_box;
	GtkFileChooserButton* cust_button;
	GtkGrid* confirm_table;
	GtkLabel* confirm_location_label;
	GtkLabel* confirm_location;
	GtkLabel* confirm_date_label;
	GtkLabel* confirm_date;
	GtkLabel* confirm_files_label;
	GtkGrid* confirm_files;
	GtkWidget* query_progress_page;
	GtkWidget* date_page;
	GtkWidget* restore_dest_page;
	gboolean got_dates;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_CHECK,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;

struct _AssistantRestoreDoQueryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AssistantRestore* self;
	DejaDupOperationStatus* _tmp0_;
	DejaDupOperationStatus* _tmp1_;
	DejaDupOperation* _tmp2_;
	DejaDupOperation* _tmp3_;
	DejaDupOperation* _tmp4_;
	DejaDupOperation* _tmp5_;
	DejaDupOperationStatus* _tmp6_;
	DejaDupOperation* _tmp7_;
	DejaDupBackend* _tmp8_;
	DejaDupBackend* _tmp9_;
	MountOperationAssistant* _tmp10_;
	MountOperationAssistant* _tmp11_;
	DejaDupOperation* _tmp12_;
	DejaDupBackend* _tmp13_;
	DejaDupBackend* _tmp14_;
	DejaDupOperation* _tmp15_;
};


static gpointer assistant_restore_parent_class = NULL;

GType assistant_get_type (void) G_GNUC_CONST;
gpointer assistant_page_info_ref (gpointer instance);
void assistant_page_info_unref (gpointer instance);
GParamSpec* assistant_param_spec_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void assistant_value_set_page_info (GValue* value, gpointer v_object);
void assistant_value_take_page_info (GValue* value, gpointer v_object);
gpointer assistant_value_get_page_info (const GValue* value);
GType assistant_page_info_get_type (void) G_GNUC_CONST;
GType assistant_operation_get_type (void) G_GNUC_CONST;
GType status_icon_get_type (void) G_GNUC_CONST;
GType assistant_restore_get_type (void) G_GNUC_CONST;
#define ASSISTANT_RESTORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT_RESTORE, AssistantRestorePrivate))
enum  {
	ASSISTANT_RESTORE_DUMMY_PROPERTY,
	ASSISTANT_RESTORE_RESTORE_LOCATION,
	ASSISTANT_RESTORE_RESTORE_FILES
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
AssistantRestore* assistant_restore_new_with_files (GList* files);
AssistantRestore* assistant_restore_construct_with_files (GType object_type, GList* files);
AssistantOperation* assistant_operation_construct (GType object_type);
void assistant_restore_set_restore_files (AssistantRestore* self, GList* value);
static void assistant_restore_real_add_setup_pages (AssistantOperation* base);
static void assistant_restore_add_query_backend_page (AssistantRestore* self);
static void assistant_restore_add_date_page (AssistantRestore* self);
static void assistant_restore_add_restore_dest_page (AssistantRestore* self);
static GtkWidget* assistant_restore_make_backup_location_page (AssistantRestore* self);
static void assistant_restore_real_add_custom_config_pages (AssistantOperation* base);
GList* assistant_restore_get_restore_files (AssistantRestore* self);
GType assistant_type_get_type (void) G_GNUC_CONST;
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const gchar* title);
static GtkWidget* assistant_restore_make_query_backend_page (AssistantRestore* self);
static GtkWidget* assistant_restore_make_date_page (AssistantRestore* self);
static GtkWidget* assistant_restore_make_restore_dest_page (AssistantRestore* self);
static void __lambda29_ (AssistantRestore* self, GtkToggleButton* r);
void assistant_restore_set_restore_location (AssistantRestore* self, const gchar* value);
static void ___lambda29__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void __lambda30_ (AssistantRestore* self, GtkToggleButton* r);
static void ___lambda30__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void __lambda31_ (AssistantRestore* self, GtkFileChooser* b);
static void ___lambda31__gtk_file_chooser_selection_changed (GtkFileChooser* _sender, gpointer self);
static GtkWidget* assistant_restore_real_make_confirm_page (AssistantOperation* base);
static DejaDupOperation* assistant_restore_real_create_op (AssistantOperation* base);
const gchar* assistant_restore_get_restore_location (AssistantRestore* self);
static gchar* assistant_restore_real_get_progress_file_prefix (AssistantOperation* base);
static gboolean assistant_restore_is_same_day (AssistantRestore* self, GTimeVal* one, GTimeVal* two);
void assistant_restore_handle_collection_dates (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates);
static void assistant_restore_real_handle_collection_dates (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates);
static GTimeVal* _g_time_val_dup (GTimeVal* self);
void assistant_operation_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
void assistant_restore_query_finished (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
static void assistant_restore_real_query_finished (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail);
void assistant_operation_do_close (AssistantOperation* self);
void assistant_go_forward (Assistant* self);
static gboolean assistant_restore_query_pulse (AssistantRestore* self);
static void assistant_restore_do_query_data_free (gpointer _data);
void assistant_restore_do_query (AssistantRestore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void assistant_restore_do_query_finish (AssistantRestore* self, GAsyncResult* _res_);
static gboolean assistant_restore_do_query_co (AssistantRestoreDoQueryData* _data_);
static void _assistant_restore_query_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, const gchar* detail, gpointer self);
static void __lambda32_ (AssistantRestore* self, DejaDupOperation* o, const gchar* e, const gchar* d);
static void ___lambda32__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self);
void assistant_operation_get_passphrase (AssistantOperation* self);
static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self);
static void _assistant_restore_handle_collection_dates_deja_dup_operation_status_collection_dates (DejaDupOperationStatus* _sender, GList* dates, gpointer self);
MountOperationAssistant* mount_operation_assistant_new (AssistantOperation* assist);
MountOperationAssistant* mount_operation_assistant_construct (GType object_type, AssistantOperation* assist);
GType mount_operation_assistant_get_type (void) G_GNUC_CONST;
void assistant_operation_pause_op (AssistantOperation* self, DejaDupBackend* back, const gchar* header, const gchar* msg);
static void _assistant_operation_pause_op_deja_dup_backend_pause_op (DejaDupBackend* _sender, const gchar* header, const gchar* msg, gpointer self);
static void assistant_restore_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page);
void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
void assistant_skip (Assistant* self);
GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self);
static void ______lambda33_ (AssistantRestore* self, GtkWidget* w);
static void _______lambda33__gtk_callback (GtkWidget* widget, gpointer self);
GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
gboolean assistant_operation_get_error_occurred (AssistantOperation* self);
GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self);
gboolean assistant_get_last_op_was_back (Assistant* self);
static gboolean _assistant_restore_query_pulse_gsource_func (gpointer self);
void assistant_operation_provide_password (AssistantOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void assistant_operation_provide_password_finish (AssistantOperation* self, GAsyncResult* _res_);
static void assistant_restore_real_do_close (AssistantOperation* base);
AssistantRestore* assistant_restore_new (void);
AssistantRestore* assistant_restore_construct (GType object_type);
static GObject * assistant_restore_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void assistant_set_apply_text (Assistant* self, const gchar* value);
static void assistant_restore_finalize (GObject* obj);
static void _vala_assistant_restore_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_assistant_restore_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


AssistantRestore* assistant_restore_construct_with_files (GType object_type, GList* files) {
	AssistantRestore * self = NULL;
	GList* _tmp0_ = NULL;
	self = (AssistantRestore*) assistant_operation_construct (object_type);
	_tmp0_ = files;
	assistant_restore_set_restore_files (self, _tmp0_);
	return self;
}


AssistantRestore* assistant_restore_new_with_files (GList* files) {
	return assistant_restore_construct_with_files (TYPE_ASSISTANT_RESTORE, files);
}


static void assistant_restore_real_add_setup_pages (AssistantOperation* base) {
	AssistantRestore * self;
	self = (AssistantRestore*) base;
	assistant_restore_add_query_backend_page (self);
	assistant_restore_add_date_page (self);
	assistant_restore_add_restore_dest_page (self);
}


static GtkWidget* assistant_restore_make_backup_location_page (AssistantRestore* self) {
	GtkWidget* result = NULL;
	gint rows = 0;
	GtkWidget* label = NULL;
	GtkSizeGroup* label_sizes = NULL;
	GtkSizeGroup* _tmp0_ = NULL;
	GtkGrid* page = NULL;
	GtkGrid* _tmp1_ = NULL;
	DejaDupConfigLocation* location = NULL;
	DejaDupConfigLocation* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GtkEventBox* _tmp8_ = NULL;
	GtkEventBox* _tmp9_ = NULL;
	GtkEventBox* _tmp10_ = NULL;
	GtkEventBox* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	GtkRequisition req = {0};
	GtkRequisition hidden = {0};
	GtkRequisition _tmp14_ = {0};
	GtkRequisition _tmp15_ = {0};
	GtkRequisition _tmp16_ = {0};
	gint _tmp17_ = 0;
	GtkRequisition _tmp18_ = {0};
	gint _tmp19_ = 0;
	GtkRequisition _tmp20_ = {0};
	gint _tmp21_ = 0;
	GtkRequisition _tmp22_ = {0};
	gint _tmp23_ = 0;
	GtkRequisition _tmp24_ = {0};
	gint _tmp25_ = 0;
	GtkRequisition _tmp26_ = {0};
	gint _tmp27_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	_tmp0_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	label_sizes = _tmp0_;
	_tmp1_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp1_);
	page = _tmp1_;
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 12, "border-width", 12, NULL);
	_tmp2_ = deja_dup_config_location_new (label_sizes);
	g_object_ref_sink (_tmp2_);
	location = _tmp2_;
	_tmp3_ = _ ("_Backup location");
	_tmp4_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (label);
	label = (GtkWidget*) _tmp4_;
	g_object_set ((GObject*) label, "xalign", 1.0f, "mnemonic-widget", location, NULL);
	gtk_size_group_add_widget (label_sizes, label);
	_tmp5_ = rows;
	gtk_grid_attach (page, label, 0, _tmp5_, 1, 1);
	g_object_set ((GObject*) location, "hexpand", TRUE, NULL);
	_tmp6_ = rows;
	gtk_grid_attach (page, (GtkWidget*) location, 1, _tmp6_, 1, 1);
	_tmp7_ = rows;
	rows = _tmp7_ + 1;
	_tmp8_ = deja_dup_config_location_get_extras (location);
	_tmp9_ = _tmp8_;
	g_object_set ((GObject*) _tmp9_, "hexpand", TRUE, NULL);
	_tmp10_ = deja_dup_config_location_get_extras (location);
	_tmp11_ = _tmp10_;
	_tmp12_ = rows;
	gtk_grid_attach (page, (GtkWidget*) _tmp11_, 0, _tmp12_, 2, 1);
	_tmp13_ = rows;
	rows = _tmp13_ + 1;
	gtk_widget_show_all ((GtkWidget*) page);
	gtk_widget_get_preferred_size ((GtkWidget*) page, NULL, &_tmp14_);
	req = _tmp14_;
	deja_dup_config_location_hidden_size (location, &_tmp15_);
	hidden = _tmp15_;
	_tmp16_ = req;
	_tmp17_ = _tmp16_.width;
	_tmp18_ = hidden;
	_tmp19_ = _tmp18_.width;
	req.width = _tmp17_ + _tmp19_;
	_tmp20_ = req;
	_tmp21_ = _tmp20_.height;
	_tmp22_ = hidden;
	_tmp23_ = _tmp22_.height;
	req.height = _tmp21_ + _tmp23_;
	_tmp24_ = req;
	_tmp25_ = _tmp24_.width;
	_tmp26_ = req;
	_tmp27_ = _tmp26_.height;
	gtk_widget_set_size_request ((GtkWidget*) page, _tmp25_, _tmp27_);
	result = (GtkWidget*) page;
	_g_object_unref0 (location);
	_g_object_unref0 (label_sizes);
	_g_object_unref0 (label);
	return result;
}


static void assistant_restore_real_add_custom_config_pages (AssistantOperation* base) {
	AssistantRestore * self;
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	self = (AssistantRestore*) base;
	_tmp1_ = assistant_restore_get_restore_files (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = deja_dup_has_seen_settings ();
		_tmp0_ = !_tmp3_;
	}
	if (_tmp0_) {
		GtkWidget* page = NULL;
		GtkWidget* _tmp4_ = NULL;
		GtkWidget* _tmp5_ = NULL;
		GtkWidget* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp4_ = assistant_restore_make_backup_location_page (self);
		page = _tmp4_;
		_tmp5_ = page;
		assistant_append_page ((Assistant*) self, _tmp5_, ASSISTANT_TYPE_NORMAL);
		_tmp6_ = page;
		_tmp7_ = _ ("Restore From Where?");
		assistant_set_page_title ((Assistant*) self, _tmp6_, _tmp7_);
		_g_object_unref0 (page);
	}
}


static GtkWidget* assistant_restore_make_query_backend_page (AssistantRestore* self) {
	GtkWidget* result = NULL;
	GtkProgressBar* _tmp0_ = NULL;
	GtkBox* page = NULL;
	GtkBox* _tmp1_ = NULL;
	GtkProgressBar* _tmp2_ = NULL;
	GtkProgressBar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->query_progress_bar);
	self->priv->query_progress_bar = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp1_);
	page = _tmp1_;
	_tmp2_ = self->priv->query_progress_bar;
	g_object_set ((GObject*) page, "child", _tmp2_, "border-width", 12, NULL);
	_tmp3_ = self->priv->query_progress_bar;
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) _tmp3_, "expand", FALSE, NULL);
	result = (GtkWidget*) page;
	return result;
}


static GtkWidget* assistant_restore_make_date_page (AssistantRestore* self) {
	GtkWidget* result = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkComboBoxText* _tmp1_ = NULL;
	GtkComboBoxText* _tmp2_ = NULL;
	GtkListStore* _tmp3_ = NULL;
	GtkLabel* date_label = NULL;
	const gchar* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkComboBoxText* _tmp6_ = NULL;
	GtkBox* hbox = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkComboBoxText* _tmp8_ = NULL;
	GtkBox* page = NULL;
	GtkBox* _tmp9_ = NULL;
	GtkComboBoxText* _tmp10_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->date_store);
	self->priv->date_store = _tmp0_;
	_tmp1_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->date_combo);
	self->priv->date_combo = _tmp1_;
	_tmp2_ = self->priv->date_combo;
	_tmp3_ = self->priv->date_store;
	gtk_combo_box_set_model ((GtkComboBox*) _tmp2_, (GtkTreeModel*) _tmp3_);
	_tmp4_ = _ ("_Date");
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	date_label = _tmp5_;
	_tmp6_ = self->priv->date_combo;
	g_object_set ((GObject*) date_label, "mnemonic-widget", _tmp6_, "use-underline", TRUE, "xalign", 1.0f, NULL);
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp7_);
	hbox = _tmp7_;
	_tmp8_ = self->priv->date_combo;
	g_object_set ((GObject*) hbox, "child", date_label, "child", _tmp8_, NULL);
	_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp9_);
	page = _tmp9_;
	g_object_set ((GObject*) page, "child", hbox, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) hbox, (GtkWidget*) date_label, "expand", FALSE, NULL);
	_tmp10_ = self->priv->date_combo;
	gtk_container_child_set ((GtkContainer*) hbox, (GtkWidget*) _tmp10_, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) hbox, "expand", FALSE, NULL);
	result = (GtkWidget*) page;
	_g_object_unref0 (hbox);
	_g_object_unref0 (date_label);
	return result;
}


static void __lambda29_ (AssistantRestore* self, GtkToggleButton* r) {
	GtkToggleButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		assistant_restore_set_restore_location (self, "/");
	}
}


static void ___lambda29__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda29_ ((AssistantRestore*) self, _sender);
}


static void __lambda30_ (AssistantRestore* self, GtkToggleButton* r) {
	GtkToggleButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkBox* _tmp6_ = NULL;
	GtkToggleButton* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkFileChooserButton* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		_tmp3_ = self->priv->cust_button;
		_tmp4_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp3_);
		_tmp5_ = _tmp4_;
		assistant_restore_set_restore_location (self, _tmp5_);
		_g_free0 (_tmp5_);
	}
	_tmp6_ = self->priv->cust_box;
	_tmp7_ = r;
	_tmp8_ = gtk_toggle_button_get_active (_tmp7_);
	_tmp9_ = _tmp8_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, _tmp9_);
}


static void ___lambda30__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda30_ ((AssistantRestore*) self, _sender);
}


static void __lambda31_ (AssistantRestore* self, GtkFileChooser* b) {
	GtkFileChooser* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_if_fail (b != NULL);
	_tmp0_ = b;
	_tmp1_ = gtk_file_chooser_get_filename (_tmp0_);
	_tmp2_ = _tmp1_;
	assistant_restore_set_restore_location (self, _tmp2_);
	_g_free0 (_tmp2_);
}


static void ___lambda31__gtk_file_chooser_selection_changed (GtkFileChooser* _sender, gpointer self) {
	__lambda31_ ((AssistantRestore*) self, _sender);
}


static GtkWidget* assistant_restore_make_restore_dest_page (AssistantRestore* self) {
	GtkWidget* result = NULL;
	GtkRadioButton* orig_radio = NULL;
	GtkRadioButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkRadioButton* cust_radio = NULL;
	GtkRadioButton* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkFileChooserButton* _tmp5_ = NULL;
	GtkFileChooserButton* _tmp6_ = NULL;
	GtkLabel* cust_label = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkFileChooserButton* _tmp12_ = NULL;
	GtkBox* _tmp13_ = NULL;
	GtkBox* _tmp14_ = NULL;
	GtkFileChooserButton* _tmp15_ = NULL;
	GtkBox* page = NULL;
	GtkBox* _tmp16_ = NULL;
	GtkBox* _tmp17_ = NULL;
	GtkBox* _tmp18_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_ref_sink (_tmp0_);
	orig_radio = _tmp0_;
	_tmp1_ = _ ("Restore files to _original locations");
	g_object_set ((GObject*) orig_radio, "label", _tmp1_, "use-underline", TRUE, NULL);
	g_signal_connect_object ((GtkToggleButton*) orig_radio, "toggled", (GCallback) ___lambda29__gtk_toggle_button_toggled, self, 0);
	_tmp2_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_ref_sink (_tmp2_);
	cust_radio = _tmp2_;
	_tmp3_ = _ ("Restore to _specific folder");
	g_object_set ((GObject*) cust_radio, "label", _tmp3_, "use-underline", TRUE, "group", orig_radio, NULL);
	g_signal_connect_object ((GtkToggleButton*) cust_radio, "toggled", (GCallback) ___lambda30__gtk_toggle_button_toggled, self, 0);
	_tmp4_ = _ ("Choose destination for restored files");
	_tmp5_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_tmp4_, GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->cust_button);
	self->priv->cust_button = _tmp5_;
	_tmp6_ = self->priv->cust_button;
	g_signal_connect_object ((GtkFileChooser*) _tmp6_, "selection-changed", (GCallback) ___lambda31__gtk_file_chooser_selection_changed, self, 0);
	_tmp7_ = _ ("Restore _folder");
	_tmp8_ = g_strconcat ("    ", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = (GtkLabel*) gtk_label_new (_tmp9_);
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	cust_label = _tmp11_;
	_tmp12_ = self->priv->cust_button;
	g_object_set ((GObject*) cust_label, "mnemonic-widget", _tmp12_, "use-underline", TRUE, "xalign", 1.0f, NULL);
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->cust_box);
	self->priv->cust_box = _tmp13_;
	_tmp14_ = self->priv->cust_box;
	_tmp15_ = self->priv->cust_button;
	g_object_set ((GObject*) _tmp14_, "child", cust_label, "child", _tmp15_, "sensitive", FALSE, NULL);
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp16_);
	page = _tmp16_;
	_tmp17_ = self->priv->cust_box;
	g_object_set ((GObject*) page, "child", orig_radio, "child", cust_radio, "child", _tmp17_, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) orig_radio, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) cust_radio, "expand", FALSE, NULL);
	_tmp18_ = self->priv->cust_box;
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) _tmp18_, "expand", FALSE, NULL);
	result = (GtkWidget*) page;
	_g_object_unref0 (cust_label);
	_g_object_unref0 (cust_radio);
	_g_object_unref0 (orig_radio);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GtkWidget* assistant_restore_real_make_confirm_page (AssistantOperation* base) {
	AssistantRestore * self;
	GtkWidget* result = NULL;
	gint rows = 0;
	GtkWidget* label = NULL;
	GtkWidget* w = NULL;
	GtkGrid* _tmp0_ = NULL;
	GtkGrid* page = NULL;
	GtkGrid* _tmp1_ = NULL;
	GtkGrid* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	DejaDupConfigLabelLocation* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	const gchar* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	GtkLabel* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	const gchar* _tmp19_ = NULL;
	GtkLabel* _tmp20_ = NULL;
	GtkLabel* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkLabel* _tmp23_ = NULL;
	GtkLabel* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GtkLabel* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GtkLabel* _tmp29_ = NULL;
	GtkLabel* _tmp30_ = NULL;
	GtkGrid* _tmp31_ = NULL;
	GtkGrid* _tmp32_ = NULL;
	GtkGrid* _tmp33_ = NULL;
	GtkGrid* _tmp34_ = NULL;
	GtkGrid* _tmp35_ = NULL;
	GtkLabel* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	GtkGrid* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	self = (AssistantRestore*) base;
	rows = 0;
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->confirm_table);
	self->priv->confirm_table = _tmp0_;
	_tmp1_ = self->priv->confirm_table;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	page = _tmp2_;
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 12, "border-width", 12, NULL);
	_tmp3_ = _ ("Backup location");
	_tmp4_ = (GtkLabel*) gtk_label_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (label);
	label = (GtkWidget*) _tmp4_;
	g_object_set ((GObject*) label, "xalign", 1.0f, "yalign", 0.0f, NULL);
	_tmp5_ = deja_dup_config_label_location_new ();
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (w);
	w = (GtkWidget*) _tmp5_;
	g_object_set ((GObject*) w, "hexpand", TRUE, NULL);
	_tmp6_ = rows;
	gtk_grid_attach (page, label, 0, _tmp6_, 1, 1);
	_tmp7_ = rows;
	gtk_grid_attach (page, w, 1, _tmp7_, 1, 1);
	_tmp8_ = rows;
	rows = _tmp8_ + 1;
	_tmp9_ = _ ("Restore date");
	_tmp10_ = (GtkLabel*) gtk_label_new (_tmp9_);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->confirm_date_label);
	self->priv->confirm_date_label = _tmp10_;
	_tmp11_ = self->priv->confirm_date_label;
	g_object_set ((GObject*) _tmp11_, "xalign", 1.0f, NULL);
	_tmp12_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->confirm_date);
	self->priv->confirm_date = _tmp12_;
	_tmp13_ = self->priv->confirm_date;
	g_object_set ((GObject*) _tmp13_, "xalign", 0.0f, NULL);
	_tmp14_ = self->priv->confirm_date_label;
	_tmp15_ = rows;
	gtk_grid_attach (page, (GtkWidget*) _tmp14_, 0, _tmp15_, 1, 1);
	_tmp16_ = self->priv->confirm_date;
	_tmp17_ = rows;
	gtk_grid_attach (page, (GtkWidget*) _tmp16_, 1, _tmp17_, 1, 1);
	_tmp18_ = rows;
	rows = _tmp18_ + 1;
	_tmp19_ = _ ("Restore folder");
	_tmp20_ = (GtkLabel*) gtk_label_new (_tmp19_);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->confirm_location_label);
	self->priv->confirm_location_label = _tmp20_;
	_tmp21_ = self->priv->confirm_location_label;
	g_object_set ((GObject*) _tmp21_, "xalign", 1.0f, NULL);
	_tmp22_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->confirm_location);
	self->priv->confirm_location = _tmp22_;
	_tmp23_ = self->priv->confirm_location;
	g_object_set ((GObject*) _tmp23_, "xalign", 0.0f, NULL);
	_tmp24_ = self->priv->confirm_location_label;
	_tmp25_ = rows;
	gtk_grid_attach (page, (GtkWidget*) _tmp24_, 0, _tmp25_, 1, 1);
	_tmp26_ = self->priv->confirm_location;
	_tmp27_ = rows;
	gtk_grid_attach (page, (GtkWidget*) _tmp26_, 1, _tmp27_, 1, 1);
	_tmp28_ = rows;
	rows = _tmp28_ + 1;
	_tmp29_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->confirm_files_label);
	self->priv->confirm_files_label = _tmp29_;
	_tmp30_ = self->priv->confirm_files_label;
	g_object_set ((GObject*) _tmp30_, "xalign", 1.0f, "yalign", 0.0f, NULL);
	_tmp31_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->confirm_files);
	self->priv->confirm_files = _tmp31_;
	_tmp32_ = self->priv->confirm_files;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp32_, GTK_ORIENTATION_VERTICAL);
	_tmp33_ = self->priv->confirm_files;
	gtk_grid_set_row_spacing (_tmp33_, 6);
	_tmp34_ = self->priv->confirm_files;
	gtk_grid_set_column_spacing (_tmp34_, 6);
	_tmp35_ = self->priv->confirm_files;
	gtk_grid_set_row_homogeneous (_tmp35_, TRUE);
	_tmp36_ = self->priv->confirm_files_label;
	_tmp37_ = rows;
	gtk_grid_attach (page, (GtkWidget*) _tmp36_, 0, _tmp37_, 1, 1);
	_tmp38_ = self->priv->confirm_files;
	_tmp39_ = rows;
	gtk_grid_attach (page, (GtkWidget*) _tmp38_, 1, _tmp39_, 1, 1);
	_tmp40_ = rows;
	rows = _tmp40_ + 1;
	result = (GtkWidget*) page;
	_g_object_unref0 (w);
	_g_object_unref0 (label);
	return result;
}


static void assistant_restore_add_query_backend_page (AssistantRestore* self) {
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_restore_make_query_backend_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_PROGRESS);
	_tmp1_ = _ ("Checking for Backups…");
	assistant_set_page_title ((Assistant*) self, page, _tmp1_);
	_tmp2_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->query_progress_page);
	self->priv->query_progress_page = _tmp2_;
	_g_object_unref0 (page);
}


static void assistant_restore_add_date_page (AssistantRestore* self) {
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_restore_make_date_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_NORMAL);
	_tmp1_ = _ ("Restore From When?");
	assistant_set_page_title ((Assistant*) self, page, _tmp1_);
	_tmp2_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->date_page);
	self->priv->date_page = _tmp2_;
	_g_object_unref0 (page);
}


static void assistant_restore_add_restore_dest_page (AssistantRestore* self) {
	GtkWidget* page = NULL;
	GtkWidget* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = assistant_restore_make_restore_dest_page (self);
	page = _tmp0_;
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_NORMAL);
	_tmp1_ = _ ("Restore to Where?");
	assistant_set_page_title ((Assistant*) self, page, _tmp1_);
	_tmp2_ = _g_object_ref0 (page);
	_g_object_unref0 (self->priv->restore_dest_page);
	self->priv->restore_dest_page = _tmp2_;
	_g_object_unref0 (page);
}


static DejaDupOperation* assistant_restore_real_create_op (AssistantOperation* base) {
	AssistantRestore * self;
	DejaDupOperation* result = NULL;
	gchar* date = NULL;
	gboolean _tmp0_ = FALSE;
	DejaDupOperationRestore* rest_op = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GList* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	DejaDupOperationRestore* _tmp10_ = NULL;
	DejaDupOperationState* _tmp11_ = NULL;
	self = (AssistantRestore*) base;
	date = NULL;
	_tmp0_ = self->priv->got_dates;
	if (_tmp0_) {
		GtkTreeIter iter = {0};
		GtkComboBoxText* _tmp1_ = NULL;
		GtkTreeIter _tmp2_ = {0};
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->priv->date_combo;
		_tmp3_ = gtk_combo_box_get_active_iter ((GtkComboBox*) _tmp1_, &_tmp2_);
		iter = _tmp2_;
		if (_tmp3_) {
			GtkListStore* _tmp4_ = NULL;
			GtkTreeIter _tmp5_ = {0};
			_tmp4_ = self->priv->date_store;
			_tmp5_ = iter;
			gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, 1, &date, -1);
		}
	}
	gtk_widget_realize ((GtkWidget*) self);
	_tmp6_ = self->priv->_restore_location;
	_tmp7_ = date;
	_tmp8_ = assistant_restore_get_restore_files (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = deja_dup_operation_restore_new (_tmp6_, _tmp7_, _tmp9_);
	rest_op = _tmp10_;
	_tmp11_ = self->op_state;
	if (_tmp11_ != NULL) {
		DejaDupOperationRestore* _tmp12_ = NULL;
		DejaDupOperationState* _tmp13_ = NULL;
		_tmp12_ = rest_op;
		_tmp13_ = self->op_state;
		deja_dup_operation_set_state ((DejaDupOperation*) _tmp12_, _tmp13_);
	}
	result = (DejaDupOperation*) rest_op;
	_g_free0 (date);
	return result;
}


static gchar* assistant_restore_real_get_progress_file_prefix (AssistantOperation* base) {
	AssistantRestore * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (AssistantRestore*) base;
	_tmp0_ = _ ("Restoring:");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean assistant_restore_is_same_day (AssistantRestore* self, GTimeVal* one, GTimeVal* two) {
	gboolean result = FALSE;
	GDate day1 = {0};
	GDate day2 = {0};
	GTimeVal _tmp0_ = {0};
	GTimeVal _tmp1_ = {0};
	GDate _tmp2_ = {0};
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (one != NULL, FALSE);
	g_return_val_if_fail (two != NULL, FALSE);
	memset (&day1, 0, sizeof (GDate));
	memset (&day2, 0, sizeof (GDate));
	_tmp0_ = *one;
	g_date_set_time_val (&day1, &_tmp0_);
	_tmp1_ = *two;
	g_date_set_time_val (&day2, &_tmp1_);
	_tmp2_ = day2;
	_tmp3_ = g_date_compare (&day1, &_tmp2_);
	result = _tmp3_ == 0;
	return result;
}


static GTimeVal* _g_time_val_dup (GTimeVal* self) {
	GTimeVal* dup;
	dup = g_new0 (GTimeVal, 1);
	memcpy (dup, self, sizeof (GTimeVal));
	return dup;
}


static gpointer __g_time_val_dup0 (gpointer self) {
	return self ? _g_time_val_dup (self) : NULL;
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* buffer = NULL;
	gchar* _tmp0_ = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 64);
	buffer = _tmp0_;
	buffer_length1 = 64;
	_buffer_size_ = buffer_length1;
	_tmp1_ = buffer;
	_tmp1__length1 = buffer_length1;
	_tmp2_ = format;
	strftime (_tmp1_, _tmp1__length1, _tmp2_, &(*self));
	_tmp3_ = buffer;
	_tmp3__length1 = buffer_length1;
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
	result = _tmp4_;
	buffer = (g_free (buffer), NULL);
	return result;
}


static void _g_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static void assistant_restore_real_handle_collection_dates (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates) {
	GList* timevals = NULL;
	GTimeVal tv = {0};
	GtkListStore* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GtkListStore* _tmp50_ = NULL;
	gint _tmp51_ = 0;
	g_return_if_fail (op != NULL);
	timevals = NULL;
	g_get_current_time (&tv);
	self->priv->got_dates = TRUE;
	_tmp0_ = self->priv->date_store;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = dates;
	{
		GList* date_collection = NULL;
		GList* date_it = NULL;
		date_collection = _tmp1_;
		for (date_it = date_collection; date_it != NULL; date_it = date_it->next) {
			gchar* _tmp2_ = NULL;
			gchar* date = NULL;
			_tmp2_ = g_strdup ((const gchar*) date_it->data);
			date = _tmp2_;
			{
				const gchar* _tmp3_ = NULL;
				gboolean _tmp4_ = FALSE;
				_tmp3_ = date;
				_tmp4_ = g_time_val_from_iso8601 (_tmp3_, &tv);
				if (_tmp4_) {
					GTimeVal _tmp5_ = {0};
					GTimeVal* _tmp6_ = NULL;
					_tmp5_ = tv;
					_tmp6_ = __g_time_val_dup0 (&_tmp5_);
					timevals = g_list_append (timevals, _tmp6_);
				}
				_g_free0 (date);
			}
		}
	}
	{
		GList* i = NULL;
		GList* _tmp7_ = NULL;
		_tmp7_ = timevals;
		i = _tmp7_;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				GList* _tmp11_ = NULL;
				GList* _tmp12_ = NULL;
				gconstpointer _tmp13_ = NULL;
				gchar* format = NULL;
				gchar* _tmp14_ = NULL;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				GList* _tmp17_ = NULL;
				GList* _tmp18_ = NULL;
				struct tm t = {0};
				GTimeVal _tmp36_ = {0};
				glong _tmp37_ = 0L;
				struct tm _tmp38_ = {0};
				gchar* user_str = NULL;
				const gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp41_ = NULL;
				GtkTreeIter _tmp42_ = {0};
				GtkListStore* _tmp43_ = NULL;
				GtkTreeIter _tmp44_ = {0};
				const gchar* _tmp45_ = NULL;
				gchar* _tmp46_ = NULL;
				gchar* _tmp47_ = NULL;
				GtkComboBoxText* _tmp48_ = NULL;
				GtkTreeIter _tmp49_ = {0};
				if (!_tmp8_) {
					GList* _tmp9_ = NULL;
					GList* _tmp10_ = NULL;
					_tmp9_ = i;
					_tmp10_ = _tmp9_->next;
					i = _tmp10_;
				}
				_tmp8_ = FALSE;
				_tmp11_ = i;
				if (!(_tmp11_ != NULL)) {
					break;
				}
				_tmp12_ = i;
				_tmp13_ = _tmp12_->data;
				tv = *((GTimeVal*) _tmp13_);
				_tmp14_ = g_strdup ("%x");
				format = _tmp14_;
				_tmp17_ = i;
				_tmp18_ = _tmp17_->prev;
				if (_tmp18_ != NULL) {
					GList* _tmp19_ = NULL;
					GList* _tmp20_ = NULL;
					gconstpointer _tmp21_ = NULL;
					GTimeVal _tmp22_ = {0};
					GTimeVal _tmp23_ = {0};
					gboolean _tmp24_ = FALSE;
					_tmp19_ = i;
					_tmp20_ = _tmp19_->prev;
					_tmp21_ = _tmp20_->data;
					_tmp22_ = tv;
					_tmp23_ = *((GTimeVal*) _tmp21_);
					_tmp24_ = assistant_restore_is_same_day (self, &_tmp23_, &_tmp22_);
					_tmp16_ = _tmp24_;
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					_tmp15_ = TRUE;
				} else {
					gboolean _tmp25_ = FALSE;
					GList* _tmp26_ = NULL;
					GList* _tmp27_ = NULL;
					_tmp26_ = i;
					_tmp27_ = _tmp26_->next;
					if (_tmp27_ != NULL) {
						GList* _tmp28_ = NULL;
						GList* _tmp29_ = NULL;
						gconstpointer _tmp30_ = NULL;
						GTimeVal _tmp31_ = {0};
						GTimeVal _tmp32_ = {0};
						gboolean _tmp33_ = FALSE;
						_tmp28_ = i;
						_tmp29_ = _tmp28_->next;
						_tmp30_ = _tmp29_->data;
						_tmp31_ = tv;
						_tmp32_ = *((GTimeVal*) _tmp30_);
						_tmp33_ = assistant_restore_is_same_day (self, &_tmp32_, &_tmp31_);
						_tmp25_ = _tmp33_;
					} else {
						_tmp25_ = FALSE;
					}
					_tmp15_ = _tmp25_;
				}
				if (_tmp15_) {
					const gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					_tmp34_ = _ ("%x %X");
					_tmp35_ = g_strdup (_tmp34_);
					_g_free0 (format);
					format = _tmp35_;
				}
				_tmp36_ = tv;
				_tmp37_ = _tmp36_.tv_sec;
				g_time_local ((time_t) _tmp37_, &_tmp38_);
				t = _tmp38_;
				_tmp39_ = format;
				_tmp40_ = g_time_format (&t, _tmp39_);
				user_str = _tmp40_;
				_tmp41_ = self->priv->date_store;
				gtk_list_store_prepend (_tmp41_, &_tmp42_);
				iter = _tmp42_;
				_tmp43_ = self->priv->date_store;
				_tmp44_ = iter;
				_tmp45_ = user_str;
				_tmp46_ = g_time_val_to_iso8601 (&tv);
				_tmp47_ = _tmp46_;
				gtk_list_store_set (_tmp43_, &_tmp44_, 0, _tmp45_, 1, _tmp47_, -1);
				_g_free0 (_tmp47_);
				_tmp48_ = self->priv->date_combo;
				_tmp49_ = iter;
				gtk_combo_box_set_active_iter ((GtkComboBox*) _tmp48_, &_tmp49_);
				_g_free0 (user_str);
				_g_free0 (format);
			}
		}
	}
	_tmp50_ = self->priv->date_store;
	_tmp51_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp50_, NULL);
	if (_tmp51_ == 0) {
		const gchar* _tmp52_ = NULL;
		_tmp52_ = _ ("No backups to restore");
		assistant_operation_show_error ((AssistantOperation*) self, _tmp52_, NULL);
	}
	__g_list_free__g_free0_0 (timevals);
}


void assistant_restore_handle_collection_dates (AssistantRestore* self, DejaDupOperationStatus* op, GList* dates) {
	g_return_if_fail (self != NULL);
	ASSISTANT_RESTORE_GET_CLASS (self)->handle_collection_dates (self, op, dates);
}


static void assistant_restore_real_query_finished (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail) {
	DejaDupOperation* _tmp0_ = NULL;
	DejaDupOperationState* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (op != NULL);
	_tmp0_ = op;
	_tmp1_ = deja_dup_operation_get_state (_tmp0_);
	_deja_dup_operation_state_unref0 (self->op_state);
	self->op_state = _tmp1_;
	_g_object_unref0 (self->query_op);
	self->query_op = NULL;
	_g_object_unref0 (((AssistantOperation*) self)->op);
	((AssistantOperation*) self)->op = NULL;
	_tmp2_ = cancelled;
	if (_tmp2_) {
		assistant_operation_do_close ((AssistantOperation*) self);
	} else {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = success;
		if (_tmp3_) {
			assistant_go_forward ((Assistant*) self);
		}
	}
}


void assistant_restore_query_finished (AssistantRestore* self, DejaDupOperation* op, gboolean success, gboolean cancelled, const gchar* detail) {
	g_return_if_fail (self != NULL);
	ASSISTANT_RESTORE_GET_CLASS (self)->query_finished (self, op, success, cancelled, detail);
}


static gboolean assistant_restore_query_pulse (AssistantRestore* self) {
	gboolean result = FALSE;
	GtkProgressBar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->query_progress_bar;
	gtk_progress_bar_pulse (_tmp0_);
	result = TRUE;
	return result;
}


static void assistant_restore_do_query_data_free (gpointer _data) {
	AssistantRestoreDoQueryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AssistantRestoreDoQueryData, _data_);
}


void assistant_restore_do_query (AssistantRestore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AssistantRestoreDoQueryData* _data_;
	AssistantRestore* _tmp0_ = NULL;
	_data_ = g_slice_new0 (AssistantRestoreDoQueryData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, assistant_restore_do_query);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, assistant_restore_do_query_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	assistant_restore_do_query_co (_data_);
}


void assistant_restore_do_query_finish (AssistantRestore* self, GAsyncResult* _res_) {
	AssistantRestoreDoQueryData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _assistant_restore_query_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, const gchar* detail, gpointer self) {
	assistant_restore_query_finished ((AssistantRestore*) self, _sender, success, cancelled, detail);
}


static void __lambda32_ (AssistantRestore* self, DejaDupOperation* o, const gchar* e, const gchar* d) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (o != NULL);
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	_tmp1_ = d;
	assistant_operation_show_error ((AssistantOperation*) self, _tmp0_, _tmp1_);
}


static void ___lambda32__deja_dup_operation_raise_error (DejaDupOperation* _sender, const gchar* errstr, const gchar* detail, gpointer self) {
	__lambda32_ ((AssistantRestore*) self, _sender, errstr, detail);
}


static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self) {
	assistant_operation_get_passphrase ((AssistantOperation*) self);
}


static void _assistant_restore_handle_collection_dates_deja_dup_operation_status_collection_dates (DejaDupOperationStatus* _sender, GList* dates, gpointer self) {
	assistant_restore_handle_collection_dates ((AssistantRestore*) self, _sender, dates);
}


static void _assistant_operation_pause_op_deja_dup_backend_pause_op (DejaDupBackend* _sender, const gchar* header, const gchar* msg, gpointer self) {
	assistant_operation_pause_op ((AssistantOperation*) self, _sender, header, msg);
}


static gboolean assistant_restore_do_query_co (AssistantRestoreDoQueryData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	gtk_widget_realize ((GtkWidget*) _data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = deja_dup_operation_status_new ();
	_g_object_unref0 (_data_->self->query_op);
	_data_->self->query_op = _data_->_tmp0_;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->query_op;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _g_object_ref0 ((DejaDupOperation*) _data_->_tmp1_);
	_g_object_unref0 (((AssistantOperation*) _data_->self)->op);
	((AssistantOperation*) _data_->self)->op = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = ((AssistantOperation*) _data_->self)->op;
	g_signal_connect_object (_data_->_tmp3_, "done", (GCallback) _assistant_restore_query_finished_deja_dup_operation_done, _data_->self, 0);
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = ((AssistantOperation*) _data_->self)->op;
	g_signal_connect_object (_data_->_tmp4_, "raise-error", (GCallback) ___lambda32__deja_dup_operation_raise_error, _data_->self, 0);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = ((AssistantOperation*) _data_->self)->op;
	g_signal_connect_object (_data_->_tmp5_, "passphrase-required", (GCallback) _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required, (AssistantOperation*) _data_->self, 0);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->self->query_op;
	g_signal_connect_object (_data_->_tmp6_, "collection-dates", (GCallback) _assistant_restore_handle_collection_dates_deja_dup_operation_status_collection_dates, _data_->self, 0);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = ((AssistantOperation*) _data_->self)->op;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = deja_dup_operation_get_backend (_data_->_tmp7_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = mount_operation_assistant_new ((AssistantOperation*) _data_->self);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_;
	deja_dup_backend_set_mount_op (_data_->_tmp9_, (GMountOperation*) _data_->_tmp11_);
	_g_object_unref0 (_data_->_tmp11_);
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = ((AssistantOperation*) _data_->self)->op;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = deja_dup_operation_get_backend (_data_->_tmp12_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->_tmp13_;
	g_signal_connect_object (_data_->_tmp14_, "pause-op", (GCallback) _assistant_operation_pause_op_deja_dup_backend_pause_op, (AssistantOperation*) _data_->self, 0);
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = ((AssistantOperation*) _data_->self)->op;
	deja_dup_operation_start (_data_->_tmp15_, TRUE, NULL, NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void ______lambda33_ (AssistantRestore* self, GtkWidget* w) {
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (w != NULL);
	_tmp0_ = w;
	deja_dup_destroy_widget (_tmp0_);
}


static void _______lambda33__gtk_callback (GtkWidget* widget, gpointer self) {
	______lambda33_ ((AssistantRestore*) self, widget);
}


static gboolean _assistant_restore_query_pulse_gsource_func (gpointer self) {
	gboolean result;
	result = assistant_restore_query_pulse ((AssistantRestore*) self);
	return result;
}


static void assistant_restore_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page) {
	AssistantRestore * self;
	Assistant* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GtkWidget* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	self = (AssistantRestore*) base;
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	_tmp0_ = assist;
	_tmp1_ = page;
	ASSISTANT_OPERATION_CLASS (assistant_restore_parent_class)->do_prepare (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ASSISTANT_OPERATION, AssistantOperation), _tmp0_, _tmp1_);
	_tmp2_ = self->priv->query_timeout_id;
	if (_tmp2_ > ((guint) 0)) {
		guint _tmp3_ = 0U;
		_tmp3_ = self->priv->query_timeout_id;
		g_source_remove (_tmp3_);
		self->priv->query_timeout_id = (guint) 0;
	}
	_tmp4_ = page;
	_tmp5_ = self->priv->date_page;
	if (_tmp4_ == _tmp5_) {
		gboolean _tmp6_ = FALSE;
		_tmp6_ = self->priv->got_dates;
		if (!_tmp6_) {
			assistant_skip ((Assistant*) self);
		}
	} else {
		GtkWidget* _tmp7_ = NULL;
		GtkWidget* _tmp8_ = NULL;
		_tmp7_ = page;
		_tmp8_ = self->priv->restore_dest_page;
		if (_tmp7_ == _tmp8_) {
			GList* _tmp9_ = NULL;
			GList* _tmp10_ = NULL;
			_tmp9_ = assistant_restore_get_restore_files (self);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				assistant_skip ((Assistant*) self);
			}
		} else {
			GtkWidget* _tmp11_ = NULL;
			GtkWidget* _tmp12_ = NULL;
			GtkWidget* _tmp13_ = NULL;
			_tmp11_ = page;
			_tmp12_ = assistant_operation_get_confirm_page ((AssistantOperation*) self);
			_tmp13_ = _tmp12_;
			if (_tmp11_ == _tmp13_) {
				gboolean _tmp14_ = FALSE;
				GList* _tmp23_ = NULL;
				GList* _tmp24_ = NULL;
				_tmp14_ = self->priv->got_dates;
				if (_tmp14_) {
					GtkLabel* _tmp15_ = NULL;
					GtkComboBoxText* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					GtkLabel* _tmp19_ = NULL;
					GtkLabel* _tmp20_ = NULL;
					_tmp15_ = self->priv->confirm_date;
					_tmp16_ = self->priv->date_combo;
					_tmp17_ = gtk_combo_box_text_get_active_text (_tmp16_);
					_tmp18_ = _tmp17_;
					gtk_label_set_label (_tmp15_, _tmp18_);
					_g_free0 (_tmp18_);
					_tmp19_ = self->priv->confirm_date_label;
					gtk_widget_show ((GtkWidget*) _tmp19_);
					_tmp20_ = self->priv->confirm_date;
					gtk_widget_show ((GtkWidget*) _tmp20_);
				} else {
					GtkLabel* _tmp21_ = NULL;
					GtkLabel* _tmp22_ = NULL;
					_tmp21_ = self->priv->confirm_date_label;
					gtk_widget_hide ((GtkWidget*) _tmp21_);
					_tmp22_ = self->priv->confirm_date;
					gtk_widget_hide ((GtkWidget*) _tmp22_);
				}
				_tmp23_ = assistant_restore_get_restore_files (self);
				_tmp24_ = _tmp23_;
				if (_tmp24_ == NULL) {
					const gchar* _tmp25_ = NULL;
					GtkLabel* _tmp34_ = NULL;
					GtkLabel* _tmp35_ = NULL;
					GtkLabel* _tmp36_ = NULL;
					GtkGrid* _tmp37_ = NULL;
					_tmp25_ = self->priv->_restore_location;
					if (g_strcmp0 (_tmp25_, "/") == 0) {
						GtkLabel* _tmp26_ = NULL;
						const gchar* _tmp27_ = NULL;
						_tmp26_ = self->priv->confirm_location;
						_tmp27_ = _ ("Original location");
						gtk_label_set_label (_tmp26_, _tmp27_);
					} else {
						GtkLabel* _tmp28_ = NULL;
						const gchar* _tmp29_ = NULL;
						GFile* _tmp30_ = NULL;
						GFile* _tmp31_ = NULL;
						gchar* _tmp32_ = NULL;
						gchar* _tmp33_ = NULL;
						_tmp28_ = self->priv->confirm_location;
						_tmp29_ = self->priv->_restore_location;
						_tmp30_ = g_file_new_for_path (_tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = deja_dup_get_file_desc (_tmp31_);
						_tmp33_ = _tmp32_;
						gtk_label_set_label (_tmp28_, _tmp33_);
						_g_free0 (_tmp33_);
						_g_object_unref0 (_tmp31_);
					}
					_tmp34_ = self->priv->confirm_location_label;
					gtk_widget_show ((GtkWidget*) _tmp34_);
					_tmp35_ = self->priv->confirm_location;
					gtk_widget_show ((GtkWidget*) _tmp35_);
					_tmp36_ = self->priv->confirm_files_label;
					gtk_widget_hide ((GtkWidget*) _tmp36_);
					_tmp37_ = self->priv->confirm_files;
					gtk_widget_hide ((GtkWidget*) _tmp37_);
				} else {
					GtkLabel* _tmp38_ = NULL;
					GList* _tmp39_ = NULL;
					GList* _tmp40_ = NULL;
					guint _tmp41_ = 0U;
					const gchar* _tmp42_ = NULL;
					GtkGrid* _tmp43_ = NULL;
					GList* _tmp44_ = NULL;
					GList* _tmp45_ = NULL;
					GtkLabel* _tmp59_ = NULL;
					GtkLabel* _tmp60_ = NULL;
					GtkLabel* _tmp61_ = NULL;
					GtkGrid* _tmp62_ = NULL;
					_tmp38_ = self->priv->confirm_files_label;
					_tmp39_ = assistant_restore_get_restore_files (self);
					_tmp40_ = _tmp39_;
					_tmp41_ = g_list_length (_tmp40_);
					_tmp42_ = g_dngettext (GETTEXT_PACKAGE, "File to restore", "Files to restore", (gulong) _tmp41_);
					gtk_label_set_label (_tmp38_, _tmp42_);
					_tmp43_ = self->priv->confirm_files;
					gtk_container_foreach ((GtkContainer*) _tmp43_, _______lambda33__gtk_callback, self);
					_tmp44_ = assistant_restore_get_restore_files (self);
					_tmp45_ = _tmp44_;
					{
						GList* f_collection = NULL;
						GList* f_it = NULL;
						f_collection = _tmp45_;
						for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
							GFile* _tmp46_ = NULL;
							GFile* f = NULL;
							_tmp46_ = _g_object_ref0 ((GFile*) f_it->data);
							f = _tmp46_;
							{
								gchar* parse_name = NULL;
								GFile* _tmp47_ = NULL;
								gchar* _tmp48_ = NULL;
								GtkLabel* file_label = NULL;
								const gchar* _tmp49_ = NULL;
								gchar* _tmp50_ = NULL;
								gchar* _tmp51_ = NULL;
								GtkLabel* _tmp52_ = NULL;
								GtkLabel* _tmp53_ = NULL;
								GtkLabel* _tmp54_ = NULL;
								const gchar* _tmp55_ = NULL;
								GtkLabel* _tmp56_ = NULL;
								GtkGrid* _tmp57_ = NULL;
								GtkLabel* _tmp58_ = NULL;
								_tmp47_ = f;
								_tmp48_ = g_file_get_parse_name (_tmp47_);
								parse_name = _tmp48_;
								_tmp49_ = parse_name;
								_tmp50_ = g_path_get_basename (_tmp49_);
								_tmp51_ = _tmp50_;
								_tmp52_ = (GtkLabel*) gtk_label_new (_tmp51_);
								g_object_ref_sink (_tmp52_);
								_tmp53_ = _tmp52_;
								_g_free0 (_tmp51_);
								file_label = _tmp53_;
								_tmp54_ = file_label;
								_tmp55_ = parse_name;
								gtk_widget_set_tooltip_text ((GtkWidget*) _tmp54_, _tmp55_);
								_tmp56_ = file_label;
								g_object_set ((GObject*) _tmp56_, "xalign", 0.0f, NULL);
								_tmp57_ = self->priv->confirm_files;
								_tmp58_ = file_label;
								gtk_container_add ((GtkContainer*) _tmp57_, (GtkWidget*) _tmp58_);
								_g_object_unref0 (file_label);
								_g_free0 (parse_name);
								_g_object_unref0 (f);
							}
						}
					}
					_tmp59_ = self->priv->confirm_location_label;
					gtk_widget_hide ((GtkWidget*) _tmp59_);
					_tmp60_ = self->priv->confirm_location;
					gtk_widget_hide ((GtkWidget*) _tmp60_);
					_tmp61_ = self->priv->confirm_files_label;
					gtk_widget_show ((GtkWidget*) _tmp61_);
					_tmp62_ = self->priv->confirm_files;
					gtk_widget_show_all ((GtkWidget*) _tmp62_);
				}
			} else {
				GtkWidget* _tmp63_ = NULL;
				GtkWidget* _tmp64_ = NULL;
				GtkWidget* _tmp65_ = NULL;
				_tmp63_ = page;
				_tmp64_ = assistant_operation_get_summary_page ((AssistantOperation*) self);
				_tmp65_ = _tmp64_;
				if (_tmp63_ == _tmp65_) {
					gboolean _tmp66_ = FALSE;
					gboolean _tmp67_ = FALSE;
					_tmp66_ = assistant_operation_get_error_occurred ((AssistantOperation*) self);
					_tmp67_ = _tmp66_;
					if (_tmp67_) {
						GtkWidget* _tmp68_ = NULL;
						const gchar* _tmp69_ = NULL;
						_tmp68_ = page;
						_tmp69_ = _ ("Restore Failed");
						assistant_set_page_title ((Assistant*) self, _tmp68_, _tmp69_);
					} else {
						GtkWidget* _tmp70_ = NULL;
						const gchar* _tmp71_ = NULL;
						GtkWidget* _tmp72_ = NULL;
						gboolean _tmp73_ = FALSE;
						_tmp70_ = page;
						_tmp71_ = _ ("Restore Finished");
						assistant_set_page_title ((Assistant*) self, _tmp70_, _tmp71_);
						_tmp72_ = ((AssistantOperation*) self)->detail_widget;
						_tmp73_ = gtk_widget_get_visible (_tmp72_);
						if (!_tmp73_) {
							GList* _tmp74_ = NULL;
							GList* _tmp75_ = NULL;
							_tmp74_ = assistant_restore_get_restore_files (self);
							_tmp75_ = _tmp74_;
							if (_tmp75_ == NULL) {
								GtkLabel* _tmp76_ = NULL;
								const gchar* _tmp77_ = NULL;
								_tmp76_ = ((AssistantOperation*) self)->summary_label;
								_tmp77_ = _ ("Your files were successfully restored.");
								gtk_label_set_label (_tmp76_, _tmp77_);
							} else {
								GtkLabel* _tmp78_ = NULL;
								GList* _tmp79_ = NULL;
								GList* _tmp80_ = NULL;
								guint _tmp81_ = 0U;
								const gchar* _tmp82_ = NULL;
								_tmp78_ = ((AssistantOperation*) self)->summary_label;
								_tmp79_ = assistant_restore_get_restore_files (self);
								_tmp80_ = _tmp79_;
								_tmp81_ = g_list_length (_tmp80_);
								_tmp82_ = g_dngettext (GETTEXT_PACKAGE, "Your file was successfully restored.", "Your files were successfully restored.", (gulong) _tmp81_);
								gtk_label_set_label (_tmp78_, _tmp82_);
							}
						}
					}
				} else {
					GtkWidget* _tmp83_ = NULL;
					GtkWidget* _tmp84_ = NULL;
					GtkWidget* _tmp85_ = NULL;
					_tmp83_ = page;
					_tmp84_ = assistant_operation_get_progress_page ((AssistantOperation*) self);
					_tmp85_ = _tmp84_;
					if (_tmp83_ == _tmp85_) {
						GtkWidget* _tmp86_ = NULL;
						const gchar* _tmp87_ = NULL;
						_tmp86_ = page;
						_tmp87_ = _ ("Restoring…");
						assistant_set_page_title ((Assistant*) self, _tmp86_, _tmp87_);
					} else {
						GtkWidget* _tmp88_ = NULL;
						GtkWidget* _tmp89_ = NULL;
						_tmp88_ = page;
						_tmp89_ = self->priv->query_progress_page;
						if (_tmp88_ == _tmp89_) {
							gboolean _tmp90_ = FALSE;
							gboolean _tmp91_ = FALSE;
							_tmp90_ = assistant_get_last_op_was_back ((Assistant*) self);
							_tmp91_ = _tmp90_;
							if (_tmp91_) {
								assistant_skip ((Assistant*) self);
							} else {
								GtkProgressBar* _tmp92_ = NULL;
								guint _tmp93_ = 0U;
								gboolean _tmp94_ = FALSE;
								DejaDupOperationStatus* _tmp95_ = NULL;
								_tmp92_ = self->priv->query_progress_bar;
								gtk_progress_bar_set_fraction (_tmp92_, (gdouble) 0);
								_tmp93_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _assistant_restore_query_pulse_gsource_func, g_object_ref (self), g_object_unref);
								self->priv->query_timeout_id = _tmp93_;
								_tmp95_ = self->query_op;
								if (_tmp95_ != NULL) {
									DejaDupOperationStatus* _tmp96_ = NULL;
									gboolean _tmp97_ = FALSE;
									gboolean _tmp98_ = FALSE;
									_tmp96_ = self->query_op;
									_tmp97_ = deja_dup_operation_get_needs_password ((DejaDupOperation*) _tmp96_);
									_tmp98_ = _tmp97_;
									_tmp94_ = _tmp98_;
								} else {
									_tmp94_ = FALSE;
								}
								if (_tmp94_) {
									assistant_operation_provide_password ((AssistantOperation*) self, NULL, NULL);
								} else {
									DejaDupOperationStatus* _tmp99_ = NULL;
									_tmp99_ = self->query_op;
									if (_tmp99_ == NULL) {
										assistant_restore_do_query (self, NULL, NULL);
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void assistant_restore_real_do_close (AssistantOperation* base) {
	AssistantRestore * self;
	guint _tmp0_ = 0U;
	self = (AssistantRestore*) base;
	_tmp0_ = self->priv->query_timeout_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->query_timeout_id;
		g_source_remove (_tmp1_);
		self->priv->query_timeout_id = (guint) 0;
	}
	ASSISTANT_OPERATION_CLASS (assistant_restore_parent_class)->do_close (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ASSISTANT_OPERATION, AssistantOperation));
}


AssistantRestore* assistant_restore_construct (GType object_type) {
	AssistantRestore * self = NULL;
	self = (AssistantRestore*) assistant_operation_construct (object_type);
	return self;
}


AssistantRestore* assistant_restore_new (void) {
	return assistant_restore_construct (TYPE_ASSISTANT_RESTORE);
}


const gchar* assistant_restore_get_restore_location (AssistantRestore* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_restore_location;
	result = _tmp0_;
	return result;
}


void assistant_restore_set_restore_location (AssistantRestore* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_restore_location);
	self->priv->_restore_location = _tmp1_;
	g_object_notify ((GObject *) self, "restore-location");
}


GList* assistant_restore_get_restore_files (AssistantRestore* self) {
	GList* result;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_restore_files;
	result = _tmp0_;
	return result;
}


void assistant_restore_set_restore_files (AssistantRestore* self, GList* value) {
	GList* _tmp0_ = NULL;
	GList* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->_restore_files;
	{
		GList* f_collection = NULL;
		GList* f_it = NULL;
		f_collection = _tmp0_;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp1_ = NULL;
			GFile* f = NULL;
			_tmp1_ = _g_object_ref0 ((GFile*) f_it->data);
			f = _tmp1_;
			{
				GFile* _tmp2_ = NULL;
				_tmp2_ = f;
				g_object_unref ((GObject*) _tmp2_);
				_g_object_unref0 (f);
			}
		}
	}
	_tmp3_ = value;
	_tmp4_ = g_list_copy (_tmp3_);
	__g_list_free__g_object_unref0_0 (self->_restore_files);
	self->_restore_files = _tmp4_;
	_tmp5_ = self->_restore_files;
	{
		GList* f_collection = NULL;
		GList* f_it = NULL;
		f_collection = _tmp5_;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp6_ = NULL;
			GFile* f = NULL;
			_tmp6_ = _g_object_ref0 ((GFile*) f_it->data);
			f = _tmp6_;
			{
				GFile* _tmp7_ = NULL;
				_tmp7_ = f;
				g_object_ref ((GObject*) _tmp7_);
				_g_object_unref0 (f);
			}
		}
	}
	g_object_notify ((GObject *) self, "restore-files");
}


static GObject * assistant_restore_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AssistantRestore * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (assistant_restore_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASSISTANT_RESTORE, AssistantRestore);
	_tmp0_ = _ ("Restore");
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
	_tmp1_ = _ ("_Restore");
	assistant_set_apply_text ((Assistant*) self, _tmp1_);
	return obj;
}


static void assistant_restore_class_init (AssistantRestoreClass * klass) {
	assistant_restore_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantRestorePrivate));
	((AssistantOperationClass *) klass)->add_setup_pages = assistant_restore_real_add_setup_pages;
	((AssistantOperationClass *) klass)->add_custom_config_pages = assistant_restore_real_add_custom_config_pages;
	((AssistantOperationClass *) klass)->make_confirm_page = assistant_restore_real_make_confirm_page;
	((AssistantOperationClass *) klass)->create_op = assistant_restore_real_create_op;
	((AssistantOperationClass *) klass)->get_progress_file_prefix = assistant_restore_real_get_progress_file_prefix;
	((AssistantRestoreClass *) klass)->handle_collection_dates = assistant_restore_real_handle_collection_dates;
	((AssistantRestoreClass *) klass)->query_finished = assistant_restore_real_query_finished;
	((AssistantOperationClass *) klass)->do_prepare = assistant_restore_real_do_prepare;
	((AssistantOperationClass *) klass)->do_close = assistant_restore_real_do_close;
	G_OBJECT_CLASS (klass)->get_property = _vala_assistant_restore_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_assistant_restore_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_restore_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_restore_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_RESTORE_RESTORE_LOCATION, g_param_spec_string ("restore-location", "restore-location", "restore-location", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_RESTORE_RESTORE_FILES, g_param_spec_pointer ("restore-files", "restore-files", "restore-files", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void assistant_restore_instance_init (AssistantRestore * self) {
	gchar* _tmp0_ = NULL;
	self->priv = ASSISTANT_RESTORE_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("/");
	self->priv->_restore_location = _tmp0_;
}


static void assistant_restore_finalize (GObject* obj) {
	AssistantRestore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ASSISTANT_RESTORE, AssistantRestore);
	_g_free0 (self->priv->_restore_location);
	__g_list_free__g_object_unref0_0 (self->_restore_files);
	_g_object_unref0 (self->query_op);
	_deja_dup_operation_state_unref0 (self->op_state);
	_g_object_unref0 (self->priv->query_progress_bar);
	_g_object_unref0 (self->priv->date_combo);
	_g_object_unref0 (self->priv->date_store);
	_g_object_unref0 (self->priv->cust_box);
	_g_object_unref0 (self->priv->cust_button);
	_g_object_unref0 (self->priv->confirm_table);
	_g_object_unref0 (self->priv->confirm_location_label);
	_g_object_unref0 (self->priv->confirm_location);
	_g_object_unref0 (self->priv->confirm_date_label);
	_g_object_unref0 (self->priv->confirm_date);
	_g_object_unref0 (self->priv->confirm_files_label);
	_g_object_unref0 (self->priv->confirm_files);
	_g_object_unref0 (self->priv->query_progress_page);
	_g_object_unref0 (self->priv->date_page);
	_g_object_unref0 (self->priv->restore_dest_page);
	G_OBJECT_CLASS (assistant_restore_parent_class)->finalize (obj);
}


GType assistant_restore_get_type (void) {
	static volatile gsize assistant_restore_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_restore_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantRestoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_restore_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantRestore), 0, (GInstanceInitFunc) assistant_restore_instance_init, NULL };
		GType assistant_restore_type_id;
		assistant_restore_type_id = g_type_register_static (TYPE_ASSISTANT_OPERATION, "AssistantRestore", &g_define_type_info, 0);
		g_once_init_leave (&assistant_restore_type_id__volatile, assistant_restore_type_id);
	}
	return assistant_restore_type_id__volatile;
}


static void _vala_assistant_restore_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AssistantRestore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASSISTANT_RESTORE, AssistantRestore);
	switch (property_id) {
		case ASSISTANT_RESTORE_RESTORE_LOCATION:
		g_value_set_string (value, assistant_restore_get_restore_location (self));
		break;
		case ASSISTANT_RESTORE_RESTORE_FILES:
		g_value_set_pointer (value, assistant_restore_get_restore_files (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_assistant_restore_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AssistantRestore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ASSISTANT_RESTORE, AssistantRestore);
	switch (property_id) {
		case ASSISTANT_RESTORE_RESTORE_LOCATION:
		assistant_restore_set_restore_location (self, g_value_get_string (value));
		break;
		case ASSISTANT_RESTORE_RESTORE_FILES:
		assistant_restore_set_restore_files (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



