/* chess-state.c generated by valac 0.38.0.11-8bd7f, the Vala compiler
 * generated from chess-state.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2014 Robert Ancell
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;
typedef struct _ChessStatePrivate ChessStatePrivate;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
enum  {
	CHESS_STATE_DUMMY_PROPERTY,
	CHESS_STATE_OPPONENT_PROPERTY,
	CHESS_STATE_LAST_PROPERTY
};
static GParamSpec* chess_state_properties[CHESS_STATE_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_COLOR (color_get_type ())

#define TYPE_PIECE_TYPE (piece_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;
typedef struct _ChessPiecePrivate ChessPiecePrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ChessMovePrivate ChessMovePrivate;

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_RESULT (chess_result_get_type ())

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessState {
	GObject parent_instance;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GObjectClass parent_class;
};

struct _ChessStatePrivate {
	gint64 piece_masks[2];
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};

struct _ChessPiece {
	GObject parent_instance;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GObjectClass parent_class;
};

struct _ChessMove {
	GObject parent_instance;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GObjectClass parent_class;
};

typedef enum  {
	CHESS_RULE_UNKNOWN,
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_SEVENTY_FIVE_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_FIVE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH,
	CHESS_RULE_BUG
} ChessRule;

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW,
	CHESS_RESULT_BUG
} ChessResult;


static gpointer chess_state_parent_class = NULL;

GType check_state_get_type (void) G_GNUC_CONST;
GType chess_state_get_type (void) G_GNUC_CONST;
GType chess_player_get_type (void) G_GNUC_CONST;
GType chess_piece_get_type (void) G_GNUC_CONST;
GType chess_move_get_type (void) G_GNUC_CONST;
#define CHESS_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_STATE, ChessStatePrivate))
static ChessState* chess_state_new_empty (void);
static ChessState* chess_state_construct_empty (GType object_type);
ChessState* chess_state_new (const gchar* fen);
ChessState* chess_state_construct (GType object_type, const gchar* fen);
GType color_get_type (void) G_GNUC_CONST;
ChessPlayer* chess_player_new (Color color);
ChessPlayer* chess_player_construct (GType object_type, Color color);
GType piece_type_get_type (void) G_GNUC_CONST;
static gboolean chess_state_decode_piece_type (ChessState* self, gunichar c, PieceType* type);
gint chess_state_get_index (ChessState* self, gint rank, gint file);
ChessPiece* chess_piece_new (ChessPlayer* player, PieceType type);
ChessPiece* chess_piece_construct (GType object_type, ChessPlayer* player, PieceType type);
static CheckState chess_state_get_check_state (ChessState* self, ChessPlayer* player);
ChessState* chess_state_copy (ChessState* self);
ChessMove* chess_move_copy (ChessMove* self);
gboolean chess_state_equals (ChessState* self, ChessState* state);
gchar* chess_state_get_fen (ChessState* self);
gunichar chess_piece_get_symbol (ChessPiece* self);
gint chess_state_get_file (ChessState* self, gint index);
gint chess_state_get_rank (ChessState* self, gint index);
gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply);
static gboolean chess_state_decode_move (ChessState* self, ChessPlayer* player, const gchar* move, gint* r0, gint* f0, gint* r1, gint* f1, PieceType* promotion_type);
gboolean chess_state_move_with_coords (ChessState* self, ChessPlayer* player, gint r0, gint f0, gint r1, gint f1, PieceType promotion_type, gboolean apply, gboolean test_check);
Color chess_piece_get_color (ChessPiece* self);
gboolean chess_state_is_in_check (ChessState* self, ChessPlayer* player);
ChessMove* chess_move_new (void);
ChessMove* chess_move_construct (GType object_type);
GType chess_rule_get_type (void) G_GNUC_CONST;
GType chess_result_get_type (void) G_GNUC_CONST;
ChessResult chess_state_get_result (ChessState* self, ChessRule* rule);
static gboolean chess_state_can_move (ChessState* self, ChessPlayer* player);
gboolean chess_state_have_sufficient_material (ChessState* self);
static gboolean chess_state_is_in_checkmate (ChessState* self, ChessPlayer* player);
ChessPlayer* chess_state_get_opponent (ChessState* self);
static void chess_state_finalize (GObject * obj);
static void _vala_chess_state_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

extern const gint64 BIT_BOARD_set_location_masks[64];
extern const gint64 BIT_BOARD_move_masks[768];
extern const gint64 BIT_BOARD_over_masks[4096];
extern const gint64 BIT_BOARD_clear_location_masks[64];

GType check_state_get_type (void) {
	static volatile gsize check_state_type_id__volatile = 0;
	if (g_once_init_enter (&check_state_type_id__volatile)) {
		static const GEnumValue values[] = {{CHECK_STATE_NONE, "CHECK_STATE_NONE", "none"}, {CHECK_STATE_CHECK, "CHECK_STATE_CHECK", "check"}, {CHECK_STATE_CHECKMATE, "CHECK_STATE_CHECKMATE", "checkmate"}, {0, NULL, NULL}};
		GType check_state_type_id;
		check_state_type_id = g_enum_register_static ("CheckState", values);
		g_once_init_leave (&check_state_type_id__volatile, check_state_type_id);
	}
	return check_state_type_id__volatile;
}


static ChessState* chess_state_construct_empty (GType object_type) {
	ChessState * self = NULL;
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self = (ChessState*) g_object_new (object_type, NULL);
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return self;
#line 267 "chess-state.c"
}


static ChessState* chess_state_new_empty (void) {
#line 41 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return chess_state_construct_empty (TYPE_CHESS_STATE);
#line 274 "chess-state.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
#line 1118 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1119 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1119 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1119 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1119 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	return result;
#line 292 "chess-state.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 80 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return self ? g_object_ref (self) : NULL;
#line 299 "chess-state.c"
}


ChessState* chess_state_construct (GType object_type, const gchar* fen) {
	ChessState * self = NULL;
	ChessPlayer* _tmp0_;
	ChessPlayer* _tmp1_;
	ChessPlayer* _tmp2_;
	ChessPlayer* _tmp3_;
	gchar** fields = NULL;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint fields_length1;
	gint _fields_size_;
	gchar** ranks = NULL;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint ranks_length1;
	gint _ranks_size_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	const gchar* _tmp63_;
	gchar** _tmp70_;
	gint _tmp70__length1;
	const gchar* _tmp71_;
	gchar** _tmp91_;
	gint _tmp91__length1;
	const gchar* _tmp92_;
	gchar** _tmp100_;
	gint _tmp100__length1;
	const gchar* _tmp101_;
	gint _tmp102_;
	gchar** _tmp103_;
	gint _tmp103__length1;
	const gchar* _tmp104_;
	gint _tmp105_;
	ChessPlayer* _tmp106_;
	Color _tmp107_;
	ChessPlayer* _tmp109_;
	CheckState _tmp110_;
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (fen != NULL, NULL);
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self = (ChessState*) g_object_new (object_type, NULL);
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp0_ = chess_player_new (COLOR_WHITE);
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (self->players[COLOR_WHITE]);
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->players[COLOR_WHITE] = _tmp0_;
#line 48 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp1_ = self->players[COLOR_WHITE];
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp2_ = chess_player_new (COLOR_BLACK);
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (self->players[COLOR_BLACK]);
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->players[COLOR_BLACK] = _tmp2_;
#line 49 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp3_ = self->players[COLOR_BLACK];
#line 364 "chess-state.c"
	{
		gint i = 0;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		i = 0;
#line 369 "chess-state.c"
		{
			gboolean _tmp4_ = FALSE;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp4_ = TRUE;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 376 "chess-state.c"
				gint _tmp6_;
				gint _tmp7_;
				ChessPiece* _tmp8_;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!_tmp4_) {
#line 382 "chess-state.c"
					gint _tmp5_;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp5_ = i;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					i = _tmp5_ + 1;
#line 388 "chess-state.c"
				}
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp4_ = FALSE;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp6_ = i;
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!(_tmp6_ < 64)) {
#line 50 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					break;
#line 398 "chess-state.c"
				}
#line 51 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp7_ = i;
#line 51 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (self->board[_tmp7_]);
#line 51 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				self->board[_tmp7_] = NULL;
#line 51 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp8_ = self->board[_tmp7_];
#line 408 "chess-state.c"
			}
		}
	}
#line 53 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp9_ = fen;
#line 53 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, " ", 0);
#line 53 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	fields = _tmp11_;
#line 53 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	fields_length1 = _vala_array_length (_tmp10_);
#line 53 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_fields_size_ = fields_length1;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp12_ = fields;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp12__length1 = fields_length1;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp13_ = _tmp12_[0];
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "/", 0);
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	ranks = _tmp15_;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	ranks_length1 = _vala_array_length (_tmp14_);
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_ranks_size_ = ranks_length1;
#line 436 "chess-state.c"
	{
		gint rank = 0;
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		rank = 0;
#line 441 "chess-state.c"
		{
			gboolean _tmp16_ = FALSE;
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp16_ = TRUE;
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 448 "chess-state.c"
				gint _tmp18_;
				gchar* rank_string = NULL;
				gchar** _tmp19_;
				gint _tmp19__length1;
				gint _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!_tmp16_) {
#line 458 "chess-state.c"
					gint _tmp17_;
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp17_ = rank;
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					rank = _tmp17_ + 1;
#line 464 "chess-state.c"
				}
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp16_ = FALSE;
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp18_ = rank;
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!(_tmp18_ < 8)) {
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					break;
#line 474 "chess-state.c"
				}
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp19_ = ranks;
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp19__length1 = ranks_length1;
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp20_ = rank;
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp21_ = _tmp19_[7 - _tmp20_];
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp22_ = g_strdup (_tmp21_);
#line 63 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				rank_string = _tmp22_;
#line 488 "chess-state.c"
				{
					gint file = 0;
					gint offset = 0;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					file = 0;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					offset = 0;
#line 496 "chess-state.c"
					{
						gboolean _tmp23_ = FALSE;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp23_ = TRUE;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						while (TRUE) {
#line 503 "chess-state.c"
							gboolean _tmp25_ = FALSE;
							gint _tmp26_;
							gchar c = '\0';
							const gchar* _tmp31_;
							gint _tmp32_;
							gchar _tmp33_;
							gboolean _tmp34_ = FALSE;
							gchar _tmp35_;
							PieceType type = 0;
							Color _tmp39_ = 0;
							gchar _tmp40_;
							gboolean _tmp41_;
							Color color = 0;
							gchar _tmp42_;
							gchar _tmp43_;
							PieceType _tmp44_ = 0;
							gint index = 0;
							gint _tmp45_;
							gint _tmp46_;
							gint _tmp47_;
							ChessPiece* piece = NULL;
							Color _tmp48_;
							ChessPlayer* _tmp49_;
							PieceType _tmp50_;
							ChessPiece* _tmp51_;
							gint _tmp52_;
							ChessPiece* _tmp53_;
							ChessPiece* _tmp54_;
							ChessPiece* _tmp55_;
							gint64 mask = 0LL;
							gint _tmp56_;
							gint64 _tmp57_;
							Color _tmp58_;
							gint64 _tmp59_;
							gint64 _tmp60_;
							gint _tmp61_;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							if (!_tmp23_) {
#line 542 "chess-state.c"
								gint _tmp24_;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp24_ = offset;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								offset = _tmp24_ + 1;
#line 548 "chess-state.c"
							}
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp23_ = FALSE;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp26_ = file;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							if (_tmp26_ < 8) {
#line 556 "chess-state.c"
								gint _tmp27_;
								const gchar* _tmp28_;
								gint _tmp29_;
								gint _tmp30_;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp27_ = offset;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp28_ = rank_string;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp29_ = strlen (_tmp28_);
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp30_ = _tmp29_;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp25_ = _tmp27_ < _tmp30_;
#line 571 "chess-state.c"
							} else {
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp25_ = FALSE;
#line 575 "chess-state.c"
							}
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							if (!_tmp25_) {
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								break;
#line 581 "chess-state.c"
							}
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp31_ = rank_string;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp32_ = offset;
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp33_ = string_get (_tmp31_, (glong) _tmp32_);
#line 66 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							c = _tmp33_;
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp35_ = c;
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							if (_tmp35_ >= '1') {
#line 595 "chess-state.c"
								gchar _tmp36_;
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp36_ = c;
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp34_ = _tmp36_ <= '8';
#line 601 "chess-state.c"
							} else {
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp34_ = FALSE;
#line 605 "chess-state.c"
							}
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							if (_tmp34_) {
#line 609 "chess-state.c"
								gint _tmp37_;
								gchar _tmp38_;
#line 69 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp37_ = file;
#line 69 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp38_ = c;
#line 69 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								file = _tmp37_ + (_tmp38_ - '0');
#line 70 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								continue;
#line 620 "chess-state.c"
							}
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp40_ = c;
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp41_ = g_ascii_isupper (_tmp40_);
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							if (_tmp41_) {
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp39_ = COLOR_WHITE;
#line 630 "chess-state.c"
							} else {
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp39_ = COLOR_BLACK;
#line 634 "chess-state.c"
							}
#line 74 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							color = _tmp39_;
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp42_ = c;
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp43_ = g_ascii_toupper (_tmp42_);
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							chess_state_decode_piece_type (self, (gunichar) _tmp43_, &_tmp44_);
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							type = _tmp44_;
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp45_ = rank;
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp46_ = file;
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp47_ = chess_state_get_index (self, _tmp45_, _tmp46_);
#line 78 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							index = _tmp47_;
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp48_ = color;
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp49_ = self->players[_tmp48_];
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp50_ = type;
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp51_ = chess_piece_new (_tmp49_, _tmp50_);
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							piece = _tmp51_;
#line 80 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp52_ = index;
#line 80 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp53_ = piece;
#line 80 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp54_ = _g_object_ref0 (_tmp53_);
#line 80 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_g_object_unref0 (self->board[_tmp52_]);
#line 80 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							self->board[_tmp52_] = _tmp54_;
#line 80 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp55_ = self->board[_tmp52_];
#line 81 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp56_ = index;
#line 81 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp57_ = BIT_BOARD_set_location_masks[_tmp56_];
#line 81 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							mask = _tmp57_;
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp58_ = color;
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp59_ = mask;
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							self->priv->piece_masks[_tmp58_] |= _tmp59_;
#line 82 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp60_ = self->priv->piece_masks[_tmp58_];
#line 83 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp61_ = file;
#line 83 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							file = _tmp61_ + 1;
#line 64 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_g_object_unref0 (piece);
#line 696 "chess-state.c"
						}
					}
				}
#line 61 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_g_free0 (rank_string);
#line 702 "chess-state.c"
			}
		}
	}
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp62_ = fields;
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp62__length1 = fields_length1;
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp63_ = _tmp62_[1];
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (g_strcmp0 (_tmp63_, "w") == 0) {
#line 714 "chess-state.c"
		ChessPlayer* _tmp64_;
		ChessPlayer* _tmp65_;
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp64_ = self->players[COLOR_WHITE];
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp65_ = _g_object_ref0 (_tmp64_);
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->current_player);
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->current_player = _tmp65_;
#line 725 "chess-state.c"
	} else {
		gchar** _tmp66_;
		gint _tmp66__length1;
		const gchar* _tmp67_;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp66_ = fields;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp66__length1 = fields_length1;
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp67_ = _tmp66_[1];
#line 90 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (g_strcmp0 (_tmp67_, "b") == 0) {
#line 738 "chess-state.c"
			ChessPlayer* _tmp68_;
			ChessPlayer* _tmp69_;
#line 91 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp68_ = self->players[COLOR_BLACK];
#line 91 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp69_ = _g_object_ref0 (_tmp68_);
#line 91 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_g_object_unref0 (self->current_player);
#line 91 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			self->current_player = _tmp69_;
#line 749 "chess-state.c"
		}
	}
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp70_ = fields;
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp70__length1 = fields_length1;
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp71_ = _tmp70_[2];
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (g_strcmp0 (_tmp71_, "-") != 0) {
#line 760 "chess-state.c"
		{
			gint i = 0;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			i = 0;
#line 765 "chess-state.c"
			{
				gboolean _tmp72_ = FALSE;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp72_ = TRUE;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				while (TRUE) {
#line 772 "chess-state.c"
					gint _tmp74_;
					gchar** _tmp75_;
					gint _tmp75__length1;
					const gchar* _tmp76_;
					gint _tmp77_;
					gint _tmp78_;
					gchar c = '\0';
					gchar** _tmp79_;
					gint _tmp79__length1;
					const gchar* _tmp80_;
					gint _tmp81_;
					gchar _tmp82_;
					gchar _tmp83_;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (!_tmp72_) {
#line 788 "chess-state.c"
						gint _tmp73_;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp73_ = i;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						i = _tmp73_ + 1;
#line 794 "chess-state.c"
					}
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp72_ = FALSE;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp74_ = i;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp75_ = fields;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp75__length1 = fields_length1;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp76_ = _tmp75_[2];
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp77_ = strlen (_tmp76_);
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp78_ = _tmp77_;
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (!(_tmp74_ < _tmp78_)) {
#line 98 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						break;
#line 814 "chess-state.c"
					}
#line 100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp79_ = fields;
#line 100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp79__length1 = fields_length1;
#line 100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp80_ = _tmp79_[2];
#line 100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp81_ = i;
#line 100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp82_ = string_get (_tmp80_, (glong) _tmp81_);
#line 100 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					c = _tmp82_;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp83_ = c;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (_tmp83_ == 'K') {
#line 832 "chess-state.c"
						gboolean _tmp84_;
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						self->can_castle_kingside[COLOR_WHITE] = TRUE;
#line 102 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp84_ = self->can_castle_kingside[COLOR_WHITE];
#line 838 "chess-state.c"
					} else {
						gchar _tmp85_;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp85_ = c;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						if (_tmp85_ == 'Q') {
#line 845 "chess-state.c"
							gboolean _tmp86_;
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							self->can_castle_queenside[COLOR_WHITE] = TRUE;
#line 104 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp86_ = self->can_castle_queenside[COLOR_WHITE];
#line 851 "chess-state.c"
						} else {
							gchar _tmp87_;
#line 105 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp87_ = c;
#line 105 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							if (_tmp87_ == 'k') {
#line 858 "chess-state.c"
								gboolean _tmp88_;
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								self->can_castle_kingside[COLOR_BLACK] = TRUE;
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp88_ = self->can_castle_kingside[COLOR_BLACK];
#line 864 "chess-state.c"
							} else {
								gchar _tmp89_;
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp89_ = c;
#line 107 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								if (_tmp89_ == 'q') {
#line 871 "chess-state.c"
									gboolean _tmp90_;
#line 108 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									self->can_castle_queenside[COLOR_BLACK] = TRUE;
#line 108 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									_tmp90_ = self->can_castle_queenside[COLOR_BLACK];
#line 877 "chess-state.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 115 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp91_ = fields;
#line 115 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp91__length1 = fields_length1;
#line 115 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp92_ = _tmp91_[3];
#line 115 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (g_strcmp0 (_tmp92_, "-") != 0) {
#line 894 "chess-state.c"
		gchar** _tmp93_;
		gint _tmp93__length1;
		const gchar* _tmp94_;
		gchar _tmp95_;
		gchar** _tmp96_;
		gint _tmp96__length1;
		const gchar* _tmp97_;
		gchar _tmp98_;
		gint _tmp99_;
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp93_ = fields;
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp93__length1 = fields_length1;
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp94_ = _tmp93_[3];
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp95_ = string_get (_tmp94_, (glong) 1);
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp96_ = fields;
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp96__length1 = fields_length1;
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp97_ = _tmp96_[3];
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp98_ = string_get (_tmp97_, (glong) 0);
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp99_ = chess_state_get_index (self, (gint) (_tmp95_ - '1'), (gint) (_tmp98_ - 'a'));
#line 119 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->en_passant_index = _tmp99_;
#line 924 "chess-state.c"
	}
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp100_ = fields;
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp100__length1 = fields_length1;
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp101_ = _tmp100_[4];
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp102_ = atoi (_tmp101_);
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->halfmove_clock = _tmp102_;
#line 126 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp103_ = fields;
#line 126 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp103__length1 = fields_length1;
#line 126 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp104_ = _tmp103_[5];
#line 126 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp105_ = atoi (_tmp104_);
#line 126 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->number = (_tmp105_ - 1) * 2;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp106_ = self->current_player;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp107_ = _tmp106_->color;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp107_ == COLOR_BLACK) {
#line 952 "chess-state.c"
		gint _tmp108_;
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp108_ = self->number;
#line 128 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->number = _tmp108_ + 1;
#line 958 "chess-state.c"
	}
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp109_ = self->current_player;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp110_ = chess_state_get_check_state (self, _tmp109_);
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->check_state = _tmp110_;
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return self;
#line 972 "chess-state.c"
}


ChessState* chess_state_new (const gchar* fen) {
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return chess_state_construct (TYPE_CHESS_STATE, fen);
#line 979 "chess-state.c"
}


ChessState* chess_state_copy (ChessState* self) {
	ChessState* result = NULL;
	ChessState* state = NULL;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	gint _tmp2_;
	ChessState* _tmp3_;
	ChessPlayer* _tmp4_;
	ChessPlayer* _tmp5_;
	ChessPlayer* _tmp6_;
	ChessState* _tmp7_;
	ChessPlayer* _tmp8_;
	ChessPlayer* _tmp9_;
	ChessPlayer* _tmp10_;
	ChessState* _tmp11_;
	ChessPlayer* _tmp12_;
	ChessPlayer* _tmp13_;
	ChessState* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	ChessState* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	ChessState* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	ChessState* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	ChessState* _tmp26_;
	gint _tmp27_;
	ChessState* _tmp28_;
	CheckState _tmp29_;
	ChessMove* _tmp30_;
	ChessState* _tmp43_;
	gint64 _tmp44_;
	gint64 _tmp45_;
	ChessState* _tmp46_;
	gint64 _tmp47_;
	gint64 _tmp48_;
	ChessState* _tmp49_;
	gint _tmp50_;
#line 133 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp0_ = chess_state_new_empty ();
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	state = _tmp0_;
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp1_ = state;
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp2_ = self->number;
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp1_->number = _tmp2_;
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp3_ = state;
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp4_ = self->players[COLOR_WHITE];
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (_tmp3_->players[COLOR_WHITE]);
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp3_->players[COLOR_WHITE] = _tmp5_;
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp6_ = _tmp3_->players[COLOR_WHITE];
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp7_ = state;
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp8_ = self->players[COLOR_BLACK];
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (_tmp7_->players[COLOR_BLACK]);
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp7_->players[COLOR_BLACK] = _tmp9_;
#line 139 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp10_ = _tmp7_->players[COLOR_BLACK];
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp11_ = state;
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp12_ = self->current_player;
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (_tmp11_->current_player);
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp11_->current_player = _tmp13_;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp14_ = state;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp15_ = self->can_castle_kingside[COLOR_WHITE];
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp14_->can_castle_kingside[COLOR_WHITE] = _tmp15_;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp16_ = _tmp14_->can_castle_kingside[COLOR_WHITE];
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp17_ = state;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp18_ = self->can_castle_queenside[COLOR_WHITE];
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp17_->can_castle_queenside[COLOR_WHITE] = _tmp18_;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp19_ = _tmp17_->can_castle_queenside[COLOR_WHITE];
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp20_ = state;
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp21_ = self->can_castle_kingside[COLOR_BLACK];
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp20_->can_castle_kingside[COLOR_BLACK] = _tmp21_;
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp22_ = _tmp20_->can_castle_kingside[COLOR_BLACK];
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp23_ = state;
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp24_ = self->can_castle_queenside[COLOR_BLACK];
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp23_->can_castle_queenside[COLOR_BLACK] = _tmp24_;
#line 144 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp25_ = _tmp23_->can_castle_queenside[COLOR_BLACK];
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp26_ = state;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp27_ = self->en_passant_index;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp26_->en_passant_index = _tmp27_;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp28_ = state;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp29_ = self->check_state;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp28_->check_state = _tmp29_;
#line 147 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp30_ = self->last_move;
#line 147 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp30_ != NULL) {
#line 1119 "chess-state.c"
		ChessState* _tmp31_;
		ChessMove* _tmp32_;
		ChessMove* _tmp33_;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp31_ = state;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp32_ = self->last_move;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp33_ = chess_move_copy (_tmp32_);
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (_tmp31_->last_move);
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp31_->last_move = _tmp33_;
#line 1133 "chess-state.c"
	}
	{
		gint i = 0;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		i = 0;
#line 1139 "chess-state.c"
		{
			gboolean _tmp34_ = FALSE;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp34_ = TRUE;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 1146 "chess-state.c"
				gint _tmp36_;
				ChessState* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				ChessPiece* _tmp40_;
				ChessPiece* _tmp41_;
				ChessPiece* _tmp42_;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!_tmp34_) {
#line 1156 "chess-state.c"
					gint _tmp35_;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp35_ = i;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					i = _tmp35_ + 1;
#line 1162 "chess-state.c"
				}
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp34_ = FALSE;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp36_ = i;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!(_tmp36_ < 64)) {
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					break;
#line 1172 "chess-state.c"
				}
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp37_ = state;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp38_ = i;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp39_ = i;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp40_ = self->board[_tmp39_];
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp41_ = _g_object_ref0 (_tmp40_);
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (_tmp37_->board[_tmp38_]);
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp37_->board[_tmp38_] = _tmp41_;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp42_ = _tmp37_->board[_tmp38_];
#line 1190 "chess-state.c"
			}
		}
	}
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp43_ = state;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp44_ = self->priv->piece_masks[COLOR_WHITE];
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp43_->priv->piece_masks[COLOR_WHITE] = _tmp44_;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp45_ = _tmp43_->priv->piece_masks[COLOR_WHITE];
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp46_ = state;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp47_ = self->priv->piece_masks[COLOR_BLACK];
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp46_->priv->piece_masks[COLOR_BLACK] = _tmp47_;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp48_ = _tmp46_->priv->piece_masks[COLOR_BLACK];
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp49_ = state;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp50_ = self->halfmove_clock;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp49_->halfmove_clock = _tmp50_;
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	result = state;
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return result;
#line 1220 "chess-state.c"
}


gboolean chess_state_equals (ChessState* self, ChessState* state) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gint64 _tmp7_;
	ChessState* _tmp8_;
	gint64 _tmp9_;
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 158 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (state != NULL, FALSE);
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp7_ = self->priv->piece_masks[COLOR_WHITE];
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp8_ = state;
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp9_ = _tmp8_->priv->piece_masks[COLOR_WHITE];
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp7_ != _tmp9_) {
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp6_ = TRUE;
#line 1250 "chess-state.c"
	} else {
		gint64 _tmp10_;
		ChessState* _tmp11_;
		gint64 _tmp12_;
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp10_ = self->priv->piece_masks[COLOR_BLACK];
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp11_ = state;
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp12_ = _tmp11_->priv->piece_masks[COLOR_BLACK];
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp6_ = _tmp10_ != _tmp12_;
#line 1263 "chess-state.c"
	}
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp6_) {
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp5_ = TRUE;
#line 1269 "chess-state.c"
	} else {
		ChessPlayer* _tmp13_;
		Color _tmp14_;
		ChessState* _tmp15_;
		ChessPlayer* _tmp16_;
		Color _tmp17_;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp13_ = self->current_player;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp14_ = _tmp13_->color;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp15_ = state;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp16_ = _tmp15_->current_player;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp17_ = _tmp16_->color;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp5_ = _tmp14_ != _tmp17_;
#line 1288 "chess-state.c"
	}
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp5_) {
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp4_ = TRUE;
#line 1294 "chess-state.c"
	} else {
		gboolean _tmp18_;
		ChessState* _tmp19_;
		gboolean _tmp20_;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp18_ = self->can_castle_kingside[COLOR_WHITE];
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp19_ = state;
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp20_ = _tmp19_->can_castle_kingside[COLOR_WHITE];
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp4_ = _tmp18_ != _tmp20_;
#line 1307 "chess-state.c"
	}
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp4_) {
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp3_ = TRUE;
#line 1313 "chess-state.c"
	} else {
		gboolean _tmp21_;
		ChessState* _tmp22_;
		gboolean _tmp23_;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp21_ = self->can_castle_queenside[COLOR_WHITE];
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp22_ = state;
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp23_ = _tmp22_->can_castle_queenside[COLOR_WHITE];
#line 172 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp3_ = _tmp21_ != _tmp23_;
#line 1326 "chess-state.c"
	}
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp3_) {
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp2_ = TRUE;
#line 1332 "chess-state.c"
	} else {
		gboolean _tmp24_;
		ChessState* _tmp25_;
		gboolean _tmp26_;
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp24_ = self->can_castle_kingside[COLOR_BLACK];
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp25_ = state;
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp26_ = _tmp25_->can_castle_kingside[COLOR_BLACK];
#line 173 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp2_ = _tmp24_ != _tmp26_;
#line 1345 "chess-state.c"
	}
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp2_) {
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp1_ = TRUE;
#line 1351 "chess-state.c"
	} else {
		gboolean _tmp27_;
		ChessState* _tmp28_;
		gboolean _tmp29_;
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp27_ = self->can_castle_queenside[COLOR_BLACK];
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp28_ = state;
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp29_ = _tmp28_->can_castle_queenside[COLOR_BLACK];
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp1_ = _tmp27_ != _tmp29_;
#line 1364 "chess-state.c"
	}
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp1_) {
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp0_ = TRUE;
#line 1370 "chess-state.c"
	} else {
		gint _tmp30_;
		ChessState* _tmp31_;
		gint _tmp32_;
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp30_ = self->en_passant_index;
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp31_ = state;
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp32_ = _tmp31_->en_passant_index;
#line 175 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp0_ = _tmp30_ != _tmp32_;
#line 1383 "chess-state.c"
	}
#line 168 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp0_) {
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 176 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		return result;
#line 1391 "chess-state.c"
	}
	{
		gint i = 0;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		i = 0;
#line 1397 "chess-state.c"
		{
			gboolean _tmp33_ = FALSE;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp33_ = TRUE;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 1404 "chess-state.c"
				gint _tmp35_;
				gboolean _tmp36_ = FALSE;
				gint _tmp37_;
				ChessPiece* _tmp38_;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!_tmp33_) {
#line 1411 "chess-state.c"
					gint _tmp34_;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp34_ = i;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					i = _tmp34_ + 1;
#line 1417 "chess-state.c"
				}
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp33_ = FALSE;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp35_ = i;
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!(_tmp35_ < 64)) {
#line 179 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					break;
#line 1427 "chess-state.c"
				}
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp37_ = i;
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp38_ = self->board[_tmp37_];
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp38_ != NULL) {
#line 1435 "chess-state.c"
					gint _tmp39_;
					ChessPiece* _tmp40_;
					PieceType _tmp41_;
					ChessState* _tmp42_;
					gint _tmp43_;
					ChessPiece* _tmp44_;
					PieceType _tmp45_;
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp39_ = i;
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp40_ = self->board[_tmp39_];
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp41_ = _tmp40_->type;
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp42_ = state;
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp43_ = i;
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp44_ = _tmp42_->board[_tmp43_];
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp45_ = _tmp44_->type;
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp36_ = _tmp41_ != _tmp45_;
#line 1459 "chess-state.c"
				} else {
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp36_ = FALSE;
#line 1463 "chess-state.c"
				}
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp36_) {
#line 182 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 182 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 1471 "chess-state.c"
				}
			}
		}
	}
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	result = TRUE;
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return result;
#line 1480 "chess-state.c"
}


gchar* chess_state_get_fen (ChessState* self) {
	gchar* result = NULL;
	GString* value = NULL;
	GString* _tmp0_;
	GString* _tmp26_;
	ChessPlayer* _tmp27_;
	Color _tmp28_;
	GString* _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp34_;
	gboolean _tmp36_;
	gboolean _tmp38_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	GString* _tmp45_;
	gint _tmp46_;
	GString* _tmp53_;
	GString* _tmp54_;
	gint _tmp55_;
	GString* _tmp56_;
	ChessPlayer* _tmp57_;
	Color _tmp58_;
	GString* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
#line 188 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp0_ = g_string_new ("");
#line 190 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	value = _tmp0_;
#line 1517 "chess-state.c"
	{
		gint rank = 0;
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		rank = 7;
#line 1522 "chess-state.c"
		{
			gboolean _tmp1_ = FALSE;
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp1_ = TRUE;
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 1529 "chess-state.c"
				gint _tmp3_;
				gint skip_count = 0;
				gint _tmp21_;
				gint _tmp24_;
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!_tmp1_) {
#line 1536 "chess-state.c"
					gint _tmp2_;
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp2_ = rank;
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					rank = _tmp2_ - 1;
#line 1542 "chess-state.c"
				}
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp1_ = FALSE;
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp3_ = rank;
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!(_tmp3_ >= 0)) {
#line 192 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					break;
#line 1552 "chess-state.c"
				}
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				skip_count = 0;
#line 1556 "chess-state.c"
				{
					gint file = 0;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					file = 0;
#line 1561 "chess-state.c"
					{
						gboolean _tmp4_ = FALSE;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp4_ = TRUE;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						while (TRUE) {
#line 1568 "chess-state.c"
							gint _tmp6_;
							ChessPiece* p = NULL;
							gint _tmp7_;
							gint _tmp8_;
							gint _tmp9_;
							ChessPiece* _tmp10_;
							ChessPiece* _tmp11_;
							ChessPiece* _tmp12_;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							if (!_tmp4_) {
#line 1579 "chess-state.c"
								gint _tmp5_;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp5_ = file;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								file = _tmp5_ + 1;
#line 1585 "chess-state.c"
							}
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp4_ = FALSE;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp6_ = file;
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							if (!(_tmp6_ < 8)) {
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								break;
#line 1595 "chess-state.c"
							}
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp7_ = rank;
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp8_ = file;
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp9_ = chess_state_get_index (self, _tmp7_, _tmp8_);
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp10_ = self->board[_tmp9_];
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp11_ = _g_object_ref0 (_tmp10_);
#line 197 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							p = _tmp11_;
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp12_ = p;
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							if (_tmp12_ == NULL) {
#line 1613 "chess-state.c"
								gint _tmp13_;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp13_ = skip_count;
#line 199 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								skip_count = _tmp13_ + 1;
#line 1619 "chess-state.c"
							} else {
								gint _tmp14_;
								GString* _tmp17_;
								ChessPiece* _tmp18_;
								gunichar _tmp19_;
								gunichar _tmp20_;
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp14_ = skip_count;
#line 202 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								if (_tmp14_ > 0) {
#line 1630 "chess-state.c"
									GString* _tmp15_;
									gint _tmp16_;
#line 204 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									_tmp15_ = value;
#line 204 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									_tmp16_ = skip_count;
#line 204 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									g_string_append_printf (_tmp15_, "%d", _tmp16_);
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									skip_count = 0;
#line 1641 "chess-state.c"
								}
#line 207 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp17_ = value;
#line 207 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp18_ = p;
#line 207 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp19_ = chess_piece_get_symbol (_tmp18_);
#line 207 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp20_ = _tmp19_;
#line 207 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								g_string_append_printf (_tmp17_, "%c", (gint) _tmp20_);
#line 1653 "chess-state.c"
							}
#line 195 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_g_object_unref0 (p);
#line 1657 "chess-state.c"
						}
					}
				}
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp21_ = skip_count;
#line 210 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp21_ > 0) {
#line 1665 "chess-state.c"
					GString* _tmp22_;
					gint _tmp23_;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp22_ = value;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp23_ = skip_count;
#line 211 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					g_string_append_printf (_tmp22_, "%d", _tmp23_);
#line 1674 "chess-state.c"
				}
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp24_ = rank;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp24_ != 0) {
#line 1680 "chess-state.c"
					GString* _tmp25_;
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp25_ = value;
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					g_string_append_c (_tmp25_, '/');
#line 1686 "chess-state.c"
				}
			}
		}
	}
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp26_ = value;
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_string_append_c (_tmp26_, ' ');
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp27_ = self->current_player;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp28_ = _tmp27_->color;
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp28_ == COLOR_WHITE) {
#line 1701 "chess-state.c"
		GString* _tmp29_;
#line 218 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp29_ = value;
#line 218 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp29_, 'w');
#line 1707 "chess-state.c"
	} else {
		GString* _tmp30_;
#line 220 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp30_ = value;
#line 220 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp30_, 'b');
#line 1714 "chess-state.c"
	}
#line 222 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp31_ = value;
#line 222 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_string_append_c (_tmp31_, ' ');
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp32_ = self->can_castle_kingside[COLOR_WHITE];
#line 223 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp32_) {
#line 1724 "chess-state.c"
		GString* _tmp33_;
#line 224 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp33_ = value;
#line 224 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp33_, 'K');
#line 1730 "chess-state.c"
	}
#line 225 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp34_ = self->can_castle_queenside[COLOR_WHITE];
#line 225 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp34_) {
#line 1736 "chess-state.c"
		GString* _tmp35_;
#line 226 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp35_ = value;
#line 226 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp35_, 'Q');
#line 1742 "chess-state.c"
	}
#line 227 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp36_ = self->can_castle_kingside[COLOR_BLACK];
#line 227 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp36_) {
#line 1748 "chess-state.c"
		GString* _tmp37_;
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp37_ = value;
#line 228 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp37_, 'k');
#line 1754 "chess-state.c"
	}
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp38_ = self->can_castle_queenside[COLOR_BLACK];
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp38_) {
#line 1760 "chess-state.c"
		GString* _tmp39_;
#line 230 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp39_ = value;
#line 230 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp39_, 'q');
#line 1766 "chess-state.c"
	}
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp40_ = self->can_castle_kingside[COLOR_WHITE];
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp41_ = self->can_castle_queenside[COLOR_WHITE];
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp42_ = self->can_castle_kingside[COLOR_BLACK];
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp43_ = self->can_castle_queenside[COLOR_BLACK];
#line 231 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (!(((_tmp40_ | _tmp41_) | _tmp42_) | _tmp43_)) {
#line 1778 "chess-state.c"
		GString* _tmp44_;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp44_ = value;
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp44_, '-');
#line 1784 "chess-state.c"
	}
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp45_ = value;
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_string_append_c (_tmp45_, ' ');
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp46_ = self->en_passant_index;
#line 235 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp46_ >= 0) {
#line 1794 "chess-state.c"
		GString* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
#line 236 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp47_ = value;
#line 236 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp48_ = self->en_passant_index;
#line 236 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp49_ = chess_state_get_file (self, _tmp48_);
#line 236 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp50_ = self->en_passant_index;
#line 236 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp51_ = chess_state_get_rank (self, _tmp50_);
#line 236 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		g_string_append_printf (_tmp47_, "%c%d", 'a' + _tmp49_, _tmp51_ + 1);
#line 1812 "chess-state.c"
	} else {
		GString* _tmp52_;
#line 238 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp52_ = value;
#line 238 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		g_string_append_c (_tmp52_, '-');
#line 1819 "chess-state.c"
	}
#line 240 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp53_ = value;
#line 240 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_string_append_c (_tmp53_, ' ');
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp54_ = value;
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp55_ = self->halfmove_clock;
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_string_append_printf (_tmp54_, "%d", _tmp55_);
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp56_ = value;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_string_append_c (_tmp56_, ' ');
#line 244 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp57_ = self->current_player;
#line 244 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp58_ = _tmp57_->color;
#line 244 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp58_ == COLOR_WHITE) {
#line 1841 "chess-state.c"
		GString* _tmp59_;
		gint _tmp60_;
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp59_ = value;
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp60_ = self->number;
#line 245 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		g_string_append_printf (_tmp59_, "%d", _tmp60_ / 2);
#line 1850 "chess-state.c"
	} else {
		GString* _tmp61_;
		gint _tmp62_;
#line 247 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp61_ = value;
#line 247 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp62_ = self->number;
#line 247 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		g_string_append_printf (_tmp61_, "%d", (_tmp62_ / 2) + 1);
#line 1860 "chess-state.c"
	}
#line 249 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp63_ = value;
#line 249 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp64_ = _tmp63_->str;
#line 249 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp65_ = g_strdup (_tmp64_);
#line 249 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	result = _tmp65_;
#line 249 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_string_free0 (value);
#line 249 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return result;
#line 1874 "chess-state.c"
}


gint chess_state_get_index (ChessState* self, gint rank, gint file) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 254 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp0_ = rank;
#line 254 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp1_ = file;
#line 254 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	result = (_tmp0_ * 8) + _tmp1_;
#line 254 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return result;
#line 1892 "chess-state.c"
}


gint chess_state_get_rank (ChessState* self, gint index) {
	gint result = 0;
	gint _tmp0_;
#line 257 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp0_ = index;
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	result = _tmp0_ / 8;
#line 259 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return result;
#line 1907 "chess-state.c"
}


gint chess_state_get_file (ChessState* self, gint index) {
	gint result = 0;
	gint _tmp0_;
#line 262 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 264 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp0_ = index;
#line 264 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	result = _tmp0_ % 8;
#line 264 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return result;
#line 1922 "chess-state.c"
}


gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	gint r0 = 0;
	gint f0 = 0;
	gint r1 = 0;
	gint f1 = 0;
	PieceType promotion_type = 0;
	ChessPlayer* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	PieceType _tmp6_ = 0;
	gboolean _tmp7_;
	ChessPlayer* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	PieceType _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
#line 267 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 267 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (move != NULL, FALSE);
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp0_ = self->current_player;
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp1_ = move;
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp7_ = chess_state_decode_move (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	r0 = _tmp2_;
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	f0 = _tmp3_;
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	r1 = _tmp4_;
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	f1 = _tmp5_;
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	promotion_type = _tmp6_;
#line 272 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (!_tmp7_) {
#line 273 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 273 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		return result;
#line 1975 "chess-state.c"
	}
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp8_ = self->current_player;
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp9_ = r0;
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp10_ = f0;
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp11_ = r1;
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp12_ = f1;
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp13_ = promotion_type;
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp14_ = apply;
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp15_ = chess_state_move_with_coords (self, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_, TRUE);
#line 275 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (!_tmp15_) {
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 276 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		return result;
#line 1999 "chess-state.c"
	}
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	result = TRUE;
#line 278 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return result;
#line 2005 "chess-state.c"
}


gboolean chess_state_move_with_coords (ChessState* self, ChessPlayer* player, gint r0, gint f0, gint r1, gint f1, PieceType promotion_type, gboolean apply, gboolean test_check) {
	gboolean result = FALSE;
	gint start = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint end = 0;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Color color = 0;
	ChessPlayer* _tmp6_;
	Color _tmp7_;
	Color _tmp8_ = 0;
	Color _tmp9_;
	Color opponent_color = 0;
	ChessPiece* piece = NULL;
	gint _tmp10_;
	ChessPiece* _tmp11_;
	ChessPiece* _tmp12_;
	gboolean _tmp13_ = FALSE;
	ChessPiece* _tmp14_;
	gint64 end_mask = 0LL;
	gint _tmp18_;
	gint64 _tmp19_;
	gint64 move_mask = 0LL;
	Color _tmp20_;
	ChessPiece* _tmp21_;
	PieceType _tmp22_;
	gint _tmp23_;
	gint64 _tmp24_;
	gint64 _tmp25_;
	gint64 _tmp26_;
	gint64 over_mask = 0LL;
	gint _tmp27_;
	gint _tmp28_;
	gint64 _tmp29_;
	gint64 _tmp30_;
	gint64 _tmp31_;
	gint64 _tmp32_;
	ChessPiece* victim = NULL;
	gint _tmp33_;
	ChessPiece* _tmp34_;
	ChessPiece* _tmp35_;
	gint victim_index = 0;
	gint _tmp36_;
	gboolean _tmp37_ = FALSE;
	ChessPiece* _tmp38_;
	gint rook_start = 0;
	gint rook_end = 0;
	gboolean is_promotion = FALSE;
	gboolean ambiguous_rank = FALSE;
	gboolean ambiguous_file = FALSE;
	ChessPiece* _tmp42_;
	PieceType _tmp43_;
	gboolean _tmp111_ = FALSE;
	gboolean _tmp112_;
	gboolean _tmp114_;
	gint64 old_white_mask = 0LL;
	gint64 _tmp147_;
	gint64 old_black_mask = 0LL;
	gint64 _tmp148_;
	gboolean old_white_can_castle_kingside = FALSE;
	gboolean _tmp149_;
	gboolean old_white_can_castle_queenside = FALSE;
	gboolean _tmp150_;
	gboolean old_black_can_castle_kingside = FALSE;
	gboolean _tmp151_;
	gboolean old_black_can_castle_queenside = FALSE;
	gboolean _tmp152_;
	gint old_en_passant_index = 0;
	gint _tmp153_;
	gint old_halfmove_clock = 0;
	gint _tmp154_;
	gint _tmp155_;
	ChessPiece* _tmp156_;
	gint _tmp157_;
	gint64 _tmp158_;
	gint64 _tmp159_;
	gint _tmp160_;
	gint64 _tmp161_;
	gint64 _tmp162_;
	ChessPiece* _tmp163_;
	gboolean _tmp172_;
	Color _tmp182_;
	gint64 _tmp183_;
	gint64 _tmp184_;
	Color _tmp185_;
	gint _tmp186_;
	gint64 _tmp187_;
	gint64 _tmp188_;
	gint _tmp189_;
	ChessPiece* _tmp207_;
	PieceType _tmp208_;
	gboolean _tmp239_ = FALSE;
	ChessPiece* _tmp240_;
	PieceType _tmp241_;
	gboolean _tmp247_ = FALSE;
	ChessPiece* _tmp248_;
	PieceType _tmp249_;
	gboolean _result_ = FALSE;
	gboolean _tmp252_ = FALSE;
	gboolean _tmp253_;
	gboolean _tmp256_ = FALSE;
	gboolean _tmp257_;
	ChessPlayer* _tmp294_ = NULL;
	Color _tmp295_;
	ChessPlayer* _tmp298_;
	ChessPlayer* _tmp299_;
	CheckState _tmp300_;
	ChessMove* _tmp301_;
	ChessMove* _tmp302_;
	gint _tmp303_;
	ChessMove* _tmp304_;
	ChessPiece* _tmp305_;
	ChessPiece* _tmp306_;
	gboolean _tmp307_;
	ChessMove* _tmp312_;
	ChessPiece* _tmp313_;
	ChessPiece* _tmp314_;
	gint _tmp315_;
	ChessMove* _tmp320_;
	gint _tmp321_;
	ChessMove* _tmp322_;
	gint _tmp323_;
	ChessMove* _tmp324_;
	gint _tmp325_;
	ChessMove* _tmp326_;
	gint _tmp327_;
	ChessMove* _tmp328_;
	gboolean _tmp329_;
	ChessMove* _tmp330_;
	gboolean _tmp331_;
	ChessMove* _tmp332_;
	CheckState _tmp333_;
#line 281 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 281 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp0_ = r0;
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp1_ = f0;
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp2_ = chess_state_get_index (self, _tmp0_, _tmp1_);
#line 287 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	start = _tmp2_;
#line 288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp3_ = r1;
#line 288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp4_ = f1;
#line 288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp5_ = chess_state_get_index (self, _tmp3_, _tmp4_);
#line 288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	end = _tmp5_;
#line 290 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp6_ = player;
#line 290 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp7_ = _tmp6_->color;
#line 290 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	color = _tmp7_;
#line 291 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp9_ = color;
#line 291 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp9_ == COLOR_WHITE) {
#line 291 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp8_ = COLOR_BLACK;
#line 2176 "chess-state.c"
	} else {
#line 291 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp8_ = COLOR_WHITE;
#line 2180 "chess-state.c"
	}
#line 291 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	opponent_color = _tmp8_;
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp10_ = start;
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp11_ = self->board[_tmp10_];
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp12_ = _g_object_ref0 (_tmp11_);
#line 294 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	piece = _tmp12_;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp14_ = piece;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp14_ == NULL) {
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp13_ = TRUE;
#line 2198 "chess-state.c"
	} else {
		ChessPiece* _tmp15_;
		ChessPlayer* _tmp16_;
		ChessPlayer* _tmp17_;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp15_ = piece;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp16_ = _tmp15_->player;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp17_ = player;
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp13_ = _tmp16_ != _tmp17_;
#line 2211 "chess-state.c"
	}
#line 295 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp13_) {
#line 296 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 296 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (piece);
#line 296 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		return result;
#line 2221 "chess-state.c"
	}
#line 299 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp18_ = end;
#line 299 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp19_ = BIT_BOARD_set_location_masks[_tmp18_];
#line 299 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	end_mask = _tmp19_;
#line 300 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp20_ = color;
#line 300 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp21_ = piece;
#line 300 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp22_ = _tmp21_->type;
#line 300 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp23_ = start;
#line 300 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp24_ = BIT_BOARD_move_masks[(((_tmp20_ * 64) * 6) + (_tmp22_ * 64)) + _tmp23_];
#line 300 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	move_mask = _tmp24_;
#line 301 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp25_ = end_mask;
#line 301 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp26_ = move_mask;
#line 301 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if ((_tmp25_ & _tmp26_) == ((gint64) 0)) {
#line 302 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 302 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (piece);
#line 302 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		return result;
#line 2253 "chess-state.c"
	}
#line 305 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp27_ = start;
#line 305 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp28_ = end;
#line 305 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp29_ = BIT_BOARD_over_masks[(_tmp27_ * 64) + _tmp28_];
#line 305 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	over_mask = _tmp29_;
#line 306 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp30_ = over_mask;
#line 306 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp31_ = self->priv->piece_masks[COLOR_WHITE];
#line 306 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp32_ = self->priv->piece_masks[COLOR_BLACK];
#line 306 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if ((_tmp30_ & (_tmp31_ | _tmp32_)) != ((gint64) 0)) {
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (piece);
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		return result;
#line 2277 "chess-state.c"
	}
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp33_ = end;
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp34_ = self->board[_tmp33_];
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp35_ = _g_object_ref0 (_tmp34_);
#line 310 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	victim = _tmp35_;
#line 311 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp36_ = end;
#line 311 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	victim_index = _tmp36_;
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp38_ = victim;
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp38_ != NULL) {
#line 2295 "chess-state.c"
		ChessPiece* _tmp39_;
		ChessPlayer* _tmp40_;
		ChessPlayer* _tmp41_;
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp39_ = victim;
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp40_ = _tmp39_->player;
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp41_ = player;
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp37_ = _tmp40_ == _tmp41_;
#line 2307 "chess-state.c"
	} else {
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp37_ = FALSE;
#line 2311 "chess-state.c"
	}
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp37_) {
#line 315 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 315 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (victim);
#line 315 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (piece);
#line 315 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		return result;
#line 2323 "chess-state.c"
	}
#line 318 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	rook_start = -1;
#line 318 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	rook_end = -1;
#line 319 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	is_promotion = FALSE;
#line 320 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	ambiguous_rank = FALSE;
#line 321 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	ambiguous_file = FALSE;
#line 322 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp42_ = piece;
#line 322 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp43_ = _tmp42_->type;
#line 322 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	switch (_tmp43_) {
#line 322 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		case PIECE_TYPE_PAWN:
#line 2343 "chess-state.c"
		{
			gboolean _tmp44_ = FALSE;
			ChessPiece* _tmp45_;
			gint _tmp55_;
			gint _tmp56_;
			gboolean _tmp59_ = FALSE;
			gint _tmp60_;
			ChessPiece* _tmp62_;
#line 326 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp45_ = victim;
#line 326 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp45_ == NULL) {
#line 2356 "chess-state.c"
				gint _tmp46_;
				gint _tmp47_;
#line 326 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp46_ = end;
#line 326 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp47_ = self->en_passant_index;
#line 326 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp44_ = _tmp46_ == _tmp47_;
#line 2365 "chess-state.c"
			} else {
#line 326 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp44_ = FALSE;
#line 2369 "chess-state.c"
			}
#line 326 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp44_) {
#line 2373 "chess-state.c"
				gint _tmp48_ = 0;
				gint _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				ChessPiece* _tmp53_;
				ChessPiece* _tmp54_;
#line 328 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp49_ = r1;
#line 328 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp49_ == 2) {
#line 328 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp48_ = 3;
#line 2387 "chess-state.c"
				} else {
#line 328 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp48_ = 4;
#line 2391 "chess-state.c"
				}
#line 328 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp50_ = f1;
#line 328 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp51_ = chess_state_get_index (self, _tmp48_, _tmp50_);
#line 328 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				victim_index = _tmp51_;
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp52_ = victim_index;
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp53_ = self->board[_tmp52_];
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp54_ = _g_object_ref0 (_tmp53_);
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (victim);
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				victim = _tmp54_;
#line 2409 "chess-state.c"
			}
#line 333 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp55_ = f0;
#line 333 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp56_ = f1;
#line 333 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp55_ != _tmp56_) {
#line 2417 "chess-state.c"
				ChessPiece* _tmp57_;
#line 335 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp57_ = victim;
#line 335 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp57_ == NULL) {
#line 336 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 336 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (victim);
#line 336 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (piece);
#line 336 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 2431 "chess-state.c"
				}
			} else {
				ChessPiece* _tmp58_;
#line 341 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp58_ = victim;
#line 341 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp58_ != NULL) {
#line 342 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 342 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (victim);
#line 342 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (piece);
#line 342 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 2447 "chess-state.c"
				}
			}
#line 344 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp60_ = r1;
#line 344 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp60_ == 0) {
#line 344 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp59_ = TRUE;
#line 2456 "chess-state.c"
			} else {
				gint _tmp61_;
#line 344 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp61_ = r1;
#line 344 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp59_ = _tmp61_ == 7;
#line 2463 "chess-state.c"
			}
#line 344 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			is_promotion = _tmp59_;
#line 347 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp62_ = victim;
#line 347 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp62_ != NULL) {
#line 348 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				ambiguous_file = TRUE;
#line 2473 "chess-state.c"
			}
#line 349 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			break;
#line 2477 "chess-state.c"
		}
#line 322 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		case PIECE_TYPE_KING:
#line 2481 "chess-state.c"
		{
			gint _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
#line 352 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp63_ = f0;
#line 352 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp64_ = f1;
#line 352 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp65_ = abs (_tmp63_ - _tmp64_);
#line 352 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp65_ > 1) {
#line 2494 "chess-state.c"
				gint _tmp66_ = 0;
				gint _tmp67_;
				gint _tmp68_;
				gint _tmp69_;
				gint _tmp70_;
				gint _tmp71_ = 0;
				gint _tmp72_;
				gint _tmp73_;
				gint _tmp76_;
				gint _tmp77_;
				gint _tmp78_;
				gint _tmp79_;
				ChessPiece* rook = NULL;
				gint _tmp84_;
				ChessPiece* _tmp85_;
				ChessPiece* _tmp86_;
				gboolean _tmp87_ = FALSE;
				gboolean _tmp88_ = FALSE;
				ChessPiece* _tmp89_;
				gint64 rook_over_mask = 0LL;
				gint _tmp96_;
				gint _tmp97_;
				gint64 _tmp98_;
				gint64 _tmp99_;
				gint64 _tmp100_;
				gint64 _tmp101_;
				CheckState _tmp102_;
				ChessPlayer* _tmp103_;
				gint _tmp104_;
				gint _tmp105_;
				gint _tmp106_;
				gint _tmp107_;
				gint _tmp108_;
				gint _tmp109_;
				gboolean _tmp110_;
#line 355 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp67_ = f1;
#line 355 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp68_ = f0;
#line 355 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp67_ > _tmp68_) {
#line 355 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp66_ = 7;
#line 2538 "chess-state.c"
				} else {
#line 355 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp66_ = 0;
#line 2542 "chess-state.c"
				}
#line 355 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp69_ = r0;
#line 355 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp70_ = chess_state_get_index (self, _tmp69_, _tmp66_);
#line 355 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				rook_start = _tmp70_;
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp72_ = f1;
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp73_ = f0;
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp72_ > _tmp73_) {
#line 2556 "chess-state.c"
					gint _tmp74_;
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp74_ = f1;
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp71_ = _tmp74_ - 1;
#line 2562 "chess-state.c"
				} else {
					gint _tmp75_;
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp75_ = f1;
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp71_ = _tmp75_ + 1;
#line 2569 "chess-state.c"
				}
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp76_ = r0;
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp77_ = chess_state_get_index (self, _tmp76_, _tmp71_);
#line 356 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				rook_end = _tmp77_;
#line 359 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp78_ = f1;
#line 359 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp79_ = f0;
#line 359 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp78_ > _tmp79_) {
#line 2583 "chess-state.c"
					Color _tmp80_;
					gboolean _tmp81_;
#line 361 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp80_ = color;
#line 361 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp81_ = self->can_castle_kingside[_tmp80_];
#line 361 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (!_tmp81_) {
#line 362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						result = FALSE;
#line 362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_g_object_unref0 (victim);
#line 362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_g_object_unref0 (piece);
#line 362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						return result;
#line 2600 "chess-state.c"
					}
				} else {
					Color _tmp82_;
					gboolean _tmp83_;
#line 366 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp82_ = color;
#line 366 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp83_ = self->can_castle_queenside[_tmp82_];
#line 366 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (!_tmp83_) {
#line 367 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						result = FALSE;
#line 367 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_g_object_unref0 (victim);
#line 367 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_g_object_unref0 (piece);
#line 367 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						return result;
#line 2619 "chess-state.c"
					}
				}
#line 370 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp84_ = rook_start;
#line 370 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp85_ = self->board[_tmp84_];
#line 370 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp86_ = _g_object_ref0 (_tmp85_);
#line 370 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				rook = _tmp86_;
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp89_ = rook;
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp89_ == NULL) {
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp88_ = TRUE;
#line 2636 "chess-state.c"
				} else {
					ChessPiece* _tmp90_;
					PieceType _tmp91_;
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp90_ = rook;
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp91_ = _tmp90_->type;
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp88_ = _tmp91_ != PIECE_TYPE_ROOK;
#line 2646 "chess-state.c"
				}
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp88_) {
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp87_ = TRUE;
#line 2652 "chess-state.c"
				} else {
					ChessPiece* _tmp92_;
					Color _tmp93_;
					Color _tmp94_;
					Color _tmp95_;
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp92_ = rook;
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp93_ = chess_piece_get_color (_tmp92_);
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp94_ = _tmp93_;
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp95_ = color;
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp87_ = _tmp94_ != _tmp95_;
#line 2668 "chess-state.c"
				}
#line 371 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp87_) {
#line 372 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 372 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (rook);
#line 372 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (victim);
#line 372 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (piece);
#line 372 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 2682 "chess-state.c"
				}
#line 375 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp96_ = rook_start;
#line 375 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp97_ = rook_end;
#line 375 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp98_ = BIT_BOARD_over_masks[(_tmp96_ * 64) + _tmp97_];
#line 375 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				rook_over_mask = _tmp98_;
#line 376 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp99_ = rook_over_mask;
#line 376 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp100_ = self->priv->piece_masks[COLOR_WHITE];
#line 376 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp101_ = self->priv->piece_masks[COLOR_BLACK];
#line 376 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if ((_tmp99_ & (_tmp100_ | _tmp101_)) != ((gint64) 0)) {
#line 377 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 377 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (rook);
#line 377 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (victim);
#line 377 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (piece);
#line 377 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 2710 "chess-state.c"
				}
#line 380 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp102_ = self->check_state;
#line 380 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp102_ == CHECK_STATE_CHECK) {
#line 381 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 381 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (rook);
#line 381 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (victim);
#line 381 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (piece);
#line 381 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 2726 "chess-state.c"
				}
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp103_ = player;
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp104_ = r0;
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp105_ = f0;
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp106_ = rook_end;
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp107_ = chess_state_get_rank (self, _tmp106_);
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp108_ = rook_end;
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp109_ = chess_state_get_file (self, _tmp108_);
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp110_ = chess_state_move_with_coords (self, _tmp103_, _tmp104_, _tmp105_, _tmp107_, _tmp109_, PIECE_TYPE_QUEEN, FALSE, TRUE);
#line 384 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!_tmp110_) {
#line 385 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 385 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (rook);
#line 385 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (victim);
#line 385 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (piece);
#line 385 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 2756 "chess-state.c"
				}
#line 352 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (rook);
#line 2760 "chess-state.c"
			}
#line 387 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			break;
#line 2764 "chess-state.c"
		}
		default:
		{
#line 389 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			break;
#line 2770 "chess-state.c"
		}
	}
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp112_ = apply;
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (!_tmp112_) {
#line 2777 "chess-state.c"
		gboolean _tmp113_;
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp113_ = test_check;
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp111_ = !_tmp113_;
#line 2783 "chess-state.c"
	} else {
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp111_ = FALSE;
#line 2787 "chess-state.c"
	}
#line 392 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp111_) {
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		result = TRUE;
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (victim);
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (piece);
#line 393 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		return result;
#line 2799 "chess-state.c"
	}
#line 396 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp114_ = apply;
#line 396 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp114_) {
#line 2805 "chess-state.c"
		{
			gint i = 0;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			i = 0;
#line 2810 "chess-state.c"
			{
				gboolean _tmp115_ = FALSE;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp115_ = TRUE;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				while (TRUE) {
#line 2817 "chess-state.c"
					gint _tmp117_;
					gint _tmp118_;
					gint _tmp119_;
					ChessPiece* p = NULL;
					gint _tmp120_;
					ChessPiece* _tmp121_;
					ChessPiece* _tmp122_;
					gboolean _tmp123_ = FALSE;
					gboolean _tmp124_ = FALSE;
					ChessPiece* _tmp125_;
					gint r = 0;
					gint _tmp133_;
					gint _tmp134_;
					gint f = 0;
					gint _tmp135_;
					gint _tmp136_;
					ChessPlayer* _tmp137_;
					gint _tmp138_;
					gint _tmp139_;
					gint _tmp140_;
					gint _tmp141_;
					gboolean _tmp142_;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (!_tmp115_) {
#line 2842 "chess-state.c"
						gint _tmp116_;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp116_ = i;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						i = _tmp116_ + 1;
#line 2848 "chess-state.c"
					}
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp115_ = FALSE;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp117_ = i;
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (!(_tmp117_ < 64)) {
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						break;
#line 2858 "chess-state.c"
					}
#line 401 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp118_ = i;
#line 401 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp119_ = start;
#line 401 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (_tmp118_ == _tmp119_) {
#line 402 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						continue;
#line 2868 "chess-state.c"
					}
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp120_ = i;
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp121_ = self->board[_tmp120_];
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp122_ = _g_object_ref0 (_tmp121_);
#line 405 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					p = _tmp122_;
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp125_ = p;
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (_tmp125_ == NULL) {
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp124_ = TRUE;
#line 2884 "chess-state.c"
					} else {
						ChessPiece* _tmp126_;
						ChessPlayer* _tmp127_;
						ChessPlayer* _tmp128_;
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp126_ = p;
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp127_ = _tmp126_->player;
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp128_ = player;
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp124_ = _tmp127_ != _tmp128_;
#line 2897 "chess-state.c"
					}
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (_tmp124_) {
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp123_ = TRUE;
#line 2903 "chess-state.c"
					} else {
						ChessPiece* _tmp129_;
						PieceType _tmp130_;
						ChessPiece* _tmp131_;
						PieceType _tmp132_;
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp129_ = p;
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp130_ = _tmp129_->type;
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp131_ = piece;
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp132_ = _tmp131_->type;
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp123_ = _tmp130_ != _tmp132_;
#line 2919 "chess-state.c"
					}
#line 406 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (_tmp123_) {
#line 407 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_g_object_unref0 (p);
#line 407 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						continue;
#line 2927 "chess-state.c"
					}
#line 410 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp133_ = i;
#line 410 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp134_ = chess_state_get_rank (self, _tmp133_);
#line 410 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					r = _tmp134_;
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp135_ = i;
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp136_ = chess_state_get_file (self, _tmp135_);
#line 411 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					f = _tmp136_;
#line 412 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp137_ = player;
#line 412 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp138_ = r;
#line 412 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp139_ = f;
#line 412 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp140_ = r1;
#line 412 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp141_ = f1;
#line 412 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp142_ = chess_state_move_with_coords (self, _tmp137_, _tmp138_, _tmp139_, _tmp140_, _tmp141_, PIECE_TYPE_QUEEN, FALSE, TRUE);
#line 412 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (_tmp142_) {
#line 2955 "chess-state.c"
						gint _tmp143_;
						gint _tmp144_;
						gint _tmp145_;
						gint _tmp146_;
#line 414 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp143_ = r;
#line 414 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp144_ = r0;
#line 414 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						if (_tmp143_ != _tmp144_) {
#line 415 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							ambiguous_rank = TRUE;
#line 2968 "chess-state.c"
						}
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp145_ = f;
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp146_ = f0;
#line 416 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						if (_tmp145_ != _tmp146_) {
#line 417 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							ambiguous_file = TRUE;
#line 2978 "chess-state.c"
						}
					}
#line 398 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 2983 "chess-state.c"
				}
			}
		}
	}
#line 422 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp147_ = self->priv->piece_masks[COLOR_WHITE];
#line 422 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	old_white_mask = _tmp147_;
#line 423 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp148_ = self->priv->piece_masks[COLOR_BLACK];
#line 423 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	old_black_mask = _tmp148_;
#line 424 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp149_ = self->can_castle_kingside[COLOR_WHITE];
#line 424 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	old_white_can_castle_kingside = _tmp149_;
#line 425 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp150_ = self->can_castle_queenside[COLOR_WHITE];
#line 425 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	old_white_can_castle_queenside = _tmp150_;
#line 426 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp151_ = self->can_castle_kingside[COLOR_BLACK];
#line 426 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	old_black_can_castle_kingside = _tmp151_;
#line 427 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp152_ = self->can_castle_queenside[COLOR_BLACK];
#line 427 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	old_black_can_castle_queenside = _tmp152_;
#line 428 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp153_ = self->en_passant_index;
#line 428 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	old_en_passant_index = _tmp153_;
#line 429 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp154_ = self->halfmove_clock;
#line 429 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	old_halfmove_clock = _tmp154_;
#line 432 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp155_ = start;
#line 432 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (self->board[_tmp155_]);
#line 432 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->board[_tmp155_] = NULL;
#line 432 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp156_ = self->board[_tmp155_];
#line 433 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp157_ = start;
#line 433 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp158_ = BIT_BOARD_clear_location_masks[_tmp157_];
#line 433 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->priv->piece_masks[COLOR_WHITE] &= _tmp158_;
#line 433 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp159_ = self->priv->piece_masks[COLOR_WHITE];
#line 434 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp160_ = start;
#line 434 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp161_ = BIT_BOARD_clear_location_masks[_tmp160_];
#line 434 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->priv->piece_masks[COLOR_BLACK] &= _tmp161_;
#line 434 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp162_ = self->priv->piece_masks[COLOR_BLACK];
#line 435 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp163_ = victim;
#line 435 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp163_ != NULL) {
#line 3048 "chess-state.c"
		gint _tmp164_;
		ChessPiece* _tmp165_;
		gint _tmp166_;
		gint64 _tmp167_;
		gint64 _tmp168_;
		gint _tmp169_;
		gint64 _tmp170_;
		gint64 _tmp171_;
#line 437 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp164_ = victim_index;
#line 437 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->board[_tmp164_]);
#line 437 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->board[_tmp164_] = NULL;
#line 437 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp165_ = self->board[_tmp164_];
#line 438 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp166_ = victim_index;
#line 438 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp167_ = BIT_BOARD_clear_location_masks[_tmp166_];
#line 438 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->priv->piece_masks[COLOR_WHITE] &= _tmp167_;
#line 438 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp168_ = self->priv->piece_masks[COLOR_WHITE];
#line 439 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp169_ = victim_index;
#line 439 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp170_ = BIT_BOARD_clear_location_masks[_tmp169_];
#line 439 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->priv->piece_masks[COLOR_BLACK] &= _tmp170_;
#line 439 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp171_ = self->priv->piece_masks[COLOR_BLACK];
#line 3081 "chess-state.c"
	}
#line 441 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp172_ = is_promotion;
#line 441 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp172_) {
#line 3087 "chess-state.c"
		gint _tmp173_;
		ChessPlayer* _tmp174_;
		PieceType _tmp175_;
		ChessPiece* _tmp176_;
		ChessPiece* _tmp177_;
#line 442 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp173_ = end;
#line 442 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp174_ = player;
#line 442 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp175_ = promotion_type;
#line 442 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp176_ = chess_piece_new (_tmp174_, _tmp175_);
#line 442 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->board[_tmp173_]);
#line 442 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->board[_tmp173_] = _tmp176_;
#line 442 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp177_ = self->board[_tmp173_];
#line 3107 "chess-state.c"
	} else {
		gint _tmp178_;
		ChessPiece* _tmp179_;
		ChessPiece* _tmp180_;
		ChessPiece* _tmp181_;
#line 444 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp178_ = end;
#line 444 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp179_ = piece;
#line 444 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp180_ = _g_object_ref0 (_tmp179_);
#line 444 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->board[_tmp178_]);
#line 444 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->board[_tmp178_] = _tmp180_;
#line 444 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp181_ = self->board[_tmp178_];
#line 3125 "chess-state.c"
	}
#line 445 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp182_ = color;
#line 445 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp183_ = end_mask;
#line 445 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->priv->piece_masks[_tmp182_] |= _tmp183_;
#line 445 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp184_ = self->priv->piece_masks[_tmp182_];
#line 446 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp185_ = opponent_color;
#line 446 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp186_ = end;
#line 446 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp187_ = BIT_BOARD_clear_location_masks[_tmp186_];
#line 446 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->priv->piece_masks[_tmp185_] &= _tmp187_;
#line 446 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp188_ = self->priv->piece_masks[_tmp185_];
#line 447 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp189_ = rook_start;
#line 447 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp189_ >= 0) {
#line 3149 "chess-state.c"
		ChessPiece* rook = NULL;
		gint _tmp190_;
		ChessPiece* _tmp191_;
		ChessPiece* _tmp192_;
		gint _tmp193_;
		ChessPiece* _tmp194_;
		Color _tmp195_;
		gint _tmp196_;
		gint64 _tmp197_;
		gint64 _tmp198_;
		gint _tmp199_;
		ChessPiece* _tmp200_;
		ChessPiece* _tmp201_;
		ChessPiece* _tmp202_;
		Color _tmp203_;
		gint _tmp204_;
		gint64 _tmp205_;
		gint64 _tmp206_;
#line 449 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp190_ = rook_start;
#line 449 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp191_ = self->board[_tmp190_];
#line 449 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp192_ = _g_object_ref0 (_tmp191_);
#line 449 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		rook = _tmp192_;
#line 450 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp193_ = rook_start;
#line 450 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->board[_tmp193_]);
#line 450 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->board[_tmp193_] = NULL;
#line 450 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp194_ = self->board[_tmp193_];
#line 451 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp195_ = color;
#line 451 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp196_ = rook_start;
#line 451 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp197_ = BIT_BOARD_clear_location_masks[_tmp196_];
#line 451 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->priv->piece_masks[_tmp195_] &= _tmp197_;
#line 451 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp198_ = self->priv->piece_masks[_tmp195_];
#line 452 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp199_ = rook_end;
#line 452 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp200_ = rook;
#line 452 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp201_ = _g_object_ref0 (_tmp200_);
#line 452 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->board[_tmp199_]);
#line 452 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->board[_tmp199_] = _tmp201_;
#line 452 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp202_ = self->board[_tmp199_];
#line 453 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp203_ = color;
#line 453 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp204_ = rook_end;
#line 453 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp205_ = BIT_BOARD_set_location_masks[_tmp204_];
#line 453 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->priv->piece_masks[_tmp203_] |= _tmp205_;
#line 453 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp206_ = self->priv->piece_masks[_tmp203_];
#line 447 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (rook);
#line 3218 "chess-state.c"
	}
#line 457 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp207_ = piece;
#line 457 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp208_ = _tmp207_->type;
#line 457 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp208_ == PIECE_TYPE_KING) {
#line 3226 "chess-state.c"
		Color _tmp209_;
		gboolean _tmp210_;
		Color _tmp211_;
		gboolean _tmp212_;
#line 459 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp209_ = color;
#line 459 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->can_castle_kingside[_tmp209_] = FALSE;
#line 459 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp210_ = self->can_castle_kingside[_tmp209_];
#line 460 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp211_ = color;
#line 460 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->can_castle_queenside[_tmp211_] = FALSE;
#line 460 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp212_ = self->can_castle_queenside[_tmp211_];
#line 3243 "chess-state.c"
	} else {
		ChessPiece* _tmp213_;
		PieceType _tmp214_;
#line 463 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp213_ = piece;
#line 463 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp214_ = _tmp213_->type;
#line 463 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (_tmp214_ == PIECE_TYPE_ROOK) {
#line 3253 "chess-state.c"
			gint _tmp215_ = 0;
			Color _tmp216_;
			gint base_rank = 0;
			gint _tmp217_;
			gint _tmp218_;
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp216_ = color;
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp216_ == COLOR_WHITE) {
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp215_ = 0;
#line 3265 "chess-state.c"
			} else {
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp215_ = 7;
#line 3269 "chess-state.c"
			}
#line 465 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			base_rank = _tmp215_;
#line 466 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp217_ = r0;
#line 466 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp218_ = base_rank;
#line 466 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp217_ == _tmp218_) {
#line 3279 "chess-state.c"
				gint _tmp219_;
#line 468 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp219_ = f0;
#line 468 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp219_ == 0) {
#line 3285 "chess-state.c"
					Color _tmp220_;
					gboolean _tmp221_;
#line 469 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp220_ = color;
#line 469 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					self->can_castle_queenside[_tmp220_] = FALSE;
#line 469 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp221_ = self->can_castle_queenside[_tmp220_];
#line 3294 "chess-state.c"
				} else {
					gint _tmp222_;
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp222_ = f0;
#line 470 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (_tmp222_ == 7) {
#line 3301 "chess-state.c"
						Color _tmp223_;
						gboolean _tmp224_;
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp223_ = color;
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						self->can_castle_kingside[_tmp223_] = FALSE;
#line 471 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp224_ = self->can_castle_kingside[_tmp223_];
#line 3310 "chess-state.c"
					}
				}
			}
		} else {
			gboolean _tmp225_ = FALSE;
			ChessPiece* _tmp226_;
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp226_ = victim;
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp226_ != NULL) {
#line 3321 "chess-state.c"
				ChessPiece* _tmp227_;
				PieceType _tmp228_;
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp227_ = victim;
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp228_ = _tmp227_->type;
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp225_ = _tmp228_ == PIECE_TYPE_ROOK;
#line 3330 "chess-state.c"
			} else {
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp225_ = FALSE;
#line 3334 "chess-state.c"
			}
#line 475 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp225_) {
#line 3338 "chess-state.c"
				gint _tmp229_ = 0;
				Color _tmp230_;
				gint base_rank = 0;
				gint _tmp231_;
				gint _tmp232_;
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp230_ = opponent_color;
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp230_ == COLOR_WHITE) {
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp229_ = 0;
#line 3350 "chess-state.c"
				} else {
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp229_ = 7;
#line 3354 "chess-state.c"
				}
#line 477 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				base_rank = _tmp229_;
#line 478 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp231_ = r1;
#line 478 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp232_ = base_rank;
#line 478 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp231_ == _tmp232_) {
#line 3364 "chess-state.c"
					gint _tmp233_;
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp233_ = f1;
#line 480 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (_tmp233_ == 0) {
#line 3370 "chess-state.c"
						Color _tmp234_;
						gboolean _tmp235_;
#line 481 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp234_ = opponent_color;
#line 481 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						self->can_castle_queenside[_tmp234_] = FALSE;
#line 481 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp235_ = self->can_castle_queenside[_tmp234_];
#line 3379 "chess-state.c"
					} else {
						gint _tmp236_;
#line 482 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp236_ = f1;
#line 482 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						if (_tmp236_ == 7) {
#line 3386 "chess-state.c"
							Color _tmp237_;
							gboolean _tmp238_;
#line 483 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp237_ = opponent_color;
#line 483 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							self->can_castle_kingside[_tmp237_] = FALSE;
#line 483 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp238_ = self->can_castle_kingside[_tmp237_];
#line 3395 "chess-state.c"
						}
					}
				}
			}
		}
	}
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp240_ = piece;
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp241_ = _tmp240_->type;
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp241_ == PIECE_TYPE_PAWN) {
#line 3408 "chess-state.c"
		gint64 _tmp242_;
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp242_ = over_mask;
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp239_ = _tmp242_ != ((gint64) 0);
#line 3414 "chess-state.c"
	} else {
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp239_ = FALSE;
#line 3418 "chess-state.c"
	}
#line 488 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp239_) {
#line 3422 "chess-state.c"
		gint _tmp243_;
		gint _tmp244_;
		gint _tmp245_;
		gint _tmp246_;
#line 489 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp243_ = r0;
#line 489 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp244_ = r1;
#line 489 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp245_ = f0;
#line 489 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp246_ = chess_state_get_index (self, (_tmp243_ + _tmp244_) / 2, _tmp245_);
#line 489 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->en_passant_index = _tmp246_;
#line 3437 "chess-state.c"
	} else {
#line 491 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->en_passant_index = -1;
#line 3441 "chess-state.c"
	}
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp248_ = piece;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp249_ = _tmp248_->type;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp249_ == PIECE_TYPE_PAWN) {
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp247_ = TRUE;
#line 3451 "chess-state.c"
	} else {
		ChessPiece* _tmp250_;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp250_ = victim;
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp247_ = _tmp250_ != NULL;
#line 3458 "chess-state.c"
	}
#line 494 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp247_) {
#line 495 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->halfmove_clock = 0;
#line 3464 "chess-state.c"
	} else {
		gint _tmp251_;
#line 497 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp251_ = self->halfmove_clock;
#line 497 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->halfmove_clock = _tmp251_ + 1;
#line 3471 "chess-state.c"
	}
#line 500 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_result_ = TRUE;
#line 501 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp253_ = test_check;
#line 501 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp253_) {
#line 3479 "chess-state.c"
		ChessPlayer* _tmp254_;
		gboolean _tmp255_;
#line 501 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp254_ = player;
#line 501 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp255_ = chess_state_is_in_check (self, _tmp254_);
#line 501 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp252_ = _tmp255_;
#line 3488 "chess-state.c"
	} else {
#line 501 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp252_ = FALSE;
#line 3492 "chess-state.c"
	}
#line 501 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp252_) {
#line 502 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_result_ = FALSE;
#line 3498 "chess-state.c"
	}
#line 505 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp257_ = apply;
#line 505 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (!_tmp257_) {
#line 505 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp256_ = TRUE;
#line 3506 "chess-state.c"
	} else {
		gboolean _tmp258_;
#line 505 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp258_ = _result_;
#line 505 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp256_ = !_tmp258_;
#line 3513 "chess-state.c"
	}
#line 505 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp256_) {
#line 3517 "chess-state.c"
		gint _tmp259_;
		ChessPiece* _tmp260_;
		ChessPiece* _tmp261_;
		ChessPiece* _tmp262_;
		gint _tmp263_;
		ChessPiece* _tmp264_;
		ChessPiece* _tmp265_;
		gint _tmp270_;
		gint64 _tmp280_;
		gint64 _tmp281_;
		gint64 _tmp282_;
		gint64 _tmp283_;
		gboolean _tmp284_;
		gboolean _tmp285_;
		gboolean _tmp286_;
		gboolean _tmp287_;
		gboolean _tmp288_;
		gboolean _tmp289_;
		gboolean _tmp290_;
		gboolean _tmp291_;
		gint _tmp292_;
		gint _tmp293_;
#line 507 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp259_ = start;
#line 507 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp260_ = piece;
#line 507 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp261_ = _g_object_ref0 (_tmp260_);
#line 507 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->board[_tmp259_]);
#line 507 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->board[_tmp259_] = _tmp261_;
#line 507 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp262_ = self->board[_tmp259_];
#line 508 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp263_ = end;
#line 508 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (self->board[_tmp263_]);
#line 508 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->board[_tmp263_] = NULL;
#line 508 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp264_ = self->board[_tmp263_];
#line 509 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp265_ = victim;
#line 509 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (_tmp265_ != NULL) {
#line 3564 "chess-state.c"
			gint _tmp266_;
			ChessPiece* _tmp267_;
			ChessPiece* _tmp268_;
			ChessPiece* _tmp269_;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp266_ = victim_index;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp267_ = victim;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp268_ = _g_object_ref0 (_tmp267_);
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_g_object_unref0 (self->board[_tmp266_]);
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			self->board[_tmp266_] = _tmp268_;
#line 510 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp269_ = self->board[_tmp266_];
#line 3581 "chess-state.c"
		}
#line 511 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp270_ = rook_start;
#line 511 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (_tmp270_ >= 0) {
#line 3587 "chess-state.c"
			ChessPiece* rook = NULL;
			gint _tmp271_;
			ChessPiece* _tmp272_;
			ChessPiece* _tmp273_;
			gint _tmp274_;
			ChessPiece* _tmp275_;
			ChessPiece* _tmp276_;
			ChessPiece* _tmp277_;
			gint _tmp278_;
			ChessPiece* _tmp279_;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp271_ = rook_end;
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp272_ = self->board[_tmp271_];
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp273_ = _g_object_ref0 (_tmp272_);
#line 513 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			rook = _tmp273_;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp274_ = rook_start;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp275_ = rook;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp276_ = _g_object_ref0 (_tmp275_);
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_g_object_unref0 (self->board[_tmp274_]);
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			self->board[_tmp274_] = _tmp276_;
#line 514 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp277_ = self->board[_tmp274_];
#line 515 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp278_ = rook_end;
#line 515 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_g_object_unref0 (self->board[_tmp278_]);
#line 515 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			self->board[_tmp278_] = NULL;
#line 515 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp279_ = self->board[_tmp278_];
#line 511 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_g_object_unref0 (rook);
#line 3628 "chess-state.c"
		}
#line 517 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp280_ = old_white_mask;
#line 517 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->priv->piece_masks[COLOR_WHITE] = _tmp280_;
#line 517 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp281_ = self->priv->piece_masks[COLOR_WHITE];
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp282_ = old_black_mask;
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->priv->piece_masks[COLOR_BLACK] = _tmp282_;
#line 518 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp283_ = self->priv->piece_masks[COLOR_BLACK];
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp284_ = old_white_can_castle_kingside;
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->can_castle_kingside[COLOR_WHITE] = _tmp284_;
#line 519 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp285_ = self->can_castle_kingside[COLOR_WHITE];
#line 520 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp286_ = old_white_can_castle_queenside;
#line 520 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->can_castle_queenside[COLOR_WHITE] = _tmp286_;
#line 520 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp287_ = self->can_castle_queenside[COLOR_WHITE];
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp288_ = old_black_can_castle_kingside;
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->can_castle_kingside[COLOR_BLACK] = _tmp288_;
#line 521 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp289_ = self->can_castle_kingside[COLOR_BLACK];
#line 522 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp290_ = old_black_can_castle_queenside;
#line 522 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->can_castle_queenside[COLOR_BLACK] = _tmp290_;
#line 522 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp291_ = self->can_castle_queenside[COLOR_BLACK];
#line 523 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp292_ = old_en_passant_index;
#line 523 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->en_passant_index = _tmp292_;
#line 524 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp293_ = old_halfmove_clock;
#line 524 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		self->halfmove_clock = _tmp293_;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		result = _result_;
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (victim);
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (piece);
#line 526 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		return result;
#line 3682 "chess-state.c"
	}
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp295_ = color;
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp295_ == COLOR_WHITE) {
#line 3688 "chess-state.c"
		ChessPlayer* _tmp296_;
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp296_ = self->players[COLOR_BLACK];
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp294_ = _tmp296_;
#line 3694 "chess-state.c"
	} else {
		ChessPlayer* _tmp297_;
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp297_ = self->players[COLOR_WHITE];
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp294_ = _tmp297_;
#line 3701 "chess-state.c"
	}
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp298_ = _g_object_ref0 (_tmp294_);
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (self->current_player);
#line 529 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->current_player = _tmp298_;
#line 530 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp299_ = self->current_player;
#line 530 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp300_ = chess_state_get_check_state (self, _tmp299_);
#line 530 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->check_state = _tmp300_;
#line 532 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp301_ = chess_move_new ();
#line 532 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (self->last_move);
#line 532 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->last_move = _tmp301_;
#line 533 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp302_ = self->last_move;
#line 533 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp303_ = self->number;
#line 533 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp302_->number = _tmp303_;
#line 534 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp304_ = self->last_move;
#line 534 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp305_ = piece;
#line 534 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp306_ = _g_object_ref0 (_tmp305_);
#line 534 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (_tmp304_->piece);
#line 534 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp304_->piece = _tmp306_;
#line 535 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp307_ = is_promotion;
#line 535 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp307_) {
#line 3741 "chess-state.c"
		ChessMove* _tmp308_;
		gint _tmp309_;
		ChessPiece* _tmp310_;
		ChessPiece* _tmp311_;
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp308_ = self->last_move;
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp309_ = end;
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp310_ = self->board[_tmp309_];
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp311_ = _g_object_ref0 (_tmp310_);
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (_tmp308_->promotion_piece);
#line 536 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp308_->promotion_piece = _tmp311_;
#line 3758 "chess-state.c"
	}
#line 537 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp312_ = self->last_move;
#line 537 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp313_ = victim;
#line 537 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp314_ = _g_object_ref0 (_tmp313_);
#line 537 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (_tmp312_->victim);
#line 537 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp312_->victim = _tmp314_;
#line 538 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp315_ = rook_end;
#line 538 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp315_ >= 0) {
#line 3774 "chess-state.c"
		ChessMove* _tmp316_;
		gint _tmp317_;
		ChessPiece* _tmp318_;
		ChessPiece* _tmp319_;
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp316_ = self->last_move;
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp317_ = rook_end;
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp318_ = self->board[_tmp317_];
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp319_ = _g_object_ref0 (_tmp318_);
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_g_object_unref0 (_tmp316_->moved_rook);
#line 539 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp316_->moved_rook = _tmp319_;
#line 3791 "chess-state.c"
	}
#line 540 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp320_ = self->last_move;
#line 540 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp321_ = r0;
#line 540 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp320_->r0 = _tmp321_;
#line 541 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp322_ = self->last_move;
#line 541 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp323_ = f0;
#line 541 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp322_->f0 = _tmp323_;
#line 542 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp324_ = self->last_move;
#line 542 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp325_ = r1;
#line 542 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp324_->r1 = _tmp325_;
#line 543 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp326_ = self->last_move;
#line 543 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp327_ = f1;
#line 543 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp326_->f1 = _tmp327_;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp328_ = self->last_move;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp329_ = ambiguous_rank;
#line 544 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp328_->ambiguous_rank = _tmp329_;
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp330_ = self->last_move;
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp331_ = ambiguous_file;
#line 545 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp330_->ambiguous_file = _tmp331_;
#line 546 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp332_ = self->last_move;
#line 546 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp333_ = self->check_state;
#line 546 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp332_->check_state = _tmp333_;
#line 548 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	result = TRUE;
#line 548 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (victim);
#line 548 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (piece);
#line 548 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return result;
#line 3843 "chess-state.c"
}


ChessResult chess_state_get_result (ChessState* self, ChessRule* rule) {
	ChessRule _vala_rule = 0;
	ChessResult result = 0;
	CheckState _tmp0_;
	ChessPlayer* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	ChessMove* _tmp7_;
#line 551 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 553 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_vala_rule = CHESS_RULE_CHECKMATE;
#line 554 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp0_ = self->check_state;
#line 554 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp0_ == CHECK_STATE_CHECKMATE) {
#line 3864 "chess-state.c"
		ChessPlayer* _tmp1_;
		Color _tmp2_;
#line 556 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp1_ = self->current_player;
#line 556 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp2_ = _tmp1_->color;
#line 556 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (_tmp2_ == COLOR_WHITE) {
#line 558 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_rule = CHESS_RULE_CHECKMATE;
#line 559 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			result = CHESS_RESULT_BLACK_WON;
#line 559 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (rule) {
#line 559 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				*rule = _vala_rule;
#line 3881 "chess-state.c"
			}
#line 559 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			return result;
#line 3885 "chess-state.c"
		} else {
#line 563 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_rule = CHESS_RULE_CHECKMATE;
#line 564 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			result = CHESS_RESULT_WHITE_WON;
#line 564 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (rule) {
#line 564 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				*rule = _vala_rule;
#line 3895 "chess-state.c"
			}
#line 564 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			return result;
#line 3899 "chess-state.c"
		}
	}
#line 568 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp3_ = self->current_player;
#line 568 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp4_ = chess_state_can_move (self, _tmp3_);
#line 568 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (!_tmp4_) {
#line 570 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_vala_rule = CHESS_RULE_STALEMATE;
#line 571 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		result = CHESS_RESULT_DRAW;
#line 571 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (rule) {
#line 571 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			*rule = _vala_rule;
#line 3916 "chess-state.c"
		}
#line 571 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		return result;
#line 3920 "chess-state.c"
	}
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp7_ = self->last_move;
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp7_ != NULL) {
#line 3926 "chess-state.c"
		ChessMove* _tmp8_;
		ChessPiece* _tmp9_;
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp8_ = self->last_move;
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp9_ = _tmp8_->victim;
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp6_ = _tmp9_ != NULL;
#line 3935 "chess-state.c"
	} else {
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp6_ = FALSE;
#line 3939 "chess-state.c"
	}
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp6_) {
#line 3943 "chess-state.c"
		gboolean _tmp10_;
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp10_ = chess_state_have_sufficient_material (self);
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp5_ = !_tmp10_;
#line 3949 "chess-state.c"
	} else {
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp5_ = FALSE;
#line 3953 "chess-state.c"
	}
#line 574 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp5_) {
#line 576 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_vala_rule = CHESS_RULE_INSUFFICIENT_MATERIAL;
#line 577 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		result = CHESS_RESULT_DRAW;
#line 577 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (rule) {
#line 577 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			*rule = _vala_rule;
#line 3965 "chess-state.c"
		}
#line 577 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		return result;
#line 3969 "chess-state.c"
	}
#line 580 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	result = CHESS_RESULT_IN_PROGRESS;
#line 580 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (rule) {
#line 580 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		*rule = _vala_rule;
#line 3977 "chess-state.c"
	}
#line 580 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return result;
#line 3981 "chess-state.c"
}


static CheckState chess_state_get_check_state (ChessState* self, ChessPlayer* player) {
	CheckState result = 0;
	ChessPlayer* _tmp0_;
	gboolean _tmp1_;
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 583 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (player != NULL, 0);
#line 585 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp0_ = player;
#line 585 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp1_ = chess_state_is_in_check (self, _tmp0_);
#line 585 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp1_) {
#line 3999 "chess-state.c"
		ChessPlayer* _tmp2_;
		gboolean _tmp3_;
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp2_ = player;
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp3_ = chess_state_is_in_checkmate (self, _tmp2_);
#line 587 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (_tmp3_) {
#line 588 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			result = CHECK_STATE_CHECKMATE;
#line 588 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			return result;
#line 4012 "chess-state.c"
		} else {
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			result = CHECK_STATE_CHECK;
#line 590 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			return result;
#line 4018 "chess-state.c"
		}
	}
#line 592 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	result = CHECK_STATE_NONE;
#line 592 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return result;
#line 4025 "chess-state.c"
}


gboolean chess_state_is_in_check (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_;
	Color _tmp2_;
	ChessPlayer* opponent = NULL;
	ChessPlayer* _tmp5_;
#line 595 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 595 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 597 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp1_ = player;
#line 597 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp2_ = _tmp1_->color;
#line 597 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 4046 "chess-state.c"
		ChessPlayer* _tmp3_;
#line 597 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp3_ = self->players[COLOR_BLACK];
#line 597 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp0_ = _tmp3_;
#line 4052 "chess-state.c"
	} else {
		ChessPlayer* _tmp4_;
#line 597 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp4_ = self->players[COLOR_WHITE];
#line 597 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp0_ = _tmp4_;
#line 4059 "chess-state.c"
	}
#line 597 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp5_ = _g_object_ref0 (_tmp0_);
#line 597 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	opponent = _tmp5_;
#line 4065 "chess-state.c"
	{
		gint king_index = 0;
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		king_index = 0;
#line 4070 "chess-state.c"
		{
			gboolean _tmp6_ = FALSE;
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp6_ = TRUE;
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 4077 "chess-state.c"
				gint _tmp8_;
				ChessPiece* p = NULL;
				gint _tmp9_;
				ChessPiece* _tmp10_;
				ChessPiece* _tmp11_;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				ChessPiece* _tmp14_;
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!_tmp6_) {
#line 4088 "chess-state.c"
					gint _tmp7_;
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp7_ = king_index;
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					king_index = _tmp7_ + 1;
#line 4094 "chess-state.c"
				}
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp6_ = FALSE;
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp8_ = king_index;
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!(_tmp8_ < 64)) {
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					break;
#line 4104 "chess-state.c"
				}
#line 602 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp9_ = king_index;
#line 602 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp10_ = self->board[_tmp9_];
#line 602 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp11_ = _g_object_ref0 (_tmp10_);
#line 602 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				p = _tmp11_;
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp14_ = p;
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp14_ != NULL) {
#line 4118 "chess-state.c"
					ChessPiece* _tmp15_;
					ChessPlayer* _tmp16_;
					ChessPlayer* _tmp17_;
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp15_ = p;
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp16_ = _tmp15_->player;
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp17_ = player;
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp13_ = _tmp16_ == _tmp17_;
#line 4130 "chess-state.c"
				} else {
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp13_ = FALSE;
#line 4134 "chess-state.c"
				}
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp13_) {
#line 4138 "chess-state.c"
					ChessPiece* _tmp18_;
					PieceType _tmp19_;
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp18_ = p;
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp19_ = _tmp18_->type;
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp12_ = _tmp19_ == PIECE_TYPE_KING;
#line 4147 "chess-state.c"
				} else {
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp12_ = FALSE;
#line 4151 "chess-state.c"
				}
#line 603 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp12_) {
#line 4155 "chess-state.c"
					{
						gint start = 0;
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						start = 0;
#line 4160 "chess-state.c"
						{
							gboolean _tmp20_ = FALSE;
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp20_ = TRUE;
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							while (TRUE) {
#line 4167 "chess-state.c"
								gint _tmp22_;
								ChessPlayer* _tmp23_;
								gint _tmp24_;
								gint _tmp25_;
								gint _tmp26_;
								gint _tmp27_;
								gint _tmp28_;
								gint _tmp29_;
								gint _tmp30_;
								gint _tmp31_;
								gboolean _tmp32_;
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								if (!_tmp20_) {
#line 4181 "chess-state.c"
									gint _tmp21_;
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									_tmp21_ = start;
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									start = _tmp21_ + 1;
#line 4187 "chess-state.c"
								}
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp20_ = FALSE;
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp22_ = start;
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								if (!(_tmp22_ < 64)) {
#line 606 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									break;
#line 4197 "chess-state.c"
								}
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp23_ = opponent;
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp24_ = start;
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp25_ = chess_state_get_rank (self, _tmp24_);
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp26_ = start;
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp27_ = chess_state_get_file (self, _tmp26_);
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp28_ = king_index;
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp29_ = chess_state_get_rank (self, _tmp28_);
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp30_ = king_index;
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp31_ = chess_state_get_file (self, _tmp30_);
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp32_ = chess_state_move_with_coords (self, _tmp23_, _tmp25_, _tmp27_, _tmp29_, _tmp31_, PIECE_TYPE_QUEEN, FALSE, FALSE);
#line 608 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								if (_tmp32_) {
#line 612 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									result = TRUE;
#line 612 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									_g_object_unref0 (p);
#line 612 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									_g_object_unref0 (opponent);
#line 612 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									return result;
#line 4229 "chess-state.c"
								}
							}
						}
					}
				}
#line 600 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (p);
#line 4237 "chess-state.c"
			}
		}
	}
#line 617 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	result = FALSE;
#line 617 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (opponent);
#line 617 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return result;
#line 4247 "chess-state.c"
}


static gboolean chess_state_is_in_checkmate (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
#line 620 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 620 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 4257 "chess-state.c"
	{
		gint piece_index = 0;
#line 623 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		piece_index = 0;
#line 4262 "chess-state.c"
		{
			gboolean _tmp0_ = FALSE;
#line 623 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp0_ = TRUE;
#line 623 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 4269 "chess-state.c"
				gint _tmp2_;
				ChessPiece* p = NULL;
				gint _tmp3_;
				ChessPiece* _tmp4_;
				ChessPiece* _tmp5_;
				gboolean _tmp6_ = FALSE;
				ChessPiece* _tmp7_;
#line 623 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!_tmp0_) {
#line 4279 "chess-state.c"
					gint _tmp1_;
#line 623 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp1_ = piece_index;
#line 623 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					piece_index = _tmp1_ + 1;
#line 4285 "chess-state.c"
				}
#line 623 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp0_ = FALSE;
#line 623 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp2_ = piece_index;
#line 623 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!(_tmp2_ < 64)) {
#line 623 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					break;
#line 4295 "chess-state.c"
				}
#line 625 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp3_ = piece_index;
#line 625 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp4_ = self->board[_tmp3_];
#line 625 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp5_ = _g_object_ref0 (_tmp4_);
#line 625 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				p = _tmp5_;
#line 626 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp7_ = p;
#line 626 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp7_ != NULL) {
#line 4309 "chess-state.c"
					ChessPiece* _tmp8_;
					ChessPlayer* _tmp9_;
					ChessPlayer* _tmp10_;
#line 626 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp8_ = p;
#line 626 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp9_ = _tmp8_->player;
#line 626 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp10_ = player;
#line 626 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp6_ = _tmp9_ == _tmp10_;
#line 4321 "chess-state.c"
				} else {
#line 626 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp6_ = FALSE;
#line 4325 "chess-state.c"
				}
#line 626 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp6_) {
#line 4329 "chess-state.c"
					{
						gint end = 0;
#line 628 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						end = 0;
#line 4334 "chess-state.c"
						{
							gboolean _tmp11_ = FALSE;
#line 628 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp11_ = TRUE;
#line 628 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							while (TRUE) {
#line 4341 "chess-state.c"
								gint _tmp13_;
								ChessPlayer* _tmp14_;
								gint _tmp15_;
								gint _tmp16_;
								gint _tmp17_;
								gint _tmp18_;
								gint _tmp19_;
								gint _tmp20_;
								gint _tmp21_;
								gint _tmp22_;
								gboolean _tmp23_;
#line 628 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								if (!_tmp11_) {
#line 4355 "chess-state.c"
									gint _tmp12_;
#line 628 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									_tmp12_ = end;
#line 628 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									end = _tmp12_ + 1;
#line 4361 "chess-state.c"
								}
#line 628 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp11_ = FALSE;
#line 628 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp13_ = end;
#line 628 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								if (!(_tmp13_ < 64)) {
#line 628 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									break;
#line 4371 "chess-state.c"
								}
#line 630 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp14_ = player;
#line 630 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp15_ = piece_index;
#line 630 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp16_ = chess_state_get_rank (self, _tmp15_);
#line 630 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp17_ = piece_index;
#line 630 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp18_ = chess_state_get_file (self, _tmp17_);
#line 630 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp19_ = end;
#line 630 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp20_ = chess_state_get_rank (self, _tmp19_);
#line 630 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp21_ = end;
#line 630 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp22_ = chess_state_get_file (self, _tmp21_);
#line 630 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp23_ = chess_state_move_with_coords (self, _tmp14_, _tmp16_, _tmp18_, _tmp20_, _tmp22_, PIECE_TYPE_QUEEN, FALSE, TRUE);
#line 630 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								if (_tmp23_) {
#line 634 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									result = FALSE;
#line 634 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									_g_object_unref0 (p);
#line 634 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									return result;
#line 4401 "chess-state.c"
								}
							}
						}
					}
				}
#line 623 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (p);
#line 4409 "chess-state.c"
			}
		}
	}
#line 639 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	result = TRUE;
#line 639 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return result;
#line 4417 "chess-state.c"
}


static gboolean chess_state_can_move (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean have_pieces = FALSE;
	gboolean _tmp24_;
#line 642 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 642 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 644 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	have_pieces = FALSE;
#line 4431 "chess-state.c"
	{
		gint start = 0;
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		start = 0;
#line 4436 "chess-state.c"
		{
			gboolean _tmp0_ = FALSE;
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp0_ = TRUE;
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 4443 "chess-state.c"
				gint _tmp2_;
				ChessPiece* p = NULL;
				gint _tmp3_;
				ChessPiece* _tmp4_;
				ChessPiece* _tmp5_;
				gboolean _tmp6_ = FALSE;
				ChessPiece* _tmp7_;
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!_tmp0_) {
#line 4453 "chess-state.c"
					gint _tmp1_;
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp1_ = start;
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					start = _tmp1_ + 1;
#line 4459 "chess-state.c"
				}
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp0_ = FALSE;
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp2_ = start;
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!(_tmp2_ < 64)) {
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					break;
#line 4469 "chess-state.c"
				}
#line 648 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp3_ = start;
#line 648 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp4_ = self->board[_tmp3_];
#line 648 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp5_ = _g_object_ref0 (_tmp4_);
#line 648 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				p = _tmp5_;
#line 649 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp7_ = p;
#line 649 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp7_ != NULL) {
#line 4483 "chess-state.c"
					ChessPiece* _tmp8_;
					ChessPlayer* _tmp9_;
					ChessPlayer* _tmp10_;
#line 649 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp8_ = p;
#line 649 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp9_ = _tmp8_->player;
#line 649 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp10_ = player;
#line 649 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp6_ = _tmp9_ == _tmp10_;
#line 4495 "chess-state.c"
				} else {
#line 649 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp6_ = FALSE;
#line 4499 "chess-state.c"
				}
#line 649 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp6_) {
#line 651 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					have_pieces = TRUE;
#line 4505 "chess-state.c"
					{
						gint end = 0;
#line 654 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						end = 0;
#line 4510 "chess-state.c"
						{
							gboolean _tmp11_ = FALSE;
#line 654 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp11_ = TRUE;
#line 654 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							while (TRUE) {
#line 4517 "chess-state.c"
								gint _tmp13_;
								ChessPlayer* _tmp14_;
								gint _tmp15_;
								gint _tmp16_;
								gint _tmp17_;
								gint _tmp18_;
								gint _tmp19_;
								gint _tmp20_;
								gint _tmp21_;
								gint _tmp22_;
								gboolean _tmp23_;
#line 654 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								if (!_tmp11_) {
#line 4531 "chess-state.c"
									gint _tmp12_;
#line 654 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									_tmp12_ = end;
#line 654 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									end = _tmp12_ + 1;
#line 4537 "chess-state.c"
								}
#line 654 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp11_ = FALSE;
#line 654 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp13_ = end;
#line 654 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								if (!(_tmp13_ < 64)) {
#line 654 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									break;
#line 4547 "chess-state.c"
								}
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp14_ = player;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp15_ = start;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp16_ = chess_state_get_rank (self, _tmp15_);
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp17_ = start;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp18_ = chess_state_get_file (self, _tmp17_);
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp19_ = end;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp20_ = chess_state_get_rank (self, _tmp19_);
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp21_ = end;
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp22_ = chess_state_get_file (self, _tmp21_);
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp23_ = chess_state_move_with_coords (self, _tmp14_, _tmp16_, _tmp18_, _tmp20_, _tmp22_, PIECE_TYPE_QUEEN, FALSE, TRUE);
#line 656 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								if (_tmp23_) {
#line 660 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									result = TRUE;
#line 660 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									_g_object_unref0 (p);
#line 660 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									return result;
#line 4577 "chess-state.c"
								}
							}
						}
					}
				}
#line 646 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (p);
#line 4585 "chess-state.c"
			}
		}
	}
#line 666 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp24_ = have_pieces;
#line 666 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp24_) {
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 667 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		return result;
#line 4597 "chess-state.c"
	} else {
#line 669 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		result = TRUE;
#line 669 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		return result;
#line 4603 "chess-state.c"
	}
}


gboolean chess_state_have_sufficient_material (ChessState* self) {
	gboolean result = FALSE;
	gint white_knight_count = 0;
	gint white_bishop_count = 0;
	gboolean white_bishop_on_white_square = FALSE;
	gboolean white_bishop_on_black_square = FALSE;
	gint black_knight_count = 0;
	gint black_bishop_count = 0;
	gboolean black_bishop_on_white_square = FALSE;
	gboolean black_bishop_on_black_square = FALSE;
#line 672 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 674 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	white_knight_count = 0;
#line 675 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	white_bishop_count = 0;
#line 676 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	white_bishop_on_white_square = FALSE;
#line 677 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	white_bishop_on_black_square = FALSE;
#line 678 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	black_knight_count = 0;
#line 679 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	black_bishop_count = 0;
#line 680 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	black_bishop_on_white_square = FALSE;
#line 681 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	black_bishop_on_black_square = FALSE;
#line 4636 "chess-state.c"
	{
		gint i = 0;
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		i = 0;
#line 4641 "chess-state.c"
		{
			gboolean _tmp0_ = FALSE;
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp0_ = TRUE;
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			while (TRUE) {
#line 4648 "chess-state.c"
				gint _tmp2_;
				ChessPiece* p = NULL;
				gint _tmp3_;
				ChessPiece* _tmp4_;
				ChessPiece* _tmp5_;
				ChessPiece* _tmp6_;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				ChessPiece* _tmp9_;
				PieceType _tmp10_;
				ChessPiece* _tmp15_;
				PieceType _tmp16_;
				ChessPiece* _tmp22_;
				PieceType _tmp23_;
				gboolean _tmp33_ = FALSE;
				gint _tmp34_;
				gboolean _tmp36_ = FALSE;
				gint _tmp37_;
				gboolean _tmp39_ = FALSE;
				gint _tmp40_;
				gboolean _tmp42_ = FALSE;
				gboolean _tmp43_;
				gboolean _tmp45_ = FALSE;
				gboolean _tmp46_;
				gboolean _tmp48_ = FALSE;
				gboolean _tmp49_ = FALSE;
				gint _tmp50_;
				gboolean _tmp53_ = FALSE;
				gboolean _tmp54_ = FALSE;
				gint _tmp55_;
				gboolean _tmp58_ = FALSE;
				gint _tmp59_;
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!_tmp0_) {
#line 4683 "chess-state.c"
					gint _tmp1_;
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp1_ = i;
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					i = _tmp1_ + 1;
#line 4689 "chess-state.c"
				}
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp0_ = FALSE;
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp2_ = i;
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (!(_tmp2_ < 64)) {
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					break;
#line 4699 "chess-state.c"
				}
#line 685 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp3_ = i;
#line 685 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp4_ = self->board[_tmp3_];
#line 685 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp5_ = _g_object_ref0 (_tmp4_);
#line 685 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				p = _tmp5_;
#line 686 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp6_ = p;
#line 686 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp6_ == NULL) {
#line 687 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 687 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					continue;
#line 4717 "chess-state.c"
				}
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp9_ = p;
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp10_ = _tmp9_->type;
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp10_ == PIECE_TYPE_PAWN) {
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp8_ = TRUE;
#line 4727 "chess-state.c"
				} else {
					ChessPiece* _tmp11_;
					PieceType _tmp12_;
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp11_ = p;
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp12_ = _tmp11_->type;
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp8_ = _tmp12_ == PIECE_TYPE_ROOK;
#line 4737 "chess-state.c"
				}
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp8_) {
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp7_ = TRUE;
#line 4743 "chess-state.c"
				} else {
					ChessPiece* _tmp13_;
					PieceType _tmp14_;
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp13_ = p;
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp14_ = _tmp13_->type;
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp7_ = _tmp14_ == PIECE_TYPE_QUEEN;
#line 4753 "chess-state.c"
				}
#line 690 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp7_) {
#line 691 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 691 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 691 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 4763 "chess-state.c"
				}
#line 694 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp15_ = p;
#line 694 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp16_ = _tmp15_->type;
#line 694 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp16_ == PIECE_TYPE_KNIGHT) {
#line 4771 "chess-state.c"
					ChessPiece* _tmp17_;
					Color _tmp18_;
					Color _tmp19_;
#line 696 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp17_ = p;
#line 696 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp18_ = chess_piece_get_color (_tmp17_);
#line 696 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp19_ = _tmp18_;
#line 696 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (_tmp19_ == COLOR_WHITE) {
#line 4783 "chess-state.c"
						gint _tmp20_;
#line 697 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp20_ = white_knight_count;
#line 697 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						white_knight_count = _tmp20_ + 1;
#line 4789 "chess-state.c"
					} else {
						gint _tmp21_;
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp21_ = black_knight_count;
#line 699 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						black_knight_count = _tmp21_ + 1;
#line 4796 "chess-state.c"
					}
				}
#line 702 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp22_ = p;
#line 702 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp23_ = _tmp22_->type;
#line 702 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp23_ == PIECE_TYPE_BISHOP) {
#line 4805 "chess-state.c"
					Color color = 0;
					gint _tmp24_;
					gint _tmp25_;
					ChessPiece* _tmp26_;
					Color _tmp27_;
					Color _tmp28_;
#line 704 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					color = COLOR_BLACK;
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp24_ = i;
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp25_ = i;
#line 705 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (((_tmp24_ + (_tmp25_ / 8)) % 2) != 0) {
#line 706 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						color = COLOR_WHITE;
#line 4822 "chess-state.c"
					}
#line 708 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp26_ = p;
#line 708 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp27_ = chess_piece_get_color (_tmp26_);
#line 708 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp28_ = _tmp27_;
#line 708 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (_tmp28_ == COLOR_WHITE) {
#line 4832 "chess-state.c"
						Color _tmp29_;
						gint _tmp30_;
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp29_ = color;
#line 710 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						if (_tmp29_ == COLOR_WHITE) {
#line 711 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							white_bishop_on_white_square = TRUE;
#line 4841 "chess-state.c"
						} else {
#line 713 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							white_bishop_on_black_square = TRUE;
#line 4845 "chess-state.c"
						}
#line 714 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp30_ = white_bishop_count;
#line 714 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						white_bishop_count = _tmp30_ + 1;
#line 4851 "chess-state.c"
					} else {
						Color _tmp31_;
						gint _tmp32_;
#line 718 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp31_ = color;
#line 718 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						if (_tmp31_ == COLOR_WHITE) {
#line 719 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							black_bishop_on_white_square = TRUE;
#line 4861 "chess-state.c"
						} else {
#line 721 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							black_bishop_on_black_square = TRUE;
#line 4865 "chess-state.c"
						}
#line 722 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp32_ = black_bishop_count;
#line 722 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						black_bishop_count = _tmp32_ + 1;
#line 4871 "chess-state.c"
					}
				}
#line 756 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp34_ = white_knight_count;
#line 756 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp34_ > 1) {
#line 756 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp33_ = TRUE;
#line 4880 "chess-state.c"
				} else {
					gint _tmp35_;
#line 756 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp35_ = black_knight_count;
#line 756 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp33_ = _tmp35_ > 1;
#line 4887 "chess-state.c"
				}
#line 756 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp33_) {
#line 757 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 757 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 757 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 4897 "chess-state.c"
				}
#line 760 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp37_ = white_bishop_count;
#line 760 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp37_ > 0) {
#line 4903 "chess-state.c"
					gint _tmp38_;
#line 760 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp38_ = white_knight_count;
#line 760 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp36_ = _tmp38_ > 0;
#line 4909 "chess-state.c"
				} else {
#line 760 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp36_ = FALSE;
#line 4913 "chess-state.c"
				}
#line 760 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp36_) {
#line 761 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 761 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 761 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 4923 "chess-state.c"
				}
#line 762 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp40_ = black_bishop_count;
#line 762 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp40_ > 0) {
#line 4929 "chess-state.c"
					gint _tmp41_;
#line 762 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp41_ = black_knight_count;
#line 762 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp39_ = _tmp41_ > 0;
#line 4935 "chess-state.c"
				} else {
#line 762 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp39_ = FALSE;
#line 4939 "chess-state.c"
				}
#line 762 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp39_) {
#line 763 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 763 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 763 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 4949 "chess-state.c"
				}
#line 766 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp43_ = white_bishop_on_white_square;
#line 766 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp43_) {
#line 4955 "chess-state.c"
					gboolean _tmp44_;
#line 766 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp44_ = white_bishop_on_black_square;
#line 766 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp42_ = _tmp44_;
#line 4961 "chess-state.c"
				} else {
#line 766 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp42_ = FALSE;
#line 4965 "chess-state.c"
				}
#line 766 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp42_) {
#line 767 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 767 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 767 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 4975 "chess-state.c"
				}
#line 768 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp46_ = black_bishop_on_white_square;
#line 768 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp46_) {
#line 4981 "chess-state.c"
					gboolean _tmp47_;
#line 768 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp47_ = black_bishop_on_black_square;
#line 768 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp45_ = _tmp47_;
#line 4987 "chess-state.c"
				} else {
#line 768 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp45_ = FALSE;
#line 4991 "chess-state.c"
				}
#line 768 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp45_) {
#line 769 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 769 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 769 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 5001 "chess-state.c"
				}
#line 772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp50_ = white_bishop_count;
#line 772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp50_ > 0) {
#line 772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp49_ = TRUE;
#line 5009 "chess-state.c"
				} else {
					gint _tmp51_;
#line 772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp51_ = white_knight_count;
#line 772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp49_ = _tmp51_ > 0;
#line 5016 "chess-state.c"
				}
#line 772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp49_) {
#line 5020 "chess-state.c"
					gint _tmp52_;
#line 772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp52_ = black_knight_count;
#line 772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp48_ = _tmp52_ > 0;
#line 5026 "chess-state.c"
				} else {
#line 772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp48_ = FALSE;
#line 5030 "chess-state.c"
				}
#line 772 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp48_) {
#line 773 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 773 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 773 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 5040 "chess-state.c"
				}
#line 774 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp55_ = black_bishop_count;
#line 774 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp55_ > 0) {
#line 774 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp54_ = TRUE;
#line 5048 "chess-state.c"
				} else {
					gint _tmp56_;
#line 774 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp56_ = black_knight_count;
#line 774 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp54_ = _tmp56_ > 0;
#line 5055 "chess-state.c"
				}
#line 774 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp54_) {
#line 5059 "chess-state.c"
					gint _tmp57_;
#line 774 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp57_ = white_knight_count;
#line 774 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp53_ = _tmp57_ > 0;
#line 5065 "chess-state.c"
				} else {
#line 774 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp53_ = FALSE;
#line 5069 "chess-state.c"
				}
#line 774 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp53_) {
#line 775 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = TRUE;
#line 775 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_g_object_unref0 (p);
#line 775 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 5079 "chess-state.c"
				}
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp59_ = white_bishop_count;
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp59_ > 0) {
#line 5085 "chess-state.c"
					gint _tmp60_;
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp60_ = black_bishop_count;
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp58_ = _tmp60_ > 0;
#line 5091 "chess-state.c"
				} else {
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp58_ = FALSE;
#line 5095 "chess-state.c"
				}
#line 778 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp58_) {
#line 5099 "chess-state.c"
					gboolean _tmp61_ = FALSE;
					gboolean _tmp62_;
#line 780 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp62_ = white_bishop_on_white_square;
#line 780 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (_tmp62_) {
#line 5106 "chess-state.c"
						gboolean _tmp63_;
#line 780 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp63_ = black_bishop_on_black_square;
#line 780 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp61_ = _tmp63_;
#line 5112 "chess-state.c"
					} else {
#line 780 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp61_ = FALSE;
#line 5116 "chess-state.c"
					}
#line 780 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (_tmp61_) {
#line 781 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						result = TRUE;
#line 781 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_g_object_unref0 (p);
#line 781 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						return result;
#line 5126 "chess-state.c"
					} else {
						gboolean _tmp64_ = FALSE;
						gboolean _tmp65_;
#line 782 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp65_ = white_bishop_on_black_square;
#line 782 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						if (_tmp65_) {
#line 5134 "chess-state.c"
							gboolean _tmp66_;
#line 782 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp66_ = black_bishop_on_white_square;
#line 782 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp64_ = _tmp66_;
#line 5140 "chess-state.c"
						} else {
#line 782 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp64_ = FALSE;
#line 5144 "chess-state.c"
						}
#line 782 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						if (_tmp64_) {
#line 783 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							result = TRUE;
#line 783 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_g_object_unref0 (p);
#line 783 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							return result;
#line 5154 "chess-state.c"
						}
					}
				}
#line 683 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_g_object_unref0 (p);
#line 5160 "chess-state.c"
			}
		}
	}
#line 787 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	result = FALSE;
#line 787 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return result;
#line 5168 "chess-state.c"
}


static gboolean chess_state_decode_piece_type (ChessState* self, gunichar c, PieceType* type) {
	PieceType _vala_type = 0;
	gboolean result = FALSE;
	gunichar _tmp0_;
#line 790 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 792 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_vala_type = PIECE_TYPE_PAWN;
#line 793 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp0_ = c;
#line 793 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	switch (_tmp0_) {
#line 793 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		case 'P':
#line 5186 "chess-state.c"
		{
#line 796 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_type = PIECE_TYPE_PAWN;
#line 797 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			result = TRUE;
#line 797 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (type) {
#line 797 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				*type = _vala_type;
#line 5196 "chess-state.c"
			}
#line 797 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			return result;
#line 5200 "chess-state.c"
		}
#line 793 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		case 'R':
#line 5204 "chess-state.c"
		{
#line 799 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_type = PIECE_TYPE_ROOK;
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			result = TRUE;
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (type) {
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				*type = _vala_type;
#line 5214 "chess-state.c"
			}
#line 800 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			return result;
#line 5218 "chess-state.c"
		}
#line 793 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		case 'N':
#line 5222 "chess-state.c"
		{
#line 802 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_type = PIECE_TYPE_KNIGHT;
#line 803 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			result = TRUE;
#line 803 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (type) {
#line 803 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				*type = _vala_type;
#line 5232 "chess-state.c"
			}
#line 803 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			return result;
#line 5236 "chess-state.c"
		}
#line 793 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		case 'B':
#line 5240 "chess-state.c"
		{
#line 805 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_type = PIECE_TYPE_BISHOP;
#line 806 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			result = TRUE;
#line 806 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (type) {
#line 806 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				*type = _vala_type;
#line 5250 "chess-state.c"
			}
#line 806 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			return result;
#line 5254 "chess-state.c"
		}
#line 793 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		case 'Q':
#line 5258 "chess-state.c"
		{
#line 808 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_type = PIECE_TYPE_QUEEN;
#line 809 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			result = TRUE;
#line 809 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (type) {
#line 809 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				*type = _vala_type;
#line 5268 "chess-state.c"
			}
#line 809 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			return result;
#line 5272 "chess-state.c"
		}
#line 793 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		case 'K':
#line 5276 "chess-state.c"
		{
#line 811 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_type = PIECE_TYPE_KING;
#line 812 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			result = TRUE;
#line 812 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (type) {
#line 812 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				*type = _vala_type;
#line 5286 "chess-state.c"
			}
#line 812 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			return result;
#line 5290 "chess-state.c"
		}
		default:
		{
#line 814 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			result = FALSE;
#line 814 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (type) {
#line 814 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				*type = _vala_type;
#line 5300 "chess-state.c"
			}
#line 814 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			return result;
#line 5304 "chess-state.c"
		}
	}
#line 790 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (type) {
#line 790 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		*type = _vala_type;
#line 5311 "chess-state.c"
	}
}


static gboolean chess_state_decode_move (ChessState* self, ChessPlayer* player, const gchar* move, gint* r0, gint* f0, gint* r1, gint* f1, PieceType* promotion_type) {
	gint _vala_r0 = 0;
	gint _vala_f0 = 0;
	gint _vala_r1 = 0;
	gint _vala_f1 = 0;
	PieceType _vala_promotion_type = 0;
	gboolean result = FALSE;
	gint i = 0;
	const gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp150_;
	gint _tmp151_;
	gchar _tmp152_;
	const gchar* _tmp158_;
	gint _tmp159_;
	gchar _tmp160_;
#line 818 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 818 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 818 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (move != NULL, FALSE);
#line 820 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	i = 0;
#line 822 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_vala_promotion_type = PIECE_TYPE_QUEEN;
#line 823 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp0_ = move;
#line 823 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp1_ = g_str_has_prefix (_tmp0_, "O-O-O");
#line 823 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp1_) {
#line 5348 "chess-state.c"
		ChessPlayer* _tmp2_;
		Color _tmp3_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
#line 825 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp2_ = player;
#line 825 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp3_ = _tmp2_->color;
#line 825 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (_tmp3_ == COLOR_WHITE) {
#line 5360 "chess-state.c"
			gint _tmp4_;
#line 826 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_r1 = 0;
#line 826 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp4_ = _vala_r1;
#line 826 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_r0 = _tmp4_;
#line 5368 "chess-state.c"
		} else {
			gint _tmp5_;
#line 828 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_r1 = 7;
#line 828 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp5_ = _vala_r1;
#line 828 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_r0 = _tmp5_;
#line 5377 "chess-state.c"
		}
#line 829 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_vala_f0 = 4;
#line 830 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_vala_f1 = 2;
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp6_ = i;
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp7_ = strlen ("O-O-O");
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp8_ = _tmp7_;
#line 831 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		i = _tmp6_ + ((gint) _tmp8_);
#line 5391 "chess-state.c"
	} else {
		const gchar* _tmp9_;
		gboolean _tmp10_;
#line 833 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp9_ = move;
#line 833 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp10_ = g_str_has_prefix (_tmp9_, "O-O");
#line 833 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (_tmp10_) {
#line 5401 "chess-state.c"
			ChessPlayer* _tmp11_;
			Color _tmp12_;
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
#line 835 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp11_ = player;
#line 835 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp12_ = _tmp11_->color;
#line 835 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp12_ == COLOR_WHITE) {
#line 5413 "chess-state.c"
				gint _tmp13_;
#line 836 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_vala_r1 = 0;
#line 836 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp13_ = _vala_r1;
#line 836 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_vala_r0 = _tmp13_;
#line 5421 "chess-state.c"
			} else {
				gint _tmp14_;
#line 838 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_vala_r1 = 7;
#line 838 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp14_ = _vala_r1;
#line 838 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_vala_r0 = _tmp14_;
#line 5430 "chess-state.c"
			}
#line 839 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_f0 = 4;
#line 840 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_f1 = 6;
#line 841 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp15_ = i;
#line 841 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp16_ = strlen ("O-O");
#line 841 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp17_ = _tmp16_;
#line 841 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			i = _tmp15_ + ((gint) _tmp17_);
#line 5444 "chess-state.c"
		} else {
			PieceType type = 0;
			const gchar* _tmp18_;
			gint _tmp19_;
			gchar _tmp20_;
			PieceType _tmp21_ = 0;
			gboolean _tmp22_;
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gboolean _tmp27_ = FALSE;
			const gchar* _tmp28_;
			gint _tmp29_;
			gchar _tmp30_;
			gboolean _tmp38_ = FALSE;
			const gchar* _tmp39_;
			gint _tmp40_;
			gchar _tmp41_;
			gboolean _tmp49_ = FALSE;
			const gchar* _tmp50_;
			gint _tmp51_;
			gchar _tmp52_;
			gboolean _tmp57_ = FALSE;
			const gchar* _tmp58_;
			gint _tmp59_;
			gchar _tmp60_;
			gboolean _tmp69_ = FALSE;
			const gchar* _tmp70_;
			gint _tmp71_;
			gchar _tmp72_;
			const gchar* _tmp81_;
			gint _tmp82_;
			gchar _tmp83_;
			gboolean _tmp101_ = FALSE;
			gint _tmp102_;
			gboolean _tmp105_ = FALSE;
			gint _tmp106_;
#line 845 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			type = PIECE_TYPE_PAWN;
#line 846 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp18_ = move;
#line 846 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp19_ = i;
#line 846 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp20_ = string_get (_tmp18_, (glong) _tmp19_);
#line 846 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp22_ = chess_state_decode_piece_type (self, (gunichar) _tmp20_, &_tmp21_);
#line 846 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			type = _tmp21_;
#line 846 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp22_) {
#line 5496 "chess-state.c"
				gint _tmp23_;
#line 847 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp23_ = i;
#line 847 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				i = _tmp23_ + 1;
#line 5502 "chess-state.c"
			}
#line 849 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_f1 = -1;
#line 849 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp24_ = _vala_f1;
#line 849 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_r1 = _tmp24_;
#line 849 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp25_ = _vala_r1;
#line 849 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_f0 = _tmp25_;
#line 849 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp26_ = _vala_f0;
#line 849 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_vala_r0 = _tmp26_;
#line 850 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp28_ = move;
#line 850 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp29_ = i;
#line 850 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp30_ = string_get (_tmp28_, (glong) _tmp29_);
#line 850 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp30_ >= 'a') {
#line 5526 "chess-state.c"
				const gchar* _tmp31_;
				gint _tmp32_;
				gchar _tmp33_;
#line 850 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp31_ = move;
#line 850 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp32_ = i;
#line 850 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp33_ = string_get (_tmp31_, (glong) _tmp32_);
#line 850 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp27_ = _tmp33_ <= 'h';
#line 5538 "chess-state.c"
			} else {
#line 850 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp27_ = FALSE;
#line 5542 "chess-state.c"
			}
#line 850 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp27_) {
#line 5546 "chess-state.c"
				const gchar* _tmp34_;
				gint _tmp35_;
				gchar _tmp36_;
				gint _tmp37_;
#line 852 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp34_ = move;
#line 852 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp35_ = i;
#line 852 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp36_ = string_get (_tmp34_, (glong) _tmp35_);
#line 852 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_vala_f1 = (gint) (_tmp36_ - 'a');
#line 853 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp37_ = i;
#line 853 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				i = _tmp37_ + 1;
#line 5563 "chess-state.c"
			}
#line 855 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp39_ = move;
#line 855 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp40_ = i;
#line 855 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp41_ = string_get (_tmp39_, (glong) _tmp40_);
#line 855 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp41_ >= '1') {
#line 5573 "chess-state.c"
				const gchar* _tmp42_;
				gint _tmp43_;
				gchar _tmp44_;
#line 855 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp42_ = move;
#line 855 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp43_ = i;
#line 855 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp44_ = string_get (_tmp42_, (glong) _tmp43_);
#line 855 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp38_ = _tmp44_ <= '8';
#line 5585 "chess-state.c"
			} else {
#line 855 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp38_ = FALSE;
#line 5589 "chess-state.c"
			}
#line 855 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp38_) {
#line 5593 "chess-state.c"
				const gchar* _tmp45_;
				gint _tmp46_;
				gchar _tmp47_;
				gint _tmp48_;
#line 857 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp45_ = move;
#line 857 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp46_ = i;
#line 857 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp47_ = string_get (_tmp45_, (glong) _tmp46_);
#line 857 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_vala_r1 = (gint) (_tmp47_ - '1');
#line 858 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp48_ = i;
#line 858 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				i = _tmp48_ + 1;
#line 5610 "chess-state.c"
			}
#line 860 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp50_ = move;
#line 860 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp51_ = i;
#line 860 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp52_ = string_get (_tmp50_, (glong) _tmp51_);
#line 860 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp52_ == 'x') {
#line 860 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp49_ = TRUE;
#line 5622 "chess-state.c"
			} else {
				const gchar* _tmp53_;
				gint _tmp54_;
				gchar _tmp55_;
#line 860 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp53_ = move;
#line 860 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp54_ = i;
#line 860 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp55_ = string_get (_tmp53_, (glong) _tmp54_);
#line 860 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp49_ = _tmp55_ == '-';
#line 5635 "chess-state.c"
			}
#line 860 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp49_) {
#line 5639 "chess-state.c"
				gint _tmp56_;
#line 861 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp56_ = i;
#line 861 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				i = _tmp56_ + 1;
#line 5645 "chess-state.c"
			}
#line 862 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp58_ = move;
#line 862 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp59_ = i;
#line 862 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp60_ = string_get (_tmp58_, (glong) _tmp59_);
#line 862 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp60_ >= 'a') {
#line 5655 "chess-state.c"
				const gchar* _tmp61_;
				gint _tmp62_;
				gchar _tmp63_;
#line 862 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp61_ = move;
#line 862 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp62_ = i;
#line 862 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp63_ = string_get (_tmp61_, (glong) _tmp62_);
#line 862 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp57_ = _tmp63_ <= 'h';
#line 5667 "chess-state.c"
			} else {
#line 862 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp57_ = FALSE;
#line 5671 "chess-state.c"
			}
#line 862 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp57_) {
#line 5675 "chess-state.c"
				gint _tmp64_;
				const gchar* _tmp65_;
				gint _tmp66_;
				gchar _tmp67_;
				gint _tmp68_;
#line 864 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp64_ = _vala_f1;
#line 864 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_vala_f0 = _tmp64_;
#line 865 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp65_ = move;
#line 865 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp66_ = i;
#line 865 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp67_ = string_get (_tmp65_, (glong) _tmp66_);
#line 865 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_vala_f1 = (gint) (_tmp67_ - 'a');
#line 866 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp68_ = i;
#line 866 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				i = _tmp68_ + 1;
#line 5697 "chess-state.c"
			}
#line 868 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp70_ = move;
#line 868 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp71_ = i;
#line 868 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp72_ = string_get (_tmp70_, (glong) _tmp71_);
#line 868 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp72_ >= '1') {
#line 5707 "chess-state.c"
				const gchar* _tmp73_;
				gint _tmp74_;
				gchar _tmp75_;
#line 868 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp73_ = move;
#line 868 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp74_ = i;
#line 868 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp75_ = string_get (_tmp73_, (glong) _tmp74_);
#line 868 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp69_ = _tmp75_ <= '8';
#line 5719 "chess-state.c"
			} else {
#line 868 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp69_ = FALSE;
#line 5723 "chess-state.c"
			}
#line 868 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp69_) {
#line 5727 "chess-state.c"
				gint _tmp76_;
				const gchar* _tmp77_;
				gint _tmp78_;
				gchar _tmp79_;
				gint _tmp80_;
#line 870 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp76_ = _vala_r1;
#line 870 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_vala_r0 = _tmp76_;
#line 871 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp77_ = move;
#line 871 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp78_ = i;
#line 871 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp79_ = string_get (_tmp77_, (glong) _tmp78_);
#line 871 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_vala_r1 = (gint) (_tmp79_ - '1');
#line 872 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp80_ = i;
#line 872 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				i = _tmp80_ + 1;
#line 5749 "chess-state.c"
			}
#line 874 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp81_ = move;
#line 874 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp82_ = i;
#line 874 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp83_ = string_get (_tmp81_, (glong) _tmp82_);
#line 874 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp83_ == '=') {
#line 5759 "chess-state.c"
				gint _tmp84_;
				const gchar* _tmp85_;
				gint _tmp86_;
				gchar _tmp87_;
				PieceType _tmp88_ = 0;
				gboolean _tmp89_;
#line 876 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp84_ = i;
#line 876 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				i = _tmp84_ + 1;
#line 877 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp85_ = move;
#line 877 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp86_ = i;
#line 877 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp87_ = string_get (_tmp85_, (glong) _tmp86_);
#line 877 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp89_ = chess_state_decode_piece_type (self, (gunichar) _tmp87_, &_tmp88_);
#line 877 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_vala_promotion_type = _tmp88_;
#line 877 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp89_) {
#line 5782 "chess-state.c"
					gint _tmp90_;
#line 878 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp90_ = i;
#line 878 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					i = _tmp90_ + 1;
#line 5788 "chess-state.c"
				}
			} else {
				const gchar* _tmp91_;
				gint _tmp92_;
				gchar _tmp93_;
#line 880 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp91_ = move;
#line 880 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp92_ = i;
#line 880 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp93_ = string_get (_tmp91_, (glong) _tmp92_);
#line 880 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp93_ != '\0') {
#line 5802 "chess-state.c"
					const gchar* _tmp94_;
					gint _tmp95_;
					gchar _tmp96_;
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp94_ = move;
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp95_ = i;
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp96_ = string_get (_tmp94_, (glong) _tmp95_);
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					switch (_tmp96_) {
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						case 'q':
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						case 'Q':
#line 5818 "chess-state.c"
						{
							gint _tmp97_;
#line 886 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_vala_promotion_type = PIECE_TYPE_QUEEN;
#line 887 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp97_ = i;
#line 887 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							i = _tmp97_ + 1;
#line 888 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							break;
#line 5829 "chess-state.c"
						}
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						case 'n':
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						case 'N':
#line 5835 "chess-state.c"
						{
							gint _tmp98_;
#line 891 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_vala_promotion_type = PIECE_TYPE_KNIGHT;
#line 892 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp98_ = i;
#line 892 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							i = _tmp98_ + 1;
#line 893 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							break;
#line 5846 "chess-state.c"
						}
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						case 'r':
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						case 'R':
#line 5852 "chess-state.c"
						{
							gint _tmp99_;
#line 896 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_vala_promotion_type = PIECE_TYPE_ROOK;
#line 897 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp99_ = i;
#line 897 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							i = _tmp99_ + 1;
#line 898 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							break;
#line 5863 "chess-state.c"
						}
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						case 'b':
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						case 'B':
#line 5869 "chess-state.c"
						{
							gint _tmp100_;
#line 901 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_vala_promotion_type = PIECE_TYPE_BISHOP;
#line 902 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp100_ = i;
#line 902 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							i = _tmp100_ + 1;
#line 903 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							break;
#line 5880 "chess-state.c"
						}
						default:
#line 882 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						break;
#line 5885 "chess-state.c"
					}
				}
			}
#line 908 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp102_ = _vala_r1;
#line 908 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp102_ < 0) {
#line 908 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp101_ = TRUE;
#line 5895 "chess-state.c"
			} else {
				gint _tmp103_;
#line 908 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp103_ = _vala_f1;
#line 908 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp101_ = _tmp103_ < 0;
#line 5902 "chess-state.c"
			}
#line 908 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp101_) {
#line 5906 "chess-state.c"
				const gchar* _tmp104_;
#line 910 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp104_ = move;
#line 910 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				g_debug ("chess-state.vala:910: Move %s missing destination", _tmp104_);
#line 911 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				result = FALSE;
#line 911 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (r0) {
#line 911 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					*r0 = _vala_r0;
#line 5918 "chess-state.c"
				}
#line 911 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (f0) {
#line 911 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					*f0 = _vala_f0;
#line 5924 "chess-state.c"
				}
#line 911 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (r1) {
#line 911 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					*r1 = _vala_r1;
#line 5930 "chess-state.c"
				}
#line 911 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (f1) {
#line 911 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					*f1 = _vala_f1;
#line 5936 "chess-state.c"
				}
#line 911 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (promotion_type) {
#line 911 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					*promotion_type = _vala_promotion_type;
#line 5942 "chess-state.c"
				}
#line 911 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				return result;
#line 5946 "chess-state.c"
			}
#line 915 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp106_ = _vala_r0;
#line 915 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp106_ < 0) {
#line 915 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp105_ = TRUE;
#line 5954 "chess-state.c"
			} else {
				gint _tmp107_;
#line 915 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp107_ = _vala_f0;
#line 915 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp105_ = _tmp107_ < 0;
#line 5961 "chess-state.c"
			}
#line 915 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			if (_tmp105_) {
#line 5965 "chess-state.c"
				gint match_rank = 0;
				gint match_file = 0;
				gint _tmp146_;
				gint _tmp148_;
				gint _tmp149_;
#line 917 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				match_rank = -1;
#line 917 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				match_file = -1;
#line 5975 "chess-state.c"
				{
					gint file = 0;
#line 919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					file = 0;
#line 5980 "chess-state.c"
					{
						gboolean _tmp108_ = FALSE;
#line 919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						_tmp108_ = TRUE;
#line 919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						while (TRUE) {
#line 5987 "chess-state.c"
							gint _tmp110_;
							gboolean _tmp111_ = FALSE;
							gint _tmp112_;
#line 919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							if (!_tmp108_) {
#line 5993 "chess-state.c"
								gint _tmp109_;
#line 919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp109_ = file;
#line 919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								file = _tmp109_ + 1;
#line 5999 "chess-state.c"
							}
#line 919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp108_ = FALSE;
#line 919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp110_ = file;
#line 919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							if (!(_tmp110_ < 8)) {
#line 919 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								break;
#line 6009 "chess-state.c"
							}
#line 921 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							_tmp112_ = _vala_f0;
#line 921 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							if (_tmp112_ >= 0) {
#line 6015 "chess-state.c"
								gint _tmp113_;
								gint _tmp114_;
#line 921 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp113_ = file;
#line 921 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp114_ = _vala_f0;
#line 921 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp111_ = _tmp113_ != _tmp114_;
#line 6024 "chess-state.c"
							} else {
#line 921 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								_tmp111_ = FALSE;
#line 6028 "chess-state.c"
							}
#line 921 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
							if (_tmp111_) {
#line 922 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								continue;
#line 6034 "chess-state.c"
							}
							{
								gint rank = 0;
#line 924 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
								rank = 0;
#line 6040 "chess-state.c"
								{
									gboolean _tmp115_ = FALSE;
#line 924 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									_tmp115_ = TRUE;
#line 924 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
									while (TRUE) {
#line 6047 "chess-state.c"
										gint _tmp117_;
										gboolean _tmp118_ = FALSE;
										gint _tmp119_;
										ChessPiece* piece = NULL;
										gint _tmp122_;
										gint _tmp123_;
										gint _tmp124_;
										ChessPiece* _tmp125_;
										ChessPiece* _tmp126_;
										gboolean _tmp127_ = FALSE;
										gboolean _tmp128_ = FALSE;
										ChessPiece* _tmp129_;
										ChessPlayer* _tmp136_;
										gint _tmp137_;
										gint _tmp138_;
										gint _tmp139_;
										gint _tmp140_;
										gboolean _tmp141_;
										gint _tmp142_;
										gint _tmp144_;
										gint _tmp145_;
#line 924 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										if (!_tmp115_) {
#line 6071 "chess-state.c"
											gint _tmp116_;
#line 924 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp116_ = rank;
#line 924 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											rank = _tmp116_ + 1;
#line 6077 "chess-state.c"
										}
#line 924 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp115_ = FALSE;
#line 924 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp117_ = rank;
#line 924 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										if (!(_tmp117_ < 8)) {
#line 924 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											break;
#line 6087 "chess-state.c"
										}
#line 926 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp119_ = _vala_r0;
#line 926 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										if (_tmp119_ >= 0) {
#line 6093 "chess-state.c"
											gint _tmp120_;
											gint _tmp121_;
#line 926 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp120_ = rank;
#line 926 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp121_ = _vala_r0;
#line 926 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp118_ = _tmp120_ != _tmp121_;
#line 6102 "chess-state.c"
										} else {
#line 926 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp118_ = FALSE;
#line 6106 "chess-state.c"
										}
#line 926 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										if (_tmp118_) {
#line 927 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											continue;
#line 6112 "chess-state.c"
										}
#line 930 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp122_ = rank;
#line 930 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp123_ = file;
#line 930 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp124_ = chess_state_get_index (self, _tmp122_, _tmp123_);
#line 930 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp125_ = self->board[_tmp124_];
#line 930 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp126_ = _g_object_ref0 (_tmp125_);
#line 930 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										piece = _tmp126_;
#line 931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp129_ = piece;
#line 931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										if (_tmp129_ == NULL) {
#line 931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp128_ = TRUE;
#line 6132 "chess-state.c"
										} else {
											ChessPiece* _tmp130_;
											PieceType _tmp131_;
											PieceType _tmp132_;
#line 931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp130_ = piece;
#line 931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp131_ = _tmp130_->type;
#line 931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp132_ = type;
#line 931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp128_ = _tmp131_ != _tmp132_;
#line 6145 "chess-state.c"
										}
#line 931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										if (_tmp128_) {
#line 931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp127_ = TRUE;
#line 6151 "chess-state.c"
										} else {
											ChessPiece* _tmp133_;
											ChessPlayer* _tmp134_;
											ChessPlayer* _tmp135_;
#line 931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp133_ = piece;
#line 931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp134_ = _tmp133_->player;
#line 931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp135_ = player;
#line 931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp127_ = _tmp134_ != _tmp135_;
#line 6164 "chess-state.c"
										}
#line 931 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										if (_tmp127_) {
#line 932 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_g_object_unref0 (piece);
#line 932 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											continue;
#line 6172 "chess-state.c"
										}
#line 935 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp136_ = player;
#line 935 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp137_ = rank;
#line 935 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp138_ = file;
#line 935 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp139_ = _vala_r1;
#line 935 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp140_ = _vala_f1;
#line 935 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp141_ = chess_state_move_with_coords (self, _tmp136_, _tmp137_, _tmp138_, _tmp139_, _tmp140_, PIECE_TYPE_QUEEN, FALSE, TRUE);
#line 935 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										if (!_tmp141_) {
#line 936 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_g_object_unref0 (piece);
#line 936 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											continue;
#line 6192 "chess-state.c"
										}
#line 939 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp142_ = match_rank;
#line 939 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										if (_tmp142_ >= 0) {
#line 6198 "chess-state.c"
											const gchar* _tmp143_;
#line 941 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_tmp143_ = move;
#line 941 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											g_debug ("chess-state.vala:941: Move %s is ambiguous", _tmp143_);
#line 942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											result = FALSE;
#line 942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											_g_object_unref0 (piece);
#line 942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											if (r0) {
#line 942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
												*r0 = _vala_r0;
#line 6212 "chess-state.c"
											}
#line 942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											if (f0) {
#line 942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
												*f0 = _vala_f0;
#line 6218 "chess-state.c"
											}
#line 942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											if (r1) {
#line 942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
												*r1 = _vala_r1;
#line 6224 "chess-state.c"
											}
#line 942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											if (f1) {
#line 942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
												*f1 = _vala_f1;
#line 6230 "chess-state.c"
											}
#line 942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											if (promotion_type) {
#line 942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
												*promotion_type = _vala_promotion_type;
#line 6236 "chess-state.c"
											}
#line 942 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
											return result;
#line 6240 "chess-state.c"
										}
#line 945 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp144_ = rank;
#line 945 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										match_rank = _tmp144_;
#line 946 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_tmp145_ = file;
#line 946 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										match_file = _tmp145_;
#line 924 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
										_g_object_unref0 (piece);
#line 6252 "chess-state.c"
									}
								}
							}
						}
					}
				}
#line 950 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp146_ = match_rank;
#line 950 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				if (_tmp146_ < 0) {
#line 6263 "chess-state.c"
					const gchar* _tmp147_;
#line 952 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					_tmp147_ = move;
#line 952 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					g_debug ("chess-state.vala:952: Move %s has no matches", _tmp147_);
#line 953 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					result = FALSE;
#line 953 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (r0) {
#line 953 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						*r0 = _vala_r0;
#line 6275 "chess-state.c"
					}
#line 953 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (f0) {
#line 953 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						*f0 = _vala_f0;
#line 6281 "chess-state.c"
					}
#line 953 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (r1) {
#line 953 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						*r1 = _vala_r1;
#line 6287 "chess-state.c"
					}
#line 953 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (f1) {
#line 953 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						*f1 = _vala_f1;
#line 6293 "chess-state.c"
					}
#line 953 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					if (promotion_type) {
#line 953 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
						*promotion_type = _vala_promotion_type;
#line 6299 "chess-state.c"
					}
#line 953 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
					return result;
#line 6303 "chess-state.c"
				}
#line 956 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp148_ = match_rank;
#line 956 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_vala_r0 = _tmp148_;
#line 957 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_tmp149_ = match_file;
#line 957 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
				_vala_f0 = _tmp149_;
#line 6313 "chess-state.c"
			}
		}
	}
#line 961 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp150_ = move;
#line 961 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp151_ = i;
#line 961 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp152_ = string_get (_tmp150_, (glong) _tmp151_);
#line 961 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp152_ == '+') {
#line 6325 "chess-state.c"
		gint _tmp153_;
#line 962 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp153_ = i;
#line 962 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		i = _tmp153_ + 1;
#line 6331 "chess-state.c"
	} else {
		const gchar* _tmp154_;
		gint _tmp155_;
		gchar _tmp156_;
#line 963 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp154_ = move;
#line 963 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp155_ = i;
#line 963 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp156_ = string_get (_tmp154_, (glong) _tmp155_);
#line 963 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (_tmp156_ == '#') {
#line 6344 "chess-state.c"
			gint _tmp157_;
#line 964 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			_tmp157_ = i;
#line 964 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			i = _tmp157_ + 1;
#line 6350 "chess-state.c"
		}
	}
#line 966 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp158_ = move;
#line 966 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp159_ = i;
#line 966 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp160_ = string_get (_tmp158_, (glong) _tmp159_);
#line 966 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp160_ != '\0') {
#line 6361 "chess-state.c"
		const gchar* _tmp161_;
#line 968 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp161_ = move;
#line 968 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		g_debug ("chess-state.vala:968: Move %s has unexpected characters", _tmp161_);
#line 969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		result = FALSE;
#line 969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (r0) {
#line 969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			*r0 = _vala_r0;
#line 6373 "chess-state.c"
		}
#line 969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (f0) {
#line 969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			*f0 = _vala_f0;
#line 6379 "chess-state.c"
		}
#line 969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (r1) {
#line 969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			*r1 = _vala_r1;
#line 6385 "chess-state.c"
		}
#line 969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (f1) {
#line 969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			*f1 = _vala_f1;
#line 6391 "chess-state.c"
		}
#line 969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		if (promotion_type) {
#line 969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
			*promotion_type = _vala_promotion_type;
#line 6397 "chess-state.c"
		}
#line 969 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		return result;
#line 6401 "chess-state.c"
	}
#line 972 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	result = TRUE;
#line 972 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (r0) {
#line 972 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		*r0 = _vala_r0;
#line 6409 "chess-state.c"
	}
#line 972 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (f0) {
#line 972 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		*f0 = _vala_f0;
#line 6415 "chess-state.c"
	}
#line 972 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (r1) {
#line 972 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		*r1 = _vala_r1;
#line 6421 "chess-state.c"
	}
#line 972 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (f1) {
#line 972 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		*f1 = _vala_f1;
#line 6427 "chess-state.c"
	}
#line 972 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (promotion_type) {
#line 972 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		*promotion_type = _vala_promotion_type;
#line 6433 "chess-state.c"
	}
#line 972 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return result;
#line 6437 "chess-state.c"
}


ChessPlayer* chess_state_get_opponent (ChessState* self) {
	ChessPlayer* result;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_;
	Color _tmp2_;
#line 27 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 27 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp1_ = self->current_player;
#line 27 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_tmp2_ = _tmp1_->color;
#line 27 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 6454 "chess-state.c"
		ChessPlayer* _tmp3_;
#line 27 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp3_ = self->players[COLOR_BLACK];
#line 27 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp0_ = _tmp3_;
#line 6460 "chess-state.c"
	} else {
		ChessPlayer* _tmp4_;
#line 27 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp4_ = self->players[COLOR_WHITE];
#line 27 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		_tmp0_ = _tmp4_;
#line 6467 "chess-state.c"
	}
#line 27 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	result = _tmp0_;
#line 27 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	return result;
#line 6473 "chess-state.c"
}


static void chess_state_class_init (ChessStateClass * klass) {
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	chess_state_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_type_class_add_private (klass, sizeof (ChessStatePrivate));
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_state_get_property;
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_state_finalize;
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_STATE_OPPONENT_PROPERTY, chess_state_properties[CHESS_STATE_OPPONENT_PROPERTY] = g_param_spec_object ("opponent", "opponent", "opponent", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 6488 "chess-state.c"
}


static void chess_state_instance_init (ChessState * self) {
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->priv = CHESS_STATE_GET_PRIVATE (self);
#line 22 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->number = 0;
#line 31 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->en_passant_index = -1;
#line 36 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self->last_move = NULL;
#line 6501 "chess-state.c"
}


static void chess_state_finalize (GObject * obj) {
	ChessState * self;
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_STATE, ChessState);
#line 23 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_vala_array_destroy (self->players, 2, (GDestroyNotify) g_object_unref);
#line 24 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (self->current_player);
#line 35 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_vala_array_destroy (self->board, 64, (GDestroyNotify) g_object_unref);
#line 36 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	_g_object_unref0 (self->last_move);
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	G_OBJECT_CLASS (chess_state_parent_class)->finalize (obj);
#line 6519 "chess-state.c"
}


GType chess_state_get_type (void) {
	static volatile gsize chess_state_type_id__volatile = 0;
	if (g_once_init_enter (&chess_state_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessState), 0, (GInstanceInitFunc) chess_state_instance_init, NULL };
		GType chess_state_type_id;
		chess_state_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessState", &g_define_type_info, 0);
		g_once_init_leave (&chess_state_type_id__volatile, chess_state_type_id);
	}
	return chess_state_type_id__volatile;
}


static void _vala_chess_state_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_STATE, ChessState);
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
	switch (property_id) {
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		case CHESS_STATE_OPPONENT_PROPERTY:
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		g_value_set_object (value, chess_state_get_opponent (self));
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		break;
#line 6546 "chess-state.c"
		default:
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 20 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-state.vala"
		break;
#line 6552 "chess-state.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



