/* contacts-window.c generated by valac 0.38.7, the Vala compiler
 * generated from contacts-window.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <folks/folks-eds.h>
#include <folks/folks.h>
#include <contacts-esd-setup.h>
#include <libedataserver/libedataserver.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <pango/pango.h>


#define CONTACTS_TYPE_WINDOW (contacts_window_get_type ())
#define CONTACTS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_WINDOW, ContactsWindow))
#define CONTACTS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_WINDOW, ContactsWindowClass))
#define CONTACTS_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_WINDOW))
#define CONTACTS_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_WINDOW))
#define CONTACTS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_WINDOW, ContactsWindowClass))

typedef struct _ContactsWindow ContactsWindow;
typedef struct _ContactsWindowClass ContactsWindowClass;
typedef struct _ContactsWindowPrivate ContactsWindowPrivate;

#define CONTACTS_TYPE_ACCOUNTS_LIST (contacts_accounts_list_get_type ())
#define CONTACTS_ACCOUNTS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_ACCOUNTS_LIST, ContactsAccountsList))
#define CONTACTS_ACCOUNTS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_ACCOUNTS_LIST, ContactsAccountsListClass))
#define CONTACTS_IS_ACCOUNTS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_ACCOUNTS_LIST))
#define CONTACTS_IS_ACCOUNTS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_ACCOUNTS_LIST))
#define CONTACTS_ACCOUNTS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_ACCOUNTS_LIST, ContactsAccountsListClass))

typedef struct _ContactsAccountsList ContactsAccountsList;
typedef struct _ContactsAccountsListClass ContactsAccountsListClass;

#define CONTACTS_TYPE_LIST_PANE (contacts_list_pane_get_type ())
#define CONTACTS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPane))
#define CONTACTS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))
#define CONTACTS_IS_LIST_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_IS_LIST_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LIST_PANE))
#define CONTACTS_LIST_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LIST_PANE, ContactsListPaneClass))

typedef struct _ContactsListPane ContactsListPane;
typedef struct _ContactsListPaneClass ContactsListPaneClass;

#define CONTACTS_TYPE_CONTACT_PANE (contacts_contact_pane_get_type ())
#define CONTACTS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPane))
#define CONTACTS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))
#define CONTACTS_IS_CONTACT_PANE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_IS_CONTACT_PANE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT_PANE))
#define CONTACTS_CONTACT_PANE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT_PANE, ContactsContactPaneClass))

typedef struct _ContactsContactPane ContactsContactPane;
typedef struct _ContactsContactPaneClass ContactsContactPaneClass;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
enum  {
	CONTACTS_WINDOW_0_PROPERTY,
	CONTACTS_WINDOW_STORE_PROPERTY,
	CONTACTS_WINDOW_SELECTION_MODE_PROPERTY,
	CONTACTS_WINDOW_EDIT_MODE_PROPERTY,
	CONTACTS_WINDOW_NUM_PROPERTIES
};
static GParamSpec* contacts_window_properties[CONTACTS_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CONTACTS_TYPE_APP (contacts_app_get_type ())
#define CONTACTS_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_APP, ContactsApp))
#define CONTACTS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_APP, ContactsAppClass))
#define CONTACTS_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_APP))
#define CONTACTS_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_APP))
#define CONTACTS_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_APP, ContactsAppClass))

typedef struct _ContactsApp ContactsApp;
typedef struct _ContactsAppClass ContactsAppClass;

#define CONTACTS_TYPE_SETTINGS (contacts_settings_get_type ())
#define CONTACTS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettings))
#define CONTACTS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))
#define CONTACTS_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_SETTINGS))
#define CONTACTS_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_SETTINGS, ContactsSettingsClass))

typedef struct _ContactsSettings ContactsSettings;
typedef struct _ContactsSettingsClass ContactsSettingsClass;
#define _contacts_settings_unref0(var) ((var == NULL) ? NULL : (var = (contacts_settings_unref (var), NULL)))
typedef struct _Block33Data Block33Data;
typedef struct _Block34Data Block34Data;
typedef struct _ContactsAccountsListPrivate ContactsAccountsListPrivate;

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;

#define CONTACTS_TYPE_LINK_OPERATION (contacts_link_operation_get_type ())
#define CONTACTS_LINK_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LINK_OPERATION, ContactsLinkOperation))
#define CONTACTS_LINK_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LINK_OPERATION, ContactsLinkOperationClass))
#define CONTACTS_IS_LINK_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LINK_OPERATION))
#define CONTACTS_IS_LINK_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LINK_OPERATION))
#define CONTACTS_LINK_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LINK_OPERATION, ContactsLinkOperationClass))

typedef struct _ContactsLinkOperation ContactsLinkOperation;
typedef struct _ContactsLinkOperationClass ContactsLinkOperationClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ContactsContactPanePrivate ContactsContactPanePrivate;

#define CONTACTS_TYPE_IN_APP_NOTIFICATION (contacts_in_app_notification_get_type ())
#define CONTACTS_IN_APP_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_IN_APP_NOTIFICATION, ContactsInAppNotification))
#define CONTACTS_IN_APP_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_IN_APP_NOTIFICATION, ContactsInAppNotificationClass))
#define CONTACTS_IS_IN_APP_NOTIFICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_IN_APP_NOTIFICATION))
#define CONTACTS_IS_IN_APP_NOTIFICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_IN_APP_NOTIFICATION))
#define CONTACTS_IN_APP_NOTIFICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_IN_APP_NOTIFICATION, ContactsInAppNotificationClass))

typedef struct _ContactsInAppNotification ContactsInAppNotification;
typedef struct _ContactsInAppNotificationClass ContactsInAppNotificationClass;
typedef struct _ContactsListPanePrivate ContactsListPanePrivate;

#define CONTACTS_TYPE_LINK_OPERATION2 (contacts_link_operation2_get_type ())
#define CONTACTS_LINK_OPERATION2(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_LINK_OPERATION2, ContactsLinkOperation2))
#define CONTACTS_LINK_OPERATION2_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_LINK_OPERATION2, ContactsLinkOperation2Class))
#define CONTACTS_IS_LINK_OPERATION2(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_LINK_OPERATION2))
#define CONTACTS_IS_LINK_OPERATION2_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_LINK_OPERATION2))
#define CONTACTS_LINK_OPERATION2_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_LINK_OPERATION2, ContactsLinkOperation2Class))

typedef struct _ContactsLinkOperation2 ContactsLinkOperation2;
typedef struct _ContactsLinkOperation2Class ContactsLinkOperation2Class;
typedef struct _Block35Data Block35Data;
typedef struct _Block36Data Block36Data;
typedef struct _Block37Data Block37Data;
typedef struct _Block38Data Block38Data;

struct _ContactsWindow {
	GtkApplicationWindow parent_instance;
	ContactsWindowPrivate * priv;
};

struct _ContactsWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _ContactsWindowPrivate {
	GtkGrid* content_grid;
	GtkContainer* contact_pane_container;
	GtkGrid* loading_box;
	GtkSizeGroup* left_pane_size_group;
	GtkHeaderBar* left_toolbar;
	GtkHeaderBar* right_toolbar;
	GtkOverlay* overlay;
	GtkButton* add_button;
	GtkToggleButton* select_button;
	GtkButton* edit_button;
	GtkButton* cancel_button;
	GtkButton* done_button;
	GtkStack* view_switcher;
	GtkGrid* content_header_bar;
	GtkGrid* setup_view;
	GtkHeaderBar* setup_header_bar;
	GtkButton* setup_done_button;
	GtkButton* setup_cancel_button;
	ContactsAccountsList* setup_accounts_list;
	ContactsListPane* list_pane;
	ContactsContactPane* contact_pane;
	gboolean new_contact_mode;
	ContactsStore* _store;
	gboolean _selection_mode;
	gboolean _edit_mode;
};

struct _Block33Data {
	int _ref_count_;
	ContactsWindow* self;
	ContactsApp* app;
	ContactsSettings* settings;
};

struct _Block34Data {
	int _ref_count_;
	Block33Data * _data33_;
	GSimpleAction* change_book_action;
	gulong id2;
};

struct _ContactsAccountsList {
	GtkBox parent_instance;
	ContactsAccountsListPrivate * priv;
	FolksPersonaStore* selected_store;
};

struct _ContactsAccountsListClass {
	GtkBoxClass parent_class;
};

struct _ContactsContactPane {
	GtkStack parent_instance;
	ContactsContactPanePrivate * priv;
	ContactsContact* contact;
	gboolean on_edit_mode;
	GtkGrid* suggestion_grid;
};

struct _ContactsContactPaneClass {
	GtkStackClass parent_class;
};

struct _ContactsListPane {
	GtkFrame parent_instance;
	ContactsListPanePrivate * priv;
	GtkToolItem* search_tool_item;
	GtkSearchEntry* filter_entry;
	GtkButton* link_button;
	GtkButton* delete_button;
	GtkActionBar* actions_bar;
};

struct _ContactsListPaneClass {
	GtkFrameClass parent_class;
};

struct _Block35Data {
	int _ref_count_;
	ContactsWindow* self;
	ContactsLinkOperation2* operation;
	ContactsInAppNotification* notification;
};

struct _Block36Data {
	int _ref_count_;
	ContactsWindow* self;
	ContactsInAppNotification* notification;
	gboolean really_delete;
	GeeLinkedList* contact_list;
};

struct _Block37Data {
	int _ref_count_;
	ContactsWindow* self;
	ContactsInAppNotification* notification;
	gboolean really_delete;
	ContactsContact* contact;
};

struct _Block38Data {
	int _ref_count_;
	ContactsWindow* self;
	ContactsInAppNotification* notification;
	ContactsLinkOperation* operation;
};


static gpointer contacts_window_parent_class = NULL;

GType contacts_window_get_type (void) G_GNUC_CONST;
GType contacts_accounts_list_get_type (void) G_GNUC_CONST;
GType contacts_list_pane_get_type (void) G_GNUC_CONST;
GType contacts_contact_pane_get_type (void) G_GNUC_CONST;
GType contacts_store_get_type (void) G_GNUC_CONST;
#define CONTACTS_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_WINDOW, ContactsWindowPrivate))
GType contacts_app_get_type (void) G_GNUC_CONST;
gpointer contacts_settings_ref (gpointer instance);
void contacts_settings_unref (gpointer instance);
GParamSpec* contacts_param_spec_settings (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void contacts_value_set_settings (GValue* value, gpointer v_object);
void contacts_value_take_settings (GValue* value, gpointer v_object);
gpointer contacts_value_get_settings (const GValue* value);
GType contacts_settings_get_type (void) G_GNUC_CONST;
ContactsWindow* contacts_window_new (ContactsApp* app, ContactsStore* contacts_store, ContactsSettings* settings);
ContactsWindow* contacts_window_construct (GType object_type, ContactsApp* app, ContactsStore* contacts_store, ContactsSettings* settings);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
static void contacts_window_create_contact_pane (ContactsWindow* self);
ContactsStore* contacts_window_get_store (ContactsWindow* self);
ContactsAccountsList* contacts_accounts_list_new (ContactsStore* contacts_store);
ContactsAccountsList* contacts_accounts_list_construct (GType object_type, ContactsStore* contacts_store);
gboolean contacts_settings_get_did_initial_setup (ContactsSettings* self);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
static void ___lambda78_ (ContactsWindow* self);
void contacts_accounts_list_update_contents (ContactsAccountsList* self, gboolean select_active);
static void ____lambda78__contacts_store_eds_persona_store_changed (ContactsStore* _sender, gpointer self);
static void ___lambda79_ (Block34Data* _data34_);
static void ____lambda79__contacts_accounts_list_account_selected (ContactsAccountsList* _sender, gpointer self);
static void ___lambda80_ (Block34Data* _data34_);
void contacts_settings_set_did_initial_setup (ContactsSettings* self, gboolean value);
static void ____lambda80__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda81_ (Block34Data* _data34_);
static void ____lambda81__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void contacts_window_init_content_widgets (ContactsWindow* self);
ContactsContactPane* contacts_contact_pane_new (ContactsWindow* parent_window, ContactsStore* contacts_store);
ContactsContactPane* contacts_contact_pane_construct (GType object_type, ContactsWindow* parent_window, ContactsStore* contacts_store);
GType contacts_contact_get_type (void) G_GNUC_CONST;
static void contacts_window_contact_pane_delete_contact_cb (ContactsWindow* self, ContactsContact* contact);
static void _contacts_window_contact_pane_delete_contact_cb_contacts_contact_pane_will_delete (ContactsContactPane* _sender, ContactsContact* contact, gpointer self);
GType contacts_link_operation_get_type (void) G_GNUC_CONST;
static void contacts_window_contact_pane_contacts_linked_cb (ContactsWindow* self, const gchar* main_contact, const gchar* linked_contact, ContactsLinkOperation* operation);
static void _contacts_window_contact_pane_contacts_linked_cb_contacts_contact_pane_contacts_linked (ContactsContactPane* _sender, const gchar* main_contact, const gchar* linked_contact, ContactsLinkOperation* operation, gpointer self);
void contacts_window_set_list_pane (ContactsWindow* self);
ContactsListPane* contacts_list_pane_new (ContactsStore* contacts_store);
ContactsListPane* contacts_list_pane_construct (GType object_type, ContactsStore* contacts_store);
static void contacts_window_list_pane_selection_changed_cb (ContactsWindow* self, ContactsContact* new_selection);
static void _contacts_window_list_pane_selection_changed_cb_contacts_list_pane_selection_changed (ContactsListPane* _sender, ContactsContact* contact, gpointer self);
static void contacts_window_list_pane_link_contacts_cb (ContactsWindow* self, GeeLinkedList* contact_list);
static void _contacts_window_list_pane_link_contacts_cb_contacts_list_pane_link_contacts (ContactsListPane* _sender, GeeLinkedList* contacts_list, gpointer self);
static void contacts_window_list_pane_delete_contacts_cb (ContactsWindow* self, GeeLinkedList* contact_list);
static void _contacts_window_list_pane_delete_contacts_cb_contacts_list_pane_delete_contacts (ContactsListPane* _sender, GeeLinkedList* contacts_list, gpointer self);
static void __lambda90_ (ContactsWindow* self, gint nr_contacts);
static void contacts_window_set_left_title (ContactsWindow* self, const gchar* value);
static void ___lambda90__contacts_list_pane_contacts_marked (ContactsListPane* _sender, gint contacts_marked, gpointer self);
void contacts_list_pane_select_contact (ContactsListPane* self, ContactsContact* contact, gboolean ignore_change);
void contacts_window_activate_selection_mode (ContactsWindow* self, gboolean active);
void contacts_window_set_selection_mode (ContactsWindow* self, gboolean value);
void contacts_list_pane_show_selection (ContactsListPane* self);
void contacts_list_pane_hide_selection (ContactsListPane* self);
void contacts_window_enter_edit_mode (ContactsWindow* self);
void contacts_window_set_edit_mode (ContactsWindow* self, gboolean value);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
static void contacts_window_set_right_title (ContactsWindow* self, const gchar* value);
void contacts_contact_pane_set_edit_mode (ContactsContactPane* self, gboolean on_edit, gboolean drop_changes);
void contacts_window_leave_edit_mode (ContactsWindow* self, gboolean drop_changes);
void contacts_contact_pane_create_contact (ContactsContactPane* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_contact_pane_create_contact_finish (ContactsContactPane* self, GAsyncResult* _res_);
GType contacts_in_app_notification_get_type (void) G_GNUC_CONST;
void contacts_window_add_notification (ContactsWindow* self, ContactsInAppNotification* notification);
void contacts_in_app_notification_show (ContactsInAppNotification* self);
void contacts_window_set_shown_contact (ContactsWindow* self, ContactsContact* c);
void contacts_contact_pane_show_contact (ContactsContactPane* self, ContactsContact* new_contact, gboolean show_matches);
void contacts_window_new_contact (ContactsWindow* self);
void contacts_contact_pane_new_contact (ContactsContactPane* self);
static void _contacts_window_new_contact_gtk_button_clicked (GtkButton* _sender, gpointer self);
void contacts_window_show_search (ContactsWindow* self, const gchar* query);
static void __lambda82_ (ContactsWindow* self);
static void ___lambda82__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void __lambda83_ (ContactsWindow* self);
static void ___lambda83__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda84_ (ContactsWindow* self);
static void ___lambda84__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda85_ (ContactsWindow* self);
static void ___lambda85__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean contacts_window_key_press_event_cb (ContactsWindow* self, GdkEventKey* event);
void contacts_utils_grab_entry_focus_no_select (GtkEntry* entry);
static gboolean _contacts_window_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean contacts_window_delete_event_cb (ContactsWindow* self, GdkEventAny* event);
static gboolean _contacts_window_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
GType contacts_link_operation2_get_type (void) G_GNUC_CONST;
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
void contacts_link_contacts_list (GeeLinkedList* contact_list, ContactsStore* contacts_store, GAsyncReadyCallback _callback_, gpointer _user_data_);
ContactsLinkOperation2* contacts_link_contacts_list_finish (GAsyncResult* _res_);
static void __lambda86_ (Block35Data* _data35_, GObject* obj, GAsyncResult* _result_);
static void ___lambda86__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
ContactsInAppNotification* contacts_in_app_notification_new (const gchar* message, GtkButton* button);
ContactsInAppNotification* contacts_in_app_notification_construct (GType object_type, const gchar* message, GtkButton* button);
static void __lambda87_ (Block35Data* _data35_);
void contacts_link_operation2_undo (ContactsLinkOperation2* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_link_operation2_undo_finish (ContactsLinkOperation2* self, GAsyncResult* _res_);
void contacts_in_app_notification_dismiss (ContactsInAppNotification* self);
static void ___lambda87__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
static void __lambda88_ (Block36Data* _data36_);
static void ___lambda88__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda89_ (Block36Data* _data36_);
void contacts_contact_remove_personas (ContactsContact* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_contact_remove_personas_finish (ContactsContact* self, GAsyncResult* _res_, GError** error);
static void ___lambda89__contacts_in_app_notification_dismissed (ContactsInAppNotification* _sender, gpointer self);
void contacts_contact_show (ContactsContact* self);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
GtkLabel* contacts_in_app_notification_get_message_label (ContactsInAppNotification* self);
static void __lambda74_ (Block37Data* _data37_);
static void ___lambda75_ (Block37Data* _data37_);
static void ____lambda75__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda74__contacts_in_app_notification_dismissed (ContactsInAppNotification* _sender, gpointer self);
static void __lambda76_ (Block37Data* _data37_);
static void ___lambda76__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
static void __lambda77_ (Block38Data* _data38_);
void contacts_link_operation_undo (ContactsLinkOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_link_operation_undo_finish (ContactsLinkOperation* self, GAsyncResult* _res_);
static void ___lambda77__gtk_button_clicked (GtkButton* _sender, gpointer self);
static const gchar* contacts_window_get_left_title (ContactsWindow* self);
static const gchar* contacts_window_get_right_title (ContactsWindow* self);
void contacts_window_set_store (ContactsWindow* self, ContactsStore* value);
gboolean contacts_window_get_selection_mode (ContactsWindow* self);
gboolean contacts_window_get_edit_mode (ContactsWindow* self);
static void contacts_window_finalize (GObject * obj);
static void _vala_contacts_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_contacts_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _contacts_settings_ref0 (gpointer self) {
	return self ? contacts_settings_ref (self) : NULL;
}


static Block33Data* block33_data_ref (Block33Data* _data33_) {
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}


static void block33_data_unref (void * _userdata_) {
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		ContactsWindow* self;
		self = _data33_->self;
		_g_object_unref0 (_data33_->app);
		_contacts_settings_unref0 (_data33_->settings);
		_g_object_unref0 (self);
		g_slice_free (Block33Data, _data33_);
	}
}


static Block34Data* block34_data_ref (Block34Data* _data34_) {
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}


static void block34_data_unref (void * _userdata_) {
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		ContactsWindow* self;
		self = _data34_->_data33_->self;
		_g_object_unref0 (_data34_->change_book_action);
		block33_data_unref (_data34_->_data33_);
		_data34_->_data33_ = NULL;
		g_slice_free (Block34Data, _data34_);
	}
}


static void ___lambda78_ (ContactsWindow* self) {
	ContactsAccountsList* _tmp0_;
	_tmp0_ = self->priv->setup_accounts_list;
	contacts_accounts_list_update_contents (_tmp0_, FALSE);
}


static void ____lambda78__contacts_store_eds_persona_store_changed (ContactsStore* _sender, gpointer self) {
	___lambda78_ ((ContactsWindow*) self);
}


static void ___lambda79_ (Block34Data* _data34_) {
	Block33Data* _data33_;
	ContactsWindow* self;
	GtkButton* _tmp0_;
	ContactsAccountsList* _tmp1_;
	gulong _tmp2_;
	_data33_ = _data34_->_data33_;
	self = _data33_->self;
	_tmp0_ = self->priv->setup_done_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	_tmp1_ = self->priv->setup_accounts_list;
	_tmp2_ = _data34_->id2;
	g_signal_handler_disconnect ((GObject*) _tmp1_, _tmp2_);
}


static void ____lambda79__contacts_accounts_list_account_selected (ContactsAccountsList* _sender, gpointer self) {
	___lambda79_ (self);
}


static void ___lambda80_ (Block34Data* _data34_) {
	Block33Data* _data33_;
	ContactsWindow* self;
	GtkStack* _tmp0_;
	GtkGrid* _tmp1_;
	EdsfPersonaStore* e_store = NULL;
	ContactsAccountsList* _tmp2_;
	FolksPersonaStore* _tmp3_;
	EdsfPersonaStore* _tmp4_;
	ESourceRegistry* _tmp5_;
	EdsfPersonaStore* _tmp6_;
	ESource* _tmp7_;
	ESource* _tmp8_;
	ContactsSettings* _tmp9_;
	GSimpleAction* _tmp10_;
	_data33_ = _data34_->_data33_;
	self = _data33_->self;
	_tmp0_ = self->priv->view_switcher;
	gtk_stack_set_visible_child_name (_tmp0_, "content-view");
	_tmp1_ = self->priv->content_header_bar;
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->setup_accounts_list;
	_tmp3_ = _tmp2_->selected_store;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, EDSF_TYPE_PERSONA_STORE) ? ((EdsfPersonaStore*) _tmp3_) : NULL);
	e_store = _tmp4_;
	_tmp5_ = eds_source_registry;
	_tmp6_ = e_store;
	_tmp7_ = edsf_persona_store_get_source (_tmp6_);
	_tmp8_ = _tmp7_;
	e_source_registry_set_default_address_book (_tmp5_, _tmp8_);
	_tmp9_ = _data33_->settings;
	contacts_settings_set_did_initial_setup (_tmp9_, TRUE);
	_tmp10_ = _data34_->change_book_action;
	if (_tmp10_ != NULL) {
		GSimpleAction* _tmp11_;
		_tmp11_ = _data34_->change_book_action;
		g_simple_action_set_enabled (_tmp11_, TRUE);
	}
	_g_object_unref0 (e_store);
}


static void ____lambda80__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda80_ (self);
}


static void ___lambda81_ (Block34Data* _data34_) {
	Block33Data* _data33_;
	ContactsWindow* self;
	ContactsApp* _tmp0_;
	_data33_ = _data34_->_data33_;
	self = _data33_->self;
	_tmp0_ = _data33_->app;
	g_application_quit ((GApplication*) _tmp0_);
}


static void ____lambda81__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda81_ (self);
}


ContactsWindow* contacts_window_construct (GType object_type, ContactsApp* app, ContactsStore* contacts_store, ContactsSettings* settings) {
	ContactsWindow * self = NULL;
	Block33Data* _data33_;
	ContactsApp* _tmp0_;
	ContactsApp* _tmp1_;
	ContactsSettings* _tmp2_;
	ContactsSettings* _tmp3_;
	ContactsApp* _tmp4_;
	ContactsStore* _tmp5_;
	GtkHeaderBar* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkToggleButton* _tmp13_;
	GtkHeaderBar* _tmp14_;
	ContactsStore* _tmp15_;
	ContactsAccountsList* _tmp16_;
	ContactsAccountsList* _tmp17_;
	ContactsAccountsList* _tmp18_;
	ContactsAccountsList* _tmp19_;
	GtkGrid* _tmp20_;
	ContactsAccountsList* _tmp21_;
	ContactsSettings* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	g_return_val_if_fail (app != NULL, NULL);
	g_return_val_if_fail (contacts_store != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	_data33_ = g_slice_new0 (Block33Data);
	_data33_->_ref_count_ = 1;
	_tmp0_ = app;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data33_->app);
	_data33_->app = _tmp1_;
	_tmp2_ = settings;
	_tmp3_ = _contacts_settings_ref0 (_tmp2_);
	_contacts_settings_unref0 (_data33_->settings);
	_data33_->settings = _tmp3_;
	_tmp4_ = _data33_->app;
	_tmp5_ = contacts_store;
	self = (ContactsWindow*) g_object_new (object_type, "application", _tmp4_, "show-menubar", FALSE, "store", _tmp5_, NULL);
	_data33_->self = g_object_ref (self);
	g_debug ("contacts-window.vala:107: everyone creation: finalized already!!!");
	_tmp6_ = self->priv->right_toolbar;
	g_object_bind_property_with_closures ((GObject*) self, "selection-mode", (GObject*) _tmp6_, "show-close-button", G_BINDING_DEFAULT | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp7_ = self->priv->add_button;
	g_object_bind_property_with_closures ((GObject*) self, "selection-mode", (GObject*) _tmp7_, "visible", G_BINDING_DEFAULT | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp8_ = self->priv->edit_button;
	g_object_bind_property_with_closures ((GObject*) self, "selection-mode", (GObject*) _tmp8_, "visible", G_BINDING_DEFAULT | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp9_ = self->priv->edit_button;
	g_object_bind_property_with_closures ((GObject*) self, "edit-mode", (GObject*) _tmp9_, "visible", G_BINDING_DEFAULT | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp10_ = self->priv->done_button;
	g_object_bind_property_with_closures ((GObject*) self, "edit-mode", (GObject*) _tmp10_, "visible", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp11_ = self->priv->cancel_button;
	g_object_bind_property_with_closures ((GObject*) self, "edit-mode", (GObject*) _tmp11_, "visible", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp12_ = self->priv->add_button;
	g_object_bind_property_with_closures ((GObject*) self, "edit-mode", (GObject*) _tmp12_, "visible", G_BINDING_DEFAULT | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp13_ = self->priv->select_button;
	g_object_bind_property_with_closures ((GObject*) self, "edit-mode", (GObject*) _tmp13_, "visible", G_BINDING_DEFAULT | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp14_ = self->priv->right_toolbar;
	g_object_bind_property_with_closures ((GObject*) self, "edit-mode", (GObject*) _tmp14_, "show-close-button", G_BINDING_DEFAULT | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	contacts_window_create_contact_pane (self);
	_tmp15_ = self->priv->_store;
	_tmp16_ = contacts_accounts_list_new (_tmp15_);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->setup_accounts_list);
	self->priv->setup_accounts_list = _tmp16_;
	_tmp17_ = self->priv->setup_accounts_list;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp17_, TRUE);
	_tmp18_ = self->priv->setup_accounts_list;
	gtk_widget_set_halign ((GtkWidget*) _tmp18_, GTK_ALIGN_CENTER);
	_tmp19_ = self->priv->setup_accounts_list;
	gtk_widget_show ((GtkWidget*) _tmp19_);
	_tmp20_ = self->priv->setup_view;
	_tmp21_ = self->priv->setup_accounts_list;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 1, 0, 1, 1);
	_tmp22_ = _data33_->settings;
	_tmp23_ = contacts_settings_get_did_initial_setup (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_) {
		GtkStack* _tmp25_;
		GtkGrid* _tmp26_;
		_tmp25_ = self->priv->view_switcher;
		gtk_stack_set_visible_child_name (_tmp25_, "content-view");
		_tmp26_ = self->priv->content_header_bar;
		gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp26_);
	} else {
		Block34Data* _data34_;
		ContactsApp* _tmp27_;
		GAction* _tmp28_;
		GSimpleAction* _tmp29_;
		GSimpleAction* _tmp30_;
		ContactsStore* _tmp32_;
		ContactsAccountsList* _tmp33_;
		gulong _tmp34_;
		GtkStack* _tmp35_;
		GtkHeaderBar* _tmp36_;
		ContactsAccountsList* _tmp37_;
		GtkButton* _tmp38_;
		GtkButton* _tmp39_;
		_data34_ = g_slice_new0 (Block34Data);
		_data34_->_ref_count_ = 1;
		_data34_->_data33_ = block33_data_ref (_data33_);
		_tmp27_ = _data33_->app;
		_tmp28_ = g_action_map_lookup_action ((GActionMap*) _tmp27_, "change-book");
		_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp28_) : NULL);
		_data34_->change_book_action = _tmp29_;
		_tmp30_ = _data34_->change_book_action;
		if (_tmp30_ != NULL) {
			GSimpleAction* _tmp31_;
			_tmp31_ = _data34_->change_book_action;
			g_simple_action_set_enabled (_tmp31_, FALSE);
		}
		_tmp32_ = self->priv->_store;
		g_signal_connect_object (_tmp32_, "eds-persona-store-changed", (GCallback) ____lambda78__contacts_store_eds_persona_store_changed, self, 0);
		_data34_->id2 = (gulong) 0;
		_tmp33_ = self->priv->setup_accounts_list;
		_tmp34_ = g_signal_connect_data (_tmp33_, "account-selected", (GCallback) ____lambda79__contacts_accounts_list_account_selected, block34_data_ref (_data34_), (GClosureNotify) block34_data_unref, 0);
		_data34_->id2 = _tmp34_;
		_tmp35_ = self->priv->view_switcher;
		gtk_stack_set_visible_child_name (_tmp35_, "setup-view");
		_tmp36_ = self->priv->setup_header_bar;
		gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp36_);
		_tmp37_ = self->priv->setup_accounts_list;
		contacts_accounts_list_update_contents (_tmp37_, FALSE);
		_tmp38_ = self->priv->setup_done_button;
		g_signal_connect_data (_tmp38_, "clicked", (GCallback) ____lambda80__gtk_button_clicked, block34_data_ref (_data34_), (GClosureNotify) block34_data_unref, 0);
		_tmp39_ = self->priv->setup_cancel_button;
		g_signal_connect_data (_tmp39_, "clicked", (GCallback) ____lambda81__gtk_button_clicked, block34_data_ref (_data34_), (GClosureNotify) block34_data_unref, 0);
		block34_data_unref (_data34_);
		_data34_ = NULL;
	}
	contacts_window_init_content_widgets (self);
	block33_data_unref (_data33_);
	_data33_ = NULL;
	return self;
}


ContactsWindow* contacts_window_new (ContactsApp* app, ContactsStore* contacts_store, ContactsSettings* settings) {
	return contacts_window_construct (CONTACTS_TYPE_WINDOW, app, contacts_store, settings);
}


static void _contacts_window_contact_pane_delete_contact_cb_contacts_contact_pane_will_delete (ContactsContactPane* _sender, ContactsContact* contact, gpointer self) {
	contacts_window_contact_pane_delete_contact_cb ((ContactsWindow*) self, contact);
}


static void _contacts_window_contact_pane_contacts_linked_cb_contacts_contact_pane_contacts_linked (ContactsContactPane* _sender, const gchar* main_contact, const gchar* linked_contact, ContactsLinkOperation* operation, gpointer self) {
	contacts_window_contact_pane_contacts_linked_cb ((ContactsWindow*) self, main_contact, linked_contact, operation);
}


static void contacts_window_create_contact_pane (ContactsWindow* self) {
	ContactsStore* _tmp0_;
	ContactsContactPane* _tmp1_;
	ContactsContactPane* _tmp2_;
	ContactsContactPane* _tmp3_;
	ContactsContactPane* _tmp4_;
	ContactsContactPane* _tmp5_;
	GtkContainer* _tmp6_;
	ContactsContactPane* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = contacts_contact_pane_new (self, _tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->contact_pane);
	self->priv->contact_pane = _tmp1_;
	_tmp2_ = self->priv->contact_pane;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->contact_pane;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	_tmp4_ = self->priv->contact_pane;
	g_signal_connect_object (_tmp4_, "will-delete", (GCallback) _contacts_window_contact_pane_delete_contact_cb_contacts_contact_pane_will_delete, self, 0);
	_tmp5_ = self->priv->contact_pane;
	g_signal_connect_object (_tmp5_, "contacts-linked", (GCallback) _contacts_window_contact_pane_contacts_linked_cb_contacts_contact_pane_contacts_linked, self, 0);
	_tmp6_ = self->priv->contact_pane_container;
	_tmp7_ = self->priv->contact_pane;
	gtk_container_add (_tmp6_, (GtkWidget*) _tmp7_);
}


static void _contacts_window_list_pane_selection_changed_cb_contacts_list_pane_selection_changed (ContactsListPane* _sender, ContactsContact* contact, gpointer self) {
	contacts_window_list_pane_selection_changed_cb ((ContactsWindow*) self, contact);
}


static void _contacts_window_list_pane_link_contacts_cb_contacts_list_pane_link_contacts (ContactsListPane* _sender, GeeLinkedList* contacts_list, gpointer self) {
	contacts_window_list_pane_link_contacts_cb ((ContactsWindow*) self, contacts_list);
}


static void _contacts_window_list_pane_delete_contacts_cb_contacts_list_pane_delete_contacts (ContactsListPane* _sender, GeeLinkedList* contacts_list, gpointer self) {
	contacts_window_list_pane_delete_contacts_cb ((ContactsWindow*) self, contacts_list);
}


static void __lambda90_ (ContactsWindow* self, gint nr_contacts) {
	gint _tmp0_;
	_tmp0_ = nr_contacts;
	if (_tmp0_ == 0) {
		contacts_window_set_left_title (self, _ ("Select"));
	} else {
		gint _tmp1_;
		gint _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = nr_contacts;
		_tmp2_ = nr_contacts;
		_tmp3_ = g_strdup_printf (ngettext ("%d Selected", "%d Selected", (gulong) _tmp1_), _tmp2_);
		_tmp4_ = _tmp3_;
		contacts_window_set_left_title (self, _tmp4_);
		_g_free0 (_tmp4_);
	}
}


static void ___lambda90__contacts_list_pane_contacts_marked (ContactsListPane* _sender, gint contacts_marked, gpointer self) {
	__lambda90_ ((ContactsWindow*) self, contacts_marked);
}


void contacts_window_set_list_pane (ContactsWindow* self) {
	ContactsListPane* _tmp0_;
	ContactsStore* _tmp1_;
	ContactsListPane* _tmp2_;
	ContactsListPane* _tmp3_;
	ContactsListPane* _tmp4_;
	ContactsListPane* _tmp5_;
	ContactsListPane* _tmp6_;
	GtkSizeGroup* _tmp7_;
	ContactsListPane* _tmp8_;
	GtkSizeGroup* _tmp9_;
	GtkGrid* _tmp10_;
	GtkGrid* _tmp11_;
	GtkGrid* _tmp12_;
	ContactsListPane* _tmp13_;
	ContactsContactPane* _tmp14_;
	ContactsContact* _tmp15_;
	ContactsListPane* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list_pane;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = self->priv->_store;
	_tmp2_ = contacts_list_pane_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->list_pane);
	self->priv->list_pane = _tmp2_;
	_tmp3_ = self->priv->list_pane;
	g_signal_connect_object (_tmp3_, "selection-changed", (GCallback) _contacts_window_list_pane_selection_changed_cb_contacts_list_pane_selection_changed, self, 0);
	_tmp4_ = self->priv->list_pane;
	g_signal_connect_object (_tmp4_, "link-contacts", (GCallback) _contacts_window_list_pane_link_contacts_cb_contacts_list_pane_link_contacts, self, 0);
	_tmp5_ = self->priv->list_pane;
	g_signal_connect_object (_tmp5_, "delete-contacts", (GCallback) _contacts_window_list_pane_delete_contacts_cb_contacts_list_pane_delete_contacts, self, 0);
	_tmp6_ = self->priv->list_pane;
	g_signal_connect_object (_tmp6_, "contacts-marked", (GCallback) ___lambda90__contacts_list_pane_contacts_marked, self, 0);
	_tmp7_ = self->priv->left_pane_size_group;
	_tmp8_ = self->priv->list_pane;
	gtk_size_group_add_widget (_tmp7_, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->left_pane_size_group;
	_tmp10_ = self->priv->loading_box;
	gtk_size_group_remove_widget (_tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->loading_box;
	gtk_widget_destroy ((GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->content_grid;
	_tmp13_ = self->priv->list_pane;
	gtk_grid_attach (_tmp12_, (GtkWidget*) _tmp13_, 0, 0, 1, 1);
	_tmp14_ = self->priv->contact_pane;
	_tmp15_ = _tmp14_->contact;
	if (_tmp15_ != NULL) {
		ContactsListPane* _tmp16_;
		ContactsContactPane* _tmp17_;
		ContactsContact* _tmp18_;
		_tmp16_ = self->priv->list_pane;
		_tmp17_ = self->priv->contact_pane;
		_tmp18_ = _tmp17_->contact;
		contacts_list_pane_select_contact (_tmp16_, _tmp18_, FALSE);
	}
	_tmp19_ = self->priv->list_pane;
	gtk_widget_show ((GtkWidget*) _tmp19_);
}


void contacts_window_activate_selection_mode (ContactsWindow* self, gboolean active) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = active;
	if (_tmp0_) {
		GtkHeaderBar* _tmp1_;
		GtkStyleContext* _tmp2_;
		GtkHeaderBar* _tmp3_;
		GtkStyleContext* _tmp4_;
		GtkHeaderBar* _tmp5_;
		ContactsListPane* _tmp6_;
		contacts_window_set_selection_mode (self, TRUE);
		_tmp1_ = self->priv->left_toolbar;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
		gtk_style_context_add_class (_tmp2_, "selection-mode");
		_tmp3_ = self->priv->right_toolbar;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
		gtk_style_context_add_class (_tmp4_, "selection-mode");
		_tmp5_ = self->priv->left_toolbar;
		gtk_header_bar_set_title (_tmp5_, _ ("Select"));
		_tmp6_ = self->priv->list_pane;
		contacts_list_pane_show_selection (_tmp6_);
	} else {
		GtkHeaderBar* _tmp7_;
		GtkStyleContext* _tmp8_;
		GtkHeaderBar* _tmp9_;
		GtkStyleContext* _tmp10_;
		GtkHeaderBar* _tmp11_;
		ContactsListPane* _tmp12_;
		ContactsContactPane* _tmp13_;
		ContactsContact* _tmp14_;
		contacts_window_set_selection_mode (self, FALSE);
		_tmp7_ = self->priv->left_toolbar;
		_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
		gtk_style_context_remove_class (_tmp8_, "selection-mode");
		_tmp9_ = self->priv->right_toolbar;
		_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
		gtk_style_context_remove_class (_tmp10_, "selection-mode");
		_tmp11_ = self->priv->left_toolbar;
		gtk_header_bar_set_title (_tmp11_, _ ("All Contacts"));
		_tmp12_ = self->priv->list_pane;
		contacts_list_pane_hide_selection (_tmp12_);
		_tmp13_ = self->priv->contact_pane;
		_tmp14_ = _tmp13_->contact;
		if (_tmp14_ == NULL) {
			GtkButton* _tmp15_;
			_tmp15_ = self->priv->edit_button;
			gtk_widget_hide ((GtkWidget*) _tmp15_);
		}
	}
}


void contacts_window_enter_edit_mode (ContactsWindow* self) {
	ContactsContactPane* _tmp0_;
	ContactsContact* _tmp1_;
	gchar* name = NULL;
	ContactsContactPane* _tmp2_;
	ContactsContact* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GtkHeaderBar* _tmp10_;
	GtkStyleContext* _tmp11_;
	GtkHeaderBar* _tmp12_;
	GtkStyleContext* _tmp13_;
	ContactsContactPane* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contact_pane;
	_tmp1_ = _tmp0_->contact;
	if (_tmp1_ == NULL) {
		return;
	}
	contacts_window_set_edit_mode (self, TRUE);
	_tmp2_ = self->priv->contact_pane;
	_tmp3_ = _tmp2_->contact;
	_tmp4_ = contacts_contact_get_display_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	name = _tmp6_;
	_tmp7_ = name;
	_tmp8_ = g_strdup_printf (_ ("Editing %s"), _tmp7_);
	_tmp9_ = _tmp8_;
	contacts_window_set_right_title (self, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->left_toolbar;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
	gtk_style_context_add_class (_tmp11_, "selection-mode");
	_tmp12_ = self->priv->right_toolbar;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	gtk_style_context_add_class (_tmp13_, "selection-mode");
	_tmp14_ = self->priv->contact_pane;
	contacts_contact_pane_set_edit_mode (_tmp14_, TRUE, FALSE);
	_g_free0 (name);
}


void contacts_window_leave_edit_mode (ContactsWindow* self, gboolean drop_changes) {
	GtkHeaderBar* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkHeaderBar* _tmp2_;
	GtkStyleContext* _tmp3_;
	gboolean _tmp4_;
	ContactsContactPane* _tmp12_;
	ContactsContact* _tmp13_;
	g_return_if_fail (self != NULL);
	contacts_window_set_edit_mode (self, FALSE);
	_tmp0_ = self->priv->left_toolbar;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_remove_class (_tmp1_, "selection-mode");
	_tmp2_ = self->priv->right_toolbar;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_remove_class (_tmp3_, "selection-mode");
	_tmp4_ = self->priv->new_contact_mode;
	if (_tmp4_) {
		GtkButton* _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = self->priv->done_button;
		gtk_button_set_label (_tmp5_, _ ("Done"));
		_tmp6_ = drop_changes;
		if (_tmp6_) {
			ContactsContactPane* _tmp7_;
			gboolean _tmp8_;
			_tmp7_ = self->priv->contact_pane;
			_tmp8_ = drop_changes;
			contacts_contact_pane_set_edit_mode (_tmp7_, FALSE, _tmp8_);
		} else {
			ContactsContactPane* _tmp9_;
			_tmp9_ = self->priv->contact_pane;
			contacts_contact_pane_create_contact (_tmp9_, NULL, NULL);
		}
		self->priv->new_contact_mode = FALSE;
	} else {
		ContactsContactPane* _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = self->priv->contact_pane;
		_tmp11_ = drop_changes;
		contacts_contact_pane_set_edit_mode (_tmp10_, FALSE, _tmp11_);
	}
	_tmp12_ = self->priv->contact_pane;
	_tmp13_ = _tmp12_->contact;
	if (_tmp13_ != NULL) {
		ContactsContactPane* _tmp14_;
		ContactsContact* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp14_ = self->priv->contact_pane;
		_tmp15_ = _tmp14_->contact;
		_tmp16_ = contacts_contact_get_display_name (_tmp15_);
		_tmp17_ = _tmp16_;
		contacts_window_set_right_title (self, _tmp17_);
	} else {
		GtkButton* _tmp18_;
		contacts_window_set_right_title (self, "");
		_tmp18_ = self->priv->edit_button;
		gtk_widget_hide ((GtkWidget*) _tmp18_);
	}
}


void contacts_window_add_notification (ContactsWindow* self, ContactsInAppNotification* notification) {
	GtkOverlay* _tmp0_;
	ContactsInAppNotification* _tmp1_;
	ContactsInAppNotification* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (notification != NULL);
	_tmp0_ = self->priv->overlay;
	_tmp1_ = notification;
	gtk_overlay_add_overlay (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp2_ = notification;
	contacts_in_app_notification_show (_tmp2_);
}


void contacts_window_set_shown_contact (ContactsWindow* self, ContactsContact* c) {
	ContactsContactPane* _tmp0_;
	gboolean _tmp1_;
	ContactsContactPane* _tmp2_;
	ContactsContact* _tmp3_;
	ContactsListPane* _tmp4_;
	ContactsContact* _tmp7_;
	gboolean _tmp11_ = FALSE;
	ContactsContact* _tmp12_;
	GtkButton* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->contact_pane;
	_tmp1_ = _tmp0_->on_edit_mode;
	if (_tmp1_) {
		contacts_window_leave_edit_mode (self, FALSE);
	}
	_tmp2_ = self->priv->contact_pane;
	_tmp3_ = c;
	contacts_contact_pane_show_contact (_tmp2_, _tmp3_, FALSE);
	_tmp4_ = self->priv->list_pane;
	if (_tmp4_ != NULL) {
		ContactsListPane* _tmp5_;
		ContactsContact* _tmp6_;
		_tmp5_ = self->priv->list_pane;
		_tmp6_ = c;
		contacts_list_pane_select_contact (_tmp5_, _tmp6_, FALSE);
	}
	_tmp7_ = c;
	if (_tmp7_ != NULL) {
		ContactsContact* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp8_ = c;
		_tmp9_ = contacts_contact_get_display_name (_tmp8_);
		_tmp10_ = _tmp9_;
		contacts_window_set_right_title (self, _tmp10_);
	} else {
		contacts_window_set_right_title (self, "");
	}
	_tmp12_ = c;
	if (_tmp12_ != NULL) {
		GtkToggleButton* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp13_ = self->priv->select_button;
		_tmp14_ = gtk_toggle_button_get_active (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp11_ = !_tmp15_;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp16_ = self->priv->edit_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp16_, _tmp11_);
}


void contacts_window_new_contact (ContactsWindow* self) {
	GtkHeaderBar* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkHeaderBar* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkButton* _tmp4_;
	ContactsContactPane* _tmp5_;
	g_return_if_fail (self != NULL);
	contacts_window_set_edit_mode (self, TRUE);
	self->priv->new_contact_mode = TRUE;
	contacts_window_set_right_title (self, _ ("New Contact"));
	_tmp0_ = self->priv->left_toolbar;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	gtk_style_context_add_class (_tmp1_, "selection-mode");
	_tmp2_ = self->priv->right_toolbar;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, "selection-mode");
	_tmp4_ = self->priv->done_button;
	gtk_button_set_label (_tmp4_, _ ("Add"));
	_tmp5_ = self->priv->contact_pane;
	contacts_contact_pane_new_contact (_tmp5_);
}


static void _contacts_window_new_contact_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	contacts_window_new_contact ((ContactsWindow*) self);
}


void contacts_window_show_search (ContactsWindow* self, const gchar* query) {
	ContactsListPane* _tmp0_;
	GtkSearchEntry* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	_tmp0_ = self->priv->list_pane;
	_tmp1_ = _tmp0_->filter_entry;
	_tmp2_ = query;
	gtk_entry_set_text ((GtkEntry*) _tmp1_, _tmp2_);
}


static void __lambda82_ (ContactsWindow* self) {
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->select_button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	contacts_window_activate_selection_mode (self, _tmp2_);
}


static void ___lambda82__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	__lambda82_ ((ContactsWindow*) self);
}


static void __lambda83_ (ContactsWindow* self) {
	contacts_window_enter_edit_mode (self);
}


static void ___lambda83__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda83_ ((ContactsWindow*) self);
}


static void __lambda84_ (ContactsWindow* self) {
	contacts_window_leave_edit_mode (self, FALSE);
}


static void ___lambda84__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda84_ ((ContactsWindow*) self);
}


static void __lambda85_ (ContactsWindow* self) {
	contacts_window_leave_edit_mode (self, TRUE);
}


static void ___lambda85__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda85_ ((ContactsWindow*) self);
}


static void contacts_window_init_content_widgets (ContactsWindow* self) {
	gchar* layout_desc = NULL;
	gchar** tokens = NULL;
	gint tokens_length1 = 0;
	gint _tokens_size_ = 0;
	GtkSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GtkToggleButton* _tmp15_;
	GtkButton* _tmp16_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_settings_get_default ();
	g_object_get (_tmp0_, "gtk-decoration-layout", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_g_free0 (layout_desc);
	layout_desc = _tmp2_;
	_tmp3_ = layout_desc;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ":", 2);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	tokens = _tmp5_;
	tokens_length1 = _vala_array_length (_tmp4_);
	_tokens_size_ = tokens_length1;
	_tmp6_ = tokens;
	_tmp6__length1 = tokens_length1;
	if (_tmp6_ != NULL) {
		GtkHeaderBar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GtkHeaderBar* _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		_tmp7_ = self->priv->right_toolbar;
		_tmp8_ = tokens;
		_tmp8__length1 = tokens_length1;
		_tmp9_ = _tmp8_[1];
		_tmp10_ = g_strdup_printf (":%s", _tmp9_);
		_tmp11_ = _tmp10_;
		gtk_header_bar_set_decoration_layout (_tmp7_, _tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = self->priv->left_toolbar;
		_tmp13_ = tokens;
		_tmp13__length1 = tokens_length1;
		_tmp14_ = _tmp13_[0];
		gtk_header_bar_set_decoration_layout (_tmp12_, _tmp14_);
	}
	_tmp15_ = self->priv->select_button;
	g_signal_connect_object (_tmp15_, "toggled", (GCallback) ___lambda82__gtk_toggle_button_toggled, self, 0);
	_tmp16_ = self->priv->edit_button;
	g_signal_connect_object (_tmp16_, "clicked", (GCallback) ___lambda83__gtk_button_clicked, self, 0);
	_tmp17_ = self->priv->done_button;
	g_signal_connect_object (_tmp17_, "clicked", (GCallback) ___lambda84__gtk_button_clicked, self, 0);
	_tmp18_ = self->priv->cancel_button;
	g_signal_connect_object (_tmp18_, "clicked", (GCallback) ___lambda85__gtk_button_clicked, self, 0);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (layout_desc);
}


static gboolean contacts_window_key_press_event_cb (ContactsWindow* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event;
	_tmp2_ = _tmp1_->keyval;
	_tmp3_ = gdk_keyval_from_name ("q");
	if (_tmp2_ == _tmp3_) {
		GdkEventKey* _tmp4_;
		GdkModifierType _tmp5_;
		_tmp4_ = event;
		_tmp5_ = _tmp4_->state;
		_tmp0_ = (_tmp5_ & GDK_CONTROL_MASK) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ContactsContactPane* _tmp6_;
		_tmp6_ = self->priv->contact_pane;
		contacts_contact_pane_show_contact (_tmp6_, NULL, TRUE);
		gtk_widget_destroy ((GtkWidget*) self);
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		GdkEventKey* _tmp9_;
		guint _tmp10_;
		_tmp9_ = event;
		_tmp10_ = _tmp9_->keyval;
		if (_tmp10_ == ((guint) GDK_KEY_s)) {
			_tmp8_ = TRUE;
		} else {
			GdkEventKey* _tmp11_;
			guint _tmp12_;
			_tmp11_ = event;
			_tmp12_ = _tmp11_->keyval;
			_tmp8_ = _tmp12_ == ((guint) GDK_KEY_f);
		}
		if (_tmp8_) {
			GdkEventKey* _tmp13_;
			GdkModifierType _tmp14_;
			_tmp13_ = event;
			_tmp14_ = _tmp13_->state;
			_tmp7_ = (_tmp14_ & GDK_CONTROL_MASK) != 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ContactsListPane* _tmp15_;
			GtkSearchEntry* _tmp16_;
			_tmp15_ = self->priv->list_pane;
			_tmp16_ = _tmp15_->filter_entry;
			contacts_utils_grab_entry_focus_no_select ((GtkEntry*) _tmp16_);
		} else {
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			gboolean _tmp22_ = FALSE;
			GdkEventKey* _tmp23_;
			gint _tmp24_;
			_tmp23_ = event;
			_tmp24_ = _tmp23_->length;
			if (_tmp24_ >= 1) {
				GdkEventKey* _tmp25_;
				guint _tmp26_;
				guint32 _tmp27_;
				_tmp25_ = event;
				_tmp26_ = _tmp25_->keyval;
				_tmp27_ = gdk_keyval_to_unicode (_tmp26_);
				_tmp22_ = _tmp27_ != ((guint32) 0);
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				GdkEventKey* _tmp28_;
				GdkModifierType _tmp29_;
				_tmp28_ = event;
				_tmp29_ = _tmp28_->state;
				_tmp21_ = (_tmp29_ & GDK_CONTROL_MASK) == 0;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				GdkEventKey* _tmp30_;
				GdkModifierType _tmp31_;
				_tmp30_ = event;
				_tmp31_ = _tmp30_->state;
				_tmp20_ = (_tmp31_ & GDK_MOD1_MASK) == 0;
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				GdkEventKey* _tmp32_;
				guint _tmp33_;
				_tmp32_ = event;
				_tmp33_ = _tmp32_->keyval;
				_tmp19_ = _tmp33_ != ((guint) GDK_KEY_Escape);
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				GdkEventKey* _tmp34_;
				guint _tmp35_;
				_tmp34_ = event;
				_tmp35_ = _tmp34_->keyval;
				_tmp18_ = _tmp35_ != ((guint) GDK_KEY_Tab);
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				GdkEventKey* _tmp36_;
				guint _tmp37_;
				_tmp36_ = event;
				_tmp37_ = _tmp36_->keyval;
				_tmp17_ = _tmp37_ != ((guint) GDK_KEY_BackSpace);
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				ContactsListPane* _tmp38_;
				GtkSearchEntry* _tmp39_;
				GdkEventKey* _tmp40_;
				_tmp38_ = self->priv->list_pane;
				_tmp39_ = _tmp38_->filter_entry;
				contacts_utils_grab_entry_focus_no_select ((GtkEntry*) _tmp39_);
				_tmp40_ = event;
				gtk_window_propagate_key_event ((GtkWindow*) self, _tmp40_);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean _contacts_window_key_press_event_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = contacts_window_key_press_event_cb ((ContactsWindow*) self, event);
	return result;
}


static gboolean contacts_window_delete_event_cb (ContactsWindow* self, GdkEventAny* event) {
	gboolean result = FALSE;
	ContactsContactPane* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->contact_pane;
	contacts_contact_pane_show_contact (_tmp0_, NULL, TRUE);
	result = FALSE;
	return result;
}


static gboolean _contacts_window_delete_event_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = contacts_window_delete_event_cb ((ContactsWindow*) self, event);
	return result;
}


static void contacts_window_list_pane_selection_changed_cb (ContactsWindow* self, ContactsContact* new_selection) {
	ContactsContact* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = new_selection;
	contacts_window_set_shown_contact (self, _tmp0_);
}


static Block35Data* block35_data_ref (Block35Data* _data35_) {
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}


static void block35_data_unref (void * _userdata_) {
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		ContactsWindow* self;
		self = _data35_->self;
		_g_object_unref0 (_data35_->notification);
		_g_object_unref0 (_data35_->operation);
		_g_object_unref0 (self);
		g_slice_free (Block35Data, _data35_);
	}
}


static void __lambda86_ (Block35Data* _data35_, GObject* obj, GAsyncResult* _result_) {
	ContactsWindow* self;
	GAsyncResult* _tmp0_;
	ContactsLinkOperation2* _tmp1_;
	self = _data35_->self;
	g_return_if_fail (_result_ != NULL);
	_tmp0_ = _result_;
	_tmp1_ = contacts_link_contacts_list_finish (_tmp0_);
	_g_object_unref0 (_data35_->operation);
	_data35_->operation = _tmp1_;
}


static void ___lambda86__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda86_ (self, source_object, res);
	block35_data_unref (self);
}


static void __lambda87_ (Block35Data* _data35_) {
	ContactsWindow* self;
	self = _data35_->self;
	contacts_link_operation2_undo (_data35_->operation, NULL, NULL);
	contacts_in_app_notification_dismiss (_data35_->notification);
}


static void ___lambda87__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda87_ (self);
}


static void contacts_window_list_pane_link_contacts_cb (ContactsWindow* self, GeeLinkedList* contact_list) {
	Block35Data* _data35_;
	GtkToggleButton* _tmp0_;
	GeeLinkedList* _tmp1_;
	ContactsStore* _tmp2_;
	gchar* msg = NULL;
	GeeLinkedList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeLinkedList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	GtkButton* b = NULL;
	GtkButton* _tmp10_;
	ContactsInAppNotification* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact_list != NULL);
	_data35_ = g_slice_new0 (Block35Data);
	_data35_->_ref_count_ = 1;
	_data35_->self = g_object_ref (self);
	contacts_window_set_shown_contact (self, NULL);
	_tmp0_ = self->priv->select_button;
	gtk_toggle_button_set_active (_tmp0_, FALSE);
	_data35_->operation = NULL;
	_tmp1_ = contact_list;
	_tmp2_ = self->priv->_store;
	contacts_link_contacts_list (_tmp1_, _tmp2_, ___lambda86__gasync_ready_callback, block35_data_ref (_data35_));
	_tmp3_ = contact_list;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = contact_list;
	_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf (ngettext ("%d contacts linked", "%d contacts linked", (gulong) _tmp5_), _tmp8_);
	msg = _tmp9_;
	_tmp10_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Undo"));
	g_object_ref_sink (_tmp10_);
	b = _tmp10_;
	_tmp11_ = contacts_in_app_notification_new (msg, NULL);
	g_object_ref_sink (_tmp11_);
	_data35_->notification = _tmp11_;
	g_signal_connect_data (b, "clicked", (GCallback) ___lambda87__gtk_button_clicked, block35_data_ref (_data35_), (GClosureNotify) block35_data_unref, 0);
	contacts_window_add_notification (self, _data35_->notification);
	_g_object_unref0 (b);
	_g_free0 (msg);
	block35_data_unref (_data35_);
	_data35_ = NULL;
}


static Block36Data* block36_data_ref (Block36Data* _data36_) {
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}


static void block36_data_unref (void * _userdata_) {
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		ContactsWindow* self;
		self = _data36_->self;
		_g_object_unref0 (_data36_->notification);
		_g_object_unref0 (_data36_->contact_list);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}


static void __lambda88_ (Block36Data* _data36_) {
	ContactsWindow* self;
	ContactsInAppNotification* _tmp0_;
	self = _data36_->self;
	_data36_->really_delete = FALSE;
	_tmp0_ = _data36_->notification;
	contacts_in_app_notification_dismiss (_tmp0_);
}


static void ___lambda88__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda88_ (self);
}


static void __lambda89_ (Block36Data* _data36_) {
	ContactsWindow* self;
	gboolean _tmp0_;
	self = _data36_->self;
	_tmp0_ = _data36_->really_delete;
	if (_tmp0_) {
		{
			GeeLinkedList* _c_list = NULL;
			GeeLinkedList* _tmp1_;
			GeeLinkedList* _tmp2_;
			gint _c_size = 0;
			GeeLinkedList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _c_index = 0;
			_tmp1_ = _data36_->contact_list;
			_tmp2_ = _g_object_ref0 (_tmp1_);
			_c_list = _tmp2_;
			_tmp3_ = _c_list;
			_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_c_size = _tmp5_;
			_c_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				ContactsContact* c = NULL;
				GeeLinkedList* _tmp9_;
				gint _tmp10_;
				gpointer _tmp11_;
				ContactsContact* _tmp12_;
				_tmp6_ = _c_index;
				_c_index = _tmp6_ + 1;
				_tmp7_ = _c_index;
				_tmp8_ = _c_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _c_list;
				_tmp10_ = _c_index;
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
				c = (ContactsContact*) _tmp11_;
				_tmp12_ = c;
				contacts_contact_remove_personas (_tmp12_, NULL, NULL);
				_g_object_unref0 (c);
			}
			_g_object_unref0 (_c_list);
		}
	}
}


static void ___lambda89__contacts_in_app_notification_dismissed (ContactsInAppNotification* _sender, gpointer self) {
	__lambda89_ (self);
}


static void contacts_window_list_pane_delete_contacts_cb (ContactsWindow* self, GeeLinkedList* contact_list) {
	Block36Data* _data36_;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GtkToggleButton* _tmp2_;
	gchar* msg = NULL;
	GeeLinkedList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeLinkedList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	GtkButton* b = NULL;
	GtkButton* _tmp10_;
	const gchar* _tmp11_;
	GtkButton* _tmp12_;
	ContactsInAppNotification* _tmp13_;
	GtkButton* _tmp14_;
	ContactsInAppNotification* _tmp15_;
	ContactsInAppNotification* _tmp16_;
	GeeLinkedList* _tmp29_;
	gpointer _tmp30_;
	ContactsContact* _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact_list != NULL);
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_data36_->self = g_object_ref (self);
	_tmp0_ = contact_list;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data36_->contact_list);
	_data36_->contact_list = _tmp1_;
	contacts_window_set_shown_contact (self, NULL);
	_tmp2_ = self->priv->select_button;
	gtk_toggle_button_set_active (_tmp2_, FALSE);
	_tmp3_ = _data36_->contact_list;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _data36_->contact_list;
	_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf (ngettext ("%d contact deleted", "%d contacts deleted", (gulong) _tmp5_), _tmp8_);
	msg = _tmp9_;
	_tmp10_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Undo"));
	g_object_ref_sink (_tmp10_);
	b = _tmp10_;
	_tmp11_ = msg;
	_tmp12_ = b;
	_tmp13_ = contacts_in_app_notification_new (_tmp11_, _tmp12_);
	g_object_ref_sink (_tmp13_);
	_data36_->notification = _tmp13_;
	_data36_->really_delete = TRUE;
	_tmp14_ = b;
	g_signal_connect_data (_tmp14_, "clicked", (GCallback) ___lambda88__gtk_button_clicked, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
	_tmp15_ = _data36_->notification;
	g_signal_connect_data (_tmp15_, "dismissed", (GCallback) ___lambda89__contacts_in_app_notification_dismissed, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
	_tmp16_ = _data36_->notification;
	contacts_window_add_notification (self, _tmp16_);
	{
		GeeLinkedList* _c_list = NULL;
		GeeLinkedList* _tmp17_;
		GeeLinkedList* _tmp18_;
		gint _c_size = 0;
		GeeLinkedList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _c_index = 0;
		_tmp17_ = _data36_->contact_list;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		_c_list = _tmp18_;
		_tmp19_ = _c_list;
		_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_c_size = _tmp21_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			ContactsContact* c = NULL;
			GeeLinkedList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			ContactsContact* _tmp28_;
			_tmp22_ = _c_index;
			_c_index = _tmp22_ + 1;
			_tmp23_ = _c_index;
			_tmp24_ = _c_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _c_list;
			_tmp26_ = _c_index;
			_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _tmp26_);
			c = (ContactsContact*) _tmp27_;
			_tmp28_ = c;
			contacts_contact_show (_tmp28_);
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_list);
	}
	_tmp29_ = _data36_->contact_list;
	_tmp30_ = gee_linked_list_last (_tmp29_);
	_tmp31_ = (ContactsContact*) _tmp30_;
	contacts_window_set_shown_contact (self, _tmp31_);
	_g_object_unref0 (_tmp31_);
	_g_object_unref0 (b);
	_g_free0 (msg);
	block36_data_unref (_data36_);
	_data36_ = NULL;
}


static Block37Data* block37_data_ref (Block37Data* _data37_) {
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}


static void block37_data_unref (void * _userdata_) {
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		ContactsWindow* self;
		self = _data37_->self;
		_g_object_unref0 (_data37_->notification);
		_g_object_unref0 (_data37_->contact);
		_g_object_unref0 (self);
		g_slice_free (Block37Data, _data37_);
	}
}


static void ___lambda75_ (Block37Data* _data37_) {
	ContactsWindow* self;
	ContactsContact* _tmp0_;
	self = _data37_->self;
	_tmp0_ = _data37_->contact;
	contacts_contact_show (_tmp0_);
}


static void ____lambda75__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda75_ (self);
	block37_data_unref (self);
}


static void __lambda74_ (Block37Data* _data37_) {
	ContactsWindow* self;
	self = _data37_->self;
	if (_data37_->really_delete) {
		ContactsContact* _tmp0_;
		_tmp0_ = _data37_->contact;
		contacts_contact_remove_personas (_tmp0_, ____lambda75__gasync_ready_callback, block37_data_ref (_data37_));
	}
}


static void ___lambda74__contacts_in_app_notification_dismissed (ContactsInAppNotification* _sender, gpointer self) {
	__lambda74_ (self);
}


static void __lambda76_ (Block37Data* _data37_) {
	ContactsWindow* self;
	ContactsContact* _tmp0_;
	ContactsContact* _tmp1_;
	self = _data37_->self;
	_data37_->really_delete = FALSE;
	contacts_in_app_notification_dismiss (_data37_->notification);
	_tmp0_ = _data37_->contact;
	contacts_contact_show (_tmp0_);
	_tmp1_ = _data37_->contact;
	contacts_window_set_shown_contact (self, _tmp1_);
}


static void ___lambda76__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda76_ (self);
}


static void contacts_window_contact_pane_delete_contact_cb (ContactsWindow* self, ContactsContact* contact) {
	Block37Data* _data37_;
	ContactsContact* _tmp0_;
	ContactsContact* _tmp1_;
	GtkToggleButton* _tmp2_;
	gchar* msg = NULL;
	ContactsContact* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GtkButton* b = NULL;
	GtkButton* _tmp7_;
	ContactsInAppNotification* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	_data37_ = g_slice_new0 (Block37Data);
	_data37_->_ref_count_ = 1;
	_data37_->self = g_object_ref (self);
	_tmp0_ = contact;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data37_->contact);
	_data37_->contact = _tmp1_;
	contacts_window_set_shown_contact (self, NULL);
	_tmp2_ = self->priv->select_button;
	gtk_toggle_button_set_active (_tmp2_, FALSE);
	_tmp3_ = _data37_->contact;
	_tmp4_ = contacts_contact_get_display_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf (_ ("Contact deleted: “%s”"), _tmp5_);
	msg = _tmp6_;
	_tmp7_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Undo"));
	g_object_ref_sink (_tmp7_);
	b = _tmp7_;
	_tmp8_ = contacts_in_app_notification_new (msg, b);
	g_object_ref_sink (_tmp8_);
	_data37_->notification = _tmp8_;
	_tmp9_ = contacts_in_app_notification_get_message_label (_data37_->notification);
	_tmp10_ = _tmp9_;
	g_object_set (_tmp10_, "wrap", FALSE, NULL);
	_tmp11_ = contacts_in_app_notification_get_message_label (_data37_->notification);
	_tmp12_ = _tmp11_;
	gtk_label_set_max_width_chars (_tmp12_, 45);
	_tmp13_ = contacts_in_app_notification_get_message_label (_data37_->notification);
	_tmp14_ = _tmp13_;
	gtk_label_set_ellipsize (_tmp14_, PANGO_ELLIPSIZE_END);
	_data37_->really_delete = TRUE;
	g_signal_connect_data (_data37_->notification, "dismissed", (GCallback) ___lambda74__contacts_in_app_notification_dismissed, block37_data_ref (_data37_), (GClosureNotify) block37_data_unref, 0);
	contacts_window_add_notification (self, _data37_->notification);
	g_signal_connect_data (b, "clicked", (GCallback) ___lambda76__gtk_button_clicked, block37_data_ref (_data37_), (GClosureNotify) block37_data_unref, 0);
	_g_object_unref0 (b);
	_g_free0 (msg);
	block37_data_unref (_data37_);
	_data37_ = NULL;
}


static Block38Data* block38_data_ref (Block38Data* _data38_) {
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}


static void block38_data_unref (void * _userdata_) {
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		ContactsWindow* self;
		self = _data38_->self;
		_g_object_unref0 (_data38_->notification);
		_g_object_unref0 (_data38_->operation);
		_g_object_unref0 (self);
		g_slice_free (Block38Data, _data38_);
	}
}


static void __lambda77_ (Block38Data* _data38_) {
	ContactsWindow* self;
	ContactsLinkOperation* _tmp0_;
	self = _data38_->self;
	contacts_in_app_notification_dismiss (_data38_->notification);
	_tmp0_ = _data38_->operation;
	contacts_link_operation_undo (_tmp0_, NULL, NULL);
}


static void ___lambda77__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda77_ (self);
}


static void contacts_window_contact_pane_contacts_linked_cb (ContactsWindow* self, const gchar* main_contact, const gchar* linked_contact, ContactsLinkOperation* operation) {
	Block38Data* _data38_;
	ContactsLinkOperation* _tmp0_;
	ContactsLinkOperation* _tmp1_;
	gchar* msg = NULL;
	const gchar* _tmp2_;
	GtkButton* b = NULL;
	GtkButton* _tmp8_;
	const gchar* _tmp9_;
	ContactsInAppNotification* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (linked_contact != NULL);
	g_return_if_fail (operation != NULL);
	_data38_ = g_slice_new0 (Block38Data);
	_data38_->_ref_count_ = 1;
	_data38_->self = g_object_ref (self);
	_tmp0_ = operation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data38_->operation);
	_data38_->operation = _tmp1_;
	_tmp2_ = main_contact;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = main_contact;
		_tmp4_ = linked_contact;
		_tmp5_ = g_strdup_printf (_ ("%s linked to %s"), _tmp3_, _tmp4_);
		_g_free0 (msg);
		msg = _tmp5_;
	} else {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = linked_contact;
		_tmp7_ = g_strdup_printf (_ ("%s linked to the contact"), _tmp6_);
		_g_free0 (msg);
		msg = _tmp7_;
	}
	_tmp8_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Undo"));
	g_object_ref_sink (_tmp8_);
	b = _tmp8_;
	_tmp9_ = msg;
	_tmp10_ = contacts_in_app_notification_new (_tmp9_, b);
	g_object_ref_sink (_tmp10_);
	_data38_->notification = _tmp10_;
	g_signal_connect_data (b, "clicked", (GCallback) ___lambda77__gtk_button_clicked, block38_data_ref (_data38_), (GClosureNotify) block38_data_unref, 0);
	contacts_window_add_notification (self, _data38_->notification);
	_g_object_unref0 (b);
	_g_free0 (msg);
	block38_data_unref (_data38_);
	_data38_ = NULL;
}


static const gchar* contacts_window_get_left_title (ContactsWindow* self) {
	const gchar* result;
	GtkHeaderBar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->left_toolbar;
	_tmp1_ = gtk_header_bar_get_title (_tmp0_);
	result = _tmp1_;
	return result;
}


static void contacts_window_set_left_title (ContactsWindow* self, const gchar* value) {
	GtkHeaderBar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->left_toolbar;
	_tmp1_ = value;
	gtk_header_bar_set_title (_tmp0_, _tmp1_);
}


static const gchar* contacts_window_get_right_title (ContactsWindow* self) {
	const gchar* result;
	GtkHeaderBar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->right_toolbar;
	_tmp1_ = gtk_header_bar_get_title (_tmp0_);
	result = _tmp1_;
	return result;
}


static void contacts_window_set_right_title (ContactsWindow* self, const gchar* value) {
	GtkHeaderBar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->right_toolbar;
	_tmp1_ = value;
	gtk_header_bar_set_title (_tmp0_, _tmp1_);
}


ContactsStore* contacts_window_get_store (ContactsWindow* self) {
	ContactsStore* result;
	ContactsStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	result = _tmp0_;
	return result;
}


void contacts_window_set_store (ContactsWindow* self, ContactsStore* value) {
	g_return_if_fail (self != NULL);
	if (contacts_window_get_store (self) != value) {
		ContactsStore* _tmp0_;
		ContactsStore* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_store);
		self->priv->_store = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, contacts_window_properties[CONTACTS_WINDOW_STORE_PROPERTY]);
	}
}


gboolean contacts_window_get_selection_mode (ContactsWindow* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_selection_mode;
	result = _tmp0_;
	return result;
}


void contacts_window_set_selection_mode (ContactsWindow* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (contacts_window_get_selection_mode (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_selection_mode = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_window_properties[CONTACTS_WINDOW_SELECTION_MODE_PROPERTY]);
	}
}


gboolean contacts_window_get_edit_mode (ContactsWindow* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_edit_mode;
	result = _tmp0_;
	return result;
}


void contacts_window_set_edit_mode (ContactsWindow* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (contacts_window_get_edit_mode (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_edit_mode = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_window_properties[CONTACTS_WINDOW_EDIT_MODE_PROPERTY]);
	}
}


static void contacts_window_class_init (ContactsWindowClass * klass) {
	gint ContactsWindow_private_offset;
	contacts_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsWindowPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_WINDOW_STORE_PROPERTY, contacts_window_properties[CONTACTS_WINDOW_STORE_PROPERTY] = g_param_spec_object ("store", "store", "store", CONTACTS_TYPE_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_WINDOW_SELECTION_MODE_PROPERTY, contacts_window_properties[CONTACTS_WINDOW_SELECTION_MODE_PROPERTY] = g_param_spec_boolean ("selection-mode", "selection-mode", "selection-mode", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_WINDOW_EDIT_MODE_PROPERTY, contacts_window_properties[CONTACTS_WINDOW_EDIT_MODE_PROPERTY] = g_param_spec_boolean ("edit-mode", "edit-mode", "edit-mode", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	ContactsWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/contacts/ui/contacts-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_grid", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, content_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "contact_pane_container", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, contact_pane_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "loading_box", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, loading_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "left_pane_size_group", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, left_pane_size_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "left_toolbar", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, left_toolbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "right_toolbar", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, right_toolbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "add_button", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, add_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "select_button", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, select_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "edit_button", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, edit_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cancel_button", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, cancel_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "done_button", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, done_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "view_switcher", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, view_switcher));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_header_bar", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, content_header_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "setup_view", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, setup_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "setup_header_bar", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, setup_header_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "setup_done_button", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, setup_done_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "setup_cancel_button", FALSE, ContactsWindow_private_offset + G_STRUCT_OFFSET (ContactsWindowPrivate, setup_cancel_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "new_contact", G_CALLBACK(_contacts_window_new_contact_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "key_press_event_cb", G_CALLBACK(_contacts_window_key_press_event_cb_gtk_widget_key_press_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_event_cb", G_CALLBACK(_contacts_window_delete_event_cb_gtk_widget_delete_event));
}


static void contacts_window_instance_init (ContactsWindow * self) {
	self->priv = CONTACTS_WINDOW_GET_PRIVATE (self);
	self->priv->new_contact_mode = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void contacts_window_finalize (GObject * obj) {
	ContactsWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_WINDOW, ContactsWindow);
	_g_object_unref0 (self->priv->content_grid);
	_g_object_unref0 (self->priv->contact_pane_container);
	_g_object_unref0 (self->priv->loading_box);
	_g_object_unref0 (self->priv->left_pane_size_group);
	_g_object_unref0 (self->priv->left_toolbar);
	_g_object_unref0 (self->priv->right_toolbar);
	_g_object_unref0 (self->priv->overlay);
	_g_object_unref0 (self->priv->add_button);
	_g_object_unref0 (self->priv->select_button);
	_g_object_unref0 (self->priv->edit_button);
	_g_object_unref0 (self->priv->cancel_button);
	_g_object_unref0 (self->priv->done_button);
	_g_object_unref0 (self->priv->view_switcher);
	_g_object_unref0 (self->priv->content_header_bar);
	_g_object_unref0 (self->priv->setup_view);
	_g_object_unref0 (self->priv->setup_header_bar);
	_g_object_unref0 (self->priv->setup_done_button);
	_g_object_unref0 (self->priv->setup_cancel_button);
	_g_object_unref0 (self->priv->setup_accounts_list);
	_g_object_unref0 (self->priv->list_pane);
	_g_object_unref0 (self->priv->contact_pane);
	_g_object_unref0 (self->priv->_store);
	G_OBJECT_CLASS (contacts_window_parent_class)->finalize (obj);
}


GType contacts_window_get_type (void) {
	static volatile gsize contacts_window_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsWindow), 0, (GInstanceInitFunc) contacts_window_instance_init, NULL };
		GType contacts_window_type_id;
		contacts_window_type_id = g_type_register_static (gtk_application_window_get_type (), "ContactsWindow", &g_define_type_info, 0);
		g_once_init_leave (&contacts_window_type_id__volatile, contacts_window_type_id);
	}
	return contacts_window_type_id__volatile;
}


static void _vala_contacts_window_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ContactsWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_WINDOW, ContactsWindow);
	switch (property_id) {
		case CONTACTS_WINDOW_STORE_PROPERTY:
		g_value_set_object (value, contacts_window_get_store (self));
		break;
		case CONTACTS_WINDOW_SELECTION_MODE_PROPERTY:
		g_value_set_boolean (value, contacts_window_get_selection_mode (self));
		break;
		case CONTACTS_WINDOW_EDIT_MODE_PROPERTY:
		g_value_set_boolean (value, contacts_window_get_edit_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_contacts_window_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ContactsWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_WINDOW, ContactsWindow);
	switch (property_id) {
		case CONTACTS_WINDOW_STORE_PROPERTY:
		contacts_window_set_store (self, g_value_get_object (value));
		break;
		case CONTACTS_WINDOW_SELECTION_MODE_PROPERTY:
		contacts_window_set_selection_mode (self, g_value_get_boolean (value));
		break;
		case CONTACTS_WINDOW_EDIT_MODE_PROPERTY:
		contacts_window_set_edit_mode (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



