; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=amdgcn -mcpu=tahiti | FileCheck %s --check-prefixes=GFX6,GCN
; RUN: llc < %s -mtriple=amdgcn -mcpu=tonga | FileCheck %s --check-prefixes=GFX8,GCN
; RUN: llc < %s -mtriple=amdgcn-amd-amdpal -mcpu=gfx1030 | FileCheck %s --check-prefixes=GFX10,GCN
; RUN: llc < %s -mtriple=amdgcn-amd-amdpal -mcpu=gfx1100 -amdgpu-enable-vopd=0 | FileCheck %s --check-prefixes=GFX11,GCN
; RUN: llc < %s -mtriple=amdgcn -mcpu=gfx940 | FileCheck %s --check-prefixes=GFX940,GCN

define amdgpu_kernel void @build_vector2 (ptr addrspace(1) %out) {
; GFX6-LABEL: build_vector2:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, 5
; GFX6-NEXT:    v_mov_b32_e32 v1, 6
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: build_vector2:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8-NEXT:    v_mov_b32_e32 v0, 5
; GFX8-NEXT:    v_mov_b32_e32 v1, 6
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: build_vector2:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, 5
; GFX10-NEXT:    v_mov_b32_e32 v1, 6
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: build_vector2:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    v_mov_b32_e32 v0, 5
; GFX11-NEXT:    v_mov_b32_e32 v1, 6
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; GFX940-LABEL: build_vector2:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX940-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, 5
; GFX940-NEXT:    v_mov_b32_e32 v1, 6
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_endpgm
entry:
  store <2 x i32> <i32 5, i32 6>, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @build_vector4 (ptr addrspace(1) %out) {
; GFX6-LABEL: build_vector4:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, 5
; GFX6-NEXT:    v_mov_b32_e32 v1, 6
; GFX6-NEXT:    v_mov_b32_e32 v2, 7
; GFX6-NEXT:    v_mov_b32_e32 v3, 8
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    buffer_store_dwordx4 v[0:3], off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: build_vector4:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8-NEXT:    v_mov_b32_e32 v0, 5
; GFX8-NEXT:    v_mov_b32_e32 v1, 6
; GFX8-NEXT:    v_mov_b32_e32 v2, 7
; GFX8-NEXT:    v_mov_b32_e32 v3, 8
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v5, s1
; GFX8-NEXT:    v_mov_b32_e32 v4, s0
; GFX8-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: build_vector4:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    v_mov_b32_e32 v0, 5
; GFX10-NEXT:    v_mov_b32_e32 v1, 6
; GFX10-NEXT:    v_mov_b32_e32 v2, 7
; GFX10-NEXT:    v_mov_b32_e32 v3, 8
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: build_vector4:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    v_mov_b32_e32 v0, 5
; GFX11-NEXT:    v_mov_b32_e32 v1, 6
; GFX11-NEXT:    v_mov_b32_e32 v2, 7
; GFX11-NEXT:    v_mov_b32_e32 v3, 8
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b128 v4, v[0:3], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; GFX940-LABEL: build_vector4:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX940-NEXT:    v_mov_b32_e32 v4, 0
; GFX940-NEXT:    v_mov_b32_e32 v0, 5
; GFX940-NEXT:    v_mov_b32_e32 v1, 6
; GFX940-NEXT:    v_mov_b32_e32 v2, 7
; GFX940-NEXT:    v_mov_b32_e32 v3, 8
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1] sc0 sc1
; GFX940-NEXT:    s_endpgm
entry:
  store <4 x i32> <i32 5, i32 6, i32 7, i32 8>, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @build_vector_v2i16 (ptr addrspace(1) %out) {
; GFX6-LABEL: build_vector_v2i16:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    v_mov_b32_e32 v0, 0x60005
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: build_vector_v2i16:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x60005
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: build_vector_v2i16:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    v_mov_b32_e32 v1, 0x60005
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: build_vector_v2i16:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    v_mov_b32_e32 v1, 0x60005
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
;
; GFX940-LABEL: build_vector_v2i16:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    v_mov_b32_e32 v1, 0x60005
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_endpgm
entry:
  store <2 x i16> <i16 5, i16 6>, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @build_vector_v2i16_trunc (ptr addrspace(1) %out, i32 %a) {
; GFX6-LABEL: build_vector_v2i16_trunc:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_load_dword s6, s[4:5], 0xb
; GFX6-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x9
; GFX6-NEXT:    s_mov_b32 s3, 0xf000
; GFX6-NEXT:    s_mov_b32 s2, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    v_alignbit_b32 v0, 5, s6, 16
; GFX6-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: build_vector_v2i16_trunc:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX8-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshr_b32 s2, s2, 16
; GFX8-NEXT:    s_or_b32 s2, s2, 0x50000
; GFX8-NEXT:    v_mov_b32_e32 v0, s0
; GFX8-NEXT:    v_mov_b32_e32 v1, s1
; GFX8-NEXT:    v_mov_b32_e32 v2, s2
; GFX8-NEXT:    flat_store_dword v[0:1], v2
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: build_vector_v2i16_trunc:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_clause 0x1
; GFX10-NEXT:    s_load_dword s2, s[4:5], 0x8
; GFX10-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_lshr_b32 s2, s2, 16
; GFX10-NEXT:    s_pack_ll_b32_b16 s2, s2, 5
; GFX10-NEXT:    v_mov_b32_e32 v1, s2
; GFX10-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: build_vector_v2i16_trunc:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x8
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_pack_hl_b32_b16 s2, s2, 5
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_mov_b32_e32 v1, s2
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_endpgm
;
; GFX940-LABEL: build_vector_v2i16_trunc:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX940-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX940-NEXT:    v_mov_b32_e32 v0, 0
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_lshr_b32 s2, s2, 16
; GFX940-NEXT:    s_pack_ll_b32_b16 s2, s2, 5
; GFX940-NEXT:    v_mov_b32_e32 v1, s2
; GFX940-NEXT:    global_store_dword v0, v1, s[0:1] sc0 sc1
; GFX940-NEXT:    s_endpgm
  %srl = lshr i32 %a, 16
  %trunc = trunc i32 %srl to i16
  %ins.0 = insertelement <2 x i16> undef, i16 %trunc, i32 0
  %ins.1 = insertelement <2 x i16> %ins.0, i16 5, i32 1
  store <2 x i16> %ins.1, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @build_v2i32_from_v4i16_shuffle(ptr addrspace(1) %out, <4 x i16> %in) {
; GFX6-LABEL: build_v2i32_from_v4i16_shuffle:
; GFX6:       ; %bb.0: ; %entry
; GFX6-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; GFX6-NEXT:    s_mov_b32 s7, 0xf000
; GFX6-NEXT:    s_mov_b32 s6, -1
; GFX6-NEXT:    s_waitcnt lgkmcnt(0)
; GFX6-NEXT:    s_mov_b32 s4, s0
; GFX6-NEXT:    s_mov_b32 s5, s1
; GFX6-NEXT:    s_lshl_b32 s0, s3, 16
; GFX6-NEXT:    s_lshl_b32 s1, s2, 16
; GFX6-NEXT:    v_mov_b32_e32 v0, s1
; GFX6-NEXT:    v_mov_b32_e32 v1, s0
; GFX6-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GFX6-NEXT:    s_endpgm
;
; GFX8-LABEL: build_v2i32_from_v4i16_shuffle:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX8-NEXT:    s_waitcnt lgkmcnt(0)
; GFX8-NEXT:    s_lshl_b32 s3, s3, 16
; GFX8-NEXT:    s_lshl_b32 s2, s2, 16
; GFX8-NEXT:    v_mov_b32_e32 v3, s1
; GFX8-NEXT:    v_mov_b32_e32 v0, s2
; GFX8-NEXT:    v_mov_b32_e32 v1, s3
; GFX8-NEXT:    v_mov_b32_e32 v2, s0
; GFX8-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GFX8-NEXT:    s_endpgm
;
; GFX10-LABEL: build_v2i32_from_v4i16_shuffle:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_lshl_b32 s2, s2, 16
; GFX10-NEXT:    s_lshl_b32 s3, s3, 16
; GFX10-NEXT:    v_mov_b32_e32 v0, s2
; GFX10-NEXT:    v_mov_b32_e32 v1, s3
; GFX10-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: build_v2i32_from_v4i16_shuffle:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshl_b32 s2, s2, 16
; GFX11-NEXT:    s_lshl_b32 s3, s3, 16
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; GFX940-LABEL: build_v2i32_from_v4i16_shuffle:
; GFX940:       ; %bb.0: ; %entry
; GFX940-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX940-NEXT:    v_mov_b32_e32 v2, 0
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_lshl_b32 s3, s3, 16
; GFX940-NEXT:    s_lshl_b32 s2, s2, 16
; GFX940-NEXT:    v_mov_b32_e32 v0, s2
; GFX940-NEXT:    v_mov_b32_e32 v1, s3
; GFX940-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1] sc0 sc1
; GFX940-NEXT:    s_endpgm
entry:
  %shuf = shufflevector <4 x i16> %in, <4 x i16> zeroinitializer, <2 x i32> <i32 0, i32 2>
  %zextended = zext <2 x i16> %shuf to <2 x i32>
  %shifted = shl <2 x i32> %zextended, <i32 16, i32 16>
  store <2 x i32> %shifted, ptr addrspace(1) %out
  ret void
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GCN: {{.*}}
