//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// UNSUPPORTED: c++03

// <unordered_set>

// template <class Value, class Hash = hash<Value>, class Pred = equal_to<Value>,
//           class Alloc = allocator<Value>>
// class unordered_set

// template <class... Args>
//     iterator emplace_hint(const_iterator p, Args&&... args);

#include <unordered_set>
#include <cassert>

#include "test_macros.h"
#include "../../Emplaceable.h"
#include "min_allocator.h"

int main(int, char**) {
  {
    typedef std::unordered_set<Emplaceable> C;
    typedef C::iterator R;
    C c;
    R r = c.emplace_hint(c.end());
    assert(c.size() == 1);
    assert(*r == Emplaceable());

    r = c.emplace_hint(c.end(), Emplaceable(5, 6));
    assert(c.size() == 2);
    assert(*r == Emplaceable(5, 6));

    r = c.emplace_hint(r, 5, 6);
    assert(c.size() == 2);
    assert(*r == Emplaceable(5, 6));
  }
  {
    typedef std::
        unordered_set<Emplaceable, std::hash<Emplaceable>, std::equal_to<Emplaceable>, min_allocator<Emplaceable>>
            C;
    typedef C::iterator R;
    C c;
    R r = c.emplace_hint(c.end());
    assert(c.size() == 1);
    assert(*r == Emplaceable());

    r = c.emplace_hint(c.end(), Emplaceable(5, 6));
    assert(c.size() == 2);
    assert(*r == Emplaceable(5, 6));

    r = c.emplace_hint(r, 5, 6);
    assert(c.size() == 2);
    assert(*r == Emplaceable(5, 6));
  }

  return 0;
}
