/* context.c generated by valac 0.38.8, the Vala compiler
 * generated from context.vala, do not modify */

/*
 * Copyright (C) 2011-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define KKC_TYPE_CONTEXT (kkc_context_get_type ())
#define KKC_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CONTEXT, KkcContext))
#define KKC_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CONTEXT, KkcContextClass))
#define KKC_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CONTEXT))
#define KKC_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CONTEXT))
#define KKC_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CONTEXT, KkcContextClass))

typedef struct _KkcContext KkcContext;
typedef struct _KkcContextClass KkcContextClass;
typedef struct _KkcContextPrivate KkcContextPrivate;

#define KKC_TYPE_STATE (kkc_state_get_type ())
#define KKC_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_STATE, KkcState))
#define KKC_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_STATE, KkcStateClass))
#define KKC_IS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_STATE))
#define KKC_IS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_STATE))
#define KKC_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_STATE, KkcStateClass))

typedef struct _KkcState KkcState;
typedef struct _KkcStateClass KkcStateClass;

#define KKC_TYPE_STATE_HANDLER (kkc_state_handler_get_type ())
#define KKC_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_STATE_HANDLER, KkcStateHandler))
#define KKC_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_STATE_HANDLER, KkcStateHandlerClass))
#define KKC_IS_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_STATE_HANDLER))
#define KKC_IS_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_STATE_HANDLER))
#define KKC_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_STATE_HANDLER, KkcStateHandlerClass))

typedef struct _KkcStateHandler KkcStateHandler;
typedef struct _KkcStateHandlerClass KkcStateHandlerClass;
enum  {
	KKC_CONTEXT_0_PROPERTY,
	KKC_CONTEXT_DICTIONARIES_PROPERTY,
	KKC_CONTEXT_CANDIDATES_PROPERTY,
	KKC_CONTEXT_SEGMENTS_PROPERTY,
	KKC_CONTEXT_INPUT_PROPERTY,
	KKC_CONTEXT_INPUT_CURSOR_POS_PROPERTY,
	KKC_CONTEXT_INPUT_CURSOR_WIDTH_PROPERTY,
	KKC_CONTEXT_INPUT_MODE_PROPERTY,
	KKC_CONTEXT_PUNCTUATION_STYLE_PROPERTY,
	KKC_CONTEXT_AUTO_CORRECT_PROPERTY,
	KKC_CONTEXT_TYPING_RULE_PROPERTY,
	KKC_CONTEXT_KEY_EVENT_FILTER_PROPERTY,
	KKC_CONTEXT_NUM_PROPERTIES
};
static GParamSpec* kkc_context_properties[KKC_CONTEXT_NUM_PROPERTIES];

#define KKC_TYPE_DICTIONARY_LIST (kkc_dictionary_list_get_type ())
#define KKC_DICTIONARY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DICTIONARY_LIST, KkcDictionaryList))
#define KKC_DICTIONARY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_DICTIONARY_LIST, KkcDictionaryListClass))
#define KKC_IS_DICTIONARY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DICTIONARY_LIST))
#define KKC_IS_DICTIONARY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_DICTIONARY_LIST))
#define KKC_DICTIONARY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_DICTIONARY_LIST, KkcDictionaryListClass))

typedef struct _KkcDictionaryList KkcDictionaryList;
typedef struct _KkcDictionaryListClass KkcDictionaryListClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define KKC_TYPE_KEY_EVENT (kkc_key_event_get_type ())
#define KKC_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_KEY_EVENT, KkcKeyEvent))
#define KKC_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_KEY_EVENT, KkcKeyEventClass))
#define KKC_IS_KEY_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_KEY_EVENT))
#define KKC_IS_KEY_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_KEY_EVENT))
#define KKC_KEY_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_KEY_EVENT, KkcKeyEventClass))

typedef struct _KkcKeyEvent KkcKeyEvent;
typedef struct _KkcKeyEventClass KkcKeyEventClass;

#define KKC_TYPE_LANGUAGE_MODEL (kkc_language_model_get_type ())
#define KKC_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModel))
#define KKC_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))
#define KKC_IS_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_IS_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))

typedef struct _KkcLanguageModel KkcLanguageModel;
typedef struct _KkcLanguageModelClass KkcLanguageModelClass;

#define KKC_TYPE_INITIAL_STATE_HANDLER (kkc_initial_state_handler_get_type ())
#define KKC_INITIAL_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_INITIAL_STATE_HANDLER, KkcInitialStateHandler))
#define KKC_INITIAL_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_INITIAL_STATE_HANDLER, KkcInitialStateHandlerClass))
#define KKC_IS_INITIAL_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_INITIAL_STATE_HANDLER))
#define KKC_IS_INITIAL_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_INITIAL_STATE_HANDLER))
#define KKC_INITIAL_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_INITIAL_STATE_HANDLER, KkcInitialStateHandlerClass))

typedef struct _KkcInitialStateHandler KkcInitialStateHandler;
typedef struct _KkcInitialStateHandlerClass KkcInitialStateHandlerClass;

#define KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER (kkc_convert_sentence_state_handler_get_type ())
#define KKC_CONVERT_SENTENCE_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER, KkcConvertSentenceStateHandler))
#define KKC_CONVERT_SENTENCE_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER, KkcConvertSentenceStateHandlerClass))
#define KKC_IS_CONVERT_SENTENCE_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER))
#define KKC_IS_CONVERT_SENTENCE_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER))
#define KKC_CONVERT_SENTENCE_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER, KkcConvertSentenceStateHandlerClass))

typedef struct _KkcConvertSentenceStateHandler KkcConvertSentenceStateHandler;
typedef struct _KkcConvertSentenceStateHandlerClass KkcConvertSentenceStateHandlerClass;

#define KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER (kkc_convert_segment_state_handler_get_type ())
#define KKC_CONVERT_SEGMENT_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER, KkcConvertSegmentStateHandler))
#define KKC_CONVERT_SEGMENT_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER, KkcConvertSegmentStateHandlerClass))
#define KKC_IS_CONVERT_SEGMENT_STATE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER))
#define KKC_IS_CONVERT_SEGMENT_STATE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER))
#define KKC_CONVERT_SEGMENT_STATE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER, KkcConvertSegmentStateHandlerClass))

typedef struct _KkcConvertSegmentStateHandler KkcConvertSegmentStateHandler;
typedef struct _KkcConvertSegmentStateHandlerClass KkcConvertSegmentStateHandlerClass;
typedef struct _KkcStatePrivate KkcStatePrivate;

#define KKC_TYPE_DECODER (kkc_decoder_get_type ())
#define KKC_DECODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DECODER, KkcDecoder))
#define KKC_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_DECODER, KkcDecoderClass))
#define KKC_IS_DECODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DECODER))
#define KKC_IS_DECODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_DECODER))
#define KKC_DECODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_DECODER, KkcDecoderClass))

typedef struct _KkcDecoder KkcDecoder;
typedef struct _KkcDecoderClass KkcDecoderClass;

#define KKC_TYPE_SEGMENT_LIST (kkc_segment_list_get_type ())
#define KKC_SEGMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SEGMENT_LIST, KkcSegmentList))
#define KKC_SEGMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SEGMENT_LIST, KkcSegmentListClass))
#define KKC_IS_SEGMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SEGMENT_LIST))
#define KKC_IS_SEGMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SEGMENT_LIST))
#define KKC_SEGMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SEGMENT_LIST, KkcSegmentListClass))

typedef struct _KkcSegmentList KkcSegmentList;
typedef struct _KkcSegmentListClass KkcSegmentListClass;

#define KKC_TYPE_CANDIDATE_LIST (kkc_candidate_list_get_type ())
#define KKC_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CANDIDATE_LIST, KkcCandidateList))
#define KKC_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CANDIDATE_LIST, KkcCandidateListClass))
#define KKC_IS_CANDIDATE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CANDIDATE_LIST))
#define KKC_IS_CANDIDATE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CANDIDATE_LIST))
#define KKC_CANDIDATE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CANDIDATE_LIST, KkcCandidateListClass))

typedef struct _KkcCandidateList KkcCandidateList;
typedef struct _KkcCandidateListClass KkcCandidateListClass;

#define KKC_TYPE_ROM_KANA_CONVERTER (kkc_rom_kana_converter_get_type ())
#define KKC_ROM_KANA_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverter))
#define KKC_ROM_KANA_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverterClass))
#define KKC_IS_ROM_KANA_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_CONVERTER))
#define KKC_IS_ROM_KANA_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_CONVERTER))
#define KKC_ROM_KANA_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_CONVERTER, KkcRomKanaConverterClass))

typedef struct _KkcRomKanaConverter KkcRomKanaConverter;
typedef struct _KkcRomKanaConverterClass KkcRomKanaConverterClass;

#define KKC_TYPE_ROM_KANA_CHARACTER_LIST (kkc_rom_kana_character_list_get_type ())
#define KKC_ROM_KANA_CHARACTER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterList))
#define KKC_ROM_KANA_CHARACTER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterListClass))
#define KKC_IS_ROM_KANA_CHARACTER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST))
#define KKC_IS_ROM_KANA_CHARACTER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_ROM_KANA_CHARACTER_LIST))
#define KKC_ROM_KANA_CHARACTER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_ROM_KANA_CHARACTER_LIST, KkcRomKanaCharacterListClass))

typedef struct _KkcRomKanaCharacterList KkcRomKanaCharacterList;
typedef struct _KkcRomKanaCharacterListClass KkcRomKanaCharacterListClass;

#define KKC_TYPE_CANDIDATE (kkc_candidate_get_type ())
#define KKC_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_CANDIDATE, KkcCandidate))
#define KKC_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_CANDIDATE, KkcCandidateClass))
#define KKC_IS_CANDIDATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_CANDIDATE))
#define KKC_IS_CANDIDATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_CANDIDATE))
#define KKC_CANDIDATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_CANDIDATE, KkcCandidateClass))

typedef struct _KkcCandidate KkcCandidate;
typedef struct _KkcCandidateClass KkcCandidateClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define KKC_TYPE_KEY_EVENT_FILTER (kkc_key_event_filter_get_type ())
#define KKC_KEY_EVENT_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_KEY_EVENT_FILTER, KkcKeyEventFilter))
#define KKC_KEY_EVENT_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_KEY_EVENT_FILTER, KkcKeyEventFilterClass))
#define KKC_IS_KEY_EVENT_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_KEY_EVENT_FILTER))
#define KKC_IS_KEY_EVENT_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_KEY_EVENT_FILTER))
#define KKC_KEY_EVENT_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_KEY_EVENT_FILTER, KkcKeyEventFilterClass))

typedef struct _KkcKeyEventFilter KkcKeyEventFilter;
typedef struct _KkcKeyEventFilterClass KkcKeyEventFilterClass;

#define KKC_TYPE_MODIFIER_TYPE (kkc_modifier_type_get_type ())

#define KKC_TYPE_KANA_MODE (kkc_kana_mode_get_type ())

#define KKC_TYPE_INPUT_MODE (kkc_input_mode_get_type ())

#define KKC_TYPE_PUNCTUATION_STYLE (kkc_punctuation_style_get_type ())

#define KKC_TYPE_RULE (kkc_rule_get_type ())
#define KKC_RULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_RULE, KkcRule))
#define KKC_RULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_RULE, KkcRuleClass))
#define KKC_IS_RULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_RULE))
#define KKC_IS_RULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_RULE))
#define KKC_RULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_RULE, KkcRuleClass))

typedef struct _KkcRule KkcRule;
typedef struct _KkcRuleClass KkcRuleClass;
enum  {
	KKC_CONTEXT_REQUEST_SELECTION_TEXT_SIGNAL,
	KKC_CONTEXT_NUM_SIGNALS
};
static guint kkc_context_signals[KKC_CONTEXT_NUM_SIGNALS] = {0};

struct _KkcContext {
	GObject parent_instance;
	KkcContextPrivate * priv;
};

struct _KkcContextClass {
	GObjectClass parent_class;
};

struct _KkcContextPrivate {
	KkcState* state;
	GeeMap* handlers;
};

struct _KkcState {
	GObject parent_instance;
	KkcStatePrivate * priv;
	GType handler_type;
	KkcLanguageModel* model;
	KkcDecoder* decoder;
	KkcSegmentList* segments;
	KkcCandidateList* candidates;
	KkcDictionaryList* dictionaries;
	KkcRomKanaConverter* rom_kana_converter;
	KkcRomKanaCharacterList* input_characters;
	gint input_characters_cursor_pos;
	GString* selection;
	GString* output;
	gboolean quoted;
	KkcKeyEvent* this_command_key;
	KkcKeyEvent* last_command_key;
	gchar* overriding_input;
	GeeIterator* completion_iterator;
};

struct _KkcStateClass {
	GObjectClass parent_class;
};

typedef enum  {
	KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED,
	KKC_KEY_EVENT_FORMAT_ERROR_KEYSYM_NOT_FOUND
} KkcKeyEventFormatError;
#define KKC_KEY_EVENT_FORMAT_ERROR kkc_key_event_format_error_quark ()
typedef enum  {
	KKC_MODIFIER_TYPE_NONE = 0,
	KKC_MODIFIER_TYPE_SHIFT_MASK = 1 << 0,
	KKC_MODIFIER_TYPE_LOCK_MASK = 1 << 1,
	KKC_MODIFIER_TYPE_CONTROL_MASK = 1 << 2,
	KKC_MODIFIER_TYPE_MOD1_MASK = 1 << 3,
	KKC_MODIFIER_TYPE_MOD2_MASK = 1 << 4,
	KKC_MODIFIER_TYPE_MOD3_MASK = 1 << 5,
	KKC_MODIFIER_TYPE_MOD4_MASK = 1 << 6,
	KKC_MODIFIER_TYPE_MOD5_MASK = 1 << 7,
	KKC_MODIFIER_TYPE_LSHIFT_MASK = 1 << 22,
	KKC_MODIFIER_TYPE_RSHIFT_MASK = 1 << 23,
	KKC_MODIFIER_TYPE_SUPER_MASK = 1 << 26,
	KKC_MODIFIER_TYPE_HYPER_MASK = 1 << 27,
	KKC_MODIFIER_TYPE_META_MASK = 1 << 28,
	KKC_MODIFIER_TYPE_RELEASE_MASK = 1 << 30
} KkcModifierType;

typedef enum  {
	KKC_KANA_MODE_HIRAGANA,
	KKC_KANA_MODE_KATAKANA,
	KKC_KANA_MODE_HANKAKU_KATAKANA,
	KKC_KANA_MODE_LATIN,
	KKC_KANA_MODE_WIDE_LATIN
} KkcKanaMode;

typedef enum  {
	KKC_INPUT_MODE_HIRAGANA = KKC_KANA_MODE_HIRAGANA,
	KKC_INPUT_MODE_KATAKANA = KKC_KANA_MODE_KATAKANA,
	KKC_INPUT_MODE_HANKAKU_KATAKANA = KKC_KANA_MODE_HANKAKU_KATAKANA,
	KKC_INPUT_MODE_LATIN = KKC_KANA_MODE_LATIN,
	KKC_INPUT_MODE_WIDE_LATIN = KKC_KANA_MODE_WIDE_LATIN,
	KKC_INPUT_MODE_DIRECT
} KkcInputMode;

typedef enum  {
	KKC_PUNCTUATION_STYLE_JA_JA,
	KKC_PUNCTUATION_STYLE_EN_EN,
	KKC_PUNCTUATION_STYLE_JA_EN,
	KKC_PUNCTUATION_STYLE_EN_JA
} KkcPunctuationStyle;


static gpointer kkc_context_parent_class = NULL;

GType kkc_context_get_type (void) G_GNUC_CONST;
GType kkc_state_get_type (void) G_GNUC_CONST;
GType kkc_state_handler_get_type (void) G_GNUC_CONST;
#define KKC_CONTEXT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_CONTEXT, KkcContextPrivate))
static void kkc_context_disconnect_state_signals (KkcContext* self, KkcState* state);
GType kkc_dictionary_list_get_type (void) G_GNUC_CONST;
KkcDictionaryList* kkc_context_get_dictionaries (KkcContext* self);
void kkc_dictionary_list_clear (KkcDictionaryList* self);
GType kkc_key_event_get_type (void) G_GNUC_CONST;
static void kkc_context_filter_forwarded_cb (KkcContext* self, KkcKeyEvent* key);
static gboolean kkc_context_process_key_event_internal (KkcContext* self, KkcKeyEvent* key);
GType kkc_language_model_get_type (void) G_GNUC_CONST;
KkcContext* kkc_context_new (KkcLanguageModel* model);
KkcContext* kkc_context_construct (GType object_type, KkcLanguageModel* model);
GType kkc_initial_state_handler_get_type (void) G_GNUC_CONST;
KkcInitialStateHandler* kkc_initial_state_handler_new (void);
KkcInitialStateHandler* kkc_initial_state_handler_construct (GType object_type);
GType kkc_convert_sentence_state_handler_get_type (void) G_GNUC_CONST;
KkcConvertSentenceStateHandler* kkc_convert_sentence_state_handler_new (void);
KkcConvertSentenceStateHandler* kkc_convert_sentence_state_handler_construct (GType object_type);
GType kkc_convert_segment_state_handler_get_type (void) G_GNUC_CONST;
KkcConvertSegmentStateHandler* kkc_convert_segment_state_handler_new (void);
KkcConvertSegmentStateHandler* kkc_convert_segment_state_handler_construct (GType object_type);
KkcDictionaryList* kkc_dictionary_list_new (void);
KkcDictionaryList* kkc_dictionary_list_construct (GType object_type);
KkcState* kkc_state_new (KkcLanguageModel* model, KkcDictionaryList* dictionaries);
KkcState* kkc_state_construct (GType object_type, KkcLanguageModel* model, KkcDictionaryList* dictionaries);
static void kkc_context_connect_state_signals (KkcContext* self, KkcState* state);
static void kkc_context_notify_input_mode_cb (KkcContext* self, GObject* s, GParamSpec* p);
static void kkc_context_candidates_selected_cb (KkcContext* self);
static void kkc_context_request_selection_text_cb (KkcContext* self);
static void _kkc_context_notify_input_mode_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _kkc_context_request_selection_text_cb_kkc_state_request_selection_text (KkcState* _sender, gpointer self);
GType kkc_decoder_get_type (void) G_GNUC_CONST;
GType kkc_segment_list_get_type (void) G_GNUC_CONST;
GType kkc_candidate_list_get_type (void) G_GNUC_CONST;
GType kkc_rom_kana_converter_get_type (void) G_GNUC_CONST;
GType kkc_rom_kana_character_list_get_type (void) G_GNUC_CONST;
GType kkc_candidate_get_type (void) G_GNUC_CONST;
static void _kkc_context_candidates_selected_cb_kkc_candidate_list_selected (KkcCandidateList* _sender, KkcCandidate* candidate, gpointer self);
void kkc_context_set_selection_text (KkcContext* self, const gchar* text);
GQuark kkc_key_event_format_error_quark (void);
gboolean kkc_context_process_key_events (KkcContext* self, const gchar* keyseq, GError** error);
KkcKeyEvent* kkc_key_event_new_from_string (const gchar* key, GError** error);
KkcKeyEvent* kkc_key_event_construct_from_string (GType object_type, const gchar* key, GError** error);
gboolean kkc_context_process_key_event (KkcContext* self, KkcKeyEvent* key);
GType kkc_key_event_filter_get_type (void) G_GNUC_CONST;
KkcKeyEventFilter* kkc_context_get_key_event_filter (KkcContext* self);
KkcKeyEvent* kkc_key_event_filter_filter_key_event (KkcKeyEventFilter* self, KkcKeyEvent* key);
gboolean kkc_state_handler_process_key_event (KkcStateHandler* self, KkcState* state, KkcKeyEvent* key);
gboolean kkc_context_process_command_event (KkcContext* self, const gchar* command);
#define KKC_KEYSYMS_VoidSymbol ((guint) 0xffffff)
GType kkc_modifier_type_get_type (void) G_GNUC_CONST;
KkcKeyEvent* kkc_key_event_new (guint keyval, guint keycode, KkcModifierType modifiers);
KkcKeyEvent* kkc_key_event_construct (GType object_type, guint keyval, guint keycode, KkcModifierType modifiers);
gboolean kkc_state_handler_dispatch_command (KkcStateHandler* self, const gchar* command, KkcState* state, KkcKeyEvent* key);
void kkc_context_reset (KkcContext* self);
void kkc_state_reset (KkcState* self);
void kkc_context_clear_output (KkcContext* self);
gboolean kkc_context_has_output (KkcContext* self);
static gchar* kkc_context_retrieve_output (KkcContext* self, gboolean clear);
gchar* kkc_context_peek_output (KkcContext* self);
gchar* kkc_context_poll_output (KkcContext* self);
void kkc_context_set_dictionaries (KkcContext* self, KkcDictionaryList* value);
KkcCandidateList* kkc_context_get_candidates (KkcContext* self);
KkcSegmentList* kkc_context_get_segments (KkcContext* self);
gchar* kkc_context_get_input (KkcContext* self);
gchar* kkc_state_get_input (KkcState* self);
gint kkc_context_get_input_cursor_pos (KkcContext* self);
gint kkc_state_get_input_cursor_pos (KkcState* self);
guint kkc_context_get_input_cursor_width (KkcContext* self);
guint kkc_state_get_input_cursor_width (KkcState* self);
GType kkc_kana_mode_get_type (void) G_GNUC_CONST;
GType kkc_input_mode_get_type (void) G_GNUC_CONST;
KkcInputMode kkc_context_get_input_mode (KkcContext* self);
KkcInputMode kkc_state_get_input_mode (KkcState* self);
void kkc_context_set_input_mode (KkcContext* self, KkcInputMode value);
void kkc_state_set_input_mode (KkcState* self, KkcInputMode value);
GType kkc_punctuation_style_get_type (void) G_GNUC_CONST;
KkcPunctuationStyle kkc_context_get_punctuation_style (KkcContext* self);
KkcPunctuationStyle kkc_state_get_punctuation_style (KkcState* self);
void kkc_context_set_punctuation_style (KkcContext* self, KkcPunctuationStyle value);
void kkc_state_set_punctuation_style (KkcState* self, KkcPunctuationStyle value);
gboolean kkc_context_get_auto_correct (KkcContext* self);
gboolean kkc_state_get_auto_correct (KkcState* self);
void kkc_context_set_auto_correct (KkcContext* self, gboolean value);
void kkc_state_set_auto_correct (KkcState* self, gboolean value);
GType kkc_rule_get_type (void) G_GNUC_CONST;
KkcRule* kkc_context_get_typing_rule (KkcContext* self);
KkcRule* kkc_state_get_typing_rule (KkcState* self);
void kkc_context_set_typing_rule (KkcContext* self, KkcRule* value);
KkcKeyEventFilter* kkc_rule_get_filter (KkcRule* self);
static void _kkc_context_filter_forwarded_cb_kkc_key_event_filter_forwarded (KkcKeyEventFilter* _sender, KkcKeyEvent* key, gpointer self);
void kkc_state_set_typing_rule (KkcState* self, KkcRule* value);
static void kkc_context_finalize (GObject * obj);
static void _vala_kkc_context_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_kkc_context_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void kkc_context_filter_forwarded_cb (KkcContext* self, KkcKeyEvent* key) {
	KkcKeyEvent* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	kkc_context_process_key_event_internal (self, _tmp0_);
}


/**
         * Create a new Context.
         *
         * @param model a language model
         *
         * @return a new Context
         */
KkcContext* kkc_context_construct (GType object_type, KkcLanguageModel* model) {
	KkcContext * self = NULL;
	GeeMap* _tmp0_;
	KkcInitialStateHandler* _tmp1_;
	KkcInitialStateHandler* _tmp2_;
	GeeMap* _tmp3_;
	KkcConvertSentenceStateHandler* _tmp4_;
	KkcConvertSentenceStateHandler* _tmp5_;
	GeeMap* _tmp6_;
	KkcConvertSegmentStateHandler* _tmp7_;
	KkcConvertSegmentStateHandler* _tmp8_;
	KkcLanguageModel* _tmp9_;
	KkcDictionaryList* _tmp10_;
	KkcDictionaryList* _tmp11_;
	KkcState* _tmp12_;
	KkcState* _tmp13_;
	g_return_val_if_fail (model != NULL, NULL);
	self = (KkcContext*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->handlers;
	_tmp1_ = kkc_initial_state_handler_new ();
	_tmp2_ = _tmp1_;
	gee_map_set (_tmp0_, (gpointer) ((gintptr) KKC_TYPE_INITIAL_STATE_HANDLER), (KkcStateHandler*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->handlers;
	_tmp4_ = kkc_convert_sentence_state_handler_new ();
	_tmp5_ = _tmp4_;
	gee_map_set (_tmp3_, (gpointer) ((gintptr) KKC_TYPE_CONVERT_SENTENCE_STATE_HANDLER), (KkcStateHandler*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->handlers;
	_tmp7_ = kkc_convert_segment_state_handler_new ();
	_tmp8_ = _tmp7_;
	gee_map_set (_tmp6_, (gpointer) ((gintptr) KKC_TYPE_CONVERT_SEGMENT_STATE_HANDLER), (KkcStateHandler*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = model;
	_tmp10_ = kkc_dictionary_list_new ();
	_tmp11_ = _tmp10_;
	_tmp12_ = kkc_state_new (_tmp9_, _tmp11_);
	_g_object_unref0 (self->priv->state);
	self->priv->state = _tmp12_;
	_g_object_unref0 (_tmp11_);
	_tmp13_ = self->priv->state;
	kkc_context_connect_state_signals (self, _tmp13_);
	return self;
}


KkcContext* kkc_context_new (KkcLanguageModel* model) {
	return kkc_context_construct (KKC_TYPE_CONTEXT, model);
}


static void kkc_context_notify_input_mode_cb (KkcContext* self, GObject* s, GParamSpec* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_object_notify ((GObject*) self, "input-mode");
}


static void kkc_context_candidates_selected_cb (KkcContext* self) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject*) self, "input");
}


static void kkc_context_request_selection_text_cb (KkcContext* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit (self, kkc_context_signals[KKC_CONTEXT_REQUEST_SELECTION_TEXT_SIGNAL], 0);
}


static void _kkc_context_notify_input_mode_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	kkc_context_notify_input_mode_cb ((KkcContext*) self, _sender, pspec);
}


static void _kkc_context_request_selection_text_cb_kkc_state_request_selection_text (KkcState* _sender, gpointer self) {
	kkc_context_request_selection_text_cb ((KkcContext*) self);
}


static void _kkc_context_candidates_selected_cb_kkc_candidate_list_selected (KkcCandidateList* _sender, KkcCandidate* candidate, gpointer self) {
	kkc_context_candidates_selected_cb ((KkcContext*) self);
}


static void kkc_context_connect_state_signals (KkcContext* self, KkcState* state) {
	KkcState* _tmp0_;
	KkcState* _tmp1_;
	KkcState* _tmp2_;
	KkcCandidateList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	_tmp0_ = state;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::input-mode", (GCallback) _kkc_context_notify_input_mode_cb_g_object_notify, self, 0);
	_tmp1_ = state;
	g_signal_connect_object (_tmp1_, "request-selection-text", (GCallback) _kkc_context_request_selection_text_cb_kkc_state_request_selection_text, self, 0);
	_tmp2_ = state;
	_tmp3_ = _tmp2_->candidates;
	g_signal_connect_object (_tmp3_, "selected", (GCallback) _kkc_context_candidates_selected_cb_kkc_candidate_list_selected, self, 0);
}


static void kkc_context_disconnect_state_signals (KkcContext* self, KkcState* state) {
	KkcState* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	KkcState* _tmp3_;
	guint _tmp4_;
	KkcState* _tmp5_;
	KkcCandidateList* _tmp6_;
	guint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (state != NULL);
	_tmp0_ = state;
	g_signal_parse_name ("notify::input-mode", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _kkc_context_notify_input_mode_cb_g_object_notify, self);
	_tmp3_ = state;
	g_signal_parse_name ("request-selection-text", KKC_TYPE_STATE, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _kkc_context_request_selection_text_cb_kkc_state_request_selection_text, self);
	_tmp5_ = state;
	_tmp6_ = _tmp5_->candidates;
	g_signal_parse_name ("selected", KKC_TYPE_CANDIDATE_LIST, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _kkc_context_candidates_selected_cb_kkc_candidate_list_selected, self);
}


/**
         * Set the current selection text.
         *
         * @param text selection text
         */
void kkc_context_set_selection_text (KkcContext* self, const gchar* text) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = text;
	if (_tmp0_ == NULL) {
		KkcState* _tmp1_;
		GString* _tmp2_;
		_tmp1_ = self->priv->state;
		_tmp2_ = _tmp1_->selection;
		g_string_erase (_tmp2_, (gssize) 0, (gssize) -1);
	} else {
		KkcState* _tmp3_;
		GString* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = self->priv->state;
		_tmp4_ = _tmp3_->selection;
		_tmp5_ = text;
		g_string_assign (_tmp4_, _tmp5_);
	}
}


/**
         * Pass key events (separated by spaces) to the context.
         *
         * This function is rarely used in programs but in unit tests.
         *
         * @param keyseq a string representing key events, separated by " "
         *
         * @return `true` if any of key events are handled, `false` otherwise
         */
static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gboolean kkc_context_process_key_events (KkcContext* self, const gchar* keyseq, GError** error) {
	gboolean result = FALSE;
	GeeList* keys = NULL;
	GeeArrayList* _tmp0_;
	GString* builder = NULL;
	GString* _tmp1_;
	gboolean complex = FALSE;
	gboolean escaped = FALSE;
	gint index = 0;
	gunichar uc = 0U;
	gboolean _tmp36_;
	GString* _tmp40_;
	gssize _tmp41_;
	gboolean retval = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (keyseq != NULL, FALSE);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	keys = (GeeList*) _tmp0_;
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	complex = FALSE;
	escaped = FALSE;
	index = 0;
	while (TRUE) {
		const gchar* _tmp2_;
		gunichar _tmp3_ = 0U;
		gboolean _tmp4_;
		gboolean _tmp5_;
		gunichar _tmp8_;
		_tmp2_ = keyseq;
		_tmp4_ = string_get_next_char (_tmp2_, &index, &_tmp3_);
		uc = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = escaped;
		if (_tmp5_) {
			GString* _tmp6_;
			gunichar _tmp7_;
			_tmp6_ = builder;
			_tmp7_ = uc;
			g_string_append_unichar (_tmp6_, _tmp7_);
			escaped = FALSE;
			continue;
		}
		_tmp8_ = uc;
		switch (_tmp8_) {
			case '\\':
			{
				escaped = TRUE;
				break;
			}
			case '(':
			{
				gboolean _tmp9_;
				GString* _tmp13_;
				gunichar _tmp14_;
				_tmp9_ = complex;
				if (_tmp9_) {
					GError* _tmp10_;
					_tmp10_ = g_error_new_literal (KKC_KEY_EVENT_FORMAT_ERROR, KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "bare '(' is not allowed in complex keyseq");
					_inner_error_ = _tmp10_;
					if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
						gboolean _tmp11_ = FALSE;
						g_propagate_error (error, _inner_error_);
						_g_string_free0 (builder);
						_g_object_unref0 (keys);
						return _tmp11_;
					} else {
						gboolean _tmp12_ = FALSE;
						_g_string_free0 (builder);
						_g_object_unref0 (keys);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return _tmp12_;
					}
				}
				complex = TRUE;
				_tmp13_ = builder;
				_tmp14_ = uc;
				g_string_append_unichar (_tmp13_, _tmp14_);
				break;
			}
			case ')':
			{
				gboolean _tmp15_;
				GString* _tmp19_;
				gunichar _tmp20_;
				GeeList* _tmp21_;
				GString* _tmp22_;
				const gchar* _tmp23_;
				GString* _tmp24_;
				_tmp15_ = complex;
				if (!_tmp15_) {
					GError* _tmp16_;
					_tmp16_ = g_error_new_literal (KKC_KEY_EVENT_FORMAT_ERROR, KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "bare ')' is not allowed in simple keyseq");
					_inner_error_ = _tmp16_;
					if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
						gboolean _tmp17_ = FALSE;
						g_propagate_error (error, _inner_error_);
						_g_string_free0 (builder);
						_g_object_unref0 (keys);
						return _tmp17_;
					} else {
						gboolean _tmp18_ = FALSE;
						_g_string_free0 (builder);
						_g_object_unref0 (keys);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return _tmp18_;
					}
				}
				complex = FALSE;
				_tmp19_ = builder;
				_tmp20_ = uc;
				g_string_append_unichar (_tmp19_, _tmp20_);
				_tmp21_ = keys;
				_tmp22_ = builder;
				_tmp23_ = _tmp22_->str;
				gee_collection_add ((GeeCollection*) _tmp21_, _tmp23_);
				_tmp24_ = builder;
				g_string_erase (_tmp24_, (gssize) 0, (gssize) -1);
				break;
			}
			case ' ':
			{
				gboolean _tmp25_;
				_tmp25_ = complex;
				if (_tmp25_) {
					GString* _tmp26_;
					gunichar _tmp27_;
					_tmp26_ = builder;
					_tmp27_ = uc;
					g_string_append_unichar (_tmp26_, _tmp27_);
				} else {
					GString* _tmp28_;
					gssize _tmp29_;
					_tmp28_ = builder;
					_tmp29_ = _tmp28_->len;
					if (_tmp29_ > ((gssize) 0)) {
						GeeList* _tmp30_;
						GString* _tmp31_;
						const gchar* _tmp32_;
						GString* _tmp33_;
						_tmp30_ = keys;
						_tmp31_ = builder;
						_tmp32_ = _tmp31_->str;
						gee_collection_add ((GeeCollection*) _tmp30_, _tmp32_);
						_tmp33_ = builder;
						g_string_erase (_tmp33_, (gssize) 0, (gssize) -1);
					}
				}
				break;
			}
			default:
			{
				GString* _tmp34_;
				gunichar _tmp35_;
				_tmp34_ = builder;
				_tmp35_ = uc;
				g_string_append_unichar (_tmp34_, _tmp35_);
				break;
			}
		}
	}
	_tmp36_ = complex;
	if (_tmp36_) {
		GError* _tmp37_;
		_tmp37_ = g_error_new_literal (KKC_KEY_EVENT_FORMAT_ERROR, KKC_KEY_EVENT_FORMAT_ERROR_PARSE_FAILED, "premature end of key events");
		_inner_error_ = _tmp37_;
		if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
			gboolean _tmp38_ = FALSE;
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (builder);
			_g_object_unref0 (keys);
			return _tmp38_;
		} else {
			gboolean _tmp39_ = FALSE;
			_g_string_free0 (builder);
			_g_object_unref0 (keys);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp39_;
		}
	}
	_tmp40_ = builder;
	_tmp41_ = _tmp40_->len;
	if (_tmp41_ > ((gssize) 0)) {
		GeeList* _tmp42_;
		GString* _tmp43_;
		const gchar* _tmp44_;
		_tmp42_ = keys;
		_tmp43_ = builder;
		_tmp44_ = _tmp43_->str;
		gee_collection_add ((GeeCollection*) _tmp42_, _tmp44_);
	}
	retval = FALSE;
	{
		GeeList* _key_list = NULL;
		GeeList* _tmp45_;
		GeeList* _tmp46_;
		gint _key_size = 0;
		GeeList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _key_index = 0;
		_tmp45_ = keys;
		_tmp46_ = _g_object_ref0 (_tmp45_);
		_key_list = _tmp46_;
		_tmp47_ = _key_list;
		_tmp48_ = gee_collection_get_size ((GeeCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_key_size = _tmp49_;
		_key_index = -1;
		while (TRUE) {
			gint _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			gchar* key = NULL;
			GeeList* _tmp53_;
			gint _tmp54_;
			gpointer _tmp55_;
			const gchar* _tmp56_;
			KkcKeyEvent* ev = NULL;
			const gchar* _tmp64_;
			KkcKeyEvent* _tmp65_;
			gboolean _tmp68_ = FALSE;
			KkcKeyEvent* _tmp69_;
			gboolean _tmp70_;
			_tmp50_ = _key_index;
			_key_index = _tmp50_ + 1;
			_tmp51_ = _key_index;
			_tmp52_ = _key_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _key_list;
			_tmp54_ = _key_index;
			_tmp55_ = gee_list_get (_tmp53_, _tmp54_);
			key = (gchar*) _tmp55_;
			_tmp56_ = key;
			if (g_strcmp0 (_tmp56_, "SPC") == 0) {
				gchar* _tmp57_;
				_tmp57_ = g_strdup ("space");
				_g_free0 (key);
				key = _tmp57_;
			} else {
				const gchar* _tmp58_;
				_tmp58_ = key;
				if (g_strcmp0 (_tmp58_, "TAB") == 0) {
					gchar* _tmp59_;
					_tmp59_ = g_strdup ("Tab");
					_g_free0 (key);
					key = _tmp59_;
				} else {
					const gchar* _tmp60_;
					_tmp60_ = key;
					if (g_strcmp0 (_tmp60_, "RET") == 0) {
						gchar* _tmp61_;
						_tmp61_ = g_strdup ("Return");
						_g_free0 (key);
						key = _tmp61_;
					} else {
						const gchar* _tmp62_;
						_tmp62_ = key;
						if (g_strcmp0 (_tmp62_, "DEL") == 0) {
							gchar* _tmp63_;
							_tmp63_ = g_strdup ("BackSpace");
							_g_free0 (key);
							key = _tmp63_;
						}
					}
				}
			}
			_tmp64_ = key;
			_tmp65_ = kkc_key_event_new_from_string (_tmp64_, &_inner_error_);
			ev = _tmp65_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
					gboolean _tmp66_ = FALSE;
					g_propagate_error (error, _inner_error_);
					_g_free0 (key);
					_g_object_unref0 (_key_list);
					_g_string_free0 (builder);
					_g_object_unref0 (keys);
					return _tmp66_;
				} else {
					gboolean _tmp67_ = FALSE;
					_g_free0 (key);
					_g_object_unref0 (_key_list);
					_g_string_free0 (builder);
					_g_object_unref0 (keys);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp67_;
				}
			}
			_tmp69_ = ev;
			_tmp70_ = kkc_context_process_key_event (self, _tmp69_);
			if (_tmp70_) {
				gboolean _tmp71_;
				_tmp71_ = retval;
				_tmp68_ = !_tmp71_;
			} else {
				_tmp68_ = FALSE;
			}
			if (_tmp68_) {
				retval = TRUE;
			}
			_g_object_unref0 (ev);
			_g_free0 (key);
		}
		_g_object_unref0 (_key_list);
	}
	result = retval;
	_g_string_free0 (builder);
	_g_object_unref0 (keys);
	return result;
}


/**
         * Pass one key event to the context.
         *
         * @param key a key event
         *
         * @return `true` if the key event is handled, `false` otherwise
         */
gboolean kkc_context_process_key_event (KkcContext* self, KkcKeyEvent* key) {
	gboolean result = FALSE;
	KkcKeyEvent* _key = NULL;
	KkcKeyEventFilter* _tmp0_;
	KkcKeyEventFilter* _tmp1_;
	KkcKeyEventFilter* _tmp2_;
	KkcKeyEvent* _tmp3_;
	KkcKeyEvent* _tmp4_;
	KkcKeyEvent* _tmp5_;
	KkcKeyEvent* _tmp6_;
	KkcKeyEvent* _tmp7_;
	gboolean _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	_tmp0_ = kkc_context_get_key_event_filter (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = key;
	_tmp4_ = kkc_key_event_filter_filter_key_event (_tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	_key = _tmp5_;
	_tmp6_ = _key;
	if (_tmp6_ == NULL) {
		result = FALSE;
		_g_object_unref0 (_key);
		return result;
	}
	_tmp7_ = _key;
	_tmp8_ = kkc_context_process_key_event_internal (self, _tmp7_);
	result = _tmp8_;
	_g_object_unref0 (_key);
	return result;
}


static gboolean kkc_context_process_key_event_internal (KkcContext* self, KkcKeyEvent* key) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	while (TRUE) {
		GType handler_type = 0UL;
		KkcState* _tmp0_;
		GType _tmp1_;
		KkcStateHandler* handler = NULL;
		GeeMap* _tmp2_;
		GType _tmp3_;
		gpointer _tmp4_;
		KkcState* _tmp5_;
		KkcKeyEvent* _tmp6_;
		KkcKeyEvent* _tmp7_;
		KkcStateHandler* _tmp8_;
		KkcState* _tmp9_;
		KkcKeyEvent* _tmp10_;
		gboolean _tmp11_;
		GType _tmp15_;
		KkcState* _tmp16_;
		GType _tmp17_;
		_tmp0_ = self->priv->state;
		_tmp1_ = _tmp0_->handler_type;
		handler_type = _tmp1_;
		_tmp2_ = self->priv->handlers;
		_tmp3_ = handler_type;
		_tmp4_ = gee_map_get (_tmp2_, (gpointer) ((gintptr) _tmp3_));
		handler = (KkcStateHandler*) _tmp4_;
		_tmp5_ = self->priv->state;
		_tmp6_ = key;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (_tmp5_->this_command_key);
		_tmp5_->this_command_key = _tmp7_;
		_tmp8_ = handler;
		_tmp9_ = self->priv->state;
		_tmp10_ = key;
		_tmp11_ = kkc_state_handler_process_key_event (_tmp8_, _tmp9_, _tmp10_);
		if (_tmp11_) {
			KkcState* _tmp12_;
			KkcKeyEvent* _tmp13_;
			KkcKeyEvent* _tmp14_;
			g_object_notify ((GObject*) self, "input");
			_tmp12_ = self->priv->state;
			_tmp13_ = key;
			_tmp14_ = _g_object_ref0 (_tmp13_);
			_g_object_unref0 (_tmp12_->last_command_key);
			_tmp12_->last_command_key = _tmp14_;
			result = TRUE;
			_g_object_unref0 (handler);
			return result;
		}
		_tmp15_ = handler_type;
		_tmp16_ = self->priv->state;
		_tmp17_ = _tmp16_->handler_type;
		if (_tmp15_ == _tmp17_) {
			result = FALSE;
			_g_object_unref0 (handler);
			return result;
		}
		_g_object_unref0 (handler);
	}
}


/**
         * Process an explicit command in the context.
         *
         * This function is rarely used in programs but called from
         * D-Bus service.
         *
         * @param command a command
         *
         * @return `true` if the command is handled, `false` otherwise
         */
gboolean kkc_context_process_command_event (KkcContext* self, const gchar* command) {
	gboolean result = FALSE;
	KkcKeyEvent* key = NULL;
	KkcKeyEvent* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (command != NULL, FALSE);
	_tmp0_ = kkc_key_event_new (KKC_KEYSYMS_VoidSymbol, (guint) 0, 0);
	key = _tmp0_;
	while (TRUE) {
		GType handler_type = 0UL;
		KkcState* _tmp1_;
		GType _tmp2_;
		KkcStateHandler* handler = NULL;
		GeeMap* _tmp3_;
		GType _tmp4_;
		gpointer _tmp5_;
		KkcState* _tmp6_;
		KkcKeyEvent* _tmp7_;
		KkcKeyEvent* _tmp8_;
		KkcStateHandler* _tmp9_;
		const gchar* _tmp10_;
		KkcState* _tmp11_;
		KkcKeyEvent* _tmp12_;
		gboolean _tmp13_;
		GType _tmp14_;
		KkcState* _tmp15_;
		GType _tmp16_;
		_tmp1_ = self->priv->state;
		_tmp2_ = _tmp1_->handler_type;
		handler_type = _tmp2_;
		_tmp3_ = self->priv->handlers;
		_tmp4_ = handler_type;
		_tmp5_ = gee_map_get (_tmp3_, (gpointer) ((gintptr) _tmp4_));
		handler = (KkcStateHandler*) _tmp5_;
		_tmp6_ = self->priv->state;
		_tmp7_ = key;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (_tmp6_->this_command_key);
		_tmp6_->this_command_key = _tmp8_;
		_tmp9_ = handler;
		_tmp10_ = command;
		_tmp11_ = self->priv->state;
		_tmp12_ = key;
		_tmp13_ = kkc_state_handler_dispatch_command (_tmp9_, _tmp10_, _tmp11_, _tmp12_);
		if (_tmp13_) {
			g_object_notify ((GObject*) self, "input");
			result = TRUE;
			_g_object_unref0 (handler);
			_g_object_unref0 (key);
			return result;
		}
		_tmp14_ = handler_type;
		_tmp15_ = self->priv->state;
		_tmp16_ = _tmp15_->handler_type;
		if (_tmp14_ == _tmp16_) {
			result = FALSE;
			_g_object_unref0 (handler);
			_g_object_unref0 (key);
			return result;
		}
		_g_object_unref0 (handler);
	}
	_g_object_unref0 (key);
}


/**
         * Reset the context.
         */
void kkc_context_reset (KkcContext* self) {
	KkcState* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	kkc_state_reset (_tmp0_);
	kkc_context_clear_output (self);
}


/**
         * Check if there is pending output
         *
         * @return `true` if there is output, `false` otherwise
         */
gboolean kkc_context_has_output (KkcContext* self) {
	gboolean result = FALSE;
	KkcState* _tmp0_;
	GString* _tmp1_;
	gssize _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->output;
	_tmp2_ = _tmp1_->len;
	result = _tmp2_ > ((gssize) 0);
	return result;
}


static gchar* kkc_context_retrieve_output (KkcContext* self, gboolean clear) {
	gchar* result = NULL;
	gchar* output = NULL;
	gchar* _tmp0_;
	KkcState* _tmp1_;
	GString* _tmp2_;
	gssize _tmp3_;
	gboolean _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	output = _tmp0_;
	_tmp1_ = self->priv->state;
	_tmp2_ = _tmp1_->output;
	_tmp3_ = _tmp2_->len;
	if (_tmp3_ > ((gssize) 0)) {
		KkcState* _tmp4_;
		GString* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = self->priv->state;
		_tmp5_ = _tmp4_->output;
		_tmp6_ = _tmp5_->str;
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (output);
		output = _tmp7_;
	}
	_tmp8_ = clear;
	if (_tmp8_) {
		KkcState* _tmp9_;
		GString* _tmp10_;
		_tmp9_ = self->priv->state;
		_tmp10_ = _tmp9_->output;
		g_string_erase (_tmp10_, (gssize) 0, (gssize) -1);
	}
	result = output;
	return result;
}


/**
         * Peek (retrieve, but not remove) the current output string.
         *
         * @return an output string
         */
gchar* kkc_context_peek_output (KkcContext* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = kkc_context_retrieve_output (self, FALSE);
	result = _tmp0_;
	return result;
}


/**
         * Poll (retrieve and remove) the current output string.
         *
         * @return an output string
         */
gchar* kkc_context_poll_output (KkcContext* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = kkc_context_retrieve_output (self, TRUE);
	result = _tmp0_;
	return result;
}


/**
         * Clear the output buffer.
         */
void kkc_context_clear_output (KkcContext* self) {
	KkcState* _tmp0_;
	GString* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->output;
	g_string_erase (_tmp1_, (gssize) 0, (gssize) -1);
}


KkcDictionaryList* kkc_context_get_dictionaries (KkcContext* self) {
	KkcDictionaryList* result;
	KkcState* _tmp0_;
	KkcDictionaryList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->dictionaries;
	result = _tmp1_;
	return result;
}


void kkc_context_set_dictionaries (KkcContext* self, KkcDictionaryList* value) {
	KkcState* _tmp0_;
	KkcDictionaryList* _tmp1_;
	KkcDictionaryList* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = value;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_tmp0_->dictionaries);
	_tmp0_->dictionaries = _tmp2_;
	g_object_notify_by_pspec ((GObject *) self, kkc_context_properties[KKC_CONTEXT_DICTIONARIES_PROPERTY]);
}


KkcCandidateList* kkc_context_get_candidates (KkcContext* self) {
	KkcCandidateList* result;
	KkcState* _tmp0_;
	KkcCandidateList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->candidates;
	result = _tmp1_;
	return result;
}


KkcSegmentList* kkc_context_get_segments (KkcContext* self) {
	KkcSegmentList* result;
	KkcState* _tmp0_;
	KkcSegmentList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = _tmp0_->segments;
	result = _tmp1_;
	return result;
}


gchar* kkc_context_get_input (KkcContext* self) {
	gchar* result;
	KkcState* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_input (_tmp0_);
	result = _tmp1_;
	return result;
}


gint kkc_context_get_input_cursor_pos (KkcContext* self) {
	gint result;
	KkcState* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_input_cursor_pos (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


guint kkc_context_get_input_cursor_width (KkcContext* self) {
	guint result;
	KkcState* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_input_cursor_width (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


KkcInputMode kkc_context_get_input_mode (KkcContext* self) {
	KkcInputMode result;
	KkcState* _tmp0_;
	KkcInputMode _tmp1_;
	KkcInputMode _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_input_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void kkc_context_set_input_mode (KkcContext* self, KkcInputMode value) {
	KkcState* _tmp0_;
	KkcInputMode _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = value;
	kkc_state_set_input_mode (_tmp0_, _tmp1_);
	g_object_notify_by_pspec ((GObject *) self, kkc_context_properties[KKC_CONTEXT_INPUT_MODE_PROPERTY]);
}


KkcPunctuationStyle kkc_context_get_punctuation_style (KkcContext* self) {
	KkcPunctuationStyle result;
	KkcState* _tmp0_;
	KkcPunctuationStyle _tmp1_;
	KkcPunctuationStyle _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_punctuation_style (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void kkc_context_set_punctuation_style (KkcContext* self, KkcPunctuationStyle value) {
	KkcState* _tmp0_;
	KkcPunctuationStyle _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = value;
	kkc_state_set_punctuation_style (_tmp0_, _tmp1_);
	g_object_notify_by_pspec ((GObject *) self, kkc_context_properties[KKC_CONTEXT_PUNCTUATION_STYLE_PROPERTY]);
}


gboolean kkc_context_get_auto_correct (KkcContext* self) {
	gboolean result;
	KkcState* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_auto_correct (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void kkc_context_set_auto_correct (KkcContext* self, gboolean value) {
	KkcState* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = value;
	kkc_state_set_auto_correct (_tmp0_, _tmp1_);
	g_object_notify_by_pspec ((GObject *) self, kkc_context_properties[KKC_CONTEXT_AUTO_CORRECT_PROPERTY]);
}


KkcRule* kkc_context_get_typing_rule (KkcContext* self) {
	KkcRule* result;
	KkcState* _tmp0_;
	KkcRule* _tmp1_;
	KkcRule* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_typing_rule (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void _kkc_context_filter_forwarded_cb_kkc_key_event_filter_forwarded (KkcKeyEventFilter* _sender, KkcKeyEvent* key, gpointer self) {
	kkc_context_filter_forwarded_cb ((KkcContext*) self, key);
}


void kkc_context_set_typing_rule (KkcContext* self, KkcRule* value) {
	KkcState* _tmp0_;
	KkcRule* _tmp1_;
	KkcRule* _tmp2_;
	KkcKeyEventFilter* _tmp3_;
	KkcKeyEventFilter* _tmp4_;
	guint _tmp5_;
	KkcState* _tmp6_;
	KkcRule* _tmp7_;
	KkcState* _tmp8_;
	KkcRule* _tmp9_;
	KkcRule* _tmp10_;
	KkcKeyEventFilter* _tmp11_;
	KkcKeyEventFilter* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_typing_rule (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = kkc_rule_get_filter (_tmp2_);
	_tmp4_ = _tmp3_;
	g_signal_parse_name ("forwarded", KKC_TYPE_KEY_EVENT_FILTER, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _kkc_context_filter_forwarded_cb_kkc_key_event_filter_forwarded, self);
	_tmp6_ = self->priv->state;
	_tmp7_ = value;
	kkc_state_set_typing_rule (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->state;
	_tmp9_ = kkc_state_get_typing_rule (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = kkc_rule_get_filter (_tmp10_);
	_tmp12_ = _tmp11_;
	g_signal_connect_object (_tmp12_, "forwarded", (GCallback) _kkc_context_filter_forwarded_cb_kkc_key_event_filter_forwarded, self, 0);
	g_object_notify_by_pspec ((GObject *) self, kkc_context_properties[KKC_CONTEXT_TYPING_RULE_PROPERTY]);
}


KkcKeyEventFilter* kkc_context_get_key_event_filter (KkcContext* self) {
	KkcKeyEventFilter* result;
	KkcState* _tmp0_;
	KkcRule* _tmp1_;
	KkcRule* _tmp2_;
	KkcKeyEventFilter* _tmp3_;
	KkcKeyEventFilter* _tmp4_;
	KkcKeyEventFilter* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->state;
	_tmp1_ = kkc_state_get_typing_rule (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = kkc_rule_get_filter (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	result = _tmp5_;
	return result;
}


static void kkc_context_class_init (KkcContextClass * klass) {
	kkc_context_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcContextPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_context_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_kkc_context_set_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_context_finalize;
	/**
	         * Dictionaries.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_DICTIONARIES_PROPERTY, kkc_context_properties[KKC_CONTEXT_DICTIONARIES_PROPERTY] = g_param_spec_object ("dictionaries", "dictionaries", "dictionaries", KKC_TYPE_DICTIONARY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Current candidates.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_CANDIDATES_PROPERTY, kkc_context_properties[KKC_CONTEXT_CANDIDATES_PROPERTY] = g_param_spec_object ("candidates", "candidates", "candidates", KKC_TYPE_CANDIDATE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Current segments.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_SEGMENTS_PROPERTY, kkc_context_properties[KKC_CONTEXT_SEGMENTS_PROPERTY] = g_param_spec_object ("segments", "segments", "segments", KKC_TYPE_SEGMENT_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Current input string.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_INPUT_PROPERTY, kkc_context_properties[KKC_CONTEXT_INPUT_PROPERTY] = g_param_spec_string ("input", "input", "input", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Current cursor position in input string.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_INPUT_CURSOR_POS_PROPERTY, kkc_context_properties[KKC_CONTEXT_INPUT_CURSOR_POS_PROPERTY] = g_param_spec_int ("input-cursor-pos", "input-cursor-pos", "input-cursor-pos", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Current cursor width in input string.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_INPUT_CURSOR_WIDTH_PROPERTY, kkc_context_properties[KKC_CONTEXT_INPUT_CURSOR_WIDTH_PROPERTY] = g_param_spec_uint ("input-cursor-width", "input-cursor-width", "input-cursor-width", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Current input mode.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_INPUT_MODE_PROPERTY, kkc_context_properties[KKC_CONTEXT_INPUT_MODE_PROPERTY] = g_param_spec_enum ("input-mode", "input-mode", "input-mode", KKC_TYPE_INPUT_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Punctuation style used in romaji-to-kana conversion.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_PUNCTUATION_STYLE_PROPERTY, kkc_context_properties[KKC_CONTEXT_PUNCTUATION_STYLE_PROPERTY] = g_param_spec_enum ("punctuation-style", "punctuation-style", "punctuation-style", KKC_TYPE_PUNCTUATION_STYLE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Flag to indicate if romaji-to-kana conversion is auto-corrected.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_AUTO_CORRECT_PROPERTY, kkc_context_properties[KKC_CONTEXT_AUTO_CORRECT_PROPERTY] = g_param_spec_boolean ("auto-correct", "auto-correct", "auto-correct", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The name of typing rule.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_TYPING_RULE_PROPERTY, kkc_context_properties[KKC_CONTEXT_TYPING_RULE_PROPERTY] = g_param_spec_object ("typing-rule", "typing-rule", "typing-rule", KKC_TYPE_RULE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Filter which runs before process_key_event.
	         *
	         * This is particularly useful for NICOLA.
	         * @see NicolaKeyEventFilter
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_CONTEXT_KEY_EVENT_FILTER_PROPERTY, kkc_context_properties[KKC_CONTEXT_KEY_EVENT_FILTER_PROPERTY] = g_param_spec_object ("key-event-filter", "key-event-filter", "key-event-filter", KKC_TYPE_KEY_EVENT_FILTER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	kkc_context_signals[KKC_CONTEXT_REQUEST_SELECTION_TEXT_SIGNAL] = g_signal_new ("request-selection-text", KKC_TYPE_CONTEXT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void kkc_context_instance_init (KkcContext * self) {
	GeeHashMap* _tmp0_;
	self->priv = KKC_CONTEXT_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_GTYPE, NULL, NULL, KKC_TYPE_STATE_HANDLER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->handlers = (GeeMap*) _tmp0_;
}


static void kkc_context_finalize (GObject * obj) {
	KkcContext * self;
	KkcState* _tmp0_;
	KkcDictionaryList* _tmp1_;
	KkcDictionaryList* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_CONTEXT, KkcContext);
	_tmp0_ = self->priv->state;
	kkc_context_disconnect_state_signals (self, _tmp0_);
	_tmp1_ = kkc_context_get_dictionaries (self);
	_tmp2_ = _tmp1_;
	kkc_dictionary_list_clear (_tmp2_);
	_g_object_unref0 (self->priv->state);
	_g_object_unref0 (self->priv->handlers);
	G_OBJECT_CLASS (kkc_context_parent_class)->finalize (obj);
}


/**
     * Main entry point of libkkc.
     */
GType kkc_context_get_type (void) {
	static volatile gsize kkc_context_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_context_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcContext), 0, (GInstanceInitFunc) kkc_context_instance_init, NULL };
		GType kkc_context_type_id;
		kkc_context_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcContext", &g_define_type_info, 0);
		g_once_init_leave (&kkc_context_type_id__volatile, kkc_context_type_id);
	}
	return kkc_context_type_id__volatile;
}


static void _vala_kkc_context_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_CONTEXT, KkcContext);
	switch (property_id) {
		case KKC_CONTEXT_DICTIONARIES_PROPERTY:
		g_value_set_object (value, kkc_context_get_dictionaries (self));
		break;
		case KKC_CONTEXT_CANDIDATES_PROPERTY:
		g_value_set_object (value, kkc_context_get_candidates (self));
		break;
		case KKC_CONTEXT_SEGMENTS_PROPERTY:
		g_value_set_object (value, kkc_context_get_segments (self));
		break;
		case KKC_CONTEXT_INPUT_PROPERTY:
		g_value_take_string (value, kkc_context_get_input (self));
		break;
		case KKC_CONTEXT_INPUT_CURSOR_POS_PROPERTY:
		g_value_set_int (value, kkc_context_get_input_cursor_pos (self));
		break;
		case KKC_CONTEXT_INPUT_CURSOR_WIDTH_PROPERTY:
		g_value_set_uint (value, kkc_context_get_input_cursor_width (self));
		break;
		case KKC_CONTEXT_INPUT_MODE_PROPERTY:
		g_value_set_enum (value, kkc_context_get_input_mode (self));
		break;
		case KKC_CONTEXT_PUNCTUATION_STYLE_PROPERTY:
		g_value_set_enum (value, kkc_context_get_punctuation_style (self));
		break;
		case KKC_CONTEXT_AUTO_CORRECT_PROPERTY:
		g_value_set_boolean (value, kkc_context_get_auto_correct (self));
		break;
		case KKC_CONTEXT_TYPING_RULE_PROPERTY:
		g_value_set_object (value, kkc_context_get_typing_rule (self));
		break;
		case KKC_CONTEXT_KEY_EVENT_FILTER_PROPERTY:
		g_value_take_object (value, kkc_context_get_key_event_filter (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_kkc_context_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	KkcContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_CONTEXT, KkcContext);
	switch (property_id) {
		case KKC_CONTEXT_DICTIONARIES_PROPERTY:
		kkc_context_set_dictionaries (self, g_value_get_object (value));
		break;
		case KKC_CONTEXT_INPUT_MODE_PROPERTY:
		kkc_context_set_input_mode (self, g_value_get_enum (value));
		break;
		case KKC_CONTEXT_PUNCTUATION_STYLE_PROPERTY:
		kkc_context_set_punctuation_style (self, g_value_get_enum (value));
		break;
		case KKC_CONTEXT_AUTO_CORRECT_PROPERTY:
		kkc_context_set_auto_correct (self, g_value_get_boolean (value));
		break;
		case KKC_CONTEXT_TYPING_RULE_PROPERTY:
		kkc_context_set_typing_rule (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



