; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple riscv32-unknown-elf -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV32
; RUN: llc -mtriple riscv32-unknown-elf -mattr=+f -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV32-F
; RUN: llc -mtriple riscv32-unknown-elf -mattr=+f,+d -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV32-FD
;
; RUN: llc -mtriple riscv32-unknown-elf -mattr=+f -target-abi ilp32 -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV32-F-ILP3
; RUN: llc -mtriple riscv32-unknown-elf -mattr=+f,+d -target-abi ilp32f -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV32-FD-ILP32F
; RUN: llc -mtriple riscv32-unknown-elf -mattr=+f,+d -target-abi ilp32 -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV32-FD-ILP32

; RUN: llc -mtriple riscv32-unknown-elf -mattr=+i -target-abi ilp32e -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefixes=CHECK,CHECK-RV32I-ILP32E
; RUN: llc -mtriple riscv32-unknown-elf -mattr=+e -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefixes=CHECK,CHECK-RV32E
; RUN: llc -mtriple riscv32-unknown-elf -mattr=+e,+f -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefixes=CHECK,CHECK-RV32E-F
;
; RUN: llc -mtriple riscv64-unknown-elf -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV64
; RUN: llc -mtriple riscv64-unknown-elf -mattr=+f -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV64-F
; RUN: llc -mtriple riscv64-unknown-elf -mattr=+f,+d -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV64-FD

; RUN: llc -mtriple riscv64-unknown-elf -mattr=+f -target-abi=lp64 -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV64-F-LP64
; RUN: llc -mtriple riscv64-unknown-elf -mattr=+f,+d -target-abi=lp64f -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV64-FD-LP64F
; RUN: llc -mtriple riscv64-unknown-elf -mattr=+f,+d -target-abi=lp64 -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefix CHECK -check-prefix CHECK-RV64-FD-LP64
;
; RUN: llc -mtriple riscv64-unknown-elf -mattr=+i -target-abi lp64e -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefixes=CHECK,CHECK-RV64I-LP64E
; RUN: llc -mtriple riscv64-unknown-elf -mattr=+e -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefixes=CHECK,CHECK-RV64E
; RUN: llc -mtriple riscv64-unknown-elf -mattr=+e,+f -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefixes=CHECK,CHECK-RV64E-F
; RUN: llc -mtriple riscv64-unknown-elf -mattr=+e,+f,+d -o - %s \
; RUN: 2>&1 | FileCheck %s -check-prefixes=CHECK,CHECK-RV64E-FD

;
; Checking for special return instructions (sret, mret).
;
define void @foo_supervisor() #0 {
; CHECK-LABEL: foo_supervisor:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sret
  ret void
}

define void @foo_machine() #1 {
; CHECK-LABEL: foo_machine:
; CHECK:       # %bb.0:
; CHECK-NEXT:    mret
  ret void
}

;
; Checking all Caller saved registers (arguments and temps)
; and FP registers are all saved when the handler calls another function.
;
; extern int otherfoo();
;
; __attribute__((interrupt)) void foo_with_call() {
;   otherfoo();
; }
;

declare i32 @otherfoo(...)
define void @foo_with_call() #1 {
;
; CHECK-RV32-LABEL: foo_with_call:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -64
; CHECK-RV32-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t0, 56(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t1, 52(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t2, 48(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a0, 44(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a1, 40(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a2, 36(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a3, 32(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a4, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a5, 24(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a6, 20(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a7, 16(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t3, 12(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t4, 8(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t5, 4(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t6, 0(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    call otherfoo
; CHECK-RV32-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t0, 56(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t1, 52(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t2, 48(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a0, 44(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a1, 40(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a2, 36(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a3, 32(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a4, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a5, 24(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a6, 20(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a7, 16(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t3, 12(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t4, 8(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t5, 4(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t6, 0(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    addi sp, sp, 64
; CHECK-RV32-NEXT:    mret
;
; CHECK-RV32-F-LABEL: foo_with_call:
; CHECK-RV32-F:       # %bb.0:
; CHECK-RV32-F-NEXT:    addi sp, sp, -144
; CHECK-RV32-F-NEXT:    sw ra, 140(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t0, 136(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t1, 132(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t2, 128(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a0, 124(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a1, 120(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a2, 116(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a3, 112(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a4, 108(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a5, 104(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a6, 100(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a7, 96(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t3, 92(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t4, 88(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t5, 84(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t6, 80(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft0, 76(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft1, 72(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft2, 68(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft3, 64(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft4, 60(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft5, 56(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft6, 52(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft7, 48(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa0, 44(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa1, 40(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa2, 36(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa3, 32(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa4, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa5, 24(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa6, 20(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa7, 16(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft8, 12(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft9, 8(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft10, 4(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft11, 0(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    call otherfoo
; CHECK-RV32-F-NEXT:    lw ra, 140(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t0, 136(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t1, 132(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t2, 128(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a0, 124(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a1, 120(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a2, 116(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a3, 112(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a4, 108(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a5, 104(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a6, 100(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a7, 96(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t3, 92(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t4, 88(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t5, 84(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t6, 80(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft0, 76(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft1, 72(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft2, 68(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft3, 64(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft4, 60(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft5, 56(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft6, 52(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft7, 48(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa0, 44(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa1, 40(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa2, 36(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa3, 32(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa4, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa5, 24(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa6, 20(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa7, 16(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft8, 12(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft9, 8(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft10, 4(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft11, 0(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    addi sp, sp, 144
; CHECK-RV32-F-NEXT:    mret
;
; CHECK-RV32-FD-LABEL: foo_with_call:
; CHECK-RV32-FD:       # %bb.0:
; CHECK-RV32-FD-NEXT:    addi sp, sp, -224
; CHECK-RV32-FD-NEXT:    sw ra, 220(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t0, 216(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t1, 212(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t2, 208(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a0, 204(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a1, 200(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a2, 196(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a3, 192(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a4, 188(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a5, 184(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a6, 180(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a7, 176(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t3, 172(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t4, 168(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t5, 164(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t6, 160(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft0, 152(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft1, 144(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft2, 136(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft3, 128(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft4, 120(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft5, 112(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft6, 104(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft7, 96(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa0, 88(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa1, 80(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa2, 72(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa3, 64(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa4, 56(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa5, 48(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa6, 40(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa7, 32(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft8, 24(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft9, 16(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft10, 8(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft11, 0(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    call otherfoo
; CHECK-RV32-FD-NEXT:    lw ra, 220(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t0, 216(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t1, 212(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t2, 208(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a0, 204(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a1, 200(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a2, 196(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a3, 192(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a4, 188(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a5, 184(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a6, 180(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a7, 176(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t3, 172(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t4, 168(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t5, 164(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t6, 160(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft0, 152(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft1, 144(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft2, 136(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft3, 128(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft4, 120(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft5, 112(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft6, 104(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft7, 96(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa0, 88(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa1, 80(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa2, 72(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa3, 64(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa4, 56(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa5, 48(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa6, 40(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa7, 32(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft8, 24(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft9, 16(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft10, 8(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft11, 0(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    addi sp, sp, 224
; CHECK-RV32-FD-NEXT:    mret
;
; CHECK-RV32-F-ILP3-LABEL: foo_with_call:
; CHECK-RV32-F-ILP3:       # %bb.0:
; CHECK-RV32-F-ILP3-NEXT:    addi sp, sp, -192
; CHECK-RV32-F-ILP3-NEXT:    sw ra, 188(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw t0, 184(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw t1, 180(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw t2, 176(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a0, 172(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a1, 168(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a2, 164(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a3, 160(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a4, 156(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a5, 152(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a6, 148(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a7, 144(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw t3, 140(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw t4, 136(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw t5, 132(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw t6, 128(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft0, 124(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft1, 120(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft2, 116(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft3, 112(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft4, 108(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft5, 104(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft6, 100(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft7, 96(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs0, 92(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs1, 88(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa0, 84(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa1, 80(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa2, 76(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa3, 72(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa4, 68(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa5, 64(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa6, 60(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa7, 56(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs2, 52(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs3, 48(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs4, 44(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs5, 40(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs6, 36(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs7, 32(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs8, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs9, 24(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs10, 20(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs11, 16(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft8, 12(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft9, 8(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft10, 4(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft11, 0(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    call otherfoo
; CHECK-RV32-F-ILP3-NEXT:    lw ra, 188(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw t0, 184(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw t1, 180(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw t2, 176(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a0, 172(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a1, 168(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a2, 164(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a3, 160(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a4, 156(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a5, 152(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a6, 148(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a7, 144(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw t3, 140(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw t4, 136(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw t5, 132(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw t6, 128(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft0, 124(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft1, 120(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft2, 116(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft3, 112(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft4, 108(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft5, 104(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft6, 100(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft7, 96(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs0, 92(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs1, 88(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa0, 84(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa1, 80(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa2, 76(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa3, 72(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa4, 68(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa5, 64(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa6, 60(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa7, 56(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs2, 52(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs3, 48(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs4, 44(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs5, 40(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs6, 36(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs7, 32(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs8, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs9, 24(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs10, 20(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs11, 16(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft8, 12(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft9, 8(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft10, 4(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft11, 0(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    addi sp, sp, 192
; CHECK-RV32-F-ILP3-NEXT:    mret
;
; CHECK-RV32-FD-ILP32F-LABEL: foo_with_call:
; CHECK-RV32-FD-ILP32F:       # %bb.0:
; CHECK-RV32-FD-ILP32F-NEXT:    addi sp, sp, -320
; CHECK-RV32-FD-ILP32F-NEXT:    sw ra, 316(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw t0, 312(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw t1, 308(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw t2, 304(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a0, 300(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a1, 296(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a2, 292(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a3, 288(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a4, 284(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a5, 280(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a6, 276(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a7, 272(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw t3, 268(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw t4, 264(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw t5, 260(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw t6, 256(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft0, 248(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft1, 240(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft2, 232(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft3, 224(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft4, 216(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft5, 208(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft6, 200(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft7, 192(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs0, 184(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs1, 176(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa0, 168(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa1, 160(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa2, 152(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa3, 144(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa4, 136(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa5, 128(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa6, 120(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa7, 112(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs2, 104(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs3, 96(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs4, 88(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs5, 80(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs6, 72(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs7, 64(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs8, 56(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs9, 48(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs10, 40(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs11, 32(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft8, 24(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft9, 16(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft10, 8(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft11, 0(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    call otherfoo
; CHECK-RV32-FD-ILP32F-NEXT:    lw ra, 316(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw t0, 312(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw t1, 308(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw t2, 304(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a0, 300(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a1, 296(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a2, 292(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a3, 288(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a4, 284(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a5, 280(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a6, 276(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a7, 272(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw t3, 268(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw t4, 264(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw t5, 260(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw t6, 256(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft0, 248(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft1, 240(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft2, 232(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft3, 224(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft4, 216(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft5, 208(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft6, 200(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft7, 192(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs0, 184(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs1, 176(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa0, 168(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa1, 160(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa2, 152(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa3, 144(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa4, 136(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa5, 128(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa6, 120(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa7, 112(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs2, 104(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs3, 96(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs4, 88(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs5, 80(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs6, 72(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs7, 64(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs8, 56(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs9, 48(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs10, 40(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs11, 32(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft8, 24(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft9, 16(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft10, 8(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft11, 0(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    addi sp, sp, 320
; CHECK-RV32-FD-ILP32F-NEXT:    mret
;
; CHECK-RV32-FD-ILP32-LABEL: foo_with_call:
; CHECK-RV32-FD-ILP32:       # %bb.0:
; CHECK-RV32-FD-ILP32-NEXT:    addi sp, sp, -320
; CHECK-RV32-FD-ILP32-NEXT:    sw ra, 316(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw t0, 312(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw t1, 308(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw t2, 304(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a0, 300(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a1, 296(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a2, 292(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a3, 288(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a4, 284(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a5, 280(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a6, 276(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a7, 272(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw t3, 268(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw t4, 264(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw t5, 260(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw t6, 256(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft0, 248(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft1, 240(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft2, 232(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft3, 224(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft4, 216(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft5, 208(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft6, 200(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft7, 192(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs0, 184(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs1, 176(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa0, 168(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa1, 160(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa2, 152(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa3, 144(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa4, 136(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa5, 128(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa6, 120(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa7, 112(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs2, 104(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs3, 96(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs4, 88(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs5, 80(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs6, 72(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs7, 64(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs8, 56(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs9, 48(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs10, 40(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs11, 32(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft8, 24(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft9, 16(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft10, 8(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft11, 0(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    call otherfoo
; CHECK-RV32-FD-ILP32-NEXT:    lw ra, 316(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw t0, 312(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw t1, 308(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw t2, 304(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a0, 300(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a1, 296(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a2, 292(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a3, 288(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a4, 284(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a5, 280(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a6, 276(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a7, 272(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw t3, 268(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw t4, 264(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw t5, 260(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw t6, 256(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft0, 248(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft1, 240(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft2, 232(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft3, 224(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft4, 216(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft5, 208(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft6, 200(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft7, 192(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs0, 184(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs1, 176(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa0, 168(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa1, 160(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa2, 152(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa3, 144(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa4, 136(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa5, 128(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa6, 120(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa7, 112(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs2, 104(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs3, 96(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs4, 88(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs5, 80(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs6, 72(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs7, 64(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs8, 56(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs9, 48(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs10, 40(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs11, 32(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft8, 24(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft9, 16(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft10, 8(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft11, 0(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    addi sp, sp, 320
; CHECK-RV32-FD-ILP32-NEXT:    mret
;
; CHECK-RV32I-ILP32E-LABEL: foo_with_call:
; CHECK-RV32I-ILP32E:       # %bb.0:
; CHECK-RV32I-ILP32E-NEXT:    addi sp, sp, -104
; CHECK-RV32I-ILP32E-NEXT:    sw ra, 100(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw t0, 96(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw t1, 92(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw t2, 88(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a1, 80(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a2, 76(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a3, 72(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a4, 68(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a5, 64(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a6, 60(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a7, 56(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s2, 52(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s3, 48(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s4, 44(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s5, 40(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s6, 36(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s7, 32(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s8, 28(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s9, 24(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s10, 20(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s11, 16(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw t3, 12(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw t4, 8(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw t5, 4(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw t6, 0(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    call otherfoo
; CHECK-RV32I-ILP32E-NEXT:    lw ra, 100(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw t0, 96(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw t1, 92(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw t2, 88(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a1, 80(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a2, 76(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a3, 72(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a4, 68(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a5, 64(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a6, 60(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a7, 56(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s2, 52(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s3, 48(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s4, 44(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s5, 40(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s6, 36(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s7, 32(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s8, 28(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s9, 24(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s10, 20(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s11, 16(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw t3, 12(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw t4, 8(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw t5, 4(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw t6, 0(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    addi sp, sp, 104
; CHECK-RV32I-ILP32E-NEXT:    mret
;
; CHECK-RV32E-LABEL: foo_with_call:
; CHECK-RV32E:       # %bb.0:
; CHECK-RV32E-NEXT:    addi sp, sp, -40
; CHECK-RV32E-NEXT:    sw ra, 36(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw t0, 32(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw t1, 28(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw t2, 24(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw a1, 16(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw a2, 12(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw a3, 8(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw a4, 4(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw a5, 0(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    call otherfoo
; CHECK-RV32E-NEXT:    lw ra, 36(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw t0, 32(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw t1, 28(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw t2, 24(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw a1, 16(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw a2, 12(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw a3, 8(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw a4, 4(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw a5, 0(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    addi sp, sp, 40
; CHECK-RV32E-NEXT:    mret
;
; CHECK-RV32E-F-LABEL: foo_with_call:
; CHECK-RV32E-F:       # %bb.0:
; CHECK-RV32E-F-NEXT:    addi sp, sp, -168
; CHECK-RV32E-F-NEXT:    sw ra, 164(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw t0, 160(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw t1, 156(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw t2, 152(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw a0, 148(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw a1, 144(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw a2, 140(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw a3, 136(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw a4, 132(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw a5, 128(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft0, 124(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft1, 120(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft2, 116(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft3, 112(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft4, 108(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft5, 104(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft6, 100(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft7, 96(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs0, 92(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs1, 88(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa0, 84(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa1, 80(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa2, 76(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa3, 72(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa4, 68(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa5, 64(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa6, 60(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa7, 56(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs2, 52(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs3, 48(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs4, 44(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs5, 40(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs6, 36(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs7, 32(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs8, 28(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs9, 24(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs10, 20(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs11, 16(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft8, 12(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft9, 8(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft10, 4(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft11, 0(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    call otherfoo
; CHECK-RV32E-F-NEXT:    lw ra, 164(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw t0, 160(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw t1, 156(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw t2, 152(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw a0, 148(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw a1, 144(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw a2, 140(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw a3, 136(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw a4, 132(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw a5, 128(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft0, 124(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft1, 120(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft2, 116(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft3, 112(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft4, 108(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft5, 104(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft6, 100(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft7, 96(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs0, 92(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs1, 88(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa0, 84(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa1, 80(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa2, 76(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa3, 72(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa4, 68(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa5, 64(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa6, 60(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa7, 56(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs2, 52(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs3, 48(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs4, 44(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs5, 40(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs6, 36(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs7, 32(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs8, 28(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs9, 24(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs10, 20(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs11, 16(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft8, 12(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft9, 8(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft10, 4(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft11, 0(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    addi sp, sp, 168
; CHECK-RV32E-F-NEXT:    mret
;
; CHECK-RV64-LABEL: foo_with_call:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    addi sp, sp, -128
; CHECK-RV64-NEXT:    sd ra, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t0, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t1, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t2, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a0, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a1, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a2, 72(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a3, 64(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a4, 56(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a5, 48(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a6, 40(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a7, 32(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t3, 24(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t4, 16(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t5, 8(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t6, 0(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    call otherfoo
; CHECK-RV64-NEXT:    ld ra, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t0, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t1, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t2, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a0, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a1, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a2, 72(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a3, 64(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a4, 56(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a5, 48(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a6, 40(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a7, 32(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t3, 24(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t4, 16(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t5, 8(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t6, 0(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    addi sp, sp, 128
; CHECK-RV64-NEXT:    mret
;
; CHECK-RV64-F-LABEL: foo_with_call:
; CHECK-RV64-F:       # %bb.0:
; CHECK-RV64-F-NEXT:    addi sp, sp, -208
; CHECK-RV64-F-NEXT:    sd ra, 200(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t0, 192(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t1, 184(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t2, 176(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a0, 168(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a1, 160(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a2, 152(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a3, 144(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a4, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a5, 128(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a6, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a7, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t3, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t4, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t5, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t6, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft0, 76(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft1, 72(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft2, 68(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft3, 64(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft4, 60(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft5, 56(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft6, 52(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft7, 48(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa0, 44(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa1, 40(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa2, 36(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa3, 32(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa4, 28(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa5, 24(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa6, 20(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa7, 16(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft8, 12(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft9, 8(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft10, 4(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft11, 0(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    call otherfoo
; CHECK-RV64-F-NEXT:    ld ra, 200(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t0, 192(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t1, 184(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t2, 176(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a0, 168(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a1, 160(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a2, 152(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a3, 144(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a4, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a5, 128(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a6, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a7, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t3, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t4, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t5, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t6, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft0, 76(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft1, 72(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft2, 68(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft3, 64(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft4, 60(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft5, 56(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft6, 52(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft7, 48(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa0, 44(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa1, 40(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa2, 36(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa3, 32(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa4, 28(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa5, 24(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa6, 20(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa7, 16(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft8, 12(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft9, 8(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft10, 4(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft11, 0(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    addi sp, sp, 208
; CHECK-RV64-F-NEXT:    mret
;
; CHECK-RV64-FD-LABEL: foo_with_call:
; CHECK-RV64-FD:       # %bb.0:
; CHECK-RV64-FD-NEXT:    addi sp, sp, -288
; CHECK-RV64-FD-NEXT:    sd ra, 280(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t0, 272(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t1, 264(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t2, 256(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a0, 248(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a1, 240(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a2, 232(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a3, 224(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a4, 216(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a5, 208(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a6, 200(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a7, 192(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t3, 184(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t4, 176(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t5, 168(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t6, 160(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft0, 152(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft1, 144(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft2, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft3, 128(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft4, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft5, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft6, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft7, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa0, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa1, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa2, 72(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa3, 64(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa4, 56(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa5, 48(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa6, 40(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa7, 32(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft8, 24(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft9, 16(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft10, 8(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft11, 0(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    call otherfoo
; CHECK-RV64-FD-NEXT:    ld ra, 280(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t0, 272(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t1, 264(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t2, 256(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a0, 248(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a1, 240(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a2, 232(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a3, 224(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a4, 216(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a5, 208(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a6, 200(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a7, 192(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t3, 184(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t4, 176(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t5, 168(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t6, 160(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft0, 152(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft1, 144(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft2, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft3, 128(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft4, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft5, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft6, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft7, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa0, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa1, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa2, 72(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa3, 64(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa4, 56(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa5, 48(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa6, 40(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa7, 32(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft8, 24(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft9, 16(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft10, 8(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft11, 0(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    addi sp, sp, 288
; CHECK-RV64-FD-NEXT:    mret
;
; CHECK-RV64-F-LP64-LABEL: foo_with_call:
; CHECK-RV64-F-LP64:       # %bb.0:
; CHECK-RV64-F-LP64-NEXT:    addi sp, sp, -256
; CHECK-RV64-F-LP64-NEXT:    sd ra, 248(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd t0, 240(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd t1, 232(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd t2, 224(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a0, 216(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a1, 208(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a2, 200(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a3, 192(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a4, 184(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a5, 176(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a6, 168(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a7, 160(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd t3, 152(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd t4, 144(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd t5, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd t6, 128(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft0, 124(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft1, 120(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft2, 116(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft3, 112(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft4, 108(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft5, 104(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft6, 100(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft7, 96(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs0, 92(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs1, 88(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa0, 84(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa1, 80(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa2, 76(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa3, 72(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa4, 68(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa5, 64(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa6, 60(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa7, 56(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs2, 52(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs3, 48(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs4, 44(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs5, 40(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs6, 36(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs7, 32(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs8, 28(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs9, 24(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs10, 20(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs11, 16(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft8, 12(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft9, 8(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft10, 4(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft11, 0(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    call otherfoo
; CHECK-RV64-F-LP64-NEXT:    ld ra, 248(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld t0, 240(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld t1, 232(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld t2, 224(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a0, 216(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a1, 208(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a2, 200(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a3, 192(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a4, 184(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a5, 176(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a6, 168(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a7, 160(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld t3, 152(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld t4, 144(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld t5, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld t6, 128(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft0, 124(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft1, 120(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft2, 116(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft3, 112(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft4, 108(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft5, 104(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft6, 100(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft7, 96(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs0, 92(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs1, 88(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa0, 84(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa1, 80(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa2, 76(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa3, 72(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa4, 68(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa5, 64(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa6, 60(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa7, 56(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs2, 52(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs3, 48(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs4, 44(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs5, 40(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs6, 36(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs7, 32(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs8, 28(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs9, 24(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs10, 20(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs11, 16(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft8, 12(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft9, 8(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft10, 4(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft11, 0(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    addi sp, sp, 256
; CHECK-RV64-F-LP64-NEXT:    mret
;
; CHECK-RV64-FD-LP64F-LABEL: foo_with_call:
; CHECK-RV64-FD-LP64F:       # %bb.0:
; CHECK-RV64-FD-LP64F-NEXT:    addi sp, sp, -384
; CHECK-RV64-FD-LP64F-NEXT:    sd ra, 376(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd t0, 368(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd t1, 360(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd t2, 352(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a0, 344(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a1, 336(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a2, 328(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a3, 320(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a4, 312(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a5, 304(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a6, 296(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a7, 288(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd t3, 280(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd t4, 272(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd t5, 264(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd t6, 256(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft0, 248(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft1, 240(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft2, 232(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft3, 224(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft4, 216(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft5, 208(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft6, 200(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft7, 192(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs0, 184(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs1, 176(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa0, 168(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa1, 160(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa2, 152(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa3, 144(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa4, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa5, 128(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa6, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa7, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs2, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs3, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs4, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs5, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs6, 72(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs7, 64(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs8, 56(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs9, 48(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs10, 40(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs11, 32(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft8, 24(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft9, 16(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft10, 8(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft11, 0(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    call otherfoo
; CHECK-RV64-FD-LP64F-NEXT:    ld ra, 376(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld t0, 368(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld t1, 360(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld t2, 352(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a0, 344(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a1, 336(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a2, 328(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a3, 320(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a4, 312(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a5, 304(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a6, 296(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a7, 288(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld t3, 280(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld t4, 272(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld t5, 264(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld t6, 256(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft0, 248(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft1, 240(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft2, 232(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft3, 224(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft4, 216(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft5, 208(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft6, 200(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft7, 192(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs0, 184(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs1, 176(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa0, 168(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa1, 160(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa2, 152(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa3, 144(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa4, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa5, 128(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa6, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa7, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs2, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs3, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs4, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs5, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs6, 72(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs7, 64(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs8, 56(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs9, 48(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs10, 40(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs11, 32(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft8, 24(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft9, 16(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft10, 8(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft11, 0(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    addi sp, sp, 384
; CHECK-RV64-FD-LP64F-NEXT:    mret
;
; CHECK-RV64-FD-LP64-LABEL: foo_with_call:
; CHECK-RV64-FD-LP64:       # %bb.0:
; CHECK-RV64-FD-LP64-NEXT:    addi sp, sp, -384
; CHECK-RV64-FD-LP64-NEXT:    sd ra, 376(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd t0, 368(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd t1, 360(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd t2, 352(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a0, 344(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a1, 336(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a2, 328(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a3, 320(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a4, 312(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a5, 304(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a6, 296(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a7, 288(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd t3, 280(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd t4, 272(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd t5, 264(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd t6, 256(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft0, 248(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft1, 240(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft2, 232(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft3, 224(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft4, 216(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft5, 208(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft6, 200(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft7, 192(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs0, 184(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs1, 176(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa0, 168(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa1, 160(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa2, 152(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa3, 144(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa4, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa5, 128(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa6, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa7, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs2, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs3, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs4, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs5, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs6, 72(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs7, 64(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs8, 56(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs9, 48(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs10, 40(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs11, 32(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft8, 24(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft9, 16(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft10, 8(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft11, 0(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    call otherfoo
; CHECK-RV64-FD-LP64-NEXT:    ld ra, 376(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld t0, 368(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld t1, 360(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld t2, 352(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a0, 344(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a1, 336(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a2, 328(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a3, 320(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a4, 312(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a5, 304(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a6, 296(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a7, 288(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld t3, 280(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld t4, 272(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld t5, 264(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld t6, 256(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft0, 248(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft1, 240(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft2, 232(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft3, 224(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft4, 216(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft5, 208(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft6, 200(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft7, 192(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs0, 184(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs1, 176(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa0, 168(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa1, 160(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa2, 152(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa3, 144(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa4, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa5, 128(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa6, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa7, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs2, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs3, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs4, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs5, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs6, 72(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs7, 64(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs8, 56(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs9, 48(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs10, 40(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs11, 32(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft8, 24(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft9, 16(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft10, 8(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft11, 0(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    addi sp, sp, 384
; CHECK-RV64-FD-LP64-NEXT:    mret
;
; CHECK-RV64I-LP64E-LABEL: foo_with_call:
; CHECK-RV64I-LP64E:       # %bb.0:
; CHECK-RV64I-LP64E-NEXT:    addi sp, sp, -208
; CHECK-RV64I-LP64E-NEXT:    sd ra, 200(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd t0, 192(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd t1, 184(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd t2, 176(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a0, 168(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a1, 160(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a2, 152(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a3, 144(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a4, 136(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a5, 128(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a6, 120(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a7, 112(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s2, 104(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s3, 96(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s4, 88(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s5, 80(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s6, 72(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s7, 64(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s8, 56(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s9, 48(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s10, 40(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s11, 32(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd t3, 24(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd t4, 16(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd t5, 8(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd t6, 0(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    call otherfoo
; CHECK-RV64I-LP64E-NEXT:    ld ra, 200(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld t0, 192(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld t1, 184(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld t2, 176(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a0, 168(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a1, 160(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a2, 152(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a3, 144(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a4, 136(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a5, 128(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a6, 120(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a7, 112(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s2, 104(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s3, 96(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s4, 88(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s5, 80(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s6, 72(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s7, 64(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s8, 56(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s9, 48(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s10, 40(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s11, 32(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld t3, 24(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld t4, 16(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld t5, 8(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld t6, 0(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    addi sp, sp, 208
; CHECK-RV64I-LP64E-NEXT:    mret
;
; CHECK-RV64E-LABEL: foo_with_call:
; CHECK-RV64E:       # %bb.0:
; CHECK-RV64E-NEXT:    addi sp, sp, -80
; CHECK-RV64E-NEXT:    sd ra, 72(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd t0, 64(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd t1, 56(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd t2, 48(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd a0, 40(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd a1, 32(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd a2, 24(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd a3, 16(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd a4, 8(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd a5, 0(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    call otherfoo
; CHECK-RV64E-NEXT:    ld ra, 72(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld t0, 64(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld t1, 56(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld t2, 48(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld a1, 32(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld a2, 24(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld a3, 16(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld a4, 8(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld a5, 0(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    addi sp, sp, 80
; CHECK-RV64E-NEXT:    mret
;
; CHECK-RV64E-F-LABEL: foo_with_call:
; CHECK-RV64E-F:       # %bb.0:
; CHECK-RV64E-F-NEXT:    addi sp, sp, -208
; CHECK-RV64E-F-NEXT:    sd ra, 200(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd t0, 192(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd t1, 184(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd t2, 176(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd a0, 168(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd a1, 160(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd a2, 152(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd a3, 144(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd a4, 136(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd a5, 128(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft0, 124(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft1, 120(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft2, 116(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft3, 112(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft4, 108(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft5, 104(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft6, 100(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft7, 96(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs0, 92(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs1, 88(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa0, 84(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa1, 80(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa2, 76(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa3, 72(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa4, 68(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa5, 64(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa6, 60(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa7, 56(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs2, 52(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs3, 48(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs4, 44(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs5, 40(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs6, 36(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs7, 32(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs8, 28(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs9, 24(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs10, 20(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs11, 16(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft8, 12(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft9, 8(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft10, 4(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft11, 0(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    call otherfoo
; CHECK-RV64E-F-NEXT:    ld ra, 200(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld t0, 192(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld t1, 184(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld t2, 176(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld a0, 168(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld a1, 160(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld a2, 152(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld a3, 144(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld a4, 136(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld a5, 128(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft0, 124(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft1, 120(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft2, 116(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft3, 112(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft4, 108(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft5, 104(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft6, 100(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft7, 96(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs0, 92(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs1, 88(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa0, 84(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa1, 80(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa2, 76(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa3, 72(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa4, 68(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa5, 64(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa6, 60(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa7, 56(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs2, 52(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs3, 48(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs4, 44(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs5, 40(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs6, 36(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs7, 32(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs8, 28(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs9, 24(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs10, 20(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs11, 16(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft8, 12(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft9, 8(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft10, 4(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft11, 0(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    addi sp, sp, 208
; CHECK-RV64E-F-NEXT:    mret
;
; CHECK-RV64E-FD-LABEL: foo_with_call:
; CHECK-RV64E-FD:       # %bb.0:
; CHECK-RV64E-FD-NEXT:    addi sp, sp, -464
; CHECK-RV64E-FD-NEXT:    sd ra, 456(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd t0, 448(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd t1, 440(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd t2, 432(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a0, 424(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a1, 416(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a2, 408(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a3, 400(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a4, 392(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a5, 384(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a6, 376(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a7, 368(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s2, 360(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s3, 352(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s4, 344(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s5, 336(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s6, 328(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s7, 320(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s8, 312(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s9, 304(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s10, 296(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s11, 288(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd t3, 280(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd t4, 272(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd t5, 264(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd t6, 256(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft0, 248(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft1, 240(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft2, 232(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft3, 224(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft4, 216(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft5, 208(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft6, 200(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft7, 192(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs0, 184(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs1, 176(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa0, 168(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa1, 160(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa2, 152(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa3, 144(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa4, 136(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa5, 128(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa6, 120(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa7, 112(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs2, 104(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs3, 96(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs4, 88(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs5, 80(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs6, 72(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs7, 64(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs8, 56(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs9, 48(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs10, 40(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs11, 32(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft8, 24(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft9, 16(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft10, 8(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft11, 0(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    call otherfoo
; CHECK-RV64E-FD-NEXT:    ld ra, 456(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld t0, 448(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld t1, 440(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld t2, 432(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a0, 424(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a1, 416(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a2, 408(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a3, 400(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a4, 392(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a5, 384(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a6, 376(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a7, 368(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s2, 360(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s3, 352(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s4, 344(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s5, 336(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s6, 328(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s7, 320(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s8, 312(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s9, 304(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s10, 296(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s11, 288(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld t3, 280(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld t4, 272(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld t5, 264(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld t6, 256(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft0, 248(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft1, 240(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft2, 232(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft3, 224(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft4, 216(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft5, 208(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft6, 200(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft7, 192(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs0, 184(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs1, 176(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa0, 168(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa1, 160(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa2, 152(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa3, 144(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa4, 136(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa5, 128(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa6, 120(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa7, 112(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs2, 104(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs3, 96(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs4, 88(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs5, 80(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs6, 72(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs7, 64(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs8, 56(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs9, 48(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs10, 40(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs11, 32(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft8, 24(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft9, 16(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft10, 8(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft11, 0(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    addi sp, sp, 464
; CHECK-RV64E-FD-NEXT:    mret
  %call = call i32 @otherfoo()
  ret void
}

;
; Additionally check frame pointer and return address are properly saved.
;
define void @foo_fp_with_call() #2 {
;
; CHECK-RV32-LABEL: foo_fp_with_call:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -80
; CHECK-RV32-NEXT:    sw ra, 76(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t0, 72(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t1, 68(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t2, 64(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s0, 60(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a0, 56(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a1, 52(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a2, 48(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a3, 44(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a4, 40(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a5, 36(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a6, 32(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a7, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t3, 24(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t4, 20(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t5, 16(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t6, 12(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    addi s0, sp, 80
; CHECK-RV32-NEXT:    call otherfoo
; CHECK-RV32-NEXT:    lw ra, 76(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t0, 72(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t1, 68(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t2, 64(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s0, 60(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a0, 56(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a1, 52(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a2, 48(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a3, 44(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a4, 40(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a5, 36(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a6, 32(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a7, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t3, 24(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t4, 20(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t5, 16(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t6, 12(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    addi sp, sp, 80
; CHECK-RV32-NEXT:    mret
;
; CHECK-RV32-F-LABEL: foo_fp_with_call:
; CHECK-RV32-F:       # %bb.0:
; CHECK-RV32-F-NEXT:    addi sp, sp, -160
; CHECK-RV32-F-NEXT:    sw ra, 156(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t0, 152(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t1, 148(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t2, 144(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw s0, 140(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a0, 136(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a1, 132(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a2, 128(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a3, 124(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a4, 120(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a5, 116(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a6, 112(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw a7, 108(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t3, 104(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t4, 100(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t5, 96(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    sw t6, 92(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft0, 88(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft1, 84(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft2, 80(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft3, 76(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft4, 72(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft5, 68(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft6, 64(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft7, 60(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa0, 56(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa1, 52(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa2, 48(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa3, 44(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa4, 40(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa5, 36(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa6, 32(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw fa7, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft8, 24(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft9, 20(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft10, 16(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    fsw ft11, 12(sp) # 4-byte Folded Spill
; CHECK-RV32-F-NEXT:    addi s0, sp, 160
; CHECK-RV32-F-NEXT:    call otherfoo
; CHECK-RV32-F-NEXT:    lw ra, 156(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t0, 152(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t1, 148(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t2, 144(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw s0, 140(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a0, 136(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a1, 132(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a2, 128(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a3, 124(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a4, 120(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a5, 116(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a6, 112(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw a7, 108(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t3, 104(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t4, 100(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t5, 96(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    lw t6, 92(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft0, 88(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft1, 84(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft2, 80(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft3, 76(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft4, 72(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft5, 68(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft6, 64(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft7, 60(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa0, 56(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa1, 52(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa2, 48(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa3, 44(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa4, 40(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa5, 36(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa6, 32(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw fa7, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft8, 24(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft9, 20(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft10, 16(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    flw ft11, 12(sp) # 4-byte Folded Reload
; CHECK-RV32-F-NEXT:    addi sp, sp, 160
; CHECK-RV32-F-NEXT:    mret
;
; CHECK-RV32-FD-LABEL: foo_fp_with_call:
; CHECK-RV32-FD:       # %bb.0:
; CHECK-RV32-FD-NEXT:    addi sp, sp, -240
; CHECK-RV32-FD-NEXT:    sw ra, 236(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t0, 232(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t1, 228(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t2, 224(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw s0, 220(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a0, 216(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a1, 212(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a2, 208(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a3, 204(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a4, 200(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a5, 196(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a6, 192(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw a7, 188(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t3, 184(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t4, 180(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t5, 176(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    sw t6, 172(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft0, 160(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft1, 152(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft2, 144(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft3, 136(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft4, 128(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft5, 120(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft6, 112(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft7, 104(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa0, 96(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa1, 88(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa2, 80(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa3, 72(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa4, 64(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa5, 56(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa6, 48(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd fa7, 40(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft8, 32(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft9, 24(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft10, 16(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    fsd ft11, 8(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-NEXT:    addi s0, sp, 240
; CHECK-RV32-FD-NEXT:    call otherfoo
; CHECK-RV32-FD-NEXT:    lw ra, 236(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t0, 232(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t1, 228(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t2, 224(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw s0, 220(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a0, 216(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a1, 212(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a2, 208(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a3, 204(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a4, 200(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a5, 196(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a6, 192(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw a7, 188(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t3, 184(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t4, 180(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t5, 176(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    lw t6, 172(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft0, 160(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft1, 152(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft2, 144(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft3, 136(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft4, 128(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft5, 120(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft6, 112(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft7, 104(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa0, 96(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa1, 88(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa2, 80(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa3, 72(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa4, 64(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa5, 56(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa6, 48(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld fa7, 40(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft8, 32(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft9, 24(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft10, 16(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    fld ft11, 8(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-NEXT:    addi sp, sp, 240
; CHECK-RV32-FD-NEXT:    mret
;
; CHECK-RV32-F-ILP3-LABEL: foo_fp_with_call:
; CHECK-RV32-F-ILP3:       # %bb.0:
; CHECK-RV32-F-ILP3-NEXT:    addi sp, sp, -208
; CHECK-RV32-F-ILP3-NEXT:    sw ra, 204(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw t0, 200(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw t1, 196(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw t2, 192(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw s0, 188(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a0, 184(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a1, 180(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a2, 176(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a3, 172(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a4, 168(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a5, 164(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a6, 160(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw a7, 156(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw t3, 152(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw t4, 148(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw t5, 144(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    sw t6, 140(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft0, 136(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft1, 132(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft2, 128(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft3, 124(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft4, 120(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft5, 116(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft6, 112(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft7, 108(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs0, 104(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs1, 100(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa0, 96(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa1, 92(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa2, 88(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa3, 84(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa4, 80(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa5, 76(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa6, 72(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fa7, 68(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs2, 64(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs3, 60(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs4, 56(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs5, 52(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs6, 48(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs7, 44(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs8, 40(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs9, 36(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs10, 32(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw fs11, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft8, 24(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft9, 20(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft10, 16(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    fsw ft11, 12(sp) # 4-byte Folded Spill
; CHECK-RV32-F-ILP3-NEXT:    addi s0, sp, 208
; CHECK-RV32-F-ILP3-NEXT:    call otherfoo
; CHECK-RV32-F-ILP3-NEXT:    lw ra, 204(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw t0, 200(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw t1, 196(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw t2, 192(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw s0, 188(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a0, 184(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a1, 180(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a2, 176(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a3, 172(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a4, 168(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a5, 164(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a6, 160(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw a7, 156(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw t3, 152(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw t4, 148(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw t5, 144(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    lw t6, 140(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft0, 136(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft1, 132(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft2, 128(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft3, 124(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft4, 120(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft5, 116(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft6, 112(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft7, 108(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs0, 104(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs1, 100(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa0, 96(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa1, 92(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa2, 88(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa3, 84(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa4, 80(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa5, 76(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa6, 72(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fa7, 68(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs2, 64(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs3, 60(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs4, 56(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs5, 52(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs6, 48(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs7, 44(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs8, 40(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs9, 36(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs10, 32(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw fs11, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft8, 24(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft9, 20(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft10, 16(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    flw ft11, 12(sp) # 4-byte Folded Reload
; CHECK-RV32-F-ILP3-NEXT:    addi sp, sp, 208
; CHECK-RV32-F-ILP3-NEXT:    mret
;
; CHECK-RV32-FD-ILP32F-LABEL: foo_fp_with_call:
; CHECK-RV32-FD-ILP32F:       # %bb.0:
; CHECK-RV32-FD-ILP32F-NEXT:    addi sp, sp, -336
; CHECK-RV32-FD-ILP32F-NEXT:    sw ra, 332(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw t0, 328(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw t1, 324(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw t2, 320(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw s0, 316(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a0, 312(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a1, 308(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a2, 304(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a3, 300(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a4, 296(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a5, 292(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a6, 288(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw a7, 284(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw t3, 280(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw t4, 276(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw t5, 272(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    sw t6, 268(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft0, 256(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft1, 248(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft2, 240(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft3, 232(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft4, 224(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft5, 216(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft6, 208(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft7, 200(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs0, 192(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs1, 184(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa0, 176(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa1, 168(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa2, 160(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa3, 152(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa4, 144(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa5, 136(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa6, 128(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fa7, 120(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs2, 112(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs3, 104(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs4, 96(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs5, 88(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs6, 80(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs7, 72(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs8, 64(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs9, 56(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs10, 48(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd fs11, 40(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft8, 32(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft9, 24(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft10, 16(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    fsd ft11, 8(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32F-NEXT:    addi s0, sp, 336
; CHECK-RV32-FD-ILP32F-NEXT:    call otherfoo
; CHECK-RV32-FD-ILP32F-NEXT:    lw ra, 332(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw t0, 328(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw t1, 324(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw t2, 320(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw s0, 316(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a0, 312(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a1, 308(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a2, 304(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a3, 300(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a4, 296(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a5, 292(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a6, 288(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw a7, 284(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw t3, 280(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw t4, 276(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw t5, 272(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    lw t6, 268(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft0, 256(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft1, 248(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft2, 240(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft3, 232(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft4, 224(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft5, 216(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft6, 208(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft7, 200(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs0, 192(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs1, 184(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa0, 176(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa1, 168(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa2, 160(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa3, 152(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa4, 144(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa5, 136(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa6, 128(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fa7, 120(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs2, 112(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs3, 104(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs4, 96(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs5, 88(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs6, 80(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs7, 72(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs8, 64(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs9, 56(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs10, 48(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld fs11, 40(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft8, 32(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft9, 24(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft10, 16(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    fld ft11, 8(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32F-NEXT:    addi sp, sp, 336
; CHECK-RV32-FD-ILP32F-NEXT:    mret
;
; CHECK-RV32-FD-ILP32-LABEL: foo_fp_with_call:
; CHECK-RV32-FD-ILP32:       # %bb.0:
; CHECK-RV32-FD-ILP32-NEXT:    addi sp, sp, -336
; CHECK-RV32-FD-ILP32-NEXT:    sw ra, 332(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw t0, 328(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw t1, 324(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw t2, 320(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw s0, 316(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a0, 312(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a1, 308(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a2, 304(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a3, 300(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a4, 296(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a5, 292(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a6, 288(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw a7, 284(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw t3, 280(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw t4, 276(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw t5, 272(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    sw t6, 268(sp) # 4-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft0, 256(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft1, 248(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft2, 240(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft3, 232(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft4, 224(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft5, 216(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft6, 208(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft7, 200(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs0, 192(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs1, 184(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa0, 176(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa1, 168(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa2, 160(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa3, 152(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa4, 144(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa5, 136(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa6, 128(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fa7, 120(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs2, 112(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs3, 104(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs4, 96(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs5, 88(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs6, 80(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs7, 72(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs8, 64(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs9, 56(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs10, 48(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd fs11, 40(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft8, 32(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft9, 24(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft10, 16(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    fsd ft11, 8(sp) # 8-byte Folded Spill
; CHECK-RV32-FD-ILP32-NEXT:    addi s0, sp, 336
; CHECK-RV32-FD-ILP32-NEXT:    call otherfoo
; CHECK-RV32-FD-ILP32-NEXT:    lw ra, 332(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw t0, 328(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw t1, 324(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw t2, 320(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw s0, 316(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a0, 312(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a1, 308(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a2, 304(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a3, 300(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a4, 296(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a5, 292(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a6, 288(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw a7, 284(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw t3, 280(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw t4, 276(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw t5, 272(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    lw t6, 268(sp) # 4-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft0, 256(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft1, 248(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft2, 240(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft3, 232(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft4, 224(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft5, 216(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft6, 208(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft7, 200(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs0, 192(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs1, 184(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa0, 176(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa1, 168(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa2, 160(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa3, 152(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa4, 144(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa5, 136(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa6, 128(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fa7, 120(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs2, 112(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs3, 104(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs4, 96(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs5, 88(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs6, 80(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs7, 72(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs8, 64(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs9, 56(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs10, 48(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld fs11, 40(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft8, 32(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft9, 24(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft10, 16(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    fld ft11, 8(sp) # 8-byte Folded Reload
; CHECK-RV32-FD-ILP32-NEXT:    addi sp, sp, 336
; CHECK-RV32-FD-ILP32-NEXT:    mret
;
; CHECK-RV32I-ILP32E-LABEL: foo_fp_with_call:
; CHECK-RV32I-ILP32E:       # %bb.0:
; CHECK-RV32I-ILP32E-NEXT:    addi sp, sp, -108
; CHECK-RV32I-ILP32E-NEXT:    sw ra, 104(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw t0, 100(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw t1, 96(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw t2, 92(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s0, 88(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a0, 84(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a1, 80(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a2, 76(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a3, 72(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a4, 68(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a5, 64(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a6, 60(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw a7, 56(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s2, 52(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s3, 48(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s4, 44(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s5, 40(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s6, 36(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s7, 32(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s8, 28(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s9, 24(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s10, 20(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw s11, 16(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw t3, 12(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw t4, 8(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw t5, 4(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    sw t6, 0(sp) # 4-byte Folded Spill
; CHECK-RV32I-ILP32E-NEXT:    addi s0, sp, 108
; CHECK-RV32I-ILP32E-NEXT:    call otherfoo
; CHECK-RV32I-ILP32E-NEXT:    lw ra, 104(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw t0, 100(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw t1, 96(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw t2, 92(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s0, 88(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a0, 84(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a1, 80(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a2, 76(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a3, 72(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a4, 68(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a5, 64(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a6, 60(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw a7, 56(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s2, 52(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s3, 48(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s4, 44(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s5, 40(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s6, 36(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s7, 32(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s8, 28(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s9, 24(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s10, 20(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw s11, 16(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw t3, 12(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw t4, 8(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw t5, 4(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    lw t6, 0(sp) # 4-byte Folded Reload
; CHECK-RV32I-ILP32E-NEXT:    addi sp, sp, 108
; CHECK-RV32I-ILP32E-NEXT:    mret
;
; CHECK-RV32E-LABEL: foo_fp_with_call:
; CHECK-RV32E:       # %bb.0:
; CHECK-RV32E-NEXT:    addi sp, sp, -44
; CHECK-RV32E-NEXT:    sw ra, 40(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw t0, 36(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw t1, 32(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw t2, 28(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw a0, 20(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw a1, 16(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw a2, 12(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw a3, 8(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw a4, 4(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    sw a5, 0(sp) # 4-byte Folded Spill
; CHECK-RV32E-NEXT:    addi s0, sp, 44
; CHECK-RV32E-NEXT:    call otherfoo
; CHECK-RV32E-NEXT:    lw ra, 40(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw t0, 36(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw t1, 32(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw t2, 28(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw a0, 20(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw a1, 16(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw a2, 12(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw a3, 8(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw a4, 4(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    lw a5, 0(sp) # 4-byte Folded Reload
; CHECK-RV32E-NEXT:    addi sp, sp, 44
; CHECK-RV32E-NEXT:    mret
;
; CHECK-RV32E-F-LABEL: foo_fp_with_call:
; CHECK-RV32E-F:       # %bb.0:
; CHECK-RV32E-F-NEXT:    addi sp, sp, -172
; CHECK-RV32E-F-NEXT:    sw ra, 168(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw t0, 164(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw t1, 160(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw t2, 156(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw s0, 152(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw a0, 148(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw a1, 144(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw a2, 140(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw a3, 136(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw a4, 132(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    sw a5, 128(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft0, 124(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft1, 120(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft2, 116(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft3, 112(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft4, 108(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft5, 104(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft6, 100(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft7, 96(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs0, 92(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs1, 88(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa0, 84(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa1, 80(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa2, 76(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa3, 72(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa4, 68(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa5, 64(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa6, 60(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fa7, 56(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs2, 52(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs3, 48(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs4, 44(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs5, 40(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs6, 36(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs7, 32(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs8, 28(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs9, 24(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs10, 20(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw fs11, 16(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft8, 12(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft9, 8(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft10, 4(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    fsw ft11, 0(sp) # 4-byte Folded Spill
; CHECK-RV32E-F-NEXT:    addi s0, sp, 172
; CHECK-RV32E-F-NEXT:    call otherfoo
; CHECK-RV32E-F-NEXT:    lw ra, 168(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw t0, 164(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw t1, 160(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw t2, 156(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw s0, 152(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw a0, 148(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw a1, 144(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw a2, 140(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw a3, 136(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw a4, 132(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    lw a5, 128(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft0, 124(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft1, 120(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft2, 116(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft3, 112(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft4, 108(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft5, 104(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft6, 100(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft7, 96(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs0, 92(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs1, 88(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa0, 84(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa1, 80(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa2, 76(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa3, 72(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa4, 68(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa5, 64(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa6, 60(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fa7, 56(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs2, 52(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs3, 48(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs4, 44(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs5, 40(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs6, 36(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs7, 32(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs8, 28(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs9, 24(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs10, 20(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw fs11, 16(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft8, 12(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft9, 8(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft10, 4(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    flw ft11, 0(sp) # 4-byte Folded Reload
; CHECK-RV32E-F-NEXT:    addi sp, sp, 172
; CHECK-RV32E-F-NEXT:    mret
;
; CHECK-RV64-LABEL: foo_fp_with_call:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    addi sp, sp, -144
; CHECK-RV64-NEXT:    sd ra, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t0, 128(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t1, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t2, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s0, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a0, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a1, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a2, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a3, 72(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a4, 64(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a5, 56(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a6, 48(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd a7, 40(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t3, 32(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t4, 24(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t5, 16(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd t6, 8(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    addi s0, sp, 144
; CHECK-RV64-NEXT:    call otherfoo
; CHECK-RV64-NEXT:    ld ra, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t0, 128(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t1, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t2, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s0, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a0, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a1, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a2, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a3, 72(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a4, 64(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a5, 56(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a6, 48(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld a7, 40(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t3, 32(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t4, 24(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t5, 16(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld t6, 8(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    addi sp, sp, 144
; CHECK-RV64-NEXT:    mret
;
; CHECK-RV64-F-LABEL: foo_fp_with_call:
; CHECK-RV64-F:       # %bb.0:
; CHECK-RV64-F-NEXT:    addi sp, sp, -224
; CHECK-RV64-F-NEXT:    sd ra, 216(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t0, 208(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t1, 200(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t2, 192(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd s0, 184(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a0, 176(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a1, 168(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a2, 160(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a3, 152(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a4, 144(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a5, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a6, 128(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd a7, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t3, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t4, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t5, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    sd t6, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft0, 84(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft1, 80(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft2, 76(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft3, 72(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft4, 68(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft5, 64(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft6, 60(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft7, 56(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa0, 52(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa1, 48(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa2, 44(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa3, 40(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa4, 36(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa5, 32(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa6, 28(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw fa7, 24(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft8, 20(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft9, 16(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft10, 12(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    fsw ft11, 8(sp) # 4-byte Folded Spill
; CHECK-RV64-F-NEXT:    addi s0, sp, 224
; CHECK-RV64-F-NEXT:    call otherfoo
; CHECK-RV64-F-NEXT:    ld ra, 216(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t0, 208(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t1, 200(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t2, 192(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld s0, 184(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a0, 176(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a1, 168(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a2, 160(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a3, 152(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a4, 144(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a5, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a6, 128(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld a7, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t3, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t4, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t5, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    ld t6, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft0, 84(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft1, 80(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft2, 76(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft3, 72(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft4, 68(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft5, 64(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft6, 60(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft7, 56(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa0, 52(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa1, 48(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa2, 44(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa3, 40(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa4, 36(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa5, 32(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa6, 28(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw fa7, 24(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft8, 20(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft9, 16(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft10, 12(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    flw ft11, 8(sp) # 4-byte Folded Reload
; CHECK-RV64-F-NEXT:    addi sp, sp, 224
; CHECK-RV64-F-NEXT:    mret
;
; CHECK-RV64-FD-LABEL: foo_fp_with_call:
; CHECK-RV64-FD:       # %bb.0:
; CHECK-RV64-FD-NEXT:    addi sp, sp, -304
; CHECK-RV64-FD-NEXT:    sd ra, 296(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t0, 288(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t1, 280(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t2, 272(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd s0, 264(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a0, 256(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a1, 248(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a2, 240(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a3, 232(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a4, 224(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a5, 216(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a6, 208(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd a7, 200(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t3, 192(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t4, 184(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t5, 176(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    sd t6, 168(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft0, 160(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft1, 152(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft2, 144(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft3, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft4, 128(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft5, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft6, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft7, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa0, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa1, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa2, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa3, 72(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa4, 64(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa5, 56(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa6, 48(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd fa7, 40(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft8, 32(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft9, 24(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft10, 16(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    fsd ft11, 8(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-NEXT:    addi s0, sp, 304
; CHECK-RV64-FD-NEXT:    call otherfoo
; CHECK-RV64-FD-NEXT:    ld ra, 296(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t0, 288(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t1, 280(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t2, 272(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld s0, 264(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a0, 256(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a1, 248(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a2, 240(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a3, 232(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a4, 224(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a5, 216(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a6, 208(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld a7, 200(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t3, 192(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t4, 184(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t5, 176(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    ld t6, 168(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft0, 160(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft1, 152(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft2, 144(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft3, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft4, 128(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft5, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft6, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft7, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa0, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa1, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa2, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa3, 72(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa4, 64(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa5, 56(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa6, 48(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld fa7, 40(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft8, 32(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft9, 24(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft10, 16(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    fld ft11, 8(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-NEXT:    addi sp, sp, 304
; CHECK-RV64-FD-NEXT:    mret
;
; CHECK-RV64-F-LP64-LABEL: foo_fp_with_call:
; CHECK-RV64-F-LP64:       # %bb.0:
; CHECK-RV64-F-LP64-NEXT:    addi sp, sp, -272
; CHECK-RV64-F-LP64-NEXT:    sd ra, 264(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd t0, 256(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd t1, 248(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd t2, 240(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd s0, 232(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a0, 224(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a1, 216(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a2, 208(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a3, 200(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a4, 192(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a5, 184(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a6, 176(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd a7, 168(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd t3, 160(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd t4, 152(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd t5, 144(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    sd t6, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft0, 132(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft1, 128(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft2, 124(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft3, 120(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft4, 116(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft5, 112(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft6, 108(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft7, 104(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs0, 100(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs1, 96(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa0, 92(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa1, 88(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa2, 84(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa3, 80(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa4, 76(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa5, 72(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa6, 68(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fa7, 64(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs2, 60(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs3, 56(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs4, 52(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs5, 48(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs6, 44(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs7, 40(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs8, 36(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs9, 32(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs10, 28(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw fs11, 24(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft8, 20(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft9, 16(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft10, 12(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    fsw ft11, 8(sp) # 4-byte Folded Spill
; CHECK-RV64-F-LP64-NEXT:    addi s0, sp, 272
; CHECK-RV64-F-LP64-NEXT:    call otherfoo
; CHECK-RV64-F-LP64-NEXT:    ld ra, 264(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld t0, 256(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld t1, 248(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld t2, 240(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld s0, 232(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a0, 224(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a1, 216(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a2, 208(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a3, 200(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a4, 192(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a5, 184(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a6, 176(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld a7, 168(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld t3, 160(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld t4, 152(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld t5, 144(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    ld t6, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft0, 132(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft1, 128(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft2, 124(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft3, 120(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft4, 116(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft5, 112(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft6, 108(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft7, 104(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs0, 100(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs1, 96(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa0, 92(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa1, 88(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa2, 84(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa3, 80(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa4, 76(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa5, 72(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa6, 68(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fa7, 64(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs2, 60(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs3, 56(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs4, 52(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs5, 48(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs6, 44(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs7, 40(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs8, 36(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs9, 32(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs10, 28(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw fs11, 24(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft8, 20(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft9, 16(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft10, 12(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    flw ft11, 8(sp) # 4-byte Folded Reload
; CHECK-RV64-F-LP64-NEXT:    addi sp, sp, 272
; CHECK-RV64-F-LP64-NEXT:    mret
;
; CHECK-RV64-FD-LP64F-LABEL: foo_fp_with_call:
; CHECK-RV64-FD-LP64F:       # %bb.0:
; CHECK-RV64-FD-LP64F-NEXT:    addi sp, sp, -400
; CHECK-RV64-FD-LP64F-NEXT:    sd ra, 392(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd t0, 384(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd t1, 376(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd t2, 368(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd s0, 360(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a0, 352(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a1, 344(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a2, 336(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a3, 328(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a4, 320(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a5, 312(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a6, 304(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd a7, 296(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd t3, 288(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd t4, 280(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd t5, 272(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    sd t6, 264(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft0, 256(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft1, 248(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft2, 240(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft3, 232(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft4, 224(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft5, 216(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft6, 208(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft7, 200(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs0, 192(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs1, 184(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa0, 176(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa1, 168(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa2, 160(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa3, 152(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa4, 144(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa5, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa6, 128(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fa7, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs2, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs3, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs4, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs5, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs6, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs7, 72(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs8, 64(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs9, 56(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs10, 48(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd fs11, 40(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft8, 32(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft9, 24(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft10, 16(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    fsd ft11, 8(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64F-NEXT:    addi s0, sp, 400
; CHECK-RV64-FD-LP64F-NEXT:    call otherfoo
; CHECK-RV64-FD-LP64F-NEXT:    ld ra, 392(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld t0, 384(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld t1, 376(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld t2, 368(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld s0, 360(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a0, 352(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a1, 344(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a2, 336(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a3, 328(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a4, 320(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a5, 312(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a6, 304(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld a7, 296(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld t3, 288(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld t4, 280(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld t5, 272(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    ld t6, 264(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft0, 256(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft1, 248(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft2, 240(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft3, 232(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft4, 224(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft5, 216(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft6, 208(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft7, 200(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs0, 192(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs1, 184(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa0, 176(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa1, 168(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa2, 160(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa3, 152(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa4, 144(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa5, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa6, 128(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fa7, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs2, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs3, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs4, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs5, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs6, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs7, 72(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs8, 64(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs9, 56(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs10, 48(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld fs11, 40(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft8, 32(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft9, 24(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft10, 16(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    fld ft11, 8(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64F-NEXT:    addi sp, sp, 400
; CHECK-RV64-FD-LP64F-NEXT:    mret
;
; CHECK-RV64-FD-LP64-LABEL: foo_fp_with_call:
; CHECK-RV64-FD-LP64:       # %bb.0:
; CHECK-RV64-FD-LP64-NEXT:    addi sp, sp, -400
; CHECK-RV64-FD-LP64-NEXT:    sd ra, 392(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd t0, 384(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd t1, 376(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd t2, 368(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd s0, 360(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a0, 352(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a1, 344(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a2, 336(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a3, 328(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a4, 320(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a5, 312(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a6, 304(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd a7, 296(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd t3, 288(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd t4, 280(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd t5, 272(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    sd t6, 264(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft0, 256(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft1, 248(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft2, 240(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft3, 232(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft4, 224(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft5, 216(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft6, 208(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft7, 200(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs0, 192(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs1, 184(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa0, 176(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa1, 168(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa2, 160(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa3, 152(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa4, 144(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa5, 136(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa6, 128(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fa7, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs2, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs3, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs4, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs5, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs6, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs7, 72(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs8, 64(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs9, 56(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs10, 48(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd fs11, 40(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft8, 32(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft9, 24(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft10, 16(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    fsd ft11, 8(sp) # 8-byte Folded Spill
; CHECK-RV64-FD-LP64-NEXT:    addi s0, sp, 400
; CHECK-RV64-FD-LP64-NEXT:    call otherfoo
; CHECK-RV64-FD-LP64-NEXT:    ld ra, 392(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld t0, 384(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld t1, 376(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld t2, 368(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld s0, 360(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a0, 352(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a1, 344(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a2, 336(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a3, 328(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a4, 320(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a5, 312(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a6, 304(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld a7, 296(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld t3, 288(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld t4, 280(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld t5, 272(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    ld t6, 264(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft0, 256(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft1, 248(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft2, 240(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft3, 232(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft4, 224(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft5, 216(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft6, 208(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft7, 200(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs0, 192(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs1, 184(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa0, 176(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa1, 168(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa2, 160(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa3, 152(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa4, 144(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa5, 136(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa6, 128(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fa7, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs2, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs3, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs4, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs5, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs6, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs7, 72(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs8, 64(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs9, 56(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs10, 48(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld fs11, 40(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft8, 32(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft9, 24(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft10, 16(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    fld ft11, 8(sp) # 8-byte Folded Reload
; CHECK-RV64-FD-LP64-NEXT:    addi sp, sp, 400
; CHECK-RV64-FD-LP64-NEXT:    mret
;
; CHECK-RV64I-LP64E-LABEL: foo_fp_with_call:
; CHECK-RV64I-LP64E:       # %bb.0:
; CHECK-RV64I-LP64E-NEXT:    addi sp, sp, -216
; CHECK-RV64I-LP64E-NEXT:    sd ra, 208(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd t0, 200(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd t1, 192(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd t2, 184(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s0, 176(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a0, 168(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a1, 160(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a2, 152(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a3, 144(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a4, 136(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a5, 128(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a6, 120(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd a7, 112(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s2, 104(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s3, 96(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s4, 88(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s5, 80(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s6, 72(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s7, 64(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s8, 56(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s9, 48(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s10, 40(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd s11, 32(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd t3, 24(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd t4, 16(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd t5, 8(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    sd t6, 0(sp) # 8-byte Folded Spill
; CHECK-RV64I-LP64E-NEXT:    addi s0, sp, 216
; CHECK-RV64I-LP64E-NEXT:    call otherfoo
; CHECK-RV64I-LP64E-NEXT:    ld ra, 208(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld t0, 200(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld t1, 192(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld t2, 184(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s0, 176(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a0, 168(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a1, 160(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a2, 152(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a3, 144(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a4, 136(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a5, 128(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a6, 120(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld a7, 112(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s2, 104(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s3, 96(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s4, 88(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s5, 80(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s6, 72(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s7, 64(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s8, 56(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s9, 48(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s10, 40(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld s11, 32(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld t3, 24(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld t4, 16(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld t5, 8(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    ld t6, 0(sp) # 8-byte Folded Reload
; CHECK-RV64I-LP64E-NEXT:    addi sp, sp, 216
; CHECK-RV64I-LP64E-NEXT:    mret
;
; CHECK-RV64E-LABEL: foo_fp_with_call:
; CHECK-RV64E:       # %bb.0:
; CHECK-RV64E-NEXT:    addi sp, sp, -88
; CHECK-RV64E-NEXT:    sd ra, 80(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd t0, 72(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd t1, 64(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd t2, 56(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd a0, 40(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd a1, 32(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd a2, 24(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd a3, 16(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd a4, 8(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    sd a5, 0(sp) # 8-byte Folded Spill
; CHECK-RV64E-NEXT:    addi s0, sp, 88
; CHECK-RV64E-NEXT:    call otherfoo
; CHECK-RV64E-NEXT:    ld ra, 80(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld t0, 72(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld t1, 64(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld t2, 56(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld a0, 40(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld a1, 32(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld a2, 24(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld a3, 16(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld a4, 8(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    ld a5, 0(sp) # 8-byte Folded Reload
; CHECK-RV64E-NEXT:    addi sp, sp, 88
; CHECK-RV64E-NEXT:    mret
;
; CHECK-RV64E-F-LABEL: foo_fp_with_call:
; CHECK-RV64E-F:       # %bb.0:
; CHECK-RV64E-F-NEXT:    addi sp, sp, -216
; CHECK-RV64E-F-NEXT:    sd ra, 208(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd t0, 200(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd t1, 192(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd t2, 184(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd s0, 176(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd a0, 168(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd a1, 160(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd a2, 152(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd a3, 144(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd a4, 136(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    sd a5, 128(sp) # 8-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft0, 124(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft1, 120(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft2, 116(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft3, 112(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft4, 108(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft5, 104(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft6, 100(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft7, 96(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs0, 92(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs1, 88(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa0, 84(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa1, 80(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa2, 76(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa3, 72(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa4, 68(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa5, 64(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa6, 60(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fa7, 56(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs2, 52(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs3, 48(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs4, 44(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs5, 40(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs6, 36(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs7, 32(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs8, 28(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs9, 24(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs10, 20(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw fs11, 16(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft8, 12(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft9, 8(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft10, 4(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    fsw ft11, 0(sp) # 4-byte Folded Spill
; CHECK-RV64E-F-NEXT:    addi s0, sp, 216
; CHECK-RV64E-F-NEXT:    call otherfoo
; CHECK-RV64E-F-NEXT:    ld ra, 208(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld t0, 200(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld t1, 192(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld t2, 184(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld s0, 176(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld a0, 168(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld a1, 160(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld a2, 152(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld a3, 144(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld a4, 136(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    ld a5, 128(sp) # 8-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft0, 124(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft1, 120(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft2, 116(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft3, 112(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft4, 108(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft5, 104(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft6, 100(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft7, 96(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs0, 92(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs1, 88(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa0, 84(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa1, 80(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa2, 76(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa3, 72(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa4, 68(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa5, 64(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa6, 60(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fa7, 56(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs2, 52(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs3, 48(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs4, 44(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs5, 40(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs6, 36(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs7, 32(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs8, 28(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs9, 24(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs10, 20(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw fs11, 16(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft8, 12(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft9, 8(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft10, 4(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    flw ft11, 0(sp) # 4-byte Folded Reload
; CHECK-RV64E-F-NEXT:    addi sp, sp, 216
; CHECK-RV64E-F-NEXT:    mret
;
; CHECK-RV64E-FD-LABEL: foo_fp_with_call:
; CHECK-RV64E-FD:       # %bb.0:
; CHECK-RV64E-FD-NEXT:    addi sp, sp, -472
; CHECK-RV64E-FD-NEXT:    sd ra, 464(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd t0, 456(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd t1, 448(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd t2, 440(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s0, 432(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a0, 424(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a1, 416(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a2, 408(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a3, 400(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a4, 392(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a5, 384(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a6, 376(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd a7, 368(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s2, 360(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s3, 352(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s4, 344(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s5, 336(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s6, 328(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s7, 320(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s8, 312(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s9, 304(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s10, 296(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd s11, 288(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd t3, 280(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd t4, 272(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd t5, 264(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    sd t6, 256(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft0, 248(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft1, 240(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft2, 232(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft3, 224(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft4, 216(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft5, 208(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft6, 200(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft7, 192(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs0, 184(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs1, 176(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa0, 168(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa1, 160(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa2, 152(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa3, 144(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa4, 136(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa5, 128(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa6, 120(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fa7, 112(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs2, 104(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs3, 96(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs4, 88(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs5, 80(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs6, 72(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs7, 64(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs8, 56(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs9, 48(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs10, 40(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd fs11, 32(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft8, 24(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft9, 16(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft10, 8(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    fsd ft11, 0(sp) # 8-byte Folded Spill
; CHECK-RV64E-FD-NEXT:    addi s0, sp, 472
; CHECK-RV64E-FD-NEXT:    call otherfoo
; CHECK-RV64E-FD-NEXT:    ld ra, 464(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld t0, 456(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld t1, 448(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld t2, 440(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s0, 432(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a0, 424(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a1, 416(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a2, 408(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a3, 400(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a4, 392(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a5, 384(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a6, 376(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld a7, 368(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s2, 360(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s3, 352(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s4, 344(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s5, 336(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s6, 328(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s7, 320(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s8, 312(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s9, 304(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s10, 296(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld s11, 288(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld t3, 280(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld t4, 272(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld t5, 264(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    ld t6, 256(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft0, 248(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft1, 240(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft2, 232(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft3, 224(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft4, 216(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft5, 208(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft6, 200(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft7, 192(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs0, 184(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs1, 176(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa0, 168(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa1, 160(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa2, 152(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa3, 144(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa4, 136(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa5, 128(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa6, 120(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fa7, 112(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs2, 104(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs3, 96(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs4, 88(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs5, 80(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs6, 72(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs7, 64(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs8, 56(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs9, 48(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs10, 40(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld fs11, 32(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft8, 24(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft9, 16(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft10, 8(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    fld ft11, 0(sp) # 8-byte Folded Reload
; CHECK-RV64E-FD-NEXT:    addi sp, sp, 472
; CHECK-RV64E-FD-NEXT:    mret
  %call = call i32 @otherfoo()
  ret void
}

attributes #0 = { nounwind "interrupt"="supervisor" }
attributes #1 = { nounwind "interrupt"="machine" }
attributes #2 = { nounwind "interrupt"="machine" "frame-pointer"="all" }
