; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 3
; RUN: opt -p constraint-elimination -S %s | FileCheck %s

declare void @use(i1)
declare void @llvm.assume(i1)

define void @add_rec_decreasing_cond_true_constant(i8 noundef %len) {
; CHECK-LABEL: define void @add_rec_decreasing_cond_true_constant(
; CHECK-SAME: i8 noundef [[LEN:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[K_0:%.*]] = phi i8 [ 4, [[ENTRY:%.*]] ], [ [[K_DEC:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[CMP2_NOT:%.*]] = icmp eq i8 [[K_0]], 0
; CHECK-NEXT:    br i1 [[CMP2_NOT]], label [[EXIT:%.*]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[K_DEC]] = add i8 [[K_0]], -1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %k.0 = phi i8 [ 4, %entry], [ %k.dec, %loop.latch ]
  %cmp2.not = icmp eq i8 %k.0, 0
  br i1 %cmp2.not, label %exit, label %loop.latch

loop.latch:
  %cmp.not.i = icmp ult i8 %k.0, 5
  call void @use(i1 %cmp.not.i)
  %k.dec = add i8 %k.0, -1
  br label %loop.header

exit:
  ret void
}

define void @add_rec_decreasing_cond_not_true_constant(i8 noundef %len) {
; CHECK-LABEL: define void @add_rec_decreasing_cond_not_true_constant(
; CHECK-SAME: i8 noundef [[LEN:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[K_0:%.*]] = phi i8 [ 4, [[ENTRY:%.*]] ], [ [[K_DEC:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[CMP2_NOT:%.*]] = icmp eq i8 [[K_0]], 0
; CHECK-NEXT:    br i1 [[CMP2_NOT]], label [[EXIT:%.*]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[CMP_NOT_I:%.*]] = icmp ult i8 [[K_0]], 4
; CHECK-NEXT:    call void @use(i1 [[CMP_NOT_I]])
; CHECK-NEXT:    [[K_DEC]] = add i8 [[K_0]], -1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %k.0 = phi i8 [ 4, %entry], [ %k.dec, %loop.latch ]
  %cmp2.not = icmp eq i8 %k.0, 0
  br i1 %cmp2.not, label %exit, label %loop.latch

loop.latch:
  %cmp.not.i = icmp ult i8 %k.0, 4
  call void @use(i1 %cmp.not.i)
  %k.dec = add i8 %k.0, -1
  br label %loop.header

exit:
  ret void
}

define void @add_rec_decreasing_cond_true_start_signed_positive(i8 noundef %start) {
; CHECK-LABEL: define void @add_rec_decreasing_cond_true_start_signed_positive(
; CHECK-SAME: i8 noundef [[START:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PRECOND:%.*]] = icmp sge i8 [[START]], 1
; CHECK-NEXT:    call void @llvm.assume(i1 [[PRECOND]])
; CHECK-NEXT:    [[START_1:%.*]] = add i8 [[START]], -1
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[K_0:%.*]] = phi i8 [ [[START_1]], [[ENTRY:%.*]] ], [ [[K_DEC:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[CMP2_NOT:%.*]] = icmp eq i8 [[K_0]], 0
; CHECK-NEXT:    br i1 [[CMP2_NOT]], label [[EXIT:%.*]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[K_DEC]] = add i8 [[K_0]], -1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %precond = icmp sge i8 %start, 1
  call void @llvm.assume(i1 %precond)
  %start.1 = add i8 %start, -1
  br label %loop.header

loop.header:
  %k.0 = phi i8 [ %start.1, %entry], [ %k.dec, %loop.latch ]
  %cmp2.not = icmp eq i8 %k.0, 0
  br i1 %cmp2.not, label %exit, label %loop.latch

loop.latch:
  %cmp.not.i = icmp ult i8 %k.0, %start
  call void @use(i1 %cmp.not.i)
  %k.dec = add i8 %k.0, -1
  br label %loop.header

exit:
  ret void
}

define void @add_rec_decreasing_cond_not_true_start_signed_positive(i8 noundef %start) {
; CHECK-LABEL: define void @add_rec_decreasing_cond_not_true_start_signed_positive(
; CHECK-SAME: i8 noundef [[START:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PRECOND:%.*]] = icmp sge i8 [[START]], 1
; CHECK-NEXT:    call void @llvm.assume(i1 [[PRECOND]])
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[K_0:%.*]] = phi i8 [ [[START]], [[ENTRY:%.*]] ], [ [[K_DEC:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[CMP2_NOT:%.*]] = icmp eq i8 [[K_0]], 0
; CHECK-NEXT:    br i1 [[CMP2_NOT]], label [[EXIT:%.*]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[CMP_NOT_I:%.*]] = icmp ult i8 [[K_0]], [[START]]
; CHECK-NEXT:    call void @use(i1 [[CMP_NOT_I]])
; CHECK-NEXT:    [[K_DEC]] = add i8 [[K_0]], -1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %precond = icmp sge i8 %start, 1
  call void @llvm.assume(i1 %precond)
  br label %loop.header

loop.header:
  %k.0 = phi i8 [ %start, %entry], [ %k.dec, %loop.latch ]
  %cmp2.not = icmp eq i8 %k.0, 0
  br i1 %cmp2.not, label %exit, label %loop.latch

loop.latch:
  %cmp.not.i = icmp ult i8 %k.0, %start
  call void @use(i1 %cmp.not.i)
  %k.dec = add i8 %k.0, -1
  br label %loop.header

exit:
  ret void
}

define void @add_rec_decreasing_add_rec_positive_to_negative(i8 noundef %len) {
; CHECK-LABEL: define void @add_rec_decreasing_add_rec_positive_to_negative(
; CHECK-SAME: i8 noundef [[LEN:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[K_0:%.*]] = phi i8 [ 4, [[ENTRY:%.*]] ], [ [[K_DEC:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[CMP2_NOT:%.*]] = icmp eq i8 [[K_0]], -2
; CHECK-NEXT:    br i1 [[CMP2_NOT]], label [[EXIT:%.*]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[CMP_NOT_I:%.*]] = icmp ult i8 [[K_0]], 5
; CHECK-NEXT:    call void @use(i1 [[CMP_NOT_I]])
; CHECK-NEXT:    [[K_DEC]] = add i8 [[K_0]], -1
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %k.0 = phi i8 [ 4, %entry], [ %k.dec, %loop.latch ]
  %cmp2.not = icmp eq i8 %k.0, -2
  br i1 %cmp2.not, label %exit, label %loop.latch

loop.latch:
  %cmp.not.i = icmp ult i8 %k.0, 5
  call void @use(i1 %cmp.not.i)
  %k.dec = add i8 %k.0, -1
  br label %loop.header

exit:
  ret void
}

define void @add_rec_decreasing_2_cond_true_constant(i8 noundef %len) {
; CHECK-LABEL: define void @add_rec_decreasing_2_cond_true_constant(
; CHECK-SAME: i8 noundef [[LEN:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[K_0:%.*]] = phi i8 [ 4, [[ENTRY:%.*]] ], [ [[K_DEC:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[CMP2_NOT:%.*]] = icmp eq i8 [[K_0]], 0
; CHECK-NEXT:    br i1 [[CMP2_NOT]], label [[EXIT:%.*]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[CMP_NOT_I:%.*]] = icmp ult i8 [[K_0]], 5
; CHECK-NEXT:    call void @use(i1 [[CMP_NOT_I]])
; CHECK-NEXT:    [[K_DEC]] = add i8 [[K_0]], -2
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %k.0 = phi i8 [ 4, %entry], [ %k.dec, %loop.latch ]
  %cmp2.not = icmp eq i8 %k.0, 0
  br i1 %cmp2.not, label %exit, label %loop.latch

loop.latch:
  %cmp.not.i = icmp ult i8 %k.0, 5
  call void @use(i1 %cmp.not.i)
  %k.dec = add i8 %k.0, -2
  br label %loop.header

exit:
  ret void
}

define void @add_rec_decreasing_2_cond_not_true_constant(i8 noundef %len) {
; CHECK-LABEL: define void @add_rec_decreasing_2_cond_not_true_constant(
; CHECK-SAME: i8 noundef [[LEN:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP_HEADER:%.*]]
; CHECK:       loop.header:
; CHECK-NEXT:    [[K_0:%.*]] = phi i8 [ 5, [[ENTRY:%.*]] ], [ [[K_DEC:%.*]], [[LOOP_LATCH:%.*]] ]
; CHECK-NEXT:    [[CMP2_NOT:%.*]] = icmp eq i8 [[K_0]], 0
; CHECK-NEXT:    br i1 [[CMP2_NOT]], label [[EXIT:%.*]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[CMP_NOT_I:%.*]] = icmp ult i8 [[K_0]], 5
; CHECK-NEXT:    call void @use(i1 [[CMP_NOT_I]])
; CHECK-NEXT:    [[K_DEC]] = add i8 [[K_0]], -2
; CHECK-NEXT:    br label [[LOOP_HEADER]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %k.0 = phi i8 [ 5, %entry], [ %k.dec, %loop.latch ]
  %cmp2.not = icmp eq i8 %k.0, 0
  br i1 %cmp2.not, label %exit, label %loop.latch

loop.latch:
  %cmp.not.i = icmp ult i8 %k.0, 5
  call void @use(i1 %cmp.not.i)
  %k.dec = add i8 %k.0, -2
  br label %loop.header

exit:
  ret void
}
