//===- MCTargetOptions.h - MC Target Options -------------------*- C++ -*-===//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_MC_MCTARGETOPTIONS_H
#define LLVM_MC_MCTARGETOPTIONS_H

namespace llvm {

class MCTargetOptions {
public:
  enum AsmInstrumentation {
    AsmInstrumentationNone,
    AsmInstrumentationAddress
  };

  /// Enables AddressSanitizer instrumentation at machine level.
  bool SanitizeAddress : 1;

  bool MCRelaxAll : 1;
  bool MCNoExecStack : 1;
  bool MCSaveTempLabels : 1;
  bool MCUseDwarfDirectory : 1;
  bool ShowMCEncoding : 1;
  bool ShowMCInst : 1;
  bool AsmVerbose : 1;
  int DwarfVersion;
  MCTargetOptions();
};

inline bool operator==(const MCTargetOptions &LHS, const MCTargetOptions &RHS) {
#define ARE_EQUAL(X) LHS.X == RHS.X
  return (ARE_EQUAL(SanitizeAddress) &&
          ARE_EQUAL(MCRelaxAll) &&
          ARE_EQUAL(MCNoExecStack) &&
          ARE_EQUAL(MCSaveTempLabels) &&
          ARE_EQUAL(MCUseDwarfDirectory) &&
          ARE_EQUAL(ShowMCEncoding) &&
          ARE_EQUAL(ShowMCInst) &&
          ARE_EQUAL(AsmVerbose) &&
	  ARE_EQUAL(DwarfVersion));
#undef ARE_EQUAL
}

inline bool operator!=(const MCTargetOptions &LHS, const MCTargetOptions &RHS) {
  return !(LHS == RHS);
}

} // end namespace llvm

#endif
