/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDocumentType.h"

#include "DocumentType.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSNamedNodeMap.h"
#include "KURL.h"
#include "NamedNodeMap.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDocumentTypeTableValues[] =
{
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTypeName), (intptr_t)0, NoIntrinsic },
    { "entities", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTypeEntities), (intptr_t)0, NoIntrinsic },
    { "notations", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTypeNotations), (intptr_t)0, NoIntrinsic },
    { "publicId", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTypePublicId), (intptr_t)0, NoIntrinsic },
    { "systemId", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTypeSystemId), (intptr_t)0, NoIntrinsic },
    { "internalSubset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTypeInternalSubset), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTypeConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDocumentTypeTable = { 18, 15, JSDocumentTypeTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSDocumentTypeConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDocumentTypeConstructorTable = { 1, 0, JSDocumentTypeConstructorTableValues, 0 };
const ClassInfo JSDocumentTypeConstructor::s_info = { "DocumentTypeConstructor", &Base::s_info, &JSDocumentTypeConstructorTable, 0, CREATE_METHOD_TABLE(JSDocumentTypeConstructor) };

JSDocumentTypeConstructor::JSDocumentTypeConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDocumentTypeConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSDocumentTypePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSDocumentTypeConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocumentTypeConstructor, JSDOMWrapper>(exec, &JSDocumentTypeConstructorTable, jsCast<JSDocumentTypeConstructor*>(cell), propertyName, slot);
}

bool JSDocumentTypeConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDocumentTypeConstructor, JSDOMWrapper>(exec, &JSDocumentTypeConstructorTable, jsCast<JSDocumentTypeConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDocumentTypePrototypeTableValues[] =
{
    { "remove", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentTypePrototypeFunctionRemove), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDocumentTypePrototypeTable = { 2, 1, JSDocumentTypePrototypeTableValues, 0 };
const ClassInfo JSDocumentTypePrototype::s_info = { "DocumentTypePrototype", &Base::s_info, &JSDocumentTypePrototypeTable, 0, CREATE_METHOD_TABLE(JSDocumentTypePrototype) };

JSObject* JSDocumentTypePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDocumentType>(exec, globalObject);
}

bool JSDocumentTypePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDocumentTypePrototype* thisObject = jsCast<JSDocumentTypePrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSDocumentTypePrototypeTable, thisObject, propertyName, slot);
}

bool JSDocumentTypePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDocumentTypePrototype* thisObject = jsCast<JSDocumentTypePrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDocumentTypePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSDocumentType::s_info = { "DocumentType", &Base::s_info, &JSDocumentTypeTable, 0 , CREATE_METHOD_TABLE(JSDocumentType) };

JSDocumentType::JSDocumentType(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DocumentType> impl)
    : JSNode(structure, globalObject, impl)
{
}

void JSDocumentType::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSDocumentType::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDocumentTypePrototype::create(exec->vm(), globalObject, JSDocumentTypePrototype::createStructure(exec->vm(), globalObject, JSNodePrototype::self(exec, globalObject)));
}

bool JSDocumentType::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDocumentType* thisObject = jsCast<JSDocumentType*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDocumentType, Base>(exec, &JSDocumentTypeTable, thisObject, propertyName, slot);
}

bool JSDocumentType::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDocumentType* thisObject = jsCast<JSDocumentType*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDocumentType, Base>(exec, &JSDocumentTypeTable, thisObject, propertyName, descriptor);
}

JSValue jsDocumentTypeName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocumentType* castedThis = jsCast<JSDocumentType*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DocumentType* impl = static_cast<DocumentType*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsDocumentTypeEntities(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocumentType* castedThis = jsCast<JSDocumentType*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DocumentType* impl = static_cast<DocumentType*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->entities()));
    return result;
}


JSValue jsDocumentTypeNotations(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocumentType* castedThis = jsCast<JSDocumentType*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DocumentType* impl = static_cast<DocumentType*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->notations()));
    return result;
}


JSValue jsDocumentTypePublicId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocumentType* castedThis = jsCast<JSDocumentType*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DocumentType* impl = static_cast<DocumentType*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->publicId());
    return result;
}


JSValue jsDocumentTypeSystemId(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocumentType* castedThis = jsCast<JSDocumentType*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DocumentType* impl = static_cast<DocumentType*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->systemId());
    return result;
}


JSValue jsDocumentTypeInternalSubset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocumentType* castedThis = jsCast<JSDocumentType*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    DocumentType* impl = static_cast<DocumentType*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->internalSubset());
    return result;
}


JSValue jsDocumentTypeConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocumentType* domObject = jsCast<JSDocumentType*>(asObject(slotBase));
    return JSDocumentType::getConstructor(exec, domObject->globalObject());
}

JSValue JSDocumentType::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDocumentTypeConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDocumentTypePrototypeFunctionRemove(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocumentType::s_info))
        return throwVMTypeError(exec);
    JSDocumentType* castedThis = jsCast<JSDocumentType*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocumentType::s_info);
    DocumentType* impl = static_cast<DocumentType*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->remove(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

DocumentType* toDocumentType(JSC::JSValue value)
{
    return value.inherits(&JSDocumentType::s_info) ? jsCast<JSDocumentType*>(asObject(value))->impl() : 0;
}

}
